<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for publisher related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Suganthi
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions   

class Publisher extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->library('redis_library');
		$this->load->model('do_publisher');
		$this->load->model('do_advertiser');
		$this->load->model('do_site');
		$this->load->model('do_invoices');
		$this->load->model('do_networks');
		$this->load->model('do_email_check');
		$this->load->helper('email');
		$this->load->model('do_app_config');
		$this->load->library('user_authentication');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		$this->load->model('do_message');
		$this->load->library('notification');
        $this->load->model('do_admarket'); 
		$this->load->library('csvreader');
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}
	
		
	/**
       * 
       * name : fetch_get()
       * 
       * Fetches all publisher information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_get()
	{	
		#$network_account_id	=	$this->get('network_account_id');
		#$network_id			=	$this->get('network_id');
		#$account_id			=	$this->get('account_id');
		
		$network_account_id	=	$this->user_authentication->network_account_id;
		$network_id			=	$this->user_authentication->account_id;
		$account_id			=	$this->get('account_id'); 
		
			  
		if($account_id)
		{
			if($network_account_id)
			{
				$publisher = 	$this->do_publisher->fetch($network_id,$network_account_id,$account_id);
			}
			else
			{
				$publisher = 	$this->do_publisher->fetch($network_id,'',$account_id);
			}
		}
		else
		{
			if($network_account_id)
			{
				$publisher = 	$this->do_publisher->fetch($network_id,$network_account_id);
			}
			else
			{
				$publisher = 	$this->do_publisher->fetch($network_id);
			}
		}
		
		if($publisher)
		{
			
			$this->response($publisher,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}	
	
	
	/**
       * 
       * name : mass_email_fetch_get()
       * 
       * Fetches all publisher information as per cache time.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function mass_email_fetch_get()
	{	
		#$network_account_id	=	$this->get('network_account_id');
		#$network_id			=	$this->get('network_id');
		#$account_id			=	$this->get('account_id');
		
		$network_account_id	=	$this->user_authentication->network_account_id;
		if($this->get('netid'))
		{
			$network_id = $this->get('netid');
		}
		else
		{
			$network_id			=	$this->user_authentication->account_id;
		}
		$account_id			=	$this->get('account_id'); 
		
			  
		if($account_id)
		{
			if($network_account_id)
			{
				$publisher = 	$this->do_publisher->mass_email_fetch($network_id,$network_account_id,$account_id);
			}
			else
			{
				$publisher = 	$this->do_publisher->mass_email_fetch($network_id,'',$account_id);
			}
		}
		else
		{
			if($network_account_id)
			{
				$publisher = 	$this->do_publisher->mass_email_fetch($network_id,$network_account_id);
			}
			else
			{
				$publisher = 	$this->do_publisher->mass_email_fetch($network_id);
			}
		}
		
		if($publisher)
		{
			
			$this->response($publisher,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}	
	
	
	/**
       * 
       * name : site_count_get()
       * 
       * Fetches all site count.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function site_count_get()
	{	
		#$network_account_id	=	$this->get('network_account_id');
		#$network_id			=	$this->get('network_id');
		#$account_id			=	$this->get('account_id');
		
		$network_account_id	=	$this->user_authentication->network_account_id;
		$network_id			=	$this->user_authentication->account_id;
		$account_id			=	$this->get('account_id');
		
		if($account_id)
		{
			if($network_account_id)
			{
				$count = 	$this->do_publisher->site_count($network_id,$network_account_id,$account_id);
			}
			else
			{
				$count = 	$this->do_publisher->site_count($network_id,'',$account_id);
			}
		}
		else
		{
			if($network_account_id)
			{   
				$count = 	$this->do_publisher->site_count($network_id,$network_account_id);
			}
			else
			{
				$count = 	$this->do_publisher->site_count($network_id);
			}
		}
		
		if($count)
		{		
			$this->response($count,200);
		}
		else
		{
			$this->response('0', 200);
		}
	}
	
	/**
       * 
       * name : ad_block_count_get()
       * 
       * Fetches all ad block count.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function ad_block_count_get()
	{	
		#$network_id		=	$this->get('network_id');
		#$affiliate_id		=	$this->get('affiliate_id');
		
		$network_account_id	=	$this->user_authentication->network_account_id;
		$network_id			=	$this->user_authentication->network_id;
		$affiliate_id	    =	$this->user_authentication->affiliate_id;
		$agency_id			=	$this->user_authentication->agency_id;
		$account_id		    =	$this->get('account_id');
		
		if($account_id)
		{
			if($affiliate_id)
			{
				$count = 	$this->do_publisher->ad_block_count($network_id,$account_id,$affiliate_id);
			}
			else
			{
				$count = 	$this->do_publisher->ad_block_count($network_id,$account_id);
			}
		}
		else
		{
			$count = 	$this->do_publisher->ad_block_count($network_id,'','','',$agency_id);
		}
		
		if($count)
		{		
			$this->response($count,200);
		}
		else
		{
			$this->response('0', 200);
		}
	}
	
	//api/v1/publisher/add
	function add_post()
	{	
		$this->form_validation->set_rules('first_name','First Name', 'required|trim|first_alpha_check|alpha_numeric_dash_space');
		$this->form_validation->set_rules('last_name', 'Last Name','required|trim|first_alpha_check|alpha_numeric_dash_space');
		$this->form_validation->set_rules('email_id', 'Email Address', 'required|trim|is_email|callback_email_check');
		$this->form_validation->set_rules('website', 'Website', 'required|trim|is_unique[rv_affiliates.website]');
		$this->form_validation->set_rules('password', 'Password','required|trim');
		$this->form_validation->set_rules('confirm_password', 'Confirm Password','required|trim|matches[password]');

		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			#$network_id		=	get_session('network_account_id');
			#$account_id		=	get_session('account_id');
			
			$user_auth  	= 	$this->user_authentication;
			$network_id		=	$user_auth->network_account_id;
			$account_id		=	$user_auth->account_id;
			
			if(clean_data($this->post('floor_price_enable'))=='on')
			{
				$fenable	=	1;
			}
			else
			{
				$fenable	=	0;
			}
			
			$website=$this->post('website');
			if (!preg_match("~^(?:f|ht)tps?://~i", $website)) 
			{
			   $website = "http://" . $website;
			}
			$add_data		=	array(
									'first_name'		=>	clean_data($this->post('first_name')),
									'last_name'			=>	clean_data($this->post('last_name')),
									'email'				=>	clean_data($this->post('email_id')),
									'password'			=>	clean_data($this->post('password')),
									//'budget'			=>	$this->post('budget'),
									//'mob_no'			=>	$this->post('mob_no'),
									'skype_id'			=>	clean_data($this->post('skype_id')),
									//'additional_info'			=>	$this->post('additional_info'),
									'floor_price_enable'=>	$fenable,
									'site_url'			=>	clean_data($website),
									'account_type'		=>	'TRAFFICKER',
									'created_date'		=>	date('Y-m-d H:i:s'),
									'security_id' => clean_data($this->post('security_question_id')),
									'security_answer'=>clean_data($this->post('security_answer')) ,
									'referral_share'=>clean_data($this->post('referral_share')),
									'active_referrals'=>clean_data($this->post('active_referrals'))
									);
		
			if($network_id)
			{						
				$publisher_add = 	$this->do_publisher->add($add_data,$account_id,$network_id);
			}
			else
			{
				$publisher_add = 	$this->do_publisher->add($add_data,$account_id);
			}
			
							
							
				/* Activity Log for Publisher Add- Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,PUBLISHER_ADD);
				if($enable=='1')
				{					
				$this->activity_log(PUBLISHER,ADD,$publisher_add['pub_id']);
				}
				/* Activity Log for Publisher Add- End*/		
			
			
			if($publisher_add != FALSE)
			{	
				// SEND  LOGIN DETAILS TO USER
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->do_networks->agency_owner_details($agency_id);
				if($agency_id == 1)
				{
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$account_type  = $publisher_add['account_type'];
					$account_id    = $publisher_add['account_id'];
					$account_type  = $add_data['account_type'];
					$user_email    = $add_data['email'];
					$password      = $add_data['password'];
					$user_name     = $add_data['first_name']." ".$add_data['last_name'];
					$type          = 'PUB_LOGIN_CREDENTIAL';		
					$from 	       =  $admin_email;
					$to  	       =  $user_email;			
					$mail_content=array(
						"subject" 		=> "Login Credentials",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						"password"		=> $password								
						);			
						send_mail($type,$from,$to,$mail_content);
				
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Publisher has been added successfully!..'
									);
					$this->response( $success, 200);
				}
				else
				{
					// IF NOT NETWORK ADMIN ADMIN SEND BCC
					$network_admin=$this->do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$account_type  = $publisher_add['account_type'];
					$account_id    = $publisher_add['account_id'];
					$account_type  = $add_data['account_type'];
					$user_email    = $add_data['email'];
					$password      = $add_data['password'];
					$user_name     = $add_data['first_name']." ".$add_data['last_name'];
					$type          = 'PUB_LOGIN_CREDENTIAL';		
					$from 	       =  $admin_email;
					$to  	       =  $user_email;			
					$mail_content=array(
						"subject" 		=> "Login Credentials",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						"password"		=> $password								
						);			
					$attachement = "";	
					send_mail($type,$from,$to,$mail_content,$attachement.$bcc);
				
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Publisher has been added successfully!..'
									);
					$this->response( $success, 200);
				}
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
								);
				$this->response( $error, 200);
			}
						
		}
	}	
	 
	 /*
	 * 
	 * name: Security_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the Security Account Information for Particular Advertiser
	 */
	
    public function security_option_add_post()
    {		
		$this->form_validation->set_rules('security_name[]','Security Name','trim|required');
		$this->form_validation->set_rules('security_option[]', 'Security Option', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$mobile_no=$this->post('mobile_no');
			
			$account_id = $this->user_authentication->account_id;
			$security_name=$this->post('security_name');
			$security_option=$this->post('security_option'); 
			
			$email=$this->post('email');
			$question_id=$this->post('security_question');
			$security_answer=$this->post('security_answer');
			foreach($security_name as $secure_name){
					$secure_names.= $secure_name.',';
			}
			foreach($security_option as $secure_option){
					$secure_options.= $secure_option.',';
			}
			$update_security_infoObj=array(											
										"security"  	=>	rtrim($secure_names, ','),
										"token_type"	=>	rtrim($secure_options, ','),
										"mobile_no"     	=> 	$mobile_no,
										"email"				=>	$email,
										"question_id" 		=>  $question_id,
										"security_answer"	=>  $security_answer,
										);												
						
		    $this->do_advertiser->security_add($account_id,$update_security_infoObj);	
		    
		    
		     /* Activity Log for Security information - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,SECURTIY);
				if($enable=='1')
				{							
				$this->activity_log(SECURTIY,EDIT);
				}
			/* Activity Log for Security information - End*/	   
		        		
			
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/security'),
							'msg'	 => 'Security are updated successfully!..'
							);
		
						
			$this->response($success, 200);
		
		}

	}
	
	
	public function security_get()
	 {	
		$account_id = $this->user_authentication->account_id;

		$user_info=$this->do_advertiser->get_security($account_id);	  
		 
		 if($user_info)
		 {
			 $this->response($user_info, 200); // 200 being the HTTP response code
		 }
		
	 }
	 
	 public function security_question_get()
	 {	
		 $account_id = $this->user_authentication->account_id;
		 $security_question=$this->do_advertiser->get_security_question($account_id);		 
		 if($security_question)
		 {
			 $this->response($security_question, 200); // 200 being the HTTP response code
		 }
		
	 }
	 
	 public function add_security_get()
	 {
		 $account_id = $this->user_authentication->account_id;
		 $question=$this->get('add_additional_question');		 
		 $security_question=$this->do_advertiser->add_question($account_id,$question);	  
		 
		 if($question)
		 {			 
			 $success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/security'),
							'msg'	 => 'Additional Question are added successfully!..'
			);
			 
			 $this->response($success, 200); // 200 being the HTTP response code
		 }
		 
	 }
	
	
	
	/**
       * 
       * name : update_post()
       * 
       * Updates the site information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	function update_post()
	{
		$account_id	=	clean_data($this->post('account_id'));
		#$user_auth  	= 	$this->user_authentication;
		#$account_id		= 	$user_auth->account_id;
		
		
		$this->form_validation->set_rules('first_name','First Name', 'required|trim|first_alpha_check|alpha_numeric_dash_space');
		$this->form_validation->set_rules('last_name', 'Last Name','required|trim|first_alpha_check|alpha_numeric_dash_space');
		#$this->form_validation->set_rules('email_id', 'Email Address', 'required|trim|is_email|callback_edit_email_check');
		#$this->form_validation->set_rules('website', 'Website', 'required|trim|is_website|callback_edit_website_check');
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			$this->response( $error, 200);
		}
		else
		{			
			if(clean_data($this->post('floor_price_enable'))=="on")
			{
				$fenable	=	1;
			}
			else
			{
				$fenable	=	0;
			}
			
			$update_data	=	array(
									'first_name'		=>	clean_data($this->post('first_name')),
									'last_name'			=>	clean_data($this->post('last_name')),
									'email'				=>	clean_data($this->post('email_id')),
									'floor_price_enable'=>	$fenable,
									'site_url'			=>	clean_data($this->post('website')),
									'account_type'		=>	'TRAFFICKER',
									'referral_share'	=>	clean_data($this->post('edit_referral_share')),
									'active_referrals'	=>	clean_data($this->post('edit_active_referrals')),
									);
									
			$pub_update 	= 	$this->do_publisher->update($account_id,$update_data);
			


			$publisher_id=$this->do_publisher->fetch_affiliate_id($account_id);
			
			/* Activity Log for Publisher update- Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,PUBLISHER_EDIT);
				if($enable=='1')
				{							
				$this->activity_log(PUBLISHER,EDIT,$publisher_id[0]['affiliateid']);
				}
				/* Activity Log for Publisher update- End*/	
			
			if($pub_update != FALSE)
			{	
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Publisher has been updated successfully!..'
									);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
									);
				$this->response( $error, 200);
			}			
		}
	}
	
	/**
       * 
       * name : delete_get()
       * 
       * deletes the publisher information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_get()
	{	
		$account_id = $this->get('del_account_id');
		
		$publisher_id=$this->do_publisher->fetch_affiliate_id($account_id);
		
		$arrays	=	explode(',',$account_id);
		   if(is_array($arrays))
			{  
				foreach($arrays as $account_id)
				{
					$results= $this->delete_pub($account_id);
															
					 /* Activity Log for Publisher Delete- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,PUBLISHER_DELETE);
					if($enable=='1')
					{							
					$this->activity_log(PUBLISHER,DELETE,$publisher_id[0]['affiliateid']);
					}
					/* Activity Log for publisher Delete- End*/	
					
					
				}
				$success 	= 	array('response'	=> 	'ok',
									  'msg'			=> 	'Publisher has been deleted successfully..'
										);
					
				$this->response( $success, 200);
			}
			else
			{
				$results= $this->delete_pub($account_id);
				
				 /* Activity Log for Publisher Delete- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,PUBLISHER_DELETE);
					if($enable=='1')
					{							
					$this->activity_log(PUBLISHER,DELETE,$publisher_id[0]['affiliateid']);
					}
					/* Activity Log for publisher Delete- End*/						
							
				
				$success 	= 	array('response'	=> 	'ok',
									  'msg'			=> 	'Publisher has been deleted successfully..'
										);
					
				$this->response( $success, 200);
			}
	}
	
	function delete_pub($account_id)
	{
		if($account_id)
		{
			$publisher_details = 	$this->do_publisher->get_profile($account_id);
			$publisher = 	$this->do_publisher->remove($account_id);
			if($publisher)
			{
				 // SEND DELETION MESSAGE TO USER
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->do_networks->agency_owner_details($agency_id);
				if($agency_id==1)
				{			
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $publisher_details['email'];
					$user_name     = $publisher_details['first_name']." ".$publisher_details['last_name'];
					$type          = 'PUB_DELETION';		
					$from 	       = $admin_email;
					$to  	       = $user_email;			
					$mail_content  = array(
						"subject" 		=> "Publisher Deletion",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email
						);			
					send_mail($type,$from,$to,$mail_content);
					
				}
				else
				{
					// IF NOT NETWORK ADMIN ADMIN SEND BCC
					$network_admin=$this->do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $publisher_details['email'];
					$user_name     = $publisher_details['first_name']." ".$publisher_details['last_name'];
					$type          = 'PUB_DELETION';		
					$from 	       = $admin_email;
					$to  	       = $user_email;			
					$mail_content  = array(
						"subject" 		=> "Publisher Deletion",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email
						);
						$attachement = "";			
					send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
					
				}
			}
			else
			{
				$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Error..Please Try again.'
								);
			
				$this->response( $error, 200);
			}
		}
		else
		{
			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Publisher does not found.'
								);
			
			$this->response( $error, 200);
		}
	}
	
	/**
       * 
       * name : block_get()
       * 
       * block the publisher information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function block_get()
	{	
		$account_id = $this->get('block_account_id');	
		
		$arrays	=	explode(',',$account_id);
		   if(is_array($arrays))
			{  
				foreach($arrays as $account_id)
				{
					$publisher_id=$this->do_publisher->fetch_affiliate_id($account_id);
					 /* Activity Log for block publisher- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,USER_ACCESS_BLOCK);
					if($enable=='1')
					{				
					$this->activity_log(PUBLISHER,BLOCK,$publisher_id[0]['affiliateid']);
					}
					/* Activity Log for block publisher- End*/
					
					$results= $this->block_pub($account_id);
				}
				$success 	= 	array('response'	=> 	'ok',
									  'msg'			=> 	'Publisher has been blocked successfully..'
										);
					
				$this->response( $success, 200);
			}
			else
			{
				$publisher_id=$this->do_publisher->fetch_affiliate_id($account_id);
				 /* Activity Log for block publisher- Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,USER_ACCESS_BLOCK);
				if($enable=='1')
				{				
				$this->activity_log(PUBLISHER,BLOCK,$publisher_id[0]['affiliateid']);
				}
				/* Activity Log for block publisher- End*/
				
							
				$results= $this->block_pub($account_id);
				$success 	= 	array('response'	=> 	'ok',
									  'msg'			=> 	'Publisher has been blocked successfully..'
										);
					
				$this->response( $success, 200);
			}
	}
	
	function block_pub($account_id)
	{
		if($account_id)
		{
			$publisher 	= 	$this->do_publisher->block($account_id);
			
			$account_id = 	$this->user_authentication->account_id;
			$account_type	=	$this->user_authentication->account_type;	
			$network_id	=	$this->user_authentication->network_account_id;					
			$agency_id	=	$this->user_authentication->agency_id;
			$result		=	$this->do_networks->agency_owner_details($agency_id);
			$admin_name    	= 	$result['name'];			
			$admin_email	= 	$result['email'];	
			$admin_id   	= 	$result['account_id'];
					  
			$user = $this->do_message->get_profile($admin_id); 
		
			$type     	   = "BLOCK_PUBLISHER_ACCOUNT";
			
			if($publisher)
			{
				
				$publisher_details 	= 	$this->do_publisher->get_profile($account_id);
				//SEND MAIL TO THE BLOCKED ADVERTISER
				
				$type_details	=	array(
								//	'msg_type'		=> $message,
									'type'			=> $type,
									'string'		=> "user_access_block",
									'column_name'	=> "account_settings"
									);
				
				$mail_content=array(
					"to_name"	=>	ucfirst($publisher_details['first_name']).' '.ucfirst($publisher_details['last_name']),
					"email"	=>	$this->post('email'),
					"from_name"	=>	$user['first_name'].' '.$user['last_name'],
					'type'			=> $type,
					 
				);
				$message_data		=	array(
					'sender_id'		=>	$admin_id,
					'receiver_id'	=>	$account_id,
					'subject'		=>	'Publisher - Account blocked',
					'content'		=> 	'Your account has been blocked by admin',
					'account_type'	=>	"TRAFFICKER",
					'notification_type'	=>	"setting_information",
					'status'		=>	'1',
					'network_id'	=>	$network_id,
					'date'			=>	date('Y-m-d H:i:s')
								);		
								
				$dd = $this->notification->new_mail($message_data,$user,$publisher_details,$type_details,$mail_content);				
			
				$success 		= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Publisher has been blocked successfully.'
									);
				
				$this->response( $success, 200);
			}
			else
			{
				
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
									);
				
				$this->response( $error, 200);
			}
			
		}
		else
		{
			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Publisher does not found.'
								);
			
			$this->response( $error, 200);
		}
	}
	
	/**
       * 
       * name : unblock_get()
       * 
       * block the publisher information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function unblock_get()
	{	
		$account_id = $this->get('unblock_account_id');	
		 $arrays	=	explode(',',$account_id);
		   if(is_array($arrays))
			{  
				foreach($arrays as $account_id)
				{
					$results= $this->unblock_pub($account_id);
				}
				$success 	= 	array('response'	=> 	'ok',
									   'msg'			=> 	'Publisher has been unblocked successfully..'
										);
					
				$this->response( $success, 200);
			}
			else
			{
				$results= $this->unblock_pub($account_id);
				$success 	= 	array('response'	=> 	'ok',
									  'msg'			=> 	'Publisher has been unblocked successfully..'
										);
					
				$this->response( $success, 200);
			}
	}
	
	function unblock_pub($account_id)
	{
		if($account_id)
		{
			$publisher 	= 	$this->do_publisher->unblock($account_id);
			
			if($publisher)
			{
				
				/* Activity Log for block publisher- Start*/
				$publisher_id=$this->do_publisher->fetch_affiliate_id($account_id);	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,USER_ACCESS_UNBLOCK);
				if($enable=='1')
				{					
				$this->activity_log(PUBLISHER,UNBLOCK,$publisher_id[0]['affiliateid']);
				}
				/* Activity Log for block publisher- End*/
				
				$publisher_details 	= 	$this->do_publisher->get_profile($account_id);
				
				//SEND MAIL TO THE UNBLOCKED PUBLISHER
				$account_id = 	$this->user_authentication->account_id;
				$account_type	=	$this->user_authentication->account_type;	
				$network_id	=	$this->user_authentication->network_account_id;					
				$agency_id	=	$this->user_authentication->agency_id;
				$result		=	$this->do_networks->agency_owner_details($agency_id);
				$admin_name    	= 	$result['name'];			
				$admin_email	= 	$result['email'];	
				$admin_id   	= 	$result['account_id'];
				
				$user = $this->do_message->get_profile($admin_id); 
				$type     	   	= 	"UNBLOCK_PUBLISHER_ACCOUNT";
				
				$type_details	=	array(
								//	'msg_type'		=> $message,
									'type'			=> $type,
									'string'		=> "user_access_unblock",
									'column_name'	=> "account_settings"
									);
							
				$user_email    = $publisher_details['email'];
				$user_name     = $publisher_details['first_name'].' '.$publisher_details['last_name'];
				
				$from 	       =  $admin_email;
				$to  	       =  $user_email;			
				$mail_content  =	array(
									"to_name"	=>	ucfirst($publisher_details['first_name']).' '.ucfirst($publisher_details['last_name']),
									"email"		=>	$this->post('email'),
									"from_name"	=>	$user['first_name'].' '.$user['last_name'],
									'type'		=> $type,
									 
								);
				$message_data		=	array(
											'sender_id'		=>	$admin_id,
											'receiver_id'	=>	$account_id,
											'subject'		=>	'Publisher - Account unblocked',
											'content'		=> 	'Your account has been unblocked by admin',
											'account_type'	=>	"TRAFFICKER",
											'notification_type'	=>	"setting_information",
											'status'		=>	'1',
											'network_id'	=>	$network_id,
											'date'			=>	date('Y-m-d H:i:s')
											);		
				
				$dd = $this->notification->new_mail($message_data,$user,$publisher_details,$type_details,$mail_content);
				
				$success 		= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Publisher has been unblocked successfully.'
									);
				
				$this->response( $success, 200);
			}
			else
			{
				
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
									);
				
				$this->response( $error, 200);
			}
			
		}
		else
		{			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Publisher does not found.'
								);
			
			$this->response( $error, 200);
		}
	}
	
	/*
	 * 
	 * name: user_information
	 * @param :null
	 * @return : response Array
	 * 
	 * get the user information for particular Publisher
	 */	
	 
	 public function user_information_get()
	 {	
		 #$account_id=$this->get('account_id');
		 $user_auth  	= 	$this->user_authentication;
		 $account_id	= 	$user_auth->account_id;
		 
		 $user_info=$this->do_publisher->get_user_information($account_id);	
		
		 if($user_info!='')
		 {
			$this->response($user_info, 200); // 200 being the HTTP response code
		 }		
		
	 }
	
	
	/*
	 * 
	 * name: company_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the company Information for Particular Publisher
	 */
	
    public function company_information_add_post(){		
		
		$this->form_validation->set_rules('company_name', 'Company Name', 'trim|required');
		$this->form_validation->set_rules('company_address', 'Company Address', 'trim|required');
		$this->form_validation->set_rules('company_block_no', 'Company Block Number', 'trim|required');
		$this->form_validation->set_rules('company_address', 'Company Address', 'trim|required');
		$this->form_validation->set_rules('company_city', 'City', 'trim|required|alpha|callback_edit_company_test');
		$this->form_validation->set_rules('company_state', 'State', 'trim|required|alpha|callback_edit_company_check');
		$this->form_validation->set_rules('company_country', 'Company Country', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			#$account_id=$this->post('account_id');
			$user_auth	= 	$this->user_authentication;
			$account_id	= 	$user_auth->account_id;
			
			$update_company_infoObj=array(							
										"company_name"  =>	clean_data($this->post('company_name')),
										"company_address"	=>	clean_data($this->post('company_address')),
										"company_block_no" 	=>	clean_data($this->post('company_block_no')),
										"company_city"	=>  clean_data($this->post('company_city')),
										"company_state" =>clean_data($this->post('company_state')),
										"company_country"=>clean_data($this->post('company_country')),
										"updated"=>date("Y-m-d H:i:s")
								);	
							
			
		    $this->do_publisher->update_companyinfo($account_id,$update_company_infoObj);
		    
		    
		     /* Activity Log for Company information - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,COMPANY_INFORMATION);
				if($enable=='1')
				{							
				$this->activity_log(COMPANY_INFORMATION,EDIT);
				}
			/* Activity Log for Company information - End*/	
		    
		   //SEND EMAIL TO PUBLISHERS
		    
		    /* GET AGENCY ID FROM LIBRARY */
		    $account_type	=	$this->user_authentication->account_type;	
		    $network_id	=	$this->user_authentication->network_account_id;					
			$agency_id	=	$this->user_authentication->agency_id;
			$result		=	$this->do_networks->agency_owner_details($agency_id);
			$admin_name    	= 	$result['name'];			
			$admin_email	= 	$result['email'];	
			$admin_id   	= 	$result['account_id'];		
			
			/* TO GET ADMIN EMAIL ID FOR bcc */
			$network_admin=$this->do_networks->get_network_details();
			$bcc		   = $network_admin['email'];
			
			/* PUBLISHER DETAILS */
			$pub_result_array  =  $this->do_publisher->get_user_information($account_id);
			$pub_result		   =  $pub_result_array[0];
			$user_name  	   =  $pub_result['name'];
			$user_email		   =  $pub_result['email'];
			
			$type   ="COMPANY_INFORMATION";
			$from 	=  $admin_email;
			$to  	=  $user_email;	
			
			/* Gender values */
			$company_country=$this->do_networks->country(clean_data($this->post('company_country')));
				
			 
			/* CHECK ADMIN EMAIL AND BCC EMAIL ARE SAME */				
			$bcc=($bcc!=$admin_email)?$bcc:'';
			
			$attachement = "";		
					
			/* CALL HELPHER FILE */
			//send_mail($type,$from,$to,$mail_content,$attachement,$bcc);			
			$affiliate_id	=	$this->user_authentication->affiliate_id;
			$reciever = $this->do_message->get_affiliate($affiliate_id); 
			
			$user = $this->do_message->get_profile($admin_id); 
			$type_details	=	array(
								//'msg_type'		=> $message,
								'type'			=> $type,
								'string'		=> "company_info",
								'column_name'	=> "account_settings",
								'bcc'			=>	$bcc
								);
			 
			$mail_content=array(
						"subject" 		=> "Publisher - Company Information",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,							
						"company_name"  =>	clean_data($this->post('company_name')),
						"company_address"	=>	clean_data($this->post('company_address')),
						"company_block_no" 	=>	clean_data($this->post('company_block_no')),
						"company_city"		=>  clean_data($this->post('company_city')),
						"company_state"		=>  clean_data($this->post('company_state')),
						"company_country" 	=> $company_country['name']	,
						"account_type"	    => "publisher"			
						);
				  
			$message_data		=	array(
										'sender_id'		=>	$admin_id,
										'receiver_id'	=>	$account_id,
										'subject'		=>	'Publisher - Company Information',
										'content'		=> 	'Your company information has been updated Successfully',
										'account_type'	=>	"TRAFFICKER",
										'notification_type'	=>	"setting_information",
										'network_id'	=>	$network_id,
										'status'		=>	'1',
										'date'			=>	date('Y-m-d H:i:s')
									);		
					
			$dd = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);	
					
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/company_information'),
							'msg'	 => 'Company Information are updated successfully!..'
			);
		
						
			$this->response($success, 200);
		}

	}
	
	/*
	 * 
	 * name: personal_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the Personal Account Information for Particular Publisher
	 */
	
    public function personal_information_add_post(){
	
			if($this->post('individual')==1)
		{
		$this->form_validation->set_rules('first_name', 'First Name', 'trim|required');
		$this->form_validation->set_rules('last_name', 'Last Name', 'trim|required');
		$this->form_validation->set_rules('gender', 'Gender', 'trim|required');
		$this->form_validation->set_rules('date_of_birth', 'Date Of Birth', 'trim|required');
		$this->form_validation->set_rules('mobile_no', 'Mobile Number', 'trim|required');
		$this->form_validation->set_rules('city', 'City', 'trim|required|alpha|callback_edit_check');
		$this->form_validation->set_rules('state', 'State', 'trim|required|alpha|callback_edit_state');
		$this->form_validation->set_rules('country', 'Country', 'trim|required');
		//$this->form_validation->set_rules('company_block_no', 'Company Block Number', 'trim|required');
		//$this->form_validation->set_rules('company_address', 'Company Address', 'trim|required');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|callback_acc_email_check');
		$this->form_validation->set_rules('skype', 'Skype Address', 'trim|required');
		$this->form_validation->set_rules('icq', 'ICQ Address', 'trim|required');
		$this->form_validation->set_rules('jabber', 'Jabber Address', 'trim|required');	
		}		
		else
		{
		$this->form_validation->set_rules('company_name', 'Company Name', 'trim|required');
		$this->form_validation->set_rules('mobile_no', 'Mobile Number', 'trim|required');
		$this->form_validation->set_rules('company_city', 'City', 'trim|required|alpha|callback_edit_company_test');
		$this->form_validation->set_rules('company_state', 'State', 'trim|required|alpha|callback_edit_company_check');
		$this->form_validation->set_rules('company_country', 'Company Country', 'trim|required');
		$this->form_validation->set_rules('company_block_no', 'Company Block Number', 'trim|required');
		$this->form_validation->set_rules('company_address', 'Company Address', 'trim|required');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|callback_acc_email_check');
		$this->form_validation->set_rules('skype', 'Skype Address', 'trim|required');
		$this->form_validation->set_rules('icq', 'ICQ Address', 'trim|required');
		$this->form_validation->set_rules('jabber', 'Jabber Address', 'trim|required');	
		}	

		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{				
			
			#$account_id=$this->post('account_id');	
			$user_auth  = 	$this->user_authentication;
			$account_id	= 	$user_auth->account_id;
			
			$org_date = clean_data($this->post('date_of_birth'));
			$date = new DateTime($org_date);
			$date_format=$date->format('Y-m-d'); // 2012-09-13
			if($this->post('individual')==1)
		{
			$update_personal_infoObj=array(							
										"first_name"  	=>	clean_data($this->post('first_name')),
										"last_name"		=>	clean_data($this->post('last_name')),
										"gender" 		=>	clean_data($this->post('gender')),
										"dob"			=> 	$date_format ,
										//"company_address"	=>	clean_data($this->post('company_address')),
										//"company_block_no" 	=>	clean_data($this->post('company_block_no')),
										"mobile_number" =>	clean_data($this->post('mobile_no')),
										"city" 			=>	clean_data($this->post('city')),
										"state" 		=>	clean_data($this->post('state')),
										"country" 		=>	clean_data($this->post('country')),
										"skype"         => 	clean_data($this->post('skype')),
										"icq"         	=> 	clean_data($this->post('icq')),
										"jabber"        => 	clean_data($this->post('jabber')),
										"vat_number"    =>  clean_data($this->post('european_vat')),
										"email" 		=>	clean_data($this->post('email')),
										"alternate_email"	=>	clean_data($this->post('another_email')),
										"currency" 	=>	clean_data($this->post('currency_to_view')),
										"updated"		=>	date("Y-m-d H:i:s")										
								);
									
			$account_setting_type="personal";				
		
		    $this->do_publisher->update($account_id,$update_personal_infoObj,$account_setting_type);
		}
		else
		{
		$update_company_infoObj=array(							
										"company_name"  =>	clean_data($this->post('company_name')),
										"company_address"	=>	clean_data($this->post('company_address')),
										"company_block_no" 	=>	clean_data($this->post('company_block_no')),
										"mobile_number" =>	clean_data($this->post('mobile_no')),
										"company_city"	=>  clean_data($this->post('company_city')),
										"company_state" =>clean_data($this->post('company_state')),
										"company_country"=>clean_data($this->post('company_country')),
										"skype"         => 	clean_data($this->post('skype')),
										"icq"         	=> 	clean_data($this->post('icq')),
										"jabber"        => 	clean_data($this->post('jabber')),
										"vat_number"    =>  clean_data($this->post('european_vat')),
										"email" 		=>	clean_data($this->post('email')),
										"alternate_email"	=>	clean_data($this->post('another_email')),
										"currency" 	=>	clean_data($this->post('currency_to_view')),
										"updated"		=>	date("Y-m-d H:i:s")										
								);
		
		  $this->do_publisher->update_companyinfo($account_id,$update_company_infoObj);
		}
		    
		    /* Activity Log for Personal information - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,PERSONAL_INFORMATION);
				if($enable=='1')
				{							
				$this->activity_log(PERSONAL_INFORMATION,EDIT);
				}
			/* Activity Log for Personal information - End*/	
		    
		     //SEND EMAIL TO PUBLISHERS
		    
			/* GET AGENCY ID FROM LIBRARY */
		    $account_type	=	$this->user_authentication->account_type;	
		    $network_id	=	$this->user_authentication->network_account_id;					
			$agency_id	=	$this->user_authentication->agency_id;
			$result		=	$this->do_networks->agency_owner_details($agency_id);
			$admin_name    	= 	$result['name'];			
			$admin_email	= 	$result['email'];	
			$admin_id   	= 	$result['account_id'];		
				
			/* GET ADMIN EMAIL ID FOR bcc */
			$network_admin=$this->do_networks->get_network_details();
			$bcc		   = $network_admin['email'];
				
			/* PUBLISHER DETAILS */
			$pub_result_array  =  $this->do_publisher->get_user_information($account_id);
			$pub_result		   =  $pub_result_array[0];
			$user_name  	   =  $pub_result['name'];
			$user_email		   =  $pub_result['email'];
			
			$type   =	"PERSONAL_INFORMATION";
			$from 	=  	$admin_email;
			$to  	=  	$user_email;	
			/* Gender values */
			$gender	=	(clean_data($this->post('gender'))=='1')?'Male':'Female';
			$country=	$this->do_networks->country($this->post('country'));
			$affiliate_id	=	$this->user_authentication->affiliate_id;
	
			$reciever = $this->do_message->get_affiliate($affiliate_id); 
	
			$user = $this->do_message->get_profile($admin_id); 	
				
			$type_details	=	array(
									'msg_type'		=> $message,
									'type'			=> $type,
									'string'		=> "personal_info",
									'column_name'	=> "account_settings"
									);
			$mail_content=array(
								"subject" 		=> "Publisher - Personal Information",
								"to_name" 		=> $user_name,				
								"from_name"		=> $admin_name,							
								"first_name"    => clean_data($this->post('first_name')),
								"last_name" 	=> clean_data($this->post('last_name')),
								"gender"    	=> $gender,
								"dob"	        => $date_format ,
								"mobile_number" => clean_data($this->post('mobile_no')),
								"city"          => clean_data($this->post('city')),
								"state"         => clean_data($this->post('state')),
								"country" 		=> $country['name'],
								"skype"         => clean_data($this->post('skype')),
								"icq"         	=> clean_data($this->post('icq')),
								"jabber"        => clean_data($this->post('jabber')),
								"vat_number"    =>  clean_data($this->post('european_vat')),
								"account_type"	=> "publisher"		
								);			
			/* CHECK ADMIN EMAIL AND BCC EMAIL ARE SAME */				
			$bcc=($bcc!=$admin_email)?$bcc:'';
			    
			$attachement = "";		
			$message_data	=	array(
										'sender_id'		=>	$admin_id,
										'receiver_id'	=>	$account_id,
										'subject'		=>	'Publisher - Personal Information',
										'content'		=> 	'Publisher personal information updated successfully',
										'account_type'	=>	"TRAFFICKER",
										'notification_type'	=>	"setting_information",
										'status'		=>	'1',
										'network_id'	=>	$network_id,
										'date'			=>	date('Y-m-d H:i:s'),
									);		
						 	
			$type_details['bcc']=$bcc;	
			 	
		//	$dd = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);			
				$adv_details	=	$this->do_advertiser->get_user_information($account_id); 	
				$notication_value ='account_set_pub';
				$notification_msg = $this->do_message->get_notification_msg($notication_value); 
				if($notification_msg[0]['msg_type']=='1')
				{
					$notification_content = $notification_msg[0]['content'];
				}
				else
				{
					$template_filename = $notification_msg[0]['template_filename'];
					$csvfilepath 	= $this->config->item('read_settings');	
					$notification_content = file_get_contents($csvfilepath.$template_filename);
				}
				
				$adgate_url=base_url();
				$prod_name	= 	$this->config->item('prod_name');
				$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
				$msg_replace = str_replace("{{publisher_name}}",$user_name,$msg_replace);	
				$msg_replace = str_replace("{{admin_name}}",$admin_name,$msg_replace);
				 
				$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin>Login</a>' ,$msg_replace);
				$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">Click here to Adgate</a>',$msg_replace);//print_r('$msg_replace');exit;
				 
				$dd = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace);
						
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/personal_information'),
							'msg'	 => 'Personal Information are updated successfully!..'
			);
		
						
			$this->response($success, 200);
		}

	}
	
	
	 
	/*
	 * 
	 * name: account_settings_add
	 * @param :null
	 * @return : response Array
	 * 
	 * Add/update the Account Setting Information for Particular Publisher
	 */
	
    public function account_settings_add_post(){		
		
		//$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|callback_acc_email_check');
		//$this->form_validation->set_rules('another_email','Another Email','trim|required|valid_email');
		//$this->form_validation->set_rules('currency_to_view', 'Currency', 'trim|required');
		//$this->form_validation->set_rules('current_password', 'Current password', 'trim|[current_password]');
		$this->form_validation->set_rules('password', 'New password', 'trim|matches[conf_password]');
		$this->form_validation->set_rules('conf_password', 'Repeat password', 'trim|matches[password]');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			#$account_id=$this->post('account_id');	
			$user_auth  = 	$this->user_authentication;
			$account_id	= 	$user_auth->account_id;
			$account_setting_type="account";								
			
			//GET PUBLISHER CURRENT PASSWORD
			$db_old_pass=$this->do_publisher->get_current_pass($account_id);	
			$current_password=trim($this->post('current_password'));
		    if(md5($current_password)==$db_old_pass || $current_password=='')
			{			
				$update_setting_infoObj	=	array(
												//	"email"  =>	clean_data($this->post('email')),
												//	"alternate_email"	=>	clean_data($this->post('another_email')),
													"currency" 	=>	clean_data($this->post('currency_to_view')),
													"password"=>clean_data($this->post('password')),
													"email_updated"=>date("Y-m-d H:i:s")																				
												);						
								
				$this->do_publisher->update($account_id,$update_setting_infoObj,$account_setting_type);	
				$enable_twofactor = clean_data($this->post('enable_twofactor'));
		    
				if($enable_twofactor){
					$security_enable = 1; 	
				}
				else{
					$security_enable = 0; 
				}
					$security_info = array(
					"security_enable"=>$security_enable,
					
					);
				$this->do_app_config->update_security_info($account_id,$security_info);
			/* Activity Log for Account settings - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,ACC_SETTINGS);
				if($enable=='1')
				{							
				$this->activity_log(ACC_SETTINGS,EDIT);
				}
			/* Activity Log for Account Settings - End*/	
				
				
				//SEND EMAIL TO PUBLISHERS -ACCOUNT SETTINGS
				
				/* GET AGENCY ID FROM LIBRARY */
				$account_type	=	$this->user_authentication->account_type;	
				$network_id	=	$this->user_authentication->network_account_id;					
				$agency_id	=	$this->user_authentication->agency_id;
				$result		=	$this->do_networks->agency_owner_details($agency_id);
				$admin_name    	= 	$result['name'];			
				$admin_email	= 	$result['email'];	
				$admin_id   	= 	$result['account_id'];					 		
			
				/* TO GET ADMIN EMAIL ID FOR bcc */
				$network_admin=$this->do_networks->get_network_details();
				$bcc		   = $network_admin['email'];
				
				/* PUBLISHER DETAILS */
				$pub_result_array  =  $this->do_publisher->get_user_information($account_id);
				$pub_result		   =  $pub_result_array[0];
				$user_name  	   =  $pub_result['name'];
				$user_email		   =  clean_data($this->post('email'));
				//CHECK WHETHER ACCOUNT SETTINGS / PASS UPDATED
				if(clean_data($this->post('password'))!='')
				{
					$type   ="PUB_CHANGE_PASSWORD";
				}
				else
				{
					$type   ="SETTING_INFORMATION";
				}
				$from 	=  $admin_email;
				$to  	=  $user_email;			
			
				$affiliate_id	=	$this->user_authentication->affiliate_id;
				$reciever = $this->do_message->get_affiliate($affiliate_id); 
				$user = $this->do_message->get_profile($admin_id); 
				$type_details	=	array(
											'msg_type'		=> $message,
											'type'			=> $type,
											'string'		=> "account_set",
											'column_name'	=> "account_settings"
											);
					 
				if(clean_data($this->post('password'))=='')
				{
			  
					$message_data		=	array(
							'sender_id'		=>	$admin_id,
							'receiver_id'	=>	$account_id,
							'subject'		=>	'Publisher - Account Information',
							'content'		=> 	'Please check the account details. Email:'.clean_data($this->post('email')).'Alternate email: '. clean_data($this->post('another_email')).'currency: '. clean_data($this->post('currency_to_view')),
							'account_type'	=>	"TRAFFICKER",
							'notification_type'	=>	"setting_information",
							'network_id'	=>	$network_id,
							'status'		=>	'1',
							'date'			=>	date('Y-m-d H:i:s')
											);		
				//	$dd = $this->notification->new_mail($message_data,$user,$reciever,$type_details);				
				}
				else
				{
					$mail_content=array(
							"to_name"	=>	$reciever['dj_first_name'].' '.ucfirst($reciever['dj_last_name']),
							"email"	=>	$this->post('email'),
							"password"  => 	$this->post('password'),
							"from_name"	=>	$user['first_name'].' '.$user['last_name']
							 
						);
								
					$message_data		=	array(
							'sender_id'		=>	$admin_id,
							'receiver_id'	=>	$account_id,
							'subject'		=>	'Publisher - Change Password',
							'content'		=> 	'Please check the new password and Login. Login Id:'.clean_data($this->post('email')).'    Password: '. clean_data($this->post('password')),
							'account_type'	=>	"TRAFFICKER",
							'notification_type'	=>	"setting_information",
							'status'		=>	'1',
							'network_id'	=>	$network_id,
							'date'			=>	date('Y-m-d H:i:s'),
							 
							
											);		
					//$dd = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);		
				}	
				$adv_details	=	$this->do_advertiser->get_user_information($account_id); 	
				$notication_value ='account_set_pub';
				$notification_msg = $this->do_message->get_notification_msg($notication_value); 
				if($notification_msg[0]['msg_type']=='1')
				{
					$notification_content = $notification_msg[0]['content'];
				}
				else
				{
					$template_filename = $notification_msg[0]['template_filename'];
					$csvfilepath 	= $this->config->item('read_settings');	
					$notification_content = file_get_contents($csvfilepath.$template_filename);
				}
				
				$adgate_url=base_url();
				$prod_name	= 	$this->config->item('prod_name');
				$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
				$msg_replace = str_replace("{{publisher_name}}",$user_name,$msg_replace);	
				$msg_replace = str_replace("{{admin_name}}",$admin_name,$msg_replace);
				 
				$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin>Login</a>' ,$msg_replace);
				$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">Click here to Adgate</a>',$msg_replace);//print_r('$msg_replace');exit;
				 
				$dd = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace);	
				/* CALL HELPHER FILE */
				//send_mail($type,$from,$to,$mail_content,$attachement,$bcc);			
				
				$success = array(
								'response' => 'ok',
								'redirect'=>site_url('publisher/settings/account_settings'),
								'msg'	 => 'Account Settings Information are updated successfully!..'
				);
			  
			    $this->response($success, 200);
		  }
		  else
		  { 
		       $success = array(
								'response' => 'error',
								'redirect'=>site_url('publisher/settings/account_settings'),
								'msg'	 => 'Your old password mismatch!..'
				);
			  
			    $this->response($success, 200);
		  }
		}

	}
	
	/*
	 * 
	 * name: upload_profile_image
	 * @param :null
	 * @return:response array
	 * 
	 * Upload the selected image
	 * 
	 */
	
	public function upload_profile_image_post()
	{	
		#$account_id=$this->post('account_id');
		$user_auth	= 	$this->user_authentication;
		$account_id	= 	$user_auth->account_id;
		
		if($_FILES['profile_image'])
		{
			$profile_image=array(
					'file_name'   => $_FILES['profile_image']['name'],
					'source_name' => $_FILES['profile_image']['tmp_name'] 				 				
					);
		}
		
		
		$data=$this->image_lib->update_profile_image($profile_image);
		$this->do_publisher->update_image_information($account_id,$data['upload_data']['file_name']);
		 
		 $success = array(
							'response' => 'ok',
							'msg'	 => 'Profile Image updated successfully!..'
			);
			
			$this->response($success, 200);
		
	}
	
	/*
	 * 
	 * name: delete_profile_image
	 * @param : null
	 * @return :response array
	 * 
	 * Delete the image in user profile
	 */
	
	public function delete_profile_image_post()
	{
		 #$account_id=$this->post('account_id');			
		 $user_auth  	= 	$this->user_authentication;
		 $account_id 	= 	$user_auth->account_id;
		 $profile_name	=	$this->do_publisher->get_user_information($account_id);
		 $delete_profile_name=$profile_name[0]['dj_profile_image'];	
		 
				
		if($delete_profile_name)
		{
			$is_delete_profile=$this->image_lib->delete_profile_image($delete_profile_name);
			
			/* Delete Profile name in Database */
			$this->do_publisher->delete_profile_name($account_id);
			

			if($is_delete_profile)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => 'Profile image deleted'
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the Profile Image '
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete Profile Image'
							);
			$this->response($error, 200);
		}
	}	
	
	/*
	 * 
	 * name: email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	
	public function email_check()
	{
		$email		=	clean_data($this->post('email_id'));
		
		$count		=	$this->do_email_check->dup_email_check($email);		
			   
		if($count>0 )
		{
			$this->form_validation->set_message('email_check', "This Email address already Exists");
			return FALSE;	
		}
		else
		{
			return true;
		}
	}	
	
	/*
	 * 
	 * name: edit_email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	function edit_email_check()
	{
		#$account_id	=	$this->post('account_id');
		$user_auth  = 	$this->user_authentication;
		$account_id	= 	$user_auth->account_id;
		$email		=	clean_data($this->post('email_id'));
		$count 		= 	$this->do_email_check->dup_email_check($email,$account_id);
		
		if($count>0)
		{
			$this->form_validation->set_message('edit_email_check', "This Email address already Exists");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	
		/*
	 * 
	 * name: edit_website_check
	 * @param : null
	 * @return : website Count 
	 * 
	 * checked the email count
	 */
	
	function edit_website_check()
	{
		$website	=	clean_data($this->post('website'));
		#$account_id	=	$this->post('account_id');
		$user_auth  = 	$this->user_authentication;
		$account_id	= 	$user_auth->account_id;
		$count 		= 	$this->do_publisher->dup_website_check($account_id,$website);
		
		if($count>0)
		{
			$this->form_validation->set_message('edit_website_check', "This Website address already Exists");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	
	/**
       * 
       * name : site_count_get()
       * 
       * Fetches all site count.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_site_get()
	{					
		$site_list = $this->do_publisher->fetch_site();
			
		$this->response($site_list);
	}
	
	
	/*
	 * 
	 * name: account_email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	function acc_email_check()
	{
		#$account_id	=	$this->post('account_id');
		$user_auth  = 	$this->user_authentication;
		$account_id	= 	$user_auth->account_id;
		$email		=	clean_data($this->post('email'));
		$count 		= 	$this->do_email_check->dup_email_check($email,$account_id);	
		
		if($count>0)
		{
			$this->form_validation->set_message('acc_email_check', "This Email address already Exists");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	/*
	* 
	* name: publisher_earning_post
	* @param : account_id,account_type values
	* @return : true or false.
	* 
	*/
	public function publisher_earning_post()
	{	
		$user_auth  	= 	$this->user_authentication;
		$account_id		= 	$user_auth->account_id;
		$account_type	= 	$user_auth->account_type;
		$earning 		= 	$this->do_publisher->publisher_earning($account_id);
		//	log_message('error','publisher_earning');
		//log_message('error',$this->db->last_query());
		if($earning)
		{
			$bal		=	$this->do_invoices->retreive_overall_payment_details($account_id);
			//log_message('error','publisher_bal');
		//log_message('error',$this->db->last_query());
			$searning 	= 	$this->do_publisher->publisher_earning($account_id,date('Y-m-d',strtotime('yesterday')));
			$searning_today 	= 	$this->do_publisher->publisher_earning_today($account_id,date('Y-m-d',strtotime('yesterday')));
			
			//	log_message('error','publisher_searning');
		//log_message('error',$this->db->last_query());
			$success 	= 	array('response'	=> 	'ok',
								  'balance'		=>	ROUND($bal['tot_payment']->tot_amount,4),
								  'searning'	=>	$searning['earnings'],
								  'searning_today'	=>	$searning_today['earnings'],
								  'msg'			=> 	$earning
								);
			
			$this->response( $success, 200);
		}
		else
		{			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	''
								);
			
			$this->response( $error, 200);
		}			
		
	}
	
	function check()
	{
		$t=clean_data($this->input->post('city'));
		if( ! preg_match("/^([-a-z_ ])+$/i", $t))
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
		
	}
	
	function state()
	{
		$s=clean_data($this->input->post('state'));
		if( ! preg_match("/^([-a-z_ ])+$/i", $s))
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
		
	}
	
	function company_test()
	{
		$tt=clean_data($this->input->post('company_city'));
		if(  !preg_match("/^([-a-z_ ])+$/i", $tt))
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
		
	}
	
	function company_check()
	{
		$ss=clean_data($this->input->post('company_state'));
		if( !preg_match("/^([-a-z_ ])+$/i", $ss))
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
		
	}
	
	public function fetch_adblocks_get()
	{					
		if($this->user_authentication->account_type=='TRAFFICKER')
		{
			$account_id 	= 	$this->user_authentication->account_id;
		}
		else
		{
			$account_id 	= 	$this->get('account_id');
		}
		
		$adb_list 	= 	$this->do_publisher->fetch_adblocks($account_id);
			
		if($adb_list)
		{
			$this->response($adb_list,200);
		}
		else
		{
			$this->response('error',200);
		}
		
	}
	
	
	public function fetch_adblocks_div_get()
	{					
		if($this->user_authentication->account_type=='TRAFFICKER')
		{
			$account_id 	= 	$this->user_authentication->account_id;
		}
		else
		{
			$account_id 	= 	$this->get('account_id');
		}
		
		$adb_list 	= 	$this->do_publisher->fetch_adblocks_div($account_id);
			
		if($adb_list)
		{
			$this->response($adb_list,200);
		}
		else
		{
			$this->response('error',200);
		}
		
	}
	
	
	
	
	function fetch_adtag_get()
	{
		$zone_id 	= 	$this->get('zoneid');
		
		$zone_data=$this->do_publisher->fetch_adblocks_adtag($zone_id);
		
		if($zone_data)
		{
			$this->response($zone_data, 200); 
		}
		else
		{
			$this->response('error', 200);
		}
		
	}
	
	function notification_settings_post()
	{	 
		//	echo "post<pre>";print_r($_POST);exit();
			$enable_notification = $this->input->post('enable_notification');
			$user_auth  	= 	$this->user_authentication;
			$account_id 	= 	$user_auth->account_id;
			$client_id 	= 	$user_auth->client_id;
			$notification['account_id']= $account_id;
			$notification['client_id']= $client_id;
			
		
			if($enable_notification)
			{ 
				if(isset($_POST))
				{
                   $postvalues = $_POST;
                   if(isset($postvalues['campaign_type']) && ($postvalues['campaign_type'] == 'favorite'))
                   {
                     if(isset($postvalues['campaignsfav']))
                     {
                       $notification['campaigns']			=	$this->input->post('campaignsfav');
                     }
                     else if(!empty($postvalues['fav_exist']))
                     {
                       $campaignsarr = explode(',', $postvalues['fav_exist']);
                      // echo "ttt<pre>";print_r($campaignsarr);exit();
                       $notification['campaigns']			=	$campaignsarr;
                     }
                   }
                   else if(isset($postvalues['campaign_type']) && ($postvalues['campaign_type'] == 'member'))
                   {
                     if(isset($postvalues['campaigns']))
                     {
                     $notification['campaigns']			=	$this->input->post('campaigns');
                     }
                     else if(!empty($postvalues['fav_exist']))
                     {
                     	$campaignsarr = explode(',', $postvalues['fav_exist']);
                       $notification['campaigns']			=	$campaignsarr;
                     }
                   }
                   else if(isset($postvalues['campaign_type']) && ($postvalues['campaign_type'] == 'both'))
                   {
                     if(isset($postvalues['campaigns']))
                     {
                     $notification['campaigns']			=	$this->input->post('campaignstest');
                     }
                     else if(!empty($postvalues['fav_exist']))
                     {
                     	$campaignsarr = explode(',', $postvalues['fav_exist']);
                       $notification['campaigns']			=	$campaignsarr;
                     }
                   }
				}
				$notification['msg_pub_enable']		= 	1;				
				$notification['msg_type']			= 	$this->input->post('message_type');
				$notification['site_value']			= 	$this->input->post('site_vals'); 
				$notification['app_value']			= 	$this->input->post('app_vals'); 
				$notification['paymnt_value']		= 	$this->input->post('paymnt_val');
				$notification['adblock_value']		= 	$this->input->post('adb_val');
				$notification['account_settings']	= 	$this->input->post('account_settings');
				$notification['apps']	= 	$this->input->post('app_vals');
				
				$notification['news_enable']		= 	($this->input->post('campaign_notification'))?$this->input->post('campaign_notification'):'';
				$notification['news_type']			= 	($this->input->post('campaign_type'))?$this->input->post('campaign_type'):'';
				//$notification['campaigns']			=	$this->input->post('campaigns');
				$notification['adgate_news']		= 	$this->input->post('enable_adgatenews');
				$notification['login_secure']		= 	$this->input->post('login_secure');
				$ret = $this->do_publisher->notification_set_add($account_id,$notification);
			}
			else
			{ 
				$notification['msg_pub_enable']	= 	0;
				$notification['msg_type']		=	'';
				$notification['site_value']		= 	''; 
				$notification['paymnt_value']	= 	'';
				$notification['adblock_value']	= 	'';
				$notification['news_enable']	= 	'';
				$notification['news_type']		= 	'';
				$notification['campaigns']		=	'';
				$notification['adgate_news']		= 	$this->input->post('enable_adgatenews');	//'';
				$notification['login_secure']		= 	'';
				$ret = $this->do_publisher->notification_set_add($account_id,$notification);
			}
			
			/* Activity Log for Notification settings information - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,NOTIFICATION_SETTINGS);
				if($enable=='1')
				{							
				$this->activity_log(NOTIFICATION_SETTINGS,EDIT);
				}
			/* Activity Log for Notification settings information - End*/	
			
			if($ret)
			{
				$success 	= 	array('response'	=> 	'ok',
							   'msg'			=> 	'Settings successfully updated'
							);
		
				$this->response( $success, 200);
				
			}
			else
			{
				$error 	= 	array('response'	=> 	'failed',
							   'msg'			=> 	'Error! please try again..'
							);
		
				$this->response( $error, 200);
				 
			}
		 
	}
	
	function notification_value_get()
	{
		if($this->user_authentication->account_type=='TRAFFICKER')
		{
			$account_id 	= 	$this->user_authentication->account_id;
		}
		else
		{
			$account_id 	= 	$this->get('account_id');
		}
		$notify_list 	= 	$this->do_publisher->fetch_notification($account_id);
		
		if($notify_list)
		{
			$this->response($notify_list,200);
		}
		else
		{
			$this->response('error',200);
		}
		
		
	}
	
	function fetch_pubadgate_news_get()
	{
		if($this->user_authentication->account_type=='TRAFFICKER')
		{
			$account_id 	= 	$this->user_authentication->account_id;
		}
		else
		{
			$account_id 	= 	$this->get('account_id');
		}
		$notify_list 	= 	$this->do_publisher->fetch_pubadgate_news($account_id);
		
		if($notify_list)
		{
			$this->response($notify_list,200);
		}
		else
		{
			$this->response('error',200);
		}
		
		
	}
	
	function activity_log($module,$process,$pub_id=false)
	{
				/* Activity Log for EDIT setting information - Start*/				
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");	  						
				$account_id=$this->user_authentication->account_id;
				if($pub_id)
				{
					$publisher_id =	$pub_id;    
				}
				else
				{
					$publisher_id =	$this->user_authentication->affiliate_id;
				}
							
								
				$activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$user_agent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,
				"module"=>$module,
				"process"=>$process,
				"advertiser_id"=>'',
				"campaign_id"=>'',
				"banner_id"=>'',
				"publisher_id"=>$publisher_id,
				"site_id"=>'',
				"app_id"=>'',
				"adblock_id"=>'');				
																									
				//$this->do_app_config->activity_log($account_id,$activity_log);
				$this->redis_library->logcount($account_id,$activity_log);  
				/* Activity Log for edit settings information - End*/			
		
	}
	
	function activity_log_delete_get()
	{    
		$activity_id = $this->get('activity_id'); 
							
		if($activity_id)
		{
			$act_id	=	explode(',',$activity_id);
			
			if(is_array($act_id))
			{  
				foreach($act_id as $activity_id)
				{	
					if(is_numeric($activity_id))
					{   
						$id = $this->do_networks->delete_activity_log($activity_id);
					}
					else
					{   
						$this->redis_library->deletekey($activity_id);
					}
				}
				
				$success 	= 	array('response'	=> 	'ok',
									  'msg'			=> 	'Activity Log has been deleted successfully..'
							);
					
				$this->response( $success, 200);		
		
			}
			else
			{  
				
					if(is_numeric($activity_id))
					{  
					$id = $this->do_networks->delete_activity_log($activity_id);
					}
					else
					{  
						$this->redis_library->deletekey($activity_id);
					}
					
					$success 	= 	array('response'	=> 	'ok',
									  'msg'			=> 	'Activity Log has been deleted successfully..'
							);
					
					$this->response( $success, 200);		
		
				
			}					
		   	
		}
	
	}
	
	function get_publisher_get()
	{
		$data						= array();
		$data['country'] 			= $this->get('country');
		$data['revenue'] 			= $this->get('revenue');
		$data['payment_type'] 		= $this->get('payment_type');
		$data['impression_limit'] 	= $this->get('impression_limit');
		$data['click_limit'] 		= $this->get('click_limit');
		$data['conversion_limit'] 	= $this->get('conversion_limit');
		if($this->get('date_from'))
		{
		$data['date_from'] 			= $this->get('date_from');
		$data['date_to'] 			= $this->get('date_to');
		}
		else
		{
		$data['date_from'] 			= $this->get('default_date_from');
		$data['date_to'] 			= $this->get('default_date_to');
		}
		$data['creation_df'] 		= $this->get('creation_df');
		$data['creation_dt'] 		= $this->get('creation_dt');
		
		$data['last_hit_df'] 		= $this->get('last_hit_df');
		$data['last_hit_dt'] 		= $this->get('last_hit_dt');

		$data['last_sl_conv_df'] 	= $this->get('last_sl_conv_df');
		$data['last_sl_conv_dt'] 	= $this->get('last_sl_conv_dt');
						
		$data['sale_limit'] 		= $this->get('sale_limit');
		
		$data['acc_type'] 			= $this->get('acc_type');
		$data['adv_balance'] 		= $this->get('adv_balance');
	//	$data['state_val'] 			= $this->get('state_val');

		if($data['acc_type'] == '1')
		{	
			$success = $this->do_publisher->get_advertiser($data);
		}
		else 
		{
			
			$success = $this->do_publisher->get_publisher($data);
		}
	//$this->response($this->db->last_query(),200);
		if($success)
		{
			$this->response($success,200);
		}
		else
		{
			$this->response('error',200);
		}	
	}

public function  publisher_mass_import_post()
	{
		
		
		$file_id=$this->post('upload_name');	
		//$admarket = $this->post('admarket'); // val is 1 admarket val is 0 normal campaign import
		if($file_id!='')
		{
			$upload_extension = explode(".", $file_id);		
			
			if($upload_extension[1]=='csv')
			{
				
					$csvfilepath 	= $this->config->item('read_csv');	
					
					$file_name		= $this->getLatestFile($csvfilepath);
						
						$data = $this->csvreader->parse_file($file_name);
						

					
					$counter		= '1';	
					$ext_counter=1;
					$insert_rec=array();
					$exist_rec=array();
					$num_rows=count($data);	
						
					if($num_rows>0)
					{
						foreach($data as $row)
						{
							$account_id		=	get_session('account_id');
							
							if($row['agencyid']!='' && $row['email']!='' )
							{								 
									  	
							 $add_data		=	array(
									'first_name'		=>	trim($row['first_name']),
									'last_name'			=>	trim($row['last_name']),
									'email'				=>	trim($row['email']),
									'password'			=>	trim($row['password']),
									'budget'			=>	trim($row['budget']),
									'mob_no'			=>	trim($row['mob_no']),
									'skype_id'			=>	trim($row['skype_id']),
									//'additional_info'			=>	$this->post('additional_info'),
									'floor_price_enable'=>	trim($row['floor_price']),	
									'website'			=>	$row['site_url'],
									'account_type'		=>	'TRAFFICKER',
									'created_date'		=>	trim($row['created_date']),
									'security_id' 		=>	trim($row['security_id']),
									'security_answer'	=>	trim($row['security_answer']),
									'referral_share'	=>	trim($row['referral_share']),
									'active_referrals'	=>	trim($row['active_referrals']),	
									);
		
		 									
							
								if(!empty($add_data))
								{
											
									$result[]=	$this->do_publisher->add($add_data,$account_id);
								
										
										$insert_rec[] =$counter;
										
								}
								else
								{
										$exist_rec[]=$ext_counter;
								}
						$counter++;	
						$ext_counter++;						
						
					}
					else
					{
						$error = array('response'	=> 'error',
												// 'msg'		=> 'required fields are empty',
												// 'error_msg'=> $ex_count.' uploaded file(s) are already Exists !' 
												'msg'	 => 'The file contains invalid data for this operation..'
												 ); 
								$this->response($error,200);
					}
					
					}
						if(count($insert_rec)>0 && count($exist_rec) >0)
						{
								$ins_count = count($insert_rec);
								$ex_count= count($exist_rec);
								$success = array('response'	=> 'ok_error',
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												 'error_msg'=> $ex_count.' uploaded file(s) are already Exists !' ,
												  'id'		=>	$result
												 ); 
								$this->response($success,200);
						}
						else if(count($insert_rec)>0 && count($exist_rec)<=0)
						{
							
								$ins_count = count($insert_rec);
								$success = array('response'	=> 'ok',
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												 'id'		=>	$result
												 ); 
								$this->response($success,200);
						}
						else if(count($exist_rec) >0&& count($insert_rec)<=0)
						{
								$ex_count= count($exist_rec);
									$error = array(
										   'response' => 'error',
										   'msg' =>  $ex_count.' uploaded file(s) are already Exists ! '
										  );
									$this->response( $error, 200);
						}
					}
					else
					{
						$error = array(
									'response' => 'error',
									'redirect'=>site_url('admin/settings/mass_import'),
									'msg'	 => 'There is no data in the file!..'
									);
				  
						$this->response($error, 200);	
					}														
			}
			else
			{
				$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV file to upload!..'
							);
	  
				$this->response($error, 200);	
					
			}		
		}
		else
		{
			$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV file to upload!..'
						);
	  
			$this->response($error, 200);
		}		
		
						
	
		
	}
	function getLatestFile($directoryPath)
    {
        $directoryPath = rtrim($directoryPath, '/');
        
        $max = array(
            'path' => null,
            'timestamp' => 0
        );
        
        foreach (scandir($directoryPath, SCANDIR_SORT_NONE) as $file) {
            $path = $directoryPath . '/' . $file;
            if (!is_file($path)) {
                continue;
            }
            $timestamp = filemtime($path);
            if ($timestamp > $max['timestamp']) {
                $max['path']      = $path;
                $max['timestamp'] = $timestamp;
            }
        }
        
        return $max['path'];
    }

}
