<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Publisher Site related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Dinesh A
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Payments extends REST_Controller
{
	
	function __construct(){
		
		parent::__construct();
		$this->load->library('redis_library');
		$this->load->model('do_payments');
		$this->load->model('do_advertiser');
		$this->load->model('do_networks');
		$this->load->model('do_publisher');
		 
		$this->load->model('do_message');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->library('user_authentication');
		$this->load->library('notification');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }	

	}
	
	
	
	/**
       * 
       * name : add_fund_post()
       * 
       * Adds the advertiser fund to admin
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function add_fund_post(){
		 
		$this->form_validation->set_rules('amount','Amount', 'required|trim');
		
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
		   
		   //Get from library file
	        $account_id = $this->user_authentication->account_id;
	        
	        $acc_type = $this->user_authentication->account_type;
	        
	        $network_id	=	$this->user_authentication->network_account_id;					
			$agency_id	=	$this->user_authentication->agency_id;
			$result		=	$this->do_networks->agency_owner_details($agency_id);
			$admin_name    	= 	$result['name'];			
			$admin_email	= 	$result['email'];	
			$admin_id   	= 	$result['account_id'];
				
			$payment_id = $this->do_payments->add_fund(clean_data($this->post()),$account_id); 
			
			/* Activity Log for add payment - Start*/				
		
				$enable	=  	$this->default_configurations->activity_log_setting(PAYMENT,PAYMENT_REQ);
					if($enable=='1')
					{	
						$this->activity_log(PAYMENT,ADD);
					}
				/* Activity Log for add payment - End*/	
			//Get advertiser details
			$advertiser_details=$this->do_advertiser->get_user_information(clean_data($this->post('account_id'))); 
			$advertiser_info=$advertiser_details[0];
			$added_amount=clean_data($this->post('amount'));
			$currency=clean_data($this->post('currency'));
			$wallet_amt = $this->do_payments->get_wallet_bal($this->post('account_id'));
			
			/* Payment Activity*/
			$update_amount = array(
							"amount"=>$this->post('amount'),
							"wallet_total"=>$wallet_amt,
							);
			
			$this->pay_activity_log(PAYMENT,'WIRE',$update_amount);
			
			/* SMS /Emali /BackupCode verify */	
			$message  = $this->default_configurations->get('message_type');					
			$security_details=$this->do_advertiser->get_security($account_id);			
			$security_option=$security_details[0]['payment_security'];			
			if($security_option=='1')
			{
				
			}
			else if($security_option=='2')
			{
				$user = $this->do_message->get_profile($admin_id);
				$from=$admin_email;
				$to=$security_details[0]['payment_email'];
				$user_name     = $advertiser_info['dj_first_name']." ".$advertiser_info['dj_last_name'];
				$type_details		=	array(
					'msg_type'		=> $message,
					'type'			=> "ADV_VERIFICATION_EMAIL",
					'string'		=> "payment",
					'column_name'	=> "Payment Verification");
			    $mail_content=array(
					"subject" 		=> "Verification Email",
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $to,
					"account_id"    => $account_id,
					"verification_id"=> $payment_id
					);
				$message_data		=	array(
												'sender_id'		=>	$admin_id,
												'receiver_id'	=>	$account_id,
												'subject'		=>	'Verification Mail',
												'content'		=>	'Congrats.',
												'image_name'	=>	NULL,
												'file_name'		=>	NULL,
												'account_type'	=>	$acc_type,
												'notification_type'	=>	"payment_setting",	
												'status'		=>	'1',
												'network_id'	=>	$network_id,									
												'date'			=>	date('Y-m-d H:i:s')
												);	
						
			$email = $this->notification->new_mail($message_data,$user,$advertiser_info,$type_details,$mail_content);				
				
			}
			else if($security_option=='3' || $security_option=='')
			{
				$payment_question=$this->do_advertiser->get_security($account_id);
				if($payment_question[0]['payment_security_question_id'])
				{
					$qus_id=$payment_question[0]['payment_security_question_id'];
					$question=$this->do_advertiser->get_question($qus_id);
					$qus=$question[0]['question'];
					$this->response($qus, 200);
				}				
			}
			
			
		    //Sending mail to advertiser for adding fund
								
			/* GET ADMIN EMAIL ID FOR bcc */
			$network_admin=$this->do_networks->get_network_details();
			$bcc		   = $network_admin['email'];
			
			if($acc_type=='ADVERTISER')
			{
				$type_details		=	array(
					'msg_type'		=> $message,
					'type'			=> "ADV_ADD_FUND_EMAIL",
					'string'		=> "payment_add",
					'column_name'	=> "payments");  
				
				$user_email    = $advertiser_info['email'];
				$amount        = $added_amount;
				$user_name     = $advertiser_info['dj_first_name']." ".$advertiser_info['dj_last_name'];
				$type     ="ADV_ADD_FUND_EMAIL";
				$from 	=  $admin_email;
				$to  	=  $user_email;			
				/*$mail_content=array(
					"subject" 		=> "Add Fund Information",
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email,
					"added_amount"  => $amount,
					"currency"      => $currency								
					);*/
					
				/* CHECK ADMIN EMAIL AND BCC EMAIL ARE SAME */				
				$bcc=($bcc!=$admin_email)?$bcc:'';	
				$attachement='';	
				
				$user = $this->do_message->get_profile($admin_id);
				
				$message_data		=	array(
												'sender_id'		=>	$admin_id,
												'receiver_id'	=>	$account_id,
												'subject'		=>	'Add Fund Information',
												'content'		=>	'Congrats! You have added  $'.$amount.' successfully.The added fund is waiting for admin approval. ',
												'image_name'	=>	NULL,
												'file_name'		=>	NULL,
												'account_type'	=>	$acc_type,
												'notification_type'	=>	"payment_setting",	
												'status'		=>	'1',
												'network_id'	=>	$network_id,									
												'date'			=>	date('Y-m-d H:i:s')
												);
												
												
					$notification_value ='payment_add';
					$notification_msg = $this->do_message->get_notification_msg($notification_value);   
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
						
					$searchStr=$this->config->item('macros');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}
										
					if($count>0)
					{	
					$amount=$this->post('amount');
					$msg = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{advertiser_name}}",$user_name,$msg);	
					$msg = str_replace("{{amount}}",$amount,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'">Login</a>' ,$msg);
					$mail_content = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('click_directADS').'</a>' ,$msg);		  			
					}  
					else
					{
						$mail_content=$notification_content;
					}	
					
					$dat = $this->notification->pub_notification_mail($message_data,$user,$advertiser_info,$type_details,$mail_content);		
							
					//$dd = $this->notification->new_mail($message_data,$user,$advertiser_info,$type_details,$mail_content);
			}
					
			$success = array(
									'response' => 'ok',
									'msg'	 => 'Amount has been funded successfully and payment is waiting for approval'
					);
			$this->response( $success, 200);
		}
	}
	
		/**
       * 
       * name : make_payment_post()
       * 
       * Makes the payment for publisher and update the invoice table
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function make_payment_post(){
		
		$invoice_id = clean_data($this->post('invoice_id'));
		
		if($invoice_id)
		{
			$payment_details = $this->do_payments->make_payment(clean_data($this->post()));
			if(!empty($payment_details) && $payment_details=='update_payment_detail')
			{
				$error = array('response'=>'error',
								'msg'=>'Update payment type in payment settings'
						);
						$this->response( $error, 200);
			}
			
			else if(!empty($payment_details))
			{
				$invoice_details = $payment_details['invoice'];
				$account_details = $payment_details['account'];
				
				//SEND AN EMAIL DETAILS REGARDING PAYMENT
				
				$success = array(
									'response' 	=> 	'ok',
									'amount'	=> 	' '.html_entity_decode($this->config->item("currency"),ENT_QUOTES).''.$invoice_details['amount'],
									'name'		=>	ucfirst($invoice_details['name']),
									'msg'	 	=> 	'Amount <b>'.html_entity_decode($this->config->item("currency"),ENT_QUOTES).''.$invoice_details['amount'].'</b> has been successfully paid to <b>'.ucfirst($invoice_details['name']).'</b>'
					);
				$this->response( $success, 200);
			}else{
				$error = array('response'=>'error',
								'msg'=>'Problem with payment'
						);
			}
		}else{
			
			$error = array(
									'response' => 'error',
									'msg'	 => 'Not an valid invoice id'
					);
				$this->response( $error, 200);
		}
	}
	
	/*
     * 
     * name : fetch_campaign_invoice_list()
     * 
     * param: none
     * 
     * @return get the details history for all campaign invoices
    */
	public function fetch_campaign_invoice_list_get()
	{
		$campaign_id = $this->get('campaign_id');
	     //to fetch and list all publisher invoice details in admin panel
		$invoice_list=$this->do_payments->fetch_campaign_invoice_list($campaign_id);
	    $this->response($invoice_list); 
	  
	}
	
	/*
    * 
    * name : fetch_publisher_invoice_list_get()
    * 
    * param: none
    * 
    * @return get the details history for all publisher invoices
    */
    
	public function fetch_publisher_invoice_list_get()
	{
		$filter	=	clean_data($this->get('filter'));
		
	   //Get from library file
	   if($this->user_authentication->account_type=='TRAFFICKER'){
		   $account_id = $this->user_authentication->account_id;
		  }
		  
	   if($account_id!='')
	   {
	   //to fetch and list all publisher invoice details in publisher panel
	    $pub_invoice_list=$this->do_payments->fetch_publisher_invoice_list($account_id,$filter);
	    $this->response($pub_invoice_list); 
	   }
	   else
	   {
	     //to fetch and list all publisher invoice details in admin panel
		$pub_invoice_list=$this->do_payments->fetch_publisher_invoice_list('',$filter);
	    $this->response($pub_invoice_list); 
	   }
	}
	
	/*
    * 
    * name : fetch_referral_invoice_list_get()
    * 
    * param: none
    * 
    * @return get the details history for all publisher invoices
    */
    
	public function fetch_referral_invoice_list_get()
	{
		$filter	=	clean_data($this->get('filter'));
		
	   //Get from library file
		if($this->user_authentication->account_type=='TRAFFICKER'){
			$account_id = $this->user_authentication->account_id;
		}
		  
		if($account_id!='')
		{
			//to fetch and list all publisher invoice details in publisher panel
			$ref_invoice_list	=	$this->do_payments->fetch_referral_invoice_list($account_id,$filter);			
		}
		else
		{
			//to fetch and list all publisher invoice details in admin panel
			$ref_invoice_list	=	$this->do_payments->fetch_referral_invoice_list('',$filter);			
		}
		$this->response($ref_invoice_list); 
	}
	
	/*
     * 
     * name : publisher_invoice_item_get()
     * 
     * param: none
     * 
     * @return get the details of publisher invoice item
    */
	public function publisher_invoice_item_get()
    {
	   $invoice_id=$this->get('id'); 
	   $pub_invoice_item=$this->do_payments->fetch_publisher_invoice_item($invoice_id);
	   $this->response($pub_invoice_item); 
	}
	
	/*
     * 
     * name : fetch_advertiser_payment_get()
     * 
     * param: none
     * 
     * @return get the details of advertiser detailed payments
    */
	 
	 public function fetch_advertiser_payment_get()
	{
	   //Get from library file
	   $account_id = $this->user_authentication->account_id;
	   $adv_pay_item=$this->do_payments->fetch_advertiser_payment($account_id);
	   $this->response($adv_pay_item); 
	}
	
	/*
     * 
     * name : fetch_advertiser_date_wise_payment_post()
     * 
     * param: month,year,accounid
     * 
     * @return get the details of advertiser detailed payments
    */
	 public function fetch_advertiser_date_wise_payment_post()
	{
	   //Get from library file
	   $account_id = $this->user_authentication->account_id;
	   $month=clean_data($this->post('month'));
	   $year=clean_data($this->post('year'));
	   $adv_pay_item=$this->do_payments->fetch_advertiser_date_wise_payment($month,$year,$account_id);
	   $this->response($adv_pay_item); 
	   
	}
	
	 /* 
     * 
     * name : fetch_publisher_payment_history_get()
     * 
     * param: accounid
     * 
     * @return get the details of publisher detailed payments
    */
	 public function fetch_publisher_payment_history_get()
	{ 
	    //Get from library file
	   $account_id = $this->user_authentication->account_id;
	   $filter	=	$this->get('filter');
	   $pub_pay_item=$this->do_payments->fetch_publisher_invoice_payment_list($account_id,$filter);
	 //   log_message('error','payment');
	 //  log_message('error',$this->db->last_query());
	   $this->response($pub_pay_item); 
	}

	
   /*
     * 
     * name : fetch_pub_date_wise_payment()
     * 
     * param: month,year,accounid
     * 
     * @return get the details of publisher detailed payments history
    */
	public function fetch_pub_date_wise_payment_post()
	{
	   //Get from library file
	   $account_id = $this->user_authentication->account_id;
	   $month	=	clean_data($this->post('month'));
	   $year	=	clean_data($this->post('year'));
	   $filter	=	clean_data($this->post('filter'));
	   $order	=	$this->convert_sorting_data($filter['order']);
	   $pub_pay_history=$this->do_payments->fetch_pub_date_wise_payment($month,$year,$account_id,$filter,$order);
	   $this->response($pub_pay_history); 
	}
	
	 /*
     * ADMIN PANEL
     * name : list_publisher_payment_details()
     * 
     * param: month,year,accounid
     * 
     * @return get the details of advertiser detailed payments history
    */
	public function list_advertiser_payment_details_get()
	{
	   //Get from library file
	   $agencyid = $this->user_authentication->agency_id;
	   $advertiser_history=$this->do_payments->advertiser_payment_history($agencyid);
	   $this->response($advertiser_history);
	}
    
     /*
     * ADMIN PANEL
     * name : list_publisher_payment_details()
     * 
     * param: month,year,accounid
     * 
     * @return get the details of advertiser detailed payments history
    */
	public function list_advertiser_payment_date_wise_post()
	{
	   $month=clean_data($this->post('month'));
	   $year=clean_data($this->post('year'));
	   $account_id=clean_data($this->post('account_id'));
	   $adv_datewise_history=$this->do_payments->fetch_advertiser_date_wise_payment_history($month,$year,$account_id);
	   $this->response($adv_datewise_history); 
	}
	
	 /*
     * ADMIN PANEL
     * name : list_publisher_payment_history_get()
     * 
     * param:none
     * 
     * @return get the details of advertiser detailed payments history
    */
	public function list_publisher_payment_history_get()
	{
	   //Get from library file
	   $agencyid = $this->user_authentication->agency_id;
	   $publisher_history=$this->do_payments->publisher_payment_history($agencyid);
	   $this->response($publisher_history);
	}
	
	 /*
     * ADMIN PANEL
     * name : list_publisher_payment_date_wise()
     * 
     * param:month,year,accountid
     * 
     * @return get the details of publisher detailed payments history
    */
	public function list_publisher_payment_date_wise_post()
	{
	   $month=		clean_data($this->post('month'));
	   $year=		clean_data($this->post('year'));
	   $account_id=	clean_data($this->post('account_id'));
	   $pub_datewise_history=$this->do_payments->fetch_publisher_date_wise_payment_history($month,$year,$account_id);
	   $this->response($pub_datewise_history); 
	}
	
	/*
     * ADMIN PANEL
     * name : fetch_admin_payment_history_get()
     * 
     * param:none
     * 
     * @return: credit & debit payment details
    */
	public function fetch_admin_payment_history_get()
	{
	    //Get from library file
	   $agencyid = $this->user_authentication->agency_id;
	   $admin_pay_history=$this->do_payments->fetch_admin_payment_history($agencyid);
	   $this->response($admin_pay_history); 
	}
	
	/*
     * ADMIN PANEL
     * name : reject_publisher_invoice_amount_get()
     * 
     * param:invoice_id
     * 
     * @return: send mail to the pub and return reject success msg
    */
	public function reject_publisher_invoice_amount_get()
	{
	    $invoice_id=$this->get('invoice_id');
	    $rejected_acc_id=$this->do_payments->reject_invoice_payment($invoice_id);
		if($rejected_acc_id)
		    $publisher_details=$this->do_publisher->get_profile($rejected_acc_id);
		    //Get admin details
			$result=$this->do_networks->get_network_details();			
			$admin_name    = $result['firstname']." ".$result['lastname'];			
			$admin_email   = $result['email'];
			$user_email    = $publisher_details['email'];
			$user_name     = $publisher_details['first_name']." ".$publisher_details['last_name'];
			$type     	   = "PUB_PAY_REJECTED";
			$from 		   = $admin_email;
			$to  		   =  $user_email;			
			$mail_content=array(
				"subject" 		=> "Your Invoice Payment",
				"to_name" 		=> $user_name,				
				"from_name"		=> $admin_name,
				"email"  		=> $user_email,
			 );
		   $attachement='';	
		   send_mail($type,$from,$to,$mail_content,$attachement,$from); 
		   $success = array(
							'response' => 'ok',
							'msg'	 => 'Invoice payment rejected successfully!..' );
		   $this->response($success, 200);

	}
	
	/*
     * ADVERTISER PANEL
     * name : fetch_deposit_amount_list_get()
     * 
     * param:none
     * 
     * @return: credit advertiser payment details
    */
    public function fetch_deposit_amount_list_get()
    {
		$filter	=	clean_data($this->get('filter'));
		//Get from library file
		$account_id = $this->user_authentication->account_id;
		$payment_list =$this->do_payments->fetch_deposit_list($account_id,$filter); 
		$this->response($payment_list,200);
	}
	
	    public function fetch_monthly_deposit_amount_list_get()
    {
		//Get from library file
		$date=$this->get('date');
		$account_id = $this->user_authentication->account_id;
		$payment_list =$this->do_payments->fetch_monthly_deposit_list($account_id,$date); 
		$this->response($payment_list,200);
	}
	/*
     * ADMIN PANEL
     * name : fetch_advertiser_deposit_amount_list_get()
     * 
     * param:none
     * 
     * @return: credit advertiser payment details
    */
	public function fetch_advertiser_deposit_amount_list_get()
	{  
		$filter	=	clean_data($this->get('filter'));
		
		//Get from library file
		$agency_id 		= 	$this->user_authentication->agency_id;
		$payment_list 	=	$this->do_payments->fetch_adv_deposit_list($agency_id,$filter); 
		$this->response($payment_list,200);
	}
        
    /*
     * ADMIN PANEL
     * name : advertiser_billing_details_get()
     * 
     * param:none
     * 
     * @return: credit advertiser payment details
    */
    public function advertiser_billing_details_get()
    {
		$b_id=$this->get('billing_id'); 
		$bill_details = $this->do_payments->fetch_billing_details($b_id);
		
		$this->response($bill_details,200);	
	}
	
	/*
     * ADMIN PANEL
     * name : admin_revenue_list_get()
     * 
     * param:none
     * 
     * @return: return month wise revenue details
    */
	public function admin_revenue_list_get()
	{
	   //Get from library file
	    $agency_id = $this->user_authentication->agency_id;
		$revenue_details = $this->do_payments->fetch_admin_revenue_details($agency_id);
		$this->response($revenue_details,200);	
	}
	
	/*
     * ADMIN PANEL
     * name : admin_revenue_list_date_wise_get()
     * 
     * param:none
     * 
     * @return: return date wise revenue details
    */
	public function admin_revenue_list_date_wise_get()    
	{
	    $month=$this->get('month'); 
		$year=$this->get('year'); 
	    $agency_id=$this->get('agency_id'); 
		$revenue_details = $this->do_payments->fetch_admin_revenue_details_date_wise($month,$year,$agency_id);
		$this->response($revenue_details,200);	
	}
	
	/***********************************************/
	/*			Manual Invoice For Publisher       */
	/***********************************************/
	
	public function add_payout_post()
	{
		$account_id	= 	$this->user_authentication->account_id;
	   
	    if($account_id)
	    {
			$amount	=	clean_data($this->post('amount'));
			$gateway	=	clean_data($this->post('gateway'));
			$res = $this->do_invoices->request_invoices($account_id,$amount,$gateway);
		 
			if($res !== FALSE){
				$success = array(
								'response' 	=> 	'ok',
								'msg'	 	=> 	'Invoice has generated Successfully..'
							);
			 
							
				$account_id = 	$this->user_authentication->account_id;
				$account_type	=	$this->user_authentication->account_type;	
				$network_id	=	$this->user_authentication->network_account_id;					
				$agency_id	=	$this->user_authentication->agency_id;
				$result		=	$this->do_networks->agency_owner_details($agency_id);
				$admin_name    	= 	$result['name'];			
				$admin_email	= 	$result['email'];	
				$admin_id   	= 	$result['account_id'];
				
				/* Activity Log for Add Payout - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(PAYMENT,PAYMENT_PUB_REQ);
				if($enable=='1')
				{		
				$this->activity_log(PAYMENT,REQUEST);
				}
				/* Activity Log for Add Payout- End*/		
				
					 
				if($account_type=='TRAFFICKER')
				{
					$affiliate_id	=	$this->user_authentication->affiliate_id;
					$reciever = $this->do_message->get_affiliate($affiliate_id); 
			 
					$user = $this->do_message->get_profile($admin_id);
					
					$mail_type = "PAYMENT_REQUEST";
					$acc_type='TRAFFICKER';
					
					$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "PAYMENT_REQUEST",
						'string'		=> 'payout_settings',
						'column_name'	=> 'payments'
						);
						
					$message_data		=	array(
						'sender_id'		=>	$admin_id,
						'receiver_id'	=>	$account_id,
						'subject'		=>	'Publisher - Payment',
						'content'		=> 	'Payment request received successfully',
						'image_name'	=>	NULL,
						'file_name'		=>	NULL,
						'account_type'	=>	"TRAFFICKER",
						'notification_type'	=>	"payment_setting",	
						'status'		=>	'1',
						'network_id'	=>	$network_id,									
						'date'			=>	date('Y-m-d H:i:s')
						);
						
														
					$user_email    =	$reciever['email'];
					$user_name     =	$reciever['name'];
					$from 		   = 	$admin_email;
					$to  		   = 	$user_email;		
											
					/*$mail_content=array(
							"subject" 	   => "Payment request",
							"to_name" 	   => $user_name,				
							"from_name"	   => $admin_name,
							"req_amount"   => $this->post('amount')
							 
						);*/
						
					$attachement='';					
						
					//$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);
					
					$notification_value ='pay_request';
					$notification_msg = $this->do_message->get_notification_msg($notification_value);   
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
						
					$searchStr=$this->config->item('macros');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}
										
					if($count>0)
					{	
					$amount=$this->post('amount');
					$msg = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{publisher_name}}",$reciever['name'],$msg);	
					$msg = str_replace("{{amount}}",$amount,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'">Login</a>' ,$msg);
					$mail_content = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.base_url().'">Click here to Adgate</a>' ,$msg);		  			
					}  
					else
					{
						$mail_content=$notification_content;
					}	
					
					$dat = $this->notification->pub_notification_mail($message_data,$user,$reciever,$type_details,$mail_content);			
					
				}
				$this->response($success,200); 
			}
			else
			{
				$error 	= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	array('amount'=>'Request amount should not be greater than earnings.')
							);
				$this->response($error,200); 
			}
		}
		else
		{
	   		$error 	= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Invalid Request!..'
							);
			$this->response($error,200); 
		}	   
	}
	
	/*
     * Publisher PANEL
     * name : fetch_network_details_get()
     * 
     * param:none
     * 
     * @return: credit advertiser payment details
    */
    public function fetch_network_details_get()
    {
		$network 	=	$this->do_payments->get_network_details();
		
		$this->response($network,200);
	}
	 
	 /*
     * Publisher PANEL
     * name : fetch_publisher_details_get()
     * 
     * param:none
     * 
     * @return: credit advertiser payment details
    */
    public function fetch_publisher_details_get()
    {
		$id = $this->get('id');
		
		if($id!='' || $id!=FALSE)
		{
			$account_id = $id;
		}
		else
		{
			$account_id = $this->user_authentication->account_id;
		}
		
		$network 	=	$this->do_payments->get_publisher_details($account_id);
		
		$this->response($network,200);
	}
	/*
	 * 
	 * name: invoice_viewmore
	 * @param : campaign_id
	 * @return : Selected invoice info list
     */
	 public function invoice_viewmore_get()
	 {
	    $invoice_code = $this->get('invoice_code');
	   
		$invoice_details =$this->do_payments->fetch_campaign_individual_invoice($invoice_code); 
		$this->response($invoice_details);
	 }
	 
	function add_advertiser_fund_get()
	{		
		$pay_data	=	$this->get('pay_data');
		
		if (!empty($pay_data))
		{ 
			$last_order_id 	= 	$this->do_payments->insert_paypal_order($pay_data);
			
			$fund_details 	= 	array('account_id'	=>	$pay_data['account_id'],

									  'payer_id' 	=>	$this->get('payer_id'),

									  'amount'		=>	$pay_data['payment_gross'],

									  'currency'	=>	$pay_data['mc_currency']

									);
									
			if($pay_data['payment_type']=='3')
			{									
				$fund_details['payment_type']	=	'webmoney';
			}
			elseif($pay_data['payment_type']=='4')
			{									
				$fund_details['payment_type']	=	'bitcoin';
			}
			elseif($pay_data['payment_type']=='5')
			{									
				$fund_details['payment_type']	=	'authorize';
				$fund_details['api_signature']	=	$this->get('payer_key');
			}

			$payment_id 	= 	$this->do_payments->add_fund($fund_details,$pay_data['account_id']);

			//Updates the Admin apporval and also adds the balance for advertiser
			if($payment_id)
			{
				$this->do_payments->payment_approve($payment_id,$pay_data['payment_gross'],$pay_data['account_id']);
			}

			//$this->mod_payments->insert_paypal_fund($advertiser,$payment_gross);

			if(!empty($last_order_id))
			{

				//SENDS THE EMAIL FOR ADVERTISER AND ADMIN

				$payer_name  	= 	$pay_data['first_name'];

				$payer_email	= 	$pay_data['payer_email'] . ' on '.date('m/d/Y') . ' at ' . date('g:i A') . "\n\n";                     

				$data['payment_gross'] 	= 	$pay_data['payment_gross'];

				$data['payment_status']	= 	$pay_data['payment_status'];

				$data['payment_date'] 	= 	$pay_data['payment_date'];

				$data['txn_id']			= 	$pay_data['txn_id'];

				$data['ipn_track_id'] 	= 	$pay_data['ipn_track_id'];

				$data['payer_name']		= 	$payer_name;

				$data['payer_email']	= 	$payer_email;

				//Get advertiser details

				$advertiser_details		=	$this->do_advertiser->get_user_information($pay_data['account_id']); 

				$advertiser_info		=	$advertiser_details[0];

				//Get admin details

				$result					=	$this->do_networks->get_network_details();			

				$admin_name    			= 	$result['firstname']." ".$result['lastname'];			

				$admin_email   			= 	$result['email'];

				$user_email    			= 	$advertiser_info['email'];

				$user_name     			= 	$advertiser_info['dj_first_name']." ".$advertiser_info['dj_last_name'];

				$type   =	"ADV_PAYPAL_ADD_FUND_EMAIL";

				$from 	=  	$admin_email;

				$to  	=  	$user_email;			

				/*$mail_content	=	array(

										"subject" 		=> "Add ".ucfirst($fund_details['payment_type'])." Fund Information",

										"to_name" 		=> $user_name,				

										"from_name"		=> $admin_name,

										"email"  		=> $user_email,

										"added_amount"  => $data['payment_gross'],

										"currency"      => $this->config->item('currency')								

									);*/

				$attachement	=	'';	
				
				$account_id = $this->user_authentication->account_id;
	        
				$acc_type = $this->user_authentication->account_type;
				
				$network_id	=	$this->user_authentication->network_account_id;					
				$agency_id	=	$this->user_authentication->agency_id;
				$result		=	$this->do_networks->agency_owner_details($agency_id);
				$admin_name    	= 	$result['name'];			
				$admin_email	= 	$result['email'];	
				$admin_id   	= 	$result['account_id'];
				$amount=$pay_data['mc_currency'];
				
				$type_details		=	array(
					'msg_type'		=> $message,
					'type'			=> "ADV_ADD_FUND_EMAIL",
					'string'		=> "payment_add",
					'column_name'	=> "payments");  
								
				$user = $this->do_message->get_profile($admin_id);
				
				$message_data		=	array(
												'sender_id'		=>	$admin_id,
												'receiver_id'	=>	$account_id,
												'subject'		=>	'Add Fund Information',
												'content'		=>	'Congrats! You have added  $'.$amount.' successfully.The added fund is waiting for admin approval. ',
												'image_name'	=>	NULL,
												'file_name'		=>	NULL,
												'account_type'	=>	$acc_type,
												'notification_type'	=>	"payment_setting",	
												'status'		=>	'1',
												'network_id'	=>	$network_id,									
												'date'			=>	date('Y-m-d H:i:s')
												);
																							
					$notification_value ='payment_add';
					$notification_msg = $this->do_message->get_notification_msg($notification_value);   
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
					//$this->pay_activity_log(PAYMENT,strtoupper($fund_details['payment_type']),$amount);	
					$searchStr=$this->config->item('macros');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}
										
					if($count>0)
					{	
					$amount=$this->post('amount');
					$msg = str_replace("{{Product_name}}",'<a  style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{advertiser_name}}",$user_name,$msg);	
					$msg = str_replace("{{amount}}",$amount,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'">Login</a>' ,$msg);
					$mail_content = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.base_url().'">Click here to Adgate</a>' ,$msg);		  			
					}  
					else
					{
						$mail_content=$notification_content;
					}	
					
					$dat = $this->notification->pub_notification_mail($message_data,$user,$advertiser_info,$type_details,$mail_content);		
				
				
				
				//send_mail($type,$from,$to,$mail_content,$attachement,$from);

			}

		}

	}
	
	/*
	 * name: convert_sorting_data
	 * @param :
	 * @return : $output or false
	 * 
	 * convert data into order by array
	 */
	function convert_sorting_data($request_data = FALSE)
	{
		if($request_data)
		{
			if ( isset( $request_data['iSortCol_0'] ) )
			{
				//Initialize order by array
				$sorting_order = array();
				
				for ( $i=0 ; $i<intval( $request_data['iSortingCols'] ) ; $i++ )
				{
					if ( $request_data[ 'bSortable_'.intval($request_data['iSortCol_'.$i]) ] == "true" )
					{
						$sorting_order[$request_data[ 'mDataProp_'.intval($request_data['iSortCol_'.$i]) ]] = $request_data[ 'sSortDir_'.$i];	
					}
				}
				return $sorting_order;	
			}else{
				return FALSE;	
			}
		}else{
			return FALSE;	
		}		
	}
	
	function activity_log($module,$process)
	{
				/* Activity Log for Add/Edit/Delete site - Start*/				
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");							
				$account_id=$this->user_authentication->account_id;
				$publisher_id=$this->user_authentication->affiliate_id;
				$module=$module;
				$process=$process;				
								
				$activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$user_agent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,
				"module"=>$module,
				"process"=>$process,
				"advertiser_id"=>'',
				"campaign_id"=>'',
				"banner_id"=>'',
				"publisher_id"=>$publisher_id,
				"site_id"=>'',
				"app_id"=>'',
				"adblock_id"=>'');

				$this->redis_library->logcount($account_id,$activity_log);  
				//$this->do_app_config->activity_log($account_id,$activity_log);
				/* Activity Log for Add/edit/Delete site - End*/			
		
	}
	function pay_activity_log($module,$process,$amount=FALSE,$details=FALSE)
	{
				/* Activity Log for Add/Edit/Delete site - Start*/				
				$user_agent=($this->user_authentication->user_agent)?$this->user_authentication->user_agent:'Unknown';
				$browser=($this->user_authentication->browser)?$this->user_authentication->browser:'Unknown';
				$os=($this->user_authentication->os)?$this->user_authentication->os:'Unknown OS';
				//~ $ip=$_SERVER['REMOTE_ADDR'];
				$ip=$this->get_client_ip_server();
				$date=date("Y-m-d H:i:s");							
				$account_id=$this->user_authentication->account_id;
				$publisher_id=$this->user_authentication->affiliate_id;
				$module=$module;
				$process=$process;				
			 
				$payment_activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$user_agent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,				 
			//	"amount"=>$amount,				 
				"transfer_path"=>$process);   
				if($details){				
				 
					foreach($details as $key => $campid)
					{    
						$payment_activity_log["campaign_id"]= $campid['campaignid'];   
						$payment_activity_log["campaign_budget"]= $campid['dj_campaign_budget'];   
						$payment_activity_log["wallet"]= $campid['camp_reserve'];   
						$payment_activity_log["amount"]= $campid['amount'];   
						$payment_activity_log["campaign_remain"]= ($campid['campaign_remain'])?$campid['campaign_remain']:'0';   
						//print_r($campid['camp_reserve']);exit;
						$this->do_app_config->payment_activity_log($account_id,$payment_activity_log);  //  DAC094 15/05/2018
					}
				}
				else
				{
					$payment_activity_log["amount"]= $amount['amount'];
					$payment_activity_log["wallet"]= ($amount['wallet_total'])?$amount['wallet_total']:$this->do_payments->get_wallet_bal($account_id);
					// print_r($payment_activity_log);exit;   
					$this->do_app_config->payment_activity_log($account_id,$payment_activity_log);
				}
				 
				
				
				/* Activity Log for Add/edit/Delete site - End*/			
		
	}
	
	/*****************Wallet*****************************/
	function wallet_fund_campaign_post()
	{
		
		$account_id = $this->user_authentication->account_id;
		
		$campaign_ids= $this->post('campaigns');
		$amount= $this->post('amount');
		
		if($campaign_ids && ($campaign_ids!= 'active' || $campaign_ids!= 'inactive' || $campaign_ids!='all'))
		{
			$camp_ids= implode(',',$campaign_ids); 
		}
		elseif($campaign_ids== 'active'){$camp_ids= $campaign_ids;}
		elseif($campaign_ids== 'inactive'){$camp_ids= $campaign_ids;}
		elseif($campaign_ids== 'all'){$camp_ids= $campaign_ids;}
		
			
		//Check wallet balance of advertiser	
		$balance_amount = $this->do_payments->get_wallet_bal($account_id);	
		// Count of campaigns
		$check_camps = $this->do_payments->get_camp_count($account_id,$campaign_ids);		
		$compare_amt=$check_camps * $amount; 
		if($compare_amt > $balance_amount)
		{
			$error = array(
						'response' => 'error',
						'msg'	 => "Wallet's amount is insufficient to make a transfer",
						 
					);
			$this->response( $error, 200);
		}
		$deducted_amt= $balance_amount - $compare_amt;

		//~ else
		//~ {
			//~ $this->response( $compare_amt, 200);
			//~ 
		//~ }
		$camp_curr_fund = $this->do_payments->wallet_to_campaign($account_id,$campaign_ids);
		$added_amount=$camp_curr_fund;
		$added_amount_log=$camp_curr_fund;
		$updated_balance_amount=$balance_amount;
		foreach($camp_curr_fund as $key=>$funds)
		{
			$added_amount[$key]['dj_campaign_budget'] = $funds['dj_campaign_budget']+$amount;
			$added_amount[$key]['wcamp_remain'] = $funds['wcamp_remain']+$amount;
			$updated_balance_amount=$updated_balance_amount- $amount;
			$added_amount_log[$key]['funds'] = $funds['dj_campaign_budget'];
			$added_amount_log[$key]['dj_campaign_budget'] = $funds['dj_campaign_budget']+$amount;			 
			$added_amount_log[$key]['camp_reserve'] = $updated_balance_amount;
			$added_amount_log[$key]['amount'] = $amount;
			$added_amount_log[$key]['campaign_remain'] = $funds['dj_campaign_budget']+$amount-$funds['wcamp_remain']; 
		}
		 
		 
		$update_fund=$this->do_payments->campaign_fund_update($added_amount,$account_id,$deducted_amt);
		if($update_fund)
		{  
			$this->pay_activity_log(PAYMENT,WTRANS,$amount,$added_amount_log);
			$success = array(
							'response' => 'ok',
							'msg'	 => 'Amount has been added successfully',
							'deducted_amt'=>$deducted_amt,
						);
			$this->response( $success, 200);
		}
		else
		{
			$error = array(
						'response' => 'error',
						'msg'	 => "Try again later",
						 
					);
			$this->response( $error, 200);
		}
	}
	
	function campaign_fund_wallet_post()
	{
		$account_id = $this->user_authentication->account_id;
		$client_id = $this->user_authentication->client_id;
		 
		 
		//~ $campaign_ids = 'all';
		$campaign_ids = $this->post('campaigns');
		$check_camps = $this->do_payments->get_camp_count($account_id,$campaign_ids);		
		
		$adv_camp_amt= $this->do_payments->get_advcamp_fund($account_id); 
		
		$new_arr= array('amount'=>0);
		$campaign_update= array();
		$i=0;
		$wallet_amt = $this->do_payments->get_wallet_bal($account_id);
		$updated_wallet= $wallet_amt;
		 
		foreach($adv_camp_amt as $key =>$value)
		{
			if(in_array($value['campaignid'],$campaign_ids)) 
			{ 
				$new_arr['amount']=$new_arr['amount']+$value['remain_amt'];
				$campaign_update[$i]['campaignid']=$value['campaignid'];
				$campaign_update[$i]['camp_reserve']='0';
				
				$updated_wallet=$updated_wallet+ $value['remain_amt'];
				
				$campaign_update[$i]['camp_reserve']=$updated_wallet;
				$campaign_update[$i]['amount']=$value['remain_amt'];
				$campaign_update[$i++]['dj_campaign_budget']='0';
			}		
		}	
		$payment_refund =  $new_arr['amount'];
	 
		//$wallet_amt = $this->do_payments->get_wallet_bal($account_id);
		$new_arr['amount']=$new_arr['amount']+$wallet_amt; 
		$campaign_ids = implode(',',$campaign_ids);
		$enable	=  	$this->default_configurations->activity_log_setting(PAYMENT,PAYMENT_REQ);
		   
		
		$wallet_update = $this->do_payments->wallet_fund_update($adv_camp_amt,$client_id,$new_arr,$campaign_ids);
			if($wallet_update)
			{ 
			$this->pay_activity_log(PAYMENT,CTRANS,$payment_refund,$campaign_update);
			$success = array(
							'response' => 'ok',
							'msg'	 => 'Amount has been refunded successfully',
							'curr_amt'=>$new_arr['amount']
						); 
			$this->response( $success, 200);
			}		
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => "Try again later"							 
						);
				$this->response( $error, 200);
			}
	}
	
	/* Getting advertiser activity logs for payments only
	 * no params 
	 * */
	public function fetch_advertiser_payment_activity_get()
	{
	   //Get from library file
	   $account_id = $this->user_authentication->account_id;
	   if($this->get('payment_type'))
	   {
		   $payment_type= $this->get('payment_type');	   
	   }
	   else
	   {
		   $payment_type= FALSE;
	   }
	   if($this->get('state'))
	   {
		   $state= $this->get('state');	   
	   }
	   else
	   {
		   $state= FALSE;
	   }
	     
	   $adv_pay_item=$this->do_payments->fetch_advertiser_activity_log($account_id,$payment_type,$state);
	   $this->response($adv_pay_item,200); 
	   
	}
	public function fetch_payment_activity_id_get()
	{
	   //~ //Get from library file
	   $log_id = $this->get('id');
	   $adv_pay_log_id=$this->do_payments->fetch_advertiser_activity_id($log_id);
		$this->response($adv_pay_log_id,200); 
	   
	}
	function get_client_ip_server() {
    $ipaddress = '';
    if ($_SERVER['HTTP_CLIENT_IP'])
        $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
    else if($_SERVER['HTTP_X_REAL_IP'])
        $ipaddress = $_SERVER['HTTP_X_REAL_IP'];    
    else if($_SERVER['HTTP_X_FORWARDED'])
        $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
    else if($_SERVER['HTTP_FORWARDED_FOR'])
        $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
    else if($_SERVER['HTTP_FORWARDED'])
        $ipaddress = $_SERVER['HTTP_FORWARDED'];
    else if($_SERVER['REMOTE_ADDR'])
        $ipaddress = $_SERVER['REMOTE_ADDR'];
	else if($_SERVER['HTTP_X_FORWARDED_FOR'])
        $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
    else
        $ipaddress = 'UNKNOWN';
 
    return $ipaddress;
	}
	
	public function  gateway_add_fundlog_post()
	{ 
		$amount = $this->post('amount');
		$account_id = $this->post('acc_id');
		$gateway = $this->post('gateway');
		$this->pay_activity_log(PAYMENT,$gateway,clean_data($amount));
	}
}
