<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 *
 * Onetime wizard will be managed here 
 *
 * @package		ADX
 * @subpackage	one time wizard
 * @category	Controller
 * @author		renuka
 * @link		http://www.djaxadexchange.com
*/


class Onetime_wizard extends REST_Controller
{	
		
	function __construct()
	{
		parent::__construct();	
		$this->load->model('do_onetime_wizard');
		$this->load->model('do_advertiser');
		$this->load->model('do_publisher');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
	}
	
	
	public function onetime_information_add_post()
	{		
		$this->form_validation->set_rules('first_name', 'First Name', 'trim|required');
		$this->form_validation->set_rules('last_name', 'Last Name', 'trim|required');
		$this->form_validation->set_rules('currency_to_view', 'Currency', 'trim|required');
		$this->form_validation->set_rules('company_name', 'Company Name', 'trim|required');
		$this->form_validation->set_rules('company_block_no', 'Company Block No', 'trim|required');
		$this->form_validation->set_rules('company_address', 'Company Address', 'trim|required');
		$this->form_validation->set_rules('company_city', 'Company City', 'trim|required');
		$this->form_validation->set_rules('company_state', 'Company State', 'trim|required');
		$this->form_validation->set_rules('company_country', 'Company Country', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$account_id=clean_data($this->post('account_id'));	
			$acc_type=clean_data($this->post('acc_type'));
							
			$update_infoObj=array(							
										"first_name"  		=>	clean_data($this->post('first_name')),
										"last_name"	        =>	clean_data($this->post('last_name')),
										"currency" 			=>	clean_data($this->post('currency_to_view')),
										"company_name"  	=>	clean_data($this->post('company_name')),
										"company_address"	=>	clean_data($this->post('company_address')),
										"company_block_no" 	=>	clean_data($this->post('company_block_no')),
										"company_city"		=>  clean_data($this->post('company_city')),
										"company_state" 	=>	clean_data($this->post('company_state')),
										"company_country"	=>	clean_data($this->post('company_country')),
										"updated"			=>	clean_data(date("Y-m-d H:i:s"))
										);	
																		
			$this->do_onetime_wizard->update_onetime_wizardinfo($account_id,$update_infoObj,$acc_type);	
				
			  
			if($acc_type=="ADVERTISER")
			{				 
				$up=array("dj_onetime_wizard"=>'1');
		        $where_acc=array("account_id"=>$account_id);
		        $this->db->update(TAB_CLIENTS,$up,$where_acc); 
				 	  
			    $success = array(
								'response' => 'ok',
								'redirect'=>site_url('advertiser/dashboard'),
								'msg'	 => 'Information added successfully!..' );	
			    $this->response($success, 200);							   
			}	
			else
			{
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Information added successfully!..'  
								);			
				$this->response($success, 200);	  
			}	 		
	
			
						
		}
		  
	}

	public function pub_onetime_information_add_post()
	{		
		$this->form_validation->set_rules('first_name', 'First Name', 'trim|required');
		$this->form_validation->set_rules('last_name', 'Last Name', 'trim|required');
		$this->form_validation->set_rules('currency_to_view', 'Currency', 'trim|required');
		$this->form_validation->set_rules('company_name', 'Company Name', 'trim|required');
		$this->form_validation->set_rules('company_block_no', 'Company Block No', 'trim|required');
		$this->form_validation->set_rules('company_address', 'Company Address', 'trim|required');
		$this->form_validation->set_rules('company_city', 'Company City', 'trim|required');
		$this->form_validation->set_rules('company_state', 'Company State', 'trim|required');
		$this->form_validation->set_rules('company_country', 'Company Country', 'trim|required');
		$this->form_validation->set_rules('billing_wire_acc_no', 'Account Number', 'trim|required');
		$this->form_validation->set_rules('billing_wire_swift_bic', 'SWIFT/BIC', 'trim|required');
		$this->form_validation->set_rules('billing_wire_company_address', 'Company Address', 'trim|required');
		$this->form_validation->set_rules('webmoney_acc_no', 'Webmoney Account Number', 'trim|required');
		$this->form_validation->set_rules('bitcoin_address', 'Bitcoin Address', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$account_id=clean_data($this->post('account_id'));	
			$acc_type=clean_data($this->post('acc_type'));
							
			$update_infoObj=array(							
										"first_name"  		=>	clean_data($this->post('first_name')),
										"last_name"	        =>	clean_data($this->post('last_name')),
										"currency" 			=>	clean_data($this->post('currency_to_view')),
										"company_name"  	=>	clean_data($this->post('company_name')),
										"company_address"	=>	clean_data($this->post('company_address')),
										"company_block_no" 	=>	clean_data($this->post('company_block_no')),
										"company_city"		=>  clean_data($this->post('company_city')),
										"company_state" 	=>	clean_data($this->post('company_state')),
										"company_country"	=>	clean_data($this->post('company_country')),
										"updated"			=>	clean_data(date("Y-m-d H:i:s"))
										);	
																		
			$this->do_onetime_wizard->update_onetime_wizardinfo($account_id,$update_infoObj,$acc_type);		
			$payment_info=array(							
										"account_id"  => $account_id,
										"payment_type" => 1,
										"account_holder_name" => $this->post('account_holder_name'),
										"bank_name"	=>	$this->post('billing_wire_bank_name'),
										"bank_account_no" 	=>	$this->post('billing_wire_acc_no'),
										"bank_address"	=>  $this->post('billing_wire_bank_address'),
										"company_address"=> $this->post('billing_wire_company_address'),
										"swift_bic" =>$this->post('billing_wire_swift_bic'),
										"created_date"=> date('Y-m-d H:i:s')
								);
								
			$wire_where	=	array(	"account_id"  	=> 	$account_id,
									"payment_type" 	=> 	1);
			$this->db->where($wire_where);
			$wire_rows	=	$this->db->get(TAB_PUB_PAYD)->num_rows();
			
			if($wire_rows>0)
			{
				$this->db->where($wire_where);					
				$this->db->update(TAB_PUB_PAYD,$payment_info);
			}
			else
			{
				$this->db->insert(TAB_PUB_PAYD,$payment_info);
			}	
			
			if($this->post('paypal_id'))
			{
				$paypal_info	=	array(
										"account_id"  	=> 	$account_id,
										"payment_type" 	=> 	2,
										"created_date"	=> 	date("Y-m-d H:i:s"),
										"paypal_id"		=> 	$this->post('paypal_id')
										);
				
				$pay_where	=	array(	"account_id"  	=> 	$account_id,
										"payment_type" 	=> 	2);
				$this->db->where($pay_where);
				$pay_rows	=	$this->db->get(TAB_PUB_PAYD)->num_rows();
				
				if($pay_rows>0)
				{
					$this->db->where($pay_where);					
					$this->db->update(TAB_PUB_PAYD,$paypal_info);
				}
				else
				{
					$this->db->insert(TAB_PUB_PAYD,$paypal_info);
				}
			}	
			
			if($this->post('webmoney_acc_no'))
			{
				$zpurse_info	=	array(
										"account_id"  		=> 	$account_id,
										"payment_type" 		=> 	3,
										"created_date"		=> 	date("Y-m-d H:i:s"),
										"bank_account_no"	=> 	$this->post('webmoney_acc_no')
										);
				
				$webm_where	=	array(	"account_id"  	=> 	$account_id,
										"payment_type" 	=> 	3);
				$this->db->where($webm_where);
				$webm_rows	=	$this->db->get(TAB_PUB_PAYD)->num_rows();
				
				if($webm_rows>0)
				{
					$this->db->where($webm_where);					
					$this->db->update(TAB_PUB_PAYD,$zpurse_info);
				}
				else
				{
					$this->db->insert(TAB_PUB_PAYD,$zpurse_info);
				}	
			}	
			
			if($this->post('bitcoin_address'))
			{
				$bitcoin_info	=	array(
										"account_id"  	=> 	$account_id,
										"payment_type" 	=> 	4,
										"created_date"	=> 	date("Y-m-d H:i:s"),
										"address"		=> 	$this->post('bitcoin_address')
										);
				
				$bit_where	=	array(	"account_id"  	=> 	$account_id,
										"payment_type" 	=> 	4);
				$this->db->where($bit_where);
				$bit_rows	=	$this->db->get(TAB_PUB_PAYD)->num_rows();
				
				if($bit_rows>0)
				{
					$this->db->where($bit_where);					
					$this->db->update(TAB_PUB_PAYD,$bitcoin_info);
				}
				else
				{
					$this->db->insert(TAB_PUB_PAYD,$bitcoin_info);
				}
			}	
			
			if($acc_type=="PUBLISHER")
			{			 
				$up=array("dj_onetime_wizard"=>'1');
				$where_acc=array("account_id"=>$account_id);
				$this->db->update(TAB_AFFILIATE,$up,$where_acc);
				 
				$success = array(
								'response' => 'ok',
								'redirect'=>site_url('publisher/dashboard'),
								'msg'	 => 'Information added successfully!..' );
				$this->response($success, 200);			   
			}	
			else
			{
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Information added successfully!..'  
								);			
				$this->response($success, 200);	  
			}	 		
						
		}
		  
	}
		
	 /*
	 * 
	 * name: personal_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add the Personal Account Information for Particular Publisher/Advertiser
	 */
	
    public function personal_information_add_post(){
			
		$this->form_validation->set_rules('first_name', 'First Name', 'trim|required');
		$this->form_validation->set_rules('last_name', 'Last Name', 'trim|required');
		$this->form_validation->set_rules('currency_to_view', 'Currency', 'trim|required');
		//$this->form_validation->set_rules('profile_image', 'Profile Image', 'trim|required');
		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			$account_id=clean_data($this->post('account_id'));	
			$acc_type=clean_data($this->post('acc_type'));
							
			$update_personal_infoObj=array(							
										"first_name"  =>	clean_data($this->post('first_name')),
										"last_name"	=>	clean_data($this->post('last_name')),
										"currency" 	=>	clean_data($this->post('currency_to_view')),
										"updated" => clean_data(date('Y-m-d H:i:s'))
										
								);										
			
			$this->do_onetime_wizard->update($account_id,$update_personal_infoObj,$acc_type);						
			    
			$success = array(
							'response' => 'ok',							
							'msg'	 => 'Personal Information are updated successfully!..'
						  );				
						
			$this->response($success, 200);
		}

	}	 
		
	/*
	 * 
	 * name: upload_profile_image
	 * @param :null
	 * @return:response array
	 * 
	 * Upload the selected image
	 * 
	 */
	
	public function upload_profile_image_post()
	{
		if($_FILES['profile_image'])
		{
			$profile_image=array(
					'file_name'   => $_FILES['profile_image']['name'],
					'source_name' => $_FILES['profile_image']['tmp_name'] 				 				
					);
		}
	
		$data=$this->image_lib->update_profile_image($profile_image);
		
		$account_id=clean_data($this->post('account_id'));	
		
		$acctype = clean_data($this->post('acc_type'));
		
		$this->do_onetime_wizard->update_image_information($account_id,$data['upload_data']['file_name'],$acctype);
		 
		 $success = array(
							'response' => 'ok',
							'msg'	 => 'Profile Image updated successfully!..'
			);
			
			$this->response($success, 200);		
	}
	
	/*
	 * 
	 * name: delete_profile_image
	 * @param : null
	 * @return :response array
	 * 
	 * Delete the image in user profile
	 */
	
	public function delete_profile_image_post()
	{
		 $account_id=clean_data($this->post('account_id'));	
		 $acc_type	=clean_data($this->post('acc_type'));		
		 $profile_name=$this->do_onetime_wizard->get_user_information($account_id,$acc_type);
	 
		 $delete_profile_name=$profile_name[0]['dj_profile_image'];		 
				
		if($delete_profile_name)
		{
			$is_delete_profile=$this->image_lib->delete_profile_image($delete_profile_name);
			
			/* Delete Profile name in Database */	
			
			if($acc_type=="PUBLISHER")
			{			
			$this->do_publisher->delete_profile_name($account_id);
			}
			if($acc_type=="ADVERTISER")
			{				
			$this->do_advertiser->delete_profile_name($account_id);	
			}
		
			if($is_delete_profile)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => 'Profile Image deleted'
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the Profile Image'
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the Profile Image'
							);
			$this->response($error, 200);
		}
	}
	
	
	/*
	 * 
	 * name: company_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the company Information for Particular Publisher/Advertiser
	 */
	
    public function company_information_add_post(){		
				
		/*$this->form_validation->set_rules('company_name', 'Company Name', 'trim|required');
		$this->form_validation->set_rules('company_address', 'Company Address', 'trim|required');
		$this->form_validation->set_rules('company_block_no', 'Company Block Number', 'trim|required');
		$this->form_validation->set_rules('company_address', 'Company Address', 'trim|required');
		$this->form_validation->set_rules('company_state', 'Company State', 'trim|required');
		$this->form_validation->set_rules('company_country', 'Company Country', 'trim|required');*/
		
		$this->form_validation->set_rules('company_name', 'Company Name', 'trim');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			$account_id	=clean_data($this->post('account_id'));	
			$acc_type	=clean_data($this->post('acc_type'));	
			
			$update_company_infoObj=array(							
											"company_name"  	=>	clean_data($this->post('company_name')),
											"company_address"	=>	clean_data($this->post('company_address')),
											"company_block_no" 	=>	clean_data($this->post('company_block_no')),
											"company_city"		=>  clean_data($this->post('company_city')),
											"company_state" 	=>	clean_data($this->post('company_state')),
											"company_country"	=>	clean_data($this->post('company_country')),
											"updated"			=>	clean_data(date("Y-m-d H:i:s"))
										);	
													
			$this->do_onetime_wizard->update_companyinfo($account_id,$update_company_infoObj,$acc_type);			
			  
			if($acc_type=="ADVERTISER")
			{				 
				$up=array("dj_onetime_wizard"=>'1');
		        $where_acc=array("account_id"=>$account_id);
		        $this->db->update(TAB_CLIENTS,$up,$where_acc); 
				 	  
			    $success = array(
								'response' => 'ok',
								'redirect'=>site_url('advertiser/dashboard'),
								'msg'	 => 'Company Information added successfully!..' );	
			    $this->response($success, 200);							   
			}	
			else
			{
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Company Information added successfully!..'
								);
			
				$this->response($success, 200);	
			}	 		
		
		}

	}

		 /*
	 * 
	 * name: payment_info_add_post
	 * @param : null
	 * @return :Last insert id
	 * 
	 */
	
    public function payment_information_add_post(){		
		
		/*$this->form_validation->set_rules('billing_wire_bank_name', 'Bank Name', 'trim|required');
		$this->form_validation->set_rules('billing_wire_acc_no', 'Account Number', 'trim|required');
		$this->form_validation->set_rules('billing_wire_bank_address', 'Bank Address', 'trim|required');
		$this->form_validation->set_rules('billing_wire_swift_bic', 'Swift/Bic', 'trim|required');
		
		$this->form_validation->set_rules('paypal_id', 'Paypal Id', 'trim|required');*/
		
		$this->form_validation->set_rules('billing_wire_bank_name', 'Bank Name', 'trim');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$account_id	=clean_data($this->post('account_id'));	
			$acc_type	=clean_data($this->post('acc_type'));	
			
			$payment_info=array(							
										"account_id"  => $account_id,
										"payment_type" => 1,
										"account_holder_name" => $this->post('account_holder_name'),
										"bank_name"	=>	$this->post('billing_wire_bank_name'),
										"bank_account_no" 	=>	$this->post('billing_wire_acc_no'),
										"bank_address"	=>  $this->post('billing_wire_bank_address'),
										"company_address"=> $this->post('billing_wire_company_address'),
										"swift_bic" =>$this->post('billing_wire_swift_bic'),
										"created_date"=> date('Y-m-d H:i:s')
								);
								
			$wire_where	=	array(	"account_id"  	=> 	$account_id,
									"payment_type" 	=> 	1);
			$this->db->where($wire_where);
			$wire_rows	=	$this->db->get(TAB_PUB_PAYD)->num_rows();
			
			if($wire_rows>0)
			{
				$this->db->where($wire_where);					
				$this->db->update(TAB_PUB_PAYD,$payment_info);
			}
			else
			{
				$this->db->insert(TAB_PUB_PAYD,$payment_info);
			}	
			
			if($this->post('paypal_id'))
			{
				$paypal_info	=	array(
										"account_id"  	=> 	$account_id,
										"payment_type" 	=> 	2,
										"created_date"	=> 	date("Y-m-d H:i:s"),
										"paypal_id"		=> 	$this->post('paypal_id')
										);
				
				$pay_where	=	array(	"account_id"  	=> 	$account_id,
										"payment_type" 	=> 	2);
				$this->db->where($pay_where);
				$pay_rows	=	$this->db->get(TAB_PUB_PAYD)->num_rows();
				
				if($pay_rows>0)
				{
					$this->db->where($pay_where);					
					$this->db->update(TAB_PUB_PAYD,$paypal_info);
				}
				else
				{
					$this->db->insert(TAB_PUB_PAYD,$paypal_info);
				}
			}	
			
			if($this->post('webmoney_acc_no'))
			{
				$zpurse_info	=	array(
										"account_id"  		=> 	$account_id,
										"payment_type" 		=> 	3,
										"created_date"		=> 	date("Y-m-d H:i:s"),
										"bank_account_no"	=> 	$this->post('webmoney_acc_no')
										);
				
				$webm_where	=	array(	"account_id"  	=> 	$account_id,
										"payment_type" 	=> 	3);
				$this->db->where($webm_where);
				$webm_rows	=	$this->db->get(TAB_PUB_PAYD)->num_rows();
				
				if($webm_rows>0)
				{
					$this->db->where($webm_where);					
					$this->db->update(TAB_PUB_PAYD,$zpurse_info);
				}
				else
				{
					$this->db->insert(TAB_PUB_PAYD,$zpurse_info);
				}	
			}	
			
			if($this->post('bitcoin_address'))
			{
				$bitcoin_info	=	array(
										"account_id"  	=> 	$account_id,
										"payment_type" 	=> 	4,
										"created_date"	=> 	date("Y-m-d H:i:s"),
										"address"		=> 	$this->post('bitcoin_address')
										);
				
				$bit_where	=	array(	"account_id"  	=> 	$account_id,
										"payment_type" 	=> 	4);
				$this->db->where($bit_where);
				$bit_rows	=	$this->db->get(TAB_PUB_PAYD)->num_rows();
				
				if($bit_rows>0)
				{
					$this->db->where($bit_where);					
					$this->db->update(TAB_PUB_PAYD,$bitcoin_info);
				}
				else
				{
					$this->db->insert(TAB_PUB_PAYD,$bitcoin_info);
				}
			}	
			
			if($acc_type=="PUBLISHER")
			{			 
				$up=array("dj_onetime_wizard"=>'1');
				$where_acc=array("account_id"=>$account_id);
				$this->db->update(TAB_AFFILIATE,$up,$where_acc);
				 
				$success = array(
								'response' => 'ok',
								'redirect'=>site_url('publisher/dashboard'),
								'msg'	 => 'Information added successfully!..' );
				$this->response($success, 200);			   
			}
        }
	}	
	
	
	public function user_info_get()
	{
	   $account_id=$this->get('account_id');
	   $account_type=$this->get('type');
	   $result=$this->do_onetime_wizard->get_onetime_info($account_id,$account_type);
	   if($result)
	   {
	  	 $this->response($result, 200);
	   }
	}
	
	
}
