<?php defined('BASEPATH') OR exit('No direct script access allowed');
/*
 * newsletter_template.php
 * 
 * Copyright 2017 dreamajax 
 */
 
/*
 * Newsletter Templates
 * @category	Controller
 * @author		Yoges D
 * @link		http://www.djaxadserver.com
 * */
class Newsletter_template extends REST_Controller
{
	
	function __construct()
	{
		parent::__construct();
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->library('user_authentication');
		$key=$this->input->get_post('api_key'); 
		$this->load->library('csvreader');	
	    //$this->response($key,200);
	    $this->load->model('do_template');
		$this->user_authentication->is_valid_apikey($key);
		$this->load->helper(array('form', 'url'));
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
		
	}
	
	public function upload_newsletter_temp_post()
	{
		
				$config2['upload_path']          = './newsletter/';
               
                $config2['allowed_types'] = 'gif|jpg|png';
              
                $this->upload->initialize($config2);
               
                if ( ! $this->upload->do_upload('file'))
                {
					$error = array('error' => $this->upload->display_errors());
                    $this->response($error);
                       
                }
                else
                {
					$data = array('upload_data' => $this->upload->data());
					$name_exp= explode('.',$data['upload_data']['file_name']);
					$db_values= array(
					'newsletter_name'=>$name_exp[0],
					);
					$db_insert = $this->do_template->add_newsletter_info($db_values);
					$this->response(array('response'=>'ok', 'msg'=>'File uploaded successfully'));
				   
                }			
	}
	
	function fetch_get()
	{
		$newsletter_list = $this->do_template->fetch_newsletter();
		$this->response($newsletter_list);
	}
	
	public function block_temp_get()
	{
	    $temp_id=$this->get('templ_id');
		if($temp_id)
		{
			$block_temp = $this->do_template->block_template_data($temp_id);
			
					/* Activity Log for Block Geo settings Add- Start/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,CPM_BLOCK);
					if($enable=='1')
					{							
					$this->activity_log(CPM_GEO,BLOCK);
					}
					/* Activity Log for Geo settings Add- End*/
			
			
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Template blocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	public function unblock_temp_get()
	{
	    $temp_id=$this->get('templ_id');
		if($temp_id)
		{
			$unblock_temp = $this->do_template->unblock_template_data($temp_id);
			
					/* Activity Log for un Block Geo settings - Start/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,CPM_UNBLOCK);
					if($enable=='1')
					{							
					$this->activity_log(CPM_GEO,UNBLOCK);
					}
					/* Activity Log for Geo settings - End*/
			
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Template unblocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	public function delete_temp_get()
	{
		$id = $this->get('temp_id');
	  
		if($id)
		{
			$manufacturer_list = $this->do_template->delete_template_list($id);
			
			/* Activity Log for Geo settings Add- Start/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,CPM_DELETE);
					if($enable=='1')
					{							
					$this->activity_log(CPM_GEO,DELETE);
					}
					/* Activity Log for Geo settings Add- End*/	
	
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Email template has been deleted'
							 );
			
			$this->response( $success, 200);
			
		}else
		{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Template is not found'
					);
			
			$this->response( $error, 200);
		}
   }
    
   public function temp_file_upload_post()
   {				
				$file_=$this->post('upload_name');
		
			if($file_!='')
			{
				$upload_extension=  explode(".",$file_);	
				 
				
			
						
				if($upload_extension[1] == "html" || $upload_extension[1] == "php")
				{	
					
				$csvfilepath 	= $this->config->item('read_html');	
					
				$file_name		= $this->getLatestFile($csvfilepath);
				
				$upload_filename = explode("/", $file_name);
				
				$file_data= $upload_filename[6];
				
				$img_upload_extension = $upload_extension[0].'.png';
				$temp_data = $this->do_template->temp_file_upload_data($file_data,$img_upload_extension);
				if($temp_data)
				{
					$success = array('response'	=> 'ok',
							 'msg'		=> 'Email template has been added successfully'
							 );
							 $this->response($success,200);
				}
				else
				{
					
					$success = array('response'	=> 'error',
							 'msg'		=> 'Email template Already exits!'
							 );
							 $this->response($success,200);
				}
				
				
				
				}
			}
	}
	function getLatestFile($directoryPath)
	{
		$directoryPath = rtrim($directoryPath, '/');
	
		$max = array('path' => null, 'timestamp' => 0);	
		
		foreach (scandir($directoryPath, SCANDIR_SORT_NONE) as $file)
		{
			$path = $directoryPath . '/' . $file;
			if (!is_file($path)) {	
				continue;
			}
			$timestamp = filemtime($path);		
			if ($timestamp > $max['timestamp']) {
				$max['path'] = $path;
				$max['timestamp'] = $timestamp;
			}
		}	
		
    return $max['path'];
	}
	public function fetch_temp_deletion_get()
	{
		$id=$this->get('id');
		//~ if($id)
		//~ {
		//~ $temp_data = $this->do_template->temp_deletetion_remove_data($id);
		//~ }
		//~ else
		//~ {
		$temp_data = $this->do_template->temp_delete_data();
		//}
		
		$this->response($temp_data,200);
	}
	public function temp_deletion_get()
	{
		$id=$this->input->get('id');
		
		if($id)
		{
		$temp_data = $this->do_template->temp_deletetion_remove_data($id);
		}
		if($temp_data)
		{
			$success = array('response'	=> 'ok',
							 'msg'		=> 'template deleted successfully'
							 );
			
			$this->response( $success, 200);
		}
		else
		{
			$success = array('response'	=> 'ok',
							 'msg'		=> 'template not deleted successfully'
							 );
			
			$this->response( $success, 200);
		}
		
		
	}
	public function fetch_temp_edit_get()
	{
		$id=$this->get('id');
		
		$temp_data = $this->do_template->temp_edit_data($id);
		$csvfilepath 	= $this->config->item('read_html');	
		//$this->response($temp_data,200);
		//$this->response($csvfilepath.$temp_data[0]['filename'],200);
		if($temp_data)
		{
		$MyFile = file_get_contents($csvfilepath.$temp_data[0]['filename']);

		$this->response($MyFile,200);
		}
		 
	}
	public function fetch_temp_image_get()
	{
		
		
		$temp_data = $this->do_template->temp_img_data();
		$csvfilepath 	= $this->config->item('read_template_image');	
		
		//$this->response($temp_data,200);
		//$this->response($csvfilepath.$temp_data[0]['filename'],200);
		if($temp_data)
		{
		$MyFile = file_get_contents($csvfilepath.$temp_data[0]['filename']);

		$this->response($MyFile,200);
		}
		
	}
	public function temp_file_edit_POST()
	{
		$id				=$this->post('edit_id');
		$html_content	=$this->input->post('html_content');
		$temp_name = $this->do_template->temp_edit_data($id);
		$csvfilepath 	= $this->config->item('read_html');	
		$handle = fopen($csvfilepath.$temp_name[0]['filename'], "w");
		$f_handled =fwrite($handle, $html_content);
		if($f_handled)
		{
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Email template has been updated'
							 );
			
			$this->response( $success, 200);
		}
		
	}
}
?>
