<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Publisher Site related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Yoges.D
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class News extends REST_Controller
{
	public 		$min_floor_price;
	
	function __construct(){

		parent::__construct();		
		$this->load->model('do_site');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');	
		$this->load->model('do_web_adblock');
		$this->load->model('do_app_config');
		$this->load->model('do_auto_link');			
		$this->min_floor_price 		=  	$this->default_configurations->get('pub_min_floor_price');
		$this->floor_price_enable 	=  	$this->default_configurations->get('floor_price_enable');
		$this->load->model('do_message');
		$this->load->model('do_networks');
		$this->load->library('notification');
        $this->load->library('user_authentication');
	    $key		=	$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = 	$this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }		   
	}
	
	public function add_news_post()
	{
		$html_content= $this->input->post('html_content');
		$heading= $this->input->post('heading');
		$image_url= $this->input->post('image_url');
		$add_news  = $this->do_site->add_news_data($heading,$html_content,$image_url);
		if($add_news)
		{
		
			$success = array(
				'response' => 'ok',
				'redirect'=>site_url('admin/news/news_create'),
				'msg'	 => 'News has been added successfully!..'
			);
			  
			$this->response($success, 200); 
		}
		else
		{
			$error = array(
				'response' => 'error',
				'redirect'=>site_url('admin/news/news_create'),
				'msg'	 => 'Error! Try again..'
			);
			  
			$this->response($error, 200); 
		}
	}
	public function edit_news_post()
	{
		$html_content= $this->input->post('html_content');
		$heading= $this->input->post('heading');
		$image_url= $this->input->post('image_url');
		$newsid= $this->input->post('sno');
		if($newsid)
		{
			$edit_news  = $this->do_site->edit_news_data($heading,$html_content,$image_url,$newsid);
			if($edit_news)
			{
			
				$success = array(
					'response' => 'ok',
					'redirect'=>site_url('admin/news/'),
					'msg'	 => 'News has been edited successfully!..'
				);
				  
				$this->response($success, 200); 
			}
			else
			{
				$error = array(
					'response' => 'error',
					'redirect'=>site_url('admin/news'),
					'msg'	 => 'Error! Try again..'
				);
				  
				$this->response($error, 200); 
			}
		}
		else
		{
			$error = array(
					'response' => 'error',
					'redirect'=>site_url('admin/news/'),
					'msg'	 => 'Error! Try again.. No id'
				);
				  
				$this->response($error, 200); 
		}
		
	}
	
	public function news_post()
	{
		$month=$this->input->post('month');
		$year=$this->input->post('year');
		if($month && $year)
		{
			$news_data  = $this->do_site->fetch_news_data($month,$year);
		}
		else
		{
			$news_data  = $this->do_site->fetch_news_data();
		}
		$this->response($news_data,200);
		
	}
	public function admin_news_post()
	{
		$month=$this->input->post('month');
		$year=$this->input->post('year');
	 	$news_data  = $this->do_site->fetch_admin_news_data();
		if($news_data)
		{
			$this->response($news_data,200);
		}
		else $this->response('error',200);		
	}
	
	function news_edit_post()
	{
		$news_id=$this->input->post('n_id');
		if($news_id)
		{
			$news_data  = $this->do_site->fetch_news_data(false,false,$news_id);
			if($news_data)
			{
				$this->response($news_data,200);
			}
		}
		else
		{
			$this->response('error',200);
		}
	}
	
	function run_post()
	{
		$news_id= $this->input->post('sno');
		if($news_id)
		{
			$news_data  = $this->do_site->news_status_change($news_id,'1');
			if($news_data)
			{
				$this->response(array('response'=>'ok','msg'=>'Display property successfully changed'),200);
			}
			else
			{
				$this->response(array('response'=>'error','msg'=>'Display property changing failed'),200);
			}
		}
		else
		{
			$this->response(array('response'=>'error','msg'=>'Try again later'),200);
		}
	}
	function block_post()
	{
		$news_id= $this->input->post('sno');
		if($news_id)
		{
			$news_data  = $this->do_site->news_status_change($news_id,'2');
			if($news_data)
			{
				$this->response(array('response'=>'ok','msg'=>'Display property successfully changed'),200);
			}
			else
			{
				$this->response(array('response'=>'error','msg'=>'Display property changing failed'),200);
			}
		}
		else
		{
			$this->response(array('response'=>'error','msg'=>'Try again later'),200);
		}
	}
}
	
