<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 *
 * Admin Account settings will be managed here 
 *
 * @package		ADX
 * @subpackage	network
 * @category	Controller
 * @author		renuka
 * @link		http://www.djaxadexchange.com
*/


class Network extends REST_Controller
{		
	function __construct()
	{
		parent::__construct();	
		$this->load->library('redis_library');
		$this->load->library('csvreader');	
		$this->load->model('do_publisher');
		$this->load->model('do_advertiser');
		$this->load->model('do_networks');	
		$this->load->model('do_notification');
		$this->load->model('do_email_check');
		$this->load->model('do_campaign');
		$this->load->model('do_special_bidding');
		$this->load->model('do_message');
		$this->load->model('do_template');
		$this->load->model('do_app_config');
		$this->load->helper('email');
		$this->load->library('user_authentication');
		$this->load->library('notification');
		$key=$this->input->get_post('api_key');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->helper('my_twilio_helper');
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}
 	
		
	 /*
	 * 
	 * name: company_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the company Information for Admin
	 */
	
    public function company_information_add_post(){		
		
		$this->form_validation->set_rules('company_name', 'Company Name', 'trim|required');
		$this->form_validation->set_rules('company_address', 'Company Address', 'trim|required');
		$this->form_validation->set_rules('company_block_no', 'Company Block Number', 'trim|required');
		$this->form_validation->set_rules('company_address', 'Company Address', 'trim|required');
		$this->form_validation->set_rules('company_city', 'City', 'trim|required|alpha|callback_edit_company_test');
		$this->form_validation->set_rules('company_state', 'State', 'trim|required|alpha|callback_edit_company_check');
		$this->form_validation->set_rules('company_country', 'Company Country', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			 //Get from library file
		     $user_id	= 	$this->user_authentication->user_id;	
			
			 $update_company_infoObj=array(							
										"company_name"  =>	clean_data($this->post('company_name')),
										"company_address"	=>	clean_data($this->post('company_address')),
										"company_block_no" 	=>	clean_data($this->post('company_block_no')),
										"company_city"	=>  clean_data($this->post('company_city')),
										"company_state" =>clean_data($this->post('company_state')),
										"company_country"=>clean_data($this->post('company_country')),
										"updated"=>clean_data(date("Y-m-d H:i:s"))
								);								
						
			
		    $this->do_networks->update_companyinfo($user_id,$update_company_infoObj);
		    
		    /* Activity Log for Company information - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,COMPANY_INFORMATION);
				if($enable=='1')
				{							
				$this->activity_log(COMPANY_INFORMATION,EDIT);
				}
			/* Activity Log for Company information - End*/	
			
					
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/company_information'),
							'msg'	 => 'Company Information are updated successfully!..'
			);
		
						
			$this->response($success, 200);
		}

	}
	
	 /*
	 * 
	 * name: billing_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the billing Information for Admin
	 */
	
    public function billing_information_add_post(){		
		
		$this->form_validation->set_rules('billing_company_name', 'Billing Name', 'trim|required');
		$this->form_validation->set_rules('billing_address', 'Billing Address', 'trim|required');
		$this->form_validation->set_rules('billing_block_no', 'Billing Block Number', 'trim|required');
		$this->form_validation->set_rules('billing_city', 'City', 'trim|required|alpha|callback_edit_company_test');
		$this->form_validation->set_rules('billing_state', 'State', 'trim|required|alpha|callback_edit_company_check');
		$this->form_validation->set_rules('billing_country', 'Billing Country', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			 //Get from library file
		     $user_id	= 	$this->user_authentication->user_id;	
			
			 $update_billing_infoObj=array(							
										"billing_company_name"  =>	clean_data($this->post('billing_company_name')),
										"billing_address"	=>	clean_data($this->post('billing_address')),
										"billing_block_no" 	=>	clean_data($this->post('billing_block_no')),
										"billing_city"	=>  clean_data($this->post('billing_city')),
										"billing_state" =>clean_data($this->post('billing_state')),
										"billing_country"=>clean_data($this->post('billing_country')),
										"updated"=>clean_data(date("Y-m-d H:i:s"))
								);								
						
			
		    $this->do_networks->update_billinginfo($user_id,$update_billing_infoObj);
		    
		    	/* Activity Log for Billing information - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,BILLING_INFO);
				if($enable=='1')
				{							
				$this->activity_log(BILLING_INFO,EDIT);
				}
				/* Activity Log for Billing information- End*/
			
					
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/billing_information'),
							'msg'	 => 'Billing Information are updated successfully!..'
			);
		
						
			$this->response($success, 200);
		}

	}
	
	 /*
	 * 
	 * name: personal_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the Personal Account Information for Admin
	 * 	 */
	
    public function personal_information_add_post(){
		
		if($this->post('individual')==1)
		{
		$this->form_validation->set_rules('first_name', 'First Name', 'trim|required');
		$this->form_validation->set_rules('last_name', 'Last Name', 'trim|required');
		$this->form_validation->set_rules('gender', 'Gender', 'trim|required');
		$this->form_validation->set_rules('date_of_birth', 'Date Of Birth', 'trim|required');
		$this->form_validation->set_rules('mobile_no', 'Mobile Number', 'trim|required');
		$this->form_validation->set_rules('city', 'City', 'trim|required|alpha|callback_edit_check');
		$this->form_validation->set_rules('state', 'State', 'trim|required|alpha|callback_edit_state');
		$this->form_validation->set_rules('country', 'Country', 'trim|required');
	
		}
		else
		{
		$this->form_validation->set_rules('company_name', 'Company Name', 'trim|required');
		$this->form_validation->set_rules('company_address', 'Company Address', 'trim|required');
		$this->form_validation->set_rules('company_block_no', 'Company Block Number', 'trim|required');
		$this->form_validation->set_rules('company_address', 'Company Address', 'trim|required');
		$this->form_validation->set_rules('company_city', 'City', 'trim|required|alpha|callback_edit_company_test');
		$this->form_validation->set_rules('company_state', 'State', 'trim|required|alpha|callback_edit_company_check');
		$this->form_validation->set_rules('company_country', 'Company Country', 'trim|required');
	
		
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' => $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			 //Get from library file
		     $account_id	= 	$this->user_authentication->account_id;	
		     $default_user_id = $this->user_authentication->user_id;		
			
			$org_date = clean_data($this->post('date_of_birth'));
			$date = new DateTime($org_date);
			$date_format=$date->format('Y-m-d'); // 2012-09-13
			if($this->post('individual')==1)
		{
			$update_personal_infoObj=array(							
										"first_name"  	=>	clean_data($this->post('first_name')),
										"last_name"		=>	clean_data($this->post('last_name')),
										"gender" 		=>	clean_data($this->post('gender')),
										"dob"			=> 	$date_format ,
										"mobile_number" =>	clean_data($this->post('mobile_no')),
										"city" 			=>	clean_data($this->post('city')),
										"state" 		=>	clean_data($this->post('state')),
										"country" 		=>	clean_data($this->post('country')),
										"updated"		=>	clean_data(date("Y-m-d H:i:s"))
										
										
								);	
								
								
															
			$account_setting_type="personal";												
		
		    $this->do_networks->update($account_id,$update_personal_infoObj,$account_setting_type,$default_user_id);
		}
		else
		{
		$user_id	= 	$this->user_authentication->user_id;	
			
			 $update_company_infoObj=array(							
										"company_name"  =>	clean_data($this->post('company_name')),
										"company_address"	=>	clean_data($this->post('company_address')),
										"company_block_no" 	=>	clean_data($this->post('company_block_no')),
										"company_city"	=>  clean_data($this->post('company_city')),
										"company_state" =>clean_data($this->post('company_state')),
										"company_country"=>clean_data($this->post('company_country')),
										"updated"=>clean_data(date("Y-m-d H:i:s"))
								);								
						
			
		    $this->do_networks->update_companyinfo($user_id,$update_company_infoObj);
		}
		    /* Activity Log for Personal information - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,PERSONAL_INFORMATION);
				if($enable=='1')
				{							
				$this->activity_log(PERSONAL_INFORMATION,EDIT);
				}
			/* Activity Log for Personal information - End*/	
		    
			
					
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/personal_information'),
							'msg'	 => 'Personal Information are updated successfully!..'
			);
		
						
			$this->response($success, 200);
		}

	}
	
	
	function load_advertiser_get()
	{
		$site_id=$this->get('site_id');
		
		$adv_list=$this->do_networks->get_advertiser_data($site_id);
		
		if($adv_list)
		 {
			// $form_data='<select name="advertiser_list" id="advertiser_list" data-nosearch="true" data-rule-required="true">'; 
			 $form_data ='<option value="">'.$this->lang->line("slt_advertiser").'</option>';
			 foreach($adv_list as $sel)
			{
				$form_data.='<option value="'.$sel['account_id'].'">'.$sel['clientname'].'</option>';      
			}
			//$form_data.='</select>';
			 $response = array(
							'response' 	=> 	'ok',
							'advlist'	=>	$form_data,
						);					
		    $this->response($response, 200);
		 }
		 else
		 {
			 $this->response(array('error'=>'Advertiser ID could not be found'),404);
		 }
		
		
	}
	
	
	
	function load_campaign_get()
	{
		$adv_id=$this->get('adv_id');
		
		$camp_list=$this->do_networks->get_campaign_data($adv_id);
		
		if($camp_list)
		 {
			 $form_data='';
			 
			 foreach($camp_list as $sel)
			{
				$form_data.='<option value="'.$sel['campaignid'].'">'.$sel['campaignname'].'</option>';      
			}
			$response = array(
							'response' 	=> 	'ok',
							'camplist'	=>	$form_data,
						);					
		    $this->response($response, 200);  
		 }
		 else
		 {
			 $response = array(
							'response' 	=> 	'ok',
							'camplist'	=>	'<option value="">No campaigns</option>',
						);					
		    $this->response($response, 200);
			 //$this->response(array('error'=>'Campaign ID could not be found'),404);    
		 }
		
		
	}
	
	
	/*
	 * 
	 * name: user_information
	 * @param :null
	 * @return : response Array
	 * 
	 * get the user information for particular Advertiser
	 */	
		 
	public function user_information_get()
	{	
         //Get from library file
		 $account_id	= 	$this->user_authentication->account_id;	
				
		 $user_info=$this->do_networks->get_user_information($account_id);	  
		 
		 if($user_info)
		 {
			 $this->response($user_info, 200); // 200 being the HTTP response code
		 }
		
	}
	
	/*
	 * 
	 * name: user_role_info
	 * @param :null
	 * @return : response Array
	 * 
	 * get the user information for particular Advertiser
	 */	
		 
	public function user_role_info_get()
	{	
         
		//Get from library file
		$user_id=$this->user_authentication->manager_user_id;	
		if(empty($user_id))
		{
			$user_id=$this->user_authentication->user_id;
		}
		$user_info=$this->do_networks->get_user_role_info($user_id);	  
		 
		 if($user_info)
		 {
			 $this->response($user_info, 200); // 200 being the HTTP response code
		 }
	 
		
	}
	
	public function pubs_role_info_get()
	{	
		$email_names = $this->get('email_names');	
		if(!empty($email_names))
		{		
		 $pub_info=$this->do_networks->get_pubs_role_info($email_names);	  		
		 if($pub_info)
		 {
			 $this->response($pub_info, 200); // 200 being the HTTP response code
		 }
	 }
	 
		
	}
		 
	/*
	 * 
	 * name: account_settings_add
	 * @param :null
	 * @return : response Array
	 * 
	 * Add/update the Account Setting Information for Admin
	 */
	
    public function account_settings_add_post(){		
		
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|callback_email_check');
		//$this->form_validation->set_rules('another_email','Another Email','trim|required|valid_email');
		#$this->form_validation->set_rules('currency_to_view', 'Currency', 'trim|required');
		$this->form_validation->set_rules('password', 'New password', 'trim|matches[conf_password]');
		$this->form_validation->set_rules('conf_password', 'Repeat password', 'trim|matches[password]');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			 //Get from library file
		     $account_id	= 	$this->user_authentication->account_id;	
		     
		     $default_user_id = $this->user_authentication->user_id;	
			
			$db_old_pass=$this->do_publisher->get_current_pass($account_id);
			
			$account_setting_type="account";
			
			$current_password=trim(clean_data($this->post('current_password')));
			
			if(md5($current_password)==$db_old_pass || $current_password=='')
			{   
			     $update_setting_infoObj=array(
										
										"email"  			=>	clean_data($this->post('email')),
										"alternate_email"	=>	clean_data($this->post('another_email')),
										"currency" 			=>	clean_data($this->post('currency_to_view')),
										"password"			=>	clean_data($this->post('password')),
										"email_updated"		=>	clean_data(date("Y-m-d H:i:s"))
							    	);	
		    $this->do_networks->update($account_id,$update_setting_infoObj,$account_setting_type,$default_user_id);
		    
		     $enable_twofactor = clean_data($this->post('enable_twofactor'));
		    
				if($enable_twofactor){
					$security_enable = 1; 	
				}
				else{
					$security_enable = 0; 
				}
					$security_info = array(
					"security_enable"=>$security_enable,
					
					);
				$this->do_app_config->update_security_info($account_id,$security_info);					
			//UPDATE EMAIL ID INTO THEIR OX_CLIENTS/OX_USERS FOR DEFAULT ADVERTISER
			$this->do_networks->update_email_def_advertiser(clean_data($this->post('email')),$default_user_id);
			
			/* Activity Log for Account settings - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,ACC_SETTINGS);
				if($enable=='1')
				{							
				$this->activity_log(ACC_SETTINGS,EDIT);
				}
			/* Activity Log for Account Settings - End*/	
			
			
			//SEND MAIL TO ADMIN
			$result=$this->do_networks->get_network_details();			
			$admin_name    = $result['firstname']." ".$result['lastname'];			
			$admin_email   = $result['email'];
			$user_email    = clean_data($this->post('email'));
			$user_name     =  $admin_name;
			$type     	   = (clean_data($this->post('password'))!='')?"ADMIN_CHANGE_PASSWORD":"ADMIN_SETTING_INFORMATION";
			$from 		   = $admin_email;
			$to  		   =  $user_email;
			if(clean_data($this->post('password'))!='')
			{			
				//If Admin change his password then it will works
				$mail_content=array(
						"subject" 		=> "Admin - Change Password",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,							
						"email"   		=> clean_data($this->post('email')),
						"password"		=> clean_data($this->post('password')),
						"account_type"	=> "admin"							
					);		
			}
			else
			{
			    //Send only email,alternate email to their email
				$mail_content=array(
								"subject" 		=> "Admin - Account Settings Information",
								"to_name" 		=> $user_name,				
								"from_name"		=> $admin_name,							
								"email"   		=> clean_data($this->post('email')),
								"alternate_email" => clean_data($this->post('another_email')),
								"currency"		=> clean_data($this->post('currency_to_view')),
								"account_type"	=> "admin"		
								);
			
			}
		   $attachement='';	
		   send_mail($type,$from,$to,$mail_content,$attachement,$from); 
		   
			 $success = array(
								'response' => 'ok',
								'redirect'=>site_url('admin/settings/account_settings'),
								'msg'	 => 'Account Settings Information are updated successfully!..'
				);
			  
			    $this->response($success, 200); 
			  }
			   else
			   {
			       $error = array(
							'response' => 'error',
							'redirect'=>site_url('admin/settings/account_settings'),
							'msg'	 => 'Please enter your current password correctly!..'
							);
			       $this->response($error, 200);
			   
			   }
		
		}

	}
	
	/*
	 * 
	 * name: upload_profile_image
	 * @param : null
	 * @return:response array
	 * 
	 * Upload the selected image
	 * 
	 */
	
	public function upload_profile_image_post()
	{
		 //Get from library file
		 $account_id	= 	$this->user_authentication->account_id;	
		if($_FILES['profile_image'])
		{
			$profile_image=array(
					'file_name'   => $_FILES['profile_image']['name'],
					'source_name' => $_FILES['profile_image']['tmp_name'] 				 				
					);
		}
	
		$data	=	$this->image_lib->update_profile_image($profile_image);
		
		if($data['upload_data']['file_name'])
		{
			$update	=	$this->do_networks->update_image_information($account_id,$data['upload_data']['file_name']);
		
			if($update)
			{
				$success = array(
							'response' 	=> 'ok',
							'msg'	 	=> 'Profile Image updated successfully!..'
						);
			
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' 	=> 'error',
							'msg'	 	=> 'Profile Image not updated successfully!..'
						);
			
				$this->response($error, 200);
			}
			
		}
		else
		{
			$error = array(
							'response' 	=> 'error',
							'msg'	 	=> 'Profile Image not uploaded successfully!..'
						);
			
			$this->response($error, 200);
		}
		
	}
	
	/*
	 * 
	 * name: delete_profile_image
	 * @param : null
	 * @return :response array
	 * 
	 * Delete the image in user profile
	 */
	
	public function delete_profile_image_post()
	{
		 //Get from library file
		 $account_id	= 	$this->user_authentication->account_id;	
		 $profile_name=$this->do_networks->get_user_information($account_id);
		 $delete_profile_name=$profile_name[0]['profile_image'];
		 
				
		if($delete_profile_name)
		{
			$is_delete_profile=$this->image_lib->delete_profile_image($delete_profile_name);

			/* Delete Profile name in Database */
			$this->do_networks->delete_profile_name($account_id);
			
			if($is_delete_profile)
			{
				
				$success = array(
							'response' => 'success',
							'msg'	 => 'Thumb image deleted'
							);
				$this->response($success, 200);
			}
			else
			{
				
				$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the Profile Image'
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the Profile Image'
							);
			$this->response($error, 200);
		}
	}

	/*
	 * 
	 * name: email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	public function email_check()
	{
		 //Get from library file
		$account_id	= 	$this->user_authentication->account_id;	
		$account_type   =   $this->user_authentication->account_type;	
		$email=clean_data($this->input->post('email'));
		//$count=$this->do_email_check->email_check($account_id,$email,$account_type);					
        $count=$this->do_email_check->dup_email_check($email,$account_id,$account_type);
		if($count>0)
		{
			$this->form_validation->set_message('email_check', "This Email address already Exists");
			return FALSE;	
		}
		else
		{
			return true;
		}
	}
	
	
		/*
	 * 
	 * name: email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	public function user_role_email_check()
	{
		$user_id=$this->user_authentication->manager_user_id;
		$email=clean_data($this->input->post('email'));
		//$count=$this->do_email_check->email_check($account_id,$email,$account_type);					
        $count=$this->do_email_check->email_check($user_id,$email);
		if($count>0)
		{
			$this->form_validation->set_message('user_role_email_check', "This Email address already Exists");
			return FALSE;	
		}
		else
		{
			return true;
		}
	}
	 
	 
	 /*
	 * 
	 * name: payment_info_add_post
	 * @param : null
	 * @return :Last insert id
	 * 
	 */
	
    public function payment_info_add_post(){		
		//$this->response( 'hai', 200);
		$this->form_validation->set_rules('billing_wire_bank_name', 'Bank Name', 'trim|required');
		$this->form_validation->set_rules('billing_wire_acc_no', 'Account Number', 'trim|required');
		$this->form_validation->set_rules('billing_wire_bank_address', 'Bank Address', 'trim|required');
		$this->form_validation->set_rules('billing_wire_company_address', 'Company Address', 'trim|required');
		#$this->form_validation->set_rules('billing_wire_currency', 'Currency', 'trim|required');
		$this->form_validation->set_rules('billing_wire_swift_bic', 'Swift/Bic', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response($error, 200);
		}
		else
		{	
			$account_id	= 	$this->user_authentication->account_id;	
			$status_check=$this->do_networks->add_payment_info(clean_data($this->post()),$account_id);
		  
			/******************************************************************************/
		  		  
			$affiliate_id	=	$this->user_authentication->affiliate_id;
			$reciever = $this->do_message->get_affiliate($affiliate_id); 
			
			$account_type	=	$this->user_authentication->account_type;	
			$network_id	=	$this->user_authentication->network_account_id;					
			$agency_id	=	$this->user_authentication->agency_id;
			$result		=	$this->do_networks->agency_owner_details($agency_id);
			$admin_name    	= 	$result['name'];			
			$admin_email	= 	$result['email'];	
			$admin_id   	= 	$result['account_id'];
			
			$user = $this->do_message->get_profile($admin_id); 
			$type='PUB_PAY_WIRE_UPDATED';
			$type_details	=	array(
										//'msg_type'		=> $message,
										'type'			=> $type,
										'string'		=> "payment_sett",
										'column_name'	=> "payments"
										);
			
			$mail_content=array(
					"to_name"	=>	ucfirst($reciever['dj_first_name']).' '.ucfirst($reciever['dj_last_name']),
					"email"		=>	$this->post('email'),
					"from_name"	=>	$user['first_name'].' '.$user['last_name'],
					'type'		=> 	$type,
					'status_check'	=>	$status_check,
					"subject" 		=> "Your wire Payment details updated",
					'bank_name'		=> clean_data($this->post('billing_wire_bank_name')),      
					'bank_account_no'=> clean_data($this->post('billing_wire_acc_no')),
					'bank_address'	 => clean_data($this->post('billing_wire_bank_address')),
					'currency_code'	 => clean_data($this->post('billing_wire_currency')),
					'swift_bic'		 => clean_data($this->post('billing_wire_swift_bic')),
					'account_holder_name' =>clean_data($this->post('account_holder_name'))	
					 
				);
				
			$message_data		=	array(
				'sender_id'		=>	$admin_id,
				'receiver_id'	=>	$account_id,
				'subject'		=>	'Publisher - Payment method',
				'content'		=> 	'Your payment method updated successfully',
				'account_type'	=>	"TRAFFICKER",
				'notification_type'	=>	"payment_setting",	
				'status'		=>	'1',
				'status'		=>	$network_id,
				'date'			=>	date('Y-m-d H:i:s')
				);		
							
			$dd = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);	
			
			/* Activity Log for Payment settings - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,PAYMENT_SETTINGS);
				if($enable=='1')
				{							
				$this->activity_log(PAYMENT_SETTINGS,EDIT);
				}
			/* Activity Log for Payment settings - End*/	
			
			
			
			
		   
			if($status_check!="updated")
			{
				$success = array(
								'response' => 'ok',
								'redirect'=>site_url('publisher/settings/payment_settings'),
								'msg'	 => 'Payment Information added successfully!..' );
				$publisher_details=$this->do_publisher->get_profile($account_id); 


				$this->response($success, 200);
			}
			else
			{
				$success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/payment_settings'),
							'msg'	 => 'Payment Information updated successfully!..' );
				$this->response($success, 200);

			}
		}
	}
	
	
	
     /* for admin account
	 * 
	 * name: admin_payment_info_add
	 * @param : null
	 * @return :Last insert id
	 * 
	 */
	
    public function admin_payment_info_add_post(){		
		
		$this->form_validation->set_rules('account_holder_name', 'Account Holder name', 'trim|required');
		$this->form_validation->set_rules('billing_wire_bank_name', 'Bank Name', 'trim|required');
		$this->form_validation->set_rules('billing_wire_acc_no', 'Account Number', 'trim|required');
		$this->form_validation->set_rules('billing_wire_bank_address', 'Bank Address', 'trim|required');
		$this->form_validation->set_rules('billing_wire_currency', 'Currency', 'trim|required');
		$this->form_validation->set_rules('billing_wire_swift_bic', 'Swift/Bic', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$account_id		= 	$this->user_authentication->account_id;	
			$status_check	=	$this->do_networks->admin_add_payment_info(clean_data($this->post()),$account_id);
			if($status_check=="inserted")
			{
				$success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => 'Payment Information added successfully!..' );
				$this->response($success, 200);
			}
			elseif($status_check=="updated")
			{
				$success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => 'Payment Information updated successfully!..' );
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => 'Payment Information not updated successfully!..' );
				$this->response($error, 200);
			}
        }
	}
	
	/* for admin account
	 * 
	 * name: admin_paypal_info_add
	 * @param : null
	 * @return :Last insert id
	 * 
	 */
	
    public function admin_paypal_info_add_post(){		
		
		$this->form_validation->set_rules('api_username', 'API Username', 'trim|required');
		$this->form_validation->set_rules('api_password', 'API Password', 'trim|required');
		$this->form_validation->set_rules('api_signature', 'API Signature', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error 	= 	array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$account_id		= 	$this->user_authentication->account_id;	
			$status_check	=	$this->do_networks->admin_add_paypal_api_info(clean_data($this->post()),$account_id);
			if($status_check=="inserted")
			{
				$success = array(
							'response' 	=> 	'ok',
							'redirect'	=>	site_url('admin/settings/payment_settings'),
							'msg'	 	=> 	'Payment Information added successfully!..' );
				$this->response($success, 200);
			}
			elseif($status_check=="updated")
			{
				$success = array(
							'response' 	=> 	'ok',
							'redirect'	=>	site_url('admin/settings/payment_settings'),
							'msg'	 	=> 	'Payment Information updated successfully!..' );
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' 	=> 	'error',
							'redirect'	=>	site_url('admin/settings/payment_settings'),
							'msg'	 	=> 'Payment Information not updated successfully!..' );
				$this->response($error, 200);
			}
        }
	}
	
   /*
	* 
	* name: fetch_payment_info
	* @param : account_id
	* @return :bankname,bank a/c no,etc.
	* 
	*/
	public function fetch_payment_info_get()
	{  
	  //Get from library file
	  $account_id	= 	$this->user_authentication->account_id;
	  $payment_info =	$this->do_networks->get_payment_info($account_id);
	  $this->response($payment_info, 200);	
	}
	
	/* FOR ADMIN
	* 
	* name: fetch_payment_info
	* @param : account_id
	* @return :bankname,bank a/c no,etc.
	* 
	*/
	public function fetch_admin_payment_info_get()
	{ 
		//Get from library file
		$account_id	= 	$this->user_authentication->account_id;
		$payment_info=$this->do_networks->get_admin_payment_info($account_id);
		$this->response($payment_info, 200);	
	}
   
    /*
	* 
	* name: fetch_paypal_info
	* @param : account_id
	* @return :bankname,bank a/c no,etc.
	* 
	*/
	public function fetch_paypal_info_get()
	{
		//Get from library file
		$account_id	= 	$this->user_authentication->account_id;
		
		$paypal_info=$this->do_networks->get_paypal_info($account_id);
		$this->response($paypal_info, 200);	
	}
	/*
	* 
	* name: fetch_epayments_info
	* @param : account_id
	* @return :bankname,bank a/c no,etc.
	* 
	*/
	public function fetch_epayments_info_get()
	{
		//Get from library file
		$account_id	= 	$this->user_authentication->account_id;
		$epayments_info=$this->do_networks->get_epayments_info($account_id);
		$this->response($epayments_info, 200);	
	}
	/*
	* 
	* name: fetch_webmoney_info
	* @param : account_id
	* @return :bankname,bank a/c no,etc.
	* 
	*/
	public function fetch_webmoney_info_get()
	{
		//Get from library file
		$account_id	= 	$this->user_authentication->account_id;
		$webmoney_info=$this->do_networks->get_webmoney_info($account_id);
		$this->response($webmoney_info, 200);	
	}
	/*
	* 
	* name: fetch_bitcoin_info
	* @param : account_id
	* @return :bankname,bank a/c no,etc.
	* 
	*/
	public function fetch_bitcoin_info_get()
	{
		//Get from library file
		$account_id	= 	$this->user_authentication->account_id;
		$bitcoin_info=$this->do_networks->get_bitcoin_info($account_id);
		$this->response($bitcoin_info, 200);	
	}
	/*
	* 
	* name: fetch_perfectmoney_info
	* @param : account_id
	* @return :bankname,bank a/c no,etc.
	* 
	*/
	public function fetch_perfectmoney_info_get()
	{
		//Get from library file
		$account_id	= 	$this->user_authentication->account_id;
		$perfectmoney_info=$this->do_networks->get_perfectmoney_info($account_id);
		$this->response($perfectmoney_info, 200);	
	}
	/*
	* 
	* name: fetch_paybit_info
	* @param : account_id
	* @return :bankname,bank a/c no,etc.
	* 
	*/
	public function fetch_paybit_info_get()
	{
		//Get from library file
		$account_id	= 	$this->user_authentication->account_id;
		$paybit_info=$this->do_networks->get_paybit_info($account_id);
		$this->response($paybit_info, 200);	
	}
	
	/*
	* 
	* name: fetch_invoice_info
	* @param : account_id
	* @return :bankname,bank a/c no,etc.
	* 
	*/
	public function fetch_invoice_info_get()
	{
		//Get from library file
		$account_id	= 	$this->user_authentication->account_id;
		$invoice_info=$this->do_networks->get_pub_invoice_info($account_id);
		$this->response($invoice_info, 200);	
	}
	
   /*
	* 
	* name: fetch_admin_paypal_info
	* @param : account_id
	* @return :bankname,bank a/c no,etc.
	* 
	*/
	public function fetch_admin_paypal_info_get()
	{
	  //Get from library file
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id	= 	$this->user_authentication->network_account_id;
		}
		else
		{
			$account_id	= 	$this->user_authentication->account_id;
		}
		
		$paypal_info	=	$this->do_networks->get_admin_paypal_info($account_id,$this->user_authentication->account_type);
		
		if($paypal_info)
		{
			$this->response($paypal_info, 200);	
		}
		else
		{
			$this->response('error', 200);	
		}		
	}  
	
    public function add_paypal_post()
	{ 		
	   //Get from library file
		$account_id	= 	$this->user_authentication->account_id;
		$status_check=$this->do_networks->add_paypal_info(clean_data($this->post()), $account_id);
		/*********************************/
		$type     	   = "PUB_PAY_PAL_UPDATED";
		$account_type	=	$this->user_authentication->account_type;	
		$network_id	=	$this->user_authentication->network_account_id;					
		$agency_id	=	$this->user_authentication->agency_id;
		$result		=	$this->do_networks->agency_owner_details($agency_id);
		$admin_name    	= 	$result['name'];			
		$admin_email	= 	$result['email'];	
		$admin_id   	= 	$result['account_id'];
			
		$affiliate_id	=	$this->user_authentication->affiliate_id;
		$reciever = $this->do_message->get_affiliate($affiliate_id); 
		$user = $this->do_message->get_profile($admin_id); 
		$type_details	=	array(
								//'msg_type'		=> $message,
								'type'			=> $type,
								'string'		=> "payment_sett",
								'column_name'	=> "payments"
									);
			 
		$mail_content=array(
				"to_name"	=>	ucfirst($reciever['dj_first_name']).' '.ucfirst($reciever['dj_last_name']),
				"email"		=>	$reciever['email'],
				"from_name"	=>	$user['first_name'].' '.$user['last_name'],
				'type'		=> 	$type,
				'status_check'	=>	$status_check,
				"subject" 		=> "Your Paypal Payment details updated",
				"method"	=> "Paypal",
				"pay_pal_id"=>clean_data($this->post('value'))
		 );
				  
		$message_data		=	array(
				'sender_id'		=>	$admin_id,
				'receiver_id'	=>	$account_id,
				'subject'		=>	'Publisher - Payment method',
				'content'		=> 	'Your payment method updated successfully. Paypal ID:'.$this->post('value'),
				'account_type'	=>	"TRAFFICKER",
				'notification_type'	=>	"payment_setting",	
				'network_id'	=> 	$network_id,
				'status'		=>	'1',
				'date'			=>	date('Y-m-d H:i:s')
				);		
			
		$dd = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);	
		/*********************************/
		if($status_check!="updated")
		{
		   $success = array(
								'response' => 'ok',
								'redirect'=>site_url('publisher/settings/payment_settings'),
								'msg'	 => 'Paypal id is added successfully!..' );
			$this->response($success, 200);
		}
		else
		{	 
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/payment_settings'),
							'msg'	 => 'Paypal id is updated successfully!..' );
			$this->response($success, 200);
		}
	  
	}
	
	public function add_webmoney_info_post()
	{ 		
		//Get from library file
		$account_id	= 	$this->user_authentication->account_id;
		  
		$status_check=$this->do_networks->add_webmoney_info(clean_data($this->post()), $account_id);
		$account_type	=	$this->user_authentication->account_type;	
		$network_id	=	$this->user_authentication->network_account_id;					
		$agency_id	=	$this->user_authentication->agency_id;
		$result		=	$this->do_networks->agency_owner_details($agency_id);
		$admin_name    	= 	$result['name'];			
		$admin_email	= 	$result['email'];	
		$admin_id   	= 	$result['account_id'];
			
		$type     	   = "PUB_WEBMONEY_UPDATED";
		$affiliate_id	=	$this->user_authentication->affiliate_id;
		$reciever = $this->do_message->get_affiliate($affiliate_id); 
		$user = $this->do_message->get_profile($admin_id); 
		
		$type_details	=	array(
									//'msg_type'		=> $message,
									'type'			=> $type,
									'string'		=> "payment_sett",
									'column_name'	=> "payments"
									);
		
		$mail_content=array(
				"to_name"	=>	ucfirst($reciever['dj_first_name']).' '.ucfirst($reciever['dj_last_name']),
				"email"		=>	$this->post('email'),
				"from_name"	=>	$user['first_name'].' '.$user['last_name'],
				'type'		=> 	$type,
				'status_check'	=>	$status_check,
				'method'	=> "Bitcoin",
				'pay_pal_id'    => $this->post('webmoney_acc_no')
			);
		$message_data		=	array(
				'sender_id'		=>	$admin_id,
				'receiver_id'	=>	$account_id,
				'subject'		=>	'Publisher - Webmoney information',
				'content'		=> 	'Your Webmoney information updated successfully',
				'account_type'	=>	"TRAFFICKER",
				'notification_type'	=>	"payment_setting",	
				'status'		=>	'1',
				'network_id'	=>	$network_id,
				'date'			=>	date('Y-m-d H:i:s')
				);		
							
		$dd = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);	
		 
		if($status_check!="updated")
		{
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/payment_settings'),
							'msg'	 => 'Webmoney id is added successfully!..' );
			$publisher_details=$this->do_publisher->get_profile($account_id); 
			//Get admin details
		 
			$this->response($success, 200);
		}
		else
		{
			//Sending mail to publisher for updating their payment settings
			//Get publisher details
			$publisher_details=$this->do_publisher->get_profile(clean_data($this->post('pk'))); 
			//Get admin details
			$account_type	=	$this->user_authentication->account_type;	
			$network_id	=	$this->user_authentication->network_account_id;					
			$agency_id	=	$this->user_authentication->agency_id;
			$result		=	$this->do_networks->agency_owner_details($agency_id);
			$admin_name    	= 	$result['name'];			
			$admin_email	= 	$result['email'];	
			$admin_id   	= 	$result['account_id'];
			
			$user_email    = $publisher_details['email'];
			$user_name     = $publisher_details['first_name']." ".$publisher_details['last_name'];
			$type     	   = "PUB_PAY_PAL_UPDATED";
			$from 		   = $admin_email;
			$to  		   =  $user_email;			
			$mail_content=array(
				"subject" 		=> "Payment details updated - Webmoney",
				"to_name" 		=> $user_name,				
				"from_name"		=> $admin_name,
				"email"  		=> $user_email,
				//'pay_pal_id'    => $this->post('value')      
			 );
			$attachement='';	
			send_mail($type,$from,$to,$mail_content,$attachement,$from); 
			$success = array(
								'response' => 'ok',
								'redirect'=>site_url('publisher/settings/payment_settings'),
								'msg'	 => 'Webmoney is updated successfully!..' );
			$this->response($success, 200);
			//$this->response( $account_id, 200);

		}
	  
	}
	
	public function add_bitcoin_info_post()
	{ 		
		//Get from library file
		$account_id	= 	$this->user_authentication->account_id;
		$status_check=$this->do_networks->add_bitcoin_info(clean_data($this->post()), $account_id);
	    
		$account_type	=	$this->user_authentication->account_type;	
		$network_id	=	$this->user_authentication->network_account_id;					
		$agency_id	=	$this->user_authentication->agency_id;
		$result		=	$this->do_networks->agency_owner_details($agency_id);
		$admin_name    	= 	$result['name'];			
		$admin_email	= 	$result['email'];	
		$admin_id   	= 	$result['account_id'];
			
		$type     	   = "PUB_PAY_PAL_UPDATED";
		$affiliate_id	=	$this->user_authentication->affiliate_id;
		$reciever = $this->do_message->get_affiliate($affiliate_id); 
		$user = $this->do_message->get_profile($admin_id); 
		
		$type_details	=	array(
										//'msg_type'		=> $message,
										'type'			=> $type,
										'string'		=> "payment_sett",
										'column_name'	=> "payments"
										);
			
		$mail_content=array(
				"to_name"	=>	ucfirst($reciever['dj_first_name']).' '.ucfirst($reciever['dj_last_name']),
				"email"		=>	$this->post('email'),
				"from_name"	=>	$user['first_name'].' '.$user['last_name'],
				'type'		=> 	$type,
				'status_check'	=>	$status_check,
				'method'	=> "Bitcoin"
				 
			);
					
		$message_data		=	array(
				'sender_id'		=>	$admin_id,
				'receiver_id'	=>	$account_id,
				'subject'		=>	'Publisher - Bitcoin Information',
				'content'		=> 	'Your bitcoin Information updated successfully',
				'account_type'	=>	"TRAFFICKER",
				'notification_type'	=>	"payment_setting",	
				'status'		=>	'1',
				'network_id'	=>	$network_id,				
				'date'			=>	date('Y-m-d H:i:s')
				);		
							
		$dd = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);	
		
		if($status_check!="updated")
		{
		
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/payment_settings'),
							'msg'	 => 'Bitcoin  is added successfully!..' );
			$this->response($success, 200);
		}
		else
		{
			//Sending mail to publisher for updating their payment settings
			//Get publisher details
			$publisher_details=$this->do_publisher->get_profile(clean_data($this->post('pk'))); 
			//Get admin details
			$success = array(
								'response' => 'ok',
								'redirect'=>site_url('publisher/settings/payment_settings'),
								'msg'	 => 'Bitcoin is updated successfully!..' );
			$this->response($success, 200);
		}	  
	}
	
	/*admin add webmoney start */
	
	public function admin_add_webmoney_info_post()
	{ 		
	   //Get from library file
	   $account_id	= 	$this->user_authentication->account_id;
	
	  
	  $status_check=$this->do_networks->admin_add_webmoney_info($this->post(), $account_id);
	//  echo $this->resopnse($status_check,200);
	  if($status_check!="updated")
	  {
	   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => 'Webmoney id is added successfully!..' );
		$this->response($success, 200);
	  }
	  else
	  {
	   {
	   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => 'Webmoney id  is updated successfully!..' );
		$this->response($success, 200);
	  }

	  }
	  
	}
	
	
	/*admin add webmoney end  */
	
	
	/* admin bitcoind add payment methored start */
	
	public function admin_add_bitcoin_info_post()
	{ 		//print_r($this->response($this->post()));
	//exit;
	   //Get from library file
	  $account_id	= 	$this->user_authentication->account_id;
	  $status_check=$this->do_networks->admin_add_bitcoin_info($this->post(), $account_id);
	  //echo $this->resopnse($status_check,200); 
	  if($status_check!="updated")
	  {
		
	   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => 'Bitcoin Address updated successfully!..' );
		$this->response($success, 200);
	  }
	  else
	  {
	   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => 'Bitcoin Address  updated successfully!..' );
		$this->response($success, 200);
	  }
	  
	}
	
	
	/*  admin bitcoind add payment methored End  */
	
	public function add_perfectmoney_info_post()
	{ 		
	   //Get from library file
	  $account_id	= 	$this->user_authentication->account_id;
	  $status_check=$this->do_networks->add_perfectmoney_info(clean_data($this->post()), $account_id);
	  if($status_check!="updated")
	  {
	   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/payment_settings'),
							'msg'	 => 'Perfect Money id is added successfully!..' );
		$this->response($success, 200);
	  }
	  else
	  {
	   //Sending mail to publisher for updating their payment settings
		//Get publisher details
		$publisher_details=$this->do_publisher->get_profile(clean_data($this->post('pk'))); 
		//Get admin details
		$account_type	=	$this->user_authentication->account_type;	
		$network_id	=	$this->user_authentication->network_account_id;					
		$agency_id	=	$this->user_authentication->agency_id;
		$result		=	$this->do_networks->agency_owner_details($agency_id);		
		$admin_name    = $result['firstname']." ".$result['lastname'];			
		$admin_email   = $result['email'];
		$user_email    = $publisher_details['email'];
		$user_name     = $publisher_details['first_name']." ".$publisher_details['last_name'];
		$type     	   = "PUB_PAY_PAL_UPDATED";
		$from 		   = $admin_email;
		$to  		   =  $user_email;			
		$mail_content=array(
			"subject" 		=> "Payment details updated - Perfectmoney",
			"to_name" 		=> $user_name,				
			"from_name"		=> $admin_name,
			"email"  		=> $user_email
			//'pay_pal_id'    => $this->post('value')      
		 );
		$attachement='';	
	    send_mail($type,$from,$to,$mail_content,$attachement,$from); 
	   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/payment_settings'),
							'msg'	 => 'PerfectMoney is updated successfully!..' );
		$this->response($success, 200);
	  }
	  
	}
	
	public function add_epayments_info_post()
	{ 		
	   //Get from library file
	  $account_id	= 	$this->user_authentication->account_id;
	  $status_check=$this->do_networks->add_epayments_info(clean_data($this->post()), $account_id);
	  if($status_check!="updated")
	  {
	   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/payment_settings'),
							'msg'	 => 'Epayments id is added successfully!..' );
		$this->response($success, 200);
	  }
	  else
	  {
	   //Sending mail to publisher for updating their payment settings
		//Get publisher details
		$publisher_details=$this->do_publisher->get_profile(clean_data($this->post('pk'))); 
		//Get admin details
		$account_type	=	$this->user_authentication->account_type;	
			$network_id	=	$this->user_authentication->network_account_id;					
			$agency_id	=	$this->user_authentication->agency_id;
			$result		=	$this->do_networks->agency_owner_details($agency_id);			
		$admin_name    = $result['firstname']." ".$result['lastname'];			
		$admin_email   = $result['email'];
		$admin_id   	= 	$result['account_id'];
		$user_email    = $publisher_details['email'];
		$user_name     = $publisher_details['first_name']." ".$publisher_details['last_name'];
		$type     	   = "PUB_PAY_PAL_UPDATED";
		$from 		   = $admin_email;
		$to  		   =  $user_email;			
		$mail_content=array(
			"subject" 		=> "Payment details updated - Epayments",
			"to_name" 		=> $user_name,				
			"from_name"		=> $admin_name,
			"email"  		=> $user_email     
		 );
		$attachement='';	
	    send_mail($type,$from,$to,$mail_content,$attachement,$from); 
	   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/payment_settings'),
							'msg'	 => 'Epayments is updated successfully!..' );
		$this->response($success, 200);
	  }
	  
	}
	
	public function add_paybit_info_post()
	{ 		
	   //Get from library file
	  $account_id	= 	$this->user_authentication->account_id;
	  $status_check=$this->do_networks->add_paybit_info(clean_data($this->post()), $account_id);
	  if($status_check!="updated")
	  {
	   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/payment_settings'),
							'msg'	 => 'Paybit is added successfully!..' );
		$this->response($success, 200);
	  }
	  else
	  {
	   //Sending mail to publisher for updating their payment settings
		//Get publisher details
		$publisher_details=$this->do_publisher->get_profile(clean_data($this->post('pk'))); 
		//Get admin details
		$account_type	=	$this->user_authentication->account_type;	
			$network_id	=	$this->user_authentication->network_account_id;					
			$agency_id	=	$this->user_authentication->agency_id;
			$result		=	$this->do_networks->agency_owner_details($agency_id);
			$admin_name    	= 	$result['name'];			
			$admin_email	= 	$result['email'];	
			$admin_id   	= 	$result['account_id'];
		$user_email    = $publisher_details['email'];
		$user_name     = $publisher_details['first_name']." ".$publisher_details['last_name'];
		$type     	   = "PUB_PAY_PAL_UPDATED";
		$from 		   = $admin_email;
		$to  		   =  $user_email;			
		$mail_content=array(
			"subject" 		=> "Payment details updated - Paybit",
			"to_name" 		=> $user_name,				
			"from_name"		=> $admin_name,
			"email"  		=> $user_email,
			//'pay_pal_id'    => $this->post('value')      
		 );
		$attachement='';	
	    send_mail($type,$from,$to,$mail_content,$attachement,$from); 
	   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/payment_settings'),
							'msg'	 => 'Paybit is updated successfully!..' );
		$this->response($success, 200);
	  }
	  
	}
	
	
	/*
	* 
	* name: admin_add_paypal
	* @param : none
	* @return : true or false.
	* 
	*/
	 public function admin_add_paypal_post()
	{
	   //Get from library file
	  $account_id	= 	$this->user_authentication->account_id;
	  $status_check=$this->do_networks->admin_add_paypal_info(clean_data($this->post()),$account_id);
	  if($status_check!="updated")
	  {
	   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => 'Paypal id is added successfully!..' );
		$this->response($success, 200);
	  }
	  else
	  {
	   $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => 'Paypal id is updated successfully!..' );
		$this->response($success, 200);
	  }
	  
	}
	
	/*
	* 
	* name: publisher_payment_mode
	* @param : account_id,payment_mode values
	* @return : true or false.
	* 
	*/
	public function publisher_payment_mode_post()
	{  
	    //Get from library file
	   $account_id	= 	$this->user_authentication->account_id;
	   $payment_mode=$this->do_networks->update_payment_mode(clean_data($this->post()), $account_id);
	   if($payment_mode)
	   {
			/* Activity Log for Payment settings - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,PAYMENT_SETTINGS);
				if($enable=='1')
				{							
				$this->activity_log(PAYMENT_MODE,EDIT);
				}
			/* Activity Log for Payment settings - End*/
			$type='USER_PAYMENT_METHOD';		
			$affiliate_id	=	$this->user_authentication->affiliate_id;
			$reciever = $this->do_message->get_affiliate($affiliate_id); 
			
			$account_type	=	$this->user_authentication->account_type;	
			$network_id	=	$this->user_authentication->network_account_id;					
			$agency_id	=	$this->user_authentication->agency_id;
			$result		=	$this->do_networks->agency_owner_details($agency_id);
			$admin_name    	= 	$result['name'];			
			$admin_email	= 	$result['email'];	
			$admin_id   	= 	$result['account_id'];
			
			$user = $this->do_message->get_profile($admin_id); 
			
			$type_details	=	array(
									'msg_type'		=> $message,
									'type'			=> $type,
									'string'		=> "payment_sett",
									'column_name'	=> "payments"
									);
			$message_data		=	array(
					'sender_id'		=>	$admin_id,
					'receiver_id'	=>	$account_id,
					'subject'		=>	'Publisher- Payment method',
					'content'		=> 	'Payment mode has been changed successfully',
					'account_type'	=>	"TRAFFICKER",
					'notification_type'	=>	"payment_setting",	
					'status'		=>	'1',
					'network_id'	=>	$network_id,
					'date'			=>	date('Y-m-d H:i:s')
									);		
			$dd = $this->notification->new_mail($message_data,$user,$reciever,$type_details);			
		  
			
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/payment_settings'),
							'msg'	 => 'Payment mode updated successfully!..' );
			$this->response($success, 200);
	   }
	   else
	   {
	       $success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/settings/payment_settings'),
							'msg'	 => 'Unable to update your payment mode!..' );
		  $this->response($success, 200);
	   
	   }
	}
	
	/*
	* 
	* name: admin_earning_post
	* @param : account_id,account_type values
	* @return : true or false.
	* 
	*/
	public function admin_earning_post()
	{	
		
		
		 //Get from library file
 		$account_id	= 	$this->user_authentication->account_id;
		$account_type 	= 	$this->user_authentication->account_type;
		
		$earning 		= 	$this->do_networks->admin_earning($account_id,$account_type);
			
		if($earning)
		{
			$success 	= 	array('response'	=> 	'ok',
								  'msg'			=> 	$earning
								);
			
			$this->response( $success, 200);
		}
		else
		{			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	''
								);
			
			$this->response( $error, 200);
		}			
		
	}
	
	/*
	* 
	* name: get_network_account_details
	* @param : none
	* @return : admin wire-account details
	* 
	*/
	public function get_network_account_details_get()
	{
		$get_account_details=$this->do_networks->get_network_admin_account_details();
		$this->response($get_account_details);
	}
	
	
	/*
	 * 
	 * name: account_settings_add
	 * @param :null
	 * @return : response Array
	 * 
	 * Add/update the Account Setting Information for Admin
	 */
	
    public function account_settings_update_role_post(){		
		
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|callback_user_role_email_check');
		//$this->form_validation->set_rules('another_email','Another Email','trim|required|valid_email');
		#$this->form_validation->set_rules('currency_to_view', 'Currency', 'trim|required');
		$this->form_validation->set_rules('password', 'New password', 'trim|matches[conf_password]');
		$this->form_validation->set_rules('conf_password', 'Repeat password', 'trim|matches[password]');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			$user_id=$this->user_authentication->manager_user_id;	
			
			$account_id=$this->user_authentication->account_id;	
			//GET CURRENT PASSWORD FROM djax_users
			$db_old_pass=$this->do_publisher->get_current_user_role_pass($user_id);
			
			$account_setting_type="account";
			
			$current_password=trim($this->post('current_password'));
			
			if(md5($current_password)==$db_old_pass || $current_password=='')
			{   
			     $update_setting_infoObj=array(
										
										"email"  =>	clean_data($this->post('email')),
										#"alternate_email"	=>	$this->post('another_email'),
										#"currency" 	=>	$this->post('currency_to_view'),
										"password"=>clean_data($this->post('password')),
										"email_updated"=>clean_data(date("Y-m-d H:i:s")),
										"acc_id"   =>$account_id
							    	);	
		    $this->do_networks->update_user_role($user_id,$update_setting_infoObj);	
		     $enable_twofactor = clean_data($this->post('enable_twofactor'));
		    
				if($enable_twofactor){
					$security_enable = 1; 	
				}
				else{
					$security_enable = 0; 
				}
					$security_info = array(
					"security_enable"=>$security_enable,
					
					);
				$this->do_app_config->update_security_info($account_id,$security_info);				
			//SEND MAIL TO ADMIN / MANAGERS
			$result=$this->do_networks->get_network_details();
			//Get user name from ox_users
			$user_name=$this->do_networks->get_user_role_info($user_id);
			$admin_name    = $result['firstname']." ".$result['lastname'];			
			$admin_email   = $result['email'];
			$user_email    = clean_data($this->post('email'));
			$user_name     =  $user_name[0]['contact_name'];
			$type     	   = (clean_data($this->post('password'))!='')?"ADMIN_CHANGE_PASSWORD":"ADMIN_SETTING_INFORMATION";
			$from 		   = $admin_email;
			$to  		   =  $user_email;
			if(clean_data($this->post('password'))!='')
			{			
				//If Admin change his password then it will works
				$mail_content=array(
						"subject" 		=> "Admin - Change Password",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,							
						"email"   		=> clean_data($this->post('email')),
						"password"		=> clean_data($this->post('password')),
						"account_type"	=> "admin"							
					);		
			log_message("error" ,"if".$mail_content);
			}
			else
			{
			    //Send only email,alternate email to their email
				$mail_content=array(
								"subject" 		=> "Admin - Account Settings Information",
								"to_name" 		=> $user_name,				
								"from_name"		=> $admin_name,							
								"email"   		=> clean_data($this->post('email')),
								"alternate_email" => clean_data($this->post('another_email')),
								"currency"		=> clean_data($this->post('currency_to_view')),
								"account_type"	=> "admin"		
								);
			
			log_message("error" ,"else".$mail_content);
			}
			
		   $attachement='';	
		   send_mail($type,$from,$to,$mail_content,$attachement,$from); 
		   
			 $success = array(
								'response' => 'ok',
								'redirect'=>site_url('admin/settings/account_settings'),
								'msg'	 => 'Account Settings Information are updated successfully!..'
				);
			  
			    $this->response($success, 200); 
			  }
			   else
			   {
			       $error = array(
							'response' => 'error',
							'redirect'=>site_url('admin/settings/account_settings'),
							'msg'	 => 'Please enter your current password correctly!..'
							);
			       $this->response($error, 200);
			   
			   }
		
		}

	}
	
	/*
	 * name: fetch_mobile_screen_get
	 * @param :null
	 * @return : mobile screen details
	 * 
	*/
	function fetch_mobile_screen_get()
	{
		$screen_config = $this->do_networks->get_screen_sizes();
		$this->response($screen_config,200); 
	}
	
	/*
	 * name: fetch_display_screen_get
	 * @param :null
	 * @return : display screen details
	 * 
	*/
	function fetch_display_screen_get()
	{
		$screen_config = $this->do_networks->get_display_screen_sizes();
		$this->response($screen_config,200); 
	}
	/*
	 * name: fetch_display_size_get
	 * @param :null
	 * @return : display size details
	 * 
	*/
	function fetch_display_size_get()
	{
		$screen_config = $this->do_networks->get_display_size();
		$this->response($screen_config,200); 
	}
	
	function fetch_app_configuration_get()
	{
		$app_config = $this->do_networks->get_app_details();
		$this->response($app_config,200); 
	}
	
	/*
	 * name: edit_screen_size_get
	 * @param :null
	 * @return : edit mobile screen details
	 * 
	*/
	function edit_screen_size_get()
	{
		$screen_id = $this->get('screen_id');
		$mobile_data = $this->do_networks->get_screen_data($screen_id);
		$this->response($mobile_data,200); 
	}
	
	/*
	 * name: edit_display_screen_size_get
	 * @param :null
	 * @return : edit display screen details
	 * 
	*/
	function edit_display_screen_size_get()
	{
		$screen_id = $this->get('screen_id');
		$mobile_data = $this->do_networks->get_display_screen_sizes($screen_id);
		$this->response($mobile_data,200); 
	}
	
	/*
	 * name: block_screen_get
	 * @param :null
	 * @return : block mobile screen details
	 * 
	*/
	public function block_screen_get()
	{
		$screen_id=$this->get('id');
		if($screen_id)
		{
			$block_screen = $this->do_networks->block_screen_data($screen_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Sleceted screen size blocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/*
	 * name: unblock_screen_get
	 * @param :null
	 * @return : Unblock mobile screen details
	 * 
	*/
	public function unblock_screen_get()
	{
		$screen_id=$this->get('id');
		if($screen_id)
		{
			$block_screen = $this->do_networks->unblock_screen_data($screen_id);
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Sleceted screen size Unblocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/*
	 * name: block_screen_get
	 * @param :null
	 * @return : block mobile screen details
	 * 
	*/
	public function block_display_screen_get()
	{
		$screen_id=$this->get('id');
		$screen_type = "display";
		if($screen_id)
		{
			$block_screen = $this->do_networks->block_screen_data($screen_id,$screen_type);
			
			/* Activity Log - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,SCREEN_BLOCK);
					if($enable=='1')
					{							
					$this->activity_log(SCREEN,BLOCK);
					}
					/* Activity Log - End*/
			
			
			
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Sleceted screen size blocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/*
	 * name: unblock_screen_get
	 * @param :null
	 * @return : Unblock mobile screen details
	 * 
	*/
	public function unblock_display_screen_get()
	{
		$screen_id=$this->get('id');
		$screen_type = "display";
		if($screen_id)
		{
			$block_screen = $this->do_networks->unblock_screen_data($screen_id,$screen_type);
			
			/* Activity Log - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,SCREEN_UNBLOCK);
					if($enable=='1')
					{							
					$this->activity_log(SCREEN,UNBLOCK);
					}
					/* Activity Log - End*/
			
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Sleceted screen size Unblocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/*
	 * name: update_screen_post
	 * @param :null
	 * @return : update mobile screen details
	 * 
	*/
	public function update_screen_post()
	{
		$screen_id = clean_data($this->post('screen_id'));
		$this->form_validation->set_rules('screen_name','Screen Name', 'required|trim|first_alpha_check|alpha_numeric_dash_space');
		$this->form_validation->set_rules('screen_width', 'Screen Width', 'required|trim|is_numeric');
		$this->form_validation->set_rules('screen_height', 'Screen Height', 'required|trim|is_numeric|callback_edit_screen_resolution_check');
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$update_data		=	array(
										 'name'		=>	clean_data($this->post('screen_name')),
										 'value'	=>	clean_data($this->post('screen_value')),
										 'width'	=>	clean_data($this->post('screen_width')),
										 'height'	=> 	clean_data($this->post('screen_height'))
										 ); 
			$screen_type = clean_data($this->post('screen_type'));
			
			$set_update = $this->do_networks->update_mobile_screens($update_data,$screen_id,$screen_type);
			
			
			/* Activity Log - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,SCREEN_EDIT);
					if($enable=='1')
					{							
					$this->activity_log(SCREEN,EDIT);
					}
					/* Activity Log - End*/
			
			
			if($set_update)
			{
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Screen size has been updated successfully!..'
								);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
								);
				$this->response( $error, 200);
			}
										 
		}
	}
	
	/*
	 * name: edit_screen_resolution_check
	 * @param :null
	 * @return : check for already exist mobile screen details
	 * 
	*/
	public function edit_screen_resolution_check()
	{
		$id			=	clean_data($this->post('screen_id'));
		$width 		=	clean_data($this->post('screen_width'));
		$height		=	clean_data($this->post('screen_height'));
		$screen_type = 	clean_data($this->post('screen_type'));
		$count		=	$this->do_networks->dup_resolution_check($id,$width,$height,$screen_type);		
			   
		if($count>0 )
		{
			$this->form_validation->set_message('edit_screen_resolution_check', "This width & height already Exists");
			return FALSE;	
		}
		else
		{
			return true;
		}
	}
	
		
	/*
	 * name: add_screen_post
	 * @param :null
	 * @return : add new mobile screen details
	 * 
	*/ 
	public function add_screen_post()
	{
		$this->form_validation->set_rules('screen_name','Screen Name', 'required|trim|first_alpha_check|alpha_numeric_dash_space');
		//$this->form_validation->set_rules('screen_value','Screen Value', 'required|trim|callback_check_screen_value');
		$this->form_validation->set_rules('screen_width', 'Screen Width', 'required|trim|is_numeric');
		$this->form_validation->set_rules('screen_height', 'Screen Height', 'required|trim|is_numeric|callback_screen_resolution_check');
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$ins_data		=	array(
										 'name'		=>	clean_data($this->post('screen_name')),
										 'value'	=>	clean_data($this->post('screen_value')),
										 'width'	=>	clean_data($this->post('screen_width')),
										 'height'	=> 	clean_data($this->post('screen_height')),
										 'status'	=> 0
										 );
			$screen_type = clean_data($this->post('screen_type'));
			$insert = $this->do_networks->insert_new_screen($ins_data,$screen_type);
			
					/* Activity Log - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,SCREEN_ADD);
					if($enable=='1')
					{							
					$this->activity_log(SCREEN,ADD);
					}
					/* Activity Log - End*/
			
			
			
			
			if($insert)
			{
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Screen size has been added successfully!..'
								);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
								);
				$this->response( $error, 200);
			}							 
		}
	}
	
	public function check_screen_value()
	{
		$scr_val	=	clean_data($this->post('screen_value'));
		$count		=	$this->do_networks->dup_screen_value($scr_val);		
			   
		if($count>0 )
		{
			$this->form_validation->set_message('check_screen_value', "This value already exist");
			return FALSE;	
		}
		else
		{
			return true;
		}
	} 
	
	public function screen_resolution_check()
	{
		$width 		=	clean_data($this->post('screen_width'));
		$height		=	clean_data($this->post('screen_height'));
		$screen_type = 	clean_data($this->post('screen_type'));
		$count		=	$this->do_networks->dup_resolution_screen_check($width,$height,$screen_type);		
			   
		if($count>0 )
		{
			$this->form_validation->set_message('screen_resolution_check', "This width & height already Exists");
			return FALSE;	
		}
		else
		{
			return true;
		}
	}
	
	function check()
	{
		$t=clean_data($this->input->post('city'));
		if( ! preg_match("/^([-a-z_ ])+$/i", $t))
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
		
	}
	
	function state()
	{
		$s=clean_data($this->input->post('state'));
		if( ! preg_match("/^([-a-z_ ])+$/i", $s))
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
		
	}
	
	function company_test()
	{
		$tt=clean_data($this->input->post('company_city'));
		print_r($tt);exit;
		if(  !preg_match("/^([-a-z_ ])+$/i", $tt))
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
		
	}
	
	function company_check()
	{
		$ss=clean_data($this->input->post('company_state'));
		if( !preg_match("/^([-a-z_ ])+$/i", $ss))
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
		
	}
	
	
	public function admin_payment_mode_post()
	{  
	    //Get from library file
	   $account_id	= 	$this->user_authentication->account_id;
	   
	    /* Activity Log for approve payment - Start*/				
		
				$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,PAYMENT_TYPE_CHANGE);
					if($enable=='1')
					{		
					$this->activity_log(PAYMENT,PAYMENT_TYPE_CHANGE);							
					}
				/* Activity Log for approve payment - End*/	  
	   
	   
	   $payment_mode=	$this->do_networks->admin_update_payment_mode(clean_data($this->post()), $account_id);
	   if($payment_mode)
	   {
	      $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => 'Payment mode updated successfully!..' );
		  $this->response($success, 200);
	   }
	   else
	   {
	       $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/payment_settings'),
							'msg'	 => 'Unable to update your payment mode!..' );
		  $this->response($success, 200);
	   
	   }
	}
	
	
	/*
	 * 
	 * name: send_mass_email
	 * @param :null
	 * @return : response Array
	 * 
	 * send mass email to advertisers and publishers
	 */
	
    public function send_mass_email_post(){		
		

		if(clean_data($this->post('select_advertiser'))=="select_adv")
		{
			$this->form_validation->set_rules('advertiser[]','Advertiser','trim|required');
		}
		else
		{
			$this->form_validation->set_rules('select_advertiser', 'Select Advertiser', 'required');
		}
		if(clean_data($this->post('select_publisher'))=="select_pub")
		{
			$this->form_validation->set_rules('publisher[]','Publisher','trim|required');
		}
		else{
			$this->form_validation->set_rules('select_publisher', 'Select Publisher', 'required');
		}
	//	$this->form_validation->set_rules('subject_name', 'Subject Name', 'trim|required');
		//$this->form_validation->set_rules('ck', 'Message', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$network_account_id	=	$this->user_authentication->network_account_id;
			$network_id			=	$this->user_authentication->account_id;
			$agency_id			=	$this->user_authentication->agency_id;
			 //Get from library file
		     $account_id	= 	$this->user_authentication->account_id;	
		     
		     $default_user_id = $this->user_authentication->user_id;
		     
		     $adv_count=$this->post('adv_count');
		     	
			 $pub_count=$this->post('pub_count');
			 
			 $increment_val=$this->post('inc_val');	
			
			if(clean_data($this->post('select_advertiser'))=="all_adv")
			{
				$advertisers = $this->do_networks->fetch_adv_email($network_id, $network_account_id);
			
				foreach($advertisers as $adv)
				{
					
					foreach($adv as $aval)
					{
						$adv_to_mail[] = $aval;
					}  
					  
				}
				
				if($adv_count > $increment_val)
				{
				$adv_limit = $this->post('adv_limit');
				$memcache_adv = explode('-',$adv_limit[0]);
				$set_adv= array_slice($adv_to_mail,$memcache_adv[0],$memcache_adv[1]);
				}
				else{
				$set_adv=$adv_to_mail;
				}
				
				
			}
			
			else
			{
				$set_adv = clean_data($this->post('advertiser'));
					
			}
			
			if(clean_data($this->post('select_publisher'))=="all_pub")
			{
				$publishers = $this->do_networks->fetch_pub_email($network_id, $network_account_id);
				
				foreach($publishers as $pub)
				{
					foreach($pub as $pval)
					{
						$pub_to_mail[] = $pval;
					}    
				}
				if($pub_count > $increment_val)
				{
				$pub_limit = $this->post('pub_limit');
				$memcache_pub = explode('-',$pub_limit[0]);
				$set_pub= array_slice($pub_to_mail,$memcache_pub[0],$memcache_pub[1]);
				}
				else{
				$set_pub=$pub_to_mail;
				}
			}
			else
			{
				$set_pub = clean_data($this->post('publisher'));
			}
			
			$country = clean_data($this->post('country'));
			$state_val = clean_data($this->post('state_val'));
			$adv_balance = clean_data($this->post('adv_balance'));
			$impression_limit = clean_data($this->post('impression_limit'));
			$click_limit = clean_data($this->post('click_limit'));
			$conversion_limit = clean_data($this->post('conversion_limit'));
			$revenue = clean_data($this->post('revenue'));
			$payment_type = clean_data($this->post('payment_type'));
			$acc_type = clean_data($this->post('acc_type'));

		if($acc_type==1)
		{
			
			$country_mail = $this->do_networks->fetch_adv_country_email_filter($set_adv, $country,$state_val,$adv_balance,$impression_limit,$click_limit,$conversion_limit);
		}
		else
		{
				
		$country_mail = $this->do_networks->fetch_pub_country_email_filter($set_pub, $country,$revenue,$payment_type,$impression_limit,$click_limit,$conversion_limit);
		}
//	print_r($country_mail);exit;
			$memcache_set = clean_data($this->post('slot1'));
		
			$to_mail = array_merge($set_adv,$set_pub);
			//$this->response($to_mail,200);
			
					//SEND MAIL TO ADMIN
			$result=$this->do_networks->get_network_details();			
	/*		$admin_name    = $result['firstname']." ".$result['lastname'];			
			$admin_email   = $result['email'];
			$user_email    = clean_data($this->post('email'));
			$user_name     =  $admin_name;
			$type     	   = "MASS_EMAIL";
			$from 		   = $admin_email;
			$subject 	   = clean_data($this->post('subject_name'));
			//If Admin change his password then it will works
			$attachement='';
			$mail_content=array(
					"subject"		=> $subject,
					"message"		=> clean_data($this->post('message')),
					"from_name"		=> $admin_name
				);
				 */
	/*			
		  if(is_array($to_mail))
		  {
				foreach($to_mail as $email_id)
				 {
					 $to  =  $email_id;
					 send_mail($type,$from,$to,$mail_content,$attachement,$from,$subject); 
				 }
			 }
			 else
			 {
				 $to  =  $to_mail;
				send_mail($type,$from,$to,$mail_content,$attachement,$from,$subject); 
			 }	
		   
		  */
			 $success = array(
							'response' => 'ok',
							'redirect'=>site_url('admin/settings/mass_email'),
							'msg'	 => 'Mail has been sent successfully!..'
			);
		  
			$this->response($success, 200); 
		}

	}
	
	/*name:template file upload
	 * @param:null
	 * 
	 */
	 
	 public function temp_upload_post()
	 {
		
		  $upload_path = $this->config->item('email_tmp_upload_path');
		 // print_r($upload_path);exit;
        $config['allowed_types'] = '*';
        $config['max_filename'] = '255';
        $config['encrypt_name'] = TRUE;
        $config['max_size'] = '1024'; //1 MB
 
        if (isset($_FILES['file']['name'])) {
            if (0 < $_FILES['file']['error']) {
                echo 'Error during file upload' . $_FILES['file']['error'];
            } else {
                if (file_exists($this->config->item('email_tmp_upload_path'). $_FILES['file']['name'])) {
                    echo 'File already exists : uploads/' . $_FILES['file']['name'];
                } else {
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('file')) {
                        echo $this->upload->display_errors();
                    } else {
                        echo 'File successfully uploaded : uploads/' . $_FILES['file']['name'];
                    }
                }
            }
        } else {
            echo 'Please choose a file';
        }
		
		}
	 
	/*
	 * 
	 * name: update_add_div_link
	 * @param :null
	 * @return : response Array
	 * 
	 * update_add_div_link_post
	 */
	
    public function update_add_div_link_post()
    {		
		$this->form_validation->set_rules('select_publisher', 'Select Publisher', 'trim');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$network_account_id	=	$this->user_authentication->network_account_id;
			$network_id			=	$this->user_authentication->account_id;
			
			$publishers = 	$this->do_publisher->fetch($network_id,$network_account_id);
			
			foreach($publishers as $p)
			{	
				$where_aff	=	array(
									'account_id'	=>	$p['account_id']
								);
				
				$adblocks 	= 	$this->do_publisher->fetch_adblocks($p['account_id']);
												
				if(clean_data($this->post('select_publisher'))=='select_pub' && clean_data($this->post('publisher')) && in_array($p['account_id'],clean_data($this->post('publisher'))))
				{		
					$update_aff		=	array(
											'is_div_link'	=>	1
										);			
					
													
					foreach($adblocks as $a)
					{
						$where_adb	=	array(
										'zoneid'		=>	$a['zoneid']
									);
						
						if(clean_data($this->post('select_adblock'))=='select_adb' && clean_data($this->post('adblock')) && in_array($a['zoneid'],clean_data($this->post('adblock'))))
						{
							$update_adb	=	array(
											'is_div_link'	=>	1
										);
						}
						else
						{
							$update_adb	=	array(
											'is_div_link'	=>	((clean_data($this->post('select_adblock'))=="all_adb")?'-1':0)
										);
						}					
										
						$this->do_publisher->update_div_link(TAB_ZONES,$update_adb,$where_adb);
					}
				}
				else
				{
					$update_aff	=	array(
										'is_div_link'	=>	((clean_data($this->post('select_publisher'))=="all_pub")?'-1':0)
									);
					foreach($adblocks as $a)
					{
						$where_adb	=	array(
										'zoneid'		=>	$a['zoneid']
									);
									
						$update_adb	=	array(
											'is_div_link'	=>	((clean_data($this->post('select_publisher'))=="all_pub")?'-1':((clean_data($this->post('select_adblock'))=="all_adb")?'-1':0))
										);
									
						$this->do_publisher->update_div_link(TAB_ZONES,$update_adb,$where_adb);
					}
				}
				
				$upd_status	=	$this->do_publisher->update_div_link(TAB_AFFILIATE,$update_aff,$where_aff);
				
			}
			
			if($upd_status)
			{	
				$this->response(array('response'=>'ok','msg'=>'Div Link successfully added for selected publishers.'),200);
			}
			else
			{				
				$this->response(array('response'=>'error','msg'=>'Error! try again..'),200);
			}
			
		}
	}	
	
	/*
	 * 
	 * name: fetch_div_link_get
	 * @param :null
	 * @return : response Array
	 * 
	 * fetch_div_link_get
	 */
	
	
	public function fetch_div_link_get()
	{					
		$account_id 	= 	$this->get('account_id');
		
		$table 			= 	$this->get('table');
		
		$where			=	array('oxza.is_div_link'=>$this->get('is_div_link'));
				
		$link_list 		= 	$this->do_publisher->fetch_div_link($table,$where,$account_id);
			
		if($link_list)
		{
			$this->response($link_list,200);
		}
		else
		{
			$this->response('error',200);
		}		
	}	
	
	/*
	* 
	* name: fetch_admin_paypal_info
	* @param : account_id
	* @return :bankname,bank a/c no,etc.
	* 
	*/
	public function fetch_admin_payinfo_get()
	{
		
		//Get from library file
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id	= 	$this->user_authentication->network_account_id;
			$where	=	array(
						'network_account_id'	=>	$account_id,
						'payment_type'			=>	$this->get('payment_type')
					);
		}
		else
		{
			$account_id	= 	$this->user_authentication->account_id;
			$where	=	array(
						'account_id'	=>	$account_id,
						'payment_type'	=>	$this->get('payment_type')
					);
		}
		$account_type	=	$this->user_authentication->account_type;		
		
		$authorize_info	=	$this->do_networks->fetch_admin_payinfo($where,$account_type);
		
		if($authorize_info)
		{
			$this->response($authorize_info, 200);	
		}
		else
		{
			$this->response('error', 200);	
		}		
	}
	 /*
	* 
	* name: fetch_admin_webmoney_info
	* @param : account_id
	* @return :bankname,bank a/c no,etc.
	* 
	*/
	public function fetch_admin_webmoney_info_get()
	{
		 
	  //Get from library file
	 	if($this->user_authentication->account_type=='ADVERTISER')
		{  
			$account_id	= 	$this->user_authentication->network_account_id;
		}
		else
		{ 
			$account_id	= 	$this->user_authentication->account_id;
		}
		
		$webmoney_info	=	$this->do_networks->get_admin_webmoney_info($account_id,$this->user_authentication->account_type);
		 
		if($webmoney_info)
		{
			$this->response($webmoney_info, 200);	
		}
		else
		{
			$this->response('error', 200);	
		}	 
	} 
	
	public function update_zonebid_get()
	{
		$campaignid	=	clean_data($this->get('campaignid'));
		$zoneid		=	clean_data($this->get('zoneid'));
		$bid_rate	=	clean_data($this->get('bid_rate'));
		if($this->user_authentication->account_type=='ADVERTISER')
		{			
			$account_id	= 	$this->user_authentication->account_id;
		}
		else
		{
			$account_id	= 	'';
		}
								 
		$zone_bidding_list = $this->do_networks->update_zone_bidding($campaignid,$zoneid,$bid_rate);
		
		$success = array( 
								'response'	=>	'ok',
								'msg'		=>	'Bid rate updated successfully'
							);
		$this->response($success, 200);			
	}
	
	public function update_trafficbid_get()
	{
		$traffic_id	=	clean_data($this->get('traffic_id'));
		$campaignid	=	clean_data($this->get('campaignid'));
		$bid_rate	=	clean_data($this->get('bid_rate'));
		if($this->user_authentication->account_type=='ADVERTISER')
		{			
			$account_id	= 	$this->user_authentication->account_id;
		}
		else
		{
			$account_id	= 	'';
		}
								 
		$zone_bidding_list = $this->do_networks->update_traffic_bidding($traffic_id,$campaignid,$bid_rate);  
		
		$success = array( 
								'response'	=>	'ok',
								'msg'		=>	'Bid rate updated successfully'
							);
		$this->response($success, 200);
		
			
	}
	
	public function fetch_zone_bidding_get()
	{ 
		$filter	=	clean_data($this->get('filter'));
		$admarket = clean_data($this->get('admarket'));
		if($this->user_authentication->account_type=='ADVERTISER')
		{			
			$account_id	= 	$this->user_authentication->account_id;
		}
		else
		{
			$account_id	= 	$this->user_authentication->account_id;//'';
		}
			
		$camps_list = $this->do_campaign->fetch($account_id);
		 
		if($camps_list)
		{ 	
			$n=-1;
			for($i=0;$i<count($camps_list);$i++)
			{ 
				$n++;
				$data .= $camps_list[$n]['campaignid'].",";
			}	
		}  
		 
		$expls = rtrim($data, ",");
		 
		$explode = explode(",",$expls);
			 
		$traffic_list = $this->do_networks->fetch_zone_bidding($explode,$account_id,$filter,$admarket);
		
		$this->response($traffic_list, 200);	
		
	}
	
	
	/*
	 *  name: fetch_traffic_sources_get
	 * 
	 * */
	public function fetch_traffic_sources_get()
	{ 
		$filter	=	clean_data($this->get('filter'));
		$admarket = clean_data($this->get('admarket'));
		if($this->user_authentication->account_type=='ADVERTISER')
		{			
			$account_id	= 	$this->user_authentication->account_id;
		}
		else
		{
			$account_id	= 	$this->user_authentication->account_id;
		}
		//$this->response($account_id, 200);		
		$camps_list = $this->do_campaign->fetch($account_id);
		 
		if($camps_list)
		{ 	
			$n=-1;
			for($i=0;$i<count($camps_list);$i++)
			{ 
				$n++;
				$data .= $camps_list[$n]['campaignid'].",";
			}	
		}  
		 
		$expls = rtrim($data, ",");
		 
		$explode = explode(",",$expls);
			 
		$traffic_list = $this->do_networks->fetch_traffic_sources($explode,$account_id,$filter,$admarket);
		
		$this->response($traffic_list, 200);	
		
	}
	
	public function remove_traffic_sources_post()
	{
		$cid	  =	clean_data($this->post('id'));
		$admarket = clean_data($this->post('admarket'));
		if($cid)
		{			
			$traffic_list = $this->do_special_bidding->fetch_traffic_source($cid);
			$camps_list = $this->do_networks->remove_traffic_source($cid,$admarket);
			if($camps_list)
			{	
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$account_id	= 	$this->user_authentication->account_id;
						
					/*********Message Requirements**************/
		
					$client_id 		=	$this->user_authentication->client_id;
								
					$account_type	=	$this->user_authentication->account_type;	
					$network_id	=	$this->user_authentication->network_account_id;					
					$agency_id	=	$this->user_authentication->agency_id;
					$result		=	$this->do_networks->agency_owner_details($agency_id);
					$admin_name    	= 	$result['name'];			
					$admin_email	= 	$result['email'];	
					$admin_id   	= 	$result['account_id'];
				/* Activity Log for remove_traffic_source - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK,TRAFFIC_SOURCE_DEL);
					if($enable=='1')
					{				
						$this->activity_log(TRAFFIC_SOURCE,DELETE);
					}
					/* Activity Log for remove_traffic_source - End*/		
					$message  		= 	$this->default_configurations->get('message_type');		
							

					if($account_type=='TRAFFICKER')
					{
						$affiliate_id	=	$this->user_authentication->affiliate_id;
						$user 			= 	$this->do_message->get_affiliate($affiliate_id); 

					}
					else{
						$user = $this->do_message->get_profile($admin_id); 
					}
					
					$acc_type='ADVERTISER';
					
					$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "ADMIN_MESSAGE_SETTINGS",
						'string'		=> 'traffic_source_del',
						'column_name'	=> 'network_settings'
						);
						
						
					$reciever=$this->do_message->get_profile($account_id); 
					
					$message_data		=	array(
													'sender_id'		=>	$admin_id,
													'receiver_id'	=>	$reciever['account_id'],
													'dj_is_admarket'=>	$admarket,
													'subject'		=>	'Traffic Resources Removed',
													'content'		=>	'The Traffic Resource removed successfully <br><br><b>Traffic Source Details</b><br><br>Bid Rate:'.$traffic_list['bid_rate'].'<br>Status:'.$traffic_list['status'].'<br>Traffic Id:'.$traffic_list['id'].'<br>Campaign Id:'.$traffic_list['campaign_id'].'',
													'image_name'	=>	NULL,
													'file_name'		=>	NULL,
													'account_type'	=>	$acc_type,
													'status'		=>	'1',
													'network_id'	=>	$network_id,	
													'notification_type'	=>	"network_setting",								
													'date'			=>	date('Y-m-d H:i:s')
													);
												
					$user_email    =$reciever['email'];
					$user_name     =$reciever['first_name'].' '.$reciever['last_name'];
					$mail_content=array(
										"subject" 	   => $message_data['subject'],
										"content" 	   => $message_data['content'],
										"to_name" 	   => $user_name,			
										"from_name"	   => $admin_name ,
										"email"  	   => $user_email,
										'banner_name'  => 'message from'.$admin_name,
										'contenttype'  => 'message'
										);								

			$notification_msg = $this->do_message->get_notification_msg('traffic_source_del'); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
											
			}		
			$adgate_url	=	base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$reciever['name'],$msg_replace);	

			$msg_replace = str_replace("{{bid_rate}}",$traffic_list['bid_rate'],$msg_replace);
			$msg_replace = str_replace("{{traffic_status}}",$traffic_list['status'],$msg_replace);
			$msg_replace = str_replace("{{traffic_id}}",$traffic_list['id'],$msg_replace);
			$msg_replace = str_replace("{{campaign_id}}",$traffic_list['campaign_id'],$msg_replace);
			
			$msg_replace = str_replace("{{admin_name}}",$user['first_name'].' '.$user['last_name'],$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$this->config->item('click_directADS').'</a>' ,$msg_replace);	
			
			$dd = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace);
								
					//$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);

					/*********Message Requirements**************/
				}
				
				$success = array( 
								'response'	=>	'ok',
								'msg'		=>	'Traffic source is removed successfully'
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array( 
								'response'	=>	'error',
								'msg'		=>	'Traffic source is not removed'
							);
							
				$this->response($error, 200);
			}			
		}
		else
		{
			$error = array( 
							'response'	=>	'error',
							'msg'		=>	'Traffic source is not removed'
						);
			$this->response($error, 200);
		}	
	}
	
	public function remove_zone_bidding_post()
	{
		$cid	=	clean_data($this->post('id')); 
						
		$admarket = clean_data($this->post('admarket'));   
		
		if($cid)
		{			
			$zone_bidding_list = $this->do_special_bidding->fetch_zone_id($cid);   
			$camps_list = $this->do_networks->remove_zone_id($cid,$admarket);
			if($camps_list)
			{	
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$account_id	= 	$this->user_authentication->account_id;
						
					/*********Message Requirements**************/
		
					$client_id 		=	$this->user_authentication->client_id;
								
					$account_type	=	$this->user_authentication->account_type;	
					$network_id	=	$this->user_authentication->network_account_id;					
					$agency_id	=	$this->user_authentication->agency_id;
					$result		=	$this->do_networks->agency_owner_details($agency_id);
					$admin_name    	= 	$result['name'];			
					$admin_email	= 	$result['email'];	
					$admin_id   	= 	$result['account_id'];
				/* Activity Log for remove_traffic_source - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK,ZONE_BIDDING_DEL);
					if($enable=='1')
					{				
						$this->activity_log(ZONE_BIDDING,DELETE);
					}
					/* Activity Log for remove_traffic_source - End*/		
					$message  		= 	$this->default_configurations->get('message_type');		
							

					if($account_type=='TRAFFICKER')
					{
						$affiliate_id	=	$this->user_authentication->affiliate_id;
						$user 			= 	$this->do_message->get_affiliate($affiliate_id); 

					}
					else{
						$user = $this->do_message->get_profile($admin_id); 
					}
					
					$acc_type='ADVERTISER';
					
					$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "ADMIN_MESSAGE_SETTINGS",
						'string'		=> 'ad_zone_bid_del',
						'column_name'	=> 'network_settings'
						);
						
						
					$reciever=$this->do_message->get_profile($account_id); 
					
					$message_data		=	array(
													'sender_id'		=>	$admin_id,
													'receiver_id'	=>	$reciever['account_id'],
													'subject'		=>	'Zone Bidding Removed',
													'content'		=>	'The Zone Bidding removed successfully <br><br><b>Zone Bidding Details</b><br><br>Bid Rate:'.$zone_bidding_list['bid_rate'].'<br>Status:'.$zone_bidding_list['status'].'<br>Zone Id:'.$zone_bidding_list['id'].'<br>Campaign Id:'.$zone_bidding_list['campaign_id'].'',
													'image_name'	=>	NULL,
													'file_name'		=>	NULL,
													'account_type'	=>	$acc_type,
													'dj_is_admarket'=>	$admarket,
													'notification_type'	=>	"network_setting",	
													'status'		=>	'1',
													'network_id'	=>	$network_id,									
													'date'			=>	date('Y-m-d H:i:s')
													);
												
					$user_email    =$reciever['email'];
					$user_name     =$reciever['first_name'].' '.$reciever['last_name'];
					$mail_content=array(
										"subject" 	   => $message_data['subject'],
										"content" 	   => $message_data['content'],
										"to_name" 	   => $user_name,			
										"from_name"	   => $admin_name ,
										"email"  	   => $user_email,
										'banner_name'  => 'message from'.$admin_name,
										'contenttype'  => 'message'
										);								
	

			$notification_msg = $this->do_message->get_notification_msg('ad_zone_bid_del'); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
											
			}		
			$adgate_url	=	base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$reciever['first_name'].' '.$reciever['last_name'],$msg_replace);	

			//~ $msg_replace = str_replace("{{bid_rate}}",$zone_bidding_list['bid_rate'],$msg_replace);
			//~ $msg_replace = str_replace("{{zone_bid_status}}",$zone_bidding_list['status'],$msg_replace);
			//~ $msg_replace = str_replace("{{zone_id}}",$zone_bidding_list['id'],$msg_replace);
			//~ $msg_replace = str_replace("{{campaign_id}}",$zone_bidding_list['campaign_id'],$msg_replace);
			
			$msg_replace = str_replace("{{admin_name}}",$user['first_name'].' '.$user['last_name'],$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$this->config->item('click_directADS').'</a>' ,$msg_replace);	
			
			$dd = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace);
			
								
					//$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);

					/*********Message Requirements**************/
				}
				
				$success = array( 
								'response'	=>	'ok',
								'msg'		=>	'Zone Bidding is removed successfully'
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array( 
								'response'	=>	'error',
								'msg'		=>	'Zone Bidding is not removed'
							);
							
				$this->response($error, 200);
			}			
		}
		else
		{
			$error = array( 
							'response'	=>	'error',
							'msg'		=>	'Zone Bidding is not removed'
						);
			$this->response($error, 200);
		}	
	}
	  	
	public function get_network_details_get()
	{		
		$network	=	$this->do_networks->get_network_details();
		if($network)
		{
			$this->response($network,200);
		}
	}
	
	/* for admin account
	 * 
	 * name: admin_paypal_info_add
	 * @param : null
	 * @return :Last insert id
	 * 
	 */
	
    public function admin_add_authorize_info_post(){		
		
		$this->form_validation->set_rules('auth_api_username', 'API Username', 'trim|required');
		$this->form_validation->set_rules('auth_api_signature', 'API Signature', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error 	= 	array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$account_id		= 	$this->user_authentication->account_id;	
			$status_check	=	$this->do_networks->admin_add_authorize_api_info(clean_data($this->post()),$account_id);
			
			/* Activity Log for Payment settings - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,PAYMENT_SETTINGS);
				if($enable=='1')
				{							
				$this->activity_log(PAYMENT_SETTINGS,EDIT);
				}
			/* Activity Log for Payment settings - End*/	  
						
			
			if($status_check=="inserted")
			{
				$success = array(
							'response' 	=> 	'ok',
							'redirect'	=>	site_url('admin/settings/payment_settings'),
							'msg'	 	=> 	'Payment Information added successfully!..' );
				$this->response($success, 200);
			}
			elseif($status_check=="updated")
			{
				$success = array(
							'response' 	=> 	'ok',
							'redirect'	=>	site_url('admin/settings/payment_settings'),
							'msg'	 	=> 	'Payment Information updated successfully!..' );
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' 	=> 	'error',
							'redirect'	=>	site_url('admin/settings/payment_settings'),
							'msg'	 	=> 'Payment Information not updated successfully!..' );
				$this->response($error, 200);
			}
        }
	}
	
	function delete_activity_log_get()
	{	
		$log_id = $this->get('log_id');	
		
		$arrays	=	explode(',',$log_id);
		   if(is_array($arrays))
			{  
				foreach($arrays as $logs_id)
				{
					 $results= $this->del_activity_log(clean_data($logs_id));
				}
					
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Activity log has been deleted successfully..'
										);
					
					$this->response( $success, 200);
			}
			else
			{
				$results= $this->del_activity_log(clean_data($log_id));
				
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Activity Log has been deleted successfully..'
										);
					
				$this->response( $success, 200);
			}
	}
	
	
	function del_activity_log($log_id)
	{
		if($log_id)
		{
			//$advertiser_details = 	$this->do_advertiser->get_profile($account_id);
			$log = 	$this->do_networks->delete_activity_log($log_id);
			
			if($log)
			{   
			   /* $success 		= 	array(
								'response' 	=> 	'ok',
								'msg'	 	=> 	'deleted'
								);
			
				$this->response( $success, 200);*/	
			}
			else
			{
				$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Error..Please Try again.'
								);
			
				$this->response( $error, 200);
			}
		}
		else
		{
			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'log does not found.'
								);
			
			$this->response( $error, 200);
		}
	}	
	
	
	
	function activity_log($module,$process)
	{
				/* Activity Log for EDIT setting information - Start*/				
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");							
				$account_id=$this->user_authentication->account_id;
				$publisher_id =	$this->user_authentication->affiliate_id;
				$advertiser_id =	$this->user_authentication->client_id;
				$module=$module;
				$process=$process;				
								
				$activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$user_agent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,
				"module"=>$module,
				"process"=>$process,
				"advertiser_id"=>$advertiser_id,
				"campaign_id"=>'',
				"banner_id"=>'',
				"publisher_id"=>$publisher_id,
				"site_id"=>'',
				"app_id"=>'',
				"adblock_id"=>'');		
					
				$this->redis_library->logcount($account_id,$activity_log);  
																									
				//$this->do_app_config->activity_log($account_id,$activity_log);
				/* Activity Log for edit settings information - End*/			
		
	}
	function security_check_get(){
		
		$action_type	= 	$this->get('action');
			
		$user_agent		=	$this->user_authentication->user_agent;
		$browser		=	$this->user_authentication->browser;
		$os				=	$this->user_authentication->os;
		$ip				=	$_SERVER['REMOTE_ADDR'];
		$date			=	date("Y-m-d h:i:sa");							
		$account_id		=	$this->user_authentication->account_id;
		$publisher_id 	=	$this->user_authentication->affiliate_id;
		$advertiser_id 	=	$this->user_authentication->client_id;
		$account_type   =   $this->user_authentication->account_type;	
		
		$actions		= 	explode("_",$action_type);
		/*$module			= 	$actions[1];
		$process		=	$actions[0];
		if($module == 'bidd' || $module == 'bidding'){
			$module = COUNTRY_BIDDING;
		}
		if($module == 'zonelimit'){
			$module = ZONE_LIMITATION;
		}
		if($module == 'source'){
			$module = TRAFFIC_SOURCE;
		}
		if($module == 'tracker'){
			if($process == 'link'){
				$process='edit';
			}
			$module = PIXEL_TRACKER;
		}
		if($module == 'acc'){
			$module = "acc_settings";
		}	
		if($module == 'notification'){
			$module = "notification_settings";
		}
		if($module == 'company'){
			$module = "company_info";
		}
		if($module == 'payment'){
			if($process == 'pub'){
				$process='pub_payment_approve';
				$module ='publisher';
			}
		}*/
		if($account_type == 'TRAFFICKER'){
			$module			= strtolower('PUBLISHER');
		}
		else{
			$module			= strtolower($account_type);
		}
		$process		= 'login';
		$check_log		=	$this->do_networks->fetch_action_activity_log($account_id,$module,$process);
		$security		=	$this->do_app_config->fetch_security($account_id);
		
		$ip_found 		= 	array_search($ip, array_column($check_log, 'ip'));
		$browser_found 	= 	array_search($browser, array_column($check_log, 'browser'));
		$os_found 		= 	array_search($os, array_column($check_log, 'os'));
		$browseragent_found 	= 	array_search($user_agent, array_column($check_log, 'useragent'));
		
		$os_founds 				= 	array_keys(array_column($check_log, 'os'), $os);
		$ip_founds 				= 	array_keys(array_column($check_log, 'ip'), $ip);
		$browser_founds 		= 	array_keys(array_column($check_log, 'browser'), $browser);
		$browseragent_founds 	= 	array_keys(array_column($check_log, 'useragent'), $user_agent);
		$ips 			= 	explode('.', $ip);
		$last_ip 		= 	array_pop($ips);
		$first_ips 		= 	implode('.', $ips);
		
		foreach ($check_log as $check_logs) {
			if (strpos($check_logs['ip'],$first_ips) !== false) {
			$subnet_founds	=	$check_logs['ip'];
			}
		}	
				
		
		if($security != FALSE ){
									
					if((strpos($security[0]['security'],'1')!== FALSE && $ip_founds == FALSE) || (strpos($security[0]['security'],'2')!== FALSE && $subnet_founds == FALSE) || (strpos($security[0]['security'],'3')!== FALSE && $browser_founds == FALSE) || (strpos($security[0]['security'],'4')!== FALSE && $browseragent_founds == FALSE) || (strpos($security[0]['security'],'5')!== FALSE && $os_founds == FALSE) )
					{	 
						$security_question		=	$this->do_advertiser->get_question($security[0]['security_question_id']); 
						$response = array(
							'response' 	=> 	'ok',
							'msg'	 	=> 	'Securit Exist',
							'mobileno'	=>	$security[0]['mobile_no'],
							'email'		=>	$security[0]['email'],
							'question' 	=> 	$security_question[0]['question'],
						);					
					    $this->response($response, 200);		
				    }
				    else
					{   
						$error = array(
								'response' 	=> 'error',
								'msg'		=> 'Securit Not Exist',
								
							);
						$this->response($error, 200);	
					}
			}
			else{
				   
					$error = array(
							'response' 	=> 'error',
							'msg'	 	=> 'Securit Not Exist',
							
						);
					$this->response($error, 200);	
			}
						
	}
	

	
	public function check_verification_method_post(){
		
			
			//$account_type 		= 	$this->post('_account_type');
			$verification_code	=	$this->post('verification_code');
			$verification_method=	$this->post('verification_method');
			$campaign_id		=	$this->post('code_campaignid');
			$bannerid		=	$this->post('code_bannerid');
			$action_type		=	$this->post('action_type');
			$account_id			=	$this->user_authentication->account_id;
			$account_type   	=   $this->user_authentication->account_type;	
			if($account_id){
				$security			=	$this->do_app_config->fetch_security($account_id);
				$security_question	=	$this->do_advertiser->get_question($security[0]['security_question_id']);
				
				if($verification_method	==	'security_question'){
					$success_message	=	$this->do_advertiser->backup_verification($account_id,$verification_code);
					
					if($success_message == 1){
						
						$respnse = array(
								'response' 		=> 'verification_ok',
								'msg'	 		=> 'Successfuly Verified',
								'mobileno'		=>	$security[0]['mobile_no'],
								'email'			=>	$security[0]['email'],
								'question' 		=> 	$security_question[0]['question'],
								'campaign_id'	=>	$campaign_id,
								'bannerid'	=>	$bannerid,
								'action_type'	=>	$action_type,
								'accountid'		=>	$account_id,
													
							);
			
							$this->response( $respnse, 200);	
					}
					else{
							$error = array(
								'response'  => 'error',
								'msg'	 	=> 'Please enter correct answer or choose different method for verification'
							);
			
							$this->response( $error, 200);	
					}
				}
				else if($verification_method	==	'mobile_verification'){
					if($verification_code == $security[0]['mobile_no']){
						
							$verifyCode 	= rand(100000, 999999);
							$phone 			= $security[0]['mobile_no'];
							$twilioSid 		= $this->config->item('twilio_AccountSid');
							$twilioToken 	= $this->config->item('twilio_AuthToken');
							$twiliono 		= $this->config->item('twilio_FromNumber');
							$this->do_app_config->sms_verify($verifyCode,$account_id);
							 //$client = new Services_Twilio($twilioSid, $twilioToken);
							$service 		= get_twilio_service();
							// send sms with verifcation code 
							$responses 		= $service->account->sms_messages->create($twiliono, $phone, 'Your Login Verification code ' . $verifyCode);
							$response 		= 	array(
													'response' 		=> 	'mobile_ok',
													'redirect'		=>	$redirect_url,
													'accountid'		=>	$account_id,
													'accounttype'	=>	$account_type,
													'mobileno'		=>	$security[0]['mobile_no'],
													'email'			=>	$security[0]['email'],
													'question' 		=> 	$security_question[0]['question'],
													'type'			=>	"sms",
													'campaign_id'	=>	$campaign_id,
													'bannerid'		=>	$bannerid,
													'action_type'	=>	$action_type
												);
							$this->response( $response, 200);	
					}
					else{
						$error = array(
								'response'  => 'error',
								'msg'	 	=> 'Please enter correct mobile number or choose different method for verification'
							);
			
							$this->response( $error, 200);
					}
					
				}
				else if($verification_method	==	'email_verification'){
					
					if($verification_code == $security[0]['email']){
						
									$verifyCode = rand(100000, 999999);
									$phone 		= $security[0]['mobile_no'];
											
									$this->do_app_config->sms_verify($verifyCode,$account_id);
									$type		=	"ADV_VERIFY_CODE";
									$admin_email=	$this->do_networks->get_network_details();
											
									$from 		=  	$admin_email['email'];
									$admin_name = 	$admin_email['firstname']." ".$admin_email['lastname'];
									$to  		=  	$security[0]['email'];
									//$user_name = $advObj['first_name']." ".$advObj['last_name'];
									$user_email	=	$security[0]['email'];
									//$password=$advObj['password'];
									//$account_type= 	$accnt_type;
									$to_mail 	 = 	$security[0]['email'];
									$mail_content=	array(
													"subject" 				=> "Your  Verification Code",
													"to_name" 				=> "User",				
													"from_name"				=> $admin_name,
													"email"  				=> $user_email,
													"verification_code"		=> $verifyCode,
													"password" 				=>	$password,
													"account_type" 			=>	$account_type					
													);	
														
									send_mail($type,$from,$to_mail,$mail_content);
									
							$response 	= 	array(
													'response' 		=> 	'mobile_ok',
													'accountid'		=>	$account_id,
													'accounttype'	=>	$account_type,
													'mobileno'		=>	$security[0]['mobile_no'],
													'email'			=>	$security[0]['email'],
													'question' 		=> 	$security_question[0]['question'],
													'type'			=>	"email",
													'action_type'	=>	$action_type,
													'campaign_id'	=>	$campaign_id,
													'bannerid'		=>	$bannerid,
												);
										$this->response( $response, 200);	
					
					
					
					}
					else{
						$error = array(
								'response' 	=> 'error',
								'msg'	 	=> 'Please enter correct email id or choose different method for verification'
							);
			
							$this->response( $error, 200);
					}
				}
				
			}
			
		}
		
		public function check_verification_code_match_post(){
		
			
			$account_type 		= 	$this->post('account_type');
			$verification_code	=	$this->post('verify_codes');
			$bannerid			=	$this->post('back_bannerid');
			$campaignid			=	$this->post('back_campaignid');
			$action_type		=	$this->post('back_action_type');
			$account_id			=	$this->user_authentication->account_id;
			if($account_id){
					
				$success_message=	$this->do_advertiser->sms_verification($account_id,$verification_code);
					
				if($success_message == 1){
					
						
					$respnse = array(
								'response' 		=> 'verification_ok',
								'msg'	 		=> 'Successfuly Verified',
								'campaign_id'	=>	$campaignid,
								'action_type'	=>	$action_type,
								'bannerid'		=>	$bannerid,
								'accountid'		=>	$account_id,
													
							);
			
							$this->response( $respnse, 200);	
							
					
				}
				else{
						$error = array(
								'response'  => 'error',
								'msg'	 	=> 'Please enter correct code ..'
							);
			
							$this->response( $error, 200);
					}
			}
		}
		
		public function resend_verify_code_post(){
		
			
			$account_type 		= 	$this->post('account_type');
			$type				=	$this->post('back_type');
			$mobileno			=	$this->post('back_mobileno');
			$email				=	$this->post('back_email');
			$account_id			=	$this->user_authentication->account_id;
			if($account_id){
				
				
				if($type == 'sms'){
					
					$verifyCode = rand(100000, 999999);
					$phone = $mobileno;
					$twilioSid = $this->config->item('twilio_AccountSid');
					$twilioToken = $this->config->item('twilio_AuthToken');
					$twiliono = $this->config->item('twilio_FromNumber');
					$this->do_app_config->sms_verify($verifyCode,$account_id);
										
					$service = get_twilio_service();
					$responses = $service->account->sms_messages->create($twiliono, $phone, 'Your Login Verification code ' . $verifyCode);
											
					$response 	= 	array(
										'response' 	=> 	'ok',
										'accountid'	=>	$account_id,
										'accounttype'	=>	$account_type,
										'mobileno'=>$phone,
										'type'=>"sms",
										'msg'=>"Resend successfully to : ".$phone
									);
					$this->response($response, 200);
										
				}
				else if($type == 'email'){
					
					$verifyCode 	= rand(100000, 999999);
					$phone	 		= $mobileno;
											
					$this->do_app_config->sms_verify($verifyCode,$account_id);
					$type			=	"ADV_VERIFY_CODE";
											
					$admin_email	=	$this->do_networks->get_network_details();
					$from 			=   $admin_email['email'];
					$admin_name 	=   $admin_email['firstname']." ".$admin_email['lastname'];
					$to  			=   $email;
					$user_name 		= 	"User";
					$user_email		=	$email;
				
					$account_type	= 	$account_type;
					$to_mail 		= 	$email;
					$mail_content	=	array(
												"subject" 			=> "Your Login Verification Code",
												"to_name" 			=> $user_name,				
												"from_name"			=> $admin_name,
												"email"  			=> $user_email,
												"verification_code"	=> $verifyCode,
												"account_type" 		=>	$account_type					
									);	
											
					send_mail($type,$from,$to_mail,$mail_content);
											
					$response 	= 	array(
												'response' 		=> 	'ok',
												'accountid'		=>	$account_id,
												'accounttype'	=>	$account_type,
												'email'			=>	$to_mail,
												'type'			=>	"mail",
												'msg'			=>	"Resend successfully to : ".$to_mail
										);
					$this->response($response, 200);
				}
				else{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Error, please try again'
					);
			
				$this->response( $error, 200);
			}
				
			}
			else{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Error, please try again'
					);
			
				$this->response( $error, 200);
			}
	}
	
	/*
	 * 
	 * name: Security_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the Security Account Information for Particular Advertiser
	 */
	
    public function security_option_add_post()
    {		
		$this->form_validation->set_rules('security_name[]','Security Name','trim|required');
		$this->form_validation->set_rules('security_option[]', 'Security Option', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			
			$account_id = $this->user_authentication->account_id;
			$security_name=$this->post('security_name');
			$security_option=$this->post('security_option'); 
			$mobile_no=$this->post('mobile_no');
			$email=$this->post('email');
			$question_id=$this->post('security_question');
			$security_answer=$this->post('security_answer');
			
			foreach($security_name as $secure_name){
					$secure_names.= $secure_name.',';
			}
			foreach($security_option as $secure_option){
					$secure_options.= $secure_option.',';
			}					
			$update_security_infoObj=array(											
										"security"  	=>	rtrim($secure_names, ','),
										"token_type"	=>	rtrim($secure_options, ','),
										"mobile_no"     	=> 	$mobile_no,
										"email"				=>	$email,
										"question_id" 		=>  $question_id,
										"security_answer"	=>  $security_answer,
										);											
				//$this->response($update_security_infoObj, 200);			
		    $this->do_advertiser->security_add($account_id,$update_security_infoObj);
		    
		    /* Activity Log for Security information - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,SECURTIY);
				if($enable=='1')
				{							
				$this->activity_log(SECURTIY,EDIT);
				}
			/* Activity Log for Security information - End*/	       	    		
			
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('advertiser/settings/security'),
							'msg'	 => 'Security are updated successfully!..'
							);
		
						
			$this->response($success, 200);
		}

	}
	
	function campaignlist_get()
	{
		
		$filter	=	clean_data($this->get('traffic_source'));
		
		$admarket = clean_data($this->get('admarket'));
		
		$account_id	= 	$this->user_authentication->account_id;	
								
		$camp_list=$this->do_networks->list_filter_campaign($filter,$admarket,$account_id);	
				
		  if($camp_list)
		 {
			 $form_data='<select name="camp_det" id="campaign_list" class="select2-me input-medium" data-nosearch="true" >'; 
			 $form_data.='<option value="">'.$this->lang->line("slt_camp").'</option>';
			 foreach($camp_list as $sel)
			{
				$form_data.='<option value="'.$sel['campaignid'].'">'.$sel['campaignname'].'</option>';      
			}
			$form_data.='</select>';
			 $response = array(
							'response' 	=> 	'ok',
							'camplist'	=>	$form_data,
						);					
		    $this->response($response, 200);
		 }
		 else
		 {
			 $this->response(array('error'=>'Campaign ID could not be found'),404);
		 }
		
	}
	
	
	
	function campaignlist_for_zone_get()
	{		
		$filter	=	clean_data($this->get('zone_id'));
		
		$admarket = clean_data($this->get('admarket'));
		
		$account_id	= 	$this->user_authentication->account_id;	
				
		$camp_list=$this->do_networks->list_filter_campaign_for_zone($filter,$admarket,$account_id);	

		  if($camp_list)
		 {
			 $form_data='<select name="camp_det" id="campaign_list" class="select2-me input-medium" data-nosearch="true" >'; 
			 $form_data.='<option value="">'.$this->lang->line("slt_camp").'</option>';
			 foreach($camp_list as $sel)
			{
				$form_data.='<option value="'.$sel['campaignid'].'">'.$sel['campaignname'].'</option>';    
			}
			$form_data.='</select>';
			 $response = array(
							'response' 	=> 	'ok',
							'camplist'	=>	$form_data,
						);					
		    $this->response($response, 200);
		 }
		 else
		 {
			 $this->response(array('error'=>'Campaign ID could not be found'),404);     
		 }
		
	}
	
	public function import_traffic_file_post()
	{			
	
		$file_id=$this->post('upload_name');	
	    
		if($file_id!='')
		{
			$upload_extension = explode(".", $file_id);		
			
			if($upload_extension[1]=='csv' || $upload_extension[1]=='txt' || $upload_extension[1]=='xml')
			{	
					$csvfilepath 	= $this->config->item('read_csv');	
					$file_name		= $this->getLatestFile($csvfilepath);
					if($upload_extension[1]=='xml')
					{						
						$xml = simplexml_load_file($file_name, 'SimpleXMLElement');	
						$data = json_decode(json_encode((array)$xml), TRUE);
						if(!empty($data['Trafficsource'][0]))
						{
							$data=$data['Trafficsource'];
						}
						else{
							$datum[0]=$data['Trafficsource'];
							$data=$datum;
						}
					}
					else { $data	= $this->csvreader->parse_file($file_name); }   
					
					$counter		= '1';	
					$ext_counter=1;
					$client_fails=1;
					$insert_rec=array();
					$exist_rec=array();
					$client_fails_cnt=array();
					$num_rows=count($data);	
					
												
					if($num_rows>0)
					{
						foreach($data as $row)
						{
							$admarket=$row['admarket'];
							
							if($admarket=='1')
							{
								$url=site_url('advertiser/admarket/traffic_sources');
							}
							else
							{
								$url=site_url('advertiser/network/traffic_sources');   
							}

								//echo "row<pre>";print_r($row);die;														
							if(!empty($row['sourceid']) && !empty($row['bidrate']))	
							{					
								if(!empty($row['account_id']))
								{
									$account_id=trim($row['account_id']);
								}
								else
								{
									$account_id=$this->user_authentication->account_id;	
								}
															
								$traffic_data_gen 	= 	array(								
									"campaign_id"		=>	trim($row['campaignid']),
									"traffic_id" 		=> 	trim($row['sourceid']),
									"status"			=>	trim($row['status']), 
									"bid_rate"			=>	trim($row['bidrate']),
									"account_id"		=>	$account_id,
									"source_type"		=>  trim($row['bidding_type']),
									"admarket"			=>	trim($row['admarket'])
								);		
								$traffic_data_check= array("campaign_id"=>	trim($row['campaignid']),
													"traffic_id" 		=> 	trim($row['sourceid']),
													"admarket"			=>	trim($row['admarket']),
													"source_type"       =>  trim($row['bidding_type'])
													);
													
								if(!empty($row['campaignid']))
								{  									
									$client_id_check =	$this->do_campaign->campaign_clientid_check(trim($row['campaignid']));  
								}
								else
								{
									$client_id_check = TRUE;
								}
								
								$traffic_check	=	$this->do_special_bidding->check_traffic_sources_import($traffic_data_check);  
 				
								if($client_id_check!= TRUE)
								{ 	
									$client_fails_cnt[]=$client_fails;
								}
								if($traffic_check==TRUE && $client_id_check== TRUE)
								{	
									$traffic_success=$this->do_special_bidding->add_traffic_sources($traffic_data_gen);
									$insert_rec[] =$counter;	
								}		
								else
								{  
										$exist_rec[]=$ext_counter;
								}
						$counter++;	
						$ext_counter++;						
						}
						else {
							$error = array(
									'response' => 'error',
									'redirect' => $url,
									'msg'	   => 'The file contains invalid data for this operation..'
									);
				  
							$this->response($error, 200);
						}
					}
						if(count($insert_rec)>0 && count($exist_rec) >0 )
						{
								$ins_count = count($insert_rec);
								$ex_count= count($exist_rec);
								$client_mismatch= count($client_fails_cnt);
								$success = array('response'	=> 'ok_error',
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												 'error_msg'=> $ex_count.' uploaded file(s) are already Exists !' ,
												 'redirect'	=> $url,
												 'clienterror_msg'=> $client_mismatch.' Client id mismatch error!' 
												 ); 
								$this->response($success,200);
						}
						else if(count($insert_rec)>0 && count($exist_rec)<=0)
						{
							
								$ins_count = count($insert_rec);
								$success = array('response'	=> 'ok',
												 'redirect'	=> $url,
												 'msg'		=> $ins_count.' record(s) are inserted successfully'
												 ); 
								$this->response($success,200);
						}
						else if(count($exist_rec) >0&& count($insert_rec)<=0)
						{
								$ex_count= count($exist_rec);
									$error = array(
										   'response' => 'error',
										    'redirect'	=> $url,
										   'msg' =>  $ex_count.' uploaded file(s) are already Exists ! '
										  );
									$this->response( $error, 200);
						}
					}
					else
					{
						$error = array(
									'response' => 'error',
									'redirect'=> $url,
									'msg'	 => 'There is no data in the file!..'
									);
				  
						$this->response($error, 200);	
					}													
			}
			else
			{
				$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV/TXT file to upload!..'
							);
	  
				$this->response($error, 200);	
					
			}		
		}
		else
		{
			$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV/TXT file to upload!..'
						);
	  
			$this->response($error, 200);
		}		
		
						
	}
	function getLatestFile($directoryPath)
	{
		$directoryPath = rtrim($directoryPath, '/');
	
		$max = array('path' => null, 'timestamp' => 0);	
		
		foreach (scandir($directoryPath, SCANDIR_SORT_NONE) as $file)
		{
			$path = $directoryPath . '/' . $file;
			if (!is_file($path)) {	
				continue;
			}
			$timestamp = filemtime($path);		
			if ($timestamp > $max['timestamp']) {
				$max['path'] = $path;
				$max['timestamp'] = $timestamp;
			}
		}return $max['path'];
	}
	
	
    public function send_mass_email_publisher_join_post()
    {		
			$account_id		= 	$this->user_authentication->account_id;	
			$from_email		= 	$this->user_authentication->account_type;	
			$result			=	$this->do_networks->get_user_role_info($this->user_authentication->user_id);
			$record			=	(Array)$result[0];
			    
			$country 				= clean_data($this->post('country'));
			$file_name 				= clean_data($this->post('file_name'));
			$select_publisher 		= clean_data($this->post('select_publisher'));
			$publisher 				= implode(",",clean_data($this->post('publisher')));
			$revenue 				= clean_data($this->post('revenue'));
			$payment_type 			= clean_data($this->post('payment_type'));
			$impression_limit 		= clean_data($this->post('impression_limit'));
			$click_limit 			= clean_data($this->post('click_limit'));
			$conversion_limit 		= clean_data($this->post('conversion_limit'));
			$templates_selection 	= clean_data($this->post('templates'));
			$msg_type			 	= clean_data($this->post('msg_type'));
			$advertiser			 	= clean_data($this->post('advertiser'));
			$publisher_result		= $this->do_networks->get_pubs_role_info($publisher,$advertiser);
	
			
			$tags['tag'] 			= $this->input->post('tags');

				
			
			$tags['from_email'] 	= $record['email_address'];
			$tags['adv_acc'] 		= $account_id;
			
			$tags['contact_name'] 	= $record['contact_name'];
			$package_path = explode('application',dirname(__DIR__));
			$fi = new FilesystemIterator($package_path[0].$this->config->item('read_template_data'), FilesystemIterator::SKIP_DOTS);
			$files_count = iterator_count($fi);		
			if(empty($file_name))
			{
				$files_count = $files_count + 1;
				$file_name = 'Template '.$files_count.'.html';
				$img_file_name = 'Template '.$files_count.'.png';
			}					
			$camp_list=$this->do_template->temp_file_upload_data($file_name,$img_file_name);	
			if(!empty($tags['tag']) )
			{		
				$headers = "MIME-Version: 1.0" . "\r\n";
				$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
				$headers .= 'From: <webmaster@example.com>' . "\r\n";	
				foreach($publisher_result as $pub_result)	
				{	
					$tags['pub_acc'] 		= $pub_result['default_account_id'];
					$to						= $pub_result['email_address'];
					$a_tag					= ' <a href='.base_url().'index.php/api/v1/user/accept_join_request/adv_acc/'.$account_id.'/pub_acc/'.$pub_result['default_account_id'].'/appr/1/denied/0/format/json> Accept </a> / <a href='.base_url().'index.php/api/v1/user/accept_join_request/adv_acc/'.$account_id.'/pub_acc/'.$pub_result['default_account_id'].'/appr/0/denied/1/format/json> Reject </a>';	
						
					$tags['tag'] = str_replace("acceptreject",$a_tag,$tags['tag']);		

													
					$received = mail($to,'Publisher Join Request',$tags['tag'],$headers);
				
				}					
			}
			else
			{
				foreach($publisher_result as $pub_result)	
				{				
					$tags['pub_acc'] 		= $pub_result['default_account_id'];
					$to						= $pub_result['email_address'];
					$received = send_mail($templates_selection,$to,$tags);
				}
			}
			$this->response($received,200);					
	}
		
		
	function send_mail_preview_post()
	{
			$account_id		= 	$this->user_authentication->account_id;	
			$from_email		= 	$this->user_authentication->account_type;	
			$result			=	$this->do_networks->get_user_role_info($this->user_authentication->user_id);
			$record			=	(Array)$result[0];
					
			$templates_selection = clean_data($this->post('templates'));
			$tags['tag'] = $this->post('tags');
			$tags['from_email'] = $record['email_address'];
			$tags['contact_name'] = $record['contact_name'];	
			$response = send_mail_preview($templates_selection,$tags);	
			$this->response($response,200);
	}
	//admin mass mail for advertiser and publisher
	  public function send_mass_email_admin_post()
    {		
			$account_id		= 	$this->user_authentication->account_id;	
			$from_email		= 	$this->user_authentication->account_type;	
			$result			=	$this->do_networks->get_user_role_info($this->user_authentication->user_id);
			$record			=	(Array)$result[0];
			    
		
			$file_name 				= clean_data($this->post('file_name'));
			$select_publisher 		= clean_data($this->post('select_publisher'));
			$publisher 				= explode(",",clean_data($this->post('publisher')));
			$templates_selection 	= clean_data($this->post('templates'));
			$msg_type			 	= clean_data($this->post('msg_type'));
			$advertiser			 	= clean_data($this->post('advertiser'));
			$publisher_result		= $this->do_networks->get_pubs_role_info($publisher,$advertiser);
	
			
			$tags['tag'] 			= $this->input->post('tags');
				
				
			
			$tags['from_email'] 	= $record['email_address'];
			$tags['adv_acc'] 		= $account_id;
			
			$tags['contact_name'] 	= $record['contact_name'];
			$package_path = explode('application',dirname(__DIR__));
			$fi = new FilesystemIterator($package_path[0].$this->config->item('read_template_data'), FilesystemIterator::SKIP_DOTS);
			$files_count = iterator_count($fi);
			if(empty($file_name))
			{
				$files_count = $files_count + 1;
				$file_name = 'Template '.$files_count.'.html';
				$img_file_name = 'Template '.$files_count.'.png';
			}			
			$camp_list=$this->do_template->temp_file_upload_data($file_name,$img_file_name);	
			if(!empty($tags['tag']) && $msg_type == '1')
			{		
				$headers = "MIME-Version: 1.0" . "\r\n";
				$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
				$headers .= 'From: <webmaster@example.com>' . "\r\n";	
				foreach($publisher_result as $pub_result)	
				{	
					$tags['pub_acc'] 		= $pub_result['default_account_id'];
					$tags['email_address'] 	= $pub_result['email_address'];
					$a_tag					= ' ';	
						
					$tags['tag'] = str_replace("acceptreject",$a_tag,$tags['tag']);		

													
				$received =	mail($tags['email_address'],'mass mail',$tags['tag'],$headers);
					
				}					
			}
			else
			{
				$headers = "MIME-Version: 1.0" . "\r\n";
				$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
				$headers .= 'From: <webmaster@example.com>' . "\r\n";	
			foreach($publisher_result as $pub_result)	
				{				
					$tags['pub_acc'] 		= $pub_result['default_account_id'];
					$tags['email_address'] 		= $pub_result['email_address'];
						//$received=mail('selvaraj.k@dreamajax.com','mass mail',$tags['tag'],$headers);
					$received = mail($tags['email_address'],'mass mail',$tags['tag'],$headers);
					
				}
			}
			$this->response($received,200);					
	}
		
		
}
