<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Web creatives
 *
 * All web creative will be managed here 
 *
 * @package		ADX
 * @subpackage	Web creatives
 * @category	Controller
 * @author		Vigneswaran a
 * @link		http://www.djaxadserver.com
*/

class Mobile_creative extends REST_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->library('redis_library');				
		$this->load->model('do_mobile_creative');
		$this->load->model('do_auto_link');
		$this->load->model('do_creative');
		$this->load->model('do_message');
		$this->load->model('do_campaign');
		$this->load->library('notification');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
	    $this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }	
	}
	
	/*
	 * 
	 * name: fetch_creative_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists a mobile creative of an advertiser
	 */
	
	function fetch_creative_get()
	{
		$creative_id = $this->get('creative_id');
		
		if($creative_id)
		{
			$creative_details = $this->do_mobile_creative->fetch_creative($creative_id);
			$this->response($creative_details);
		}
	}
	
	/*
	 * 
	 * name: fetch_mobile_screen_sizes_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Get a mobile screen sizes
	 */
	
	function fetch_mobile_screen_sizes_get()
	{
		$mobile_screen_sizes = $this->do_mobile_creative->fetch_mobile_screen_sizes();
		$this->response($mobile_screen_sizes);
	}
	
	/*
	 * 
	 * name: fetch_parent_creative_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists a mobile creative of an advertiser
	 */
	
	function fetch_parent_creative_get()
	{
		//$account_id = $this->get('account_id');
		$creative_id = $this->get('creative_id');
		
		if($creative_id)
		{
			$creative_details = $this->do_mobile_creative->fetch_parent_creative($creative_id);
			
			$this->response($creative_details);
		}
	}
	
	/*
	 * 
	 * name: fetch_parent_creative_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists a mobile creative of an advertiser
	 */
	
	function fetch_child_creative_get()
	{
		//$account_id = $this->get('account_id');
		$creative_id = $this->get('creative_id');
		
		if($creative_id)
		{
			$creative_details = $this->do_mobile_creative->fetch_child_creative($creative_id);
			
			$this->response($creative_details);
		}
	}
	
	/*
	 * 
	 * name: add_image_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage Image Mobile Creative adding process
	 */
	public function add_image_creative_post()
	{
		$this->form_validation->set_rules('image_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$campaign = clean_data($this->post('_img_campaign_id'));
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_img_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_img_campaign_id'));
		}
					
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type='web';
			$master_banner = '-2';
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/agency_id from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_img_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_img_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
			// Get config screen sizes for mobile from database
			
			$mobile_screen_sizes = $this->do_mobile_creative->fetch_mobile_screen_sizes();
			foreach($mobile_screen_sizes as $ms) 
			{
				$mobile_size[$ms['value']]['width'] 	= $ms['width'];
				$mobile_size[$ms['value']]['height']	= $ms['height'];
			}
				
				$creative_data 	= 	array(
										"contenttype"		=>	clean_data($this->post('tmp_wide_creative_content_type')),
										"campaignid"		=>	clean_data($campaign_id),
										"storagetype"		=>	clean_data($storage_type),
										"description"		=>	clean_data($this->post('image_creative_name')),
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"dj_admin_approve"	=>	clean_data($dj_admin_approve),
										"dj_approved_date"	=>	clean_data($dj_approved_date),					
										"dj_banner_type"	=>	MOBILE_IMAGE_CREATIVE,
										"dj_master_banner"	=>	clean_data($master_banner),
										"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_account_id" 	=> 	clean_data($dj_account_id),
										"dj_is_direct" 		=> 	clean_data($dj_is_direct),
										"dj_image_path"		=>  $dj_image_path
									);
								 
				//Call to add a creative
				$banner_id = $this->do_mobile_creative->add($creative_data,$agency_id);
				
				// Insert Wide creative 
				$wide_creative_data = array(
										"banner_id" 	=> 	$banner_id,
										"file_path"		=>	clean_data($this->post('tmp_wide_creative')),
										"width"			=>	$mobile_size['wide']['width'],
										"height"		=>	$mobile_size['wide']['height'],
										"content_type"	=>	clean_data($this->post('tmp_wide_creative_content_type')),
										"display_type" 	=> 	MOBILE_SMARTPHONE_WIDE_CREATIVE,
										"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_image_path"		=>  $dj_image_path
									);
				
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_wide_creative')));
				$this->do_mobile_creative->add_child($wide_creative_data);
				
				// Insert Static creative 
															
				$static_creative_data = array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_static_creative')),
											"width"			=>	$mobile_size['static']['width'],
											"height"		=>	$mobile_size['static']['height'],
											"content_type"	=>	clean_data($this->post('tmp_static_creative_content_type')),
											"display_type" 	=> 	MOBILE_SMARTPHONE_STATIC_CREATIVE,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
				//On sucess move the expand creative from tmp location to original location
				$is_static_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_static_creative')));
				
				//Call to add a creative
				$this->do_mobile_creative->add_child($static_creative_data);
				
				// Insert Static Interstitial Creative
				$interstitial_creative_data = array(
												"banner_id" 	=> 	$banner_id,
												"file_path"		=>	clean_data($this->post('tmp_static_interstitial_creative')),
												"width"			=>	$mobile_size['interstitial']['width'],
												"height"		=>	$mobile_size['interstitial']['height'],
												"content_type"	=>	clean_data($this->post('tmp_static_interstitial_creative_content_type')),
												"display_type" 	=> 	MOBILE_SMARTPHONE_INTERSTITIAL_CREATIVE,
												"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
				
				//On sucess move the expand creative from tmp location to original location
				$is_interstitial_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_static_interstitial_creative')));
				
				//Call to add a creative
				$this->do_mobile_creative->add_child($interstitial_creative_data);
				
				// Insert Large banner				
							
				$large_creative_data = array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_large_creative')),
											"width"			=>	$mobile_size['large']['width'],
											"height"		=>	$mobile_size['large']['height'],
											"content_type"	=>	clean_data($this->post('tmp_large_creative_content_type')),
											"display_type" 	=> 	MOBILE_FEATURE_PHONE_LARGE_CREATIVE,
											"display_size" 	=> 	LARGE,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
				//On sucess move the expand creative from tmp location to original location
				$is_large_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_large_creative')));
				
				//Call to add a creative
				$this->do_mobile_creative->add_child($large_creative_data);
				
				// Insert Medium banner				
							
				$medium_creative_data = array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_medium_creative')),
											"width"			=>	$mobile_size['medium']['width'],
											"height"		=>	$mobile_size['medium']['height'],
											"content_type"	=>	clean_data($this->post('tmp_medium_creative_content_type')),
											"display_type" 	=> 	MOBILE_FEATURE_PHONE_MEDIUM_CREATIVE,
											"display_size" 	=> 	MEDIUM,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
				//On sucess move the expand creative from tmp location to original location
				$is_medium_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_medium_creative')));
				
				//Call to add a creative
				$this->do_mobile_creative->add_child($medium_creative_data);
											
				// Insert Small banner				
							
				$small_creative_data = array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_small_creative')),
											"width"			=>	$mobile_size['small']['width'],
											"height"		=>	$mobile_size['small']['height'],
											"content_type"	=>	clean_data($this->post('tmp_small_creative_content_type')),
											"display_type" 	=> 	MOBILE_FEATURE_PHONE_SMALL_CREATIVE,
											"display_size" 	=> 	SMALL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
				//On sucess move the expand creative from tmp location to original location
				$is_small_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_small_creative')));
				
				//Call to add a creative
				$creative_add = $this->do_mobile_creative->add_child($small_creative_data);


				/**********************************************************/
				// Insert Tablet Large banner				
							
				$tab_large_creative_data = array(
												"banner_id" 	=> 	$banner_id,
												"file_path"		=>	clean_data($this->post('tmp_tab_large_creative')),
												"width"			=>	$mobile_size['tab_large']['width'],
												"height"		=>	$mobile_size['tab_large']['height'],
												"content_type"	=>	clean_data($this->post('tmp_tab_large_creative_content_type')),
												"display_type" 	=> 	MOBILE_TABLET_PHONE_LARGE_CREATIVE,
												"display_size" 	=> 	LARGE,
												"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
				
				//On sucess move the expand creative from tmp location to original location
				$is_tab_large_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_tab_large_creative')));
				
				//Call to add a creative
				$this->do_mobile_creative->add_child($tab_large_creative_data);
				
				// Insert Medium banner				
							
				$tab_medium_creative_data = array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_tab_medium_creative')),
											"width"			=>	$mobile_size['tab_medium']['width'],
											"height"		=>	$mobile_size['tab_medium']['height'],
											"content_type"	=>	clean_data($this->post('tmp_tab_medium_creative_content_type')),
											"display_type" 	=> 	MOBILE_TABLET_PHONE_MEDIUM_CREATIVE,
											"display_size" 	=> 	MEDIUM,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
				//On sucess move the expand creative from tmp location to original location
				$is_tab_medium_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_tab_medium_creative')));
				
				//Call to add a creative
				$this->do_mobile_creative->add_child($tab_medium_creative_data);
											
				// Insert Small banner				
							
				$tab_small_creative_data = array(
												"banner_id" 	=> 	$banner_id,
												"file_path"		=>	clean_data($this->post('tmp_tab_small_creative')),
												"width"			=>	$mobile_size['tab_small']['width'],
												"height"		=>	$mobile_size['tab_small']['height'],
												"content_type"	=>	clean_data($this->post('tmp_tab_small_creative_content_type')),
												"display_type" 	=> 	MOBILE_TABLET_PHONE_SMALL_CREATIVE,
												"display_size" 	=> 	SMALL,
												"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
				
				//On sucess move the expand creative from tmp location to original location
				$is_tab_small_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_tab_small_creative')));
				
				//Call to add a creative
				$creative_add = $this->do_mobile_creative->add_child($tab_small_creative_data);

				
			
			if($banner_id)
			{
				
			/***creative change for message/mail notification*****/
				$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Image creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Image Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Mobile Creative';
			$content['creative_type'] = 'Image Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			/***creative change for message/mail notification*****/	
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$banner_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),
									);						
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),
									);
				}
				
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),
								);	
				}
				
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: edit_image_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage image creative edit process
	 * 
	 */
	
	public function edit_image_creative_post()
	{
		$this->form_validation->set_rules('image_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		#WIDE CREATVES
		$tmp_wide_creative=clean_data($this->post('tmp_wide_creative'));
		if (empty($tmp_wide_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('wide_creative', 'Creative', 'required');
		}
		#STATIC CREATVES
		$tmp_static_creative=clean_data($this->post('tmp_static_creative'));
		if (empty($tmp_static_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('static_creative', 'Creative', 'required');
		}
		#STATIC INTERSTITIAL CREATVES
		$tmp_static_interstitial_creative=clean_data($this->post('tmp_static_interstitial_creative'));
		if (empty($tmp_static_interstitial_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('static_interstitial_creative', 'Creative', 'required');
		}
		#LARGE CREATVES
		$tmp_large_creative=clean_data($this->post('tmp_large_creative'));
		if (empty($tmp_large_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('large_creative', 'Creative', 'required');
		}
		#MEDIUM CREATVES
		$tmp_medium_creative=clean_data($this->post('tmp_medium_creative'));
		if (empty($tmp_medium_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('medium_creative', 'Creative', 'required');
		}
		#SMALL CREATVES
		$tmp_small_creative=clean_data($this->post('tmp_small_creative'));
		if (empty($tmp_small_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('small_creative', 'Creative', 'required');
		}
		
		#TABLET LARGE CREATVES
		$tmp_large_creative=clean_data($this->post('tmp_tab_large_creative'));
		if (empty($tmp_large_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('tab_large_creative', 'Creative', 'required');
		}
		#TABLET MEDIUM CREATVES
		$tmp_medium_creative=clean_data($this->post('tmp_tab_medium_creative'));
		if (empty($tmp_medium_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('tab_medium_creative', 'Creative', 'required');
		}
		#TABLET SMALL CREATVES
		$tmp_small_creative=clean_data($this->post('tmp_tab_small_creative'));
		if (empty($tmp_small_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('tab_small_creative', 'Creative', 'required');
		}
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=clean_data($this->post('image_creative_id'));
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";			
			$creative_data = array(
				"contenttype"=>clean_data($this->post('tmp_wide_creative_content_type')),
				"description"=>clean_data($this->post('image_creative_name')),
				"url"=>clean_data($this->url_creation($this->post('destination_url'))),
				"updated"=>clean_data(date('Y:m:d :H:i:s')),
			);
			
			//Get agency_id from library file
			$agency_id=$this->user_authentication->agency_id;
			//Call to edit a creative
			 $creative_edit=$this->do_mobile_creative->edit_mobile($creative_data,$creative_id,$agency_id);
			
			// X-Large Creative Edit 
			if($creative_edit)
			{
				if(clean_data($this->post('old_wide_creative'))!=clean_data($this->post('tmp_wide_creative')))
				{
					$wide_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_wide_creative')),
							"content_type"=>clean_data($this->post('tmp_wide_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					 $where_wide = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_SMARTPHONE_WIDE_CREATIVE
						);	
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($wide_creative_data,$where_wide);
					 $old_wide_creative_path = clean_data($this->post('old_wide_creative_path'));
					 //On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_wide_creative')));
						//Delete old creative
						$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_wide_creative'),$old_wide_creative_path));
				 }
				 
				 // Large Creative Edit 
				 
				if(clean_data($this->post('old_static_creative'))!=clean_data($this->post('tmp_static_creative')))
				{
				
					$where_static = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_SMARTPHONE_STATIC_CREATIVE
						);	
					$static_creative_data = array(
												"file_path"		=>	clean_data($this->post('tmp_static_creative')),
												"content_type"	=>	clean_data($this->post('tmp_static_creative_content_type')),
												"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
					//Call to edit a creative
					$this->do_mobile_creative->edit_child_mobile($static_creative_data,$where_static);
					$old_static_creative_path = clean_data($this->post('old_static_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_static_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_static_creative')));
					//Delete old creative
					$is_old_static_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_static_creative'),$old_static_creative_path));
					
				}
				
				 // Medium Creative Edit 
				
				if(clean_data($this->post('old_static_interstitial_creative'))!=clean_data($this->post('tmp_static_interstitial_creative')))
				{
					$where_interstitial = array(
												'banner_id'		=>	$creative_id,
												'display_type'	=>	MOBILE_SMARTPHONE_INTERSTITIAL_CREATIVE
											);	
					$interstitial_creative_data = array(
														"file_path"		=>	clean_data($this->post('tmp_static_interstitial_creative')),
														"content_type"	=>	clean_data($this->post('tmp_static_interstitial_creative_content_type')),
														"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"		=>  $dj_image_path
													);
					//Call to edit a creative
					$this->do_mobile_creative->edit_child_mobile($interstitial_creative_data,$where_interstitial);
					$old_static_interstitial_creative_path = clean_data($this->post('old_static_interstitial_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_interstitial_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_static_interstitial_creative')));
					//Delete old creative
					$is_old_interstitial_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_static_interstitial_creative')),$old_static_interstitial_creative_path);
				}
				
				// Small Creative Edit 
				if(clean_data($this->post('old_large_creative'))!=clean_data($this->post('tmp_large_creative')))
				{
					$large_creative_data = array(
												"file_path"		=>	clean_data($this->post('tmp_large_creative')),
												"content_type"	=>	clean_data($this->post('tmp_large_creative_content_type')),
												"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
					$where_large = array(
										'banner_id'		=>	$creative_id,
										'display_type'	=>	MOBILE_FEATURE_PHONE_LARGE_CREATIVE,
										'display_size' 	=> 	LARGE
									);
					//Call to edit a creative
					$this->do_mobile_creative->edit_child_mobile($large_creative_data,$where_large);
					$old_large_creative_path = clean_data($this->post('old_large_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_large_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_large_creative')));
					//Delete old creative
					$is_old_large_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_large_creative'),$old_large_creative_path));
				}
				
				// Small Creative Edit 
				if(clean_data($this->post('old_medium_creative'))!=clean_data($this->post('tmp_medium_creative')))
				{
					$medium_creative_data = array(
												"file_path"		=>	clean_data($this->post('tmp_medium_creative')),
												"content_type"	=>	clean_data($this->post('tmp_medium_creative_content_type')),
												"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
					$where_medium = array(
										'banner_id'		=>	$creative_id,
										'display_type'	=>	MOBILE_FEATURE_PHONE_MEDIUM_CREATIVE,
										'display_size' 	=> 	MEDIUM
									);
					//Call to edit a creative
					$this->do_mobile_creative->edit_child_mobile($medium_creative_data,$where_medium);
					$old_medium_creative_path = clean_data($this->post('old_medium_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_medium_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_medium_creative')));
					//Delete old creative
					$is_old_medium_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_medium_creative'),$old_medium_creative_path));
				}
				
				// Small Creative Edit 
				if(clean_data($this->post('old_small_creative'))!=clean_data($this->post('tmp_small_creative')))
				{
					$small_creative_data = array(
												"file_path"		=>	clean_data($this->post('tmp_small_creative')),
												"content_type"	=>	clean_data($this->post('tmp_small_creative_content_type')),
												"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
					$where_small = array(
										'banner_id'		=>	$creative_id,
										'display_type'	=>	MOBILE_FEATURE_PHONE_SMALL_CREATIVE,
										'display_size' 	=> 	SMALL
									);
					//Call to edit a creative
					$this->do_mobile_creative->edit_child_mobile($small_creative_data,$where_small);
					$old_small_creative_path = clean_data($this->post('old_small_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_small_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_small_creative')));
					//Delete old creative
					$is_old_small_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_small_creative'),$old_small_creative_path));
				}
				// Small Creative Edit 
				if(clean_data($this->post('old_tab_large_creative'))!=clean_data($this->post('tmp_tab_large_creative')))
				{
					$tab_large_creative_data = array(
													"file_path"		=>	clean_data($this->post('tmp_tab_large_creative')),
													"content_type"	=>	clean_data($this->post('tmp_tab_large_creative_content_type')),
													"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					$where_tab_large = array(
											'banner_id'		=>	$creative_id,
											'display_type'	=>	MOBILE_TABLET_PHONE_LARGE_CREATIVE,
											'display_size' 	=> 	LARGE
										);
					//Call to edit a creative
					$this->do_mobile_creative->edit_child_mobile($tab_large_creative_data,$where_tab_large);
					$old_tab_large_creative_path = clean_data($this->post('old_tab_large_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_tab_large_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_tab_large_creative')));
					//Delete old creative
					$is_tab_old_large_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_tab_large_creative')),$old_tab_large_creative_path);
				}
				
				// Small Creative Edit 
				if(clean_data($this->post('old_tab_medium_creative'))!=clean_data($this->post('tmp_tab_medium_creative')))
				{
					$tab_medium_creative_data = array(
													"file_path"		=>	clean_data($this->post('tmp_tab_medium_creative')),
													"content_type"	=>	clean_data($this->post('tmp_tab_medium_creative_content_type')),
													"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					$where_tab_medium = array(
												'banner_id'		=>	$creative_id,
												'display_type'	=>	MOBILE_TABLET_PHONE_MEDIUM_CREATIVE,
												'display_size' 	=> 	MEDIUM
											);
					//Call to edit a creative
					$this->do_mobile_creative->edit_child_mobile($tab_medium_creative_data,$where_tab_medium);
					$old_tab_medium_creative_path = clean_data($this->post('old_tab_medium_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_tab_medium_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_tab_medium_creative')));
					//Delete old creative
					$is_tab_old_medium_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_tab_medium_creative')),$old_tab_medium_creative_path);
				}
				
				// Small Creative Edit 
				if(clean_data($this->post('old_tab_small_creative'))!=clean_data($this->post('tmp_tab_small_creative')))
				{
					$tab_small_creative_data = array(
													"file_path"		=>	clean_data($this->post('tmp_tab_small_creative')),
													"content_type"	=>	clean_data($this->post('tmp_tab_small_creative_content_type')),
													"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					$tab_where_small = array(
											'banner_id'		=>	$creative_id,
											'display_type'	=>	MOBILE_TABLET_PHONE_SMALL_CREATIVE,
											'display_size' 	=> 	SMALL
										);
					//Call to edit a creative
					$this->do_mobile_creative->edit_child_mobile($tab_small_creative_data,$tab_where_small);
					$old_tab_small_creative_path =clean_data($this->post('old_tab_small_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_tab_small_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_tab_small_creative')));
					//Delete old creative
					$is_tab_old_small_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_tab_small_creative')),$old_tab_small_creative_path);
				}
			}
			
			if($creative_edit)
			{	
				
				
				 /***creative edit for message/mail notification*****/
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Mobile Image creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Image Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Mobile Creative';
					$content['creative_type'] = 'Image Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
				/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/			
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	site_url('advertiser/creatives/'),
										);				
				}
				else
				{
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	site_url('admin/creatives/'),
										);
				}
				
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}
				
				$this->response( $error, 200);
			}
		}
	}
	
	public function add_html_creative_post() 
	{
		$this->form_validation->set_rules('html_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('html_creative_size', 'Creative size', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$this->form_validation->set_rules('html_content', 'HTML content', 'required|trim');
		$campaign = clean_data($this->post('_html_campaign_id'));
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && $this->post('_mhtml_type')!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_html_campaign_id'));
		}
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type="html";
			$bannertype=MOBILE_HTML_CREATIVE;
			$creative_size=explode('x',clean_data($this->post('html_creative_size')));
			$creative_width=$creative_size[0];
			$creative_height=$creative_size[1];
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/agency_id from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_mhtml_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_mhtml_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
		
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
			$htmlcache=html_anchor_tag_replacer($_REQUEST['html_content']);
			$html_template = stripslashes( str_ireplace('\n', '', $_REQUEST['html_content']));
			
			$creative_data = array(
									"contenttype"		=>	clean_data($storage_type),
									"campaignid"		=>	clean_data($campaign_id),
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('html_creative_name')),
									"bannertext"		=>	htmlentities($this->post('html_content')),
									"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_banner_type"	=>	clean_data($bannertype),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id"		=>	clean_data($dj_account_id),
									"width"				=>	clean_data($creative_width),
									"height"			=>	clean_data($creative_height),
									"htmltemplate"		=>	html_entity_decode($html_template),
									"htmlcache"			=>	stripslashes($html_content),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct)
								);
			
			//Call to add a creative
			$creative_add=$this->do_mobile_creative->add($creative_data,$agency_id); 

			if($creative_add)
			{
				
				
				/***creative change for message/mail notification*****/
				$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
				$content['sub'] ='Html creative added';
				$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; HTML Creative';
				$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
				$content['creative_name'] = $creative_data['description'];
				$content['creative_ml']	  = 'Mobile Creative';
				$content['creative_type'] = 'HTML Creative';
				$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			/***creative change for message/mail notification*****/	
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),
									);						
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),
									);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),
								);	
				}
					
				$this->response( $error, 200); 
			}		

		}
	}
	/*
	 * 
	 * name: add_dialog_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage mobile text creative adding process
	 */
	public function add_dialog_creative_post()
	{
		$this->form_validation->set_rules('dlg_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$this->form_validation->set_rules('dlg_content', 'HTML content', 'required|trim');
		$campaign = clean_data($this->post('_mdlg_campaign_id'));
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_mdlg_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_mdlg_campaign_id'));
		}
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	"web";
			$dj_banner_type	=	MOBILE_DIALOGUE_CREATIVE;
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			
			//Get account/agency_id from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_mdlg_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_mdlg_account_id')));
			}
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			//checking creative is ad market or not -start DAC094
			$is_admarket	= 	clean_data($this->post('_admarket_id'));
			if($is_admarket)
			{
			$ad_market = 1;
			}
			else
			{
			$ad_market = 0;
			}	
			// stop 
			$dj_is_direct	=	0;
			
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
			$creative_data = array(
									"contenttype"		=>	clean_data('txt'),
									"campaignid"		=>	clean_data($campaign_id),
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('dlg_creative_name')),
									"bannertext"		=>	htmlentities($this->post('dlg_content')),
									"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_banner_type"	=>	clean_data($dj_banner_type),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id"		=>	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									'dj_admarket_status'=>	clean_data($ad_market)
								);
			
			//Call to add a creative
			$creative_add=$this->do_mobile_creative->add($creative_data,$agency_id);
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
			/***creative change for message/mail notification*****/
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Dialog creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Dialog Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Mobile Creative';
			$content['creative_type'] = 'Dialog Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			/***creative change for message/mail notification*****/	
			if($creative_add)
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);						
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
									
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								/*'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
								);	
				}
				
				$this->response( $error, 200);
			}		

		}
	}
	
	
	
	/*
	 * 
	 * name: edit_text_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage text creative edit process
	 * 
	 */
	
	public function edit_dialogue_creative_post()
	{		
		$this->form_validation->set_rules('dlg_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('dlg_content','Creative content', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';

		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=clean_data($this->post('dlg_creative_id'));

			$storage_type="web";

			$creative_data = array(
								"contenttype"	=>	clean_data('txt'),
								"storagetype"	=>	clean_data($storage_type),
								"description"	=>	clean_data($this->post('dlg_creative_name')),
								"bannertext"	=>	htmlentities($this->post('dlg_content')),
								"url"			=>	clean_data($this->url_creation($this->post('destination_url'))),
								"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
							);


			//Get agency_id from library file
			$agency_id=$this->user_authentication->agency_id;
			
			//Call to edit a creative
			$creative_edit=$this->do_mobile_creative->edit_mobile($creative_data,$creative_id,$agency_id);

			if($creative_edit)
			{
				
				 /***creative edit for message/mail notification*****/
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Mobile Dialog creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Dialog Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Mobile Creative';
					$content['creative_type'] = 'Dialog Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
				/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);				
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);
				}
				
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);	
				}
					
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: add_text_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage mobile text creative adding process
	 */
	public function add_text_creative_post()
	{
		$this->form_validation->set_rules('text_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$this->form_validation->set_rules('text_content', 'HTML content', 'required|trim');
		$campaign = clean_data($this->post('_mtxt_campaign_id'));
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_mtxt_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id=clean_data($this->post('_mtxt_campaign_id'));
		}
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			if(clean_data($this->post('is_dialog'))=='on')
			{
				$storage_type	=	"web";
				$dj_banner_type	=	MOBILE_DIALOGUE_CREATIVE;
			}
			else
			{
				$storage_type	=	"txt";
				$dj_banner_type	=	MOBILE_TEXT_CREATIVE;
			}
			$trusted_status='';
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			
			//Get account/agency_id from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_mtxt_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_mtxt_account_id')));
			}
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			
			
			//checking creative is ad market or not -start DAC094
			$is_admarket	= 	clean_data($this->post('_admarket_id'));
			if($is_admarket)
			{
				$ad_market = 1;
			}
			else
			{
				$ad_market = 0;
			}	
			// stop 
						
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
			$creative_data = array(
									"contenttype"		=>	clean_data($storage_type),
									"campaignid"		=>	clean_data($campaign_id),
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('text_creative_name')),
									"bannertext"		=>	htmlentities($this->post('text_content')),
									"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_banner_type"	=>	clean_data($dj_banner_type),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id"		=>	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									'dj_admarket_status'=>	clean_data($ad_market)
								);
			//print_r($creative_data);exit;
			//Call to add a creative
			$creative_add=$this->do_mobile_creative->add($creative_data,$agency_id);

			if($creative_add)
			{
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
					/***creative change for message/mail notification*****/
		
						$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
						$content['sub'] ='Text creative added';
						$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Text Creative';
						$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
						$content['creative_name'] = $creative_data['description'];
						$content['creative_ml']	  = 'Mobile Creative';
						$content['creative_type'] = 'Text Creative';
						$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
				
						/***creative change for message/mail notification*****/	
				
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);						
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);	
				}
				
				$this->response( $error, 200);
			}		

		}
	}
	
	
	
	
	/*
	 * 
	 * name: add_notification_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage mobile text creative adding process
	 */
	public function add_notification_creative_post()
	{
		$this->form_validation->set_rules('text_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$this->form_validation->set_rules('text_content', 'HTML content', 'required|trim');
		$campaign = clean_data($this->post('_mtxt_campaign_id'));
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_noti_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_mtxt_campaign_id'));
		}
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	"web";
			$dj_banner_type	=	MOBILE_NOTIFICATION_CREATIVE;
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$backgroundcolor = clean_data($this->post('backgroundcolor'));
			$fontcolor = clean_data($this->post('fontcolor'));
			$trusted_status='';
			//$click_text = $this->post('click_text');
			
			//Get account/agency_id from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_noti_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_mtxt_account_id')));
			}
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			//checking creative is ad market or not -start DAC094
			$is_admarket	= 	clean_data($this->post('_admarket_id'));
			if($is_admarket)
			{
			$ad_market = 1;
			}
			else
			{
			$ad_market = 0;
			}	
			// stop 
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
			$creative_data = array(
									"contenttype"		=>	clean_data('txt'),
									"campaignid"		=>	clean_data($campaign_id),
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('text_creative_name')),
									"bannertext"		=>	htmlentities($this->post('text_content')),
									"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_banner_type"	=>	clean_data($dj_banner_type),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id"		=>	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"backgroundcolor"	=>	clean_data($backgroundcolor),
									"fontcolor"	=>	clean_data($fontcolor),
									'dj_admarket_status'=>	clean_data($ad_market)
									
									
									
								);
			
			//Call to add a creative
			$creative_add=$this->do_mobile_creative->add($creative_data,$agency_id);

			if($creative_add)
			{
				
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
							/***creative change for message/mail notification*****/
				$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
				$content['sub'] ='Notification creative added';
				$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Notification Creative';
				$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
				$content['creative_name'] = $creative_data['description'];
				$content['creative_ml']	  = 'Mobile Creative';
				$content['creative_type'] = 'Notification Creative';
				$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			/***creative change for message/mail notification*****/	
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);						
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}				
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}	
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								/*'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
								);	
				}
				
				$this->response( $error, 200);
			}		

		}
	}
	
	
	
	/*
	 * 
	 * name: edit_text_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage text creative edit process
	 * 
	 */
	
	public function edit_notification_creative_post()
	{
		
		$this->form_validation->set_rules('notification_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('notification_content','Creative content', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';

		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=clean_data($this->post('notification_creative_id'));

			$storage_type="web";

			$creative_data = array(
								"storagetype"	=>	clean_data($storage_type),
								"description"	=>	clean_data($this->post('notification_creative_name')),
								"bannertext"	=>	htmlentities($this->post('notification_content')),
								"url"			=>	clean_data($this->url_creation($this->post('destination_url'))),
								"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
								"backgroundcolor" => clean_data($this->post('backgroundcolor')),
								"fontcolor" => clean_data($this->post('fontcolor'))
							);


			//Get agency_id from library file
			$agency_id=$this->user_authentication->agency_id;
			
			//Call to edit a creative
			$creative_edit=$this->do_mobile_creative->edit_mobile($creative_data,$creative_id,$agency_id);

			if($creative_edit)
			{
				
				/***creative edit for message/mail notification*****/
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Mobile Notification creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Notification Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Mobile Creative';
					$content['creative_type'] = 'Notification Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
				/***creative edit for message/mail notification*****/	
				
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);				
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);
				}
				
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);	
				}
					
				$this->response( $error, 200);
			}
		}
	}
	/*
	 * 
	 * name: edit_text_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage text creative edit process
	 * 
	 */
	
	public function edit_text_creative_post()
	{
		
		$this->form_validation->set_rules('text_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('text_content','Creative content', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');

		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=clean_data($this->post('text_creative_id'));

			//$storage_type="txt";

			$creative_data = array(
								//"storagetype"	=>	clean_data($storage_type),
								"description"	=>	clean_data($this->post('text_creative_name')),
								"bannertext"	=>	htmlentities(clean_data($this->post('text_content'))),
								"url"			=>	clean_data($this->url_creation($this->post('destination_url'))),
								"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
							);

			//Get agency_id from library file
			$agency_id=$this->user_authentication->agency_id;
			
			//Call to edit a creative
			$creative_edit=$this->do_mobile_creative->edit_mobile($creative_data,$creative_id,$agency_id);

			if($creative_edit)
			{
				
			/***creative edit for message/mail notification*****/
			$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
			$campaign_id = $creative_dat[0]['campaignid'];
			//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Mobile text creative edited';
			$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Text Creative';
			$content['content'] ='Congrats!The creative has been edited successfully.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Mobile Creative';
			$content['creative_type'] = 'Text Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
			/***creative edit for message/mail notification*****/	
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/					
				
				
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);				
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);
				}
				
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);	
				}
					
				$this->response( $error, 200);
			}
		}
	}

 	/*
	 * 
	 * name: add_interstitial_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage Interstitial Mobile Creative adding process
	 */
	public function add_interstitial_creative_post()
	{
		$this->form_validation->set_rules('interstitial_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$campaign = clean_data($this->post('_int_campaign_id'));
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';

		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id=clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && $this->post('_int_type')!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id=clean_data($this->post('_int_campaign_id'));
		}			
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type='web';
			$master_banner = '-4';
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/agency_id from library file
			if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_int_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_int_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			//checking creative is ad market or not -start DAC094
			$is_admarket	= 	clean_data($this->post('_admarket_id'));
			if($is_admarket)
			{
			$ad_market = 1;
			}
			else
			{
			$ad_market = 0;
			}	
			// stop 
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
			if(clean_data($this->post('_creative_type'))=='Mobile')
			{
				$bannertype		=	MOBILE_MRAID_CREATIVE_INTERSTITAL;
			}
			else if(clean_data($this->post('_creative_type'))=='App')
			{
				$bannertype		=	APP_CREATIVE_INTERSTITAL;
			}
			else
			{
				$bannertype		=	MOBILE_MRAID_CREATIVE_INTERSTITAL;
			}
			
			// Set width and height of the creative
			$creative_width='320';
			$creative_height='480';
			$creative_data = array(
								"contenttype"		=>	clean_data($this->post('tmp_interstitial_creative_content_type')),
								"campaignid"		=>	clean_data($campaign_id),
								"storagetype"		=>	clean_data($storage_type),
								"description"		=>	clean_data($this->post('interstitial_creative_name')),
								"filename"			=>	clean_data($this->post('tmp_interstitial_creative')),
								"width"				=>	clean_data($creative_width),
								"height"			=>	clean_data($creative_height),
								"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
								"dj_admin_approve"	=>	clean_data($dj_admin_approve),
								"dj_approved_date"	=>	clean_data($dj_approved_date),					
								"dj_banner_type"	=>	$bannertype,
								"dj_master_banner"	=>	clean_data($master_banner),
								"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
								"dj_account_id" 	=> 	clean_data($dj_account_id),
								"dj_is_direct" 		=> 	clean_data($dj_is_direct),
								"dj_image_path"		=>  $dj_image_path,
								'dj_admarket_status'=>	clean_data($ad_market)
							);
			
			//On sucess move the web creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_interstitial_creative')));			
			 
			//Call to add a creative
			$creative_add		=	$this->do_mobile_creative->add($creative_data,$agency_id);
			
			if($creative_add)
			{
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$creative_add,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
							/***creative change for message/mail notification*****/
							
				$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
				$content['sub'] ='Interstitial creative added';
				$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Interstitial Creative';
				$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
				$content['creative_name'] = $creative_data['description'];
				$content['creative_ml']	  = 'Mobile Creative';
				$content['creative_type'] = 'Interstitial Creative';
				$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
				
				/***creative change for message/mail notification*****/	
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);						
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									'redirect'	 	=> 	$redirect_url,
									/*'redirect'	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
									);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);	
				}
				$this->response( $error, 200);
			}
		}
	}

	  /*
	 * 
	 * name: edit_interstitial_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage INTERSTITIAL creative edit process
	 * 
	 */
	
	public function edit_interstitial_creative_post()
	{
		$this->form_validation->set_rules('interstitial_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
						
		#INTERSTITIAL CREATVES
		$tmp_interstitial_creative=clean_data($this->post('tmp_interstitial_creative'));
		if (empty($tmp_interstitial_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('interstitial_creative', 'Creative', 'required');
		}
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
					
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=clean_data($this->post('interstitial_creative_id'));
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			if(clean_data($this->post('old_interstitial_creative'))!=clean_data($this->post('tmp_interstitial_creative')))
			{
				$creative_data = array(
					"contenttype"=>clean_data($this->post('tmp_interstitial_creative_content_type')),
					"description"=>clean_data($this->post('interstitial_creative_name')),
					"filename"=>clean_data($this->post('tmp_interstitial_creative')),
					"url"=>clean_data($this->url_creation($this->post('destination_url'))),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
				);
			

			//Get agency_id from library file
			 $agency_id=$this->user_authentication->agency_id;
			
			 //Call to edit a creative
			 $creative_edit=$this->do_mobile_creative->edit_mobile($creative_data,$creative_id,$agency_id);
			 
			 $old_interstitial_creative_path = clean_data($this->post('old_interstitial_creative_path'));
			  //On sucess move the web creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_interstitial_creative')));
			//Delete old creative
			$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_interstitial_creative')),$old_interstitial_creative_path);
			}
			else
			{
				$creative_data = array(
									"description"	=>	clean_data($this->post('interstitial_creative_name')),
									"url"			=>	clean_data($this->url_creation($this->post('destination_url'))),
									"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
								);
				//Call to edit a creative
			 $creative_edit=$this->do_mobile_creative->edit_mobile($creative_data,$creative_id);
			}
			
			 
			 if($creative_edit)
			 {
				 
				 /***creative edit for message/mail notification*****/
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Mobile Interstitial creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Interstitial Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Mobile Creative';
					$content['creative_type'] = 'Interstitial Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					/***creative edit for message/mail notification*****/	
				 /***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				 
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);				
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);
				}
				
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);	
				}
				
				$this->response( $error, 200);
			}
		}
	}

	/*
	 * 
	 * name: add_expand_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage Expand Mobile Creative adding process
	 */
	public function add_expand_creative_post()
	{
		$this->form_validation->set_rules('expand_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$campaign = clean_data($this->post('_exp_campaign_id'));
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && $this->post('_exp_type')!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_exp_campaign_id'));
		}		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	'web';
			$master_banner 	= 	'-5';
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/agency_id from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_exp_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_exp_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			//checking creative is ad market or not -start DAC094
			$is_admarket	= 	clean_data($this->post('_admarket_id'));
			if($is_admarket)
			{
				$ad_market = 1;
			}
			else
			{
				$ad_market = 0;
			}	
			// stop 
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			// Set width and height of the creative
			$creative_width='320';  
			$creative_height='50';
							
			$creative_data = array(
								"contenttype"		=>	clean_data($this->post('tmp_base_creative_content_type')),
								"campaignid"		=>	clean_data($campaign_id),
								"storagetype"		=>	clean_data($storage_type),
								"description"		=>	clean_data($this->post('expand_creative_name')),
								"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
								"dj_admin_approve"	=>	clean_data($dj_admin_approve),
								"dj_approved_date"	=>	clean_data($dj_approved_date),					
								"dj_banner_type"	=>	MOBILE_MRAID_CREATIVE_EXPAND,
								"dj_master_banner"	=>	clean_data($master_banner),
								"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
								"dj_account_id" 	=> 	clean_data($dj_account_id),
								"dj_is_direct" 		=> 	clean_data($dj_is_direct),
								"dj_image_path"		=>  $dj_image_path,
								'dj_admarket_status'=>	clean_data($ad_market)
							);
		   
			//Call to add a creative
			$banner_id = $this->do_mobile_creative->add($creative_data,$agency_id);
			
			// Insert base creative 
			
			$base_creative_data = array(
									"banner_id" 	=> 	$banner_id,
									"file_path"		=>	clean_data($this->post('tmp_base_creative')),
									"width"			=>	clean_data($creative_width),
									"height"		=>	clean_data($creative_height),
									"content_type"	=>	clean_data($this->post('tmp_base_creative_content_type')),
									"display_type" 	=> 	MOBILE_CREATIVE_BASE,
									"position" 		=> 	MOBILE_CREATIVE_PORTRAIT,
									"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
			
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_creative')));
			$this->do_mobile_creative->add_child($base_creative_data);
			
			// Insert expand banner
			
			$expand_creative_width 	= 	'320';
			$expand_creative_height	=	'480';
							
			$expand_creative_data = array(
										"banner_id" 	=> 	clean_data($banner_id),
										"file_path"		=>	clean_data($this->post('tmp_expand_creative')),
										"width"			=>	clean_data($expand_creative_width),
										"height"		=>	clean_data($expand_creative_height),
										"content_type"	=>	clean_data($this->post('tmp_expand_creative_content_type')),
										"display_type" 	=> 	MOBILE_CREATIVE_EXPAND,
										"position" 		=> 	MOBILE_CREATIVE_LANDSCAPE,
										"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_image_path"		=>  $dj_image_path
									);
			
			//On sucess move the expand creative from tmp location to original location
			$is_expand_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_expand_creative')));
			
			//Call to add a creative
			$creative_add = $this->do_mobile_creative->add_child($expand_creative_data);						
			
			if($creative_add)
			{
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$banner_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				/***creative change for message/mail notification*****/
				$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
				$content['sub'] ='Expand creative added';
				$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Expand Creative';
				$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
				$content['creative_name'] = $creative_data['description'];
				$content['creative_ml']	  = 'Mobile Creative';
				$content['creative_type'] = 'Expand Creative';
				$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			/***creative change for message/mail notification*****/	
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);						
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{					
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,  
								);	
				}
				
				$this->response( $error, 200);
			}
		}
	}
	
	 /*
	 * 
	 * name: edit_expand_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage Expand creative edit process
	 * 
	 */
	
	public function edit_expand_creative_post()
	{
		$this->form_validation->set_rules('expand_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		#BASE CREATVES
		$tmp_base_creative=clean_data($this->post('tmp_base_creative'));
		if (empty($tmp_base_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('base_creative', 'Creative', 'required');
		}
		#EXPAND CREATVES
		$tmp_expand_creative=clean_data($this->post('tmp_expand_creative'));
		if (empty($tmp_expand_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('expand_creative', 'Creative', 'required');
		}
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';  
		
		//$this->response("sssasa",200);
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=clean_data($this->post('expand_creative_id'));
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";			
			$creative_data = array(
									"contenttype"	=>	clean_data($this->post('tmp_base_creative_content_type')),
									"description"	=>	clean_data($this->post('expand_creative_name')),
									"url"			=>	clean_data($this->url_creation($this->post('destination_url'))),
									"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
								);
			
			//Get agency_id from library file
			$agency_id=$this->user_authentication->agency_id;
			
			//Call to edit a creative
			 $creative_edit=$this->do_mobile_creative->edit_mobile($creative_data,$creative_id,$agency_id);
			 if($creative_edit)
			 {
				 if(clean_data($this->post('old_base_creative'))!=clean_data($this->post('tmp_base_creative')))
				 {
					$base_creative_data = array(
												"file_path"		=>	clean_data($this->post('tmp_base_creative')),
												"content_type"	=>	clean_data($this->post('tmp_base_creative_content_type')),
												"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
					 $where_base = array(
										'banner_id'		=>	$creative_id,
										'display_type'	=>	MOBILE_CREATIVE_BASE
									);	
					//Call to edit a creative
					$this->do_mobile_creative->edit_child_mobile($base_creative_data,$where_base);
					$old_base_creative_path = clean_data($this->post('old_base_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_base_creative')),$old_base_creative_path);
				 }
				 
				 if(clean_data($this->post('old_expand_creative'))!=clean_data($this->post('tmp_expand_creative')))
				 {
					$expand_creative_data = array(
												"file_path"		=>	clean_data($this->post('tmp_expand_creative')),
												"content_type"	=>	clean_data($this->post('tmp_expand_creative_content_type')),
												"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
					 $where_expand = array(
										'banner_id'		=>	$creative_id,
										'display_type'	=>	MOBILE_CREATIVE_EXPAND
									);	
					//Call to edit a creative
					$this->do_mobile_creative->edit_child_mobile($expand_creative_data,$where_expand);
					$old_expand_creative_path = clean_data($this->post('old_expand_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_expand_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_expand_creative')),$old_expand_creative_path);
				 }
			 }
			 if($creative_edit)
			 {
				 /***creative edit for message/mail notification*****/
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Mobile Expand creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Expand Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Mobile Creative';
					$content['creative_type'] = 'Expand Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
				/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
					$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
					if($enable=='1')
					{					
						$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
					}
			
			/***Activity Log For adding creatives ***/
				 
				 if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{						
						$redirect_url=site_url('advertiser/admarket/creatives/');						
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);				
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);
				}
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					
					if($adma_id=='1')
					{						
						$redirect_url=site_url('advertiser/admarket/creatives/');						
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);	
				}
					
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: add_reveal_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage Reveal Mobile Creative adding process
	 */
	public function add_reveal_creative_post()
	{
		$this->form_validation->set_rules('reveal_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$campaign = clean_data($this->post('_reveal_campaign_id'));
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_reveal_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_reveal_campaign_id'));
		}			
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type='web';
			$master_banner = '-5';
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/agency_id from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_reveal_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_reveal_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
						
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			//checking creative is ad market or not -start DAC094
			$is_admarket	= 	clean_data($this->post('_admarket_id'));
			if($is_admarket)
			{
				$ad_market = 1;
			}
			else
			{
				$ad_market = 0;
			}	
			// stop 
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
				// Set width and height of the creative
				$creative_width='320';
				$creative_height='50';
				
				$creative_data = array(
									"contenttype"		=>	clean_data($this->post('tmp_base_creative_content_type')),
									"campaignid"		=>	clean_data($campaign_id),
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('reveal_creative_name')),
									"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
									"dj_banner_type"	=>	MOBILE_MRAID_CREATIVE_REVEAL,
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),					
									"dj_master_banner"	=>	clean_data($master_banner),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"dj_image_path"		=>  $dj_image_path,
									'dj_admarket_status'=>	clean_data($ad_market)
								);				
				
                //Get agency_id from library file
			    $agency_id=$this->user_authentication->agency_id;
			
				//Call to add a creative
				$banner_id = $this->do_mobile_creative->add($creative_data,$agency_id);
				
				// Insert base creative 
				
				$base_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_base_creative')),
											"width"			=>	clean_data($creative_width),
											"height"		=>	clean_data($creative_height),
											"content_type"	=>	clean_data($this->post('tmp_base_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BASE,
											"position" 		=> 	MOBILE_CREATIVE_PORTRAIT,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_creative')));
				$this->do_mobile_creative->add_child($base_creative_data);
				
				// Insert expand banner
				
				$expand_creative_width = '320';
				$expand_creative_height='480';
								
				$expand_creative_data = array(
												"banner_id" 	=> 	clean_data($banner_id),
												"file_path"		=>	clean_data($this->post('tmp_reveal_creative')),
												"width"			=>	clean_data($expand_creative_width),
												"height"		=>	clean_data($expand_creative_height),
												"content_type"	=>	clean_data($this->post('tmp_reveal_creative_content_type')),
												"display_type"	=> 	MOBILE_CREATIVE_REVEAL,
												"position" 		=> 	MOBILE_CREATIVE_LANDSCAPE,
												"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);	
				
				//On sucess move the expand creative from tmp location to original location
				$is_expand_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_reveal_creative')));
				
				//Call to add a creative
				$creative_add = $this->do_mobile_creative->add_child($expand_creative_data);
							
			
			if($creative_add)
			{
				
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$banner_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
		/***creative change for message/mail notification*****/
		
				$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
				$content['sub'] ='Reveal creative added';
				$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Reveal Creative';
				$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
				$content['creative_name'] = $creative_data['description'];
				$content['creative_ml']	  = 'Mobile Creative';
				$content['creative_type'] = 'Reveal Creative';
				$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
				
			/***creative change for message/mail notification*****/	
				
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);						
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);	
				}	
				$this->response( $error, 200);     
			}
		}
	}
	
	/*
	 * 
	 * name: edit_reveal_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage Reveal creative edit process
	 * 
	 */
	
	public function edit_reveal_creative_post()
	{		
		$this->form_validation->set_rules('reveal_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		#BASE CREATVES
		$tmp_base_creative=clean_data($this->post('tmp_base_creative'));
		if (empty($tmp_base_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('base_creative', 'Creative', 'required');
		}
		#REVEAL CREATVES
		$tmp_reveal_creative=clean_data($this->post('tmp_reveal_creative'));
		if (empty($tmp_reveal_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('reveal_creative', 'Creative', 'required');
		}
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';					

		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=clean_data($this->post('reveal_creative_id'));
						
			$creative_data = array(
									"contenttype"	=>	clean_data($this->post('tmp_base_creative_content_type')),
									"description"	=>	clean_data($this->post('reveal_creative_name')),
									"url"			=>	clean_data($this->url_creation($this->post('destination_url'))),
									"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
								);
			
			//Get agency_id from library file
			$agency_id=$this->user_authentication->agency_id;
			 $dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";	
			//Call to edit a creative
			 $creative_edit=$this->do_mobile_creative->edit_mobile($creative_data,$creative_id,$agency_id);
			if($creative_edit) 
			{
				if(clean_data($this->post('old_base_creative'))!=clean_data($this->post('tmp_base_creative')))
				{
					$base_creative_data = array(
												"file_path"		=>	clean_data($this->post('tmp_base_creative')),
												"content_type"	=>	clean_data($this->post('tmp_base_creative_content_type')),
												"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
					$where_base = array(
										'banner_id'		=>	$creative_id,
										'display_type'	=>	MOBILE_CREATIVE_BASE
									);	
					
					//Call to edit a creative
					$this->do_mobile_creative->edit_child_mobile($base_creative_data,$where_base);
					$old_base_reveal_creative_path = clean_data($this->post('old_base_reveal_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_base_creative')),$old_base_reveal_creative_path);
				 }
				 
				 if(clean_data($this->post('old_reveal_creative'))!=clean_data($this->post('tmp_reveal_creative')))
				 {
					$reveal_creative_data = array(
													"file_path"		=>	clean_data($this->post('tmp_reveal_creative')),
													"content_type"	=>	clean_data($this->post('tmp_reveal_creative_content_type')),
													"updated"		=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					 $where_reveal = array(
											'banner_id'		=>	$creative_id,
											'display_type'	=>	MOBILE_CREATIVE_REVEAL
										);	
					//Call to edit a creative
					$this->do_mobile_creative->edit_child_mobile($reveal_creative_data,$where_reveal);
					$old_reveal_creative_path = clean_data($this->post('old_reveal_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_reveal_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_reveal_creative')),$old_reveal_creative_path);
				 }
			}
			if($creative_edit)
			{
				
				/***creative edit for message/mail notification*****/
			$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
			$campaign_id = $creative_dat[0]['campaignid'];
			//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Mobile Reveal creative edited';
			$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Reveal Creative';
			$content['content'] ='Congrats!The creative has been edited successfully.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Mobile Creative';
			$content['creative_type'] = 'Reveal Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
			/***creative edit for message/mail notification*****/
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/	
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);				
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);
				}
				
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);	
				}
				
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: add_filmstrip_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage Filmstrip Mobile Creative adding process
	 */
	public function add_filmstrip_creative_post()
	{
		$this->form_validation->set_rules('filmstrip_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$campaign = clean_data($this->post('_fs_campaign_id'));
		
		$admarket_id = clean_data($this->post('_admarket_id'));
        $adma_id = ($admarket_id == false)?'0':'1';
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_fs_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_fs_campaign_id'));
		}			
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	'web';
			$master_banner 	= 	'-2';
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/agency_id from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id=$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_fs_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_web_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			//checking creative is ad market or not -start DAC094
			$is_admarket	= 	clean_data($this->post('_admarket_id'));
			if($is_admarket)
			{
			$ad_market = 1;
			}
			else
			{
			$ad_market = 0;
			}	
			// stop 
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			// Set width and height of the creative
			$creative_width	=	'320';
			$creative_height=	'50';
								
			$creative_data = array(
									"contenttype"		=>	clean_data($this->post('tmp_base_creative_content_type')),
									"campaignid"		=>	clean_data($campaign_id),
									"storagetype"		=>	clean_data($storage_type),
									"description"		=>	clean_data($this->post('filmstrip_creative_name')),
									"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),					
									"dj_banner_type"	=>	MOBILE_RS_CREATIVE_FILMSTRIP,
									"dj_master_banner"	=>	clean_data($master_banner),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"dj_image_path"		=>  $dj_image_path,
									'dj_admarket_status'=>	clean_data($ad_market)
								);
			
			//Get agencyid
		   // $agency_id=$this->post('agency_id');
			//Call to add a creative
			$banner_id 	= 	$this->do_mobile_creative->add($creative_data,$agency_id);
			
			// Insert base creative 
			
			$base_creative_data = array(
										"banner_id" 	=> 	$banner_id,
										"file_path"		=>	clean_data($this->post('tmp_base_creative')),
										"width"			=>	clean_data($creative_width),
										"height"		=>	clean_data($creative_height),
										"content_type"	=>	clean_data($this->post('tmp_base_creative_content_type')),
										"display_type" 	=> 	MOBILE_CREATIVE_BASE,
										"position" 		=> 	MOBILE_CREATIVE_PORTRAIT,
										"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_image_path"		=>  $dj_image_path
									);
			
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_creative')));
			$this->do_mobile_creative->add_child($base_creative_data);
			
			// Insert base1 creative
			
			$creative_base1_width 	= 	"480";
			$creative_base1_height 	= 	"50";
			
			$base1_creative_data = array(
										"banner_id" 	=> 	$banner_id,
										"file_path"		=>	clean_data($this->post('tmp_base1_creative')),
										"width"			=>	clean_data($creative_base1_width),
										"height"		=>	clean_data($creative_base1_height),
										"content_type"	=>	clean_data($this->post('tmp_base1_creative_content_type')),
										"display_type" 	=> 	MOBILE_CREATIVE_BASE,
										"position" 		=> 	MOBILE_CREATIVE_LANDSCAPE,
										"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_image_path"		=>  $dj_image_path
									);
			
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base1_creative')));
			$this->do_mobile_creative->add_child($base1_creative_data);
			
			// Insert base2 creative			
		
			// Insert Horizontal1 creative
			
			$creative_hor1_width 	= 	"480";
			$creative_hor1_height 	= 	"320";
			
			$hor1_creative_data = array(
										"banner_id" 	=> 	$banner_id,
										"file_path"		=>	clean_data($this->post('tmp_hor1_creative')),
										"width"			=>	clean_data($creative_hor1_width),
										"height"		=>	clean_data($creative_hor1_height),
										"content_type"	=>	clean_data($this->post('tmp_hor1_creative_content_type')),
										"display_type" 	=> 	MOBILE_CREATIVE_FILMSTRIP,
										"display_size" 	=> 	X_LARGE,
										"position" 		=> 	MOBILE_CREATIVE_LANDSCAPE,
										"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_image_path"		=>  $dj_image_path
									);
			
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_hor1_creative')));
			$this->do_mobile_creative->add_child($hor1_creative_data);
			
			// Insert Horizontal2 creative
			
			$creative_hor2_width 	= "480";
			$creative_hor2_height 	= "320";
			
			$hor2_creative_data = array(
										"banner_id" 	=> 	$banner_id,
										"file_path"		=>	clean_data($this->post('tmp_hor2_creative')),
										"width"			=>	clean_data($creative_hor2_width),
										"height"		=>	clean_data($creative_hor2_height),
										"content_type"	=>	clean_data($this->post('tmp_hor2_creative_content_type')),
										"display_type" 	=> 	MOBILE_CREATIVE_FILMSTRIP,
										"display_size" 	=> 	LARGE,
										"position" 		=> 	MOBILE_CREATIVE_LANDSCAPE,
										"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_image_path"		=>  $dj_image_path
									);
			
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location($this->post('tmp_hor2_creative'));
			$this->do_mobile_creative->add_child($hor2_creative_data);
			
			// Insert Horizontal3 creative
			
			$creative_hor3_width 	= "480";
			$creative_hor3_height 	= "320";
			
			$hor3_creative_data = array(
										"banner_id" 	=> 	$banner_id,
										"file_path"		=>	clean_data($this->post('tmp_hor3_creative')),
										"width"			=>	clean_data($creative_hor3_width),
										"height"		=>	clean_data($creative_hor3_height),
										"content_type"	=>	clean_data($this->post('tmp_hor3_creative_content_type')),
										"display_type" 	=> 	MOBILE_CREATIVE_FILMSTRIP,
										"display_size" 	=> 	MEDIUM,
										"position" 		=> 	MOBILE_CREATIVE_LANDSCAPE,
										"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_image_path"		=>  $dj_image_path
									);
			
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_hor3_creative')));
			$this->do_mobile_creative->add_child($hor3_creative_data);
			
			// Insert Horizontal4 creative
			
			$creative_hor4_width 	= "480";
			$creative_hor4_height 	= "320";
			
			$hor4_creative_data = array(
										"banner_id" 	=> 	$banner_id,
										"file_path"		=>	clean_data($this->post('tmp_hor4_creative')),
										"width"			=>	clean_data($creative_hor4_width),
										"height"		=>	clean_data($creative_hor4_height),
										"content_type"	=>	clean_data($this->post('tmp_hor4_creative_content_type')),
										"display_type" 	=> 	MOBILE_CREATIVE_FILMSTRIP,
										"display_size" 	=> 	SMALL,
										"position" 		=> 	MOBILE_CREATIVE_LANDSCAPE,
										"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_image_path"		=>  $dj_image_path
									);
			
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_hor4_creative')));
			$this->do_mobile_creative->add_child($hor4_creative_data);
			
			// Insert Tablet1 creative
			
			$creative_tab1_width 	= "300";
			$creative_tab1_height 	= "600";
			
			$tab1_creative_data = array(
										"banner_id" 	=> 	$banner_id,
										"file_path"		=>	clean_data($this->post('tmp_tab1_creative')),
										"width"			=>	clean_data($creative_tab1_width),
										"height"		=>	clean_data($creative_tab1_height),
										"content_type"	=>	clean_data($this->post('tmp_tab1_creative_content_type')),
										"display_type" 	=> 	MOBILE_CREATIVE_NAVIGATION_TAB,
										"display_size" 	=> 	XX_LARGE,
										"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_image_path"		=>  $dj_image_path
									);
			
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_tab1_creative')));
			$this->do_mobile_creative->add_child($tab1_creative_data);
			
			// Insert Tablet2 creative
			
			$creative_tab2_width 	= "300";
			$creative_tab2_height 	= "600";
			
			$tab2_creative_data = array(
										"banner_id" 	=> 	$banner_id,
										"file_path"		=>	clean_data($this->post('tmp_tab2_creative')),
										"width"			=>	clean_data($creative_tab2_width),
										"height"		=>	clean_data($creative_tab2_height),
										"content_type"	=>	clean_data($this->post('tmp_tab2_creative_content_type')),
										"display_type" 	=> 	MOBILE_CREATIVE_NAVIGATION_TAB,
										"display_size" 	=> 	X_LARGE,
										"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_image_path"		=>  $dj_image_path
									);
			
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_tab2_creative')));
			$this->do_mobile_creative->add_child($tab2_creative_data);
			
			// Insert Tablet3 creative
			
			$creative_tab3_width 	= "300";
			$creative_tab3_height 	= "600";
			
			$tab3_creative_data = array(
										"banner_id" 	=> 	$banner_id,
										"file_path"		=>	clean_data($this->post('tmp_tab3_creative')),
										"width"			=>	clean_data($creative_tab3_width),
										"height"		=>	clean_data($creative_tab3_height),
										"content_type"	=>	clean_data($this->post('tmp_tab3_creative_content_type')),
										"display_type" 	=> 	MOBILE_CREATIVE_NAVIGATION_TAB,
										"display_size" 	=> 	LARGE,
										"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_image_path"		=>  $dj_image_path
									);
			
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_tab3_creative')));
			$this->do_mobile_creative->add_child($tab3_creative_data);
			
			// Insert Tablet4 creative
			
			$creative_tab4_width 	= "300";
			$creative_tab4_height 	= "600";
			
			$tab4_creative_data = array(
										"banner_id" 	=> 	$banner_id,
										"file_path"		=>	clean_data($this->post('tmp_tab4_creative')),
										"width"			=>	clean_data($creative_tab4_width),
										"height"		=>	clean_data($creative_tab4_height),
										"content_type"	=>	clean_data($this->post('tmp_tab4_creative_content_type')),
										"display_type" 	=> 	MOBILE_CREATIVE_NAVIGATION_TAB,
										"display_size" 	=> 	MEDIUM,
										"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_image_path"		=>  $dj_image_path
									);
			
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_tab4_creative')));
			$this->do_mobile_creative->add_child($tab4_creative_data);
			
			// Insert Tablet5 creative
			
			$creative_tab5_width 	= "300";
			$creative_tab5_height 	= "600";
			
			$tab5_creative_data = array(
										"banner_id" 	=> 	$banner_id,
										"file_path"		=>	clean_data($this->post('tmp_tab5_creative')),
										"width"			=>	clean_data($creative_tab5_width),
										"height"		=>	clean_data($creative_tab5_height),
										"content_type"	=>	clean_data($this->post('tmp_tab5_creative_content_type')),
										"display_type" 	=> 	MOBILE_CREATIVE_NAVIGATION_TAB,
										"display_size" 	=> 	SMALL,
										"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_image_path"		=>  $dj_image_path
									);
			
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_tab5_creative')));
			$this->do_mobile_creative->add_child($tab5_creative_data);
			
			// Insert Filmstrip ad1 banner
			
			$filmstrip_creative_width = '320';
			$filmstrip_creative_height='480';
							
			$film_ad1_creative_data = array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_filmstrip_ad1_creative')),
											"width"			=>	clean_data($filmstrip_creative_width),
											"height"		=>	clean_data($filmstrip_creative_height),
											"content_type"	=>	clean_data($this->post('tmp_filmstrip_ad1_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_FILMSTRIP,
											"display_size" 	=> 	X_LARGE,
											"position" 		=> 	MOBILE_CREATIVE_PORTRAIT,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
			
			//On sucess move the expand creative from tmp location to original location
			$is_expand_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_filmstrip_ad1_creative')));
			
			//Call to add a creative
			$this->do_mobile_creative->add_child($film_ad1_creative_data);
			
			// Insert Filmstrip ad2 banner
			$film_ad2_creative_data = array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_filmstrip_ad2_creative')),
											"width"			=>	clean_data($filmstrip_creative_width),
											"height"		=>	clean_data($filmstrip_creative_height),
											"content_type"	=>	clean_data($this->post('tmp_filmstrip_ad2_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_FILMSTRIP,
											"display_size" 	=> 	LARGE,
											"position" 		=> 	MOBILE_CREATIVE_PORTRAIT,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
			
			//On sucess move the expand creative from tmp location to original location
			$is_expand_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_filmstrip_ad2_creative')));
			
			//Call to add a creative
			$this->do_mobile_creative->add_child($film_ad2_creative_data);
			
			// Insert Filmstrip ad3 banner			
						
			$film_ad3_creative_data = array(
											"banner_id" => $banner_id,
											"file_path"=>clean_data($this->post('tmp_filmstrip_ad3_creative')),
											"width"=>clean_data($filmstrip_creative_width),
											"height"=>clean_data($filmstrip_creative_height),
											"content_type"=>clean_data($this->post('tmp_filmstrip_ad3_creative_content_type')),
											"display_type" => MOBILE_CREATIVE_FILMSTRIP,
											"display_size" => MEDIUM,
											"position" => MOBILE_CREATIVE_PORTRAIT,
											"created_date"=>clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
			
			//On sucess move the expand creative from tmp location to original location
			$is_expand_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_filmstrip_ad3_creative')));
			
			//Call to add a creative
			$this->do_mobile_creative->add_child($film_ad3_creative_data);
			
			// Insert Filmstrip ad4 banner
							
			$film_ad4_creative_data = array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_filmstrip_ad4_creative')),
											"width"			=>	clean_data($filmstrip_creative_width),
											"height"		=>	clean_data($filmstrip_creative_height),
											"content_type"	=>	clean_data($this->post('tmp_filmstrip_ad4_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_FILMSTRIP,
											"display_size" 	=> 	SMALL,
											"position" 		=> 	MOBILE_CREATIVE_PORTRAIT,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
			
			//On sucess move the expand creative from tmp location to original location
			$is_expand_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_filmstrip_ad4_creative')));
			
			//Call to add a creative
			$creative_add = $this->do_mobile_creative->add_child($film_ad4_creative_data);
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$banner_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/				
			/***creative change for message/mail notification*****/
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Filmstrip creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; filmstrip Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Mobile Creative';
			$content['creative_type'] = 'filmstrip Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			/***creative change for message/mail notification*****/	
			
			if($creative_add)
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);						
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);
				}
				$this->response( $success, 200);  
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,
								);	
				}
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: edit_filmstrip_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage filmstrip creative edit process
	 * 
	 */
	
	public function edit_filmstrip_creative_post()
	{
		$this->form_validation->set_rules('filmstrip_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
					
		#BASE CREATVES
		$tmp_base_creative=clean_data($this->post('tmp_base_creative'));
		if (empty($tmp_base_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('base_creative', 'Creative', 'required');
		}
		#BASE1 CREATVES
		$tmp_base1_creative=clean_data($this->post('tmp_base1_creative'));
		if (empty($tmp_base1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('base1_creative', 'Creative', 'required');
		}
		#HORIZONTAL1 CREATVES
		$tmp_hor1_creative=clean_data($this->post('tmp_hor1_creative'));
		if(empty($tmp_hor1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('hor1_creative', 'Creative', 'required');
		}
		#HORIZONTAL2 CREATVES
		$tmp_hor2_creative=clean_data($this->post('tmp_hor2_creative'));
		if(empty($tmp_hor2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('hor2_creative', 'Creative', 'required');
		}
		#HORIZONTAL3 CREATVES
		$tmp_hor3_creative=clean_data($this->post('tmp_hor3_creative'));
		if(empty($tmp_hor3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('hor3_creative', 'Creative', 'required');
		}
		#HORIZONTAL4 CREATVES
		$tmp_hor4_creative=clean_data($this->post('tmp_hor4_creative'));
		if(empty($tmp_hor4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('hor4_creative', 'Creative', 'required');
		}
		#TABLET1 CREATVES
		$tmp_tab1_creative=clean_data($this->post('tmp_tab1_creative'));
		if(empty($tmp_tab1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('tab1_creative', 'Creative', 'required');
		}
		#TABLET1 CREATVES
		$tmp_tab2_creative=clean_data($this->post('tmp_tab2_creative'));
		if(empty($tmp_tab2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('tab2_creative', 'Creative', 'required');
		}
		#TABLET3 CREATVES
		$tmp_tab3_creative=clean_data($this->post('tmp_tab3_creative'));
		if (empty($tmp_tab3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('tab3_creative', 'Creative', 'required');
		}
		#TABLET4 CREATVES
		$tmp_tab4_creative=clean_data($this->post('tmp_tab4_creative'));
		if (empty($tmp_tab4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('tab4_creative', 'Creative', 'required');
		}
		#TABLET5 CREATVES
		$tmp_tab5_creative=clean_data($this->post('tmp_tab5_creative'));
		if (empty($tmp_tab5_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('tab5_creative', 'Creative', 'required');
		}
		#FILMSTRIP AD1 CREATIVES
		$tmp_filmstrip_ad1_creative=clean_data($this->post('tmp_filmstrip_ad1_creative'));
		if (empty($tmp_filmstrip_ad1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('filmstrip_ad1_creative', 'Creative', 'required');
		}
		#FILMSTRIP AD2 CREATIVES
		$tmp_filmstrip_ad2_creative=clean_data($this->post('tmp_filmstrip_ad2_creative'));
		if (empty($tmp_filmstrip_ad2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('filmstrip_ad2_creative', 'Creative', 'required');
		}
		#FILMSTRIP AD3 CREATIVES
		$tmp_filmstrip_ad3_creative=clean_data($this->post('tmp_filmstrip_ad3_creative'));
		if (empty($tmp_filmstrip_ad3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('filmstrip_ad3_creative', 'Creative', 'required');
		}
		#FILMSTRIP AD4 CREATIVES
		$tmp_filmstrip_ad4_creative=clean_data($this->post('tmp_filmstrip_ad4_creative'));
		if (empty($tmp_filmstrip_ad4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('filmstrip_ad4_creative', 'Creative', 'required');
		}
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=clean_data($this->post('filmstrip_creative_id'));
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";				
			$creative_data = array(
				"contenttype"=>clean_data($this->post('tmp_base_creative_content_type')),
				"description"=>clean_data($this->post('filmstrip_creative_name')),
				"url"=>clean_data($this->url_creation($this->post('destination_url'))),
				"updated"=>clean_data(date('Y:m:d :H:i:s')),
			);
			
			//Get agency_id from library file
			$agency_id=$this->user_authentication->agency_id;
			 
			//Call to edit a creative
			 $creative_edit=$this->do_mobile_creative->edit_mobile($creative_data,$creative_id,$agency_id);
			if($creative_edit)
			{
				if(clean_data($this->post('old_base_creative'))!=clean_data($this->post('tmp_base_creative')))
				{
				
					$base_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_base_creative')),
							"content_type"=>clean_data($this->post('tmp_base_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
				
					 $where_base = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_CREATIVE_BASE,
							'position'=>MOBILE_CREATIVE_PORTRAIT
						);	
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($base_creative_data,$where_base);
					
					$old_film_base_creative_path = clean_data($this->post('old_film_base_creative_path'));
					 //On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_creative')));
						//Delete old creative
						$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_base_creative')),$old_film_base_creative_path);
				}
				
				// BASE1 CREATIVE EDIT
				if(clean_data($this->post('old_base1_creative'))!=clean_data($this->post('tmp_base1_creative')))
				{
				
					$base1_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_base1_creative')),
							"content_type"=>clean_data($this->post('tmp_base1_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					 $where_base = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_CREATIVE_BASE,
							'position'=>MOBILE_CREATIVE_LANDSCAPE
						);	
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($base1_creative_data,$where_base);
					 
					 $old_film_base1_creative_path = clean_data($this->post('old_film_base1_creative_path'));
					 //On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base1_creative')));
						//Delete old creative
						$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_base1_creative')),$old_film_base1_creative_path);
				}
				
				// HORIZONTAL1 CREATIVE EDIT
				if(clean_data($this->post('old_hor1_creative'))!=clean_data($this->post('tmp_hor1_creative')))
				{
				
					$hor1_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_hor1_creative')),
							"content_type"=>clean_data($this->post('tmp_hor1_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
						
					 $where_base = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_CREATIVE_FILMSTRIP,
							'position'=>MOBILE_CREATIVE_LANDSCAPE,
							'display_size'=>X_LARGE
						);
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($hor1_creative_data,$where_base);
					 
					 $old_hor1_creative_path = clean_data($this->post('old_hor1_creative_path'));
					 //On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_hor1_creative')));
						//Delete old creative
						$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_hor1_creative')),$old_hor1_creative_path);
				}
				
				// HORIZONTAL2 CREATIVE EDIT
				if(clean_data($this->post('old_hor2_creative'))!=clean_data($this->post('tmp_hor2_creative')))
				{
				
					$hor2_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_hor2_creative')),
							"content_type"=>clean_data($this->post('tmp_hor2_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					 $where_base = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_CREATIVE_FILMSTRIP,
							'position'=>MOBILE_CREATIVE_LANDSCAPE,
							'display_size'=>LARGE
						);	
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($hor2_creative_data,$where_base);
					 
					 $old_hor2_creative_path = clean_data($this->post('old_hor2_creative_path'));
					 //On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_hor2_creative')));
						//Delete old creative
						$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_hor2_creative')),$old_hor2_creative_path);
				}
				
				// HORIZONTAL3 CREATIVE EDIT
				if(clean_data($this->post('old_hor3_creative'))!=clean_data($this->post('tmp_hor3_creative')))
				{
				
					$hor3_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_hor3_creative')),
							"content_type"=>clean_data($this->post('tmp_hor3_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					 $where_base = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_CREATIVE_FILMSTRIP,
							'position'=>MOBILE_CREATIVE_LANDSCAPE,
							'display_size'=>MEDIUM
						);	
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($hor3_creative_data,$where_base);
					 
					 $old_hor3_creative_path = clean_data($this->post('old_hor3_creative_path'));
					 //On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_hor3_creative')));
						//Delete old creative
						$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_hor3_creative')),$old_hor3_creative_path);
				}
				
				// HORIZONTAL4 CREATIVE EDIT
				if(clean_data($this->post('old_hor4_creative'))!=clean_data($this->post('tmp_hor4_creative')))
				{
				
					$hor4_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_hor4_creative')),
							"content_type"=>clean_data($this->post('tmp_hor4_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					 $where_base = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_CREATIVE_FILMSTRIP,
							'position'=>MOBILE_CREATIVE_LANDSCAPE,
							'display_size'=>SMALL
						);	
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($hor4_creative_data,$where_base);
					 
					 $old_hor4_creative_path = clean_data($this->post('old_hor4_creative_path'));
					 //On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_hor4_creative')));
						//Delete old creative
						$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_hor4_creative')),$old_hor4_creative_path);
				}
				
				// TABLET1 CREATIVE EDIT
				if($this->post('old_tab1_creative')!=$this->post('tmp_tab1_creative'))
				{
				
					$tab1_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_tab1_creative')),
							"content_type"=>clean_data($this->post('tmp_tab1_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					 $where_base = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_CREATIVE_NAVIGATION_TAB,
							'display_size'=>XX_LARGE
						);	
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($tab1_creative_data,$where_base);
					 
					 $old_tab1_creative_path = clean_data($this->post('old_tab1_creative_path'));
					 //On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_tab1_creative')));
						//Delete old creative
						$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_tab1_creative')),$old_tab1_creative_path);
				}
				
				// TABLET2 CREATIVE EDIT
				if($this->post('old_tab2_creative')!=$this->post('tmp_tab2_creative'))
				{
				
					$tab2_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_tab2_creative')),
							"content_type"=>clean_data($this->post('tmp_tab2_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					 $where_base = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_CREATIVE_NAVIGATION_TAB,
							'display_size'=>X_LARGE
						);	
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($tab2_creative_data,$where_base);
					 
					 $old_tab2_creative_path = clean_data($this->post('old_tab2_creative_path'));
					 //On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_tab2_creative')));
						//Delete old creative
						$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_tab2_creative')),$old_tab2_creative_path);
				}
				
				// TABLET3 CREATIVE EDIT
				if($this->post('old_tab3_creative')!=$this->post('tmp_tab3_creative'))
				{
				
					$tab3_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_tab3_creative')),
							"content_type"=>clean_data($this->post('tmp_tab3_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					 $where_base = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_CREATIVE_NAVIGATION_TAB,
							'display_size'=>LARGE
						);	
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($tab3_creative_data,$where_base);
					 
					 $old_tab3_creative_path = clean_data($this->post('old_tab3_creative_path'));
					 //On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_tab3_creative')));
						//Delete old creative
						$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_tab3_creative')),$old_tab3_creative_path);
				}
				
				// TABLET4 CREATIVE EDIT
				if($this->post('old_tab4_creative')!=clean_data($this->post('tmp_tab4_creative')))
				{
				
					$tab4_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_tab4_creative')),
							"content_type"=>clean_data($this->post('tmp_tab4_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					 $where_base = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_CREATIVE_NAVIGATION_TAB,
							'display_size'=>MEDIUM
						);	
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($tab4_creative_data,$where_base);
					 
					 $old_tab4_creative_path = clean_data($this->post('old_tab4_creative_path'));
					 //On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_tab4_creative')));
						//Delete old creative
						$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_tab4_creative')),$old_tab4_creative_path);
				}
				
				// TABLET5 CREATIVE EDIT
				if($this->post('old_tab5_creative')!=$this->post('tmp_tab5_creative'))
				{
				
					$tab5_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_tab5_creative')),
							"content_type"=>clean_data($this->post('tmp_tab5_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					 $where_base = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_CREATIVE_NAVIGATION_TAB,
							'display_size'=>MEDIUM
						);	
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($tab5_creative_data,$where_base);
					 
					 $old_tab5_creative_path = clean_data($this->post('old_tab5_creative_path'));
					 //On sucess move the web creative from tmp location to original location
						$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_tab5_creative')));
						//Delete old creative
						$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_tab5_creative')),$old_tab5_creative_path);
				}
				
				// FILMSTRIP AD1 CREATIVE EDIT
				if($this->post('old_filmstrip_ad1_creative')!=$this->post('tmp_filmstrip_ad1_creative'))
				{
					$where_film_ad1 = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_CREATIVE_FILMSTRIP,
							'position'=>MOBILE_CREATIVE_PORTRAIT,
							'display_size' => X_LARGE
						);	
					$film_ad1_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_filmstrip_ad1_creative')),
							"content_type"=>clean_data($this->post('tmp_filmstrip_ad1_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					//Call to edit a creative
					$this->do_mobile_creative->edit_child_mobile($film_ad1_creative_data,$where_film_ad1);
					
					$old_filmstrip_ad1_creative_path = clean_data($this->post('old_filmstrip_ad1_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_expand_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_filmstrip_ad1_creative')));
					//Delete old creative
					$is_old_expand_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_filmstrip_ad1_creative')),$old_filmstrip_ad1_creative_path);
				}
				// FILMSTRIP AD2 CREATIVE EDIT
				if($this->post('old_filmstrip_ad2_creative')!=$this->post('tmp_filmstrip_ad2_creative'))
				{
					// Filmstrip Ad2 edit 
					$where_film_ad2 = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_CREATIVE_FILMSTRIP,
							'position'=>MOBILE_CREATIVE_PORTRAIT,
							'display_size' => LARGE
						);	
					$film_ad2_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_filmstrip_ad2_creative')),
							"content_type"=>clean_data($this->post('tmp_filmstrip_ad2_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					//Call to edit a creative
					$this->do_mobile_creative->edit_child_mobile($film_ad2_creative_data,$where_film_ad2);
					
					$old_filmstrip_ad2_creative_path = clean_data($this->post('old_filmstrip_ad2_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_expand_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_filmstrip_ad2_creative')));
					//Delete old creative
					$is_old_expand_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_filmstrip_ad2_creative')),$old_filmstrip_ad2_creative_path);
				}
				
				// FILMSTRIP AD3 CREATIVE EDIT
				if($this->post('old_filmstrip_ad3_creative')!=$this->post('tmp_filmstrip_ad3_creative'))
				{
					$film_ad3_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_filmstrip_ad3_creative')),
							"content_type"=>clean_data($this->post('tmp_filmstrip_ad3_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					$where_film_ad3 = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_CREATIVE_FILMSTRIP,
							'position'=>MOBILE_CREATIVE_PORTRAIT,
							'display_size' => MEDIUM
						);
					//Call to edit a creative
					$this->do_mobile_creative->edit_child_mobile($film_ad3_creative_data,$where_film_ad3);
					
					$old_filmstrip_ad3_creative_path = clean_data($this->post('old_filmstrip_ad3_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_expand_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_filmstrip_ad3_creative'));
					//Delete old creative
					$is_old_expand_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_filmstrip_ad3_creative')),$old_filmstrip_ad3_creative_path);
				}
				// FILMSTRIP AD4 CREATIVE EDIT
				if($this->post('old_filmstrip_ad4_creative')!=$this->post('tmp_filmstrip_ad4_creative'))
				{
					$film_ad4_creative_data = array(
							"file_path"=>clean_data($this->post('tmp_filmstrip_ad4_creative')),
							"content_type"=>clean_data($this->post('tmp_filmstrip_ad4_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					$where_film_ad4 = array(
							'banner_id'=>$creative_id,
							'display_type'=>MOBILE_CREATIVE_FILMSTRIP,
							'position'=>MOBILE_CREATIVE_PORTRAIT,
							'display_size' => SMALL
						);	
					//Call to edit a creative
					$this->do_mobile_creative->edit_child_mobile($film_ad4_creative_data,$where_film_ad4);
					
					$old_filmstrip_ad4_creative_path = clean_data($this->post('old_filmstrip_ad4_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_expand_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_filmstrip_ad4_creative')));
					//Delete old creative
					$is_old_expand_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_filmstrip_ad4_creative')),$old_filmstrip_ad4_creative_path);
				}
			}
			if($creative_edit)
			{
				
				/***creative edit for message/mail notification*****/
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Mobile Filmstrip creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Filmstrip Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Mobile Creative';
					$content['creative_type'] = 'Filmstrip Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
				/***creative edit for message/mail notification*****/	
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);				
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);
				}
				
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);	
				}
				
				$this->response( $error, 200);
			}
		}
	}
	/*
	 * 
	 * name: edit_adhesion_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage adhesion creative edit process
	 * 
	 */
	public function edit_html_creative_post()
	{  
		$campaign_id= clean_data($this->post('_campaign_id'));
		$this->form_validation->set_rules('html_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$this->form_validation->set_rules('html_content', 'HTML content', 'required|trim');
		

		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=clean_data($this->post('html_creative_id'));
			$storage_type="html";
			$htmlcache=html_anchor_tag_replacer($_REQUEST['html_content']);
			$html_template = stripslashes( str_ireplace('\n', '', $_REQUEST['html_content']));
			if(isset($htmlcache))
			{
				$creative_data = array(
						"description"=>clean_data($this->post('html_creative_name')),
						"url"=>clean_data($this->url_creation($this->post('destination_url'))),
						"htmltemplate "=>html_entity_decode($html_template),
						"htmlcache"=>stripslashes($htmlcache),
						"updated"=>clean_data(date('Y:m:d :H:i:s')),
					);
			//Get agencyid from library
			 $agency_id=$this->user_authentication->agency_id;
			//Call to edit a creative
			$creative_edit=$this->do_mobile_creative->edit_mobile($creative_data,$creative_id,$agency_id);

			}
			if($creative_edit)
			{
				
				
				 /***creative edit for message/mail notification*****/
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Mobile HTML creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; HTML Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Mobile Creative';
					$content['creative_type'] = 'HTML Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id); 
				/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	site_url('advertiser/creatives/'),
										);				
				}
				else
				{
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	site_url('admin/creatives/'),
										);
				}
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}
					
				$this->response( $error, 200);
			}
		}
	}

	public function edit_adhesion_creative_post()
	{
		$this->form_validation->set_rules('creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		#BASE CREATVES
		$tmp_base_portrait_creative=clean_data($this->post('tmp_base_portrait_creative'));
		if (empty($tmp_base_portrait_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('base_portrait', 'Creative', 'required');
		}
		$tmp_base_landscape_creative=clean_data($this->post('tmp_base_landscape_creative'));
		if (empty($tmp_base_landscape_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('base_landscape', 'Creative', 'required');
		}
		$tmp_base_tablet1_creative=clean_data($this->post('tmp_base_tablet1_creative'));
		if (empty($tmp_base_tablet1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('base_tablet1', 'Creative', 'required');
		}
		$tmp_base_tablet2_creative=clean_data($this->post('tmp_base_tablet2_creative'));
		if (empty($tmp_base_tablet2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('base_tablet2', 'Creative', 'required');
		}
		#HORIZANTAL CREATIVES
		$tmp_horizantal_ad1_creative=clean_data($this->post('tmp_horizantal_ad1_creative'));
		if (empty($tmp_horizantal_ad1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('horizantal_ad1', 'Creative', 'required');
		}
		$tmp_horizantal_ad2_creative=clean_data($this->post('tmp_horizantal_ad2_creative'));
		if (empty($tmp_horizantal_ad2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('horizantal_ad2', 'Creative', 'required');
		}
		$tmp_horizantal_ad3_creative=clean_data($this->post('tmp_horizantal_ad3_creative'));
		if (empty($tmp_horizantal_ad3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('horizantal_ad3', 'Creative', 'required');
		}
		$tmp_horizantal_ad4_creative=clean_data($this->post('tmp_horizantal_ad4_creative'));
		if (empty($tmp_horizantal_ad4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('horizantal_ad4', 'Creative', 'required');
		}
		#VERTICAL CREATIVES
		$tmp_vertical_ad1_creative=clean_data($this->post('tmp_vertical_ad1_creative'));
		if (empty($tmp_vertical_ad1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('vertical_ad1', 'Creative', 'required');
		}
		$tmp_vertical_ad2_creative=$this->post('tmp_vertical_ad2_creative');
		if (empty($tmp_vertical_ad2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('vertical_ad2', 'Creative', 'required');
		}
		$tmp_vertical_ad3_creative=clean_data($this->post('tmp_vertical_ad3_creative'));
		if (empty($tmp_vertical_ad3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('vertical_ad3', 'Creative', 'required');
		}
		$tmp_vertical_ad4_creative=clean_data($this->post('tmp_vertical_ad4_creative'));
		if (empty($tmp_vertical_ad4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('vertical_ad4', 'Creative', 'required');
		}
		#CONTENT CREATIVES
		$tmp_content_ad1_creative=clean_data($this->post('tmp_content_ad1_creative'));
		if (empty($tmp_content_ad1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('content_ad1', 'Creative', 'required');
		}
		$tmp_content_ad2_creative=clean_data($this->post('tmp_content_ad2_creative'));
		if (empty($tmp_content_ad2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('content_ad2', 'Creative', 'required');
		}
		$tmp_content_ad3_creative=clean_data($this->post('tmp_content_ad3_creative'));
		if (empty($tmp_content_ad3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('content_ad3', 'Creative', 'required');
		}
		$tmp_content_ad4_creative=clean_data($this->post('tmp_content_ad4_creative'));
		if (empty($tmp_content_ad4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('content_ad4', 'Creative', 'required');
		}
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=clean_data($this->post('adhesion_creative_id'));
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";				
			$creative_data = array(
				"description"=>clean_data($this->post('creative_name')),
				"url"=>clean_data($this->url_creation($this->post('destination_url'))),
				"updated"=>clean_data(date('Y:m:d :H:i:s')),
			);
			
			//Get accountid from library file
			$agency_id=$this->user_authentication->agency_id;
			
			//Call to edit a creative
			$creative_edit=$this->do_mobile_creative->edit_mobile($creative_data,$creative_id,$agency_id);

		
			 if($creative_edit)
			 {
				 #Base cretives
				if($this->post('old_base_portrait_creative') != $this->post('tmp_base_portrait_creative'))
				{
					// Base creative protrait
					$base_creative_protrait = array(
							"file_path"=>clean_data($this->post('tmp_base_portrait_creative')),
							"content_type"=>clean_data($this->post('tmp_base_portrait_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BASE,'position'=>MOBILE_CREATIVE_PORTRAIT);	
					
					$base_creative_edit = $this->do_mobile_creative->edit_child_mobile($base_creative_protrait,$where);

					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_portrait_creative')));
					
					$old_adh_base_portrait_path = clean_data($this->post('old_adh_base_portrait_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_base_portrait')),$old_adh_base_portrait_path);
				}
				if($this->post('old_base_landscape_creative') != $this->post('tmp_base_landscape_creative'))
				{
					// Base creative landscape
					$base_creative_landscape = array(
							"file_path"=>clean_data($this->post('tmp_base_landscape_creative')),
							"content_type"=>clean_data($this->post('tmp_base_landscape_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BASE,'position'=>MOBILE_CREATIVE_LANDSCAPE);

					$this->do_mobile_creative->edit_child_mobile($base_creative_landscape,$where);

					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_landscape_creative')));
					
					$old_adh_base_landscape_creative_path = clean_data($this->post('old_adh_base_landscape_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_base_landscape')),$old_adh_base_landscape_creative_path);
				}
				if(clean_data($this->post('old_base_tablet1_creative')) != clean_data($this->post('tmp_base_tablet1_creative')))
				{
					// Base creative protrait
					$base_creative_tablet1 = array(
							"file_path"=>clean_data($this->post('tmp_base_tablet1_creative')),
							"content_type"=>clean_data($this->post('tmp_base_tablet1_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BASE,'position'=>MOBILE_CREATIVE_TABLET_PORTRAIT);	
					
					$base_creative_edit = $this->do_mobile_creative->edit_child_mobile($base_creative_tablet1,$where);

					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_tablet1_creative')));
					
					$old_adh_base_tablet1_creative_path = clean_data($this->post('old_adh_base_tablet1_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_base_tablet1')),$old_adh_base_tablet1_creative_path);
				}
				if(clean_data($this->post('old_base_tablet2_creative')) != clean_data($this->post('tmp_base_tablet2_creative')))
				{
					// Base creative protrait
					$base_creative_tablet2 = array(
							"file_path"=>clean_data($this->post('tmp_base_tablet2_creative')),
							"content_type"=>clean_data($this->post('tmp_base_tablet2_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
						
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BASE,'position'=>MOBILE_CREATIVE_TABLET_LANDSCAPE);	
					
					$base_creative_edit = $this->do_mobile_creative->edit_child_mobile($base_creative_tablet2,$where);

					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_tablet2_creative')));
					
					$old_adh_base_tablet2_creative_path = clean_data($this->post('old_adh_base_tablet2_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date($this->post('old_base_tablet2'),$old_adh_base_tablet2_creative_path);
				}
				 #Horizantal creatives
				if(clean_data($this->post('old_horizantal_ad1_creative')) != clean_data($this->post('tmp_horizantal_ad1_creative')))
				{
					$horizantal_creative_one = array(
					"file_path"=>clean_data($this->post('tmp_horizantal_ad1_creative')),
					"content_type"=>clean_data($this->post('tmp_horizantal_ad1_creative_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
					);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_HORIZONTAL,	'display_size'=>X_LARGE);
					$this->do_mobile_creative->edit_child_mobile($horizantal_creative_one,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad1_creative')));
					
					$old_adh_horizantal_ad1_creative_path = clean_data($this->post('old_adh_horizantal_ad1_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_horizantal_ad1')),$old_adh_horizantal_ad1_creative_path);
				}
				
				if(clean_data($this->post('old_horizantal_ad2_creative')) != clean_data($this->post('tmp_horizantal_ad2_creative')))
				{
					
					$horizantal_creative_two = array(
							"file_path"=>clean_data($this->post('tmp_horizantal_ad2_creative')),
							"content_type"=>clean_data($this->post('tmp_horizantal_ad2_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_HORIZONTAL,'display_size'=>LARGE);
					$this->do_mobile_creative->edit_child_mobile($horizantal_creative_two,$where);

					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad2_creative')));
					
					$old_adh_horizantal_ad2_creative_path = clean_data($this->post('old_adh_horizantal_ad2_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_horizantal_ad2')),$old_adh_horizantal_ad2_creative_path);
				}
				
				if(clean_data($this->post('old_horizantal_ad3_creative')) != clean_data($this->post('tmp_horizantal_ad3_creative')))
				{
					$horizantal_creative_three = array(
					"file_path"=>clean_data($this->post('tmp_horizantal_ad3_creative')),
					"content_type"=>clean_data($this->post('tmp_horizantal_ad3_creative_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_HORIZONTAL,'display_size'=>MEDIUM);	
					$this->do_mobile_creative->edit_child_mobile($horizantal_creative_three,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad3_creative')));
					
					$old_adh_horizantal_ad3_creative_path = clean_data($this->post('old_adh_horizantal_ad3_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_horizantal_ad3')),$old_adh_horizantal_ad3_creative_path);
				}
				
				if(clean_data($this->post('old_horizantal_ad4_creative')) != clean_data($this->post('tmp_horizantal_ad4_creative')))
				{
					$horizantal_creative_four = array(
					"file_path"=>clean_data($this->post('tmp_horizantal_ad4_creative')),
					"content_type"=>clean_data($this->post('tmp_horizantal_ad4_creative_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
					);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_HORIZONTAL,'display_size'=>SMALL);
				
					$this->do_mobile_creative->edit_child_mobile($horizantal_creative_four,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad4_creative')));
					
					$old_adh_horizantal_ad4_creative_path = clean_data($this->post('old_adh_horizantal_ad4_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_horizantal_ad4')),$old_adh_horizantal_ad4_creative_path);
				}
				 #Vertical creatives
				if(clean_data($this->post('old_vertical_ad1_creative')) != clean_data($this->post('tmp_vertical_ad1_creative')))
				{
					$vertical_creative_one = array(
					"file_path"=>clean_data($this->post('tmp_vertical_ad1_creative')),
					"content_type"=>clean_data($this->post('tmp_vertical_ad1_creative_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
					
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_VERTICAL,'display_size'=>X_LARGE);
					$this->do_mobile_creative->edit_child_mobile($vertical_creative_one,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad1_creative')));
					
					$old_adh_vertical_ad1_creative_path = clean_data($this->post('old_adh_vertical_ad1_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_vertical_ad1')),$old_adh_vertical_ad1_creative_path);
				}
				if(clean_data($this->post('old_vertical_ad2_creative')) != clean_data($this->post('tmp_vertical_ad2_creative')))
				{
					$vertical_creative_two = array(
					"file_path"=>clean_data($this->post('tmp_vertical_ad2_creative')),
					"content_type"=>clean_data($this->post('tmp_vertical_ad2_creative_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_VERTICAL,'display_size'=>LARGE);
					$this->do_mobile_creative->edit_child_mobile($vertical_creative_two,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad2_creative')));
					$old_adh_vertical_ad2_creative_path = clean_data($this->post('old_adh_vertical_ad2_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_vertical_ad2')),$old_adh_vertical_ad2_creative_path);
				}
				if(clean_data($this->post('old_vertical_ad3_creative')) != clean_data($this->post('tmp_vertical_ad3_creative')))
				{
					$vertical_creative_three = array(
					"file_path"=>clean_data($this->post('tmp_vertical_ad3_creative')),
					"content_type"=>clean_data($this->post('tmp_vertical_ad3_creative_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
					);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_VERTICAL,'display_size'=>MEDIUM);	
					$this->do_mobile_creative->edit_child_mobile($vertical_creative_three,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad3_creative')));
					
					$old_adh_vertical_ad3_creative_path = clean_data($this->post('old_vertical_ad3_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_vertical_ad3')),$old_adh_vertical_ad3_creative_path);
				}
				if(clean_data($this->post('old_vertical_ad4_creative')) != clean_data($this->post('tmp_vertical_ad4_creative')))
				{
					$vertical_creative_four = array(
					"file_path"=>clean_data($this->post('tmp_vertical_ad4_creative')),
					"content_type"=>clean_data($this->post('tmp_vertical_ad4_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
					
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_VERTICAL,'display_size'=>SMALL);
					
					$this->do_mobile_creative->edit_child_mobile($vertical_creative_four,$where);
					
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_vertical_ad4_creative'));
					$old_adh_vertical_ad4_creative_path = $this->post('old_adh_vertical_ad4_creative_path');
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date($this->post('old_vertical_ad4'),$old_adh_vertical_ad4_creative_path);
				}
				#Content creatives
				if($this->post('old_content_ad1_creative') != $this->post('tmp_content_ad1_creative'))
				{
					$content_creative_one = array(
					"file_path"=>clean_data($this->post('tmp_content_ad1_creative')),
					"content_type"=>clean_data($this->post('tmp_content_ad1_creative_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
					
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_CONTENT,'display_size'=>X_LARGE);
					$this->do_mobile_creative->edit_child_mobile($content_creative_one,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad1_creative')));
					
					$old_adh_content_ad1_creative_path = clean_data($this->post('old_adh_content_ad1_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_content_ad1')),$old_adh_content_ad1_creative_path);
				}
				if($this->post('old_content_ad2_creative') != $this->post('tmp_content_ad2_creative'))
				{
					$content_creative_two = array(
					"file_path"=>clean_data($this->post('tmp_content_ad2_creative')),
					"content_type"=>clean_data($this->post('tmp_content_ad2_creative_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_CONTENT,'display_size'=>LARGE);
					$this->do_mobile_creative->edit_child_mobile($content_creative_two,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad2_creative')));
					$old_adh_content_ad2_creative_path = clean_data($this->post('old_adh_content_ad2_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_content_ad2')),$old_adh_content_ad2_creative_path);
				}
				if($this->post('old_content_ad3_creative') != $this->post('tmp_content_ad3_creative'))
				{
					$content_creative_three = array(
					"file_path"=>clean_data($this->post('tmp_content_ad3_creative')),
					"content_type"=>clean_data($this->post('tmp_content_ad3_creative_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_CONTENT,'display_size'=>MEDIUM);	
					$this->do_mobile_creative->edit_child_mobile($content_creative_three,$where);

					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad3_creative')));
					$old_adh_content_ad3_creative_path = clean_data($this->post('old_adh_content_ad3_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_content_ad3')),$old_adh_content_ad3_creative_path);
				}
				if($this->post('old_content_ad4_creative') != $this->post('tmp_content_ad4_creative'))
				{
					$content_creative_four = array(
					"file_path"=>clean_data($this->post('tmp_content_ad4_creative')),
					"content_type"=>clean_data($this->post('tmp_content_ad4_creative_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_CONTENT,'display_size'=>SMALL);
					$this->do_mobile_creative->edit_child_mobile($content_creative_four,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad4_creative')));
					$old_adh_content_ad4_creative_path = clean_data($this->post('old_adh_content_ad4_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_content_ad4')),$old_adh_content_ad4_creative_path);
				}
			}

			if($creative_edit)
			{	
				
				 /***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Mobile Adhesion creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Adhesion Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Mobile Creative';
					$content['creative_type'] = 'Adhesion Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
				/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);				
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited'.$is_old_creative_deleted,
										'redirect'	=> 	$redirect_url,
										);
				}
				
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);	
				}
				$this->response( $error, 200);
			}
		}
	}
	/*
	 * 
	 * name: edit_flex_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage flex creative edit process
	 * 
	 */
	
	public function edit_flex_creative_post()
	{
		$this->form_validation->set_rules('flex_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
					
		#HORIZANTAL CREATIVES
		$tmp_horizantal_ad1_creative=clean_data($this->post('tmp_horizantal_ad1_creative'));
		if (empty($tmp_horizantal_ad1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('horizantal_ad1', 'Creative', 'required');
		}
		$tmp_horizantal_ad2_creative=clean_data($this->post('tmp_horizantal_ad2_creative'));
		if (empty($tmp_horizantal_ad2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('horizantal_ad2', 'Creative', 'required');
		}
		$tmp_horizantal_ad3_creative=clean_data($this->post('tmp_horizantal_ad3_creative'));
		if (empty($tmp_horizantal_ad3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('horizantal_ad3', 'Creative', 'required');
		}
		$tmp_horizantal_ad4_creative=clean_data($this->post('tmp_horizantal_ad4_creative'));
		if (empty($tmp_horizantal_ad4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('horizantal_ad4', 'Creative', 'required');
		}
		#VERTICAL CREATIVES
		$tmp_vertical_ad1_creative=clean_data($this->post('tmp_vertical_ad1_creative'));
		if (empty($tmp_vertical_ad1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('vertical_ad1', 'Creative', 'required');
		}
		$tmp_vertical_ad2_creative=clean_data($this->post('tmp_vertical_ad2_creative'));
		if (empty($tmp_vertical_ad2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('vertical_ad2', 'Creative', 'required');
		}
		$tmp_vertical_ad3_creative=clean_data($this->post('tmp_vertical_ad3_creative'));
		if (empty($tmp_vertical_ad3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('vertical_ad3', 'Creative', 'required');
		}
		$tmp_vertical_ad4_creative=clean_data($this->post('tmp_vertical_ad4_creative'));
		if (empty($tmp_vertical_ad4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('vertical_ad4', 'Creative', 'required');
		}
		#CONTENT CREATIVES
		$tmp_content_ad1_creative=clean_data($this->post('tmp_content_ad1_creative'));
		if (empty($tmp_content_ad1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('content_ad1', 'Creative', 'required');
		}
		$tmp_content_ad2_creative=clean_data($this->post('tmp_content_ad2_creative'));
		if (empty($tmp_content_ad2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('content_ad2', 'Creative', 'required');
		}
		$tmp_content_ad3_creative=clean_data($this->post('tmp_content_ad3_creative'));
		if (empty($tmp_content_ad3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('content_ad3', 'Creative', 'required');
		}
		$tmp_content_ad4_creative=clean_data($this->post('tmp_content_ad4_creative'));
		if (empty($tmp_content_ad4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('content_ad4', 'Creative', 'required');
		}
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=clean_data($this->post('flex_creative_id'));
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";			
			$creative_data = array(
				"description"=>clean_data($this->post('flex_creative_name')),
				"url"=>clean_data($this->url_creation($this->post('destination_url'))),
				"updated"=>clean_data(date('Y:m:d :H:i:s')),
			);
			
			//Get agency_id from library file
			$agency_id=$this->user_authentication->agency_id;
			
			#Call to edit a creative
			$creative_edit=$this->do_mobile_creative->edit_mobile($creative_data,$creative_id,$agency_id);

		
			 if($creative_edit)
			 {
				#Horizantal creatives
				if(clean_data($this->post('old_horizantal_ad1_creative')) != clean_data($this->post('tmp_horizantal_ad1_creative')))
				{
					$horizantal_creative_one = array(
					"file_path"=>clean_data($this->post('tmp_horizantal_ad1_creative')),
					"content_type"=>clean_data($this->post('tmp_horizantal_ad1_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
					);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_HORIZONTAL,	'display_size'=>X_LARGE);
					$this->do_mobile_creative->edit_child_mobile($horizantal_creative_one,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad1_creative')));
					
					$old_horizantal_ad1_creative_path =clean_data($this->post('old_horizantal_ad1_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_horizantal_ad1')),$old_horizantal_ad1_creative_path);
				}
				
				if(clean_data($this->post('old_horizantal_ad2_creative')) != clean_data($this->post('tmp_horizantal_ad2_creative')))
				{
					
					$horizantal_creative_two = array(
							"file_path"=>clean_data($this->post('tmp_horizantal_ad2_creative')),
							"content_type"=>clean_data($this->post('tmp_horizantal_ad2_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_HORIZONTAL,'display_size'=>LARGE);
					$this->do_mobile_creative->edit_child_mobile($horizantal_creative_two,$where);

					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad2_creative')));
					$old_horizantal_ad2_creative_path = clean_data($this->post('old_horizantal_ad2_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_horizantal_ad2')),$old_horizantal_ad2_creative_path);
				}
				
				if(clean_data($this->post('old_horizantal_ad3_creative')) != clean_data($this->post('tmp_horizantal_ad3_creative')))
				{
					$horizantal_creative_three = array(
					"file_path"=>clean_data($this->post('tmp_horizantal_ad3_creative')),
					"content_type"=>clean_data($this->post('tmp_horizantal_ad3_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_HORIZONTAL,'display_size'=>MEDIUM);	
					$this->do_mobile_creative->edit_child_mobile($horizantal_creative_three,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad3_creative')));
					
					$old_horizantal_ad3_creative_path = clean_data($this->post('old_horizantal_ad3_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_horizantal_ad3')),$old_horizantal_ad3_creative_path);
				}
				
				if(clean_data($this->post('old_horizantal_ad4_creative')) != clean_data($this->post('tmp_horizantal_ad4_creative')))
				{
					$horizantal_creative_four = array(
					"file_path"=>clean_data($this->post('tmp_horizantal_ad4_creative')),
					"content_type"=>clean_data($this->post('tmp_horizantal_ad4_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
					);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_HORIZONTAL,'display_size'=>SMALL);
				
					$this->do_mobile_creative->edit_child_mobile($horizantal_creative_four,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad4_creative')));
					
					$old_horizantal_ad4_creative_path = clean_data($this->post('old_horizantal_ad4_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_horizantal_ad4')),$old_horizantal_ad4_creative_path);
				}
				 #Vertical creatives
				if(clean_data($this->post('old_vertical_ad1_creative')) != clean_data($this->post('tmp_vertical_ad1_creative')))
				{
					$vertical_creative_one = array(
					"file_path"=>clean_data($this->post('tmp_vertical_ad1_creative')),
					"content_type"=>clean_data($this->post('tmp_vertical_ad1_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
					
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_VERTICAL,'display_size'=>X_LARGE);
					$this->do_mobile_creative->edit_child_mobile($vertical_creative_one,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad1_creative')));
					
					$old_vertical_ad1_creative_path = clean_data($this->post('old_vertical_ad1_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_vertical_ad1')),$old_vertical_ad1_creative_path);
				}
				if(clean_data($this->post('old_vertical_ad2_creative')) != clean_data($this->post('tmp_vertical_ad2_creative')))
				{
					$vertical_creative_two = array(
					"file_path"=>clean_data($this->post('tmp_vertical_ad2_creative')),
					"content_type"=>clean_data($this->post('tmp_vertical_ad2_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_VERTICAL,'display_size'=>LARGE);
					$this->do_mobile_creative->edit_child_mobile($vertical_creative_two,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad2_creative')));
					
					$old_vertical_ad2_creative_path = clean_data($this->post('old_vertical_ad2_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_vertical_ad2')),$old_vertical_ad2_creative_path);
				}
				if(clean_data($this->post('old_vertical_ad3_creative')) != clean_data($this->post('tmp_vertical_ad3_creative')))
				{
					$vertical_creative_three = array(
					"file_path"=>clean_data($this->post('tmp_vertical_ad3_creative')),
					"content_type"=>clean_data($this->post('tmp_vertical_ad3_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
					);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_VERTICAL,'display_size'=>MEDIUM);	
					$this->do_mobile_creative->edit_child_mobile($vertical_creative_three,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('tmp_vertical_ad3_creative'));
					
					$old_vertical_ad3_creative_path = clean_data($this->post('old_vertical_ad3_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_vertical_ad3')),$old_vertical_ad3_creative_path);
				}
				if(clean_data($this->post('old_vertical_ad4_creative')) != clean_data($this->post('tmp_vertical_ad4_creative')))
				{
					$vertical_creative_four = array(
					"file_path"=>clean_data($this->post('tmp_vertical_ad4_creative')),
					"content_type"=>clean_data($this->post('tmp_vertical_ad4_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
					
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_VERTICAL,'display_size'=>SMALL);
					
					$this->do_mobile_creative->edit_child_mobile($vertical_creative_four,$where);
					
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad4_creative')));
					
					$old_vertical_ad4_creative_path = clean_data($this->post('old_vertical_ad4_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_vertical_ad4')),$old_vertical_ad4_creative_path);
				}
				#Content creatives
				if(clean_data($this->post('old_content_ad1_creative')) != clean_data($this->post('tmp_content_ad1_creative')))
				{
					$content_creative_one = array(
					"file_path"=>clean_data($this->post('tmp_content_ad1_creative')),
					"content_type"=>clean_data($this->post('tmp_content_ad1_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
					
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_CONTENT,'display_size'=>X_LARGE);
					$this->do_mobile_creative->edit_child_mobile($content_creative_one,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad1_creative')));
					
					$old_content_ad1_creative_path = $this->post('old_content_ad1_creative_path');
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date($this->post('old_content_ad1'),$old_content_ad1_creative_path);
				}
				if(clean_data($this->post('old_content_ad2_creative')) != clean_data($this->post('tmp_content_ad2_creative')))
				{
					$content_creative_two = array(
					"file_path"=>clean_data($this->post('tmp_content_ad2_creative')),
					"content_type"=>clean_data($this->post('tmp_content_ad2_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_CONTENT,'display_size'=>LARGE);
					$this->do_mobile_creative->edit_child_mobile($content_creative_two,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad2_creative')));
					
					$old_content_ad2_creative_path = clean_data($this->post('old_content_ad2_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_content_ad2')),$old_content_ad2_creative_path);
				}
				if(clean_data($this->post('old_content_ad3_creative')) != clean_data($this->post('tmp_content_ad3_creative')))
				{
					$content_creative_three = array(
					"file_path"=>clean_data($this->post('tmp_content_ad3_creative')),
					"content_type"=>clean_data($this->post('tmp_content_ad3_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_CONTENT,'display_size'=>MEDIUM);	
					$this->do_mobile_creative->edit_child_mobile($content_creative_three,$where);

					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad3_creative')));
					
					$old_content_ad3_creative_path = clean_data($this->post('old_content_ad3_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_content_ad3')),$old_content_ad3_creative_path);
				}
				if(clean_data($this->post('old_content_ad4_creative')) !=clean_data($this->post('tmp_content_ad4_creative')))
				{
					$content_creative_four = array(
					"file_path"=>clean_data($this->post('tmp_content_ad4_creative')),
					"content_type"=>clean_data($this->post('tmp_content_ad4_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_CONTENT,'display_size'=>SMALL);
					$this->do_mobile_creative->edit_child_mobile($content_creative_four,$where);
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad4_creative')));
					
					$old_content_ad4_creative_path = clean_data($this->post('old_content_ad4_creative_path'));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_content_ad4')),$old_content_ad4_creative_path);
				}
			}

			if($creative_edit)
			{	
				
				/***creative edit for message/mail notification*****/
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Mobile Flex creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Flex Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Mobile Creative';
					$content['creative_type'] = 'Flex Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
				/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);				
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);
				}
				
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);	
				}
				
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: add_pull_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage Pull Mobile Creative adding process
	 */
	public function add_pull_creative_post()
	{
		$this->form_validation->set_rules('pull_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$this->form_validation->set_rules('nav_msg_content', 'Content Message', 'required|trim');
		$this->form_validation->set_rules('nav_video_url', 'Content video URL', 'required|trim|callback_url_check');
		#$this->form_validation->set_rules('network[]', 'Social Networking', 'required|trim|callback_url_check');
		$campaign = clean_data($this->post('_pl_campaign_id'));
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_pl_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_pl_campaign_id'));
		}	
					
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	'web';
			$master_banner 	= 	'-2';
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			
			//Get account/agency_id from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_pl_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_pl_account_id')));
			}
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			//checking creative is ad market or not -start DAC094
			$is_admarket	= 	clean_data($this->post('_admarket_id'));
			if($is_admarket)
			{
			$ad_market = 1;
			}
			else
			{
			$ad_market = 0;
			}	
			// stop 
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
						if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
						$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
				// Set width and height of the creative
				$creative_width='320';
				$creative_height='50';
				$network					= 	clean_data($this->post('network'));
				$networking_values			= 	($network)?implode(',' , $network):'';
				
				$creative_data = array(
										"contenttype"		=>	clean_data($this->post('tmp_base_portrait_creative_content_type')),
										"campaignid"		=>	clean_data($campaign_id),
										"storagetype"		=>	clean_data($storage_type),
										"description"		=>	clean_data($this->post('pull_creative_name')),
										"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
										"dj_admin_approve"	=>	clean_data($dj_admin_approve),
										"dj_approved_date"	=>	clean_data($dj_approved_date),					
										"dj_banner_type"	=>	MOBILE_RS_CREATIVE_PULL,
										"dj_master_banner"	=>	clean_data($master_banner),
										"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
										"dj_account_id" 	=> 	clean_data($dj_account_id),
										"dj_is_direct" 		=> 	clean_data($dj_is_direct),
										"dj_image_path"		=>  $dj_image_path,
										'dj_admarket_status'=>	clean_data($ad_market)
									);
				
				
				//Call to add a creative
				$banner_id = $this->do_mobile_creative->add($creative_data,$agency_id);
				
				// Insert base creative 
				
				$base_creative_data = array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_base_portrait_creative')),
											"width"			=>	clean_data($creative_width),
											"height"		=>	clean_data($creative_height),
											"content_type"	=>	clean_data($this->post('tmp_base_portrait_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BASE,
											"position" 		=> 	MOBILE_CREATIVE_PORTRAIT,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_portrait_creative')));
				$this->do_mobile_creative->add_child($base_creative_data);
				
				//BASE ADS
				$size_base_w='480';
				$size_base_h='50';
				$base_landscape_data = array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_base_landscape_creative')),
											"width"			=>	clean_data($size_base_w),
											"height"		=>	clean_data($size_base_h),
											"content_type"	=>	clean_data($this->post('tmp_base_landscape_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BASE,
											"position" 		=> 	MOBILE_CREATIVE_LANDSCAPE,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_landscape_creative')));
				$this->do_mobile_creative->add_child($base_landscape_data);
				
				//BASE ADS
				$size_base_tablet1_w='768';
				$size_base_tablet1_h='90';
				$base_tablet1_data = array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_base_tablet1_creative')),
											"width"			=>	clean_data($size_base_tablet1_w),
											"height"		=>	clean_data($size_base_tablet1_h),
											"content_type"	=>	clean_data($this->post('tmp_base_tablet1_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BASE,
											"position" 		=> 	MOBILE_CREATIVE_TABLET_PORTRAIT,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_tablet1_creative')));
				$this->do_mobile_creative->add_child($base_tablet1_data);
				
			  // Insert base creative 
			  $size_base_tablet2_w='1024';
			  $size_base_tablet2_h='90';
			  $base_tablet2_data = array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_base_tablet2_creative')),
											"width"			=>	clean_data($size_base_tablet2_w),
											"height"		=>	clean_data($size_base_tablet2_h),
											"content_type"	=>	clean_data($this->post('tmp_base_tablet2_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BASE,
											"position" 		=> 	MOBILE_CREATIVE_TABLET_LANDSCAPE,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_tablet2_creative')));
				$this->do_mobile_creative->add_child($base_tablet2_data);
				
				#######################################################
						##### HORIZONTAL CREATIVES #######
				#####################################################
				$bg_creative_width = '1280';
				$bg_creative_height='1280';
				$bg_creative_data1 = array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_horizantal_ad1_creative')),
											"width"			=>	clean_data($bg_creative_width),
											"height"		=>	clean_data($bg_creative_height),
											"content_type"	=>	clean_data($this->post('tmp_horizantal_ad1_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"display_size" 	=> 	X_LARGE,
											"position" 		=> 	MOBILE_CREATIVE_HORIZONTAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				//On sucess move the expand creative from tmp location to original location
				$is_bg_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad1_creative')));
				//Call to add a creative
				$this->do_mobile_creative->add_child($bg_creative_data1);
				
				$bg_creative_width = '1024';
				$bg_creative_height='1024';
				$bg_creative_data2 = array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_horizantal_ad2_creative')),
											"width"			=>	clean_data($bg_creative_width),
											"height"		=>	clean_data($bg_creative_height),
											"display_size" 	=>	LARGE,
											"content_type"	=>	clean_data($this->post('tmp_horizantal_ad2_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"position" 		=> 	MOBILE_CREATIVE_HORIZONTAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				//On sucess move the expand creative from tmp location to original location
				$is_bg_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad2_creative')));
				//Call to add a creative
				$this->do_mobile_creative->add_child($bg_creative_data2);
				
				$bg_creative_width = '800';
				$bg_creative_height='800';
				$bg_creative_data3 = array(
											"banner_id" => $banner_id,
											"file_path"=>clean_data($this->post('tmp_horizantal_ad3_creative')),
											"width"=>clean_data($bg_creative_width),
											"height"=>clean_data($bg_creative_height),
											"content_type"=>clean_data($this->post('tmp_horizantal_ad3_creative_content_type')),
											"display_type" => MOBILE_CREATIVE_BACKGROUND,
											"display_size" => MEDIUM,
											"position" => MOBILE_CREATIVE_HORIZONTAL,
											"created_date"=>clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				//On sucess move the expand creative from tmp location to original location
				$is_bg_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad3_creative')));
				//Call to add a creative
				$this->do_mobile_creative->add_child($bg_creative_data3);
				
				$bg_creative_width = '480';
				$bg_creative_height='480';
				$bg_creative_data4 = array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_horizantal_ad4_creative')),
											"width"			=>	clean_data($bg_creative_width),
											"height"		=>	clean_data($bg_creative_height),
											"content_type"	=>	clean_data($this->post('tmp_horizantal_ad4_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"position" 		=> 	MOBILE_CREATIVE_HORIZONTAL,
											"display_size" 	=> 	SMALL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				//On sucess move the expand creative from tmp location to original location
				$is_bg_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad4_creative')));
				//Call to add a creative
				$this->do_mobile_creative->add_child($bg_creative_data4);
				
				#######################################################
						##### VERTICAL CREATIVES #######
				#####################################################
				$bg_creative_width = '1280';
				$bg_creative_height='1280';
				$bg_creative_data1 = array(
											"banner_id" => $banner_id,
											"file_path"=>clean_data($this->post('tmp_vertical_ad1_creative')),
											"width"=>clean_data($bg_creative_width),
											"height"=>clean_data($bg_creative_height),
											"content_type"=>clean_data($this->post('tmp_vertical_ad1_creative_content_type')),
											"display_type" => MOBILE_CREATIVE_BACKGROUND,
											"position" => MOBILE_CREATIVE_VERTICAL,
											"display_size" => X_LARGE,
											"created_date"=>clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				//On sucess move the expand creative from tmp location to original location
				$is_bg_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad1_creative')));
				//Call to add a creative
				$this->do_mobile_creative->add_child($bg_creative_data1);
				
				$bg_creative_width = '1024';
				$bg_creative_height='1024';
				$bg_creative_data2 = array(
											"banner_id" => $banner_id,
											"file_path"=>clean_data($this->post('tmp_vertical_ad2_creative')),
											"width"=>clean_data($bg_creative_width),
											"height"=>clean_data($bg_creative_height),
											"content_type"=>clean_data($this->post('tmp_vertical_ad2_creative_content_type')),
											"display_type" => MOBILE_CREATIVE_BACKGROUND,
											"display_size" => LARGE,
											"position" => MOBILE_CREATIVE_VERTICAL,
											"created_date"=>clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				//On sucess move the expand creative from tmp location to original location
				$is_bg_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad2_creative')));
				//Call to add a creative
				$this->do_mobile_creative->add_child($bg_creative_data2);
				
				$bg_creative_width = '800';
				$bg_creative_height='800';
				$bg_creative_data3 = array(
											"banner_id" => $banner_id,
											"file_path"=>clean_data($this->post('tmp_vertical_ad3_creative')),
											"width"=>clean_data($bg_creative_width),
											"height"=>clean_data($bg_creative_height),
											"content_type"=>clean_data($this->post('tmp_vertical_ad3_creative_content_type')),
											"display_type" => MOBILE_CREATIVE_BACKGROUND,
											"position" => MOBILE_CREATIVE_VERTICAL,
											"display_size" => MEDIUM,
											"created_date"=>clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				//On sucess move the expand creative from tmp location to original location
				$is_bg_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad3_creative')));
				//Call to add a creative
				$this->do_mobile_creative->add_child($bg_creative_data3);
				
				$bg_creative_width = '480';
				$bg_creative_height='480';
				$bg_creative_data4 = array(
											"banner_id" => $banner_id,
											"file_path"=>clean_data($this->post('tmp_vertical_ad4_creative')),
											"width"=>clean_data($bg_creative_width),
											"height"=>clean_data($bg_creative_height),
											"content_type"=>clean_data($this->post('tmp_vertical_ad4_creative_content_type')),
											"display_type" => MOBILE_CREATIVE_BACKGROUND,
											"display_size" => SMALL,
											"position" => MOBILE_CREATIVE_VERTICAL,
											"created_date"=>clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				//On sucess move the expand creative from tmp location to original location
				$is_bg_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad4_creative')));
				//Call to add a creative
				$this->do_mobile_creative->add_child($bg_creative_data4);
				
				#######################################################
						##### NAVICON ICONS #######
				#####################################################
				$nav_icon_width  = '80';
				$nav_icon_height  = '75';
				
				# FOR CREATING THUMBNAIL
				if($this->commandExists("ffmpeg")>0) 
				{
					$http_url = clean_data($this->post('nav_video_url'));
					$time =  shell_exec("ffmpeg -i $http_url 2>&1 | grep 'Duration' | cut -d ' ' -f 4 | sed s/,//");
					$duration = explode(":",$time);
					$duration_in_seconds = $duration[0]*3600 + $duration[1]*60+ round($duration[2]);
					$duration_in_seconds=round($duration_in_seconds); 
					
					$time_for_thumb_one=$duration_in_seconds/2; 
					
					##CREATE THUMBNAILS
					$tmp_file_name = md5(uniqid($http_url, true)).'.jpg';
					$upload_path =  $this->config->item('creative_video_thumb_path');
					
					$thumb_command1 = "ffmpeg  -itsoffset -$time_for_thumb_one  -i $http_url -vcodec mjpeg -vframes 1 -an -f rawvideo -s 150x150 ".$upload_path."/".$tmp_file_name;
					shell_exec( $thumb_command1 );
				}
				else
				{
					$tmp_file_name	=	'';
				}	
				//INSERT VIDEO NAVICON ICON
				$nav_video_creative_data = array(
												"banner_id" => $banner_id,
												"file_path"=>clean_data($this->post('tmp_navicon_video_creative')),
												"width"=>clean_data($nav_icon_width),
												"height"=>clean_data($nav_icon_height),
												"content_type"=>clean_data($this->post('tmp_navicon_video_creative_content_type')),
												"display_type" => MOBILE_CREATIVE_NAVIGATION,
												"icon_type" => MOBILE_CREATIVE_NAVIGATION_VIDEO,
												"dj_content_video_url" => clean_data($this->post('nav_video_url')),
												"dj_video_thumb_img" =>$tmp_file_name,
												"created_date"=>clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
				
				//On sucess move the expand creative from tmp location to original location
				$is_nav_video_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_navicon_video_creative')));
				//Call to add a creative
				$this->do_mobile_creative->add_child($nav_video_creative_data);
				
				//INSERT MESSAGE NAVICON ICON
				$nav_msg_creative_data = array(
												"banner_id" => $banner_id,
												"file_path"=>clean_data($this->post('tmp_navicon_msg_creative')),
												"width"=>clean_data($nav_icon_width),
												"height"=>clean_data($nav_icon_height),
												"content_type"=>clean_data($this->post('tmp_navicon_msg_creative_content_type')),
												"display_type" =>MOBILE_CREATIVE_NAVIGATION,
												"icon_type" => MOBILE_CREATIVE_NAVIGATION_MESSAGE,
												"dj_content_ad_message" => clean_data($this->post('nav_msg_content')),
												"created_date"=>clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
				//On sucess move the expand creative from tmp location to original location
				$is_nav_msg_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_navicon_msg_creative')));
				//Call to add a creative
				$this->do_mobile_creative->add_child($nav_msg_creative_data);
				
				//INSERT MESSAGE NAVICON ICON
				$nav_icon_creative_data = array(
												"banner_id" => $banner_id,
												"file_path"=>clean_data($this->post('tmp_navicon_content_creative')),
												"width"=>clean_data($nav_icon_width),
												"height"=>clean_data($nav_icon_height),
												"content_type"=>clean_data($this->post('tmp_navicon_content_creative_content_type')),
												"display_type" => MOBILE_CREATIVE_NAVIGATION,
												"icon_type" => MOBILE_CREATIVE_NAVIGATION_ICON,
												"created_date"=>clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
				//On sucess move the expand creative from tmp location to original location
				$is_nav_icon_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_navicon_content_creative')));
				//Call to add a creative
				$this->do_mobile_creative->add_child($nav_icon_creative_data);
				
				//INSERT SOCIAL NAVICON ICON				
				$nav_social_creative_data = array(
												"banner_id" => $banner_id,
												"file_path"=>clean_data($this->post('tmp_navicon_social_creative')),
												"width"=>clean_data($nav_icon_width),
												"height"=>clean_data($nav_icon_height),
												"content_type"=>clean_data($this->post('tmp_navicon_social_creative_content_type')),
												"display_type" => MOBILE_CREATIVE_NAVIGATION,
												"icon_type" => MOBILE_CREATIVE_NAVIGATION_SOCIAL,
												"dj_social_networking" => $networking_values,
												"created_date"=>clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
				//On sucess move the expand creative from tmp location to original location
				$is_nav_social_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_navicon_social_creative')));
				//Call to add a creative
				$this->do_mobile_creative->add_child($nav_social_creative_data);
				
				#######################################################
						##### CONTENT CREATIVES #######
				#####################################################
				$content_ad1_creative_data = array(
													"banner_id" => $banner_id,
													"file_path"=>clean_data($this->post('tmp_content_ad1_creative')),
													"width"=>clean_data('290'),
													"height"=>clean_data('205'),
													"content_type"=>clean_data($this->post('tmp_content_ad1_creative_content_type')),
													"display_type" => MOBILE_CREATIVE_CONTENT,
													"display_size" => SMALL,
													"created_date"=>clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
				//On sucess move the expand creative from tmp location to original location
				$is_content_ad1_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad1_creative')));
				//Call to add a creative
				$this->do_mobile_creative->add_child($content_ad1_creative_data);
				
				$content_ad2_creative_data = array(
													"banner_id" => $banner_id,
													"file_path"=>clean_data($this->post('tmp_content_ad2_creative')),
													"width"=>clean_data('435'),
													"height"=>clean_data('308'),
													"content_type"=>clean_data($this->post('tmp_content_ad2_creative_content_type')),
													"display_type" => MOBILE_CREATIVE_CONTENT,
													"display_size" => MEDIUM,
													"created_date"=>clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
				
				//On sucess move the expand creative from tmp location to original location
				$is_content_ad2_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad2_creative')));
				
				//Call to add a creative
				$this->do_mobile_creative->add_child($content_ad2_creative_data);
				
				// CONTENT CREATIVE - 3
				$content_ad3_creative_data = array(
													"banner_id" => $banner_id,
													"file_path"=>clean_data($this->post('tmp_content_ad3_creative')),
													"width"=>clean_data('544'),
													"height"=>clean_data('385'),
													"content_type"=>clean_data($this->post('tmp_content_ad3_creative_content_type')),
													"display_type" => MOBILE_CREATIVE_CONTENT,
													"display_size" => LARGE,
													"created_date"=>clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
				//On sucess move the expand creative from tmp location to original location
				$is_content_ad3_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad3_creative')));
				//Call to add a creative
				$this->do_mobile_creative->add_child($content_ad3_creative_data);
				
				//CONTENT CREATIVE-4
				$content_ad4_creative_data = array(
													"banner_id" => $banner_id,
													"file_path"=>clean_data($this->post('tmp_content_ad4_creative')),
													"width"=>clean_data('696'),
													"height"=>clean_data('492'),
													"content_type"=>clean_data($this->post('tmp_content_ad4_creative_content_type')),
													"display_type" => MOBILE_CREATIVE_CONTENT,
													"display_size" => X_LARGE,
													"created_date"=>clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
				//On sucess move the expand creative from tmp location to original location
				$is_content_ad4_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad4_creative')));
				//Call to add a creative
				$creative_add = $this->do_mobile_creative->add_child($content_ad4_creative_data);
							
			
			if($creative_add)
			{
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$banner_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
					/***creative change for message/mail notification*****/
				$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
				$content['sub'] ='Pull creative added';
				$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Pull Creative';
				$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
				$content['creative_name'] = $creative_data['description'];
				$content['creative_ml']	  = 'Mobile Creative';
				$content['creative_type'] = 'Pull Creative';
				$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
				/***creative change for message/mail notification*****/	
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	site_url('advertiser/creatives/'),
									);						
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									'redirect'	 	=> 	site_url('admin/creatives/'),
									/*'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
									);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								/*'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}
				
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: edit_pull_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this methosd we will manage pull creative edit process
	 * 
	 */
	
	public function edit_pull_creative_post()
	{
		$this->form_validation->set_rules('pull_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		#$this->form_validation->set_rules('network[]', 'Social Networking', 'required|trim|callback_url_check');
		 
		#BASE CREATVES
		$tmp_base_portrait_creative=clean_data($this->post('tmp_base_portrait_creative'));
		if (empty($tmp_base_portrait_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('base_portrait', 'Creative', 'required');
		}
		$tmp_base_landscape_creative=clean_data($this->post('tmp_base_landscape_creative'));
		if (empty($tmp_base_landscape_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('base_landscape', 'Creative', 'required');
		}
		$tmp_base_tablet1_creative=clean_data($this->post('tmp_base_tablet1_creative'));
		if (empty($tmp_base_tablet1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('base_tablet1', 'Creative', 'required');
		}
		$tmp_base_tablet2_creative=clean_data($this->post('tmp_base_tablet2_creative'));
		if (empty($tmp_base_tablet2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('base_tablet2', 'Creative', 'required');
		}
		#HORIZANTAL CREATIVES
		$tmp_horizantal_ad1_creative=clean_data($this->post('tmp_horizantal_ad1_creative'));
		if (empty($tmp_horizantal_ad1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('horizantal_ad1', 'Creative', 'required');
		}
		$tmp_horizantal_ad2_creative=$this->post('tmp_horizantal_ad2_creative');
		if (empty($tmp_horizantal_ad2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('horizantal_ad2', 'Creative', 'required');
		}
		$tmp_horizantal_ad3_creative=clean_data($this->post('tmp_horizantal_ad3_creative'));
		if (empty($tmp_horizantal_ad3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('horizantal_ad3', 'Creative', 'required');
		}
		$tmp_horizantal_ad4_creative=clean_data($this->post('tmp_horizantal_ad4_creative'));
		if (empty($tmp_horizantal_ad4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('horizantal_ad4', 'Creative', 'required');
		}
		#VERTICAL CREATIVES 
		$tmp_vertical_ad1_creative=clean_data($this->post('tmp_vertical_ad1_creative'));
		if (empty($tmp_vertical_ad1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('vertical_ad1', 'Creative', 'required');
		}
		$tmp_vertical_ad2_creative=clean_data($this->post('tmp_vertical_ad2_creative'));
		if (empty($tmp_vertical_ad2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('vertical_ad2', 'Creative', 'required');
		}
		$tmp_vertical_ad3_creative=clean_data($this->post('tmp_vertical_ad3_creative'));
		if (empty($tmp_vertical_ad3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('vertical_ad3', 'Creative', 'required');
		}
		$tmp_vertical_ad4_creative=clean_data($this->post('tmp_vertical_ad4_creative'));
		if (empty($tmp_vertical_ad4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('vertical_ad4', 'Creative', 'required');
		}
		#CONTENT CREATIVES
		$tmp_content_ad1_creative=clean_data($this->post('tmp_content_ad1_creative'));
		if (empty($tmp_content_ad1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('content_ad1', 'Creative', 'required');
		}
		$tmp_content_ad2_creative=clean_data($this->post('tmp_content_ad2_creative'));
		if (empty($tmp_content_ad2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('content_ad2', 'Creative', 'required');
		}
		$tmp_content_ad3_creative=clean_data($this->post('tmp_content_ad3_creative'));
		if (empty($tmp_content_ad3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('content_ad3', 'Creative', 'required');
		}
		$tmp_content_ad4_creative=clean_data($this->post('tmp_content_ad4_creative'));
		if (empty($tmp_content_ad4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('content_ad4', 'Creative', 'required');
		}
		#NAVIGATION ICON CREATVES
		$tmp_navicon_creative=clean_data($this->post('tmp_navicon_video_creative'));
		
		if (empty($tmp_navicon_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('navicon_video', 'Creative', 'required');
		}
		
		$tmp_navicon_social_creative=clean_data($this->post('tmp_navicon_social_creative'));
		
		if (empty($tmp_navicon_social_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('navicon_social', 'Creative', 'required');
		}
		
		$tmp_navicon_content_creative=clean_data($this->post('tmp_navicon_content_creative'));
		
		if (empty($tmp_navicon_content_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('navicon_content', 'Creative', 'required');
		}
		
		$tmp_navicon_msg_creative=clean_data($this->post('tmp_navicon_msg_creative'));
		
		if (empty($tmp_navicon_msg_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('navicon_msg', 'Creative', 'required');
		}
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$creative_id=clean_data($this->post('pull_creative_id'));
			$network				= 	clean_data($this->post('network'));
			$networking_values		= 	($network)?implode(',' , $network):'';
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";			
			$creative_data = array(
				"contenttype"=>clean_data($this->post('tmp_base_portrait_creative_content_type')),
				"description"=>clean_data($this->post('pull_creative_name')),
				"url"=>clean_data($this->url_creation($this->post('destination_url'))),
				"updated"=>clean_data(date('Y:m:d :H:i:s')),
			);
			
			//Get account from library file
			$agency_id=$this->user_authentication->agency_id;
			
			//Call to edit a creative
			 $creative_edit=$this->do_mobile_creative->edit_mobile($creative_data,$creative_id,$agency_id);
			 // Edit for base creative
			 if($creative_edit)
			 {
				if(clean_data($this->post('old_base_portrait_creative'))!=clean_data($this->post('tmp_base_portrait_creative'))) 
				{
					$base_creative_data = array(
									"file_path"=>clean_data($this->post('tmp_base_portrait_creative')),
									"content_type"=>clean_data($this->post('tmp_base_portrait_creative_content_type')),
									"updated"=>clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
					 $where_base = array(
										'banner_id'=>$creative_id,
										'display_type'=>MOBILE_CREATIVE_BASE,
										'position'=>MOBILE_CREATIVE_PORTRAIT
								);
						
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($base_creative_data,$where_base);
					 
					 $old_pull_base_portrait_creative_path = clean_data($this->post('old_pull_base_portrait_creative_path'));
					 //On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_portrait_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_base_portrait_creative')),$old_pull_base_portrait_creative_path);
				 }
				// Edit for Background Creative
				if(clean_data($this->post('old_base_landscape_creative'))!=clean_data($this->post('tmp_base_landscape_creative'))) 
				{
					$bgi_creative_data = array(
									"file_path"=>clean_data($this->post('tmp_base_landscape_creative')),
									"content_type"=>clean_data($this->post('tmp_base_landscape_creative_content_type')),
									"updated"=>clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
					 $where_bgi = array(
										'banner_id'=>$creative_id,
										'display_type'=>MOBILE_CREATIVE_BACKGROUND,
										'position'=>MOBILE_CREATIVE_LANDSCAPE
								);
						
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($bgi_creative_data,$where_bgi);
					 
					 $old_pull_base_land_creative_path = clean_data($this->post('old_pull_base_land_creative_path'));
					 //On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_landscape_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_base_landscape_creative')),$old_pull_base_land_creative_path);
				}
				
				// Edit for Navi video creative
				if(clean_data($this->post('nav_video_url'))!=clean_data($this->post('exit_url')))
				{
					# FOR CREATING THUMBNAIL
					if($this->commandExists("ffmpeg")>0) 
					{
						$http_url = clean_data($this->post('nav_video_url'));
						$time =  shell_exec("ffmpeg -i $http_url 2>&1 | grep 'Duration' | cut -d ' ' -f 4 | sed s/,//");
						$duration = explode(":",$time);
						$duration_in_seconds = $duration[0]*3600 + $duration[1]*60+ round($duration[2]);
						$duration_in_seconds=round($duration_in_seconds); 
						
						$time_for_thumb_one=$duration_in_seconds/2; 
						
						##CREATE THUMBNAILS
						$tmp_file_name = md5(uniqid($http_url, true)).'.jpg';
						$upload_path =  $this->config->item('creative_video_thumb_path');
						
						$thumb_command1 = "ffmpeg  -itsoffset -$time_for_thumb_one  -i $http_url -vcodec mjpeg -vframes 1 -an -f rawvideo -s 150x150 ".$upload_path."/".$tmp_file_name;
						shell_exec( $thumb_command1 );	
						$file_name = $tmp_file_name;
					}
					else
					{
						$file_name	=	'';
					}
				}
				else
				{
					$file_name = clean_data($this->post('exit_img'));
				}
				if(clean_data($this->post('old_navicon_video_creative'))!=clean_data($this->post('tmp_navicon_video_creative'))) 
				{
					$nav_video_creative_data = array(
									"file_path"=>clean_data($this->post('tmp_navicon_video_creative')),
									"content_type"=>clean_data($this->post('tmp_navicon_video_creative_content_type')),
									'dj_content_video_url' => clean_data($this->post('nav_video_url')),
									"dj_video_thumb_img" =>$file_name,
									"updated"=>clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
					$where_nav_video = array(
										'banner_id'=>$creative_id,
										'icon_type'=>MOBILE_CREATIVE_NAVIGATION_VIDEO
								);
						
					
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($nav_video_creative_data,$where_nav_video);
					 
					 $old_pull_navicon_video_creative_path = clean_data($this->post('old_pull_navicon_video_creative_path'));
					 //On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_navicon_video_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_navicon_video_creative')),$old_pull_navicon_video_creative_path);
				}
				else
				{
					$nav_video_creative_data = array(
									'dj_content_video_url' => clean_data($this->post('nav_video_url')),
									"updated"=>clean_data(date('Y:m:d :H:i:s'))
								);
					$where_nav_video = array(
										'banner_id'=>$creative_id,
										'icon_type'=>MOBILE_CREATIVE_NAVIGATION_VIDEO
								);
						
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($nav_video_creative_data,$where_nav_video);
				}
				
				// Edit for Navi Message creative
				if(clean_data($this->post('old_navicon_msg_creative'))!=clean_data($this->post('tmp_navicon_msg_creative'))) 
				{
					$nav_msg_creative_data = array(
									"file_path"=>clean_data($this->post('tmp_navicon_msg_creative')),
									"content_type"=>clean_data($this->post('tmp_navicon_msg_creative_content_type')),
									'dj_content_ad_message'=>clean_data($this->post('nav_msg_content')),
									"updated"=>clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
					$where_nav_msg = array(
										'banner_id'=>$creative_id,
										'icon_type'=>MOBILE_CREATIVE_NAVIGATION_MESSAGE
								);
						
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($nav_msg_creative_data,$where_nav_msg);
					 
					 $old_pull_navicon_msg_creative_path = clean_data($this->post('old_pull_navicon_msg_creative_path'));
					 //On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_navicon_msg_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_navicon_msg_creative')),$old_pull_navicon_msg_creative_path);
				}
				else
				{
					$nav_msg_creative_data = array(
									'dj_content_ad_message'=>clean_data($this->post('nav_msg_content')),
									"updated"=>clean_data(date('Y:m:d :H:i:s'))
								);
					$where_nav_msg = array(
										'banner_id'=>$creative_id,
										'icon_type'=>MOBILE_CREATIVE_NAVIGATION_MESSAGE
								);
						
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($nav_msg_creative_data,$where_nav_msg);
				}
				
				// Edit for Navi Icon creative
				if(clean_data($this->post('old_navicon_content_creative'))!=clean_data($this->post('tmp_navicon_content_creative'))) 
				{
					$nav_icon_creative_data = array(
									"file_path"=>clean_data($this->post('tmp_navicon_content_creative')),
									"content_type"=>clean_data($this->post('tmp_navicon_content_creative_content_type')),
									"updated"=>clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
					$where_nav_icon = array(
										'banner_id'=>$creative_id,
										'icon_type' => MOBILE_CREATIVE_NAVIGATION_ICON,
								);
						
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($nav_icon_creative_data,$where_nav_icon);
					 
					 $old_pull_navicon_content_creative_path = clean_data($this->post('old_pull_navicon_content_creative_path'));
					 //On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_navicon_content_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_navicon_content_creative')),$old_pull_navicon_content_creative_path);
				}
				
				// Edit for Navi social creative
				if(clean_data($this->post('old_navicon_social_creative'))!=clean_data($this->post('tmp_navicon_social_creative'))) 
				{
					$nav_soc_creative_data = array(
									"file_path"=>clean_data($this->post('tmp_navicon_social_creative')),
									"content_type"=>clean_data($this->post('tmp_navicon_social_creative_content_type')),
									'dj_social_networking' => $networking_values,
									"updated"=>clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
					$where_soc_icon = array(
										'banner_id'=>$creative_id,
										'icon_type'=>MOBILE_CREATIVE_NAVIGATION_SOCIAL
								);
						
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($nav_soc_creative_data,$where_soc_icon);
					 
					 $old_pull_navicon_social_creative_path = clean_data($this->post('old_pull_navicon_social_creative_path'));
					 //On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_navicon_social_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_navicon_social_creative')),$old_pull_navicon_social_creative_path);
				}
				else
				{
					$nav_soc_creative_data = array(
									'dj_social_networking' => $networking_values,
									"updated"=>clean_data(date('Y:m:d :H:i:s'))
								);
					$where_soc_icon = array(
										'banner_id'=>$creative_id,
										'icon_type'=>MOBILE_CREATIVE_NAVIGATION_SOCIAL
								);
						
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($nav_soc_creative_data,$where_soc_icon);
				}
				
				// Edit for Content Ad1 creative
				if(clean_data($this->post('old_content_ad1_creative'))!=clean_data($this->post('tmp_content_ad1_creative'))) 
				{
					$contad1_creative_data = array(
									"file_path"=>clean_data($this->post('tmp_content_ad1_creative')),
									"content_type"=>clean_data($this->post('tmp_content_ad1_creative_content_type')),
									"updated"=>clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
					$where_contad1 = array(
										'banner_id'=>$creative_id,
										'display_type'=>MOBILE_CREATIVE_CONTENT,
										'display_size'=>SMALL
								);
								
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($contad1_creative_data,$where_contad1);
					 
					 $old_pull_content_ad1_creative_path = clean_data($this->post('old_pull_content_ad1_creative_path'));
					 //On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad1_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_content_ad1_creative')),$old_pull_content_ad1_creative_path);
				}
				
				// Edit for Content Ad2 creative
				if(clean_data($this->post('old_content_ad2_creative'))!=clean_data($this->post('tmp_content_ad2_creative'))) 
				{
					$contad2_creative_data = array(
									"file_path"=>clean_data($this->post('tmp_content_ad2_creative')),
									"content_type"=>clean_data($this->post('tmp_content_ad2_creative_content_type')),
									"updated"=>clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
					$where_contad2 = array(
										'banner_id'=>$creative_id,
										'display_type'=>MOBILE_CREATIVE_CONTENT,
										'display_size'=>LARGE
								);
						
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($contad2_creative_data,$where_contad2);
					 
					 $old_pull_content_ad2_creative_path = clean_data($this->post('old_pull_content_ad2_creative_path'));
					 //On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad2_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_content_ad2_creative')),$old_pull_content_ad2_creative_path);
				}
				
				// Edit for Content Ad3 creative
				if(clean_data($this->post('old_content_ad3_creative'))!=clean_data($this->post('tmp_content_ad3_creative')))
				{
					$contad3_creative_data = array(
									"file_path"=>clean_data($this->post('tmp_content_ad3_creative')),
									"content_type"=>clean_data($this->post('tmp_content_ad3_creative_content_type')),
									"updated"=>clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
					$where_contad3 = array(
										'banner_id'=>$creative_id,
										'display_type'=>MOBILE_CREATIVE_CONTENT,
										'display_size'=>MEDIUM
								);
						
					//Call to edit a creative
	
					 $this->do_mobile_creative->edit_child_mobile($contad3_creative_data,$where_contad3);
					 
					 $old_pull_content_ad3_creative_path =clean_data($this->post('old_pull_content_ad3_creative_path'));
					 //On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad3_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_content_ad3_creative')),$old_pull_content_ad3_creative_path);
				}
				
				// Edit for Content Ad4 creative
				if(clean_data($this->post('old_content_ad4_creative'))!=clean_data($this->post('tmp_content_ad4_creative'))) 
				{
					$contad4_creative_data = array(
									"file_path"=>clean_data($this->post('tmp_content_ad4_creative')),
									"content_type"=>clean_data($this->post('tmp_content_ad4_creative_content_type')),
									"updated"=>clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
					$where_contad4 = array(
										'banner_id'=>$creative_id,
										'display_type'=>MOBILE_CREATIVE_CONTENT,
										'display_size'=>X_LARGE
								);
						
					//Call to edit a creative
					 $this->do_mobile_creative->edit_child_mobile($contad4_creative_data,$where_contad4);
					 
					 $old_pull_content_ad4_creative_path = clean_data($this->post('old_pull_content_ad4_creative_path'));
					 //On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad4_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_content_ad4_creative')),$old_pull_content_ad4_creative_path);
				}
				if(clean_data($this->post('old_base_tablet1_creative')) != clean_data($this->post('tmp_base_tablet1_creative')))
				{
					// Base creative protrait
					$base_creative_tablet1 = array(
							"file_path"=>clean_data($this->post('tmp_base_tablet1_creative')),
							"content_type"=>clean_data($this->post('tmp_base_tablet1_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BASE,'position'=>MOBILE_CREATIVE_TABLET_PORTRAIT);	
					
					$base_creative_edit = $this->do_mobile_creative->edit_child_mobile($base_creative_tablet1,$where);

					$old_pull_base_tablet1_creative_path = clean_data($this->post('old_pull_base_tablet1_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_tablet1_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_base_tablet1')),$old_pull_base_tablet1_creative_path);
				}
				if(clean_data($this->post('old_base_tablet2_creative')) != clean_data($this->post('tmp_base_tablet2_creative')))
				{
					// Base creative protrait
					$base_creative_tablet2 = array(
							"file_path"=>clean_data($this->post('tmp_base_tablet2_creative')),
							"content_type"=>clean_data($this->post('tmp_base_tablet2_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
						
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BASE,'position'=>MOBILE_CREATIVE_TABLET_LANDSCAPE);	
					
					$base_creative_edit = $this->do_mobile_creative->edit_child_mobile($base_creative_tablet2,$where);

					$old_pull_base_tablet2_creative_path = clean_data($this->post('old_pull_base_tablet2_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_tablet2_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_base_tablet2')),$old_pull_base_tablet2_creative_path);
				}
				 #Horizantal creatives
				if(clean_data($this->post('old_horizantal_ad1_creative')) != clean_data($this->post('tmp_horizantal_ad1_creative')))
				{
					$horizantal_creative_one = array(
					"file_path"=>clean_data($this->post('tmp_horizantal_ad1_creative')),
					"content_type"=>clean_data($this->post('tmp_horizantal_ad1_creative_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
					);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_HORIZONTAL,	'display_size'=>X_LARGE);
					$this->do_mobile_creative->edit_child_mobile($horizantal_creative_one,$where);
					
					$old_pull_horizantal_ad1_creative_path = clean_data($this->post('old_pull_horizantal_ad1_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad1_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_horizantal_ad1_creative')),$old_pull_horizantal_ad1_creative_path);
				}
				
				if(clean_data($this->post('old_horizantal_ad2_creative')) != clean_data($this->post('tmp_horizantal_ad2_creative')))
				{
					
					$horizantal_creative_two = array(
							"file_path"=>clean_data($this->post('tmp_horizantal_ad2_creative')),
							"content_type"=>clean_data($this->post('tmp_horizantal_ad2_creative_content_type')),
							"updated"=>clean_data(date('Y:m:d :H:i:s')),
							"dj_image_path"		=>  $dj_image_path
						);
					
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_HORIZONTAL,'display_size'=>LARGE);
					$this->do_mobile_creative->edit_child_mobile($horizantal_creative_two,$where);

					$old_pull_horizantal_ad2_creative_path = clean_data($this->post('old_pull_horizantal_ad2_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad2_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_horizantal_ad2_creative')),$old_pull_horizantal_ad2_creative_path);
				}
				
				if(clean_data($this->post('old_horizantal_ad3_creative')) != clean_data($this->post('tmp_horizantal_ad3_creative')))
				{
					$horizantal_creative_three = array(
					"file_path"=>clean_data($this->post('tmp_horizantal_ad3_creative')),
					"content_type"=>clean_data($this->post('tmp_horizantal_ad3_creative_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_HORIZONTAL,'display_size'=>MEDIUM);	
					$this->do_mobile_creative->edit_child_mobile($horizantal_creative_three,$where);
					
					$old_pull_horizantal_ad3_creative_path = clean_data($this->post('old_pull_horizantal_ad3_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad3_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_horizantal_ad3_creative')),$old_pull_horizantal_ad3_creative_path);
				}
				
				if(clean_data($this->post('old_horizantal_ad4_creative')) != clean_data($this->post('tmp_horizantal_ad4_creative')))
				{
					$horizantal_creative_four = array(
					"file_path"=>clean_data($this->post('tmp_horizantal_ad4_creative')),
					"content_type"=>clean_data($this->post('tmp_horizantal_ad4_creative_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
					);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_HORIZONTAL,'display_size'=>SMALL);
				
					$this->do_mobile_creative->edit_child_mobile($horizantal_creative_four,$where);
					
					$old_pull_horizantal_ad4_creative_path = clean_data($this->post('old_pull_horizantal_ad4_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad4_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_horizantal_ad4_creative')),$old_pull_horizantal_ad4_creative_path);
				}
				 #Vertical creatives
				if(clean_data($this->post('old_vertical_ad1_creative')) != clean_data($this->post('tmp_vertical_ad1_creative')))
				{
					$vertical_creative_one = array(
					"file_path"=>clean_data($this->post('tmp_vertical_ad1_creative')),
					"content_type"=>clean_data($this->post('tmp_vertical_ad1_creative_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
					
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_VERTICAL,'display_size'=>X_LARGE);
					$this->do_mobile_creative->edit_child_mobile($vertical_creative_one,$where);
					
					$old_pull_vertical_ad1_creative_path = $this->post('old_pull_vertical_ad1_creative_path');
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad1_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_vertical_ad1_creative')),$old_pull_vertical_ad1_creative_path);
				}
				if(clean_data($this->post('old_vertical_ad2_creative')) != clean_data($this->post('tmp_vertical_ad2_creative')))
				{
					$vertical_creative_two = array(
					"file_path"=>clean_data($this->post('tmp_vertical_ad2_creative')),
					"content_type"=>clean_data($this->post('tmp_vertical_ad2_creative_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
			       # print_r($vertical_creative_two);exit;
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_VERTICAL,'display_size'=>LARGE);
					$this->do_mobile_creative->edit_child_mobile($vertical_creative_two,$where);
					
					$old_pull_vertical_ad2_creative_path = clean_data($this->post('old_pull_vertical_ad2_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad2_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_vertical_ad2_creative')),$old_pull_vertical_ad2_creative_path);
				}
				if(clean_data($this->post('old_vertical_ad3_creative')) != clean_data($this->post('tmp_vertical_ad3_creative')))
				{
					$vertical_creative_three = array(
					"file_path"=>clean_data($this->post('tmp_vertical_ad3_creative')),
					"content_type"=>clean_data($this->post('tmp_vertical_ad3_creative_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
					);
			
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_VERTICAL,'display_size'=>MEDIUM);	
					$this->do_mobile_creative->edit_child_mobile($vertical_creative_three,$where);
					
					$old_pull_vertical_ad3_creative_path = clean_data($this->post('old_pull_vertical_ad3_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad3_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_vertical_ad3_creative')),$old_pull_vertical_ad3_creative_path);
				}
				if(clean_data($this->post('old_vertical_ad4_creative')) != clean_data($this->post('tmp_vertical_ad4_creative')))
				{
					$vertical_creative_four = array(
					"file_path"=>clean_data($this->post('tmp_vertical_ad4_creative')),
					"content_type"=>clean_data($this->post('tmp_vertical_ad4_content_type')),
					"updated"=>clean_data(date('Y:m:d :H:i:s')),
					"dj_image_path"		=>  $dj_image_path
						);
					
					$where = array('banner_id'=>$creative_id,'display_type'=>MOBILE_CREATIVE_BACKGROUND,'position'=>MOBILE_CREATIVE_VERTICAL,'display_size'=>SMALL);
					
					$this->do_mobile_creative->edit_child_mobile($vertical_creative_four,$where);
					
					$old_pull_vertical_ad4_creative_path = clean_data($this->post('old_pull_vertical_ad4_creative_path'));
					//On sucess move the web creative from tmp location to original location
					$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad4_creative')));
					//Delete old creative
					$is_old_creative_deleted=$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_vertical_ad4_creative')),$old_pull_vertical_ad4_creative_path);
				}

			}
			if($creative_edit)
			{
				
				/***creative edit for message/mail notification*****/
				$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
				$campaign_id = $creative_dat[0]['campaignid'];
				//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
				$content['sub'] ='Mobile Pull creative edited';
				$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Pull Creative';
				$content['content'] ='Congrats!The creative has been edited successfully.';
				$content['creative_name'] = $creative_data['description'];
				$content['creative_ml']	  = 'Mobile Creative';
				$content['creative_type'] = 'Pull Creative';
				$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
				/***creative edit for message/mail notification*****/	
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);				
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	$redirect_url,
										);
				}
				
				$this->response( $success, 200);
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								);	
				}
				
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: add_slider_creative
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage Slider Mobile Creative adding process
	 */
	public function add_slider_creative_post()
	{
		$this->form_validation->set_rules('slider_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$campaign = clean_data($this->post('_slider_campaign_id'));
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_slider_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_slider_campaign_id'));
		}		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type					=	'web';
			$master_banner 					= 	'-2';
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			
			//Get account/agency_id from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id=$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_slider_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_slider_account_id')));
			}
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			//checking creative is ad market or not -start DAC094
			$is_admarket	= 	clean_data($this->post('_admarket_id'));
			if($is_admarket)
			{
			$ad_market = 1;
			}
			else
			{
			$ad_market = 0;
			}	
			// stop 
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}
			
								
			$creative_data 					= 	array(
													"contenttype"		=>	clean_data($this->post('tmp_base_portrait_creative_content_type')),
													"campaignid"		=>	clean_data($campaign_id),
													"storagetype"		=>	clean_data($storage_type),
													"description"		=>	clean_data($this->post('slider_creative_name')),
													"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
													"dj_admin_approve"	=>	clean_data($dj_admin_approve),
													"dj_approved_date"	=>	clean_data($dj_approved_date),
													"dj_banner_type"	=>	MOBILE_RS_CREATIVE_SLIDER,
													"dj_master_banner"	=>	clean_data($master_banner),
													"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_account_id" 	=> 	clean_data($dj_account_id),
													"dj_is_direct" 		=> 	clean_data($dj_is_direct),
													"dj_image_path"		=>  $dj_image_path,
													'dj_admarket_status'=>	clean_data($ad_market)
												);
				
			 
			//Call to add a creative
			$banner_id 						= 	$this->do_mobile_creative->add($creative_data,$agency_id);
			
			if($banner_id)
			{	
				// Insert base portrait creative 
				
				$portrait_creative_data 	= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_base_portrait_creative')),
													"width"			=>	'320',
													"height"		=>	'50',
													"content_type"	=>	clean_data($this->post('tmp_base_portrait_creative_content_type')),
													"display_type" 	=> 	MOBILE_CREATIVE_BASE,
													"position" 		=> 	MOBILE_CREATIVE_PORTRAIT,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_portrait_creative')));
				$this->do_mobile_creative->add_child($portrait_creative_data);	
				
				// Insert base landscape creative 
				
				$landscape_creative_data 	= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_base_land_creative')),
													"width"			=>	'480',
													"height"		=>	'50',
													"content_type"	=>	clean_data($this->post('tmp_base_land_creative_content_type')),
													"display_type" 	=> 	MOBILE_CREATIVE_BASE,
													"position" 		=> 	MOBILE_CREATIVE_LANDSCAPE,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_land_creative')));
				$this->do_mobile_creative->add_child($landscape_creative_data);	
								
				// Insert horizontal 1 creative 
				
				$horiz_1_creative_data 		= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_horiz_add_1_creative')),
													"width"			=>	'1280',
													"height"		=>	'1280',
													"content_type"	=>	clean_data($this->post('tmp_horiz_add_1_creative_content_type')),
													"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
													"position" 		=> 	MOBILE_CREATIVE_HORIZONTAL,
													"display_size" 	=> 	X_LARGE,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horiz_add_1_creative')));
				$this->do_mobile_creative->add_child($horiz_1_creative_data);																																																	
				
				// Insert horizontal 2 creative 
				
				$horiz_2_creative_data 		= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_horiz_add_2_creative')),
													"width"			=>	'1024',
													"height"		=>	'1024',
													"content_type"	=>	clean_data($this->post('tmp_horiz_add_2_creative_content_type')),
													"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
													"position" 		=> 	MOBILE_CREATIVE_HORIZONTAL,
													"display_size" 	=> 	LARGE,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horiz_add_2_creative')));
				$this->do_mobile_creative->add_child($horiz_2_creative_data);																																																	
				
				// Insert horizontal 3 creative 
				
				$horiz_3_creative_data 		= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_horiz_add_3_creative')),
													"width"			=>	'800',
													"height"		=>	'800',
													"content_type"	=>	clean_data($this->post('tmp_horiz_add_3_creative_content_type')),
													"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
													"position" 		=> 	MOBILE_CREATIVE_HORIZONTAL,
													"display_size" 	=> 	MEDIUM,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horiz_add_3_creative')));
				$this->do_mobile_creative->add_child($horiz_3_creative_data);																																																	
				
				// Insert horizontal 4 creative 
				
				$horiz_4_creative_data 		= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_horiz_add_4_creative')),
													"width"			=>	'480',
													"height"		=>	'480',
													"content_type"	=>	clean_data($this->post('tmp_horiz_add_4_creative_content_type')),
													"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
													"position" 		=> 	MOBILE_CREATIVE_HORIZONTAL,
													"display_size" 	=> 	SMALL,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horiz_add_4_creative')));
				$this->do_mobile_creative->add_child($horiz_4_creative_data);																																																	
				
				// Insert vertical 1 creative 
				
				$verti_1_creative_data 		= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_verti_add_1_creative')),
													"width"			=>	'1280',
													"height"		=>	'1280',
													"content_type"	=>	clean_data($this->post('tmp_verti_add_1_creative_content_type')),
													"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
													"position" 		=> 	MOBILE_CREATIVE_VERTICAL,
													"display_size" 	=> 	X_LARGE,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_verti_add_1_creative')));
				$this->do_mobile_creative->add_child($verti_1_creative_data);																																																	
				
				// Insert vertical 2 creative 
				
				$verti_2_creative_data 		= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_verti_add_2_creative')),
													"width"			=>	'1024',
													"height"		=>	'1024',
													"content_type"	=>	clean_data($this->post('tmp_verti_add_2_creative_content_type')),
													"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
													"position" 		=> 	MOBILE_CREATIVE_VERTICAL,
													"display_size" 	=> 	LARGE,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_verti_add_2_creative')));
				$this->do_mobile_creative->add_child($verti_2_creative_data);																																																	
				
				// Insert vertical 3 creative 
				
				$verti_3_creative_data 		= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_verti_add_3_creative')),
													"width"			=>	'800',
													"height"		=>	'800',
													"content_type"	=>	clean_data($this->post('tmp_verti_add_3_creative_content_type')),
													"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
													"position" 		=> 	MOBILE_CREATIVE_VERTICAL,
													"display_size" 	=> 	MEDIUM,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_verti_add_3_creative')));
				$this->do_mobile_creative->add_child($verti_3_creative_data);																																																	
				
				// Insert vertical 4 creative 
				
				$verti_4_creative_data 		= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_verti_add_4_creative')),
													"width"			=>	'480',
													"height"		=>	'480',
													"content_type"	=>	clean_data($this->post('tmp_verti_add_4_creative_content_type')),
													"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
													"position" 		=> 	MOBILE_CREATIVE_VERTICAL,
													"display_size" 	=> 	SMALL,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_verti_add_4_creative')));
				$this->do_mobile_creative->add_child($verti_4_creative_data);																																																	
				
				// Insert vertical 1 creative 
				
				$content_1_creative_data 	= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_content_add_1_creative')),
													"width"			=>	'768',
													"height"		=>	'768',
													"content_type"	=>	clean_data($this->post('tmp_content_add_1_creative_content_type')),
													"display_type" 	=> 	MOBILE_CREATIVE_CONTENT,
													"position" 		=> 	'',
													"display_size" 	=> 	X_LARGE,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_add_1_creative')));
				$this->do_mobile_creative->add_child($content_1_creative_data);																																																	
				
				// Insert vertical 2 creative 
				
				$content_2_creative_data 	= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_content_add_2_creative')),
													"width"			=>	'600',
													"height"		=>	'600',
													"content_type"	=>	clean_data($this->post('tmp_content_add_2_creative_content_type')),
													"display_type" 	=> 	MOBILE_CREATIVE_CONTENT,
													"position" 		=> 	'',
													"display_size" 	=> 	LARGE,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_add_2_creative')));
				$this->do_mobile_creative->add_child($content_2_creative_data);																																																	
				
				// Insert vertical 3 creative 
				
				$content_3_creative_data 	= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_content_add_3_creative')),
													"width"			=>	'480',
													"height"		=>	'480',
													"content_type"	=>	clean_data($this->post('tmp_content_add_3_creative_content_type')),
													"display_type" 	=> 	MOBILE_CREATIVE_CONTENT,
													"position" 		=> 	'',
													"display_size" 	=> 	MEDIUM,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_add_3_creative')));
				$this->do_mobile_creative->add_child($content_3_creative_data);																																																	
				
				// Insert vertical 4 creative 
				
				$content_4_creative_data 	= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_content_add_4_creative')),
													"width"			=>	'320',
													"height"		=>	'320',
													"content_type"	=>	clean_data($this->post('tmp_content_add_4_creative_content_type')),
													"display_type" 	=> 	MOBILE_CREATIVE_CONTENT,
													"position" 		=> 	'',
													"display_size" 	=> 	SMALL,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_add_4_creative')));
				$creative_add				=	$this->do_mobile_creative->add_child($content_4_creative_data);		
				
				// Insert tablet1 portrait creative 
				
				$tab1_creative_data 	= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_base_tab1_creative')),
													"width"			=>	'768',
													"height"		=>	'90',
													"content_type"	=>	clean_data($this->post('tmp_base_tab1_creative_content_type')),
													"display_type" 	=> 	MOBILE_CREATIVE_BASE,
													"position" 		=> 	MOBILE_CREATIVE_TABLET_PORTRAIT,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_tab1_creative')));
				$this->do_mobile_creative->add_child($tab1_creative_data);
				
				// Insert tablet2 landscape creative 
				
				$tab2_creative_data 	= 	array(
													"banner_id" 	=> 	$banner_id,
													"file_path"		=>	clean_data($this->post('tmp_base_tab2_creative')),
													"width"			=>	'1024',
													"height"		=>	'90',
													"content_type"	=>	clean_data($this->post('tmp_base_tab2_creative_content_type')),
													"display_type" 	=> 	MOBILE_CREATIVE_BASE,
													"position" 		=> 	MOBILE_CREATIVE_TABLET_LANDSCAPE,
													"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
													"dj_image_path"		=>  $dj_image_path
												);
					
				//On sucess move the base creative from tmp location to original location
				$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_tab2_creative')));
				$this->do_mobile_creative->add_child($tab2_creative_data);																																															
				
				if($creative_add)
				{
					
						/***creative change for message/mail notification*****/
		
						$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
						$content['sub'] ='Slider creative added';
						$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Slider Creative';
						$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
						$content['creative_name'] = $creative_data['description'];
						$content['creative_ml']	  = 'Mobile Creative';
						$content['creative_type'] = 'Slider Creative';
						$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
				
						/***creative change for message/mail notification*****/	
						/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$banner_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),
										);						
					}
					else
					{
						$success = array(
										'response' 		=> 	'ok',
										'msg'	 		=> 	'Creative sucessfully added',
										'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),
										);
					}
					$this->response( $success, 200);
					
				}
				else
				{
					if($this->user_authentication->account_type=='ADVERTISER')
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),
									);					
					}
					else
					{
						$error = array(
									'response' 		=> 	'error',
									'msg'	 		=> 	'Error. Please try again',
									'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),
									);	
					}
					
					$this->response( $error, 200);
				}
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),
								);	
				}	
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: edit_slider_creative
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage Slider Mobile Creative edit process
	 */
	public function edit_slider_creative_post()
	{
		$this->form_validation->set_rules('slider_creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		#BASE PORTRAIT CREATVES
		$tmp_base_portrait_creative=clean_data($this->post('tmp_base_portrait_creative'));
		if (empty($tmp_base_portrait_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('base_portrait_creative', 'Creative', 'required');
		}
		#BASE LANDSCAPE CREATVES
		$tmp_base_land_creative=clean_data($this->post('tmp_base_land_creative'));
		if (empty($tmp_base_land_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('base_land_creative', 'Creative', 'required');
		}
		#SWIPE CREATVES
		/*$tmp_swipe_creative=$this->post('tmp_swipe_creative');
		if (empty($tmp_swipe_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('swipe_creative', 'Creative', 'required');
		}*/
		#HOR AD1 CREATVES
		$tmp_horiz_add_1_creative=$this->post('tmp_horiz_add_1_creative');
		if (empty($tmp_horiz_add_1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('horiz_add_1_creative', 'Creative', 'required');
		}
		#HOR AD2 CREATVES
		$tmp_horiz_add_2_creative=clean_data($this->post('tmp_horiz_add_2_creative'));
		if (empty($tmp_horiz_add_2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('horiz_add_2_creative', 'Creative', 'required');
		}
		#HOR AD3 CREATVES
		$tmp_horiz_add_3_creative=clean_data($this->post('tmp_horiz_add_3_creative'));
		if (empty($tmp_horiz_add_3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('horiz_add_3_creative', 'Creative', 'required');
		}
		#HOR AD4 CREATVES
		$tmp_horiz_add_4_creative=clean_data($this->post('tmp_horiz_add_4_creative'));
		if (empty($tmp_horiz_add_4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('horiz_add_4_creative', 'Creative', 'required');
		}
		#VERT AD1 CREATVES
		$tmp_verti_add_1_creative=clean_data($this->post('tmp_verti_add_1_creative'));
		if (empty($tmp_verti_add_1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('verti_add_1_creative', 'Creative', 'required');
		}
		#VERT AD2 CREATVES
		$tmp_verti_add_2_creative=clean_data($this->post('tmp_verti_add_2_creative'));
		if (empty($tmp_verti_add_2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('verti_add_2_creative', 'Creative', 'required');
		}
		#VERT AD3 CREATVES
		$tmp_verti_add_3_creative=clean_data($this->post('tmp_verti_add_3_creative'));
		if (empty($tmp_verti_add_3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('verti_add_3_creative', 'Creative', 'required');
		}
		#VERT AD4 CREATVES
		$tmp_verti_add_4_creative=clean_data($this->post('tmp_verti_add_4_creative'));
		if (empty($tmp_verti_add_4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('verti_add_4_creative', 'Creative', 'required');
		}
		#CONTENT AD1 CREATVES
		$tmp_content_add_1_creative=clean_data($this->post('tmp_content_add_1_creative'));
		if (empty($tmp_content_add_1_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('content_add_1_creative', 'Creative', 'required');
		}
		#CONTENT AD2 CREATVES
		$tmp_content_add_2_creative=clean_data($this->post('tmp_content_add_2_creative'));
		if (empty($tmp_content_add_2_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('content_add_2_creative', 'Creative', 'required');
		}
		#CONTENT AD3 CREATVES
		$tmp_content_add_3_creative=clean_data($this->post('tmp_content_add_3_creative'));
		if (empty($tmp_content_add_3_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('content_add_3_creative', 'Creative', 'required');
		}
		#CONTENT AD4 CREATVES
		$tmp_content_add_4_creative=clean_data($this->post('tmp_content_add_4_creative'));
		if (empty($tmp_content_add_4_creative))
		{
			$this->form_validation->set_message('required', 'No creative selected or not upto IAB standard.');
			$this->form_validation->set_rules('content_add_4_creative', 'Creative', 'required');
		}			
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{	
			$creative_id					=	clean_data($this->post('creative_id'));	
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$creative_data 					= 	array(
													"contenttype"		=>	clean_data($this->post('tmp_base_portrait_creative_content_type')),
													"description"		=>	clean_data($this->post('slider_creative_name')),
													"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
													"updated"			=>	clean_data(date('Y:m:d :H:i:s'))
												);
				
			//Get agency_id from library file
			$agency_id=$this->user_authentication->agency_id;
			
			//Call to edit a creative
			 $creative_edit					=	$this->do_mobile_creative->edit_mobile($creative_data,$creative_id,$agency_id);
			
			if($creative_edit)
			{	
				if(clean_data($this->post('old_base_portrait_creative'))!=clean_data($this->post('tmp_base_portrait_creative')))
				{
					// Insert base portrait creative 
					
					$portrait_creative_data 	= 	array(
														"file_path"		=>	clean_data($this->post('tmp_base_portrait_creative')),
														"content_type"	=>	clean_data($this->post('tmp_base_portrait_creative_content_type')),
														"updated"=>clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"		=>  $dj_image_path
													);
					
					$where_base 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_BASE,
														  'position'	=>	MOBILE_CREATIVE_PORTRAIT
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_portrait_creative')));
					
					$old_sli_base_portrait_creative_path = clean_data($this->post('old_sli_base_portrait_creative_path'));
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_base_portrait_creative')),$old_sli_base_portrait_creative_path);
					
					$this->do_mobile_creative->edit_child_mobile($portrait_creative_data,$where_base);	
				}
				
				if(clean_data($this->post('old_base_tab1_creative'))!=clean_data($this->post('tmp_base_tab1_creative')))
				{
					// Insert tablet1 portrait creative 
					
					$tablet1_creative_data 	= 	array(
														"file_path"		=>	clean_data($this->post('tmp_base_tab1_creative')),
														"content_type"	=>	clean_data($this->post('tmp_base_tab1_creative_content_type')),
														"updated"		=>clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"	=>  $dj_image_path
													);
					
					$where_base 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_BASE,
														  'position'	=>	MOBILE_CREATIVE_TABLET_PORTRAIT
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_tab1_creative')));
					
					$old_sli_base_tab1_creative_path = clean_data($this->post('old_sli_base_tab1_creative_path'));
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_base_tab1_creative')),$old_sli_base_tab1_creative_path);
					
					$this->do_mobile_creative->edit_child_mobile($tablet1_creative_data,$where_base);	
				}
				
				if(clean_data($this->post('old_base_tab2_creative'))!=clean_data($this->post('tmp_base_tab2_creative')))
				{
					// Insert tablet2 portrait creative 
					
					$tablet2_creative_data 	= 	array(
														"file_path"		=>	clean_data($this->post('tmp_base_tab2_creative')),
														"content_type"	=>	clean_data($this->post('tmp_base_tab2_creative_content_type')),
														"updated"=>clean_data(date('Y:m:d :H:i:s')),
														"dj_image_path"		=>  $dj_image_path
													);
					
					$where_base 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_BASE,
														  'position'	=>	MOBILE_CREATIVE_TABLET_LANDSCAPE
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_tab2_creative')));
					
					$old_sli_base_tab2_creative_path = clean_data($this->post('old_sli_base_tab2_creative_path'));
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_base_tab2_creative')),$old_sli_base_tab2_creative_path);
					
					$this->do_mobile_creative->edit_child_mobile($tablet2_creative_data,$where_base);	
				}
				
				if(clean_data($this->post('old_base_land_creative'))!=clean_data($this->post('tmp_base_land_creative')))
				{
					// Insert base landscape creative 
					
					$landscape_creative_data 	= 	array(
														"file_path"		=>	clean_data($this->post('tmp_base_land_creative')),
														"content_type"	=>	clean_data($this->post('tmp_base_land_creative_content_type')),
														"updated"=>clean_data(date('Y:m:d :H:i:s')),"dj_image_path"		=>  $dj_image_path		
													);
						
					$where_land 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_BASE,
														  'position'	=>	MOBILE_CREATIVE_LANDSCAPE
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_land_creative')));
					
					$old_sli_base_land_creative_path = $this->post('old_sli_base_land_creative_path');
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_base_land_creative')),$old_sli_base_land_creative_path);
					
					$this->do_mobile_creative->edit_child_mobile($landscape_creative_data,$where_land);	
					
				}
				
				/*if($this->post('old_swipe_creative')!=$this->post('tmp_swipe_creative'))
				{
					// Insert base landscape creative 
					
					$swipe_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_swipe_creative')),
														"content_type"	=>	clean_data($this->post('tmp_swipe_creative_content_type')),
														"updated"=>clean_data(date('Y:m:d :H:i:s'))
													);
					
					$where_swipe 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_SWIPE
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location($this->post('tmp_swipe_creative'));
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location($this->post('old_swipe_creative'));
					
					$this->do_mobile_creative->edit_child_mobile($swipe_creative_data,$where_swipe);		
					
				}*/
				
				if(clean_data($this->post('old_horiz_add_1_creative'))!=clean_data($this->post('tmp_horiz_add_1_creative')))
				{
					// Insert horizontal 1 creative 
					
					$horiz_1_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_horiz_add_1_creative')),
														"content_type"	=>	clean_data($this->post('tmp_horiz_add_1_creative_content_type')),
														"updated"=>clean_data(date('Y:m:d :H:i:s')),"dj_image_path"		=>  $dj_image_path
													);
					
					$where_hor_1 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_BACKGROUND,
														  'position' 	=> 	MOBILE_CREATIVE_HORIZONTAL,
														  'display_size'=>	X_LARGE
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horiz_add_1_creative')));
					
					$old_horiz_add_1_creative_path = $this->post('old_horiz_add_1_creative_path');
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_horiz_add_1_creative')),$old_horiz_add_1_creative_path);
					
					$this->do_mobile_creative->edit_child_mobile($horiz_1_creative_data,$where_hor_1);		
				}
				
				if(clean_data($this->post('old_horiz_add_2_creative'))!=clean_data($this->post('tmp_horiz_add_2_creative')))
				{
					// Insert horizontal 2 creative 
					
					$horiz_2_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_horiz_add_2_creative')),
														"content_type"	=>	clean_data($this->post('tmp_horiz_add_2_creative_content_type')),
														"updated"=>clean_data(date('Y:m:d :H:i:s')),"dj_image_path"		=>  $dj_image_path
													);
					
					$where_hor_2 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_BACKGROUND,
														  'position' 	=> 	MOBILE_CREATIVE_HORIZONTAL,
														  'display_size'=>	LARGE
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horiz_add_2_creative')));
					
					$old_horiz_add_2_creative_path = clean_data($this->post('old_horiz_add_2_creative_path'));
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_horiz_add_2_creative')),$old_horiz_add_2_creative_path);
					
					$this->do_mobile_creative->edit_child_mobile($horiz_2_creative_data,$where_hor_2);			
				}																																
					
				if(clean_data($this->post('old_horiz_add_3_creative'))!=clean_data($this->post('tmp_horiz_add_3_creative')))
				{
					// Insert horizontal 3 creative 
					
					$horiz_3_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_horiz_add_3_creative')),
														"content_type"	=>	clean_data($this->post('tmp_horiz_add_3_creative_content_type')),
														"updated"=>clean_data(date('Y:m:d :H:i:s')),"dj_image_path"		=>  $dj_image_path
													);
					
					$where_hor_3 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_BACKGROUND,
														  'position' 	=> 	MOBILE_CREATIVE_HORIZONTAL,
														  'display_size'=>	MEDIUM
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horiz_add_3_creative')));
					
					$old_horiz_add_3_creative_path = clean_data($this->post('old_horiz_add_3_creative_path'));
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_horiz_add_3_creative')),$old_horiz_add_3_creative_path);
					
					$this->do_mobile_creative->edit_child_mobile($horiz_3_creative_data,$where_hor_3);				
					
				}
				
				if(clean_data($this->post('old_horiz_add_4_creative'))!=clean_data($this->post('tmp_horiz_add_4_creative')))
				{
					// Insert horizontal 4 creative 
					
					$horiz_4_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_horiz_add_4_creative')),
														"content_type"	=>	clean_data($this->post('tmp_horiz_add_4_creative_content_type')),
														"updated"=>clean_data(date('Y:m:d :H:i:s')),"dj_image_path"		=>  $dj_image_path
													);
					
					$where_hor_4 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_BACKGROUND,
														  'position' 	=> 	MOBILE_CREATIVE_HORIZONTAL,
														  'display_size'=>	SMALL
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horiz_add_4_creative')));
					
					$old_horiz_add_4_creative_path = clean_data($this->post('old_horiz_add_4_creative_path'));
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_horiz_add_4_creative')),$old_horiz_add_4_creative_path);
					
					$this->do_mobile_creative->edit_child_mobile($horiz_4_creative_data,$where_hor_4);					
				}
				
				if(clean_data($this->post('old_verti_add_1_creative'))!=clean_data($this->post('tmp_verti_add_1_creative')))
				{	
					// Insert vertical 1 creative 
					
					$verti_1_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_verti_add_1_creative')),
														"content_type"	=>	clean_data($this->post('tmp_verti_add_1_creative_content_type')),
														"updated"=>clean_data(date('Y:m:d :H:i:s')),"dj_image_path"		=>  $dj_image_path
													);
					
					$where_ver_1 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_BACKGROUND,
														  'position' 	=> 	MOBILE_CREATIVE_VERTICAL,
														  'display_size'=>	X_LARGE
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_verti_add_1_creative')));
					
					$old_verti_add_1_creative_path = clean_data($this->post('old_verti_add_1_creative_path'));
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_verti_add_1_creative')),$old_verti_add_1_creative_path);
					
					$this->do_mobile_creative->edit_child_mobile($verti_1_creative_data,$where_ver_1);						
					
				}
				
				if(clean_data($this->post('old_verti_add_2_creative'))!=clean_data($this->post('tmp_verti_add_2_creative')))
				{	
					// Insert vertical 2 creative 
					
					$verti_2_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_verti_add_2_creative')),
														"content_type"	=>	clean_data($this->post('tmp_verti_add_2_creative_content_type')),
														"updated"=>clean_data(date('Y:m:d :H:i:s')),"dj_image_path"		=>  $dj_image_path
													);
					
					$where_ver_2 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_BACKGROUND,
														  'position' 	=> 	MOBILE_CREATIVE_VERTICAL,
														  'display_size'=>	LARGE
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_verti_add_2_creative')));
					
					$old_verti_add_2_creative_path = clean_data($this->post('old_verti_add_2_creative_path'));
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_verti_add_2_creative')),$old_verti_add_2_creative_path);
					
					$this->do_mobile_creative->edit_child_mobile($verti_2_creative_data,$where_ver_2);							
				}
				
				if(clean_data($this->post('old_verti_add_3_creative'))!=clean_data($this->post('tmp_verti_add_3_creative')))
				{	
					// Insert vertical 3 creative 
					
					$verti_3_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_verti_add_3_creative')),
														"content_type"	=>	clean_data($this->post('tmp_verti_add_3_creative_content_type')),
														"updated"=>clean_data(date('Y:m:d :H:i:s')),"dj_image_path"		=>  $dj_image_path
													);
					
					$where_ver_3 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_BACKGROUND,
														  'position' 	=> 	MOBILE_CREATIVE_VERTICAL,
														  'display_size'=>	MEDIUM
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_verti_add_3_creative')));
					
					$old_verti_add_3_creative_path = clean_data($this->post('old_verti_add_3_creative_path'));
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_verti_add_3_creative')),$old_verti_add_3_creative_path);
					
					$this->do_mobile_creative->edit_child_mobile($verti_3_creative_data,$where_ver_3);							
				}
					
				if(clean_data($this->post('old_verti_add_4_creative'))!=clean_data($this->post('tmp_verti_add_4_creative')))
				{	
					// Insert vertical 4 creative 
					
					$verti_4_creative_data 		= 	array(
														"file_path"		=>	clean_data($this->post('tmp_verti_add_4_creative')),
														"content_type"	=>	clean_data($this->post('tmp_verti_add_4_creative_content_type')),
														"updated"=>clean_data(date('Y:m:d :H:i:s')),"dj_image_path"		=>  $dj_image_path
													);
					
					$where_ver_4 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_BACKGROUND,
														  'position' 	=> 	MOBILE_CREATIVE_VERTICAL,
														  'display_size'=>	SMALL
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_verti_add_4_creative')));
					
					$old_verti_add_4_creative_path = clean_data($this->post('old_verti_add_4_creative_path'));
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_verti_add_4_creative')),$old_verti_add_4_creative_path);
					
					$this->do_mobile_creative->edit_child_mobile($verti_4_creative_data,$where_ver_4);							
				}	
					
				if(clean_data($this->post('old_content_add_1_creative'))!=clean_data($this->post('tmp_content_add_1_creative')))
				{	
					// Insert content 1 creative 
					
					$content_1_creative_data 	= 	array(
														"file_path"		=>	clean_data($this->post('tmp_content_add_1_creative')),
														"content_type"	=>	clean_data($this->post('tmp_content_add_1_creative_content_type')),
														"updated"=>clean_data(date('Y:m:d :H:i:s')),"dj_image_path"		=>  $dj_image_path
													);
					
					$where_con_1 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_CONTENT,
														  'display_size'=>	X_LARGE
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_add_1_creative')));
					
					$old_content_add_1_creative_path = clean_data($this->post('old_content_add_1_creative_path'));
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_content_add_1_creative')),$old_content_add_1_creative_path);
					
					$this->do_mobile_creative->edit_child_mobile($content_1_creative_data,$where_con_1);								
				}
									
				if(clean_data($this->post('old_content_add_2_creative'))!=clean_data($this->post('tmp_content_add_2_creative')))
				{	
					// Insert content 2 creative 
					
					$content_2_creative_data 	= 	array(
														"file_path"		=>	clean_data($this->post('tmp_content_add_2_creative')),
														"content_type"	=>	clean_data($this->post('tmp_content_add_2_creative_content_type')),
														"updated"=>clean_data(date('Y:m:d :H:i:s')),"dj_image_path"		=>  $dj_image_path
													);
					
					$where_con_2 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_CONTENT,
														  'display_size'=>	LARGE
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_add_2_creative')));
					
					$old_content_add_2_creative_path = clean_data($this->post('old_content_add_2_creative_path'));
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_content_add_2_creative')),$old_content_add_2_creative_path);
					
					$this->do_mobile_creative->edit_child_mobile($content_2_creative_data,$where_con_2);									
				}
				
				if(clean_data($this->post('old_content_add_3_creative'))!=clean_data($this->post('tmp_content_add_3_creative')))
				{	
					// Insert content 3 creative 
					
					$content_3_creative_data 	= 	array(
														"file_path"		=>	clean_data($this->post('tmp_content_add_3_creative')),
														"content_type"	=>	clean_data($this->post('tmp_content_add_3_creative_content_type')),
														"updated"=>clean_data(date('Y:m:d :H:i:s')),"dj_image_path"		=>  $dj_image_path
													);
					
					$where_con_3 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_CONTENT,
														  'display_size'=>	MEDIUM
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_add_3_creative')));
					
					$old_content_add_3_creative_path = $this->post('old_content_add_3_creative_path');
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_content_add_3_creative')),$old_content_add_3_creative_path);
					
					$this->do_mobile_creative->edit_child_mobile($content_3_creative_data,$where_con_3);										
					
				}
				
				if(clean_data($this->post('old_content_add_4_creative'))!=clean_data($this->post('tmp_content_add_4_creative')))
				{		
					// Insert content 4 creative 
					
					$content_4_creative_data 	= 	array(
														"file_path"		=>	clean_data($this->post('tmp_content_add_4_creative')),
														"content_type"	=>	clean_data($this->post('tmp_content_add_4_creative_content_type')),
														"updated"=>clean_data(date('Y:m:d :H:i:s')),"dj_image_path"		=>  $dj_image_path
													);
					
					$where_con_4 				= 	array('banner_id'	=>	$creative_id,
														  'display_type'=>	MOBILE_CREATIVE_CONTENT,
														  'display_size'=>	SMALL
														);		
					//On sucess move the base creative from tmp location to original location
					$is_creative_moved			=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_add_4_creative')));
					
					$old_content_add_4_creative_path = clean_data($this->post('old_content_add_4_creative_path'));
					
					$is_old_creative_deleted	=	$this->image_lib->delete_creative_in_original_location_date(clean_data($this->post('old_content_add_4_creative')),$old_content_add_4_creative_path);
					
					$this->do_mobile_creative->edit_child_mobile($content_4_creative_data,$where_con_4);										
					
				}
				
				
				 /***creative edit for message/mail notification*****/
				 
					$creative_dat = $this->do_creative->fetch_campaignid_creative($creative_id);
					$campaign_id = $creative_dat[0]['campaignid'];
					//$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
					$content['sub'] ='Mobile Slider creative edited';
					$content['data'] ='The Creative has been edited successfully. <br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Slider Creative';
					$content['content'] ='Congrats!The creative has been edited successfully.';
					$content['creative_name'] = $creative_data['description'];
					$content['creative_ml']	  = 'Mobile Creative';
					$content['creative_type'] = 'Slider Creative';
					$creative_add=$this->do_message->mail_to_lib_advertiser('creative_edit','campaigns',null,$content,$campaign_id);
					
				/***creative edit for message/mail notification*****/
				/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_EDIT);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,EDIT,$creative_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	site_url('advertiser/creatives/'),
										);				
				}
				else
				{
					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Creative successfully edited',
										'redirect'	=> 	site_url('admin/creatives/'),
										);
				}
				
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/creatives/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/creatives/'),
								);	
				}
					
				$this->response( $error, 200);
			}
		}
	}
	
	

	/*
	 * 
	 * name: creative_to_tmp_location_post
	 * @param
	 * @return:response array
	 * 
	 * Upload the selected web creative to a temporary location
	 * 
	 */
	public function creative_to_tmp_location_post()
	{
		if($_FILES['creative'])
		{
			$creative=array(
					'file_name'   => $_FILES['creative']['name'],
					'tmp_name' => $_FILES['creative']['tmp_name'], 
					);
					
			$tmp_creative=$this->image_lib->move_creative_to_tmp_location($creative);
			
			if($tmp_creative['upload_data'])
			{
				$success = array(
								'response' => $tmp_creative['upload_data'],
								'msg'	 => 'Moved to temporary location'
				);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'redirect'=>site_url('advertiser/creatives/add_mobile_creatives'),
								'msg'	 => 'Unable to move to temporary location '
				);
				$this->response($error, 200);
			}
		}
		
	}
	/*
	 * 
	 * name: delete_a_creative
	 * @param :
	 * @return :response array
	 * 
	 * Delete the creative in its original location
	 */
	
	public function delete_a_creative_post()
	{
		$tmp_creative_name=clean_data($this->post('creative_name'));
		
		if($tmp_creative_name)
		{
			$is_tmp_creative=$this->image_lib->delete_creative_in_original_location($tmp_creative_name);

			if($is_tmp_creative)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => 'Temporary creative deleted'
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the temporary creative file'
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the temporary location file'
							);
			$this->response($error, 200);
		}
	}
	/*
	 * 
	 * name: delete_a_tmp_creative
	 * @param :
	 * @return :response array
	 * 
	 * Delete the creative in temporary location
	 */
	
	public function delete_a_tmp_creative_post()
	{
		$tmp_creative_name=clean_data($this->post('creative_name'));
		if($tmp_creative_name)
		{
			$is_tmp_creative=$this->image_lib->delete_creative_in_tmp_location($tmp_creative_name);

			if($is_tmp_creative)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => 'Temporary creative deleted'
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the temporary creative file'
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the temporary location file'
							);
			$this->response($error, 200);
		}
	}

	/*
	 * 
	 * name: add_adhesion_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage Adhesion adding process
	 */
	public function add_adhesion_creative_post()
	{
		$this->form_validation->set_rules('creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$campaign = clean_data($this->post('_adh_campaign_id'));
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && clean_data($this->post('_adh_type'))!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_adh_campaign_id'));
		}	
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	'web';
			$master_banner 	= 	'-2';
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/agency_id from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id=$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_adh_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_adh_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			//checking creative is ad market or not -start DAC094
			$is_admarket	= 	clean_data($this->post('_admarket_id'));
			if($is_admarket)
			{
			$ad_market = 1;
			}
			else
			{
			$ad_market = 0;
			}	
			// stop 
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}

			// Set width and height of the creative
			$size_base_portrait_w		= 320;
			$size_base_portrait_h		= 50;
			
			$size_base_tablet1_w		= 728;
			$size_base_tablet1_h		= 90;
			
			$size_base_tablet2_w		= 1024;
			$size_base_tablet2_h		= 90;
			
			$size_base_landscape_w		= 480;
			$size_base_landscape_h		= 50;

			$size_bg_horizontal1		= 1280;
			$size_bg_horizontal2		= 1024;
			$size_bg_horizontal3		= 800;
			$size_bg_horizontal4		= 480;

			$size_bg_vertical1			= 1280;
			$size_bg_vertical2			= 1024;
			$size_bg_vertical3			= 800;
			$size_bg_vertical4			= 480;

			$size_content1				= 768;
			$size_content2				= 600;
			$size_content3				= 480;
			$size_content4				= 320;
			
			$creative_data 	= 	array(
									"storagetype"		=>	clean_data($storage_type),
									"campaignid"		=>	clean_data($campaign_id),
									"description"		=>	clean_data($this->post('creative_name')),
									"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),
									"dj_banner_type"	=>	MOBILE_RS_CREATIVE_ADHESION,
									"dj_master_banner"	=>	clean_data($master_banner),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"dj_image_path"		=>  $dj_image_path,
									'dj_admarket_status'=>	clean_data($ad_market)
								);			
			 
			//Call to add a creative
			$banner_id = $this->do_mobile_creative->add($creative_data,$agency_id);
				
			/*************************** ADD BASE CREATIVES***************************/
			$base_portrait_data = array(
									"banner_id" 	=> 	clean_data($banner_id),
									"file_path"		=>	clean_data($this->post('tmp_base_portrait_creative')),
									"width"			=>	clean_data($size_base_portrait_w),
									"height"		=>	clean_data($size_base_portrait_h),
									"content_type"	=>	clean_data($this->post('tmp_base_portrait_creative_content_type')),
									"display_type" 	=> 	MOBILE_CREATIVE_BASE,
									"position" 		=> 	MOBILE_CREATIVE_PORTRAIT,
									"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_portrait_creative')));
			$this->do_mobile_creative->add_child($base_portrait_data);
				
			// Insert base creative 
			$base_portrait1_data = array(
									"banner_id" 	=> 	clean_data($banner_id),
									"file_path"		=>	clean_data($this->post('tmp_base_landscape_creative')),
									"width"			=>	clean_data($size_base_landscape_w),
									"height"		=>	clean_data($size_base_landscape_h),
									"content_type"	=>	clean_data($this->post('tmp_base_landscape_creative_content_type')),
									"display_type" 	=> 	MOBILE_CREATIVE_BASE,
									"position" 		=> 	MOBILE_CREATIVE_LANDSCAPE,
									"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_landscape_creative')));
			$this->do_mobile_creative->add_child($base_portrait1_data);
			
			$base_tablet1_data = array(
									"banner_id" 	=> 	clean_data($banner_id),
									"file_path"		=>	clean_data($this->post('tmp_base_tablet1_creative')),
									"width"			=>	clean_data($size_base_tablet1_w),
									"height"		=>	clean_data($size_base_tablet1_h),
									"content_type"	=>	clean_data($this->post('tmp_base_tablet1_creative_content_type')),
									"display_type" 	=> 	MOBILE_CREATIVE_BASE,
									"position" 		=> 	MOBILE_CREATIVE_TABLET_PORTRAIT,
									"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
			#print_r($base_tablet1_data);exit;
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_tablet1_creative')));
			$this->do_mobile_creative->add_child($base_tablet1_data);
				
			// Insert base creative 
			$base_tablet2_data = array(
									"banner_id" 	=> 	clean_data($banner_id),
									"file_path"		=>	clean_data($this->post('tmp_base_tablet2_creative')),
									"width"			=>	clean_data($size_base_tablet2_w),
									"height"		=>	clean_data($size_base_tablet2_h),
									"content_type"	=>	clean_data($this->post('tmp_base_tablet2_creative_content_type')),
									"display_type" 	=> 	MOBILE_CREATIVE_BASE,
									"position" 		=> 	MOBILE_CREATIVE_TABLET_LANDSCAPE,
									"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_image_path"		=>  $dj_image_path
								);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_base_tablet2_creative')));
			$this->do_mobile_creative->add_child($base_tablet2_data);
				
			/*************************** ADD HORIZONTAL CREATIVES***************************/

			// Insert horizantal creative 
			$additional_creative_data = array(
											"banner_id" 	=> clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_horizantal_ad1_creative')),
											"width"			=>	clean_data($size_bg_horizontal1),
											"height"		=>	clean_data($size_bg_horizontal1),
											"content_type"	=>	clean_data($this->post('tmp_horizantal_ad1_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"display_size" 	=> 	X_LARGE,
											"position" 		=> 	MOBILE_CREATIVE_HORIZONTAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad1_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);

			// Insert horizantal creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_horizantal_ad2_creative')),
											"width"			=>	clean_data($size_bg_horizontal2),
											"height"		=>	clean_data($size_bg_horizontal2),
											"content_type"	=>	clean_data($this->post('tmp_horizantal_ad2_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"display_size" 	=> 	LARGE,
											"position" 		=> 	MOBILE_CREATIVE_HORIZONTAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);

			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad2_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);

			// Insert horizantal creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_horizantal_ad3_creative')),
											"width"			=>	clean_data($size_bg_horizontal3),
											"height"		=>	clean_data($size_bg_horizontal3),
											"content_type"	=>	clean_data($this->post('tmp_horizantal_ad3_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"display_size" 	=> 	MEDIUM,
											"position" 		=> 	MOBILE_CREATIVE_HORIZONTAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad3_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);

			// Insert horizantal creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_horizantal_ad4_creative')),
											"width"			=>	clean_data($size_bg_horizontal4),
											"height"		=>	clean_data($size_bg_horizontal4),
											"content_type"	=>	clean_data($this->post('tmp_horizantal_ad4_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"display_size" 	=> 	SMALL,
											"position" 		=> 	MOBILE_CREATIVE_HORIZONTAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad4_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);

			/*************************** ADD VERTICAL CREATIVES***************************/

			// Insert vertical creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_vertical_ad1_creative')),
											"width"			=>	clean_data($size_bg_vertical1),
											"height"		=>	clean_data($size_bg_vertical1),
											"content_type"	=>	clean_data($this->post('tmp_vertical_ad1_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"display_size" 	=> 	X_LARGE,
											"position" 		=> 	MOBILE_CREATIVE_VERTICAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad1_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);

			// Insert vertical creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_vertical_ad2_creative')),
											"width"			=>	clean_data($size_bg_vertical2),
											"height"		=>	clean_data($size_bg_vertical2),
											"content_type"	=>	clean_data($this->post('tmp_vertical_ad2_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"display_size"	=> 	LARGE,
											"position" 		=> 	MOBILE_CREATIVE_VERTICAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad2_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);

			// Insert vertical creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_vertical_ad3_creative')),
											"width"			=>	clean_data($size_bg_vertical3),
											"height"		=>	clean_data($size_bg_vertical3),
											"content_type"	=>	clean_data($this->post('tmp_vertical_ad3_creative_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"display_size" 	=> 	MEDIUM,
											"position" 		=> 	MOBILE_CREATIVE_VERTICAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad3_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);

			// Insert vertical creative 
			$additional_creative_data = array(
												"banner_id" 	=> 	clean_data($banner_id),
												"file_path"		=>	clean_data($this->post('tmp_vertical_ad4_creative')),
												"width"			=>	clean_data($size_bg_vertical4),
												"height"		=>	clean_data($size_bg_vertical4),
												"content_type"	=>	clean_data($this->post('tmp_vertical_ad4_creative_content_type')),
												"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
												"display_size" 	=> 	SMALL,
												"position" 		=> 	MOBILE_CREATIVE_VERTICAL,
												"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad4_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);

			/*************************** ADD CONTENT CREATIVES***************************/

			// Insert content creative 
			$additional_creative_data = array(
												"banner_id" 	=> 	clean_data($banner_id),
												"file_path"		=>	clean_data($this->post('tmp_content_ad1_creative')),
												"width"			=>	clean_data($size_content1),
												"height"		=>	clean_data($size_content1),
												"content_type"	=>	clean_data($this->post('tmp_content_ad1_creative_content_type')),
												"display_type" 	=> 	MOBILE_CREATIVE_CONTENT,
												"display_size" 	=> 	X_LARGE,
												"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad1_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);
							
			// Insert content creative 
			$additional_creative_data = array(
												"banner_id" 	=> 	clean_data($banner_id),
												"file_path"		=>	clean_data($this->post('tmp_content_ad2_creative')),
												"width"			=>	clean_data($size_content2),
												"height"		=>	clean_data($size_content2),
												"content_type"	=>	clean_data($this->post('tmp_content_ad2_creative_content_type')),
												"display_type" 	=> 	MOBILE_CREATIVE_CONTENT,
												"display_size" 	=> 	LARGE,
												"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad2_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);
							
			// Insert content creative 
			$additional_creative_data = array(
												"banner_id" 	=> 	clean_data($banner_id),
												"file_path"		=>	clean_data($this->post('tmp_content_ad3_creative')),
												"width"			=>	clean_data($size_content3),
												"height"		=>	clean_data($size_content3),
												"content_type"	=>	clean_data($this->post('tmp_content_ad3_creative_content_type')),
												"display_type" 	=> 	MOBILE_CREATIVE_CONTENT,
												"display_size" 	=> 	MEDIUM,
												"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad3_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);
							
			// Insert content creative 
			$additional_creative_data = array(
												"banner_id" 	=> 	clean_data($banner_id),
												"file_path"		=>	clean_data($this->post('tmp_content_ad4_creative')),
												"width"			=>	clean_data($size_content4),
												"height"		=>	clean_data($size_content4),
												"content_type"	=>	clean_data($this->post('tmp_content_ad4_creative_content_type')),
												"display_type" 	=> 	MOBILE_CREATIVE_CONTENT,
												"display_size" 	=> 	SMALL,
												"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
												"dj_image_path"		=>  $dj_image_path
											);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad4_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);
			
			/***creative change for message/mail notification*****/
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Adhesion creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Adhesion Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Mobile Creative';
			$content['creative_type'] = 'Adhesion Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			/***creative change for message/mail notification*****/	
			
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$banner_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/				
			if($banner_id)
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);						
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);
				}
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								/*'redirect'	 	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');  
					}
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	 	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
								'redirect'	 	=> 	$redirect_url,  
								);	
				}
				
				$this->response( $error, 200);
			}
		}
	}
	/*
	 * 
	 * name: add_flex_creative_post  
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage Full page flex crative adding process
	 */
	public function add_flex_creative_post()
	{
		$this->form_validation->set_rules('creative_name','Creative name', 'required|trim');
		$this->form_validation->set_rules('destination_url', 'Destination URL', 'required|trim|callback_url_check');
		$campaign =clean_data($this->post('_flx_campaign_id'));
		
		$admarket_id = clean_data($this->post('_admarket_id'));
		$adma_id = ($admarket_id == false)?'0':'1';
		
		if(empty($campaign))
		{
			$this->form_validation->set_rules('campaign','Campaign', 'required|trim');
			$campaign_id= clean_data($this->post('campaign'));
			if($this->user_authentication->account_type!='ADVERTISER' && $this->post('_flx_type')!='housead')
			{
				$this->form_validation->set_rules('adv_id','Advertiser', 'required|trim');
			}
		}
		else
		{
			$campaign_id= clean_data($this->post('_flx_campaign_id'));
		}			
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$storage_type	=	'web';
			$master_banner 	= 	'-2';
			$dj_image_path = $this->config->item('creative_upload_path').date("Y-m-d")."/";
			$trusted_status='';
			//Get account/agency_id from library file
		    if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id=$this->user_authentication->account_id;
				$trusted_status=$this->do_campaign->adv_trusted_status($dj_account_id);
			}
			else
			{
				$dj_account_id	=	(clean_data($this->post('_flx_type'))=='housead')?$this->user_authentication->default_advertiser_account_id:((clean_data($this->post('adv_id')))?clean_data($this->post('adv_id')):clean_data($this->post('_flx_account_id')));
			}
			
			$agency_id		=	$this->user_authentication->agency_id;
			
			$is_house_ad	= 	clean_data($this->post('_is_house_ad'));
			
			$dj_is_direct	=	0;
			//checking creative is ad market or not -start DAC094
			$is_admarket	= 	clean_data($this->post('_admarket_id'));
			if($is_admarket)
			{
			$ad_market = 1;
			}
			else
			{
			$ad_market = 0;
			}	
			// stop 
			if($is_house_ad =='1')
			{
				$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
			}
			elseif($is_house_ad =='0')
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$approval_type		=	$this->do_creative->fetch_creative_approval_type();

					if($approval_type==="ADMIN")
					if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
					$dj_approved_date='';
					if($approval_type==="AUTO")
						$dj_admin_approve='1';$dj_approved_date=date("Y-m-d H:i:s");
				}
				else
				{
					$dj_admin_approve	=	'1';
					$dj_approved_date	=	date("Y-m-d H:i:s");
				}
			}
			elseif($is_house_ad =='2')
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
				$dj_is_direct	=	1;
			}
			else
			{
				if($trusted_status=='1'){ $dj_admin_approve='1'; } else { $dj_admin_approve='0'; }
				$dj_approved_date='';
			}

			// Set width and height of the creative
			$size_bg_horizontal1		= 1280;
			$size_bg_horizontal2		= 1024;
			$size_bg_horizontal3		= 800;
			$size_bg_horizontal4		= 480;

			$size_bg_vertical1			= 1280;
			$size_bg_vertical2			= 1024;
			$size_bg_vertical3			= 800;
			$size_bg_vertical4			= 480;

			$size_content1				= 768;
			$size_content2				= 600;
			$size_content3				= 480;
			$size_content4				= 320;
			
			$creative_data = array(
									"storagetype"		=>	clean_data($storage_type),
									"campaignid"		=>	clean_data($campaign_id),
									"description"		=>	clean_data($this->post('creative_name')),
									"url"				=>	clean_data($this->url_creation($this->post('destination_url'))),
									"dj_admin_approve"	=>	clean_data($dj_admin_approve),
									"dj_approved_date"	=>	clean_data($dj_approved_date),					
									"dj_banner_type"	=>	MOBILE_RS_CREATIVE_FLEX,
									"dj_master_banner"	=>	clean_data($master_banner),
									"dj_added_date"		=>	clean_data(date('Y:m:d :H:i:s')),
									"dj_account_id" 	=> 	clean_data($dj_account_id),
									"dj_is_direct" 		=> 	clean_data($dj_is_direct),
									"dj_image_path"		=>  $dj_image_path,
									'dj_admarket_status'=>	clean_data($ad_market)
								);
			 
			//Call to add a creative
			$banner_id = $this->do_mobile_creative->add($creative_data,$agency_id);
							
			/*************************** ADD HORIZONTAL CREATIVES***************************/

			// Insert horizantal creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_horizantal_ad1_creative')),
											"width"			=>	clean_data($size_bg_horizontal1),
											"height"		=>	clean_data($size_bg_horizontal1),
											"content_type"	=>	clean_data($this->post('tmp_horizantal_ad1_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"display_size" 	=> 	X_LARGE,
											"position" 		=> 	MOBILE_CREATIVE_HORIZONTAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved	=	$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad1_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);

			// Insert horizantal creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_horizantal_ad2_creative')),
											"width"			=>	clean_data($size_bg_horizontal2),
											"height"		=>	clean_data($size_bg_horizontal2),
											"content_type"	=>	clean_data($this->post('tmp_horizantal_ad2_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"display_size" 	=> 	LARGE,
											"position" 		=> 	MOBILE_CREATIVE_HORIZONTAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
											);

			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad2_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);

			// Insert horizantal creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_horizantal_ad3_creative')),
											"width"			=>	clean_data($size_bg_horizontal3),
											"height"		=>	clean_data($size_bg_horizontal3),
											"content_type"	=>	clean_data($this->post('tmp_horizantal_ad3_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"display_size" 	=> 	MEDIUM,
											"position" 		=> 	MOBILE_CREATIVE_HORIZONTAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad3_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);

			// Insert horizantal creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	$banner_id,
											"file_path"		=>	clean_data($this->post('tmp_horizantal_ad4_creative')),
											"width"			=>	clean_data($size_bg_horizontal4),
											"height"		=>	clean_data($size_bg_horizontal4),
											"content_type"	=>	clean_data($this->post('tmp_horizantal_ad4_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"display_size" 	=> 	SMALL,
											"position" 		=> 	MOBILE_CREATIVE_HORIZONTAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_horizantal_ad4_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);

			/*************************** ADD VERTICAL CREATIVES***************************/

			// Insert vertical creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_vertical_ad1_creative')),
											"width"			=>	clean_data($size_bg_vertical1),
											"height"		=>	clean_data($size_bg_vertical1),
											"content_type"	=>	clean_data($this->post('tmp_vertical_ad1_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"display_size" 	=> 	X_LARGE,
											"position" 		=> 	MOBILE_CREATIVE_VERTICAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad1_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);

			// Insert vertical creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_vertical_ad2_creative')),
											"width"			=>	clean_data($size_bg_vertical2),
											"height"		=>	clean_data($size_bg_vertical2),
											"content_type"	=>	clean_data($this->post('tmp_vertical_ad2_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"display_size" 	=> 	LARGE,
											"position" 		=> 	MOBILE_CREATIVE_VERTICAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad2_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);

			// Insert vertical creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_vertical_ad3_creative')),
											"width"			=>	clean_data($size_bg_vertical3),
											"height"		=>	clean_data($size_bg_vertical3),
											"content_type"	=>	clean_data($this->post('tmp_vertical_ad3_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"display_size" 	=> 	MEDIUM,
											"position" 		=> 	MOBILE_CREATIVE_VERTICAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad3_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);

			// Insert vertical creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_vertical_ad4_creative')),
											"width"			=>	clean_data($size_bg_vertical4),
											"height"		=>	clean_data($size_bg_vertical4),
											"content_type"	=>	clean_data($this->post('tmp_vertical_ad4_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_BACKGROUND,
											"display_size" 	=> 	SMALL,
											"position" 		=> 	MOBILE_CREATIVE_VERTICAL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_vertical_ad4_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);

			/*************************** ADD CONTENT CREATIVES***************************/

			// Insert content creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_content_ad1_creative')),
											"width"			=>	clean_data($size_content1),
											"height"		=>	clean_data($size_content1),
											"content_type"	=>	clean_data($this->post('tmp_content_ad1_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_CONTENT,
											"display_size" 	=> 	X_LARGE,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad1_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);
							
			// Insert content creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_content_ad2_creative')),
											"width"			=>	clean_data($size_content2),
											"height"		=>	clean_data($size_content2),
											"content_type"	=>	clean_data($this->post('tmp_content_ad2_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_CONTENT,
											"display_size"	=> 	LARGE,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad2_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);
							
			// Insert content creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_content_ad3_creative')),
											"width"			=>	clean_data($size_content3),
											"height"		=>	clean_data($size_content3),
											"content_type"	=>	clean_data($this->post('tmp_content_ad3_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_CONTENT,
											"display_size" 	=> 	MEDIUM,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad3_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);
							
			// Insert content creative 
			$additional_creative_data = array(
											"banner_id" 	=> 	clean_data($banner_id),
											"file_path"		=>	clean_data($this->post('tmp_content_ad4_creative')),
											"width"			=>	clean_data($size_content4),
											"height"		=>	clean_data($size_content4),
											"content_type"	=>	clean_data($this->post('tmp_content_ad4_content_type')),
											"display_type" 	=> 	MOBILE_CREATIVE_CONTENT,
											"display_size" 	=> 	SMALL,
											"created_date"	=>	clean_data(date('Y:m:d :H:i:s')),
											"dj_image_path"		=>  $dj_image_path
										);
				
			//On sucess move the base creative from tmp location to original location
			$is_creative_moved=$this->image_lib->move_creative_to_original_location(clean_data($this->post('tmp_content_ad4_creative')));
			$this->do_mobile_creative->add_child($additional_creative_data);
							
			if($banner_id)
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);						
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Creative sucessfully added',
									/*'redirect'	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
									'redirect'	 	=> 	$redirect_url,
									);
				}
				
			/***Activity Log For adding creatives ***/
			$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_ADD);
		      if($enable=='1')
		       {
					
					$creative_add=$this->add_activity_log(BANNER,ADD,$banner_id,$campaign_id);
				}
			
			/***Activity Log For adding creatives ***/					
			/***creative change for message/mail notification*****/
			$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
			$content['sub'] ='Flex creative added';
			$content['data'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.<br>Creative name &nbsp; : &nbsp;'.$creative_data['description'].'<br>Mobile/Web Creative &nbsp; : &nbsp; Mobile Creative &nbsp; <br> Creative Type &nbsp; : &nbsp; Flex Creative';
			$content['content'] ='Congrats! A new creative has been added to the camapign <b>'.$campaign_det[0]['campaignname'].'</b>.The added creative is awaiting for approval.';
			$content['creative_name'] = $creative_data['description'];
			$content['creative_ml']	  = 'Mobile Creative';
			$content['creative_type'] = 'Flex Creative';
			$creative_add=$this->do_message->mail_to_lib_advertiser('creative_add','campaigns',null,$content,$campaign_id);
			/***creative change for message/mail notification*****/	
			$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{					
					if($adma_id=='1')
					{
						$redirect_url=site_url('advertiser/admarket/creatives/');
					}
					else
					{
						$redirect_url=site_url('advertiser/creatives/');
					}		
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	$redirect_url,
								/*'redirect'	=> 	site_url('advertiser/creatives/add_mobile_creatives/'),*/
								);					
				}
				else
				{
					if($adma_id=='1')
					{
						//$redirect_url=site_url('admin/admarket/creatives/');
						$redirect_url=site_url('admin/creatives/creative/admarket/');						
					}
					else
					{
						$redirect_url=site_url('admin/creatives/');
					}		
					
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								/*'redirect'	=> 	site_url('admin/creatives/add_mobile_creatives/'),*/
								'redirect'	 	=> $redirect_url,    
								);	
				}
				
				$this->response( $error, 200);
			}
		}
	}
	
	/* FFMPEG EXIST OR NOT */
	public function commandExists($command) 
	{
		$command = escapeshellarg($command);
		$exists = exec("man ".$command,$out);
		return sizeof($out);
	}
	
	public function url_check($url)
	{
		$pattern = "/([A-Z0-9][A-Z0-9_-]*(?:\.[A-Z0-9][A-Z0-9_-]*)+):?(\d+)?\/?/i";

		if (preg_match($pattern, $url)) 
		  {
			return TRUE;
		  }
		else
		{
			$this->form_validation->set_message('url_check', 'Please Enter Valid url');
			return FALSE;
		}	
    }	
    public function url_creation($url)
	{
		
		if (!preg_match("~^(?:f|ht)tps?://~i", $url)) 
		{
           $site_url = "http://" . $url;
        }
        else
        {
		   $site_url = $url;	
		}	
		//$this->response($site_url,200);
		return $site_url;
    }
	
	function add_activity_log($module,$process,$banner_id=false,$campaign_id=FALSE)
	{
				/* Activity Log for Add/Edit/Delete site - Start*/				
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");							
				$account_id=$this->user_authentication->account_id;
				$adv_id =	$this->user_authentication->client_id;
				
				$activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$user_agent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,
				"module"=>$module,
				"process"=>$process,
				"advertiser_id"=>$adv_id,
				"campaign_id"=>$campaign_id,
				"banner_id"=>$banner_id,
				);		
				$this->redis_library->logcount($account_id,$activity_log);
	}
	

}
