<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 *
 * All web Adblocks will be managed here 
 *
 * @package		ADX
 * @subpackage	Web Adblocks
 * @category	Controller
 * @link		http://www.djaxadexchange.com
*/


class Mobile_adblock extends REST_Controller
{
	protected $zone_type=3;
	public $min_floor_price;
	
	function __construct()
	{
		parent::__construct();	
		
		$this->load->model('do_mobile_adblock');
		$this->load->model('do_mobile_auto_link');
		$this->min_floor_price =  $this->default_configurations->get('pub_min_floor_price');
		
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
        $this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }			
	}
 	

		
	// api.v_1/web_adblock/add/format/json
	
    public function add_post(){

		$this->form_validation->set_rules('site_name','Site Name', 'required|trim');
		$this->form_validation->set_rules('block_name','Ad Block Name', 'required|trim');
		
		if(clean_data($this->post('zone_type'))!='M_A_TXT')
		{
			$this->form_validation->set_rules('width','Width', 'required|trim');
			$this->form_validation->set_rules('height','Height', 'required|trim');
		}
		$this->form_validation->set_rules('floor_price','Floor Price', 'required|trim||greater_than_equal_to['.$this->min_floor_price.']');
		
		if($this->form_validation->run() === FALSE)
		{
			 $error_msg = $this->form_validation->error_array();			

			 $error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{			
			
			/* Fetch Affiliateid */	
			#$account_id=$this->post('account_id');
			$account_id	= 	$this->user_authentication->account_id;
			$agency_id	= 	$this->user_authentication->agency_id;
			$affiliate_id=$this->do_mobile_adblock->fetch_affiliateid($account_id);
							
			$this->db->trans_start();
			
			//delivery number
			$delivery = delivery_value(clean_data($this->post('zone_type')));
			if(clean_data($this->post('zone_type'))=="M_A_SLI" || clean_data($this->post('zone_type'))=="M_A_PULL")
			{
				$ad_position = clean_data($this->post('ad_position'));
			}
			else
			{
				$ad_position = '';
			}
			
			$add_mobile_adblockObj=array(							
										"zonename"  =>	clean_data($this->post('block_name')),
										"affiliateid"=>	$affiliate_id,
										"zonetype"	=>	$this->zone_type,
										"delivery"	=>	$delivery,
										"dj_zone_type"	=>	clean_data($this->post('zone_type')),
										"width" 	=>	clean_data($this->post('width')),
										"height"	=>  clean_data($this->post('height')),
										"dj_floor_price"		=>	clean_data($this->post('floor_price')),
										"dj_passback_tag" =>stripslashes($this->post('passback_tag')),
										"dj_added_date"=>date("Y-m-d H:i:s"),
										"dj_mobile_ad_type"=>clean_data($this->post('mobile_ad_type')),
										"dj_ad_position" =>$ad_position
								);		
							
												
												
			$zone_id=$this->do_mobile_adblock->add($add_mobile_adblockObj);				
								
			$add_mobile_adblockAssoc = array("site_id"=> clean_data($this->post('site_name')),
											"zone_id"=> $zone_id,	
									);
			
			$this->do_mobile_adblock->addAssoc($add_mobile_adblockAssoc);
			
			
			//Get the agency id
			#$agency_id = $this->post('agency_id');
			
			//Auto Linking ofZones
			$this->do_mobile_auto_link->mobile_link_ads($zone_id,$agency_id);
			
			$this->db->trans_complete();
			
			$success = array(
							'response' => 'ok',
							'msg'	 => 'Mobile Ad blocks are added successfully!..'
			);
		
						
			$this->response($success, 200);
		}

	}
	
	function zonesizelist_get()
	 {
					
		    $zone_sizes=$this->do_web_adblock->list_zonesizes();		  
		   
		   if($zone_sizes)
			{
				$this->response($zone_sizes, 200); // 200 being the HTTP response code
			}

			else
			{
				$this->response(array('error' => 'Zone Sizes could not be found'), 404);
			}
		   
	 }
	 
	/**
       * 
       * name : fetch_get()
       * 
       * @params : account_id and zone_id
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	 function fetch_get()
	 {
		   $account_id	= 	$this->user_authentication->account_id;		
		   #$account_id = $this->get('account_id');
		   $zone_id	   = $this->get('zone_id');	
		
			if($account_id){
				
				$site_list = $this->do_mobile_adblock->fetch($account_id,$zone_id);
				
				$this->response($site_list);
				
			}
	}
	
	/**
       * 
       * name : update_post()
       * 
       * @params : zone_id
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	function update_post()
	{
		$zoneid 	= clean_data($this->post('zone_id'));
		$agency_id	= 	$this->user_authentication->agency_id;	
		
		if($zoneid)
		{
			$this->form_validation->set_rules('block_name','Ad Block Name', 'required|trim');
		
			if(clean_data($this->post('zone_type'))!='M_A_TXT')
			{
				$this->form_validation->set_rules('width','Width', 'required|trim');
				$this->form_validation->set_rules('height','Height', 'required|trim');
			}
			$this->form_validation->set_rules('floor_price','Floor Price', 'required|trim');
			
			if($this->form_validation->run() ===FALSE){
			
				$error_msg = $this->form_validation->error_array();
				$error = array(
									'response' => 'error',
									'msg' =>  $error_msg
								);

				 $this->response( $error, 200);
			}else{
			
				$this->do_mobile_adblock->update(clean_data($this->post()),$agency_id);
			
				$success = array(
							'response' => 'ok',
							'redirect'=>site_url('publisher/web_ad_blocks'),
							'msg'	 => 'Web Ad blocks are updated successfully!..'
				);
			
			$this->response($success, 200);
			}	
			
		}else{
			$this->response(array('error' => 'Zone is not available for this id'), 404);	
		}
	}
	
	/**
       * 
       * name : delete_get()
       * 
       * deletes the site information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_get()
	{
		
		$zone_id = $this->get('zone_id');	
		
		if($zone_id)
		{
			$zone_id = $this->do_web_adblock->delete($zone_id);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Mobile Ad block has been deleted'
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Zone id is not found'
					);
			
			$this->response( $error, 200);
		}
	}
	
	/**
       * 
       * name : generate_adtags_post()
       * 
       * Generates the Ad tags with custom settings
       * 
       * @return the generated response
    */
	
	
	function generate_adtags_post()
	{
		
		$zone_id = clean_data($this->post('zone_id'));	
		
		if($zone_id)
		{
			
			$webadblock_tag = $this->generate_webadblock_tag(clean_data($this->post()));
			
			$this->response($webadblock_tag);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Zone id is not found'
					);
			
			$this->response( $error, 200);
		}
	}
	
	
	private function generate_webadblock_tag($values =FALSE)
	{
		if($values !='')
		{
			$zone_id = $values['zone_id'];
			$source  = $values['source'];
			
			return '<script type=\'text/javascript\'>document.write ("?zoneid='.$zone_id.'&source='.$source.'");</script>';	
		}else{
			return FALSE;	
		}	
	}
	
}
