<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Message related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Suganthi
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Message extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('do_message');
		$this->load->library('Default_configurations');
		$this->load->library('memcached_library');		
		$this->load->library('user_authentication');
		$this->load->library('notification');
	    $key=$this->input->get_post('api_key'); 
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }

	}
	
	/**
       * 
       * name : fetch_user_get()
       * 
       * Fetches all users for admin.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_user_get()
	{	
		$network_id		=	$this->user_authentication->network_account_id;
		
		$account_id		=	$this->user_authentication->account_id;
		
		$account_type	=	$this->user_authentication->account_type;
		
		$search			=	$this->get('search');
		
		if($account_id)
		{
			if($network_id)
			{
				$user 	= 	$this->do_message->fetch_user($account_id,$network_id,$account_type,$search);
			}
			else
			{
				$user 	= 	$this->do_message->fetch_user($account_id,'',$account_type,$search);
			}
			
			if($user)
			{		
				$this->response($user,200);
			}
			else
			{
				$this->response('error', 200);
			}
		}
		else
		{
			$this->response( 'error', 200);
		}
	}	
	
	function delete_notify_message_get()
	{
			$msg_id    = $this->input->get('notification_id');
			$msg_type    = $this->input->get('notification_type');
		if($msg_type == 'both')
		{
			$msg_reply = $this->do_message->notify_delete_msg($msg_id);
			$msg_reply = $this->do_message->notify_delete_center_msg($msg_id);
		}
		else if($msg_type == 'message')
		{
		 $msg_reply = $this->do_message->notify_delete_msg($msg_id);
		}
		else if($msg_type == 'notification')
		{
		$msg_reply = $this->do_message->notify_delete_center_msg($msg_id);
		}
			
			if($msg_reply)
			{
			$success 	= 	array(	'response'=> 'ok',
								'msg'		=> 'notification message has been deleted'
							);
			}
			$this->response($success , 200);
			
			
	}
	function fetch_messagenotify_list_get()
	{
		$type				=	$this->get('message_type');
		//$this->response($type,200);
		$network_id			=	$this->user_authentication->network_account_id;
		
		$account_id			=	$this->user_authentication->account_id;
		
		$user_type		=	$this->user_authentication->account_type;
		if($user_type == 'MANAGER' || $user_type == 'ADMIN')
		{
			$account_type = 'ADMIN';
		}
		else
		{
			$account_type = $user_type;
		}
		if($type=='all')
		{
		$data	=	$this->do_message->fetch_notify_message_list_all($account_id,$network_id,$account_type,$type);
		}
		else
		{
		$data	=	$this->do_message->fetch_notify_message_list($account_id,$network_id,$account_type,$type);
		}
		if($data)
		{
			$this->response($data, 200);
		}
		else
		{
			$this->response(array('error'=>'No details found'),404);
		}
		
		
	}
	/**
       * 
       * name : fetch_message_get()
       * 
       * Fetches all messages for admin.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_message_get()
	{	
		

		$network_id			=	$this->user_authentication->network_account_id;
		
		$account_id			=	$this->user_authentication->account_id;
		
		$user_type		=	$this->user_authentication->account_type;
		
		if($this->get('acctype'))
		{
			if($this->get('acctype')=='pub')
			{
				$account_type='TRAFFICKER';
			}
			else if($this->get('acctype')=='adv')
			{
				$account_type='ADVERTISER';
			}
		}
		else if($user_type == 'MANAGER' || $user_type == 'ADMIN')
		{
			$account_type = 'ADMIN';
		}
		else
		{
			$account_type = $user_type;
		}
		
		$type				=	$this->get('message_type');
		
		$id					=	$this->get('message_id');
		
		$message_center		=	$this->get('message_center');

		//$this->response(array('cnter' =>$message_center),200);
		if($type)
		{
			if($network_id)
			{
				if($id)
				{
					$user 	= 	$this->do_message->fetch_message($account_id,$network_id,$account_type,$type,$id,$message_center);
				
				}
				else
				{
					$user 	= 	$this->do_message->fetch_message($account_id,$network_id,$account_type,$type,'',$message_center);
						
				}
			}
			else
			{
				if($id)
				{
					$user 	= 	$this->do_message->fetch_message($account_id,'',$account_type,$type,$id,$message_center);
				}
				else
				{
					$user 	= 	$this->do_message->fetch_message($account_id,'',$account_type,$type,'',$message_center);
				}
			}
			
			if($user)
			{			
				$this->response($user,200);
			}
			else
			{
				$this->response( array(), 200);
			}
		}
		else
		{
			$this->response( array(), 200);
		}
	}	
	
	/*
	 * 
	 * name: attach_image_to_tmp_location_post
	 * @param
	 * @return:response array
	 * 
	 * Upload the selected web creative to a temporary location
	 * 
	 */
	
	public function update_message_status_get()
	{
		$account_id		=	$this->user_authentication->account_id;
		
		$id				=	$this->get('message_id');
		
		if($id)
		{
			$update		=	$this->do_message->update_message_status($account_id,$id);

			$this->response($update,200);
		}
		
	}
	
	/*
	 * 
	 * name: unread_message_count_post
	 * @param
	 * @return:response array
	 * 
	 * Get Messages for user
	 * 
	 */
	
	public function unread_message_count_post()
	{
		//$account_id		=	clean_data($this->post('account_id'));
		
		$user_type	=	clean_data($this->post('account_type'));
		if($user_type =="MANAGER" || $user_type=="ADMIN")
		{
			$account_type= "ADMIN";
		}
		else
		{
			$account_type= clean_data($this->post('account_type'));
		}
		if($account_type=="ADMIN" || $account_type=="MANAGER")
		{
			$agency_id 	 =	$this->user_authentication->agency_id;
			$account_id  =	$this->do_message->fetch_receiever($agency_id);
		}
		else
		{
			$account_id		=	clean_data($this->post('account_id'));
		}
		
		if($account_id && $account_type)
		{
			$count	=	$this->do_message->fetch_unread_message_count($account_id,$account_type);

			if($count)
			{	
				$success	=	array(
									'response'	=>	'ok',
									'msg'		=>	$count
									);	
				$this->response($success,200);
			}
			else
			{
				$error	=	array(
									'response'	=>	'error',
									'msg'		=>	'0'
									);	
				$this->response( $error, 200);
			}
		}
		else
		{
			$error	=	array(
								'response'	=>	'error',
								'msg'		=>	'0'
								);	
			$this->response( $error, 200);
		}
		
	}
	
	
	/*
	 * 
	 * name: message_notify_post
	 * @param
	 * @return:response array
	 * 
	 * Get Messages for user
	 * 
	 */
	
	public function message_notify_post()
	{
		//$account_id		=	$this->post('account_id');
		
		$user_type	=	clean_data($this->post('account_type'));
		if($user_type =="MANAGER" || $user_type=="ADMIN")
		{
			$account_type= "ADMIN";
		}
		else
		{
			$account_type= clean_data($this->post('account_type'));
		}
		if($account_type=="ADMIN" || $account_type=="MANAGER")
		{
			$agency_id 	 =	$this->user_authentication->agency_id;
			$account_id  =	$this->do_message->fetch_receiever($agency_id);
		}
		else
		{
			$account_id		=	clean_data($this->post('account_id'));
		}
		
		if($account_id && $account_type)
		{
			$message	=	$this->do_message->fetch_message_notify($account_id,$account_type);

			if($message)
			{	
				$success	=	array(
									'response'	=>	'ok',
									'msg'		=>	$message
									);	
				$this->response($success,200);
			}
			else
			{
				$error	=	array(
									'response'	=>	'error',
									'msg'		=>	''
									);	
				$this->response( $error, 200);
			}
		}
		else
		{
			$error	=	array(
								'response'	=>	'error',
								'msg'		=>	''
								);	
			$this->response( $error, 200);
		}
		
	}
	
	
	/*
	 * 
	 * name: attach_image_to_tmp_location_post
	 * @param
	 * @return:response array
	 * 
	 * Upload the selected web creative to a temporary location
	 * 
	 */
	
	public function delete_post()
	{
		$del_msg_id			=	clean_data($this->post('del_msg_id'));
		
		$del_type			=	clean_data($this->post('del_type'));
		
		if($del_msg_id)
		{
			$msg_id	=	explode(',',$del_msg_id);
			
			if(is_array($msg_id))
			{
				foreach($msg_id as $id)
				{
					$delete	=	$this->do_message->delete($id,$del_type);
				}
			}
			else
			{
				$delete	=	$this->do_message->delete($msg_id,$del_type);
			}

			if($delete)
			{	
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Message has been deleted successfully!..'
								);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
								);
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: attach_image_to_tmp_location_post
	 * @param
	 * @return:response array
	 * 
	 * Upload the selected web creative to a temporary location
	 * 
	 */
	public function attach_image_to_tmp_location_post()
	{
		if($_FILES['attachment'])
		{
			$attachment		=	array(
								'file_name' => 	$_FILES['attachment']['name'],
								'tmp_name' 	=> 	$_FILES['attachment']['tmp_name'], 
								);
					
			$tmp_attach	=	$this->image_lib->move_attach_image_to_tmp_location($attachment);
			
			if($tmp_attach)
			{
				$success=	array(
								'response' 	=> 	$tmp_attach['upload_data'],
								'msg'	 	=> 	'Moved to temporary location'
				);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' 	=> 	'error',
								'redirect'	=>	site_url('admin/messages/messages'),
								'msg'	 	=> 	'Unable to move to temporary location '
				);
				$this->response($error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: attach_image_to_tmp_location_post
	 * @param
	 * @return:response array
	 * 
	 * Upload the selected web creative to a temporary location
	 * 
	 */
	public function attach_file_to_tmp_location_post()
	{
		if($_FILES['attachment'])
		{
			$attachment		=	array(
								'file_name' => 	$_FILES['attachment']['name'],
								'tmp_name' 	=> 	$_FILES['attachment']['tmp_name'], 
								);
					
			$tmp_attach	=	$this->image_lib->move_attach_file_to_tmp_location($attachment);

			if($tmp_attach)
			{
				$success=	array(
								'response' 	=> 	$tmp_attach['upload_data'],
								'msg'	 	=> 	'Moved to temporary location'
				);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' 	=> 	'error',
								'redirect'	=>	site_url('admin/messages/messages'),
								'msg'	 	=> 	'Unable to move to temporary location '
				);
				$this->response($error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: delete_a_creative
	 * @param :
	 * @return :response array
	 * 
	 * Delete the creative in its original location
	 */
	
	public function delete_a_attach_post()
	{
		$tmp_attach_name	=	clean_data($this->post('attach_name'));
		
		if($tmp_attach_name)
		{
			$is_tmp_attach	=	$this->image_lib->delete_attach_in_original_location($tmp_attach_name);

			if($is_tmp_attach)
			{
				$success 	= 	array(
								'response' 	=> 	'success',
								'msg'	 	=> 	'Temporary attachment deleted'
								);
				$this->response($success, 200);
			}
			else
			{
				$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Unable to delete the temporary attachment file'
								);
				$this->response($error, 200);
			}
		}
		else
		{
			$error 	= 	array(
							'response' 	=> 	'error',
							'msg'	 	=> 	'Unable to delete the temporary location file'
							);
			$this->response($error, 200);
		}
	}
	/*
	 * 
	 * name: delete_a_tmp_creative
	 * @param :
	 * @return :response array
	 * 
	 * Delete the creative in temporary location
	 */
	
	public function delete_a_tmp_attach_post()
	{
		$tmp_attach_name	=	clean_data($this->post('attach_name'));
		
		if($tmp_attach_name)
		{
			$is_tmp_attach	=	$this->image_lib->delete_attach_in_tmp_location($tmp_attach_name);

			if($is_tmp_attach)
			{
				$success 	= 	array(
								'response' 	=> 	'success',
								'msg'	 	=> 	'Temporary attachment deleted'
								);
				$this->response($success, 200);
			}
			else
			{
				$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Unable to delete the temporary attachment file'
								);
				$this->response($error, 200);
			}
		}
		else
		{
			$error 	= 	array(
							'response' 	=> 	'error',
							'msg'	 	=> 	'Unable to delete the temporary location file'
							);
			$this->response($error, 200);
		}
	}
	
	/*
	 * 
	 * name: send_post
	 * @param :
	 * @return :response array
	 * 
	 * send message to selected user
	 */
	
	public function send_post()
	{
		
		//echo "post<pre>";print_r($_POST);exit();
		$account_type			=	$this->user_authentication->account_type;
		
		if($account_type=='ADMIN' || $account_type=='MANAGER')
		{
			$this->form_validation->set_rules('account_id[]','User', 'required');
		}
		$this->form_validation->set_rules('subject', 'Subject','required|trim');
		$this->form_validation->set_rules('msg_content', 'Content', 'required|trim');

		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg["msg_content"]
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$upload	=	clean_data($this->post('attach_type'));
									
			if($upload=='image')
			{			   
				if(clean_data($this->post('tmp_image_upload'))!='')
				{
					$is_attach_moved	=	$this->image_lib->move_attach_to_original_location(clean_data($this->post('tmp_image_upload')));
															
					$image_name			=	clean_data($this->post('tmp_image_upload'));
					
					$file_name			=	NULL;
				}
				else
				{
					$image_name			=	NULL;
					$file_name			=	NULL;
				}
			}
			else if($upload=='file')
			{
				if(clean_data($this->post('tmp_file_upload'))!='')
				{
					$is_attach_moved	=	$this->image_lib->move_attach_to_original_location($this->post('tmp_file_upload'));
					
					$file_name			=	clean_data($this->post('tmp_file_upload'));
					
					$image_name			=	NULL;
				}
				else
				{
					$image_name			=	NULL;
					$file_name			=	NULL;
				}
			}
			else
			{
				$image_name			=	NULL;
				$file_name			=	NULL;
			}
			
			
			$agency_id				=	$this->user_authentication->agency_id;
			#$account_id 				=	$this->do_message->fetch_receiever($agency_id);
			$account_id 				=	$this->user_authentication->account_id;
			if($account_type=='TRAFFICKER') 
			{ 
				$affiliate_id			=	$this->user_authentication->affiliate_id;
			
				$user_details = $this->do_message->get_affiliate($affiliate_id); 
			
			} 
			else{
				$user_details = $this->do_message->get_profile($account_id); 
			}
		
			$network_id				=	$this->do_message->fetch_admin_network_id();
						
			$msg_type = $this->default_configurations->get('message_type');		
			//sandhiya handled for saving admarket message types in db
			$is_admarket	=	clean_data($this->post('admarketval'));
			$dj_is_admarket = (!empty($is_admarket)) ? 1 :0;
			if($account_type=='ADMIN' || $account_type=='MANAGER')
			{
				$account			=	clean_data($this->post('account_id')); 
				
				foreach($account as $key=>$value)
				{	
					$user				=	explode('-',$value);
					$receiver_type		=	$user[0];
					$receiver_id		=	$user[1];

					$reciever= array();
					$reciever[0]=$user[2];
					$reciever[1]=$user[3];
					
					
					$message_data		=	array(
											'sender_id'		=>	$account_id,
											'receiver_id'	=>	$receiver_id,
											'subject'		=>	clean_data($this->post('subject')),
											'content'		=>	trim(strip_tags(trim($this->post('msg_content')))),
											'image_name'	=>	$image_name,
											'file_name'		=>	$file_name,
											'account_type'	=>	$receiver_type,
											'status'		=>	'1',
											'network_id'	=>	$network_id,
											'dj_is_admarket' => $dj_is_admarket,			
											'date'			=>	date('Y-m-d H:i:s')
											);
								
					$message_add = 	$this->do_message->add($message_data,$user_details,$reciever,$msg_type);
						
				}
			}
			else
			{
				
				$get_mail = unserialize(base64_decode($_POST['receiver_email']));
				$reciever_mail[0] = $get_mail[0]['email'];		
				$reciever_mail[1] = $get_mail[0]['name'];		
				$message_data		=	array(
											'sender_id'		=>	$this->user_authentication->account_id,
											'receiver_id'	=>	clean_data($this->post('receiver_id')),
											'subject'		=>	clean_data($this->post('subject')),
											'content'		=>	trim(strip_tags(trim($this->post('msg_content')))),
											'image_name'	=>	$image_name,
											'file_name'		=>	$file_name,
											'account_type'	=>	'ADMIN',
											'status'		=>	'1',
											'network_id'	=>	$network_id,								
											'dj_is_admarket' => $dj_is_admarket,	
											'date'			=>	date('Y-m-d H:i:s')
											);
											
			
					
				$message_add 	= 	$this->do_message->add($message_data,$user_details,$reciever_mail,$msg_type); 
			}
			//$this->response(unserialize(base64_decode($sender_email)),200);
			if($network_id)
			{
				$sent		=	$this->do_message->fetch_message($account_id,$network_id,$account_type,'sent');
			}
			else
			{
				$sent		=	$this->do_message->fetch_message($account_id,'',$account_type,'sent');
			}
			
			$sent_count	=	($sent!=FALSE)?count($sent):'';
			
			if($message_add != FALSE)
			{	
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Message has been sent successfully!..',
									'count'		=>	$sent_count
								);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
								);
				$this->response( $error, 200);
			}
						
		}
	}
	
	/*
	 * 
	 * name: reply_post
	 * @param :
	 * @return :response array
	 * 
	 * reply message to selected user
	 */
	
	public function reply_post()
	{
		$this->form_validation->set_rules('subject', 'Subject','required|trim');
		$this->form_validation->set_rules('reply_msg_content', 'Content', 'required|trim');

		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$upload	=	clean_data($this->post('attach_type'));
			if($upload=='image')
			{
				if(clean_data($this->post('tmp_image_upload'))!='')
				{
					$is_attach_moved	=	$this->image_lib->move_attach_to_original_location(clean_data($this->post('tmp_image_upload')));
					
					$image_name			=	clean_data($this->post('tmp_image_upload'));
					
					$file_name			=	NULL;
				}
				else
				{
					$image_name			=	NULL;
					$file_name			=	NULL;
				}
			}
			else if($upload=='file')
			{
				if(clean_data($this->post('tmp_file_upload'))!='')
				{
					$is_attach_moved	=	$this->image_lib->move_attach_to_original_location(clean_data($this->post('tmp_file_upload')));
					
					$file_name			=	clean_data($this->post('tmp_file_upload'));
					
					$image_name			=	NULL;
				}
				else
				{
					$image_name			=	NULL;
					$file_name			=	NULL;
				}
			}
			else
			{
				$image_name			=	NULL;
				$file_name			=	NULL;
			}
			
			//$account_id				=	get_session('account_id');
			//$network_id				=	get_session('network_account_id');
			//$account_type				=	get_session('account_type');
			
			//$agency_id					=	$this->post('agency_id');
			//$account_id 				=	$this->do_message->fetch_receiever($agency_id);
		
			//$network_id				=	get_session('network_account_id');	
			if($this->user_authentication->account_type=='ADMIN' || $this->user_authentication->account_type=='MANAGER')
			{
				$agency_id					=	$this->user_authentication->agency_id;
				$account_id 				=	$this->do_message->fetch_receiever($agency_id);
			}
			else
			{
				$account_id 			=	$this->user_authentication->account_id;
			}

			$affiliate_id				=	$this->user_authentication->affiliate_id;
			$network_id				    =	$this->do_message->fetch_admin_network_id();
			
			$type                       =   ((clean_data($this->post('receiver_type'))=='MANAGER')?'ADMIN':clean_data($this->post('receiver_type')));
			if($this->user_authentication->account_type=='TRAFFICKER')
			{
				$user_details = $this->do_message->get_affiliate($affiliate_id); 
			
			}
			else{
				
				$user_details = $this->do_message->get_profile($account_id); 
			}
						
			$message_data			    =	array(
										'sender_id'		=>	$account_id,
										'receiver_id'	=>	clean_data($this->post('receiver_id')),
										'subject'		=>	clean_data($this->post('subject')),
										'content'		=>	trim(strip_tags(trim($this->post('reply_msg_content')))),
										'image_name'	=>	$image_name,
										'file_name'		=>	$file_name,
										'account_type'	=>  $type,	
										'status'		=>	'1',
										'network_id'	=>	$network_id,									
										'date'			=>	date('Y-m-d H:i:s')
										);
				$msg_type = $this->default_configurations->get('message_type');			
				//$this->response( $sender_email, 200);				
					$sender_email[0]	=	'djax_testing1@dreamajax.com';
					$sender_email[1]	=	'dJAX - Admin Administrator';				
				$message_add 		= 	$this->do_message->add($message_data,$user_details,$sender_email,$msg_type); 
										
			//$message_reply 	= 	$this->do_message->add($message_data);
			
			$account_type	=	$this->user_authentication->account_type;
			
			if($network_id)
			{
				$sent		=	$this->do_message->fetch_message($account_id,$network_id,$account_type,'sent');
			}
			else
			{
				$sent		=	$this->do_message->fetch_message($account_id,'',$account_type,'sent');
			}			
			
			$sent_count		=	($sent!=FALSE)?count($sent):'';
			//$this->response( $message_add, 200);
			if($message_add != FALSE)
			{	
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Reply Message has been sent successfully!..',
									'count'		=>	$sent_count
								);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
								);
				$this->response( $error, 200);
			}
						
		}
	}
	
	
	/*
	 * 
	 * name: delete_trash_post
	 * @param :
	 * @return success
	 * 
	 * Delete the message permanent from djax_message
	 */
	public function delete_trash_post()
	{
	    $del_msg_id			=	clean_data($this->post('del_msg_trash_id'));
		
		if($del_msg_id)
		{
			$msg_id	=	explode(',',$del_msg_id);
			
			if(is_array($msg_id))
			{
				foreach($msg_id as $id)
				{
					$delete	=	$this->do_message->delete_trash($id);
				}
			}
			else
			{
				$delete	=	$this->do_message->delete_trash($msg_id);
			}

			if($delete)
			{	
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Message has been deleted from trash successfully!..'
								);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
								);
				$this->response( $error, 200);
			}
		}
	}
	
	/*
	 * 
	 * name: fetch_receiever_id
	 * @param :
	 * @return success
	 * 
	 * Delete the message permanent from djax_message
	*/
	public function fetch_receiever_id_get()
	{
		$agency_id = $this->user_authentication->agency_id;
		if($agency_id)
		{
			$receiver = $this->do_message->fetch_receiever($agency_id);	
			$this->response($receiver, 200);
			if($receiver)
			{
				$this->response($receiver, 200);
			}
			else
			{
				$this->response(array('error'=>'No Agency Id'),404);
			}	
		}
		else
		{
			$this->response(array('error'=>'No Agency Id'),404);
		}
	}
	/*
	 * 
	 * name: fetch_receiever_DETAILS
	 * @param :
	 * @return success
	 * 
	 * Delete the message permanent from djax_message
	*/
	public function fetch_data_get()
	{
		$agency_id = $this->user_authentication->agency_id;
		
		if($agency_id)
		{
			
			$receiver = $this->do_message->fetch_receiever_det($agency_id);	
			
			if($receiver)
			{
				$this->response($receiver,200);
			}
			else
			{
				$this->response(array('error'=>'No Agency Id'),404);
			}	
		}
		else
		{
			$this->response(array('error'=>'No Agency Id'),404);
		}
	}
	
	public function fetch_network_id_get()
	{
		$network_id = $this->do_message->fetch_admin_network_id();
		$this->response($network_id,200);
	}
	function fetch_messagenotify_preview_get()
	{
		$id				=	$this->get('id');
				
		$data	=	$this->do_message->fetch_notify_message_preview($id);
		$this->response($data, 200);
		
	}
	function fetch_publishers_list_get()
	{
		$campaignid			=	$this->get('campaignid');
		$step				=   $this->get('step');
		$network_id			=	$this->user_authentication->network_account_id;		
		$account_id			=	$this->user_authentication->account_id;	
		$user_type			=	$this->user_authentication->account_type;
		if($user_type == 'MANAGER' || $user_type == 'ADMIN')
		{
			$account_type = 'ADMIN';
		}
		else
		{
			$account_type = $user_type;
		}
		
		$data	=	$this->do_message->fetch_publishers_list($account_id,$network_id,$account_type,$campaignid,$step);
		
		if($data)
		{
			$this->response($data, 200);
		}
		else
		{
			$this->response(array('error'=>'No details found'),404);
		}	
		
	}
	
	function fetch_publisher_details_get()
	{
		$site_id=$this->get('site_id');
		$data	=	$this->do_message->fetch_publisher_details($site_id); 
		
		if($data)
		{
			$this->response($data, 200);
		}
		else
		{
			$this->response(array('error'=>'No details found'),404);
		}
	}
	function fetch_campaign_details_get()
	{
		$site_id=$this->get('site_id');
		$data	=	$this->do_message->fetch_campaign_details($site_id); 
		
		if($data)
		{
			$this->response($data, 200);
		}
		else
		{
			$this->response(array('error'=>'No details found'),404);
		}
	}
}
