<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Manager related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Suganthi
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Manager extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->library('redis_library');		
		$this->load->model('do_manager');
		$this->load->model('do_email_check');
		$this->load->model('do_networks');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->model('do_network_managers');
		$this->load->model('do_roles');
		$this->load->library('user_authentication');
		$this->load->model('do_app_config');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	} 
	
	/**
       * 
       * name : fetch_get()
       * 
       * Fetches all manager information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_get()
	{	
		$account_id		=	$this->user_authentication->account_id;
		
		if($account_id!='')
		{
			$manager 	= 	$this->do_manager->fetch($account_id);
		}
		 
		if($manager)
		{
			$this->response($manager,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	
	
	function fetch_all_manager_get()
	{
	  $manager 	= 	$this->do_manager->fetch();
	  if($manager)
		{
			$this->response($manager,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	/**
   * 
   * name : fetch_manager_details()
   * 
   * Fetches all manager information.
   * 
   * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	public function fetch_manager_details_get()
	{
	   $account_id	= $this->user_authentication->account_id;
       $manager_name=$this->do_manager->fetch_manager_details($account_id);
	   if($manager_name){ 
	     $this->response($manager_name,200);
		 }
	}
	
	//api/v1/manager/add
	function add_post()
	{	
		$this->form_validation->set_rules('manager_name','Manager Name', 'required|trim|first_alpha_check|alpha_numeric_dash_space');
		$this->form_validation->set_rules('email', 'Email Address', 'required|trim|is_email|callback_email_check');
		#$this->form_validation->set_rules('manager_role', 'Manager Role','required|trim');
		$this->form_validation->set_rules('password', 'Password','required|trim');
		$this->form_validation->set_rules('confirm_password', 'Confirm Password','required|trim|matches[password]');
		
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$add_data		=	array(
									'name'		=>	clean_data($this->post('manager_name')),
									'email'		=>	clean_data($this->post('email')),
									#'role'		=>	$this->post('manager_role'),
									'password'	=>	md5(clean_data($this->post('password'))),
									'manager_share'=> clean_data($this->post('manager_share'))
									);
			$manager_add 	= 	$this->do_manager->add_manager($add_data);
			
			if($manager_add != FALSE)
			{	
				//SEND MAIL TO THE ADDED MANAGER
				$result=$this->do_networks->get_network_details();			
				$admin_name    = $result['firstname']." ".$result['lastname'];			
				$admin_email   = $result['email'];
				$user_email    = clean_data($this->post('email'));
				$password      = clean_data($this->post('password'));
				$user_name     = clean_data($this->post('manager_name'));
				$type     	   = "ADD_MANAGER_EMAIL";
				$from 	       =  $admin_email;
				//$to  	       =  $user_email;
				//$to='suganiya.r@dreamajax.com';
				$to='arunkarthik.c@dreamajax.com';
				$mail_content=array(
					"subject" 		=> "Manager Information",
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email,
					"password"      => $password,
					"demo_adv_username"  	=> 'adv_'.$user_email,
					"demo_adv_password"     => $password,
					"demo_pub_username"  	=> 'pub_'.$user_email,
					"demo_pub_password"     => $password,
					"manager_share"   => clean_data($this->post('manager_share'))						
					);
				
				$attachement='';	
    			send_mail($type,$from,$to,$mail_content,$attachement);
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Manager has been added successfully!..'
								);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
								);
				$this->response( $error, 200);
			}
						
		}
	}
	
	
	/**
       * 
       * name : update_post()
       * 
       * Updates the site information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	function update_post()
	{
		$account_id	=	clean_data($this->post('account_id'));
		
		$this->form_validation->set_rules('manager_name','Manager Name', 'required|trim|first_alpha_check|alpha_numeric_dash_space');
		$this->form_validation->set_rules('email', 'Email Address', 'required|trim|is_email|callback_edit_email_check');
		#$this->form_validation->set_rules('manager_role', 'Manager Role','required|trim');
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			$this->response( $error, 200);
		}
		else
		{
			$update_data	=	array(
									'name'		=>	clean_data($this->post('manager_name')),
									'email'		=>	clean_data($this->post('email')),
									#'role'		=>	clean_data($this->post('manager_role')),
									'manager_share'=>clean_data($this->post('manager_share'))
									);
									
			$manager_update = $this->do_manager->update($account_id,$update_data);
			
			if($manager_update != FALSE)
			{	
			    //SEND MAIL TO THE UPDATED MANAGER
				$result=$this->do_networks->get_network_details();			
				$admin_name    = $result['firstname']." ".$result['lastname'];			
				$admin_email   = $result['email'];
				$user_email    = clean_data($this->post('email'));
				$user_name     = clean_data($this->post('manager_name'));
				#$role				=	$this->post('manager_role');
				$type     	   = "UPDATE_MANAGER_EMAIL";
				$from 	       =  $admin_email;
				$to  	       =  $user_email;			
				$mail_content=array(
					"subject" 		 => "Manager Updated Information",
					"to_name" 	=> $user_name,				
					"from_name"	 => $admin_name,
					"email"  		=> $user_email,
					"manager_share"   => clean_data($this->post('manager_share'))						
					);
				$attachement='';	
    			send_mail($type,$from,$to,$mail_content,$attachement,$from);
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Manager has been updated successfully!..'
									);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
									);
				$this->response( $error, 200);
			}			
		}
	}
	
	/*
	 * 
	 * name: email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	
	public function email_check()
	{
		$email		=	clean_data($this->post('email'));
		
		$count		=	$this->do_email_check->dup_email_check($email);		
			   
		if($count>0 )
		{
			$this->form_validation->set_message('email_check', "This Email address already Exists");
			return FALSE;	
		}
		else
		{
			return true;
		}
	}	
	
	/*
	 * 
	 * name: edit_email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	function edit_email_check()
	{
		$account_id	=	clean_data($this->post('account_id'));
		$email		=	clean_data($this->post('email'));
		$count 		= 	$this->do_email_check->dup_email_check($email,$account_id);
		
		if($count>0 )
		{
			$this->form_validation->set_message('edit_email_check', "This Email address already Exists");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	/**
       * 
       * name : delete_get()
       * 
       * deletes the manager information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_get()
	{	
		$account_id = $this->get('del_account_id');	
		
		if($account_id)
		{
	         //GET MANAGER DETAILS	
			$manager_details=$this->do_manager->fetch($account_id);
			$manager 	= 	$this->do_manager->remove($account_id);
			if($manager)
			{
			     //SEND MAIL TO THE DELETED MANAGER
				$result=$this->do_networks->get_network_details();			
				$admin_name    = $result['firstname']." ".$result['lastname'];			
				$admin_email   = $result['email'];
				$user_email    = $manager_details[0]['email'];
				$user_name     =$manager_details[0]['name'];
				$type     	   = "DELETE_MANAGER_ACCOUNT";
				$from 	       =  $admin_email;
				$to  	       =  $user_email;			
				$mail_content=array(
					"subject" 		 => "Your Account is De-activated",
					"to_name" 	=> $user_name,				
					"from_name"	 => $admin_name,
					"email"  		=> $user_email,
					);
				$attachement='';	
    			send_mail($type,$from,$to,$mail_content,$attachement,$from);
				$success 	= 	array('response'	=> 	'ok',
									  'msg'			=> 	'Manager has been deleted successfully..'
									);
				
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Error..Please Try again.'
								);
			
				$this->response( $error, 200);
			}
			
		}
		else
		{
			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Manager does not found.'
								);
			
			$this->response( $error, 200);
		}
	}
	
	/**
       * 
       * name : block_get()
       * 
       * block the manager information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function block_get()
	{	
		$account_id = $this->get('block_account_id');	
		
		if($account_id)
		{
			$manager 	= 	$this->do_manager->block($account_id);
			
			if($manager)
			{
			   
			    $manager_details 	= 	$this->do_manager->fetch($account_id);
				//SEND MAIL TO THE BLOCKED MANAGER
				$result=$this->do_networks->get_network_details();			
				$admin_name    = $result['firstname']." ".$result['lastname'];			
				$admin_email   = $result['email'];
				
				//GET MANAGER DETAILS FOR BCC
				$no_of_managers_id = $this->do_networks->get_managers_list($account_id);
				foreach($no_of_managers_id as $agency)
				{
					$user_email    = $agency['email'];
					$user_name     = $agency['name'];
					$type     	   = "BLOCK_MANAGER_ACCOUNT";
					$from 	       =  $admin_email;
					$to  	       =  $user_email;			
					$mail_content=array(
						"subject" 		=> "Manager Blocked",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						);
					$attachement='';	
					send_mail($type,$from,$to,$mail_content,$attachement,$from);
					$success 	= 	array('response'	=> 	'ok',
										'msg'			=> 	'Manager has been blocked successfully..'
										);
				}
				
				$this->response( $success, 200);
			}
			else
			{
				
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
									);
				
				$this->response( $error, 200);
			}
			
		}
		else
		{
			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Manager does not found.'
								);
			
			$this->response( $error, 200);
		}
	}
	
	/**
       * 
       * name : unblock_get()
       * 
       * block the manager information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function unblock_get()
	{	
		$account_id = $this->get('unblock_account_id');	
		
		if($account_id)
		{
			$manager 	= 	$this->do_manager->unblock($account_id);
			
			if($manager)
			{
				
				$manager_details 	= 	$this->do_manager->fetch($account_id);
				//SEND MAIL TO THE UN-BLOCKED MANAGER
				$result=$this->do_networks->get_network_details();			
				$admin_name    = $result['firstname']." ".$result['lastname'];			
				$admin_email   = $result['email'];
				
				//GET MANAGER DETAILS FOR BCC
				$no_of_managers_id = $this->do_networks->get_managers_list($account_id);
				foreach($no_of_managers_id as $agency)
				{
					$user_email    = $agency['email'];
					$user_name     = $agency['name'];
					$type     	   = "UNBLOCK_MANAGER_ACCOUNT";
					$from 	       =  $admin_email;
					$to  	       =  $user_email;			
					$mail_content=array(
						"subject" 		=> "Manager Un-Blocked",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						);
					$attachement='';	
					send_mail($type,$from,$to,$mail_content,$attachement,$from);
				}
				$success 	= 	array('response'	=> 	'ok',
									  'msg'			=> 	'Manager has been unblocked successfully..'
									);
				
				$this->response( $success, 200);
			}
			else
			{
				
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
									);
				
				$this->response( $error, 200);
			}
			
		}
		else
		{			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Manager does not found.'
								);
			
			$this->response( $error, 200);
		}
	}
	
	
	/**
       * 
       * name : fetch_users_get()
       * 
       * Fetches all manager users information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_users_get()
	{
		
		$account_id		=	$this->user_authentication->account_id;
		
		if($account_id!='')
		{
			$manager 	= 	$this->do_manager->fetch_users($account_id);
		}
		 
		$this->response($manager,200);
		
	}
	
	/****
	 * 
	 * method : fetch_roles
	 * 
	 * Fetch the roles for the administrator
	 * 
	 * 
	 */
	function fetch_roles_get()
	{
		$roles = $this->do_manager->fetch_roles();
		
		$this->response($roles,200);
			
	}
	
	
	/****
	 * 
	 * method : edit_fetch_roles
	 * 
	 * Fetch the roles for the administrator
	 * 
	 * get all roles even it blocked
	 */
	function edit_fetch_roles_get()
	{
		$roles = $this->do_manager->edit_fetch_roles();
		
		$this->response($roles,200);
			
	}
	
	
	/****
	 * 
	 * method : add_user
	 * 
	 * Adds the manager user
	 * 
	 * 
	 */
	function add_user_post()
	{	
		$this->form_validation->set_rules('manager_name','Manager Name', 'required|trim|first_alpha_check|alpha_numeric_dash_space');
		$this->form_validation->set_rules('email', 'Email Address', 'required|trim|is_email|callback_email_check');
		$this->form_validation->set_rules('manager_role', 'Manager Role','required|trim');
		$this->form_validation->set_rules('password', 'Password','required|trim');
		$this->form_validation->set_rules('confirm_password', 'Confirm Password','required|trim|matches[password]');
		
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			
			if(clean_data($this->post('manager_role'))==4)
			 {
				 if($this->post('adv_id')!='')
				 {
					 $adv_pub_assoc= implode(',', clean_data($this->post('adv_id')));
				 }
				 else
				 {
					 $adv_pub_assoc= "";
				 }
				 
			 }
			 else if(clean_data($this->post('manager_role'))==5)
			 {
				 if(clean_data($this->post('pub_id'))!='')
				 {
					$adv_pub_assoc= implode(',', clean_data($this->post('pub_id')));
				  }
				  else
				  {
					  $adv_pub_assoc = "";
				  }
				 
			 }
			 else
			 {
				 $adv_pub_assoc="";
			 }
			$add_data		=	array(
									'name'		=>	clean_data($this->post('manager_name')),
									'email'		=>	clean_data($this->post('email')),
									'role_id'		=>	clean_data($this->post('manager_role')),
									'adv_pub_assoc' => $adv_pub_assoc,
									'password'	=>	md5(clean_data($this->post('password'))),
									'manager_account_id'=> clean_data($this->post('man_account_id'))
									);
			$manager_add 	= 	$this->do_manager->add_manager_user($add_data); // RETURN USER_ID
			//FETCH MANAGER ROLE NAME
			$manager_role 	= 	$this->do_roles->fetch_role(clean_data($this->post('manager_role')));
			
			    /* Activity Log for Manager Add- Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,MANAGER_ADD);
				if($enable=='1')
				{							
				$this->activity_log(MANAGER,ADD,$manager_add);
				}
				/* Activity Log for Manager Add- End*/
				
			
			
			
			if($manager_add != FALSE)
			{	
				//SEND MAIL TO THE ADDED MANAGER
				if($this->user_authentication->account_type == "ADMIN" )
				{
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);	
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					// Get MANAGER EMAIL FOR BCC
					$manager_email = $this->do_networks->get_manager_emailID($manager_add);
					$bcc =$manager_email;
				}
				else
				{
					$manager_user_id = $this->user_authentication->manager_user_id;
					$is_manager = $this->do_networks->get_manager_role($manager_user_id);
					if($is_manager == 1)
					{
						// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->do_networks->agency_owner_details($agency_id);
						$admin_name    = $result['name'];			
						$admin_email   = $result['email'];
						// IF NOT NETWORK ADMIN ADMIN SEND BCC
						$network_admin=$this->do_networks->get_network_details();
						$bcc		   = $network_admin['email'];
					}
					else
					{	
						// MANAGER USERS
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->do_networks->agency_owner_details($agency_id);
						$admin_name    = $result['name'];			
						$admin_email   = $result['email'];
						
						// Get MANAGER EMAIL FOR BCC
						$manager_email = $this->do_networks->get_manager_emailID($manager_add);
						$bcc =$manager_email;
					}
				}
				
				$user_email    = clean_data($this->post('email'));
				$password      = clean_data($this->post('password'));
				$role          = $manager_role[0]['role_name'];
				$user_name     = clean_data($this->post('manager_name'));
				$type     	   = "ADD_USER_MANAGER_EMAIL";
				$from 	       =  $admin_email;
				$to  	       =  $user_email;			
				$mail_content=array(
					"subject" 		=> "Login Information",
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"role"   		=> $role,
					"email"  		=> $user_email,
					"password"      => $password						
					);
				$attachement='';	
    			send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Manager has been added successfully!..'
								);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
								);
				$this->response( $error, 200);
			}
						
		}
	}
	
    /****
	 * 
	 * method : fetch_manager_users_get
	 * 
	 * get the manager user
	 * 
	 * 
	 */
	public function fetch_manager_users_get()
	{ 
	  $user_id=$this->get('user_id');
	  $account_id=$this->get('account_id');
	  $manager_users 	= 	$this->do_manager->fetch_manager_users($user_id,$account_id);
	  if($manager_users)
	  {
	  	$this->response( $manager_users, 200); 
	  }
	}
	
	
	/****
	 * 
	 * method : update_user_post
	 * 
	 * update the manager user
	 * 
	 * 
	 */
	function update_user_post()
	{	
		$this->form_validation->set_rules('manager_name','Manager Name', 'required|trim|first_alpha_check|alpha_numeric_dash_space');
		$this->form_validation->set_rules('manager_role', 'Manager Role','required|trim');
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			 if(clean_data($this->post('manager_role'))==4)
			 {
				 if(clean_data($this->post('adv_id'))!='')
				 {
					$adv_pub_assoc= implode(',', clean_data($this->post('adv_id')));
				 }
				 else
				 {
					  $adv_pub_assoc= "";
				 }
				 
			 }
			 else if(clean_data($this->post('manager_role'))==5)
			 {
				 if(clean_data($this->post('pub_id'))!='')
				 {
					$adv_pub_assoc= implode(',', clean_data($this->post('pub_id')));
				  }
				  else
				  {
					  $adv_pub_assoc = "";
				  }
				 
			 }
			 else
			 {
				 $adv_pub_assoc="";
			 }
			 
			$update_data		=	array(
									'name'		=>	clean_data($this->post('manager_name')),
									'email'		=>	clean_data($this->post('email')),
									'role_id'		=>	clean_data($this->post('manager_role')),
									'adv_pub_assoc' => $adv_pub_assoc,
									'manager_account_id'=> clean_data($this->post('account_id')),
									'user_id'=> clean_data($this->post('user_id'))
									); 
									#print_r($update_data);exit;
			$update_add 	= 	$this->do_manager->update_manager_user($update_data);
			
			
			 /* Activity Log for Manager Edit- Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,MANAGER_EDIT);
				if($enable=='1')
				{							
				$this->activity_log(MANAGER,EDIT,$this->post('user_id'));
				}
				/* Activity Log for Manager Edit- End*/			
			
			
			//FETCH MANAGER ROLE NAME
			$manager_role 	= 	$this->do_roles->fetch_role(clean_data($this->post('manager_role')));
			if($update_add != FALSE)
			{	
				//SEND MAIL TO THE UPDATE USER
				$result=$this->do_networks->get_network_details();			
				$admin_name    = $result['firstname']." ".$result['lastname'];			
				$admin_email   = $result['email'];
				$user_email    = clean_data($this->post('email'));
				$user_name     = clean_data($this->post('manager_name'));
				$type     	   = "UPDATE_USER_MANAGER_EMAIL";
				$role          = $manager_role[0]['role_name'];
				$from 	       =  $admin_email;
				$to  	       =  $user_email;			
				$mail_content=array(
					"subject" 		=> "Manager Information",
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email,
					"role"   		=> $role		
					);
				$attachement='';	
    			send_mail($type,$from,$to,$mail_content,$attachement,$from);
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Manager user has been updated successfully!..'
								);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
								);
				$this->response( $error, 200);
			}
						
		}
	}
	
		
	/****
	 * 
	 * method : block_manager_users
	 * 
	 * block the manager user
	 * 
	 * 
	 */
	public function block_manager_users_get()
	{
	   $user_ids=$this->get('id');
	   
	   	   $arrays	=	explode(',',$user_ids);
		   if(is_array($arrays))
			{  
				foreach($arrays as $user_id)
				{
					 $results= $this->block_man_user($user_id);
					  
					  /* Activity Log for Manager Block- Start*/	
					  $enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,MANAGER_BLOCK);
					  if($enable=='1')
					  {							
							$this->activity_log(MANAGER,BLOCK,$user_id);
					  }
					  /* Activity Log for Manager Block- End*/				 
					 
				}
					$success = array('response'	=> 'ok',
							 'msg'		=> 'Selected user is blocked successfully'
							 );
			
			$this->response( $success, 200);
			}
			else
			{
				$results= $this->block_man_user($user_id);
				
				 /* Activity Log for Manager Block- Start*/	
					  $enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,MANAGER_BLOCK);
					  if($enable=='1')
					  {							
							$this->activity_log(MANAGER,BLOCK,$user_id);
					  }
					  /* Activity Log for Manager Block- End*/				 
					  
				$success = array('response'	=> 'ok',
							 'msg'		=> 'Selected user is blocked successfully'
							 );
			
				$this->response( $success, 200);
			}
	}	
	
	function block_man_user($user_id)
	{ 
		$block_user=$this->do_manager->block_manager_users($user_id);
		if($block_user)
		{
			//SEND MAIL TO THE ADDED MANAGER
			if($this->user_authentication->account_type == "ADMIN" )
			{
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->do_networks->agency_owner_details($agency_id);	
				$admin_name    = $result['name'];			
				$admin_email   = $result['email'];
				// Get MANAGER EMAIL FOR BCC
				$manager_email = $this->do_networks->get_manager_emailID($user_id);
				$bcc =$manager_email;
			}	
			else
			{
				$manager_user_id = $this->user_authentication->manager_user_id;
				$is_manager = $this->do_networks->get_manager_role($manager_user_id);
				if($is_manager == 1)
				{
					// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					// IF NOT NETWORK ADMIN ADMIN SEND BCC
					$network_admin=$this->do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
				}
				else
				{	
					// MANAGER USERS
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					
					// Get MANAGER EMAIL FOR BCC
					$manager_email = $this->do_networks->get_manager_emailID($user_id);
					$bcc =$manager_email;
				}
			}
				
			//GET USER ROLE EMAIL AND THEIR NAME DETAILS
			$user_details  = $this->do_network_managers->get_user_profile($user_id);	
			$user_role     = $user_details[0];
			
			$user_email    = $user_role['email_address'];
			$user_name     = $user_role['contact_name'];
			$type     	   = "BLOCK_USER_ROLE";
			$from 	       = $admin_email;
			$to  	       = $user_email;			
			$mail_content=array(
					"subject" 		=> "Your are Blocked",
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email,					
					);
			$attachement='';	
    		send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
				
			
		}
	}
	
	/****
	 * 
	 * method : unblock_manager_users_get
	 * 
	 * unblock the manager user
	 * 
	 * 
	 */
	public function unblock_manager_users_get()
	{
	   $user_ids=$this->get('id');
	    $arrays	=	explode(',',$user_ids);
		   if(is_array($arrays))
			{  
				foreach($arrays as $user_id)
				{
					 $results= $this->unblock_man_user($user_id);
					 
					  /* Activity Log for Manager Block- Start*/	
					  $enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,MANAGER_UNBLOCK);
					  if($enable=='1')
					  {							
							$this->activity_log(MANAGER,UNBLOCK,$user_id);
					  }
					  /* Activity Log for Manager Block- End*/				 
					 
				}
					
				$success = array('response'	=> 'ok',
								 'msg'		=> 'Selected user is unblocked successfully'
								 );
				
				$this->response( $success, 200);
			}
			else
			{
				$results= $this->unblock_man_user($user_id);
				
				 /* Activity Log for Manager Block- Start*/	
					  $enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,MANAGER_UNBLOCK);
					  if($enable=='1')
					  {							
							$this->activity_log(MANAGER,UNBLOCK,$user_id);
					  }
					  /* Activity Log for Manager Block- End*/				 
				
				$success = array('response'	=> 'ok',
								 'msg'		=> 'Selected user is unblocked successfully'
								 );
				
				$this->response( $success, 200);
			}
	}
		
		function unblock_man_user($user_id)
		{
		$block_user=$this->do_manager->unblock_manager_users($user_id);
		if($block_user)
		{
			//SEND MAIL TO THE ADDED MANAGER
			if($this->user_authentication->account_type == "ADMIN" )
			{
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->do_networks->agency_owner_details($agency_id);	
				$admin_name    = $result['name'];			
				$admin_email   = $result['email'];
				// Get MANAGER EMAIL FOR BCC
				$manager_email = $this->do_networks->get_manager_emailID($user_id);
				$bcc =$manager_email;
			}	
			else
			{
				$manager_user_id = $this->user_authentication->manager_user_id;
				$is_manager = $this->do_networks->get_manager_role($manager_user_id);
				if($is_manager == 1)
				{
					// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					// IF NOT NETWORK ADMIN ADMIN SEND BCC
					$network_admin=$this->do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
				}
				else
				{	
					// MANAGER USERS
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					
					// Get MANAGER EMAIL FOR BCC
					$manager_email = $this->do_networks->get_manager_emailID($user_id);
					$bcc =$manager_email;
				}
			}
		
			//GET USER ROLE EMAIL AND THEIR NAME DETAILS
			$user_details  = $this->do_network_managers->get_user_profile($user_id);			
			$user_role     = $user_details[0];
			$user_email    = $user_role['email_address'];
			$user_name     = $user_role['contact_name'];
			$type     	   = "UNBLOCK_USER_ROLE";
			$from 	       = $admin_email;
			$to  	       = $user_email;			
			$mail_content=array(
					"subject" 		=> "Your are unblocked",
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email,					
					);
			$attachement='';	
    		send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
			
		}
	
	}
	
	public function get_manager_api_key_get()
	{ 
         $account_id=$this->get('account_id');
		 
		 $api_key=$this->do_manager->get_manager_api_key($account_id);
		 
	     $this->response($api_key, 200);
	}
	
	function activity_log($module,$process,$user_id)
	{
		/* Activity Log for Add/edit/block/unblock manager - Start*/				
		$user_agent=$this->user_authentication->user_agent;
		$browser=$this->user_authentication->browser;
		$os=$this->user_authentication->os;
		$ip=$_SERVER['REMOTE_ADDR'];
		$date=date("Y-m-d h:i:s");							
		$account_id=$this->user_authentication->account_id;
		$manager_user_id=$user_id;
		$module=$module;
		$process=$process;				
								
		$activity_log=array(				
			"account_id"=>$account_id,
			"useragent"=>$user_agent,
			"browser"=>$browser,
			"os"=>$os,
			"ip"=>$ip,
			"date"=>$date,
			"module"=>$module,
			"process"=>$process,
			"manager_id"=>$manager_user_id,
			"advertiser_id"=>'',
			"campaign_id"=>'',
			"banner_id"=>'',
			"publisher_id"=>'',
			"site_id"=>'',
			"app_id"=>'',
			"adblock_id"=>'');				
			
			$this->redis_library->logcount($account_id,$activity_log);			
		 //$this->do_app_config->activity_log($account_id,$activity_log);
		/* Activity Log for Add/edit/block/unblock  - End*/			
		
	}
	
	
	
}
