<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Publisher Site related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Jobs extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('do_advertiser');	
		$this->load->model('do_jobs');
		$this->load->model('do_email_check');
		$this->load->model('do_publisher');
		$this->load->helper('email');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->model('do_app_config');
		$this->load->model('do_message');
		$this->load->library('notification');
		$this->load->model('do_networks');
		
        $this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }	
	}
	
	function addjobs_post()
	{		
		$account_id	= 	$this->user_authentication->account_id;						
		$this->form_validation->set_rules('job_category', 'job category','required|trim');
		$this->form_validation->set_rules('job_title','Job Title','required');
		//$this->form_validation->set_rules('job_summary','Job summary', 'required|trim');   
		$this->form_validation->set_rules('employment_type','Employment_type', 'required|trim');
		$this->form_validation->set_rules('work_experience','work Experience', 'required|trim');
		$this->form_validation->set_rules('location','Location', 'required|trim');
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$str=clean_data(md5($this->post('job_title')));
			$enc_code=substr($str,0,7);
			
			$summary=$this->post(); 
			$job_summary=$summary['job_summary'];
			
			$obj		=	array(
									'job_category'		=>	clean_data($this->post('job_category')),
									'job_title'			=>	clean_data($this->post('job_title')),
									'job_title_enc'		=>	$enc_code,
									'job_summary'		=>	$job_summary,
									'employment_type'	=>	clean_data($this->post('employment_type')),
									'work_experience'	=>	clean_data($this->post('work_experience')),
									'location'			=>	clean_data($this->post('location'))	  							
									);
								
								
								
			$careers_add = 	$this->do_jobs->add_careers($obj);  
			if($careers_add !== FALSE){
				
			$success = array(
									'response' => 'ok',
									'redirect'	=>  site_url('admin/careers'),
									'msg'	 => 'Careers has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'redirect'	=>  site_url('admin/careers'),
									'msg'	 => 'Problem in adding Careers!..'
					);
				
				$this->response( $success, 200);
			}
		}
		
					
	}   
	
	public function fetch_careers_get()
	{
		 $id=$this->get('id');
	 	 $careers_list = $this->do_jobs->fetch_careers($id);
		 $this->response($careers_list,200);
	}
	
	public function careers_list_get()
	{		
	   $id = $this->get('id');
	   if($id)
	   {
		   $careers_list = $this->do_jobs->fetch_selected_careers($id);
		   //$careers_list = $this->do_advertiser->fetch_careers_select($id);
		   $this->response($careers_list);
       }
	}
	
	public function fetch_country_get()
	{
	 	 $country_list = $this->do_advertiser->fetch_country();
		 $this->response($careers_list,200);
	}
	
	
	function editjobs_post()
	{		
		$account_id	= 	$this->user_authentication->account_id;						
		$this->form_validation->set_rules('job_category', 'job category','required|trim');
		$this->form_validation->set_rules('job_title','Job Title','required');
		//$this->form_validation->set_rules('job_summary','Job summary', 'required|trim');
		$this->form_validation->set_rules('employment_type','Employment_type', 'required|trim');
		$this->form_validation->set_rules('work_experience','work Experience', 'required|trim');
		$this->form_validation->set_rules('location','Location', 'required|trim');
		
		if($this->form_validation->run() === FALSE)
		{	  
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	  
			$str=clean_data(md5($this->post('job_title')));
			$enc_code=substr($str,0,7);	
			
			$summary=$this->post(); 
			$job_summary=$summary['job_summary'];			
			
			
			$obj=array(
									'job_category'		=>	clean_data($this->post('job_category')),
									'job_title'			=>	clean_data($this->post('job_title')),
									'job_title_enc'		=>	$enc_code,
									'job_summary'		=>	$job_summary,
									'employment_type'	=>	clean_data($this->post('employment_type')),
									'work_experience'	=>	clean_data($this->post('work_experience')),
									'location'			=>	clean_data($this->post('location'))	,
									'id'				=>  $this->post('id')
									);
																				
			$careers_add = 	$this->do_jobs->update_careers($obj,$id);
								
			if($careers_add !== FALSE){
				
			$success = array(
									'response' => 'ok',
									'redirect'	=>  site_url('admin/careers'),
									'msg'	 => 'Careers has been updated successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'redirect'	=>  site_url('admin/careers'),
									'msg'	 => 'Problem in updaing Careers!..'
					);
				
				$this->response( $success, 200);
			}
		}
		
					
	}
	
   public function delete_careers_get()
   {
      $id = $this->get('id');
	  
	   if($id)
		{
			 $careers_list = $this->do_jobs->delete_careers($id);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Career has been deleted'
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Career id is not found'
					);
			
			$this->response( $error, 200);  
		}

   }
   
   /*
   * 
   * name: block_career
   * @param : careerid
   * @return : sucess msg
   * 
   */
	public function block_careers_get()
	{
	    $id=$this->get('id');
		if($id)
		{
			$block_careers = $this->do_jobs->block_careers($id);
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Career is blocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	   /*
   * 
   * name: unblock_career
   * @param : careerid
   * @return :sucess msg
   * 
   */
	public function unblock_careers_get()
	{
	    $id=$this->get('id');
		if($id)
		{
			$block_careers = $this->do_jobs->unblock_careers($id);
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Career is Un-blocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	
	public function job_listing_get()
	{
		 $job_title_enc=$this->get('job_title_enc');
	 	 $job_listing = $this->do_jobs->view_jobs_select($job_title_enc);
	 	 $this->response($job_listing,200);
	
	}
	
	/*
   * 
   * name: update_careers_post
   * @param : none
   * @return : careers id
   * 
   */ 
	public function update_careers_post()
	{		
		
		$this->form_validation->set_rules('job_category', 'job category','required|trim');
		$this->form_validation->set_rules('job_title','Job Title','required|trim');
		$this->form_validation->set_rules('job_summary','Job summary', 'required|trim');
		$this->form_validation->set_rules('required_skills','Required skills', 'required|trim');
		$this->form_validation->set_rules('company_offer','Company offers', 'trim');
		$this->form_validation->set_rules('employment_type','Employment_type', 'required');
		$this->form_validation->set_rules('work_experience','work Experience', 'required|trim');
		$this->form_validation->set_rules('location','Location', 'required|trim');

	   // $this->form_validation->set_rules('device_os', 'Device Name', 'required|trim');
		//$this->form_validation->set_message('is_unique', 'Already this Device name is being registered. please enter the unique one');
		//$this->form_validation->set_rules('os_value', 'OS Value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$careers = $this->do_jobs->update_careers(clean_data($this->post()));
			
			if($careers !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Careers has been Updated successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in Careers!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}

	
	}
	public function apply_job_post()   
	{		
		$this->form_validation->set_rules('first_name','First Name', 'trim|required');
		$this->form_validation->set_rules('last_name', 'Last Name','trim|required');
		$this->form_validation->set_rules('email', 'Email','trim|required|valid_email|callback_email_check');
		$this->form_validation->set_rules('country', 'Country','trim|required');
		$this->form_validation->set_rules('city', 'City','trim|required');
		$this->form_validation->set_rules('address', 'Address','trim|required');
		$this->form_validation->set_rules('postal_code', 'postal code','trim|required');
		$this->form_validation->set_rules('phone', 'phone','trim|required');
		$this->form_validation->set_rules('education', 'education','trim|required');
		$this->form_validation->set_rules('summary', 'summary','trim|required'); 
		$this->form_validation->set_rules('experience', 'experience','trim|required');  
		$this->form_validation->set_rules('resume', 'resume','trim|required');
		$this->form_validation->set_rules('biodata', 'biodata','trim|required');
		$this->form_validation->set_rules('cv', 'cv','trim|required');
		
		$this->form_validation->set_rules('g-recaptcha-response', 'recaptcha','trim|required');   
		
		//image upload
		$config['upload_path'] 		= 	$this->config->item('message_upload_path');
		$img_name=$_FILES['resume']['tmp_name'];
        $config['allowed_types']= 	'jpeg|jpg|png|gif';
		$config['max_size']			= 	$this->config->item('message_max_file_size');
		$config['source_image']   	= 	$_FILES['resume']['tmp_name'];
		$config['source_name']   	= 	$_FILES['resume']['tmp_name'];
		$config['encrypt_name']   	= 	TRUE;

		//print_r($_FILES);exit;
		$this->load->library('upload');
		$this->upload->initialize($config);
		
		if ( ! $this->upload->do_upload('resume'))
		{
		$error 	= 	array('error' => $this->upload->display_errors());
		
		return $error;
		}
		else
		{			
			$data 	= 	array('upload_data' => $this->upload->data());
			$img_name=$data['upload_data']['file_name'];
		}
		//resume upload
		$config['upload_path'] 		= 	$this->config->item('message_upload_path');
		$res_name=$_FILES['biodata']['tmp_name'];
        $config['allowed_types']= 	'doc|docx|pdf';
		$config['max_size']			= 	$this->config->item('message_max_file_size');
		$config['source_image']   	= 	$_FILES['biodata']['tmp_name'];
		$config['source_name']   	= 	$_FILES['biodata']['tmp_name'];
		$config['encrypt_name']   	= 	TRUE;

		//print_r($_FILES);exit;
		$this->load->library('upload');
		$this->upload->initialize($config);
			
		if ( ! $this->upload->do_upload('biodata'))
		{
		$error 	= 	array('error' => $this->upload->display_errors());
		
			return $error;
		}
		else
		{	
			$data 	= 	array('upload_data' => $this->upload->data());
			$res_name=$data['upload_data']['file_name'];
		}
			
		$obj		=	array(
									'first_name'		=>	clean_data($this->post('first_name')),
									'last_name'			=>	clean_data($this->post('last_name')),
									'address'			=>	clean_data($this->post('address')),
									'email'				=>	clean_data($this->post('email')),
									'country'			=>	clean_data($this->post('country')),
									'image'				=>	$img_name,
									'city'				=>	clean_data($this->post('city')),
									'postal_code'		=>	clean_data($this->post('postal_code')),
									'phone'				=>	clean_data($this->post('phone')),
									'headline'			=>	clean_data($this->post('headline')),
									'education'			=>	clean_data($this->post('education')),
									'summary'			=>	clean_data($this->post('summary')),
									'resume'				=>	$res_name,

									'experience'		=>	clean_data($this->post('experience')),
									'created_date'	=>	date('Y-m-d H:i:s')						
									);								
							
				$job_add = 	$this->do_jobs->apply_jobs($obj);
				
				//Sending Email to admin
				if($job_add !== FALSE)
				{					
				$result=$this->do_networks->get_network_details();			
				$admin_name    = $result['firstname']." ".$result['lastname'];			
				$admin_email   = $result['email'];
				$to_email	   =	"narmatha686@gmail.com";	
				$user_email	   =	clean_data($this->input->post("email"));
			 	$subject	   =	clean_data($this->input->post("headline"));			 
				$email_data['message']	=	"You have received an job application form ";
			
				// $admin_detail			=	$this->mod_site_settings->admin_details($admin_id);
		
				$config['protocol'] 	= "sendmail";
			 
				$config['wordwrap'] 	= TRUE;		
			 
				$config['mailtype'] 	= 'html';
			 
				$config['charset']		= 'UTF-8'; 
	
				$this->email->initialize($config);
			 
				$this->email->from($user_email);
			 
				$this->email->subject($subject);  
			       
				$this->email->message($email_data['message']);
						
				$this->email->to($to_email);    				 
				 
				$this->email->send();
			
			}
			redirect("site/apply_job");		
	
	}	
	
}