<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Publisher Site related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Geo_settings extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->library('redis_library');		
		$this->load->model('do_geo');
		#$this->load->library('csvreader');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->library('user_authentication');
		$this->load->model('do_app_config');
	    $key=$this->input->get_post('api_key');
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }

	}
	/*
	 * name: browser_targeting_post
	 * @param
	 * @return:response array
	 * 
	 * In this method set browser targeting for a campaign
	 * 
	 */
	function fetch_get()
	{
		$geo_list = $this->do_geo->fetch();
		$this->response($geo_list);
	}
	
	/*
   * 
   * name: block_geo_get
   * @param : categoryid
   * @return : sucess msg
   * 
   */
	public function block_geo_get()
	{
	    $geo_id=$this->get('geo_id');
		if($geo_id)
		{
			$block_geo = $this->do_geo->block_geo_data($geo_id);
			
					/* Activity Log for Block Geo settings Add- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,CPM_BLOCK);
					if($enable=='1')
					{							
					$this->activity_log(CPM_GEO,BLOCK);
					}
					/* Activity Log for Geo settings Add- End*/
			
			
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Geo settings blocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/*
   * 
   * name: unblock_geo_get
   * @param : categoryid
   * @return : sucess msg
   * 
   */
	public function unblock_geo_get()
	{
	    $geo_id=$this->get('geo_id');
		if($geo_id)
		{
			$unblock_geo = $this->do_geo->unblock_geo_data($geo_id);
			
					/* Activity Log for un Block Geo settings - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,CPM_UNBLOCK);
					if($enable=='1')
					{							
					$this->activity_log(CPM_GEO,UNBLOCK);
					}
					/* Activity Log for Geo settings - End*/
			
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Geo settings unblocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	/*
   * 
   * name: add
   * @param : CPM value,country name
   * @return :lastinsertid
   * 
   * Fetch list of geo list
   */
   public function add_post()
   {
		$this->form_validation->set_rules('cpm_val', 'CPM Value', 'required|trim');
		$this->form_validation->set_rules('cty_value', 'Country Name', 'required|trim|is_unique['.TAB_GEO_SETTING.'.value]');
		$this->form_validation->set_message('is_unique', 'Already this country name is being registered. please enter the unique one');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$geo_set = $this->do_geo->add_geo(clean_data($this->post('cpm_val')),clean_data($this->post('cty_value')));
			
					/* Activity Log for Geo settings Add- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,CPM_ADD);
					if($enable=='1')
					{							
					$this->activity_log(CPM_GEO,ADD);
					}
					/* Activity Log for Geo settings Add- End*/	
		  
			
			if($category !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Operating System has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding Operating System!..'
					);
				
				$this->response( $success, 200);
			}
		}
	}
	
	/*
   * 
   * name: geo_data
   * @param : category_id
   * @return :categoryname,categoryvalue
   * 
   */
	public function geo_data_get()
	{
		$geo_id = $this->get('geo_id');
		if($geo_id)
		{
			$geo_list = $this->do_geo->fetch_select($geo_id);
			$this->response($geo_list);
		}
	}
	
	/*
	* 
	* name: update_browser_post
	* @param : none
	* @return : browser id
	* 
	*/ 
	public function update_geo_settings_post()
	{
	    $this->form_validation->set_rules('cpm_val', 'CPM Value', 'required|trim');
		$this->form_validation->set_rules('cty_value', 'Country Name', 'required|trim|callback_geo_list_check');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$geo_id		=   clean_data($this->post('geo_id'));
			$up_val	=	array('cpm_value' =>clean_data($this->post('cpm_val')),'value' =>clean_data($this->post('cty_value')));
			$up_data = $this->do_geo->update_geo_list($up_val,$geo_id);
			
			
			/* Activity Log for Geo settings Add- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,CPM_EDIT);
					if($enable=='1')
					{							
					$this->activity_log(CPM_GEO,EDIT);
					}
					/* Activity Log for Geo settings Add- End*/	
		  
			
			
			if($operating_sys !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Geo settings has been Updated successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in updating Geo list!..'
					);
				
				$this->response( $success, 200);
			}		
		}
	}
	
	function geo_list_check()
	{
		$geo_id		=   clean_data($this->post('geo_id'));
		$geo_value	=	clean_data($this->post('cty_value'));
		$table_name =   TAB_GEO_SETTING;
		$count 		= 	$this->do_geo->geo_list_sett($table_name,$geo_value,$geo_id);
		
		if($count>0)
		{
			$this->form_validation->set_message('geo_list_check', 'Geo list already exist');
			return FALSE;
		}
		else
		{
			return TRUE;
		}	
	}
	
	/*
   * 
   * name: delete_mobile_capability_get
   * @param : none
   * @return : status true or false
   * 
  */
	public function delete_geo_get()
	{
		$id = $this->get('geo_id');
	  
		if($id)
		{
			$manufacturer_list = $this->do_geo->delete_geo_list($id);
			
			/* Activity Log for Geo settings Add- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,CPM_DELETE);
					if($enable=='1')
					{							
					$this->activity_log(CPM_GEO,DELETE);
					}
					/* Activity Log for Geo settings Add- End*/	
	
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Geo settings has been deleted'
							 );
			
			$this->response( $success, 200);
			
		}else
		{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Geo list id is not found'
					);
			
			$this->response( $error, 200);
		}
   }
   
   function activity_log($module,$process)
	{
				/* Activity Log for EDIT setting information - Start*/				
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");							
				$account_id=$this->user_authentication->account_id;
				$module=$module;
				$process=$process;				
								
				$activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$user_agent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,
				"module"=>$module,
				"process"=>$process,
				"advertiser_id"=>'',
				"campaign_id"=>'',
				"banner_id"=>'',
				"publisher_id"=>'',
				"site_id"=>'',
				"app_id"=>'',
				"adblock_id"=>'');				
				
				$this->redis_library->logcount($account_id,$activity_log);							
				//$this->do_app_config->activity_log($account_id,$activity_log);
				/* Activity Log for edit settings information - End*/			
		
	}
   
   
}
