<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Creatives
 *
 * Managing all type of creatives will be handelled here.
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Vigneswaran A
 * @link		http://www.djaxadserver.com
 */
class Creative extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library('redis_library');
        $this->load->model('do_creative');
        $this->load->model('do_message');
        $this->load->model('do_campaign');
        $this->load->model('do_linking');
        $this->load->library('user_authentication');
        $this->load->library('notification');
        $this->load->library('memcached_library');
        $this->load->library('Default_configurations');
        $key = $this->input->get_post('api_key');
        $this->load->library('csvreader');
        $this->user_authentication->is_valid_apikey($key);
        $user_auth = $this->user_authentication;
        if (isset($user_auth->error['response'])) {
            $this->response($user_auth->error, 200);
        }
    }
    /*
     * 
     * name: fetch
     * @param :
     * @return : $creative_list
     * 
     * Lists all the web creative of an advertiser
     */
    function fetch_get()
    {
        $adma_id = clean_data($this->get('admarket_id'));
        //Get account id from library file
        if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id = $this->user_authentication->account_id;
        } else {
            $type       = $this->get('housead');
            $account_id = ($type == 'housead') ? $this->user_authentication->default_advertiser_account_id : '';
        }
        //~ $campaign_id = clean_data($this->get('filter'));
        $campaign_id = clean_data($this->get('campaign_id'));
        if ($account_id) {
            $cre_list = $this->do_creative->fetch($account_id, $campaign_id, $adma_id);
        } else {
            $cre_list = $this->do_creative->fetch('', $campaign_id, $adma_id);
        }
        if ($cre_list) {
            $this->response($cre_list, 200); // 200 being the HTTP response code
        } else {
            $this->response(array(
                'error' => 'No creatives'
            ), 404);
        }
    }
    /*
     * 
     * name: fetch_creative_get
     * @param :
     * @return : $creative_list
     * 
     * Lists a web creative of an advertiser
     */
    function fetch_creative_get()
    {
        //Get account id from library file
        $account_id  = $this->user_authentication->account_id;
        $creative_id = $this->get('creative_id');
        if ($account_id && $creative_id) {
            $creative_details = $this->do_creative->fetch_creative($creative_id);
            if ($creative_details) {
                $this->response($creative_details, 200); // 200 being the HTTP response code
            } else {
                $this->response(array(
                    'error' => 'No details found'
                ), 404);
            }
        }
    }
    /*
     * 
     * name: fetch_creative_get
     * @param :
     * @return : $creative_list
     * 
     * Lists a web creative of an advertiser
     */
    function fetch_video_creative_get()
    {
        //Get account id from library file
        $account_id = $this->user_authentication->account_id;
        if ($account_id) {
            $creative_details = $this->do_creative->fetch_video_creatives($account_id);
            //print_r($creative_details); exit;
            if ($creative_details) {
                $this->response($creative_details, 200); // 200 being the HTTP response code
            } else {
                $this->response(array(
                    'error' => 'No details found'
                ), 404);
            }
        }
    }
    /*
     * _
     * name: fetch_demo_creative_get
     * @param :
     * @return : $creative_list
     * 
     * Lists a web creative of an advertiser
     */
    function fetch_demo_creative_get()
    {
        //Get account id from library file
        $account_id  = $this->user_authentication->account_id;
        $creative_id = $this->get('creative_id');
        //$campaignid=$this->get('cam_id');
        if ($account_id && $creative_id) {
            $creative_id = $this->do_creative->fetch_demo_creative_bkp($creative_id);
            if ($creative_id) {
                $this->response($creative_id, 200); // 200 being the HTTP response code
            } else {
                $this->response(array(
                    'error' => 'No details found'
                ), 200);
            }
        }
    }
    function fetch_daily_statistics_get()
    {
        $date            = date('Y-m-d');
        $admarket_status = $this->get('admarket'); // if val is 1 admarket, val is 0 normal campaign
        if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id = $this->user_authentication->account_id;
        }
        if ($date) {
            $stat_data = $this->do_creative->fetch_daily_statistics($date, $account_id, $admarket_status);
        }
        $this->response($stat_data, 200);
    }
    function fetch_demo_creative_campaign_get()
    {
        //Get account id from library file
        $account_id = $this->user_authentication->account_id;
        //$creative_id = $this->get('creative_id');
        $campaignid = $this->get('cam_id');
        if ($account_id && $campaignid) {
            $campain_details = $this->do_creative->fetch_demo_creative($campaignid);
            if ($campain_details) {
                $this->response($campain_details, 200); // 200 being the HTTP response code
            } else {
                $this->response(array(
                    'error' => 'No details found'
                ), 200);
            }
        }
    }
    function fetch_demo_additional_creative_get()
    {
        //Get account id from library file
        $account_id  = $this->user_authentication->account_id;
        $creative_id = $this->get('creative_id');
        //$campaignid=$this->get('cam_id');
        if ($account_id && $creative_id) {
            $creative_details = $this->do_creative->fetch_demo_additional_creative($creative_id);
            if ($creative_details) {
                $this->response($creative_details, 200); // 200 being the HTTP response code
            } else {
                $this->response(array(
                    'error' => 'No details found'
                ), 200);
            }
        }
    }
    /*
     * 
     * name: fetch_select_group_get
     * @param :
     * @return : $group_list
     * 
     * Lists a groups of an advertiser
     */
    function fetch_select_group_get()
    {
        if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id = $this->user_authentication->account_id;
        }
        $campaign_id   = $this->get('campaign_id');
        $group_details = $this->do_creative->fetch_selected_group($account_id, $campaign_id);
        if ($group_details) {
            $this->response($group_details, 200); // 200 being the HTTP response code
        } else {
            $this->response('error', 200);
        }
    }
    /*
     * 
     * name: fetch_group_get
     * @param :
     * @return : $group_list
     * 
     * Lists a groups of an advertiser
     */
    function fetch_group_get()
    {
        if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id = $this->user_authentication->account_id;
        } else {
            $account_id = $this->get('account_id');
        }
        $group_details = $this->do_creative->fetch_group($account_id);
        if ($group_details) {
            $this->response($group_details, 200); // 200 being the HTTP response code
        } else {
            $this->response('error', 200);
        }
    }
    function fetch_keyword_get()
    {
        if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id = $this->user_authentication->account_id;
        } else {
            $account_id = $this->get('account_id');
        }
        $keyword_details = $this->do_creative->fetch_keyword($account_id);
        if ($keyword_details) {
            $this->response($keyword_details, 200); // 200 being the HTTP response code
        } else {
            $this->response('error', 200);
        }
    }
    function fetch_keywords_ajax_get()
    {
        $value           = $this->get('value');
        $sortable2       = $this->get('sortable2');
        $keyword_details = $this->do_creative->fetch_keywords_ajax($value, $sortable2);
        if ($keyword_details) {
            $this->response($keyword_details, 200);
        } else {
            $this->response('error', 200);
        }
    }
    function fetch_avg_cpm_get()
    {
        $keywords        = $this->get('value');
        $sortable2       = $this->get('sortable2');
        $where           = $this->get('where');
        $keyword_details = $this->do_creative->fetch_avg_impression($keywords, $sortable2, $where);
        if ($keyword_details) {
            $this->response($keyword_details, 200);
        } else {
            $this->response('error', 200);
        }
    }
    function fetch_language_get()
    {
        if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id = $this->user_authentication->account_id;
        } else {
            $account_id = ($this->get('type') == 'housead') ? $this->user_authentication->default_advertiser_account_id : ($this->get('account_id') ? $this->get('account_id') : '');
        }
        $lang_details = $this->do_creative->fetch_language($account_id);
        if ($lang_details) {
            $this->response($lang_details, 200); // 200 being the HTTP response code
        } else {
            $this->response('error', 200);
        }
    }
    function fetch_group_by_camp_get()
    {
        if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id = $this->user_authentication->account_id;
        }
        $group_details = $this->do_creative->fetch_group($account_id);
        if ($group_details) {
            $this->response($group_details, 200); // 200 being the HTTP response code
        } else {
            $this->response('error', 200);
        }
    }
    /*
     * 
     * name: fetch_campaigns_get
     * @param :
     * @return : $campaign_list
     * 
     * Lists a campaigns of an advertiser
     */
    function fetch_campaigns_get()
    {
        //$this->response(print_r($this->user_authentication->account_type,true), 200);
        if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id = $this->user_authentication->account_id;  
        } else {
            $account_id = ($this->get('type') == 'housead') ? $this->user_authentication->default_advertiser_account_id : ($this->get('account_id') ? $this->get('account_id') : '');
        }
        $campaign_type    = $this->get('campaign_type');
        $admarket_id      = $this->get('admarket_id');
        $campaign_details = $this->do_creative->fetch_campaign($account_id, $campaign_type, $admarket_id);
        if ($campaign_details) {
            $this->response($campaign_details, 200); // 200 being the HTTP response code
        } else {
            $this->response('error', 200);
        }
    }
    /*
     * 
     * name: fetch_directcampaigns_get
     * @param :
     * @return : $campaign_list
     * 
     * Lists a campaigns of an advertiser
     */
    function fetch_directcampaigns_get()
    {
        $is_approve       = $this->get('is_approve');
        $campaign_type    = $this->get('campaign_type');
        $campaign_details = $this->do_creative->fetch_directcampaigns($is_approve); //$account_id,$campaign_type);
        if ($campaign_details) {
            $this->response($campaign_details, 200); // 200 being the HTTP response code
        } else {
            $this->response(array(
                'error' => 'No details found'
            ), 404);
        }
    }
    /*
     * 
     * name: fetch_cpm_campaigns_get
     * @param :
     * @return : $cpm_campaign_list
     * 
     * Lists a campaigns of an advertiser
     */
    function fetch_cpm_campaigns_get()
    {
        if ($this->user_authentication->account_type == 'ADVERTISER') {
            $account_id = $this->user_authentication->account_id;
        } else {
            $account_id = $this->user_authentication->default_advertiser_account_id;
        }
        $campaign_type    = $this->get('campaign_type');
        $admarket_id      = $this->get('admarket_id');
		$campaign_details = $this->do_creative->fetch_campaign_cpm($account_id, $campaign_type, $admarket_id);
        if ($campaign_details) {
            $this->response($campaign_details, 200); // 200 being the HTTP response code
        } else {
            $this->response(array(
                'error' => 'No details found'
            ), 404);
        }
    }
    /*
     * 
     * name: fetch_creative_dependiences_get
     * @param :
     * @return : $creative_list
     * 
     * Lists a web creative of an advertiser
     */
    function fetch_creative_dependiences_get()
    {
        //Get account id from library file
        $account_id  = $this->user_authentication->account_id;
        $creative_id = $this->get('creative_id');
        if ($account_id && $creative_id) {
            $creative_dependiency_data = $this->do_creative->fetch_creative_dependiences($creative_id);
            if ($creative_dependiency_data) {
                $this->response($creative_dependiency_data, 200); // 200 being the HTTP response code
            } else {
                $this->response(array(
                    'error' => 'No details found'
                ), 404);
            }
        }
    }
    /*
     * 
     * name: delete_get
     * @param :
     * @return : $creative_id
     * 
     * Delete the given creative id
     */
    function delete_get()
    {
        $creative_id   = $this->get('creative_id');
        $creative_name = '';
        if ($creative_id) {
            $bannerid = explode(',', $creative_id);
            if (is_array($bannerid)) {
                foreach ($bannerid as $creative_id) {
                    $camp_name = $this->do_creative->fetch_campaignid_creative($creative_id);
                    $creative_name .= $camp_name[0]['description'] . ',';
                    $creative_details = $this->do_creative->delete_creative($creative_id);
                }
            } else {
                $camp_name = $this->do_creative->fetch_campaignid_creative($creative_id);
                $creative_name .= $camp_name[0]['description'] . ',';
                $creative_details = $this->do_creative->delete_creative($creative_id);
            }
            /***creative edit for message/mail notification*****/
            $creative_dat             = $this->do_creative->fetch_campaignid_creative($creative_id);
            $campaign_id              = $creative_dat[0]['campaignid'];
            //$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
            $content['sub']           = 'Creatives Deleted';
            $content['data']          = 'The Creatives ' . rtrim($creative_name, ",") . ' has been deleted successfully';
            $content['content']       = 'Creative has been deleted successfully.';
            $content['creative_name'] = rtrim($creative_name, ",");
            $creative_add             = $this->do_message->mail_to_lib_advertiser('creative_del', 'campaigns', null, $content, $campaign_id);
            /***creative edit for message/mail notification*****/
            /***Activity Log For delete creatives ***/
            $enable                   = $this->default_configurations->activity_log_setting(CREATIVES, CREATIVE_DEL);
            if ($enable == '1') {
                $creative_add = $this->add_activity_log(BANNER, DELETE, $creative_id, $campaign_id);
            }
            /***Activity Log For delete creatives ***/
            $success = array(
                'response' => 'ok',
                'msg' => 'Creative has been deleted'
            );
            $this->response($success, 200);
        } else {
            $error = array(
                'response' => 'error',
                'msg' => 'Site id is not found'
            );
            $this->response($error, 200);
        }
    }
    /*
     * 
     * name: fetch_adblocks_get
     * @param :
     * @return : Array
     * 
     * Returns a sets off matched zones
     */
    function fetch_adblocks_post()
    {
        $this->load->model('do_linking');
        $creative_id = clean_data($this->post('creative_id'));
        if ($creative_id) {
            $result = array(
                'response' => 'ok',
                'msg' => $this->do_linking->fetch_adblocks($creative_id)
            );
        } else {
            $result = array(
                'response' => 'error',
                'msg' => 'Creative ID is not found'
            );
        }
        $this->response($result, 200);
    }
    /*
     * 
     * name: linked_process_post
     * @param :
     * @return : Update status
     * 
     * Insert/Update ad-zone assoc
     */
    function linked_process_post()
    {
        $this->load->model('do_linking');
        $creative_id = clean_data($this->post('creative_id'));
        $zone_ids    = clean_data($this->post('zone_ids'));
        if ($creative_id) {
            $result = array(
                'response' => 'ok',
                'msg' => $this->do_linking->linked_process($creative_id, $zone_ids)
            );
        } else {
            $result = array(
                'response' => 'error',
                'msg' => 'Creative ID is not found'
            );
        }
        $this->response($result, 200);
    }
    /****************************************************************************
     * Native Ads
     ****************************************************************************/
    /*
     * 
     * name		: fetch_url
     * @param   : None
     * @purpose  : fetch url
     */
    public function fetch_url_post()
    {
        $text          = clean_data($this->post('text'));
        $imageQuantity = clean_data($this->post('imagequantity'));
        $text          = " " . str_replace("\n", " ", $text);
        $header        = "";
        $linkPreview   = new LinkPreview();
        $answer        = $linkPreview->crawl($text, $imageQuantity, $header);
        echo $answer;
    }
    /*
     * 
     * name		: add_url
     * @param   : None
     * @purpose  : insert url data into ox_banners table
     */
    public function add_url_post()
    {
        $this->form_validation->set_rules('title', 'Title', 'required');
        $this->form_validation->set_rules('description', 'Description', 'required');
        $this->form_validation->set_rules('url', 'URL', 'required');
        $admarket_id = clean_data($this->post('_admarket_id'));
        $adma_id     = ($admarket_id == false) ? '0' : '1';
        if ($this->form_validation->run() === FALSE) {
            $error_msg = $this->form_validation->error_array();
            $error     = array(
                'response' => 'error',
                'msg' => $error_msg
            );
            $this->response($error, 200);
        } else {
            $trusted_status = '';
            //Get account/clientid from library file
            if ($this->user_authentication->account_type == 'ADVERTISER') {
                $dj_account_id  = $this->user_authentication->account_id;
                $trusted_status = $this->do_campaign->adv_trusted_status($dj_account_id);
            } else {
                $dj_account_id = (clean_data($this->post('_wnat_type')) == 'housead') ? $this->user_authentication->default_advertiser_account_id : ((clean_data($this->post('adv_id'))) ? clean_data($this->post('adv_id')) : clean_data($this->post('_wcat_account_id')));
            }
            $agency_id    = $this->user_authentication->agency_id;
            $is_house_ad  = clean_data($this->post('_is_house_ad'));
            $dj_is_direct = 0;
            if ($is_house_ad == '1') {
                $dj_admin_approve = '1';
                $dj_approved_date = date("Y-m-d H:i:s");
            } elseif ($is_house_ad == '0') {
                if ($this->user_authentication->account_type == 'ADVERTISER') {
                    $approval_type = $this->do_creative->fetch_creative_approval_type();
                    if ($approval_type === "ADMIN")
                        if ($trusted_status == '1') {
                            $dj_admin_approve = '1';
                        } else {
                            $dj_admin_approve = '0';
                        }
                    $dj_approved_date = '';
                    if ($approval_type === "AUTO")
                        $dj_admin_approve = '1';
                    $dj_approved_date = date("Y-m-d H:i:s");
                } else {
                    $dj_admin_approve = '1';
                    $dj_approved_date = date("Y-m-d H:i:s");
                }
            } elseif ($is_house_ad == '2') {
                if ($trusted_status == '1') {
                    $dj_admin_approve = '1';
                } else {
                    $dj_admin_approve = '0';
                }
                $dj_approved_date = '';
                //$dj_is_direct	=	1;
                $dj_is_direct     = 0;
            } else {
                if ($trusted_status == '1') {
                    $dj_admin_approve = '1';
                } else {
                    $dj_admin_approve = '0';
                }
                $dj_approved_date = '';
            }
            $bannertype    = WEB_CREATIVE_NATIVE;
            $image         = substr(clean_data($this->post('image')), -3);
            $image_type    = ($image == 'jpg') ? 'jpeg' : $image;
            $cur_date      = date("Y-m-d H:i:s");
            $dj_image_path = $this->config->item('creative_upload_path') . date("Y-m-d") . "/";
            //$image_url	=	($_GET['url']=='web')?$dj_image_path.$this->post('image'):$this->post('image');	
            $creative_data = array(
                "contenttype" => $image_type,
                "campaignid" => clean_data($this->post('campaign_id')),
                "storagetype" => $_GET['url'],
                "imageurl" => clean_data($this->post('image')),
                "file_size" => clean_data($this->post('filesize')),
                "url" => clean_data($this->post('url')),
                "statustext" => clean_data($this->post('title')),
                "description" => clean_data($this->post('title')),
                "bannertext" => clean_data($this->post('text')),
                "htmltemplate" => clean_data($this->post('description')),
                "click" => clean_data($this->post('clickk')),
                "impression" => clean_data($this->post('impression')),
                "embed" => clean_data($this->post('embed')),
                "video_url" => clean_data($this->post('video_name')),
                "dj_account_id" => $dj_account_id,
                "dj_banner_type" => clean_data($bannertype),
                "dj_admin_approve" => clean_data($dj_admin_approve),
                "dj_approved_date" => clean_data($dj_approved_date),
                "dj_added_date" => $cur_date,
                "dj_is_direct" => clean_data($dj_is_direct),
                "dj_image_path" => $dj_image_path,
                "dj_admarket_status" => clean_data($this->post('admarket_status')),
                "save_creative" => '1'
            );
            $img           = clean_data($this->post('image'));
            $add_url       = $this->do_creative->add_url($creative_data);
            if ($add_url) {
                if ($_GET['url'] == 'web') {
                    $is_creative_moved = $this->image_lib->move_creative_to_original_location($img);
                }
                if ($this->user_authentication->account_type === "ADVERTISER") {
                    $success = array(
                        'response' => 'ok',
                        'msg' => $add_url[0],
                        'redirect' => site_url('advertiser/creatives/add_web_creatives/')
                    );
                } else {
                    $success = array(
                        'response' => 'ok',
                        'msg' => $add_url[0],
                        'redirect' => site_url('admin/creatives/add_web_creatives/')
                    );
                }
                $this->response($success, 200);
            } else {
                if ($this->user_authentication->account_type === "ADVERTISER") {
                    $error = array(
                        'response' => 'error',
                        'msg' => 'Error. Please try again',
                        'redirect' => site_url('advertiser/creatives/add_web_creatives/')
                    );
                } else {
                    $error = array(
                        'response' => 'error',
                        'msg' => 'Error. Please try again',
                        'redirect' => site_url('admin/creatives/add_web_creatives/')
                    );
                }
                $this->response($error, 200);
            }
        }
    }
    /*
     * 
     * name		: display_url_get
     * @param   : None
     * @purpose  : Fetch Url
     */
    function display_url_get()
    {
        $bannerid = $_GET['bannerid'];
        $url_list = $this->do_creative->fetch_url($bannerid);
        if ($url_list) {
            $this->response($url_list, 200); // 200 being the HTTP response code
        } else {
            $this->response(array(
                'error' => 'No creatives'
            ), 404);
        }
    }
    /*
     * 
     * name		: update_url_post
     * @param   : NOne
     * @purpose  : update url content
     */
    public function update_url_post()
    {
        /*
        $fname 		= 	$this->post('tit');
        
        $id 		= 	$this->post('id');
        
        if($fname =='title')
        {
        $where_data	=	array(	'statustext' => $this->post('val'),
        'description'=>$this->post('val')
        );
        }
        else if($fname =='desc')
        {
        $where_data	=	array('htmltemplate' => $this->post('val'));
        }
        else if($fname =='feed')
        {
        $where_data = 	array(	'feed_status' 	=> 	$this->post('feed_status'),
        'feed_url'		=>	$this->post('feed')
        );	
        }
        else if($fname == 'img')
        {
        $where_data = 	array(	'contenttype' 	=> 	$this->post('file_type'),
        'imageurl'		=>	$this->post('file_name'),
        'storagetype'	=>	'web'
        );	
        }
        else
        {
        $where_data = 	array(	'impression'=> 	$this->post('imp'),
        'click'		=>	$this->post('cname')
        );	
        }
        
        $update_url = 	$this->do_creative->update_url($id,$where_data);
        
        if($update_url)
        {	
        $is_creative_moved=$this->image_lib->move_creative_to_original_location($this->post('file_name'));
        
        $this->response( $update_url, 200);
        }		
        else
        {
        $error 		= 	array(
        'response' 	=> 	'error'
        );
        $this->response( $error, 200);
        }		*/
        $fname      = clean_data($this->post('tit'));
        $id         = clean_data($this->post('id'));
        $impression = clean_data($this->post('imp'));
        $where_data = array(
            'description' => clean_data($this->post('imp')),
            'htmltemplate' => clean_data($this->post('val')),
            'embed' => clean_data($this->post('emb')),
            'storagetype' => 'url',
            'imageurl' => clean_data($this->post('imageurl'))
        );
        $update_url = $this->do_creative->update_url($id, $where_data);
        //	$this->response($this->post('file_name'),200);
        if ($update_url) {
            $is_creative_moved = $this->image_lib->move_creative_to_original_location(clean_data($this->post('imageurl')));
            $this->response($update_url, 200);
        } else {
            $error = array(
                'response' => 'error'
            );
            $this->response($error, 200);
        }
    }
    /*
     * 
     * name: approve_creative_get
     * @param :
     * @return : $success
     */
    public function approve_creative_get()
    {
        $banner_id = $this->get('banner_id');
        if ($banner_id) {
            $banner_ids = explode(',', $banner_id);
            if (is_array($banner_ids) && count($banner_ids) > 1) {
                foreach ($banner_ids as $ban_id) {
                    $this->creative_appr($ban_id);
                }
                $success = array(
                    'response' => 'ok',
                    'msg' => 'Creatives have been Approved successfully'
                );
                $this->response($success);
            } else {
                $this->creative_appr($banner_id);
                $success = array(
                    'response' => 'ok',
                    'msg' => 'Creative has been Approved successfully'
                );
                $this->response($success);
            }
        }
    }
    function creative_appr($banner_id)
    {
        //CHECK THE CREATIVE IS APPROVED / REJECTED PREVIOUSLY
        $creative_id = $this->do_creative->is_creative_id($banner_id);
        if ($creative_id != '') {
            $approve_list = $this->do_creative->approve_creative($banner_id);
            if ($approve_list) {
                /* Activity Log for approve creative - Start*/
                //$this->appr_activity_log(CAMPAIGN,PAUSE,$campaign_id);
                $enable = $this->default_configurations->activity_log_setting(CREATIVES, CREATIVE_APPR);
                if ($enable == '1') {
                    $user_agent    = $this->user_authentication->user_agent;
                    $browser       = $this->user_authentication->browser;
                    $os            = $this->user_authentication->os;
                    $ip            = $_SERVER['REMOTE_ADDR'];
                    $date          = date("Y-m-d h:i:sa");
                    $account_id    = $this->user_authentication->account_id;
                    $advertiser_id = $this->user_authentication->client_id;
                    $module        = BANNER;
                    $process       = APPROVE;
                    $banner_id     = $banner_id;
                    $activity_log  = array(
                        "account_id" => $account_id,
                        "useragent" => $user_agent,
                        "browser" => $browser,
                        "os" => $os,
                        "ip" => $ip,
                        "date" => $date,
                        "module" => $module,
                        "process" => $process,
                        "advertiser_id" => $advertiser_id,
                        "banner_id" => $banner_id
                    );
                    $this->do_app_config->activity_log($account_id, $activity_log);
                }
                /* Activity Log for approve creative - End*/
                //Get advertiser details
                $advertiser_details = $this->do_advertiser->get_profile($approve_list['dj_account_id']);
                $campaign_det       = $this->do_campaign->fetch_campaign_details($campaign_id);
                //$mail_msg=$this->do_mailmsg->fetch_notifications($approve_list['dj_account_id']);
                $msg_val            = $mail_msg['0']['msg_type'];
                $creative_appr      = $mail_msg['0']['campaigns'];
                $creative_appr_val  = explode(',', $creative_appr);
                //Get admin details
                if ($this->user_authentication->account_type == "ADMIN") {
                    $agency_id    = $this->user_authentication->agency_id;
                    $result       = $this->do_networks->agency_owner_details($agency_id);
                    $user         = $this->do_message->get_profile(ADMIN_ID);
                    $account_id   = $approve_list['dj_account_id'];
                    $network_id   = $this->do_message->fetch_admin_network_id();
                    $mail_type    = "ADVERTISER_CREATIVE_APPROVAL";
                    $acc_type     = 'ADMIN';
                    $type_details = array(
                        'msg_type' => $message,
                        'type' => "ADVERTISER_CREATIVE_APPROVAL",
                        'string' => 'creative_appr',
                        'column_name' => 'campaigns'
                    );
                    $message_data = array(
                        'sender_id' => ADMIN_ID,
                        'receiver_id' => $approve_list['dj_account_id'],
                        'subject' => 'Advertiser - Creative',
                        'content' => 'Creative approved successfully',
                        'image_name' => NULL,
                        'file_name' => NULL,
                        'account_type' => "ADVERTISER",
                        'status' => '1',
                        'network_id' => $network_id,
                        'notification_type' => 'campaign_setting',
                        'dj_is_admarket' => $campaign_det[0]['dj_is_admarket'],
                        'date' => date('Y-m-d H:i:s')
                    );
                    $admin_name   = $user['first_name'] . ' ' . $user['last_name'];
                    $admin_email  = $user['email'];
                    $user_email   = $advertiser_details['email'];
                    $user_name    = $advertiser_details['first_name'] . ' ' . $advertiser_details['last_name'];
                    $from         = $admin_email;
                    $to           = $user_email;
                    $mail_content = array(
                        "subject" => "Creative approved",
                        "to_name" => $user_name,
                        "from_name" => $admin_name,
                        "email" => $user_email,
                        'banner_name' => $approve_list['description']
                    );
                    $attachement  = '';
                    //	$this->response($advertiser_details,200);
                    $dat          = $this->notification->new_mail($message_data, $user, $advertiser_details, $type_details, $mail_content);
                } else {
                    // IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
                    $manager_user_id = $this->user_authentication->manager_user_id;
                    $is_manager      = $this->do_networks->get_manager_role($manager_user_id);
                    if ($is_manager == 1) {
                        // GET MANAGER MAILING DETAILS FOR FROM ADDRESS
                        $agency_id     = $this->user_authentication->agency_id;
                        $result        = $this->do_networks->agency_owner_details($agency_id);
                        // GET NETWORK ADMIN DETAILS FOR BCC
                        $network_admin = $this->do_networks->get_network_details();
                        $bcc           = $network_admin['email'];
                        $admin_name    = $result['name'];
                        $admin_email   = $result['email'];
                        $user_email    = $advertiser_details['email'];
                        $user_name     = $advertiser_details['first_name'] . " " . $advertiser_details['last_name'];
                        $type          = "ADVERTISER_CREATIVE_APPROVAL";
                        $from          = $admin_email;
                        $to            = $user_email;
                        $mail_content  = array(
                            "subject" => "Creative approved",
                            "to_name" => $user_name,
                            "from_name" => $admin_name,
                            "email" => $user_email,
                            'banner_name' => $approve_list['description'],
                            'contenttype' => $approve_list['dj_banner_type']
                        );
                        $network_id    = $this->do_message->fetch_admin_network_id();
                        $user          = $this->do_message->get_profile(ADMIN_ID);
                        $account_id    = $approve_list['dj_account_id'];
                        $network_id    = $this->do_message->fetch_admin_network_id();
                        $mail_type     = "ADVERTISER_CREATIVE_APPROVAL";
                        $acc_type      = 'ADMIN';
                        $type_details  = array(
                            'msg_type' => $message,
                            'type' => "ADVERTISER_CREATIVE_APPROVAL",
                            'string' => 'creative_appr',
                            'column_name' => 'campaigns'
                        );
                        $message_data  = array(
                            'sender_id' => ADMIN_ID,
                            'receiver_id' => $approve_list['dj_account_id'],
                            'subject' => 'Advertiser - Creative',
                            'content' => 'Creative approved successfully',
                            'image_name' => NULL,
                            'file_name' => NULL,
                            'account_type' => "ADVERTISER",
                            'status' => '1',
                            'network_id' => $network_id,
                            'notification_type' => "campaign_setting",
                            'dj_is_admarket' => $campaign_det[0]['dj_is_admarket'],
                            'date' => date('Y-m-d H:i:s')
                        );
                        $admin_name    = $user['first_name'] . ' ' . $user['last_name'];
                        $admin_email   = $user['email'];
                        $user_email    = $advertiser_details['email'];
                        $user_name     = $advertiser_details['first_name'] . ' ' . $advertiser_details['last_name'];
                        $from          = $admin_email;
                        $to            = $user_email;
                        $mail_content  = array(
                            "subject" => "Creative approved",
                            "to_name" => $user_name,
                            "from_name" => $admin_name,
                            "email" => $user_email,
                            'banner_name' => $approve_list['description']
                        );
                        $attachement   = '';
                        //	$this->response($advertiser_details,200);
                        $dat           = $this->notification->new_mail($message_data, $user, $advertiser_details, $type_details, $mail_content);
                    } else {
                        // GET NETWORK USERS MAILING DETAILS
                        $user_mailing_details = $this->do_networks->get_network_users_detail($manager_user_id);
                        $admin_email          = $user_mailing_details['email_address'];
                        $admin_name           = $user_mailing_details['contact_name'];
                        // GET NETWORK MANAGER MAILING DETAIL FOR BCC
                        $agency_id            = $this->user_authentication->agency_id;
                        $result               = $this->do_networks->agency_owner_details($agency_id);
                        $bcc                  = $result['email'];
                        $attachement          = '';
                        $user                 = $this->do_message->get_profile(ADMIN_ID);
                        $account_id           = $approve_list['dj_account_id'];
                        $network_id           = $this->do_message->fetch_admin_network_id();
                        $mail_type            = "ADVERTISER_CREATIVE_APPROVAL";
                        $acc_type             = 'ADMIN';
                        $type_details         = array(
                            'msg_type' => $message,
                            'type' => "ADVERTISER_CREATIVE_APPROVAL",
                            'string' => 'creative_appr',
                            'column_name' => 'campaigns'
                        );
                        $message_data         = array(
                            'sender_id' => ADMIN_ID,
                            'receiver_id' => $approve_list['dj_account_id'],
                            'subject' => 'Advertiser - Creative',
                            'content' => 'Creative approved successfully',
                            'image_name' => NULL,
                            'file_name' => NULL,
                            'account_type' => "ADVERTISER",
                            'status' => '1',
                            'network_id' => $network_id,
                            'notification_type' => "campaign_setting",
                            'dj_is_admarket' => $campaign_det[0]['dj_is_admarket'],
                            'date' => date('Y-m-d H:i:s')
                        );
                        $admin_name           = $user['first_name'] . ' ' . $user['last_name'];
                        $admin_email          = $user['email'];
                        $user_email           = $advertiser_details['email'];
                        $user_name            = $advertiser_details['first_name'] . ' ' . $advertiser_details['last_name'];
                        $from                 = $admin_email;
                        $to                   = $user_email;
                        $mail_content         = array(
                            "subject" => "Creative approved",
                            "to_name" => $user_name,
                            "from_name" => $admin_name,
                            "email" => $user_email,
                            'banner_name' => $approve_list['description']
                        );
                        $attachement          = '';
                        //	$this->response($advertiser_details,200);
                        $dat                  = $this->notification->new_mail($message_data, $user, $advertiser_details, $type_details, $mail_content);
                    }
                }
            }
        } else {
            $success = array(
                'response' => 'ok',
                'msg' => 'Creative has been Approved / Rejected Previously by admin'
            );
            $this->response($success);
        }
    }
    /*
     * 
     * name: disable_get
     * @param :
     * @return : $creative_id
     * 
     * Disable the given creative id
     */
    function disable_get()
    {
        $creative_id   = $this->get('dis_banner_id');
        $creative_name = '';
        if ($creative_id) {
            $bannerid = explode(',', $creative_id);
            if (is_array($bannerid)) {
                foreach ($bannerid as $creative_id) {
                    $camp_name = $this->do_creative->fetch_campaignid_creative($creative_id);
                    $creative_name .= $camp_name[0]['description'] . ',';
                    $creative_details = $this->do_creative->disable_creative($creative_id);
                }
            } else {
                $camp_name = $this->do_creative->fetch_campaignid_creative($creative_id);
                $creative_name .= $camp_name[0]['description'] . ',';
                if ($camp_name[0]['dj_disable'] !='1')
				{
					$creative_details = $this->do_creative->disable_creative($creative_id);
				}
				else
				{
					$success = array('response'	=> 'ok',
						 'msg'		=> 'Creative has already disabled'
						 );
					$this->response( $success, 200);
				}
            }
            /***creative edit for message/mail notification*****/
            $creative_dat             = $this->do_creative->fetch_campaignid_creative($creative_id);
            $campaign_id              = $creative_dat[0]['campaignid'];
            //$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
            $content['sub']           = 'Creatives Disabled';
            $content['data']          = 'The Creatives ' . rtrim($creative_name, ",") . ' has been disabled successfully';
            $content['content']       = 'Creative has been disabled successfully.';
            $content['creative_name'] = rtrim($creative_name, ",");
            $creative_add             = $this->do_message->mail_to_lib_advertiser('creative_disable', 'campaigns', null, $content, $campaign_id);
            /***creative edit for message/mail notification*****/
            /***Activity Log For adding creatives ***/
            $enable                   = $this->default_configurations->activity_log_setting(CREATIVES, CREATIVE_DIS);
            if ($enable == '1') {
                $creative_add = $this->add_activity_log(BANNER, DISABLE, $creative_id, $campaign_id);
            }
            /***Activity Log For adding creatives ***/
            $success = array(
                'response' => 'ok',
                'msg' => 'Creative has been disabled'
            );
            $this->response($success, 200);
        } else {
            $error = array(
                'response' => 'error',
                'msg' => 'Please try again'
            );
            $this->response($error, 200);
        }
    }
    /*
     * 
     * name: enable_get
     * @param :
     * @return : $creative_id
     * 
     * Enable the given creative id
     */
    function enable_get()
    {
        $creative_id   = $this->get('ena_banner_id');
        $creative_name = '';
        if ($creative_id) {
            $bannerid = explode(',', $creative_id);
            if (is_array($bannerid)) {
                foreach ($bannerid as $creative_id) {
                    $camp_name = $this->do_creative->fetch_campaignid_creative($creative_id);
                    $creative_name .= $camp_name[0]['description'] . ',';
                    $creative_details = $this->do_creative->enable_creative($creative_id);
                }
            } else {
                $camp_name = $this->do_creative->fetch_campaignid_creative($creative_id);
                $creative_name .= $camp_name[0]['description'] . ',';
                if ($camp_name[0]['dj_disable'] !='0')
				{
					$creative_details = $this->do_creative->enable_creative($creative_id);
				}
				else
				{
					$success = array('response'	=> 'ok',
						 'msg'		=> 'Creative has already enabled'
						 );
					$this->response( $success, 200);
				}
            }
            /***creative edit for message/mail notification*****/
            $creative_dat             = $this->do_creative->fetch_campaignid_creative($creative_id);
            $campaign_id              = $creative_dat[0]['campaignid'];
            //$campaign_det = $this->do_campaign->fetch_campaign($campaign_id);
            $content['sub']           = 'Creatives Enabled';
            $content['data']          = 'The Creatives ' . rtrim($creative_name, ",") . ' has been enabled successfully';
            $content['content']       = 'Creative has been enabled successfully.';
            $content['creative_name'] = rtrim($creative_name, ",");
            $creative_add             = $this->do_message->mail_to_lib_advertiser('creative_enable', 'campaigns', null, $content, $campaign_id);
            /***creative edit for message/mail notification*****/
            /***Activity Log For adding creatives ***/
            $enable                   = $this->default_configurations->activity_log_setting(CREATIVES, CREATIVE_ENA);
            if ($enable == '1') {
                $creative_add = $this->add_activity_log(BANNER, ENABLE, $creative_id, $campaign_id);
            }
            /***Activity Log For adding creatives ***/
            $success = array(
                'response' => 'ok',
                'msg' => 'Creative has been enabled'
            );
            $this->response($success, 200);
        } else {
            $error = array(
                'response' => 'error',
                'msg' => 'Please try again'
            );
            $this->response($error, 200);
        }
    }
    function fetch_creative_name_get()
    {
        //Get account id from library file
        $account_id = $this->user_authentication->account_id;
        $cam_id     = $this->get('cam_id');
        if ($account_id && $cam_id) {
            $creative_details = $this->do_creative->fetch_creative_names($cam_id);
            if ($creative_details) {
                $this->response($creative_details, 200); // 200 being the HTTP response code
            } else {
                $this->response(array(
                    'error' => 'No details found'
                ), 404);
            }
        }
    }
    public function fetch_browser_versions_get()
    {
        $browser_version_list = $this->do_creative->fetch_browser_versions();
        $this->response($browser_version_list);
    }
    function add_activity_log($module, $process, $banner_id = false, $campaign_id = FALSE)
    {
        /* Activity Log for Add/Edit/Delete site - Start*/
        $user_agent   = $this->user_authentication->user_agent;
        $browser      = $this->user_authentication->browser;
        $os           = $this->user_authentication->os;
        $ip           = $_SERVER['REMOTE_ADDR'];
        $date         = date("Y-m-d h:i:s");
        $account_id   = $this->user_authentication->account_id;
        $adv_id       = $this->user_authentication->client_id;
        $activity_log = array(
            "account_id" => $account_id,
            "useragent" => $user_agent,
            "browser" => $browser,
            "os" => $os,
            "ip" => $ip,
            "date" => $date,
            "module" => $module,
            "process" => $process,
            "advertiser_id" => $adv_id,
            "campaign_id" => $campaign_id,
            "banner_id" => $banner_id
        );
        $this->redis_library->logcount($account_id, $activity_log);
    }
    public function banner_mass_import_post()
    {
        
        
        $file_id = $this->post('upload_name');
       
         
        //$admarket = $this->post('admarket'); // val is 1 admarket val is 0 normal campaign import
        if ($file_id != '') {
            $upload_extension = explode(".", $file_id);
            
            if ($upload_extension[1] == 'csv') {
                
                $csvfilepath = $this->config->item('read_csv');
                $file_name   = $this->getLatestFile($csvfilepath);
                
                
                $data = $this->csvreader->parse_file($file_name);
                
                
                $counter     = '1';
                $ext_counter = 1;
                $insert_rec  = array();
                $exist_rec   = array();
                $num_rows    = count($data);
                
                if ($num_rows > 0) {
                    foreach ($data as $row) {
                         
                        if ($row['campaignid'] != '' && $row['bannerid'] != '') {
                         /*   $campaignname                    = trim($row['campaignname']);
                            $clientid                        = trim($row['clientid']);
                            $views                           = trim($row['views']);
                            $clicks                          = trim($row['clicks']);
                            $conversions                     = trim($row['conversions']);
                            $priority                        = trim($row['priority']);
                            $weight                          = trim($row['weight']);
                            $revenue                         = trim($row['revenue']);
                            $revenue_type                    = trim($row['revenue_type']);
                            $block                           = trim($row['block']);
                            $capping                         = trim($row['capping']);
                            $session_capping                 = trim($row['session_capping']);
                            $status                          = trim($row['status']);
                            $dj_budget_status                = trim($row['dj_budget_status']);
                            $viewwindow                      = trim($row['viewwindow']);
                            $clickwindow                     = trim($row['clickwindow']);
                            $ecpm                            = trim($row['ecpm']);
                            $min_impressions                 = trim($row['min_impressions']);
                            $activate_time                   = trim($row['activate_time']);
                            $expire_time                     = trim($row['end_time']);
                            $cpv_percentage                  = trim($row['cpv_percentage']);
                            $an_status                       = trim($row['cam_status']);
                            $dj_campaign_budget              = trim($row['dj_campaign_budget']);
                            $dj_is_retargeted                = trim($row['dj_is_retargeted']);
                            $behavior                        = trim($row['behavior']);
                            $dj_max_retargetting             = trim($row['dj_max_retargetting']);
                            $dj_daily_budget                 = trim($row['dj_daily_budget']);
                            $daily_budget_unlimit            = trim($row['daily_budget_unlimit']);
                            $dj_campaign_remain_budget       = trim($row['dj_campaign_remain_budget']);
                            $dj_campaign_remain_total_budget = trim($row['dj_campaign_remain_total_budget']);
                            $dj_current_date                 = trim($row['dj_current_date']);
                            $dj_targetting_type              = trim($row['dj_targetting_type']);
                            $group_id                        = trim($row['group_id']);
                            $global_tracker                  = trim($row['global_tracker']);
                            $trackerid                       = trim($row['trackerid']);
                            
                            
                            */
                            if (empty($expire_time) || $expire_time == '') {
                                
                                $expire_time1 = NULL;
                            } else {
                                
                                $expire_time1 = $expire_time;
                            }
                            
                            $import_banner_data = array(
                                //"contenttype"        =>    clean_data($this->post('tmp_game1_creative_content_type')),
                                "campaignid" => clean_data($row['campaignid']),
                                "storagetype" => clean_data($row['storagetype']),
                                "width" => clean_data($row['width']),
                                "height" => clean_data($row['height']),
                                "description" => clean_data($row['description']),
                                "url" => clean_data($row['url']),
                                "dj_admin_approve" => clean_data($row['dj_admin_approve']),
                                "dj_approved_date" => clean_data($row['dj_approved_date']),
                                "dj_banner_type" => clean_data($row['dj_banner_type']),
                                //    "dj_added_date"        =>    clean_data(date('Y:m:d :H:i:s')),
                                //    "dj_account_id"     =>     clean_data($dj_account_id),
                                "dj_is_direct" => clean_data($row['dj_is_direct']),
                                "dj_image_path" => $row['dj_image_path'],
                                "dj_admarket_status" => $row['dj_admarket_status'],
                                "filename" => $row['filename'],
                                "bannertext" => $row['bannertext'],
                                "backgroundcolor" => $row['backgroundcolor'],
                                //    "imagename" =>  $row['imagename'],
                                "imageurl" => $row['imageurl'],
                                "htmltemplate" => $row['htmltemplate'],
                                "htmlcache" => $row['htmlcache'],
                                "dj_banner_type" => $row['dj_banner_type'],
                                "dj_admin_approve" => $row['dj_admin_approve'],
                                "dj_approved_date" => $row['dj_approved_date'],
                                "dj_banner_type" => $row['dj_banner_type'],
                                "dj_is_direct" => $row['dj_is_direct'],
                                "dj_image_path" => $row['dj_image_path'],
                                "dj_admarket_status" => $row['dj_admarket_status'],
                                "dj_is_admarket" => $row['dj_is_admarket'],
                                "fontcolor" => $row['fontcolor'],
                                "file_size" => $row['file_size']
                            );
                            
                            //Call to add a creative
                            $blob_data           = FALSE;
                            $add_banners_details = $row['add_banner_id'];
                            if ($add_banners_details) {
                                $import_add_banner = array(
                                    "banner_id" => clean_data($row['add_banner_id']),
                                    "file_path" => clean_data($row['file_path']),
                                    "width" => clean_data($row['width']),
                                    "height" => clean_data($row['height']),
                                    "link_url" => clean_data($row['link_url']),
                                    "ban_description" => clean_data($row['ban_description']),
                                    "content_type" => clean_data($row['content_type']),
                                    "display_type" => clean_data($row['display_type']),
                                    "display_size" => clean_data($row['display_size']),
                                    //"display_size"        =>    clean_data($row['display_size']),
                                    "position" => clean_data($row['position']),
                                    "dj_content_video_url" => clean_data($row['dj_content_video_url']),
                                    "dj_video_thumb_img" => clean_data($row['dj_video_thumb_img']),
                                    "dj_content_ad_message" => clean_data($row['dj_content_ad_message']),
                                    "dj_social_networking" => clean_data($row['dj_social_networking']),
                                    "dj_image_path" => clean_data($row['add_dj_image_path']),
                                    "dj_admarket_status" => clean_data($row['dj_admarket_status']),
                                    "dj_file_size" => clean_data($row['dj_file_size']),
                                    "dj_admarket_lang" => clean_data($row['dj_admarket_lang'])
                                );
                            }
                            
                            if ($import_banner_data) {
                                
                                $result[] = $this->do_mobile_creative->add($import_banner_data,$blob_data);
                                if ($import_add_banner) {
                                    $addintional_ = $this->do_mobile_creative->add_child($import_add_banner, $blob_data);
                                }
                                
                                $insert_rec[] = $counter;
                                
                            } else {
                                $exist_rec[] = $ext_counter;
                            }
                            $counter++;
                            $ext_counter++;
                            
                        } else {
                            $error = array(
                                'response' => 'error',
                                // 'msg'        => 'required fields are empty',
                                // 'error_msg'=> $ex_count.' uploaded file(s) are already Exists !' 
                                'msg' => 'The file contains invalid data for this operation..'
                            );
                            $this->response($error, 200);
                        }
                        
                    }
                    if (count($insert_rec) > 0 && count($exist_rec) > 0) {
                        $ins_count = count($insert_rec);
                        $ex_count  = count($exist_rec);
                        $success   = array(
                            'response' => 'ok_error',
                            'msg' => $ins_count . ' record(s) are inserted successfully',
                            'error_msg' => $ex_count . ' uploaded file(s) are already Exists !',
                            'id' => $result
                        );
                        $this->response($success, 200);
                    } else if (count($insert_rec) > 0 && count($exist_rec) <= 0) {
                        
                        $ins_count = count($insert_rec);
                        $success   = array(
                            'response' => 'ok',
                            'msg' => $ins_count . ' record(s) are inserted successfully',
                            'id' => $result
                        );
                        $this->response($success, 200);
                    } else if (count($exist_rec) > 0 && count($insert_rec) <= 0) {
                        $ex_count = count($exist_rec);
                        $error    = array(
                            'response' => 'error',
                            'msg' => $ex_count . ' uploaded file(s) are already Exists ! '
                        );
                        $this->response($error, 200);
                    }
                } else {
                    $error = array(
                        'response' => 'error',
                        'redirect' => site_url('admin/settings/mass_import'),
                        'msg' => 'There is no datas in the file!..'
                    );
                    
                    $this->response($error, 200);
                }
            } else {
                $error = array(
                    'response' => 'error',
                    'msg' => 'Please select a valid CSV file to upload!..'
                );
                
                $this->response($error, 200);
                
            }
        } else {
            $error = array(
                'response' => 'error',
                'msg' => 'Please select a valid CSV file to upload!..'
            );
            
            $this->response($error, 200);
        }
        
        
        
    }
    
    function getLatestFile($directoryPath)
    {
        $directoryPath = rtrim($directoryPath, '/');
        
        $max = array(
            'path' => null,
            'timestamp' => 0
        );
        
        foreach (scandir($directoryPath, SCANDIR_SORT_NONE) as $file) {
            $path = $directoryPath . '/' . $file;
            if (!is_file($path)) {
                continue;
            }
            $timestamp = filemtime($path);
            if ($timestamp > $max['timestamp']) {
                $max['path']      = $path;
                $max['timestamp'] = $timestamp;
            }
        }
        
        return $max['path'];
    }
}
