<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Countrywise Bidding
 *
 */

class Countrywise_bidding extends REST_Controller
{
	
	function __construct()
	{
		
		parent::__construct();
		$this->load->library('redis_library');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->library('csvreader');
		$this->load->model('do_country');
		$this->load->model('do_campaign');
		$this->load->model('do_special_bidding');
		$this->load->library('csvreader');
		$this->load->library('user_authentication');
		$this->load->model('do_app_config');
		$this->load->model('do_message');
		$this->load->library('notification');
	    $key=$this->input->get_post('api_key');
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
         $this->load->model('do_networks');
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	} 
	
	 /*
	 * 
	 * name: fetch_countrylist
	 * @param :
	 * @return : $country_list
	 * 
	 * Lists selected countries of an advertiser
	 */
	
	function fetch_countrylist_get()
	{				
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		else
		{
			$account_id = '';//$this->user_authentication->default_advertiser_account_id;
		}		
		
		$country=$this->do_country->list_country();	
		 
		if($country)
		{
			$this->response($country, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'Country could not be found'),404);
		}		
	}
	
	function fetch_biddingcountrylist_get()
	{		
		$filter	=	clean_data($this->get('filter'));
		$admarket = clean_data($this->get('admarket'));
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = 	$this->user_authentication->account_id;
		}
		else
		{
			$account_id = 	'';//$this->user_authentication->default_advertiser_account_id;
		}
										
		$country=$this->do_country->list_bidding_country($account_id,$filter,$admarket);	
				 						 
		if($country)
		{
			$this->response($country, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'Country could not be found'),404);
		}
	}
		
	
	function fetch_unbiddingcountrylist_get()
	{
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		else
		{
			$account_id = '';//$this->user_authentication->default_advertiser_account_id;
		}
		
		$admarket = clean_data($this->get('admarket'));
		
		$country=$this->do_country->list_unbidding_country($account_id,$admarket);	
		 
		if($country)
		{
			$this->response($country, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'Country could not be found'),404);
		}
	}
		
	
	/*public function import_bidding_file_post()
	{	
		$file_id=$this->post('upload_name');	
		
		if($file_id!='')
		{
			$upload_extension = explode(".", $file_id);		
			
			if($upload_extension[1]=='csv' || $upload_extension[1]=='txt')
			{
				
					$csvfilepath 	= $this->config->item('read_csv');	
					$file_name		= $this->getLatestFile($csvfilepath);					
					$data	 		= $this->csvreader->parse_file($file_name);
					$counter		= '1';	
					$ext_counter=1;
					$insert_rec=array();
					$exist_rec=array();
					$num_rows=count($data);					
					if($num_rows>0)
					{
						foreach($data as $row)
						{
								$url= trim($row['url']);
								$check_exist = $this->do_adblock_domains->exists_check($url);
								if($check_exist=='NULL')
								{
										$domain_id=$this->do_adblock_domains->add($url);
										$insert_rec[] =$counter;	
											
										$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,DOMAIN_ADD);
										if($enable=='1')
										{							
										$this->activity_log(ADBLOCK_DOMAIN,ADD);
										}
																					
								}
								else
								{
										$exist_rec[]=$ext_counter;
								}
						$counter++;	
						$ext_counter++;						
						}
						
						if(count($insert_rec)>0 && count($exist_rec) >0)
						{
								$ins_count = count($insert_rec);
								$ex_count= count($exist_rec);
								$success = array('response'	=> 'ok_error',
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												 'error_msg'=> $ex_count.' uploaded file(s) are already Exists !' 
												 ); 
								$this->response($success,200);
						}
						else if(count($insert_rec)>0 && count($exist_rec)<=0)
						{
								$ins_count = count($insert_rec);
								$success = array('response'	=> 'ok',
												 'msg'		=> $ins_count.' record(s) are inserted successfully'
												 ); 
								$this->response($success,200);
						}
						else if(count($exist_rec) >0&& count($insert_rec)<=0)
						{
								$ex_count= count($exist_rec);
									$error = array(
										   'response' => 'error',
										   'msg' =>  $ex_count.' uploaded file(s) are already Exists ! '
										  );
									$this->response( $error, 200);
						}
					}
					else
					{
						$error = array(
									'response' => 'error',
									'redirect'=>site_url('advertiser/countrywise_bidding/'),
									'msg'	 => 'There is no datas in the file!..'
									);
				  
						$this->response($error, 200);	
					}														
			}
			else
			{
				$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV/TXT file to upload!..'
							);
	  
				$this->response($error, 200);	
					
			}		
		}
		else
		{
			$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV/TXT file to upload!..'
						);
	  
			$this->response($error, 200);
		}		
							
	}
		*/
	//export for country list
	
	public function fetch_country_export_data_get()
	{
		$campaign_id=$this->get('campaign_id');
		
		$admarket=$this->get('admarket');
		
					
		$export_data = $this->do_country->fetch_export_country_data(explode(',',$campaign_id),$admarket);
 
		
		if(!empty($export_data))
		{
				$this->response( $export_data, 200);
			
		}
		else
		{
			$this->response( 'error', 200);
		}
	}
	
	/*
	 * 
	 * 
	 * name: add_countrywise_bidding_post
	 * @param
	 * @return:response array
	 * 
	 * In this method we will manage add country bidding process
	 */
	 
	public function add_countrywise_bidding_post()
	{   
		
		$this->form_validation->set_rules('country_name','Country name', 'required|trim');
		$this->form_validation->set_rules('bidding_value', 'Bidding Value', 'required|trim');

		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			if($this->user_authentication->account_type=='ADVERTISER')
			{
				$dj_account_id	=	$this->user_authentication->account_id;
			}
			else
			{
				$dj_account_id	=	$this->post('adv_id');
			}
			
			$campaign_name	= 	clean_data($this->post('campaign_name'));	
			$campaign_type	=	$this->post('def_campaign_type');	
			$country_name	= 	$this->post('country_name');
			$bidding_value	=	$this->post('bidding_value');
			$admarket		=   $this->post('admarket');  
			
			$bidding_data 	= 	array(
									"campaign_id"	=>	clean_data($campaign_name),
									"revenue_type"	=>	clean_data($campaign_type),
									"bidding_value"	=>	clean_data($bidding_value),
									"country_value"	=>	clean_data($country_name),
									"account_id" 	=> 	clean_data($dj_account_id),
									"admarket"		=>  clean_data($admarket)
								);
			$country_add	=	$this->do_country->add_countrybidding($bidding_data);
					
			if($country_add)
			{
				/* Activity Log for Add countrybidding - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK,COUNTRY_BIDDING_ADD);
					
					if($enable=='1')
					{				
						$this->bid_activity_log(COUNTRY_BIDDING,ADD,$country_add);
					}
					
					$client_id 		=	$this->user_authentication->client_id;
					$account_type	=	$this->user_authentication->account_type;	
					$network_id		=	$this->user_authentication->network_account_id;					
					$agency_id		=	$this->user_authentication->agency_id;
					$result			=	$this->do_networks->agency_owner_details($agency_id);
					$admin_name    	= 	$result['name'];			
					$admin_email	= 	$result['email'];	
					$admin_id   	= 	$result['account_id'];

					if($account_type=='ADVERTISER')
					{
						$message  = $this->default_configurations->get('message_type');
							
						$user = $this->do_message->get_profile($admin_id); 
						
						$acc_type='ADVERTISER';
						
						$type_details		=	array(
													'msg_type'		=> $message,
													'type'			=> "ADMIN_MESSAGE_SETTINGS",
													'string'		=> 'cour_bidd_add',
													'column_name'	=> 'network_settings'
													);
												
						if($campaign_name!='-1')
						{
							$reciever= $this->do_campaign->fetch_reciever($campaign_name);
							$rec_accountid=$reciever['account_id'];
							$rec_admarket=$reciever[0]['dj_is_admarket'];
						}
						else
						{
							$rec_accountid=$dj_account_id;
							$rec_admarket=$admarket;
						}				
						
						
						
						$message_data		=	array(
													'sender_id'		=>	$admin_id,
													'receiver_id'	=>	$rec_accountid,
													'dj_is_admarket'=>	$rec_admarket,
													'subject'		=>	'CountryBidding Added',
													'content'		=>	'Congrats! A  New CountryBidding has been added successfully.',
													'image_name'	=>	NULL,
													'file_name'		=>	NULL,
													'account_type'	=>	$acc_type,
													'status'		=>	'1',
													'network_id'	=>	$network_id,									
													'date'			=>	date('Y-m-d H:i:s'));
													
						$notification_msg = $this->do_message->get_notification_msg('ad_cour_bidd_add'); 
						if($notification_msg[0]['msg_type']=='1')
						{
							$notification_content = $notification_msg[0]['content'];
						}
						else
						{
							$template_filename = $notification_msg[0]['template_filename'];
							$csvfilepath 	= $this->config->item('read_settings');	
							$notification_content = file_get_contents($csvfilepath.$template_filename);
														
						}		
						$adgate_url	=	base_url();
						$prod_name	= 	$this->config->item('prod_name');
						$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
						$msg_replace = str_replace("{{advertiser_name}}",$reciever['name'],$msg_replace);	
						
						$msg_replace = str_replace("{{admin_name}}",$user['first_name'].' '.$user['last_name'],$msg_replace);
						$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace);
						$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$this->config->item('click_directADS').'</a>' ,$msg_replace);	
						
						$dd = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace);													

						//$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details);
							
					}
					
					
					
					/* Activity Log for Add countrybidding - End*/
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Country bidding sucessfully added',
									'redirect'	 	=> 	site_url('advertiser/network/add_countrywise_bidding/'),
									);						
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Country bidding sucessfully added',
									'redirect'	 	=> 	site_url('admin/network/add_countrywise_bidding/'),
									);	
				}
				
				$this->response( $success, 200);
				
			}
			else
			{
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('advertiser/network/add_countrywise_bidding/'),
								);					
				}
				else
				{
					$error = array(
								'response' 		=> 	'error',
								'msg'	 		=> 	'Error. Please try again',
								'redirect'	 	=> 	site_url('admin/network/add_countrywise_bidding/'),
								);	
				}	
				
				$this->response( $error, 200);
			}		
	
					
			
			
			
		}
		
	}
	
	
	/*
	 * 
	 * name: delete_get
	 * @param :
	 * @return : $creative_id
	 * 
	 * Delete the given creative id
	 */
	
	function delete_get()
	{
		$country_id = $this->get('country_id');	
		
		$admarket = $this->get('admarket');

		if($country_id)
		{	
			//$reciever= $this->do_country->fetch_country_reciever($country_id,$admarket);
									
			$bidd_cnid	=	explode(',',$country_id);
					
			if(is_array($bidd_cnid))
			{ 
				foreach($bidd_cnid as $country_id)
				{				
					$country_details = $this->do_country->delete_countrybidding($country_id,$admarket);
				}
			}
			
			else
			{
				$country_details = $this->do_country->delete_countrybidding($country_id,$admarket);
			}
			/* Activity Log for delete countrybidding - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK,COUNTRY_BIDDING_DEL);
					if($enable=='1')
					{				
						$this->bid_activity_log(COUNTRY_BIDDING,DELETE,$country_id);
					}
					
					$client_id 		=	$this->user_authentication->client_id;

					$account_type	=	$this->user_authentication->account_type;	
					$network_id		=	$this->user_authentication->network_account_id;					
					$agency_id		=	$this->user_authentication->agency_id;
					$result			=	$this->do_networks->agency_owner_details($agency_id);
					$admin_name    	= 	$result['name'];			
					$admin_email	= 	$result['email'];	
					$admin_id   	= 	$result['account_id'];

					if($account_type=='ADVERTISER')
					{
						$message  = $this->default_configurations->get('message_type');
							
						$user = $this->do_message->get_profile($admin_id); 
						
						$acc_type='ADVERTISER';
						
						$type_details		=	array(
													'msg_type'		=> $message,
													'type'			=> "ADMIN_MESSAGE_SETTINGS",
													'string'		=> 'cour_bidd_del',
													'column_name'	=> 'network_settings'
													);
						if($this->user_authentication->account_type=='ADVERTISER')
						{
							$account_id = $this->user_authentication->account_id;
						}
else{
	$account_id='';
}	
						
						
						
						$message_data		=	array(
													'sender_id'		=>	$admin_id,
													'receiver_id'	=>	$account_id,
													'dj_is_admarket'=>	$admarket,
													'subject'		=>	'CountryBidding Deleted',
													'content'		=>	'CountryBidding has been Deleted successfully.',
													'image_name'	=>	NULL,
													'file_name'		=>	NULL,
													'account_type'	=>	$acc_type,
													'status'		=>	'1',
													'network_id'	=>	$network_id,									
													'date'			=>	date('Y-m-d H:i:s'));
													
			$notification_msg = $this->do_message->get_notification_msg('ad_cour_bidd_del'); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
											
			}		
			$adgate_url	=	base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$reciever['name'],$msg_replace);	
			
			$msg_replace = str_replace("{{admin_name}}",$user['first_name'].' '.$user['last_name'],$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$this->config->item('click_directADS').'</a>' ,$msg_replace);	
			
			$dd = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace);															

						//$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details);
						
					}
					
					/* Activity Log for delete countrybidding - End*/
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Country Bidding has been deleted'
							 );
			
			$this->response( $success, 200);
			
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => ' Country Bidding id is not found'
					);
			
			$this->response( $error, 200);
		}
	}
	

	function editcountrylist_get()
	{
		$country_id =clean_data($this->get('id'));
		
		if($country_id)
		{
			$country_details = $this->do_country->fetch_countrywise_bidding($country_id);
			
			$this->response($country_details);
		}
	}
	
	
	/*
	 * 
	 * name: fetch_country_list
	 * @param :
	 * @return : $country_list
	 * 
	 * Lists selected countries of an publisher
	 */
	
	function fetch_country_list_get()
	{		
		$country=$this->do_country->list_country();	
		 
		if($country)
		{
			$this->response($country, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'Country could not be found'),404);
		}		
	}
	
	function filter_country_get()
	{
		
		$campaignid	=	clean_data($this->get('campaignid'));
		$revenueid	=	clean_data($this->get('revenueid'));
		
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		else
		{
			$account_id	=	clean_data($this->get('adv_id'));
		}

		$filter_country=$this->do_country->list_unbind_country($account_id,$campaignid,$revenueid);
		$this->response($filter_country, 200);
	}
	
	function edit_countrywise_bidding_post()
	{
		
		$id=clean_data($this->post('country_id'));
		$campaignid=clean_data($this->post('campaignid'));
			
		$this->form_validation->set_rules('bidding_value', 'Bidding Value', 'required|trim');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' 	=> 	'error',
							'msg' 		=>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{			
			$country_name	= 	$this->post('country_name');
			$bidding_value	=	$this->post('bidding_value');
			
			$bidding_data 	= 	array(
									"bidding_value"	=>	clean_data($bidding_value)
								);
					
			$country_edit	=	$this->do_country->edit_countrybidding($bidding_data,$id);
		
			if($country_edit)
			{
				/* Activity Log for edit countrybidding - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK,COUNTRY_BIDDING_EDIT);
					if($enable=='1')
					{				
						$this->bid_activity_log(COUNTRY_BIDDING,EDIT,$id);
					}
					$client_id 		=	$this->user_authentication->client_id;

					$account_type	=	$this->user_authentication->account_type;	
					$network_id		=	$this->user_authentication->network_account_id;					
					$agency_id		=	$this->user_authentication->agency_id;
					$result			=	$this->do_networks->agency_owner_details($agency_id);
					$admin_name    	= 	$result['name'];			
					$admin_email	= 	$result['email'];	
					$admin_id   	= 	$result['account_id'];

					if($account_type=='ADVERTISER')
					{
						$message  = $this->default_configurations->get('message_type');
							
						$user = $this->do_message->get_profile($admin_id); 
						
						$acc_type='ADVERTISER';
						
						$type_details		=	array(
													'msg_type'		=> $message,
													'type'			=> "ADMIN_MESSAGE_SETTINGS",
													'string'		=> 'cour_bid_edit',
													'column_name'	=> 'network_settings'
													);
							
							$reciever= $this->do_country->fetch_country_reciever($id);
												
						$message_data		=	array(
													'sender_id'		=>	$admin_id,
													'receiver_id'	=>	$reciever['account_id'],
													'dj_is_admarket'=>	$reciever[0]['dj_is_admarket'],
													'subject'		=>	'CountryBidding Editted',
													'content'		=>	'Congrats!CountryBidding  <b>'. $campaign_data['campaignname'].' </b>has been editted successfully.',
													'image_name'	=>	NULL,
													'file_name'		=>	NULL,
													'account_type'	=>	$acc_type,
													'status'		=>	'1',
													'network_id'	=>	$network_id,									
													'date'			=>	date('Y-m-d H:i:s'));
													
										
			$notification_msg = $this->do_message->get_notification_msg('ad_cour_bid_edit'); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
											
			}		
			$adgate_url	=	base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$reciever['name'],$msg_replace);	
			
			$msg_replace = str_replace("{{admin_name}}",$user['first_name'].' '.$user['last_name'],$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$this->config->item('click_directADS').'</a>' ,$msg_replace);	
			
			$dd = $this->notification->notify_mail($message_data,$user,$reciever,$type_details,$mail_content,$msg_replace);		
										
						//$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details);
			
					}
					/* Activity Log for edit countrybidding - End*/
				if($this->user_authentication->account_type=='ADVERTISER')
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Country bidding sucessfully Edited',
									'redirect'	 	=> 	site_url('advertiser/network/edit_countrywise_bidding/'),
									);						
				}
				else
				{
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Country bidding sucessfully Edited',
									'redirect'	 	=> 	site_url('admin/network/edit_countrywise_bidding/'),
									);
				}
				
				$this->response( $success, 200);
				
			}
			
		}
	}
	
	function fetch_languagelist_get()
	{
		 
		$lang=$this->do_country->fetch_language_list();	 
		$this->response($lang,200); 	
		 if($lang)
		 {
			
			 $lang_val=array('response' =>'ok','value'=>$lang);
			 $this->response($lang_val, 200); // 200 being the HTTP response code
		 }
		 else
		 {
			 $this->response(array('error'=>'language could not be found'),404);
		 }
	}
	
	function fetch_country_value_get()
	{	
		 $country_id= $this->get('id');
		 $country=$this->do_country->fetch_country_list($country_id);		
		 if($country)
		 {
			 $country_val=array('response' =>'ok','value'=>$country);
			 $this->response($country_val, 200); // 200 being the HTTP response code
		 }
		 else
		 {
			 $this->response(array('error'=>'Country could not be found'),404);
		 }
		
	}
	function bid_activity_log($module,$process,$bidding_id)
	{
				/* Activity Log for Add/Edit/Delete site - Start	*/			
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");							
				$account_id=$this->user_authentication->account_id;
				$advertiser_id =	$this->user_authentication->client_id;
				//$module=$module;
				//$process=$process;				
				//$campaign_id=$campaign_id;
				
				$activity_log=array(				
								"account_id"=>$account_id,
								"useragent"=>$user_agent,
								"browser"=>$browser,
								"os"=>$os,
								"ip"=>$ip,
								"date"=>$date,
								"module"=>$module,
								"process"=>$process,
								"advertiser_id"=>$advertiser_id,
								"bidding_id"=>$bidding_id,								
								);	
				$this->redis_library->logcount($account_id,$activity_log);  
																									
				//$this->do_app_config->activity_log($account_id,$activity_log);
				/* Activity Log for Add/edit/Delete site - End*/			
		
	}
		function getLatestFile($directoryPath)
	{
		$directoryPath = rtrim($directoryPath, '/');
	
		$max = array('path' => null, 'timestamp' => 0);	
		
		foreach (scandir($directoryPath, SCANDIR_SORT_NONE) as $file)
		{
			$path = $directoryPath . '/' . $file;
			if (!is_file($path)) {	
				continue;
			}
			$timestamp = filemtime($path);		
			if ($timestamp > $max['timestamp']) {
				$max['path'] = $path;
				$max['timestamp'] = $timestamp;
			}
		}	
		
    return $max['path'];
	}
	//added for campaign upload
	public function import_countrywise_biddings_post()
	{	
	
		$file_id=$this->post('upload_name');	 
	
		if($file_id!='')
		{
			$upload_extension = explode(".", $file_id);		
			
			if($upload_extension[1]=='csv' || $upload_extension[1]=='txt' || $upload_extension[1]=='xml')
			{
				
					$csvfilepath 	= $this->config->item('read_csv');	
							
					$file_name		= $this->getLatestFile($csvfilepath);
					if($upload_extension[1]=='xml')
						{
							
							$xml = simplexml_load_file($file_name, 'SimpleXMLElement');	
							$data = json_decode(json_encode((array)$xml), TRUE);
							if(!empty($data['country'][0]))
							{
								 $data=$data['country'];
							}
							else{
							$datum[0]=$data['country'];
							$data=$datum;
							}
						}
						else
						{
							$data= $this->csvreader->parse_file($file_name);
						}
					$counter		= '1';	
					$ext_counter=1;
					$ext_row_counter=1;
					$insert_rec=array();
					$exist_rec=array();
					$exist_row_rec=array();
					$num_rows=count($data);	  
										
						
					if($num_rows>0)
					{
						foreach($data as $row)
						{
							if(!empty($row['account_id'])&&!empty($row['campaignname'])&&!empty($row['revenue_type'])&&!empty($row['country_value']))
							{
								$campaign_id			= trim($row['campaignid']);
								$dj_account_id			= trim($row['account_id']);
								$campaign_name			= trim($row['campaignname']);
								$revenue_type			= trim($row['revenue_type']);
								$country_name			= trim($row['country_value']);
								$bidding_value			= trim($row['bidding_value']);
								$status					= trim($row['status']);
								$admarket 				= trim($row['admarket']);						
							
							
								$import_bidding_data 	= 	array(
									"campaign_id"	=>	clean_data($campaign_id),
									"revenue_type"	=>	clean_data($revenue_type),
									"bidding_value"	=>	clean_data($bidding_value),
									"country_value"	=>	clean_data($country_name),
									"account_id" 	=> 	clean_data($dj_account_id),
									"status" 		=> 	clean_data($status),
									"admarket"		=>  clean_data($admarket)
								);
								
																
								$check_exist = $this->do_country->exists_campaign_check($campaign_id);  
																														
								if(($check_exist!=='NULL') && isset($check_exist))
								{
									$import_bidding_where_data 	= 	array(
									"campaign_id"	=>	clean_data($campaign_id),
									"revenue_type"	=>	clean_data($revenue_type),
									"bidding_value"	=>	clean_data($bidding_value),
									"country_value"	=>	clean_data($country_name),
									"admarket"		=>	clean_data($admarket)
									);									
									$country_add	=	$this->do_country->import_countrybidding($import_bidding_data,$import_bidding_where_data);
																														
											
									if($country_add)
									{
											$insert_rec[] =$counter;
									}
									else
									{
											$exist_row_rec[]=$ext_row_counter;										
									}	
										
										
								}
								else
								{
									
										$exist_rec[]=$ext_counter;
										
								}

						$counter++;	
						$ext_counter++;			
						$ext_row_counter++;					
						}
						else {
							$error = array(
									'response' => 'error',
									//'redirect'=>site_url('advertiser/network/traffic_sources/'),
									'msg'	 => 'The file contains invalid data for this operation..'
									);
				  
							$this->response($error, 200);
						}
					}
					
						if($admarket=='1')
						{
							$url=site_url('advertiser/admarket/countrywise_bidding');
						}
						else
						{
							$url=site_url('advertiser/network/countrywise_bidding');
						}
					
						if(count($insert_rec)>0 && count($exist_rec) >0 && count($exist_row_rec) <=0)
						{
								$ins_count = count($insert_rec);
								$ex_count= count($exist_rec);
								$success = array('response'	=> 'ok_error',
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												 	'redirect'=>site_url('advertiser/network/countrywise_bidding'),
												 'error_msg'=> $ex_count.' Campaign Name Not Found!' 
												 ); 
								$this->response($success,200);
						}
						else if(count($insert_rec)>0 && count($exist_rec)<=0  && count($exist_row_rec) >0)
						{
							
								$ins_count = count($insert_rec);
								$ins_row_count = count($exist_row_rec);
								
								$success = array('response'	=> 'ok_error',
									'redirect'=>site_url('advertiser/network/countrywise_bidding'),
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												  'error_msg'=> $ins_row_count.'Rows,All Fields name are same!' 
												 ); 
								$this->response($success,200);
						}
						else if(count($exist_rec) >0&& count($insert_rec)<=0   && count($exist_row_rec) <=0)
						{
								$ex_count= count($exist_rec);
									$error = array(
										   'response' => 'error',
										   'msg' =>  $ex_count.'Campaign Name Not Found! '
										  );
									$this->response( $error, 200);
						}
						else if(count($exist_row_rec) >0&& count($insert_rec)<=0   && count($exist_rec) <=0)
						{
								$ins_row_count = count($exist_row_rec);
									$error = array(
										   'response' => 'error',
										   'msg' =>  $ins_row_count.'Rows, All Fields name are same! '
										  );
									$this->response( $error, 200);
						}
						else if(count($exist_row_rec) >0&& count($insert_rec)<=0   && count($exist_rec) >0)
						{
								$ins_row_count = count($exist_row_rec);
								$ex_count= count($exist_rec);
									$error = array(
										   'response' => 'error',
										  'msg' => $ex_count.'Campaign Name Not Found!'.','.$ins_row_count.'Rows,All Fields name are same!'
										  
										  );
									$this->response( $error, 200);
						}
						else if(count($insert_rec)>0 && count($exist_rec)>0  && count($exist_row_rec) >0)
						{
							
								$ins_count = count($insert_rec);
								$ins_row_count = count($exist_row_rec);
								$ex_count= count($exist_rec);
								$success = array('response'	=> 'ok_error',
									'redirect'=>site_url('advertiser/network/countrywise_bidding'),
									'msg'		=> $ins_count.' record(s) are inserted successfully',
								'error_msg' => $ex_count.'Campaign Name Not Found!'.','.$ins_row_count.' Rows, All Fields name are same!'
												 ); 
								$this->response($success,200);
						}
						else if(count($insert_rec)>0 && count($exist_rec)<=0  && count($exist_row_rec) <=0)
						{

								$ins_count = count($insert_rec);
								$success = array('response'	=> 'ok',
									'redirect'=>site_url('advertiser/network/countrywise_bidding'),
									'msg'		=> $ins_count.' record(s) are inserted successfully'
								
												 ); 
								$this->response($success,200);
						}
					}
					else
					{
						$error = array(
									'response' => 'error',
									'redirect' => $url ,
									'msg'	   => 'There is no datas in the file!..'
									);
				  
						$this->response($error, 200);	
					}														
			}
			else
			{
				$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV/TXT/XML file to upload!..'
							);
	  
				$this->response($error, 200);	
					
			}		
		}
		else
		{
			$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV/TXT/XML file to upload!..'
						);
	  
			$this->response($error, 200);
		}					
	}		
	
	public function import_zone_biddings_post()
	{				
		$file_id=$this->post('upload_name');	  
					
		if($file_id!='')
		{
			$upload_extension = explode(".", $file_id);		
					
			if($upload_extension[1]=='csv' || $upload_extension[1]=='txt' || $upload_extension[1]=='xml')
			{
				
					$csvfilepath 	= $this->config->item('read_csv');	
							
					$file_name		= $this->getLatestFile($csvfilepath);
					if($upload_extension[1]=='xml')
						{
							
							$xml = simplexml_load_file($file_name, 'SimpleXMLElement');	
							$data = json_decode(json_encode((array)$xml), TRUE);
							if(!empty($data['zonebidding'][0]))
							{
								 $data=$data['zonebidding'];
							}
							else{
							$datum[0]=$data['zonebidding'];
							$data=$datum;
							}
						}
						else
						{
							$data= $this->csvreader->parse_file($file_name);
						}
					$counter		= '1';	
					$ext_counter=1;
					$client_fails=1;
					$insert_rec=array();
					$exist_rec=array();
					$client_fails_cnt=array();
					$num_rows=count($data);	
																				
					if($num_rows>0)
					{					
						foreach($data as $row)
						{		
						
							$admarket=$row['admarket'];
																					
							if($admarket=='1')
							{
								$url=site_url('advertiser/admarket/zone_bidding');
							}
							else
							{
								$url=site_url('advertiser/network/zone_bidding');
							}
																		
						
							if(!empty($row['account_id'])&&!empty($row['zone_id'])&&!empty($row['campaignid'])&&!empty($row['bidding_type'])&&!empty($row['bidrate']))	
							{
								$campaign_id			= trim($row['campaignid']);
								$dj_account_id			= trim($row['account_id']);
								$zoneid					= trim($row['zone_id']);
								$bidding_type			= trim($row['bidding_type']);
								$bidding_value			= trim($row['bidrate']);
								$status					= trim($row['status']);	
								$admarket 				= trim($row['admarket']);						
							
								$import_bidding_data 	= 	array(
									"campaign_id"	=>	clean_data($campaign_id),
									"bidding_type"	=>	clean_data($bidding_type),								
									"bidding_value"	=>	clean_data($bidding_value),
									"zoneid"		=>	clean_data($zoneid),
									"account_id" 	=> 	clean_data($dj_account_id),
									"status" 		=> 	clean_data($status),
									"admarket"		=>  clean_data($admarket)
								);	

								$zone_data_check= array("campaign_id"		=>	trim($row['campaignid']),
														"zone_id" 			=> 	trim($row['zone_id']),
														"admarket"			=>	trim($row['admarket']));				

								// Need to change here
								$client_id_check =	$this->do_campaign->campaign_clientid_check(trim($row['campaignid']));
								
								$zone_check		 =	$this->do_special_bidding->check_zone_bidding_import($zone_data_check);   
								
								if($client_id_check!= TRUE || $client_id_check=='')
								{ 					
									$client_fails_cnt[]=$client_fails;
								}								
										
								if($zone_check==TRUE && $client_id_check== TRUE)
								{							
										$zone_bidding_add	=	$this->do_special_bidding->import_zonebidding($import_bidding_data); 										
										$insert_rec[] =$counter;
								}
								else
								{
										$exist_rec[]=$ext_counter;
								}
								$counter++;	
								$ext_counter++;						
						}
						else
						{
						$error = array(
										   'response' => 'error',
										   'msg' =>  'upload valid file'
										  );
								$this->response( $error, 200);
						}
					}
									
						if(count($insert_rec)>0 && count($exist_rec) >0)
						{
							
								$ins_count = count($insert_rec);
								$ex_count= count($exist_rec);
								$client_mismatch= count($client_fails_cnt);
								$success = array('response'	=> 'ok_error',
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												 'redirect'	=> $url,
												 'error_msg'=> $ex_count.' uploaded file(s) are already Exists !',
												 'clienterror_msg'=> $client_mismatch.' Client id mismatch error!' 
												 ); 
								$this->response($success,200);
						}
						else if(count($insert_rec)>0 && count($exist_rec)<=0)
						{							
								$ins_count = count($insert_rec);
								$success = array('response'	=> 'ok',
												 'redirect' => $url,
												 'msg'		=> $ins_count.' record(s) are inserted successfully'
												 ); 
								$this->response($success,200);
						}
						else if(count($exist_rec) >0&& count($insert_rec)<=0)
						{  
								$ex_count= count($exist_rec);
								$error = array(
										   'response' => 'error',
										   'msg' =>  $ex_count.' uploaded file(s) are already Exists ! '
										  );
								$this->response( $error, 200);
						}
					}
					else
					{
						$error = array(
									'response' => 'error',
									'redirect' => $url,
									'msg'	 => 'There is no datas in the file!..'
									);
				  
						$this->response($error, 200);	
					}														
			}
			else
			{
				$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV/TXT file to upload!..'
							);
	  
				$this->response($error, 200);	
					
			}		
		}
		else
		{
			$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV/TXT file to upload!..'
						);
	  
			$this->response($error, 200);
		}			
						
	}
	
	public function fetch_zonebidding_export_data_get()
	{
		$zone_bid_id=$this->get('zone_bid_id');
		
		$admarket = $this->get('admarket');
		
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		else
		{
			$account_id = '';//$this->user_authentication->default_advertiser_account_id;
		}		
		
		
		
		$export_data = $this->do_special_bidding->fetch_export_zonebidding_data(explode(',',$zone_bid_id),$account_id,$admarket);
 
		
		if(!empty($export_data))
		{
				$this->response( $export_data, 200);
			
		}
		else
		{
			$this->response( 'error', 200);  
		}
	}


	public function fetch_traffic_sources_get()
	{
		$traffic_id=$this->get('traffic_ids');
		
		$admarket = $this->get('admarket');
		
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		else
		{
			$account_id = '';//$this->user_authentication->default_advertiser_account_id;
		}	
		
		$export_data = $this->do_special_bidding->fetch_export_trafficsource_data(explode(',',$traffic_id),$account_id,$admarket);
 
		
		if(!empty($export_data))
		{
				$this->response( $export_data, 200);
			
		}
		else
		{
			$this->response( 'error', 200);  
		}
	}	
	
	
	
}
