<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Campaign 
 * 
 * @package		ADX
 * @subpackage	Campaign API
 * @category	Controller
 * @author		Vigneswaran A
 * @link		http://www.djaxadserver.com
*/

class Campaign extends REST_Controller
{
	function __construct()
	{ 
		parent::__construct();
		$this->load->library('memcached_library');	
		$this->load->library('csvreader');		
		$this->load->library('Default_configurations');
		$this->load->model('do_campaign'); 
		$this->load->model('do_advertiser'); 
		$this->load->model('do_app_config');
		$this->load->library('notification');
		$this->load->model('do_web_creative');
		$this->load->model('do_auto_link');
        $this->load->model('do_linking');
        $this->load->model('do_targeting');
        $this->load->model('do_networks');
        $this->load->model('do_message');
        $this->load->model('do_publisher'); 
        $this->load->library('user_authentication');
        $this->load->library('notification');
		$this->load->model('do_payments');
	    $key=$this->input->get_post('api_key'); 
	    //$this->response($key,200);
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}
	
	
	
	function fetch_publisher_by_conversion_post()
	 {
		$search=''; 
		$page 			= $this->post('page');
		$display 		= $this->post('display_type');
		$campaign_id	= $this->post('camp_id');
		$admarket= clean_data($this->get('admarket'));
		$account_type   = $this->user_authentication->account_type;
		$rep_config = $this->config->item('report_config');
		if($campaign_id=='Campaign')
		{
		$search['camp_id'] ='';
		}
		else
		{
		$search['camp_id'] =$camp_id;
		}
		if(isset($rep_config[strtoupper($account_type)][strtoupper($page)]))
		{
			$settings = $rep_config[strtoupper($account_type)][strtoupper($page)][strtoupper($display)];
		}
	
		if($this->post('date_from') !='')
		{
			$search['date_from'] = $this->post('date_from');
			$search['date_to']	 = $this->post('date_to');
		}
		else
		{
			if($settings['DEFAULT_INTERVAL'] != '')
			{
					$date = get_search_date($settings['DEFAULT_INTERVAL']);
					$search['date_from'] = $date['from_date'].' 00:00:00';
					$search['date_to'] = $date['to_date'].' 23:00:00';
					
			}	
		}
		
		
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		
		if($account_id)
		{
		$pub_conv = $this->do_campaign->publisher_by_conversion($admarket,$account_id,$search);
		foreach($pub_conv as $pub)
		{
			
			$result[] = array('name'=>$pub['site_url'],'y'=>floatval($pub['count(zones.zone_id)']));
			
		}
		}
		if($result)
		{
			
		$this->response($result, 200);
		}
		
	 }
	
	 /*
	 * 
	 * name: fetch
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists all the campaign of an advertiser
	 */
	 	 	 
	function fetch_get()
	{  
		
		$filter	=	clean_data($this->get('filter'));
		$type		=	$this->get('type');
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		elseif($type=='housead')
		{
			
			$type		=	'housead';
			$account_id = 	($type=='housead')?$this->user_authentication->default_advertiser_account_id:'';			
		}		
		else
		{
		$account_id = 'ALL';
		}				
		if($account_id)
		{
			$creative_list = $this->do_campaign->fetch($account_id,$group,$status,$revenue_type,false,false,false,false,$filter); 
			//$creative_list = $this->do_campaign->fetch($account_id,false,false,false,false,false,false,false,$filter);
			//$creative_list = $this->do_campaign->fetch($account_id,$group,$status,$revenue_type);
		}
		else
		{
			$creative_list = $this->do_campaign->fetch();
		}
		
		if($creative_list)
		{
			$this->response($creative_list, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No creatives'),404);
		}
	}
	
	
	function global_tracker_get()
	{
		$campaign_id=$this->get('campaign_id');
		if($account_id)
		{
			$creative_list = $this->do_campaign->fetch_tracker($campaign_id);
			
		}
		if($creative_list)
		{
			$this->response($creative_list, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No tracker'),404);
		}
	}
	
	function fetch_domain_get()
	{
		
			$domain_list = $this->do_campaign->fetch_domain();
			
		
		if($domain_list)
		{
			$this->response($domain_list, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No tracker'),404);
		}
	}
	function preview_campaign_get()
	{  
		$campaign_id=$this->get('campaign_id');
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		else
		{
			$type		=	$this->get('type');
			$account_id = 	($type=='housead')?$this->user_authentication->default_advertiser_account_id:'';			
		}		
						
		if($account_id)
		{
			$creative_list = $this->do_campaign->fetch_preview_campaign($campaign_id);
			
		}
		else
		{
			$creative_list = $this->do_campaign->fetch_preview_campaign($campaign_id);
		}
		
		if($creative_list)
		{
			$this->response($creative_list, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No creatives'),404);
		}
	}
	
	
	
	function fetch_filter_get()
	{  		
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}		
		
		$group=$this->get('group');  
		$status=$this->get('status');
		$revenue_type=$this->get('revenue_type');	
		$group_by=$this->get('group_by');
		
		//~ $startdate=$this->get('startdate');
		//~ $enddate=$this->get('enddate');
		$groupby_date=$this->get('groupby_date');
		
		//~ $startdate= date("Y-m-d", strtotime($startdate));
	    //~ $enddate= date("Y-m-d", strtotime($enddate));	  
		$startdate=$this->get('date_from');
		$enddate=$this->get('date_to');
			
		$startdate= date("Y-m-d", strtotime($startdate));
	    $enddate= date("Y-m-d", strtotime($enddate));	
				
		if($account_id)
		{
			//$creative_list = $this->do_campaign->fetch($account_id,$group,$status,$revenue_type);
			$creative_list = $this->do_campaign->fetch($account_id,$group,$status,$revenue_type,$group_by,$groupby_date,$startdate,$enddate);
		}
		else if($group!='null' || $status!='null' || $revenue_type!='null')
		{
			$creative_list = $this->do_campaign->fetch('',$group,$status,$revenue_type);
		}
		else
		{
			$creative_list = $this->do_campaign->fetch();
		}  
						
		if($creative_list)
		{
			$this->response($creative_list, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No creatives'),404);
		}
	}
		
	function fetch_filter_status_get()
	{
		$campaigns_state=$this->get('campaign_state');
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}	
		$creative_list = $this->do_campaign->fetch($account_id,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,$campaigns_state);
		if($creative_list)
		{
			$this->response($creative_list, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No Campaign'),404);
		}
	}
	 /*
	 * 
	 * name: fetch_campaign_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists a particular campaign of an advertiser
	 */
	
	function fetch_campaign_get()
	{		
		$campaign_id = $this->get('campaign_id');
		
		if($campaign_id)
		{
			
			$campaign_data = $this->do_campaign->fetch_campaign($campaign_id);
			
			if($campaign_data)
			{
				$this->response($campaign_data, 200); // 200 being the HTTP response code
			}
			else
			{
				$this->response(array('error'=>'No details'),200);
			}
		}
	}
	
	
	/*
	 * 
	 * name: fetch_campaign_list
	 * @param : $country,$category,$adsizes
	 * @return : list_data
	 * 
	 * Converts the data into display format
	 */
	
	function fetch_campaign_list_get()
	{
		$country=$this->get('country');
		$category=$this->get('category');
		$creative_size = $this->get('creatives_size'); 		
	
			$campaign_data = $this->do_campaign->fetch_campaign_list($country,$category,$creative_size);
			//$this->response($this->db->last_query(),200); exit;
			
			if($campaign_data)
			{
			  $this->response($campaign_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		
	}
	
	
	function move_to_group_get()
	{
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		
		$group_name=$this->get('group_name');
		
		$campaign_data = $this->do_campaign->fetch_move_to_group_list($group_name,$account_id);
					
		if($campaign_data)
		{
			 $this->response($campaign_data, 200); // 200 being the HTTP response code
		}
		else
		{
		  $this->response(array('error'=>'No details'),404);  
		}
		
	}

	

	
	/*
	 * 
	 * name: fetch_campaign_list
	 * @param : $country,$category,$adsizes
	 * @return : list_data
	 * 
	 * Converts the data into display format
	 */
	
	function fetch_selected_campaign_list_get()
	{
		$campaignid=$this->get('campaignid');
		
		$campaign_data = $this->do_campaign->fetch_selected_campaign_list($campaignid);
					
			if($campaign_data)
			{
			  $this->response($campaign_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		
	}
	
	/*
	 * 
	 * name: fetch_campaign_list
	 * @param : $country,$category,$adsizes
	 * @return : list_data
	 * 
	 * Converts the data into display format
	 */
	public function add_budget_post()
	{		
		$campaign_id	=	clean_data($this->post('campaign_id'));
		$camp_budget	=	clean_data($this->post('camp_budget'));
		$campaign_name	=	clean_data($this->post('campaign_name'));
		$campaign_budget=	clean_data($this->post('campaign_budget'));
	
		$payment_mode = clean_data($this->post('payment_mode'));
		
		if($payment_mode!='')
		{
			$amount = clean_data($this->post('campaign_budget'));
							
			if($payment_mode=="2")
			{
				$site_url = site_url('site/paypal/add_payment/'.$campaign_id.'/'.$amount.'/'.$campaign_name.'/edit');
			}
			else if($payment_mode=="5")
			{
				$site_url = site_url('site/authorize/add_payment/'.$campaign_id.'/'.$amount.'/'.$campaign_name.'/'.urlencode(clean_data($this->post('email'))).'/edit');
			}
			else if($payment_mode=="4")
			{
				$site_url = site_url('site/bitpay/add_payment/'.$campaign_id.'/'.$amount.'/'.$campaign_name.'/'.urlencode(clean_data($this->post('email'))).'/edit');
			}
			
			$success = array(
						'response' 	=> 	'ok',
						'redirect'	=>	$site_url,
						'msg'	 	=> 	'Payment Process',
					);
			$this->response($success, 200);
		}
		else
		{
			$success = array(
							'response' 	=> 	'ok',
							'msg'	 	=> 	'Updated!',
							'redirect'	=> 	site_url('site/campaigns'),
							);	
			$this->response( $success, 200);
		}			
	}
	
	 /*
	 * 
	 * name: fetch_houseads_campaign_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists a particular campaign of an admin
	 */
	
	function fetch_houseads_campaign_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$campaign_data = $this->do_campaign->fetch_houseads_campaign($campaign_id);
			
			if($campaign_data)
			{
			  $this->response($campaign_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	
	 /*
	 * 
	 * name: fetch_browser_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists browser targeting details
	 */
	
	function fetch_browser_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'deliveryLimitations:Client:Browser');
			$campaign_browser_data = $this->do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_browser_data)
			{
			  $this->response($campaign_browser_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}

	function fetch_brow_vers_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'deliveryLimitations:Client:BrowserVersion');
			$campaign_browser_data = $this->do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_browser_data)
			{
			  $this->response($campaign_browser_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	function fetch_os_version_data_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'deliveryLimitations:Client:OsVersion');
			$campaign_browser_data = $this->do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_browser_data)
			{
			  $this->response($campaign_browser_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}		 
	/*
	 * 
	 * name: fetch_os_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists browser targeting details
	 */
	
	function fetch_os_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'deliveryLimitations:Client:Os');
			$campaign_os_data = $this->do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_os_data)
			{
			  $this->response($campaign_os_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	
	 /*
     * 
     * name: fetch_profile_targeting_keyword_get
     * @param :
     * @return : $campaign_profile_keyword_data
     * 
     * Lists a particular campaign of a keyword targeting details
     */
     
    
    function fetch_profile_targeting_keyword_get()
    {
        $campaign_id = $this->get('campaign_id');
        if ($campaign_id)
        {
            $where                         = array(
                'campaignid' => $campaign_id,
                'type' => 'profile:keyword'
            );
            $campaign_profile_keyword_data = $this->do_campaign->fetch_camapign_targeting($where);
            
            if ($campaign_profile_keyword_data)
            {
                $this->response($campaign_profile_keyword_data, 200); // 200 being the HTTP response code
            }
            else
            {
                $this->response(array(
                    'error' => $this->lang->line('no_details')
                ), 404);
            }
        }
    }
    
    /*available + blocked keyword fetch function*/
    function fetch_avail_keyword_get()
    {
        $campaign_id = $this->get('campaign_id');
        if ($campaign_id)
        {
            $where                         = array(
                'campaignid' => $campaign_id,
                'type' => 'profile:avail_keyword'
            );
            $campaign_profile_keyword_data = $this->do_campaign->fetch_camapign_targeting($where);
            
            if ($campaign_profile_keyword_data)
            {
                $this->response($campaign_profile_keyword_data, 200); // 200 being the HTTP response code
            }
            else
            {
                $this->response(array(
                    'error' => $this->lang->line('no_details')
                ), 404);
            }
        }
    }
    
    function fetch_blocked_keyword_get()
    {
        $campaign_id = $this->get('campaign_id');
        if ($campaign_id)
        {
            $where                         = array(
                'campaignid' => $campaign_id,
                'type' => 'profile:blocked_keyword'
            );
            $campaign_profile_keyword_data = $this->do_campaign->fetch_camapign_targeting($where);
            
            if ($campaign_profile_keyword_data)
            {
                $this->response($campaign_profile_keyword_data, 200); // 200 being the HTTP response code
            }
            else
            {
                $this->response(array(
                    'error' => $this->lang->line('no_details')
                ), 404);
            }
        }
    }
	/*
	 * 
	 * name: fetch_time_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists  time targeting details
	 */
	
	function fetch_time_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'deliveryLimitations:Time:Hour');
			$campaign_time_data = $this->do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_time_data)
			{
			  $this->response($campaign_time_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_geo_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists a particular campaign of a time targeting details
	 */
	
	function fetch_geo_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'deliveryLimitations:Geo:Country');
			$campaign_geo_data = $this->do_campaign->fetch_camapign_targeting($where);

			if($campaign_geo_data)
			{
			  $this->response($campaign_geo_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_profile_targeting_age_get
	 * @param :
	 * @return : $campaign_profile_age_data
	 * 
	 * Lists a particular campaign of a age targeting details
	 */
	
	function fetch_profile_targeting_age_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'profile:age');
			$campaign_profile_age_data = $this->do_campaign->fetch_camapign_targeting($where);

			if($campaign_profile_age_data)
			{
			  $this->response($campaign_profile_age_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_profile_targeting_gender_get
	 * @param :
	 * @return : $campaign_profile_gender_data
	 * 
	 * Lists a particular campaign of a gender targeting details
	 */
	
	function fetch_profile_targeting_gender_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'profile:gender');
			$campaign_profile_gender_data = $this->do_campaign->fetch_camapign_targeting($where);

			if($campaign_profile_gender_data)
			{
			  $this->response($campaign_profile_gender_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_profile_targeting_color_get
	 * @param :
	 * @return : $campaign_profile_gender_data
	 * 
	 * Lists a particular campaign of a color targeting details
	 */
	
	function fetch_profile_targeting_color_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'profile:color');
			$campaign_profile_color_data = $this->do_campaign->fetch_camapign_targeting($where);

			if($campaign_profile_color_data)
			{
			  $this->response($campaign_profile_color_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_profile_targeting_height_get
	 * @param :
	 * @return : $campaign_profile_gender_data
	 * 
	 * Lists a particular campaign of a height targeting details
	 */
	
	function fetch_profile_targeting_height_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'profile:height');
			$campaign_profile_height_data = $this->do_campaign->fetch_camapign_targeting($where);

			if($campaign_profile_height_data)
			{
			  $this->response($campaign_profile_height_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_profile_targeting_weight_get
	 * @param :
	 * @return : $campaign_profile_gender_data
	 * 
	 * Lists a particular campaign of a weight targeting details
	 */
	
	function fetch_profile_targeting_weight_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'profile:weight');
			$campaign_profile_weight_data = $this->do_campaign->fetch_camapign_targeting($where);

			if($campaign_profile_weight_data)
			{
			  $this->response($campaign_profile_weight_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_mobile_os_targeting_height_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists a mobile tagetting targeting details
	 */
	
	function fetch_mobile_os_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'os');
			$campaign_mob_os_data = $this->do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_mob_os_data)
			{
			  $this->response($campaign_mob_os_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_mobile_manu_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists manufacturer targeting details
	 */
	
	function fetch_mobile_manu_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'handset');
			$campaign_manu_data = $this->do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_manu_data)
			{
			  $this->response($campaign_manu_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_mobile_capa_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists mobile capability targeting details
	 */
	
	function fetch_mobile_capa_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'capability');
			$campaign_capability_data = $this->do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_capability_data)
			{
			  $this->response($campaign_capability_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_mobile_telecom_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists service providers targeting details
	 */
	
	function fetch_mobile_telecom_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'teleco');
			$campaign_telecom_data = $this->do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_telecom_data)
			{
			  $this->response($campaign_telecom_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_mobile_geo_targeting_get
	 * @param :
	 * @return : $campaign_browser_data
	 * 
	 * Lists geo targeting details of a camapign
	 */
	
	function fetch_mobile_geo_targeting_get()
	{
		$campaign_id = $this->get('campaign_id');
		if($campaign_id)
		{
			$where=array('campaignid'=>$campaign_id,'type'=>'country');
			$campaign_geo_data = $this->do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_geo_data)
			{
			  $this->response($campaign_geo_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	
	
	/*
	 * name: add_campaign_post
	 * @param
	 * @return:response array
	 * 
	 * In this method will create a campain
	 * 
	 */
	public function add_campaign_post()
	{	
		//$this->response($this->post(),200);					
		$prod_name = $this->config->item('prod_name'); 
		
	
		if($this->input->post('is_smart_cpa')=='1')
		{
		$this->form_validation->set_rules('test_budget','Test budget', 'required|trim');
		$test_budget	=	clean_data($this->input->post('test_budget'));
		$smart_conversion	=	clean_data($this->input->post('s_conv_count'));
		$smart_cpa			=	$this->input->post('is_smart_cpa');
		}	
		if($this->input->post('slice_desktop')=='1')
		{
			$smart_desktop_imp	=	clean_data($this->input->post('s_desktop_limit'));
		}	
		else
		{
			$smart_desktop_imp=50;
		}
		
		if($this->input->post('slice_mobile')=='1')
		{
			$smart_mobile_imp	=	clean_data($this->input->post('s_mobile_limit'));
		}	
		else
		{
			$smart_mobile_imp=50;
		}
		$prod_name = $this->config->item('prod_name'); 		
		$this->form_validation->set_rules('campaign_name','Campaign name', 'required|trim');
		$this->form_validation->set_rules('campaign_type', 'Campaign type', 'required|trim');
		//$this->form_validation->set_rules('retarget', 'Campaign type', 'required|trim');
		$this->form_validation->set_rules('campaign_schedule', 'Campaign schedule', 'required|trim');
		$campaign_schedule=clean_data($this->input->post('campaign_schedule'));
		
		$retarget= clean_data($this->input->post('retarget'));
		$retargetting_max_time=clean_data($this->input->post('retargetting_max_time'));
		if($retarget=="1")
		{
			if($this->input->post('cookie_expire')!='yes')
			{
			$this->form_validation->set_rules('retargetting_max_time', 'No of retargetting', 'required|trim');
			$retargetting_max_time	=	clean_data($this->input->post('retargetting_max_time'));
		    }
		    else
		    {
				$this->form_validation->set_rules('cookie_expire', 'cookie expire time', 'required|trim');
				$retargetting_max_time	=	clean_data($this->input->post('cookie_expire'));
		    }	
			$this->form_validation->set_rules('behavior', 'behavior', 'required|trim');
		}		
								
		if($campaign_schedule=="specific")
		{
			$this->form_validation->set_rules('start_end_range', 'Campaign schedule', 'required|trim');
		}
	    
		$this->form_validation->set_rules('campaign_targeting_type', 'Targeting type', 'required|trim');
		
		$campaign_from=trim($this->post('campaign_from'));
		
		$rtb_type      	= 	(clean_data($this->post('is_rtb')) == 'on') ? '1' : '0';
		$ssp_category	=	0;
		
		if ($rtb_type == "1")
        {
            $this->form_validation->set_rules('campaign_name', 'lang:campaign_name', 'required|trim');
            $this->form_validation->set_rules('campaign_type', 'lang:campaign_type', 'required|trim');
            $this->form_validation->set_rules('campaign_schedule', 'lang:campaign_schedule', 'required|trim');
            $this->form_validation->set_rules('campaign_category', 'lang:campaign_category', 'required|trim');
            if (clean_data($this->input->post('is_proposal')) == '0')
            {
                $this->form_validation->set_rules('retarget', 'Campaign type', 'required|trim');
                $this->form_validation->set_rules('campaign_daily_budget', 'lang:daily_budget', 'required|trim');
                $this->form_validation->set_rules('campaign_budget', 'lang:campaign_budget', 'required|trim');
            }
            
            $ssp_category	=	clean_data($this->input->post('ssp_category'));
        }
        
		if($campaign_from!=='HOUSE_ADS_CAMPAIGN' && $rtb_type != "1")
		{
			if($this->user_authentication->account_type!='ADVERTISER')
			{				
				$this->form_validation->set_rules('adv_id', 'Advertiser', 'required|trim');
			}
			$this->form_validation->set_rules('campaign_category', 'Campaign category', 'trim');
			
			if($this->input->post('daily_budget_unlimited')!='1')
			{
			$this->form_validation->set_rules('campaign_daily_budget', 'Daily budget', 'required|trim');
			}
			$this->form_validation->set_rules('campaign_budget', 'Campaign budget', 'required|trim');
			$this->form_validation->set_rules('campaign_weight', 'Weight', 'required|trim'); 
		}
		
		if(clean_data($this->input->post('campaign_type'))==3)
			{
				$this->form_validation->set_rules('cpa_goal', 'CPA Goal', 'required|trim');
				$camp_bid_rate	=	clean_data($this->input->post('cpa_goal'));
			}
			else
			{
				$this->form_validation->set_rules('campaign_bid_rate', 'Bid rate', 'required|trim');
				$camp_bid_rate	=	clean_data($this->input->post('campaign_bid_rate'));
			}
			
		if(!empty($this->post('targ_city')[0]))
		{
		$this->form_validation->set_rules('targ_city', 'Targeting City', 'trim|callback_valid_city_check');
		}
		if($this->form_validation->run() === FALSE)
		{			
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{	
			
			$is_direct		=	0;
			
			$account_id=$this->user_authentication->account_id;
			$trusted_status = $this->do_campaign->adv_trusted_status($account_id);  
		
			//print_r($trusted_status); die();			
			
			if($this->user_authentication->account_type=='ADVERTISER')
			{	
				$client_id 	= 	$this->user_authentication->client_id;
				$account_id	=	$this->user_authentication->account_id;
				$is_approved =	($trusted_status=='1')?'0':'1';
				
				if($this->user_authentication->is_default==2)
				{
					$is_direct	=	1;
					if(isset($_COOKIE[$prod_name.'_campaign_user_data']) && $this->post('_target_camp_id')=='') 
					{	
						$camp_id=	$_COOKIE[$prod_name.'_campaign_user_data'];
						// Delete previously created direct campaign without checkout
						$qry	=	$this->do_campaign->remove_direct_uncheckout($camp_id);
					}			
				}	
				else
				{
					if(isset($_COOKIE[$prod_name.'_adv_campaign_user_data']) && $this->post('_target_camp_id')=='') 
					{
						if(clean_data($this->input->post('_campaign_complete')==1))
						{	
							$expire	=	time();
							
							//$this->input->set_cookie($campaign_data);
							setcookie($prod_name.'_adv_campaign_user_data',$campaign_id,$expire,'/');
						}
					}
				}			
			}
			else
			{				
				$adv		=	explode('_',clean_data($this->post('adv_id')));
				$account_id	=	$adv[1];
				$client_id 	= 	($campaign_from=='HOUSE_ADS_CAMPAIGN')?$this->user_authentication->default_advertiser_client_id:$adv[0];
				if($campaign_from=='HOUSE_ADS_CAMPAIGN')
				{
					$is_approved	=	0;
				}
				else
				{
					$is_approved =	($trusted_status=='1')?'0':'1';
				}
			}
			
			$daily_budget_limited=$this->input->post('daily_budget_unlimited');  	
			$camp_end_date=$this->input->post('camp_end_date'); 			
			$camp_impressions=$this->input->post('camp_impressions');
									
			$global	= 	clean_data($this->post('global_tracker'));
			if($global=='on')
			{					 
				$global_tracker=1;
			}	  
			else
			{
				$global_tracker=0;
			} 
			$reset	= 	clean_data($this->post('reset_tracker'));
			if($reset=='on')
			{					 
				$reset_tracker=1;
			}	  
			else
			{
				$reset_tracker=0;
			} 
			$admarket	= 	clean_data($this->post('admarket_campaign'));
			if($admarket=='on')
			{					 
				$admarket_camp=1;
			}	  
			else
			{
				$admarket_camp=0;
			} 
			
			if($campaign_schedule=="specific")
			{
				$start_end_range		=	clean_data($this->input->post('start_end_range'));
				$activate_expire_time	=	explode('-',$start_end_range);
				$activate_time			=	date('Y-m-d H:i:s',strtotime($activate_expire_time[0]));
				$expire_time			=	date('Y-m-d H:i:s',strtotime($activate_expire_time[1]));
			}
			else
			{
				$activate_time	=	date('Y-m-d H:i:s');
				$expire_time	=	NULL;
			}

			$campaign_budget	=	clean_data($this->input->post('campaign_budget'));
			if ($rtb_type != "1")
            {
				if($trusted_status=='1')
				{
					$status=0;
				}
				else
				{
					$status	=	$this->validate_campaign_status($client_id,$activate_time,$expire_time,$campaign_budget,'add');
				}
			}
            else
            {
                $status = 0; // Modified for RTB Campaign
            }
			
			if($status >= 0)//if($status == 1 || $status == 2 || $status == 0)
			{
				//CALCULATE ECPM
				$prod_name = $this->config->item('prod_name');
				switch (clean_data($this->input->post('campaign_type')))
				{
					case 1:
						$ecpm=clean_data($this->input->post('campaign_bid_rate'));
					break;

					case 2:
						$default_click_ratio=$this->default_configurations->get('default_click_ratio');
						$ecpm=$default_click_ratio*clean_data($this->input->post('campaign_bid_rate'))*1000;
					break;

					case 3:
						$default_conversion_ratio=$this->default_configurations->get('default_conversion_ratio');
						$ecpm=$default_conversion_ratio*clean_data($this->input->post('campaign_bid_rate'))*1000;
					break;
					case 4:
                        $ecpm = 'DSP';
                        break;
				}

				//FETCH MINIMUM IMPRESSION FOR ECPM CALCULATION
				$min_impressions=$this->default_configurations->get('min_impressions_day_banner');
				$retarget_flag=clean_data($this->input->post('retargetting_max_time'));
				if(isset($retarget_flag) AND !empty($retarget_flag) )
					$retargetting_max_time=clean_data($this->input->post('retargetting_max_time'));
				else
					$retargetting_max_time=clean_data($this->input->post('cookie_expire'));
				
				//Frequency capping
				if($this->post('frequency_capping')!='yes')
				{
					//$nocapping			=	1;
					$nocapping			=	0;
					$block				=	0;
					$session_capping	=	0;
				}
				else
				{
					$nocapping			=	1;
					$block				=	(clean_data($this->post('targ_hour')))?clean_data($this->post('targ_hour'))*3600:0;
					$session_capping	=	(clean_data($this->post('frequency_capping_imp')))?clean_data($this->post('frequency_capping_imp')):0;
				}
				$evenly_distribute=$this->post('evenly_distribute');				
								
				$campaign_data	=	array(
											 'campaignname'			=>	clean_data($this->input->post('campaign_name')),
											 'clientid'				=>	clean_data($client_id),
											 'revenue_type'			=>	clean_data($this->input->post('campaign_type')),
											 'cpv_percentage'       =>  clean_data($this->input->post('cpv_view')),  
											 'activate_time'		=>  clean_data($activate_time),
											 'expire_time'			=>  $expire_time,
											 'dj_targetting_type'	=>  clean_data($this->input->post('campaign_targeting_type')),
											 'dj_targetting_type_excl'	=>  clean_data($this->input->post('campaign_target_type1')),
											 'priority'				=>  clean_data('-2'),
											 'revenue'				=>	clean_data($camp_bid_rate),
											 'hourly_bid_rate'		=>	clean_data($this->input->post('hourly_bid_rate')),
											 'hourly_bid_timing'	=>	clean_data($this->input->post('hourly_bid_timing')),
											 'dj_campaign_budget'	=>	clean_data($this->input->post('campaign_budget')),
											 'dj_daily_budget'		=>	clean_data($this->input->post('campaign_daily_budget')),
											 'dj_category_id'		=>	clean_data($this->input->post('campaign_category')),
											 'dj_sub_category'		=>	clean_data($this->input->post('campaign_sub_category')),
											 'weight'				=>	clean_data($this->input->post('campaign_weight')),
											 'viewwindow'			=>	clean_data('8388607'),
											 'clickwindow'			=>	clean_data('8388607'),
											 'ecpm'					=>	clean_data($ecpm),
											 'status'				=>	clean_data($status),
											 'min_impressions'		=>	clean_data($min_impressions),
											 'dj_is_retargeted'		=>	clean_data($this->input->post('retarget')),
											 'dj_max_retargetting'	=>	clean_data($retargetting_max_time),
											 'behavior'		        =>	clean_data($this->input->post('behavior')),											 										 
											 'dj_added_date'  		=> 	date('Y-m-d H:i:s'),
											 'dj_is_rtb_campaign' 	=> 	clean_data($rtb_type),
											 'dj_rtb_buyer_id' 		=> 	clean_data($ssp_category),
											 'dj_is_admarket'		=>	clean_data($admarket_camp),
											 'dj_is_direct'			=>	clean_data($is_direct),
											 'dj_is_approved'		=>	clean_data($is_approved),
											 'block'				=> 	$block,
											 'capping'				=>	$nocapping,
											 'session_capping'		=> 	$session_capping,
											 'an_status'			=> 	clean_data($this->input->post('campaign_status')),
											 'evenly_distribution'  =>  $evenly_distribute,
											 'daily_budget_unlimit' =>  $daily_budget_limited,
											 'even_distribute_end_date'=>$camp_end_date,
											 'even_distribute_impressions'=>$camp_impressions,
											'reset_pixel'         =>  $reset_tracker,
											 'url'                  => clean_data($this->input->post('pixel_url')),
											'test_budget'  			=>	($test_budget)?$test_budget:'0',
											'smart_desktop_imp'		=>	$smart_desktop_imp,
											'smart_mobile_imp'		=>	$smart_mobile_imp,
											'smart_conversion'		=>	($smart_conversion)?$smart_conversion:'0',
											'smart_cpa'				=>	($smart_cpa)?$smart_cpa:0
										);
				//	$this->response($campaign_data,200);
				if(clean_data($this->post('_campaign_id'))=='')
				{
					if($is_direct==1)
					{
						if(isset($_COOKIE[$prod_name.'_campaign_user_data'])=='') 
						{						
							$campaign_id= $this->do_campaign->add_new_campaign($campaign_data,$client_id,$global_tracker);
							$expire	=	time()+60*60*24;
							
							if($this->post('_target_camp_id')=='')
							{
								//$this->input->set_cookie($campaign_data);
								setcookie($prod_name.'_campaign_user_data',$campaign_id,$expire,'/');
							}
						}
						else
						{
							if(($this->post('_target_camp_id'))!='')
							{								
								$campaign_id= $this->do_campaign->add_new_campaign($campaign_data,$client_id,$global_tracker);
							}
							else
							{
								$campaign_id	=	$_COOKIE[$prod_name.'_campaign_user_data'];
								$campaign_edit	= 	$this->do_campaign->edit_campaign($campaign_data,$client_id,$campaign_id,$global_tracker);
							}
						}
					}
					else
					{
						if($this->user_authentication->account_type=='ADVERTISER')
						{							
							if(isset($_COOKIE[$prod_name.'_adv_campaign_user_data'])=='') 
							{						
								$campaign_id= 	$this->do_campaign->add_new_campaign($campaign_data,$client_id,$global_tracker);
								if(clean_data($this->input->post('_campaign_complete'))!=='1')
								{
									$expire		=	time()+60*60*2;
								
									//$this->input->set_cookie($campaign_data);
									setcookie($prod_name.'_adv_campaign_user_data',$campaign_id,$expire,'/');
								}								
							}
							else
							{
								$campaign_id	=	$_COOKIE[$prod_name.'_adv_campaign_user_data'];
								$campaign_edit	= 	$this->do_campaign->edit_campaign($campaign_data,$client_id,$campaign_id,$global_tracker);
							}
						}
						else
						{
							$campaign_id	= 	$this->do_campaign->add_new_campaign($campaign_data,$client_id,$global_tracker);
						}
					}
					if($campaign_id!='')
					{	$account_id=$this->user_authentication->account_id;
						$wallet_balance = $this->do_payments->get_wallet_bal($account_id);
						$campaign_amt	=	clean_data($this->input->post('campaign_budget'));
						$deduction_balance=$wallet_balance -$campaign_amt;
						$wallet_result=$this->do_campaign->deduct_wallet($account_id,$deduction_balance);
						
				    }	
					
					
					/* Start - Evenly distribution */
					if($evenly_distribute=='1')
					{	
						if(clean_data($this->post('weekly_distribute'))!='custom')
						{ 
							$current_date = date("Y-m-d");  
							$current_time = 24-date("H"); 
							if($daily_budget_limited!='1')
							{  
								$estimated_imp=$this->input->post('campaign_daily_budget')/$camp_bid_rate;
								$final_imp_per_hour=$estimated_imp/$current_time;
							}
							else if($camp_impressions!='0')
							{													
								$final_imp_per_hour=$camp_impressions/$current_time;
							}
							else if($camp_impressions=='' && $camp_end_date!='0000-00-00' || $expire_time!=NULL )
							{						
								$estimated_imp=$this->input->post('campaign_budget')/$camp_bid_rate; 
								$datetime1 = date_create($current_date);
								if($camp_end_date!='0000-00-00')
								{
								  $datetime2 = date_create($camp_end_date);
								}
								else
								{
								  $datetime2 = date_create($expire_time);
								}
								$interval = date_diff($datetime1, $datetime2);
								$diff=($interval->format('%R%a'))*24;  
								$difference=$diff+$current_time;
								$final_imp_per_hour=$estimated_imp/$difference;							
							}				
							
							$evenly_id = $this->do_campaign->add_evenly_distribution($campaign_id,$final_imp_per_hour,$current_date);						
						}
						else
						{
							if(clean_data($this->post('targ_time')))
							{						
								$hour = 	implode(',',clean_data($this->post('targ_time')));  
								if($hour)
								{
									$even_hour_data['data']	=	$hour;									
								}
								else
								{
									$even_hour_data['data']='';
								}
							}
							if(clean_data($this->post('targ_daypart')))
							{						
								$daypart = 	implode(',',clean_data($this->post('targ_daypart')));
								if($daypart!='')
								{
									$even_daypart_data['data']	=	$daypart;								
								}
								else
								{
									$even_daypart_data['data']='';
								}
							}
							
							$current_date = date("Y-m-d"); 
							if($even_hour_data!='')
							{
								$hour_data=explode(",",$even_hour_data['data']);
								$current_time=count($hour_data);
							}
							else
							{
								$current_time = 24-date("H"); 
							}							
							if($daily_budget_limited!='1')
							{  
								$estimated_imp=$this->input->post('campaign_daily_budget')/$camp_bid_rate;
								$final_imp_per_hour=$estimated_imp/$current_time;
							}
							else if($camp_impressions!='0')
							{													
								$final_imp_per_hour=$camp_impressions/$current_time;
							}
							else if($camp_impressions=='' && $camp_end_date!='0000-00-00' || $expire_time!=NULL )
							{						
								$estimated_imp=$this->input->post('campaign_budget')/$camp_bid_rate; 
								$datetime1 = date_create($current_date);
								if($camp_end_date!='0000-00-00')
								{
								  $datetime2 = date_create($camp_end_date);
								}
								else
								{
								  $datetime2 = date_create($expire_time);
								}
								$interval = date_diff($datetime1, $datetime2);
								$difference=($interval->format('%R%a'))*$current_time;  
								$final_imp_per_hour=$estimated_imp/$difference;							
							}	   			
							
							
							$this->do_campaign->add_day_evenly_distribution($campaign_id,$final_imp_per_hour,$current_date,$even_hour_data,$even_daypart_data);
											
							
						}
					
					}
					
					/* End of evenly distribution */
				
					
					
					
						
										
									
					if ($rtb_type == '1')
                    {
                        $campaign_name = clean_data($this->input->post('campaign_name'));
                        $dj_account_id = $this->user_authentication->account_id;
                        if (clean_data($this->input->post('campaign_targeting_type')) == "WEB")
                        {
                            $bannertype      = WEB_CREATIVE_HTML;
                            $text_bannertype = WEB_CREATIVE_TEXT;
                        }
                        else if (clean_data($this->input->post('campaign_targeting_type')) == "MOBILE")
                        {
                            $bannertype      = MOBILE_HTML_CREATIVE;
                            $text_bannertype = MOBILE_TEXT_CREATIVE;
                        }
                        else if (clean_data($this->input->post('campaign_targeting_type')) == "ALL")
                        {
							$bannertype      = WEB_CREATIVE_HTML;
                            $text_bannertype = WEB_CREATIVE_TEXT;
                            
                            $bannertype1      = MOBILE_HTML_CREATIVE;
                            $text_bannertype1 = MOBILE_TEXT_CREATIVE;
                        }
                        else
                        {
                            $bannertype      = WEB_CREATIVE_HTML;
                            $text_bannertype = WEB_CREATIVE_TEXT;
                        }
                        
                        $html_template = html_anchor_tag_replacer("Html Creatives");
                        $agency_id     = $this->user_authentication->agency_id;
                        $blob_data     = FALSE;
                        $creative_data = array(
                            "contenttype" => "html",
                            "campaignid" => $campaign_id,
                            "storagetype" => "html",
                            "description" => $campaign_name . "- RTB Buyer ads served to opted campaign",
                            "width" => "-1",
                            "height" => "-1",
                            "ext_bannertype" => "bannerTypeHtml:oxHtml:genericHtml",
                            "dj_admin_approve" => 1,
                            "dj_approved_date" => clean_data(date('Y:m:d :H:i:s')),
                            "dj_banner_type" => clean_data($bannertype),
                            "dj_added_date" => clean_data(date('Y:m:d :H:i:s')),
                            "dj_account_id" => clean_data($dj_account_id)
                        );
                        $rtb_camp      = 1;
                        $this->do_web_creative->add($creative_data, $blob_data, $agency_id, $rtb_camp);
                        $text_creative = array(
                            "contenttype" => "txt",
                            "campaignid" => $campaign_id,
                            "storagetype" => "txt",
                            "description" => $campaign_name . " - RTB Buyer ads served to opted campaign",
                            "ext_bannertype" => "bannerTypeText:oxText:genericText",
                            "dj_admin_approve" => 1,
                            "dj_approved_date" => clean_data(date('Y:m:d :H:i:s')),
                            "dj_banner_type" => clean_data($text_bannertype),
                            "dj_added_date" => clean_data(date('Y:m:d :H:i:s')),
                            "dj_account_id" => clean_data($dj_account_id)
                        );
                        $this->do_web_creative->add($text_creative, $blob_data, $agency_id, $rtb_camp);
                        
                        if(clean_data($this->input->post('campaign_targeting_type')) == "ALL")
                        {
							$html_template = html_anchor_tag_replacer("Html Creatives");
							$agency_id     = $this->user_authentication->agency_id;
							$blob_data     = FALSE;
							$creative_data = array(
								"contenttype" => "html",
								"campaignid" => $campaign_id,
								"storagetype" => "html",
								"description" => $campaign_name . "- RTB Buyer ads served to opted campaign",
								"width" => "-1",
								"height" => "-1",
								"ext_bannertype" => "bannerTypeHtml:oxHtml:genericHtml",
								"dj_admin_approve" => 1,
								"dj_approved_date" => clean_data(date('Y:m:d :H:i:s')),
								"dj_banner_type" => clean_data($bannertype1),
								"dj_added_date" => clean_data(date('Y:m:d :H:i:s')),
								"dj_account_id" => clean_data($dj_account_id)
							);
							$rtb_camp      = 1;
							$this->do_web_creative->add($creative_data, $blob_data, $agency_id, $rtb_camp);
							$text_creative = array(
								"contenttype" => "txt",
								"campaignid" => $campaign_id,
								"storagetype" => "txt",
								"description" => $campaign_name . " - RTB Buyer ads served to opted campaign",
								"ext_bannertype" => "bannerTypeText:oxText:genericText",
								"dj_admin_approve" => 1,
								"dj_approved_date" => clean_data(date('Y:m:d :H:i:s')),
								"dj_banner_type" => clean_data($text_bannertype1),
								"dj_added_date" => clean_data(date('Y:m:d :H:i:s')),
								"dj_account_id" => clean_data($dj_account_id)
							);
							$this->do_web_creative->add($text_creative, $blob_data, $agency_id, $rtb_camp);
							
						}
                    }
				}
				else
				{
					$campaign_id	=	clean_data($this->post('_campaign_id'));
					$campaign_edit	= 	$this->do_campaign->edit_campaign($campaign_data,$client_id,$campaign_id,$global_tracker);
				}
				
								
				//traffic source 
				if($this->post('traffic_source'))
				{
					$sources	=	$this->post('traffic_source');
					$this->do_campaign->campaign_traffic_source_assoc($campaign_id,$sources,$account_id);
				}
				else
				{
					$this->do_campaign->delete_camp_assoc($campaign_id,'traffic_source');
				}
				
				//Zone bidding 
				if($this->post('zone_bidding'))
				{
					$zones	=	$this->post('zone_bidding');
					$this->do_campaign->campaign_zone_bidding_assoc($campaign_id,$zones,$account_id);
				}
				else
				{
					$this->do_campaign->delete_camp_assoc($campaign_id,'zone_bidding');
				}
							
				//Country Bidding
				if($this->post('country_bidding'))
				{
					$country_bidding	=	$this->post('country_bidding');
					$this->do_campaign->campaign_country_bidding_assoc($campaign_id,clean_data($this->post('_account_id')),$country_bidding);
				}
				else
				{
					$this->do_campaign->delete_camp_assoc($campaign_id,'country_bidding');
				}
				
				// group options
				if($this->post('group'))
				{
					$group	=	clean_data($this->post('group'));
					$this->do_campaign->campaign_group_assoc($campaign_id,$group);
				}
				else
				{
					$this->do_campaign->delete_camp_assoc($campaign_id,'group');
				}
				
				//Pixel Tracker
				if($this->post('tracker'))
				{
					$tracker_data	=	array(
												'tracker_id'	=>	clean_data($this->post('tracker')),
												'campaign_id'	=>	$campaign_id,
												'global_tracker'=>	$global_tracker
											);
					$this->do_campaign->campaign_tracker_assoc($tracker_data);
				}
				else
				{
					$this->do_campaign->delete_camp_assoc($campaign_id,'tracker');
				}
					
				$campaign_name	=	clean_data($this->input->post('campaign_name'));	
				if($campaign_id)
				{					
					//Targeting
					
					//Browser Targeting
					
					$brow_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:Browser",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	0,
										);						
						
					if($this->post('targ_browser'))
					{
						$brow = 	implode(',',clean_data($this->post('targ_browser')));
						
						if($brow)
						{
							$brow_data['data']	=	$brow;
							
							$this->do_targeting->add($brow_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($brow_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($brow_data,$campaign_id);
					}

					//Browser Exclude Targeting
					
					$browEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:Browser",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	0,
										);					
						
					if($this->post('targ_browser_excl'))
					{
						$browEx = 	implode(',',clean_data($this->post('targ_browser_excl')));
						
						if($browEx)
						{
							$browEx_data['data']			=	$browEx;
							//$browEx_data['comparison']	=	"!=";							
							$this->do_targeting->add($browEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($browEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($browEx_data,$campaign_id);
					}
					
											
					//Browser Language Targeting
					$lang_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:Language",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	1,
										);
						
					if($this->post('targ_browser_lang'))
					{						
						$lang = 	implode(',',clean_data($this->post('targ_browser_lang')));						
						
						if($lang)
						{
							$lang_data['data']	=	$lang;
							
							$this->do_targeting->add($lang_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($lang_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($lang_data,$campaign_id);
					}


					
					
					//Browser Exclude Language Targeting
					$langEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:Language",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	1,
										);
						
					if($this->post('targ_browser_lang_excl'))
					{						
						$langEx = 	implode(',',clean_data($this->post('targ_browser_lang_excl')));					
						if($langEx)
						{
							$langEx_data['data']	=	$langEx;
							
							$this->do_targeting->add($langEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($langEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($langEx_data,$campaign_id);
					}
										
					//Browser Version Targeting
					$brow_ver_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:BrowserVersion",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	1,
										);
						
					if($this->post('targ_browser_vers'))
					{						
						$brow = 	implode(',',clean_data($this->post('targ_browser_vers')));						
						
						if($brow)
						{
							$brow_ver_data['data']	=	$brow;
							//$this->response($brow_ver_data,200);
							$this->do_targeting->add($brow_ver_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($brow_ver_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($brow_ver_data,$campaign_id);
					}
					

					//Browser Version Exclude Targeting
					$browEx_ver_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:BrowserVersion",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	1,
										);
						
					if($this->post('targ_browser_vers_excl'))
					{						
						$browEx = 	implode(',',clean_data($this->post('targ_browser_vers_excl')));
						if($browEx)
						{
							$browEx_ver_data['data']	=	$browEx;
							
							$this->do_targeting->add($browEx_ver_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($browEx_ver_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($browEx_ver_data,$campaign_id);
					}
															
					//OS Targeting
					$os_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:Os",
											"comparison"	=> 	"==",
											"data"			=> 	$os,
											"executionorder"=> 	2,
										);
						
					if($this->post('targ_os'))
					{						
						$os = 	implode(',',clean_data($this->post('targ_os')));
						
						if($os)
						{
							$os_data['data']	=	$os;
							
							$this->do_targeting->add($os_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($os_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($os_data,$campaign_id);
					}

					//OS Exclude Targeting
					$osEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:Os",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	2,
										);
						
					if($this->post('targ_os_excl'))
					{						
						$osEx = 	implode(',',clean_data($this->post('targ_os_excl')));
						
						if($osEx)
						{
							$osEx_data['data']	=	$osEx;
							
							$this->do_targeting->add($osEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($osEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($osEx_data,$campaign_id);
					}
					

					//OS version Targeting
					$osvers_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:OsVersion",
											"comparison"	=> 	"==",
											"data"			=> 	$os,
											"executionorder"=> 	2,
										);
						
					if($this->post('targ_os_version'))
					{						
						$os = 	implode(',',clean_data($this->post('targ_os_version')));
						
						if($os)
						{
							$osvers_data['data']	=	$os;
							
							$this->do_targeting->add($osvers_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($osvers_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($osvers_data,$campaign_id);
					}

					//OS version Targeting Exclude
					$osversEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:OsVersion",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	2,
										);
						
					if($this->post('targ_os_version_excl'))
					{						
						$osversEx = 	implode(',',clean_data($this->post('targ_os_version_excl')));
						
						if($osversEx)
						{
							$osversEx_data['data']	=	$osversEx;
							
							$this->do_targeting->add($osversEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($osversEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($osversEx_data,$campaign_id);
					}
										
					
					//Device Targeting
					
					$device_idata	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"device:".strtolower($this->input->post('campaign_targeting_type')),
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	3,
											);
					$device_edata	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"device:".strtolower($this->input->post('campaign_target_type1')),
												"comparison"	=> 	"!=",
												"data"			=> 	FALSE,
												"executionorder"=> 	3,
											);
											
					$devtype	=	array('all','web','mobile','tablet');


					if($this->post('targ_include_device'))
					{						
						$device = 	implode(',',clean_data($this->post('targ_include_device')));
						
						if($device)
						{
							$device_idata['data']	=	$device;
							//$device_idata['type']	=	"device:".strtolower($this->input->post('campaign_targeting_type'));
							
							$this->do_targeting->add($device_idata,$campaign_id);
						}
						else
						{										
							$this->do_targeting->delete($device_idata,$campaign_id);
						}
					}
					else
					{							
						foreach($devtype as $de)
						{							
							$this->do_targeting->delete($device_idata,$campaign_id);
						}						
					}
					
					if($this->post('targ_exclude_device'))
					{						
						$device = 	implode(',',clean_data($this->post('targ_exclude_device')));
						
						if($device)
						{
							$device_edata['data']	=	$device;
							//$device_edata['type']	=	"device:".strtolower($this->input->post('campaign_target_type1'));
							$this->do_targeting->add($device_edata,$campaign_id);
						}
						else
						{		
							$this->do_targeting->delete($device_edata,$campaign_id);							
						}
					}
					else
					{	
						foreach($devtype as $de)
						{								
							$this->do_targeting->delete($device_edata,$campaign_id);
						}					
					}









/*

if(clean_data($this->post('device_type')) == 'include')
{
					$this->do_targeting->delete1($device_idata,$campaign_id);
					$this->do_targeting->delete1($device_edata,$campaign_id);
					if($this->post('targ_include_device'))
					{						
						$device = 	implode(',',clean_data($this->post('targ_include_device')));
						
						if($device)
						{
							$device_idata['data']	=	$device;
							$device_idata['type']	=	"device:".strtolower($this->input->post('campaign_targeting_type'));
							
							$this->do_targeting->add($device_idata,$campaign_id);
						}
						else
						{	
							foreach($devtype as $de)
							{
									
								$this->do_targeting->delete1($device_idata,$campaign_id);
							}
						}
					}
					else
					{	
						foreach($devtype as $de)
						{
							
							$this->do_targeting->delete1($device_idata,$campaign_id);
						}
					}

	
}
else if(clean_data($this->post('device_type')) == 'exclude')
{
					$this->do_targeting->delete1($device_idata,$campaign_id);
					$this->do_targeting->delete1($device_edata,$campaign_id);
					if($this->post('targ_exclude_device'))
					{						
						$device = 	implode(',',clean_data($this->post('targ_exclude_device')));
						
						if($device)
						{
							$device_edata['data']	=	$device;
							$device_edata['type']	=	"device:".strtolower($this->input->post('campaign_target_type1'));
							$this->do_targeting->add($device_edata,$campaign_id);
						}
						else
						{	
							foreach($devtype as $de)
							{
									
								$this->do_targeting->delete1($device_edata,$campaign_id);
							}
						}
					}
					else
					{	
						foreach($devtype as $de)
						{
							
							$this->do_targeting->delete1($device_edata,$campaign_id);
						}
					}

	
}	*/				
					
					//Country Include Targeting
					$country_idata	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"Include_country",
											"comparison"	=> 	"=~",
											"data"			=> 	FALSE,
											"executionorder"=> 	4,
										);
					//Country Exclude Targeting
					$country_edata	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"Exclude_country",
												"comparison"	=> 	"=~",
												"data"			=> 	FALSE,
												"executionorder"=> 	4,
											);
						
					//if(clean_data($this->post('country_type'))=='include')
					//{	
						$this->do_targeting->delete($country_idata,$campaign_id);
																
						if(clean_data($this->post('targ_geo_include')))
						{						
							$country_include = 	implode(',',clean_data($this->post('targ_geo_include')));
							
							if($country_include)
							{
								$country_idata['data']	=	$country_include;
								
								$this->do_targeting->add($country_idata,$campaign_id);
							}
							else
							{
								$this->do_targeting->delete($country_idata,$campaign_id);
							}
						}
						else
						{
							$this->do_targeting->delete($country_idata,$campaign_id);
						}
					
					/*}
					else if(clean_data($this->post('country_type'))=='exclude')
					{*/	
						$this->do_targeting->delete($country_edata,$campaign_id);
																
						if(clean_data($this->post('targ_geo_exclude')))
						{						
							$country_exclude = 	implode(',',clean_data($this->post('targ_geo_exclude')));
							
							if($country_exclude)
							{
								$country_edata['data']	=	$country_exclude;
								
								$this->do_targeting->add($country_edata,$campaign_id);
							}
							else
							{
								$this->do_targeting->delete($country_edata,$campaign_id);
							}
						}
						else
						{
							$this->do_targeting->delete($country_edata,$campaign_id);
						}
					//}						
					
					//City Targeting
					$city_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Geo:City",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	5,
										);
						
					if(clean_data($this->post('targ_city')))
					{		
						$city = 	implode(',',clean_data($this->post('targ_city')));
						
						if($city)
						{
							
							$city_data['data']	=	$city;
							
							$this->do_targeting->add($city_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($city_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($city_data,$campaign_id);
					}


					//City EXCLUDE Targeting
					$cityEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Geo:City",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	5,
										);
						
					if(clean_data($this->post('targ_city_exclude')))
					{		
						$cityEx = 	implode(',',clean_data($this->post('targ_city_exclude')));
						
						if($cityEx)
						{							
							$cityEx_data['data']	=	$cityEx;
							
							$this->do_targeting->add($cityEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($cityEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($cityEx_data,$campaign_id);
					}
					
										
					//Zip Targeting
					$zip_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Geo:Zip",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	6,
										);
						
					if(clean_data($this->post('targ_zip')))
					{						
						$zip = 	clean_data($this->post('targ_zip'));
						
						if($zip)
						{
							$zip_data['data']	=	$zip;
							
							$this->do_targeting->add($zip_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($zip_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($zip_data,$campaign_id);
					}																			
					//ZipExclude Targeting
					$zipEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Geo:Zip",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	6,
										);
						
					if(clean_data($this->post('targ_zip_exclude')))
					{						
						$zipEx = 	clean_data($this->post('targ_zip_exclude'));
						
						if($zipEx)
						{
							$zipEx_data['data']	=	$zipEx;
							
							$this->do_targeting->add($zipEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($zipEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($zipEx_data,$campaign_id);
					}
					//Manufacturer targeting
					
					$manu_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"handset",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	7,
										);
						
					if(clean_data($this->post('targ_mob_manu')))
					{						
						$manu = 	implode(',',clean_data($this->post('targ_mob_manu')));
						
						if($manu)
						{
							$manu_data['data']	=	$manu;
							
							$this->do_targeting->add($manu_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($manu_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($manu_data,$campaign_id);
					}

		//Manufacturer Exclude targeting
					
					$manuEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"handset",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	7,
										);
						
					if(clean_data($this->post('targ_mob_manu_excl')))
					{						
						$manuEx = 	implode(',',clean_data($this->post('targ_mob_manu_excl')));
						
						if($manuEx)
						{
							$manuEx_data['data']	=	$manuEx;
							
							$this->do_targeting->add($manuEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($manuEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($manuEx_data,$campaign_id);
					}
					
					//Capability targeting
					$capab_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"capability",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	8,
										);
						
					if(clean_data($this->post('targ_mob_capability')))
					{						
						$capab = 	implode(',',clean_data($this->post('targ_mob_capability')));
						
						if($capab)
						{
							$capab_data['data']	=	$capab;
							
							$this->do_targeting->add($capab_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($capab_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($capab_data,$campaign_id);
					}

					//Capability targeting
					$capabEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"capability",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	8,
										);
						
					if(clean_data($this->post('targ_mob_capability_excl')))
					{						
						$capabEx = 	implode(',',clean_data($this->post('targ_mob_capability_excl')));
						
						if($capabEx)
						{
							$capabEx_data['data']	=	$capabEx;
							
							$this->do_targeting->add($capabEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($capabEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($capabEx_data,$campaign_id);
					}

					
					//Connection targeting
					$connect_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"connection",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	9,
										);
						
					if(clean_data($this->post('targ_mob_connection')))
					{						
						$connection = 	implode(',',clean_data($this->post('targ_mob_connection')));
						
						if($connection)
						{
							$connect_data['data']	=	$connection;
							
							$this->do_targeting->add($connect_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($connect_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($connect_data,$campaign_id);
					}

					//Connection targeting
					$connectEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"connection",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	9,
										);
						
					if(clean_data($this->post('targ_mob_connection_excl')))
					{						
						$connectionEx = 	implode(',',clean_data($this->post('targ_mob_connection_excl')));
						
						if($connectionEx)
						{
							$connectEx_data['data']	=	$connectionEx;
							
							$this->do_targeting->add($connectEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($connectEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($connectEx_data,$campaign_id);
					}
					
					//Carrier targeting
					$carrier_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"carrier",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	10,
										);
						
					if(clean_data($this->post('targ_mob_carrier')))
					{						
						$carrier = 	implode(',',clean_data($this->post('targ_mob_carrier')));
						
						if($carrier)
						{
							$carrier_data['data']	=	$carrier;
							
							$this->do_targeting->add($carrier_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($carrier_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($carrier_data,$campaign_id);
					}

					//Carrier targeting
					$carrierEX_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"carrier",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	10,
										);						
					if(clean_data($this->post('targ_mob_carrier_excl')))
					{						
						$carrierEx = 	implode(',',clean_data($this->post('targ_mob_carrier_excl')));				
						if($carrierEx)
						{
							$carrierEX_data['data']	=	$carrierEx;							
							$this->do_targeting->add($carrierEX_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($carrierEX_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($carrierEX_data,$campaign_id);
					}	
										
					//Blacklist targeting
					$pblack_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"profile:preset_blacklist",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	11,
										);
															
					//Blacklist targeting
					$black_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"profile:blacklist",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	11,
										);
					
					//Whitelist targeting
					$white_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"profile:whitelist",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	11,
										);
						
					//Whitelist targeting
					$pwhite_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"profile:preset_whitelist",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	11,
										);	
										
					if(clean_data($this->post('targ_list'))=='black')
					{	
						$this->do_targeting->delete($pwhite_data,$campaign_id);
						
						if(clean_data($this->post('preset_black')))
						{						
							$pblack = 	implode(',',clean_data($this->post('preset_black')));
							if($pblack)
							{
								$pblack_data['data']	=	$pblack;
								
								$this->do_targeting->add($pblack_data,$campaign_id);
							}
							else
							{
								$this->do_targeting->delete($pblack_data,$campaign_id);
							}
						}
						else
						{
							$this->do_targeting->delete($pblack_data,$campaign_id);
						}
						
						$this->do_targeting->delete($white_data,$campaign_id);
											
						if(clean_data($this->post('targ_blacklist')))
						{						
							$black = 	clean_data($this->post('targ_blacklist'));//implode(',',$this->post('targ_blacklist'));
							if($black)
							{
								$black_data['data']	=	$black;
								
								$this->do_targeting->add($black_data,$campaign_id);
							}
							else
							{
								$this->do_targeting->delete($black_data,$campaign_id);
							}
						}
						else
						{
							$this->do_targeting->delete($black_data,$campaign_id);
						}
					}
					
					if(clean_data($this->post('targ_list'))=='white')
					{
						$this->do_targeting->delete($pblack_data,$campaign_id);
												
						if(clean_data($this->post('preset_white')))
						{						
							$pwhite = 	implode(',',clean_data($this->post('preset_white')));
							if($pwhite)
							{
								$pwhite_data['data']	=	$pwhite;
								
								$this->do_targeting->add($pwhite_data,$campaign_id);
							}
							else
							{
								$this->do_targeting->delete($pwhite_data,$campaign_id);
							}
						}
						else
						{
							$this->do_targeting->delete($pwhite_data,$campaign_id);
						}
						
						$this->do_targeting->delete($black_data,$campaign_id);
												
						if(clean_data($this->post('targ_whitelist')))
						{						
							$white = 	clean_data($this->post('targ_whitelist'));//implode(',',$this->post('targ_whitelist'));
							if($white)
							{
								$white_data['data']	=	$white;
								
								$this->do_targeting->add($white_data,$campaign_id);
							}
							else
							{
								$this->do_targeting->delete($white_data,$campaign_id);
							}
						}
						else
						{
							$this->do_targeting->delete($white_data,$campaign_id);
						}
					}
					
					//Hour targeting
					$hour_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Time:Hour",
											"comparison"	=> 	"=~",
											"data"			=> 	FALSE,
											"executionorder"=> 	11,
										);
					
					//Daypart Targeting
					$daypart_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"deliveryLimitations:Time:Day",
												"comparison"	=> 	"=~",
												"data"			=> 	FALSE,
												"executionorder"=> 	11,
											);
					
														
					if(clean_data($this->post('weekly_distribute'))=='custom')
					{							
						if(clean_data($this->post('targ_time')))
						{						
							$hour = 	implode(',',clean_data($this->post('targ_time')));
							if($hour)
							{
								$hour_data['data']	=	$hour;
								
								$this->do_targeting->add($hour_data,$campaign_id);
							}
							else
							{
								$this->do_targeting->delete($hour_data,$campaign_id);
							}
						}
						else
						{
							$this->do_targeting->delete($hour_data,$campaign_id);
						}						
						
						if(clean_data($this->post('targ_daypart')))
						{						
							$daypart = 	implode(',',clean_data($this->post('targ_daypart')));
							if($daypart!='')
							{
								$daypart_data['data']	=	$daypart;
								
								$this->do_targeting->add($daypart_data,$campaign_id);
							}
							else
							{
								$this->do_targeting->delete($daypart_data,$campaign_id);
							}
						}
						else
						{
							$this->do_targeting->delete($daypart_data,$campaign_id);
						}
							
						if(clean_data($this->post('daypart_time')))
						{						
							$daypart_time = 	implode(',',clean_data($this->post('daypart_time')));
							
							if($daypart_time)
							{
								$daypart_time_data	=	array('dj_weekly_distribute'=>$daypart_time);
								
								$this->do_campaign->add_campaign_favourite($campaign_id,$daypart_time_data);
							}
							else
							{
								$daypart_time_data	=	array('dj_weekly_distribute'=>'');
								
								$this->do_campaign->add_campaign_favourite($campaign_id,$daypart_time_data);
							}
						}
						else
						{
							$daypart_time_data	=	array('dj_weekly_distribute'=>'');
							
							$this->do_campaign->add_campaign_favourite($campaign_id,$daypart_time_data);
						}
					}	
					else
					{
						$this->do_targeting->delete($hour_data,$campaign_id);
						$this->do_targeting->delete($daypart_data,$campaign_id);
						$daypart_time_data	=	array('dj_weekly_distribute'=>'');
							
						$this->do_campaign->add_campaign_favourite($campaign_id,$daypart_time_data);
					}									
					
					//Url Keyword Targeting
					$urlkey_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:url",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	0,
											);
						
					if(clean_data($this->post('targ_url_keyword')))
					{						
						$urlkey = 	clean_data($this->post('targ_url_keyword'));
						
						if($urlkey)
						{
							$urlkey_data['data']	=	$urlkey;
							
							$this->do_targeting->add($urlkey_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($urlkey_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($urlkey_data,$campaign_id);
					}
					
					//Keyword Targeting
					
					$keyword_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:keyword",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	1,
											);

					if(clean_data($this->post('targ_profile_keyword')))
					{						
						$keyword = 	clean_data($this->post('targ_profile_keyword'));
						
						if($keyword)
						{
							$keyword_data['data']	=	$keyword;
													
							$this->do_targeting->add($keyword_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($keyword_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($keyword_data,$campaign_id);
					}
					//Keyword new Targeting
					
					$new_keyword_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:avail_keyword",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	1,
											);

					if(clean_data($this->post('avail_keys')))
					{						
						//$avail_keyword = 	clean_data($this->post('avail_keys'));
						$avail_keyword = 	implode(',',clean_data($this->post('avail_keys')));
						if($avail_keyword)
						{
							$new_keyword_data['data']	=	$avail_keyword;
													
							$this->do_targeting->add($new_keyword_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($new_keyword_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($new_keyword_data,$campaign_id);
					}
					
					//blocked Keyword Targeting
					
					$blocked_keyword_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:blocked_keyword",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	1,
											);

					if(clean_data($this->post('blocked_key_name')))
					{												
						$blocks_keyword = 	clean_data($this->post('blocked_key_name'));
						$block_keyword  =	str_replace( array('\r\n','\n\r','\n','\r'), ',' , $blocks_keyword );
						
						if($block_keyword)
						{
							$blocked_keyword_data['data']	=	$block_keyword;
													
							$this->do_targeting->add($blocked_keyword_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($blocked_keyword_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($blocked_keyword_data,$campaign_id);
					}
					
					//Age Targeting
					
					$age_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:age",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	2,
											);

					if(clean_data($this->post('targ_profile_age')))
					{						
						$age = 	implode(',',clean_data($this->post('targ_profile_age')));
						
						if($age)
						{
							$age_data['data']	=	$age;
													
							$this->do_targeting->add($age_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($age_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($age_data,$campaign_id);
					}
					
					//Gender Targeting
					$gender_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:gender",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	3,
											);

					if(clean_data($this->post('targ_profile_gender')))
					{						
						$gender = 	implode(',',clean_data($this->post('targ_profile_gender')));
						
						if($gender)
						{
							$gender_data['data']	=	$gender;
													
							$this->do_targeting->add($gender_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($gender_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($gender_data,$campaign_id);
					}
					
					//Color Targeting
					$color_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:color",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	4,
											);

					if(clean_data($this->post('targ_profile_color')))
					{						
						$color = 	implode(',',clean_data($this->post('targ_profile_color')));
						
						if($color)
						{
							$color_data['data']	=	$color;
													
							$this->do_targeting->add($color_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($color_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($color_data,$campaign_id);
					}
					
					//Height Targeting
					$height_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:height",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	5,
											);


					if($this->post('targ_profile_height'))
					{						
						$height = 	implode(',',clean_data($this->post('targ_profile_height')));
						
						if($height)
						{
							$height_data['data']	=	$height;
													
							$this->do_targeting->add($height_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($height_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($height_data,$campaign_id);
					}
					
					//Height Targeting
					$weight_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:weight",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	6,
											);

					if($this->post('targ_profile_weight'))
					{						
						$weight = 	implode(',',clean_data($this->post('targ_profile_weight')));
						
						if($weight)
						{
							$weight_data['data']	=	$weight;
													
							$this->do_targeting->add($weight_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($weight_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($weight_data,$campaign_id);
					}
					/* Activity Log for Add campaign - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(CAMPAIGNS,CAMP_ADD);
					if($enable=='1')
					{				
						$this->cam_activity_log(CAMPAIGN,ADD,$campaign_id);
					}
					/* Activity Log for Add campaign - End*/
					//Targeting
					
					/*********Message Requirements**************/
		
					$client_id 		=	$this->user_authentication->client_id;

					$account_type	=	$this->user_authentication->account_type;	
					$network_id	=	$this->user_authentication->network_account_id;					
					$agency_id	=	$this->user_authentication->agency_id;
					$result		=	$this->do_networks->agency_owner_details($agency_id);
					$admin_name    	= 	$result['name'];			
					$admin_email	= 	$result['email'];	
					$admin_id   	= 	$result['account_id'];

					if($account_type=='ADVERTISER')
					{
						$message  = $this->default_configurations->get('message_type');
							
						$user = $this->do_message->get_profile($admin_id); 
						
						$acc_type='ADVERTISER';
						
						$type_details		=	array(
													'msg_type'		=> $message,
													'type'			=> "ADMIN_MESSAGE_SETTINGS",
													'string'		=> 'camp_add',
													'column_name'	=> 'campaigns'
													);
							
						$reciever= $this->do_campaign->fetch_reciever($campaign_id);
						
						$message_data		=	array(
													'sender_id'		=>	$admin_id,
													'receiver_id'	=>	$reciever['account_id'],
													'subject'		=>	'Campaign Created',
													'content'		=>	'Congrats! A  New campaign  <b>'. $campaign_data['campaignname'].' </b>has been created successfully.',
													'image_name'	=>	NULL,
													'file_name'		=>	NULL,
													'account_type'	=>	$acc_type,
													'status'		=>	'1',
													'network_id'	=>	$network_id,									
													'date'			=>	date('Y-m-d H:i:s'));
													
														

						$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details);
					}
					/*********Message Requirements**************/
					$link_name=strtolower($this->user_authentication->account_type);
					if($link_name=="advertiser")
					{
						$link="advertiser";
					}
					else
					{
						$link=$link_name;
					}
					
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Campaign sucessfully edited',
									'redirect'	 	=> 	site_url($link.'/campaigns'),
									'campaign_id'	=> 	$campaign_id,
									'campaign_name'	=> 	$campaign_name,
									'account_id'	=> 	$account_id,
									'status'		=>	$status."---".$is_approved
									);
					$this->response( $success, 200);
				}
				else
				{
					$link_name=strtolower($this->user_authentication->account_type);
					if($link_name=="advertiser")
					{
						$link="advertiser";
					}
					else
					{
						$link=$link_name;
					}
					$error = array(
									'response' => 'error',
									'msg'	 => 'Error. Please try again',
									'redirect'	 => site_url($link.'/campaigns'),
									);	
					$this->response( $error, 200);
				}
			}
			else
			{
				$error = array(
								'response' 	=> 	'error',
								'msg'	 	=> 	array('start_end_range'=>'Campaign start & end date should not be same'),
								//'redirect'	 => site_url('advertiser/campaigns'),
								);	
				$this->response( $error, 200);
			}
		}
		
	}

	/*
	 * name: edit_campaign_post
	 * @param
	 * @return:response array
	 * 
	 * In this method will edit a campain
	 * 
	 */
	public function edit_campaign_post()
	{
		//smart cpa test
		if($this->input->post('is_smart_cpa')=='1')
		{
		$this->form_validation->set_rules('test_budget','Test budget', 'required|trim');
		$test_budget	=	clean_data($this->input->post('test_budget'));
		$smart_conversion	=	clean_data($this->input->post('s_conv_count'));
		$smart_cpa			=	$this->input->post('is_smart_cpa');
		}	
		if($this->input->post('slice_desktop')=='1')
		{
			$smart_desktop_imp	=	clean_data($this->input->post('s_desktop_limit'));
		}	
		else
		{
			$smart_desktop_imp=500;
		}
		
		if($this->input->post('slice_mobile')=='1')
		{
			$smart_mobile_imp	=	clean_data($this->input->post('s_mobile_limit'));
		}	
		else
		{
			$smart_mobile_imp=500;
		}
		//$this->response($this->post(),200);
		$this->form_validation->set_rules('campaign_name','Campaign name', 'required|trim');
		$this->form_validation->set_rules('campaign_type', 'Campaign type', 'required|trim');
		$this->form_validation->set_rules('campaign_schedule', 'Campaign schedule', 'required|trim');
		
		$campaign_schedule=clean_data($this->input->post('campaign_schedule'));
		
		$retarget	= 	clean_data($this->input->post('retarget'));
		$retargetting_max_time	=	clean_data($this->input->post('retargetting_max_time'));
		if($retarget=="1")
		{
			if($this->input->post('cookie_expire')!='yes')
			{
			$this->form_validation->set_rules('retargetting_max_time', 'No of retargetting', 'required|trim');
			$retargetting_max_time	=	clean_data($this->input->post('retargetting_max_time'));
		    }
		    else
		    {
				$this->form_validation->set_rules('cookie_expire', 'cookie expire time', 'required|trim');
				$retargetting_max_time	=	clean_data($this->input->post('cookie_expire'));
		    }	
			$this->form_validation->set_rules('behavior', 'behavior', 'required|trim');
		}		
								
		if($campaign_schedule=="specific")
		{
			$this->form_validation->set_rules('start_end_range', 'Campaign schedule', 'required|trim');
		}
		if($this->post('frequency_capping')=='yes')
		{			
			$this->form_validation->set_rules('frequency_capping_imp', 'Impression', 'required|trim');
			$this->form_validation->set_rules('targ_hour', 'Hour', 'required|trim');
		}	    
		//$this->form_validation->set_rules('campaign_targeting_type', 'Targeting type', 'required|trim');
		
		$campaign_from	=	trim($this->post('campaign_from'));
		
		$rtb_type      	= 	(clean_data($this->post('is_rtb')) == 'on') ? '1' : '0';
		$ssp_category	=	0;
		
		if ($rtb_type == "1")
        {
            $this->form_validation->set_rules('campaign_name', 'lang:campaign_name', 'required|trim');
            $this->form_validation->set_rules('campaign_type', 'lang:campaign_type', 'required|trim');
            $this->form_validation->set_rules('campaign_schedule', 'lang:campaign_schedule', 'required|trim');
            $this->form_validation->set_rules('campaign_category', 'lang:campaign_category', 'required|trim');
            if (clean_data($this->input->post('is_proposal')) == '0')
            {
                $this->form_validation->set_rules('retarget', 'Campaign type', 'required|trim');
                $this->form_validation->set_rules('campaign_daily_budget', 'lang:daily_budget', 'required|trim');
                $this->form_validation->set_rules('campaign_budget', 'lang:campaign_budget', 'required|trim');
            }
            
            $ssp_category	=	clean_data($this->input->post('ssp_category'));
        }
        
		if($campaign_from!=='HOUSE_ADS_CAMPAIGN' && $rtb_type != "1")
		{
			$this->form_validation->set_rules('campaign_category', 'Campaign category', 'trim');
			
			if($this->input->post('daily_budget_unlimited')!='1')
			{
			$this->form_validation->set_rules('campaign_daily_budget', 'Daily budget', 'required|trim');
			}		
						
			$this->form_validation->set_rules('campaign_budget', 'Campaign budget', 'required|trim');
			$this->form_validation->set_rules('campaign_weight', 'Weight', 'required|trim'); 
		}
		
		if(clean_data($this->input->post('campaign_type'))==3)
			{
				$this->form_validation->set_rules('cpa_goal', 'CPA Goal', 'required|trim');
				$camp_bid_rate	=	clean_data($this->input->post('cpa_goal'));
			}
			else
			{
				$this->form_validation->set_rules('campaign_bid_rate', 'Bid rate', 'required|trim');
				$camp_bid_rate	=	clean_data($this->input->post('campaign_bid_rate'));
			}
		if(!empty($this->post('targ_city')[0]))
		{
		$this->form_validation->set_rules('targ_city', 'Targeting City', 'trim|callback_valid_city_check');
		}
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{
			$is_direct	=	0;
						

			if($this->user_authentication->account_type=='ADVERTISER')
			{	
				$client_id 	= 	$this->user_authentication->client_id;
				$account_id	=	$this->user_authentication->account_id;
				
				if($this->user_authentication->is_default==2)
				{
					$is_direct	=	1;
							
				}				
			}
			else
			{				
				$adv		=	explode('_',clean_data($this->post('adv_id')));
				$account_id	=	$adv[1];
				$client_id 	= 	($campaign_from=='HOUSE_ADS_CAMPAIGN')?$this->user_authentication->default_advertiser_client_id:$adv[0];
			}
			
			$global	= 	clean_data($this->post('global_tracker'));  
			
			if($global=='on')
			{					 
				$global_tracker=1;
			}	  
			else
			{
				$global_tracker=0;
			} 
			
			$admarket	= 	clean_data($this->post('admarket_campaign'));
			if($admarket=='on')
			{					 
				$admarket_camp=1;
			}	  
			else
			{
				$admarket_camp=0;
			} 
			
			if($campaign_schedule=="specific")
			{
				$start_end_range		=	clean_data($this->input->post('start_end_range'));
				$activate_expire_time	=	explode('-',$start_end_range);
				$activate_time			=	date('Y-m-d H:i:s',strtotime($activate_expire_time[0]));
				$expire_time			=	date('Y-m-d H:i:s',strtotime($activate_expire_time[1]));
			}
			else
			{
				$activate_time	=	date('Y-m-d H:i:s');
				$expire_time	=	NULL;
			}

			$campaign_budget	=	clean_data($this->input->post('campaign_budget'));
			if ($rtb_type != "1")
            {
				$status	=	$this->validate_campaign_status($client_id,$activate_time,$expire_time,$campaign_budget,'edit',$this->input->post('_camp_approved'));
			}
            else
            {
                $status = 	0; // Modified for RTB Campaign
            }
			
			/*
			* Check Campaign Status and Update
			*/
			/*if($this->post('_camp_status')==1)
			{
				$status = $this->post('_camp_status');
			}else{
				$status=$this->validate_campaign_status($client_id,$activate_time,$expire_time,$campaign_budget);
				
			}*/

			//CALCULATE ECPM
			
			if($status >= 0)//if($status == 1 || $status == 2 || $status == 0)
			{
				//CALCULATE ECPM
				switch (clean_data($this->input->post('campaign_type')))
				{
					case 1:
						$ecpm=clean_data($this->input->post('campaign_bid_rate'));
					break;

					case 2:
						$default_click_ratio=$this->default_configurations->get('default_click_ratio');
						$ecpm=$default_click_ratio*clean_data($this->input->post('campaign_bid_rate'))*1000;
					break;

					case 3:
						$default_conversion_ratio=$this->default_configurations->get('default_conversion_ratio');
						$ecpm=$default_conversion_ratio*clean_data($this->input->post('campaign_bid_rate'))*1000;
					break;
					case 4:
                        $ecpm = 'DSP';
                        break;
				}

				//FETCH MINIMUM IMPRESSION FOR ECPM CALCULATION
				$min_impressions=$this->default_configurations->get('min_impressions_day_banner');
				$retarget_flag=clean_data($this->input->post('retargetting_max_time'));
				if(isset($retarget_flag) AND !empty($retarget_flag) )
					$retargetting_max_time=clean_data($this->input->post('retargetting_max_time'));
				else
					$retargetting_max_time=clean_data($this->input->post('cookie_expire'));
				
				//Frequency capping
				if($this->post('frequency_capping')!='yes')
				{
					$nocapping			=	0;
					$block				=	0;
					$session_capping	=	0;
				}
				else
				{
					$nocapping			=	1;
					$block				=	(clean_data($this->post('targ_hour')))?clean_data($this->post('targ_hour'))*3600:0;
					$session_capping	=	(clean_data($this->post('frequency_capping_imp')))?clean_data($this->post('frequency_capping_imp')):0;
				}
					
					
				//budget completion mail and  campaign completion mail
					
				//$this->response( $this->input->post('bid_response'));
				$rem_budget=(clean_data($this->input->post('_camp_budget')) - clean_data($this->input->post('campaign_remain_total_budget')));
				if($rem_budget > clean_data($this->input->post('bid_response')) && $rem_budget!=0 )
				{
					$mail_status = 0;
				}
				else{
					
					$mail_status = clean_data($this->input->post('mail_status'));
					
				}
				//$this->response($this->input->post('_camp_budget').' - '.$this->input->post('campaign_remain_total_budget').' - '.$this->input->post('bid_response'));
				if(strtotime(date('y-m-d', strtotime($expire_time))) > strtotime(date('y-m-d', strtotime( clean_data($this->input->post('expire_date'))))) )
				{
					//$this->response('stopasdasd'.$this->input->post('expire_date'));
					$camp_mail_status = 0;
				}
				else
				{
					$camp_mail_status = clean_data($this->input->post('camp_mail_status'));
					//$this->response('check'.$camp_mail_status);   
				}
				//$this->response($camp_mail_status.'-mail_check');
				$evenly_distribute = $this->input->post('evenly_distribute');
if(clean_data($this->post('device_type')) == 'include')
{				
				$dj_targetting_type = $this->input->post('campaign_targeting_type');				
}
else if(clean_data($this->post('device_type')) == 'exclude')
{				
				$dj_targetting_type = $this->input->post('campaign_target_type1');				
}
				$campaign_data	=	array(
											 'clientid'				=>	clean_data($client_id),
											 'campaignname'			=>	clean_data($this->input->post('campaign_name')),
											 'revenue_type'			=>	clean_data($this->input->post('campaign_type')),
											 'cpv_percentage'       =>  clean_data($this->input->post('cpv_view')),  
											 'activate_time'		=>  clean_data($activate_time),
											 'expire_time'			=>  $expire_time,
											// 'dj_targetting_type'	=>  clean_data($dj_targetting_type),
											 'priority'				=>  clean_data('-2'),
											 'revenue'				=>	clean_data($camp_bid_rate),
											 'hourly_bid_rate'		=>	clean_data($this->input->post('hourly_bid_rate')),
											 'hourly_bid_timing'	=>	clean_data($this->input->post('hourly_bid_timing')),											 
											 'dj_campaign_budget'	=>	clean_data($this->input->post('campaign_budget')),
											 'dj_daily_budget'		=>	clean_data($this->input->post('campaign_daily_budget')),
											 'dj_category_id'		=>	clean_data($this->input->post('campaign_category')),
											 'dj_sub_category'		=>	clean_data($this->input->post('campaign_sub_category')),
											 'weight'				=>	clean_data($this->input->post('campaign_weight')),
											 'viewwindow'			=>	clean_data('8388607'),
											 'clickwindow'			=>	clean_data('8388607'),
											 'ecpm'					=>	clean_data($ecpm),
											 'status'				=>	clean_data($status),
											 'min_impressions'		=>	clean_data($min_impressions),
											 'dj_is_retargeted'		=>	clean_data($this->input->post('retarget')),
											 'dj_max_retargetting'	=>	clean_data($retargetting_max_time),
											 'behavior'		        =>	clean_data($this->input->post('behavior')),										 
											 'dj_added_date'  		=> 	date('Y-m-d H:i:s'),
											 'dj_is_rtb_campaign' 	=> 	clean_data($rtb_type),
											 'dj_rtb_buyer_id' 		=> 	clean_data($ssp_category),
											 'dj_is_admarket'		=>	clean_data($admarket_camp),
											 'dj_is_direct'			=>	clean_data($is_direct),
											 'block'				=> 	$block,
											 'capping'				=>	$nocapping,
											 'session_capping'		=> 	$session_capping,
											 'an_status'			=> 	clean_data($this->input->post('campaign_status')),
											 'bid_response'			=>	clean_data($this->input->post('bid_response')),
											 'mail_status'			=> $mail_status,
											 'camp_mail_status'		=> $camp_mail_status,
											 'evenly_distribution'  =>  $evenly_distribute,
											'test_budget'  			=>	($test_budget)?$test_budget:'0',
											'smart_desktop_imp'		=>	$smart_desktop_imp,
											'smart_mobile_imp'		=>	$smart_mobile_imp,
											'smart_conversion'		=>	($smart_conversion)?$smart_conversion:'0',
											'smart_cpa'				=>	($smart_cpa)?$smart_cpa:0
										);
				
				//$this->response( $campaign_data, 200); exit;
				$campaign_id	=	clean_data($this->post('_campaign_id'));
				$campaign_edit	= 	$this->do_campaign->edit_campaign($campaign_data,$client_id,$campaign_id,$global_tracker);
										
				//traffic source 
				if($this->post('traffic_source'))
				{
					$sources	=	$this->post('traffic_source');
					$this->do_campaign->campaign_traffic_source_assoc($campaign_id,$sources,$account_id);
				}
				else
				{
					$this->do_campaign->delete_camp_assoc($campaign_id,'traffic_source');
				}
				
				//Zone bidding 
				if($this->post('zone_bidding'))
				{
					$zones	=	$this->post('zone_bidding');
					$this->do_campaign->campaign_zone_bidding_assoc($campaign_id,$zones,$account_id);
				}
				else
				{
					$this->do_campaign->delete_camp_assoc($campaign_id,'zone_bidding');
				}
				
				//Country Bidding
				if($this->post('country_bidding'))
				{
					$country_bidding	=	$this->post('country_bidding');
					$this->do_campaign->campaign_country_bidding_assoc($campaign_id,clean_data($this->post('_account_id')),$country_bidding);
				}
				else
				{
					$this->do_campaign->delete_camp_assoc($campaign_id,'country_bidding');
				}
				
				// group options
				if(clean_data($this->post('group')))
				{  
					$group	=	clean_data($this->post('group'));
					$this->do_campaign->campaign_group_assoc($campaign_id,$group);
					//$this->response($this->db->last_query(),200);
				}
				else
				{  
					$this->do_campaign->delete_camp_assoc($campaign_id,'group');
				}
				
				//Pixel Tracker
				if(clean_data($this->post('tracker')))
				{
					$tracker_data	=	array(
												'tracker_id'	=>	clean_data($this->post('tracker')),
												'campaign_id'	=>	$campaign_id,
												'global_tracker'=>	$global_tracker
											);
					$this->do_campaign->campaign_tracker_assoc($tracker_data);
				}
				else
				{
					$this->do_campaign->delete_camp_assoc($campaign_id,'tracker');
				}				
					
				$campaign_name	=	clean_data($this->input->post('campaign_name'));	
				
				if($campaign_id)
				{					
					//Targeting
					
					//Browser Targeting
					
					$brow_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:Browser",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	0,
										);						
					
					if($this->post('targ_browser'))
					{
						$brow = 	implode(',',clean_data($this->post('targ_browser')));
						
						if($brow)
						{
							$brow_data['data']	=	$brow;
							
							$this->do_targeting->add($brow_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($brow_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($brow_data,$campaign_id);
					}

					//Browser Exclude Targeting
					
					$browEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:Browser",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	0,
										);					
						
					if($this->post('targ_browser_excl'))
					{
						$browEx = 	implode(',',clean_data($this->post('targ_browser_excl')));						
						if($browEx)
						{
							$browEx_data['data']			=	$browEx;										
							$this->do_targeting->add($browEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($browEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($browEx_data,$campaign_id);
					}
										
					//Browser Language Targeting
					$lang_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:Language",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	1,
										);
						
					if($this->post('targ_browser_lang'))
					{						
						$lang = 	implode(',',clean_data($this->post('targ_browser_lang')));						
						
						if($lang)
						{
							$lang_data['data']	=	$lang;
							
							$this->do_targeting->add($lang_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($lang_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($lang_data,$campaign_id);
					}

					//Browser Exclude Language Targeting
					$langEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:Language",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	1,
										);
						
					if($this->post('targ_browser_lang_excl'))
					{						
						$langEx = 	implode(',',clean_data($this->post('targ_browser_lang_excl')));					
						if($langEx)
						{
							$langEx_data['data']	=	$langEx;
							
							$this->do_targeting->add($langEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($langEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($langEx_data,$campaign_id);
					}

					//Browser Version Targeting
					$brow_ver_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:BrowserVersion",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	1,
										);
						
					if($this->post('targ_browser_vers'))
					{						
						$brow = 	implode(',',clean_data($this->post('targ_browser_vers')));						
						
						if($brow)
						{
							$brow_ver_data['data']	=	$brow;
							//$this->response($brow_ver_data,200);
							$this->do_targeting->add($brow_ver_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($brow_ver_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($brow_ver_data,$campaign_id);
					}					

					//Browser Version Exclude Targeting
					$browEx_ver_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:BrowserVersion",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	1,
										);
						
					if($this->post('targ_browser_vers_excl'))
					{						
						$browEx = 	implode(',',clean_data($this->post('targ_browser_vers_excl')));
						if($browEx)
						{
							$browEx_ver_data['data']	=	$browEx;
							
							$this->do_targeting->add($browEx_ver_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($browEx_ver_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($browEx_ver_data,$campaign_id);
					}
					
					//OS Targeting
					$os_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:Os",
											"comparison"	=> 	"==",
											"data"			=> 	$os,
											"executionorder"=> 	2,
										);
						
					if($this->post('targ_os'))
					{						
						$os = 	implode(',',clean_data($this->post('targ_os')));
						
						if($os)
						{
							$os_data['data']	=	$os;
							
							$this->do_targeting->add($os_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($os_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($os_data,$campaign_id);
					}


					//OS Exclude Targeting
					$osEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:Os",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	2,
										);
						
					if($this->post('targ_os_excl'))
					{						
						$osEx = 	implode(',',clean_data($this->post('targ_os_excl')));
						
						if($osEx)
						{
							$osEx_data['data']	=	$osEx;
							
							$this->do_targeting->add($osEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($osEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($osEx_data,$campaign_id);
					}

					//OS version Targeting
					$osvers_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:OsVersion",
											"comparison"	=> 	"==",
											"data"			=> 	$os,
											"executionorder"=> 	2,
										);
						
					if($this->post('targ_os_version'))
					{						
						$os = 	implode(',',clean_data($this->post('targ_os_version')));
						
						if($os)
						{
							$osvers_data['data']	=	$os;
							
							$this->do_targeting->add($osvers_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($osvers_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($osvers_data,$campaign_id);
					}

					//OS version Targeting Exclude
					$osversEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Client:OsVersion",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	2,
										);
						
					if($this->post('targ_os_version_excl'))
					{						
						$osversEx = 	implode(',',clean_data($this->post('targ_os_version_excl')));
						
						if($osversEx)
						{
							$osversEx_data['data']	=	$osversEx;
							
							$this->do_targeting->add($osversEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($osversEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($osversEx_data,$campaign_id);
					}
					
					//Device Targeting
					
					$device_idata	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"device:".strtolower($this->input->post('campaign_targeting_type')),
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	3,
											);
					$device_edata	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"device:".strtolower($this->input->post('campaign_targeting_type')),
												"comparison"	=> 	"!=",
												"data"			=> 	FALSE,
												"executionorder"=> 	3,
											);
											
					$devtype	=	array('all','web','mobile','tablet');

					if($this->post('targ_include_device'))
					{						
						$device = 	implode(',',clean_data($this->post('targ_include_device')));
						
						if($device)
						{
							$device_idata['data']	=	$device;
							//$device_idata['type']	=	"device:".strtolower($this->input->post('campaign_targeting_type'));
							
							$this->do_targeting->add($device_idata,$campaign_id);
						}
						else
						{	//$this->response($device_idata,200);									
							$this->do_targeting->delete($device_idata,$campaign_id);
						}
					}
					else
					{							
						foreach($devtype as $de)
						{							
							$this->do_targeting->delete($device_idata,$campaign_id);
						}						
					}
					
					if($this->post('targ_exclude_device'))
					{						
						$device = 	implode(',',clean_data($this->post('targ_exclude_device')));
						
						if($device)
						{
							$device_edata['data']	=	$device;
							//$device_edata['type']	=	"device:".strtolower($this->input->post('campaign_target_type1'));
							$this->do_targeting->add($device_edata,$campaign_id);
						}
						else
						{		
							$this->do_targeting->delete($device_edata,$campaign_id);							
						}
					}
					else
					{	
						foreach($devtype as $de)
						{								
							$this->do_targeting->delete($device_edata,$campaign_id);
						}					
					}
					
					
					
/*if(clean_data($this->post('device_type')) == 'include')
{
					$this->do_targeting->delete1($device_idata,$campaign_id);
					$this->do_targeting->delete1($device_edata,$campaign_id);
					if($this->post('targ_include_device'))
					{						
						$device = 	implode(',',clean_data($this->post('targ_include_device')));
						
						if($device)
						{
							$device_idata['data']	=	$device;
							$device_idata['type']	=	"device:".strtolower($this->input->post('campaign_targeting_type'));
							
							$this->do_targeting->add($device_idata,$campaign_id);
						}
						else
						{	
							foreach($devtype as $de)
							{
								
								$this->do_targeting->delete1($device_idata,$campaign_id);
							}
						}
					}
					else
					{	
						foreach($devtype as $de)
						{
							
							$this->do_targeting->delete1($device_idata,$campaign_id);
						}
					}

	
}
else if(clean_data($this->post('device_type')) == 'exclude')
{
					$this->do_targeting->delete1($device_idata,$campaign_id);
					$this->do_targeting->delete1($device_edata,$campaign_id);
					if($this->post('targ_exclude_device'))
					{						
						$device = 	implode(',',clean_data($this->post('targ_exclude_device')));
						
						if($device)
						{
							$device_edata['data']	=	$device;
							$device_edata['type']	=	"device:".strtolower($this->input->post('campaign_target_type1'));
							$this->do_targeting->add($device_edata,$campaign_id);
						}
						else
						{	
							foreach($devtype as $de)
							{
									
								$this->do_targeting->delete1($device_edata,$campaign_id);
							}
						}
					}
					else
					{	
						foreach($devtype as $de)
						{
							
							$this->do_targeting->delete1($device_edata,$campaign_id);
						}
					}

	
}	*/				

					
					//Country Include Targeting
					$country_idata	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"Include_country",
											"comparison"	=> 	"=~",
											"data"			=> 	FALSE,
											"executionorder"=> 	4,
										);
					//Country Exclude Targeting
					$country_edata	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"Exclude_country",
												"comparison"	=> 	"=~",
												"data"			=> 	FALSE,
												"executionorder"=> 	4,
											);
						
					//if(clean_data($this->post('country_type'))=='include')
					//{	
						$this->do_targeting->delete($country_idata,$campaign_id);
																
						if(clean_data($this->post('targ_geo_include')))
						{						
							$country_include = 	implode(',',clean_data($this->post('targ_geo_include')));
							
							if($country_include)
							{
								$country_idata['data']	=	$country_include;
								
								$this->do_targeting->add($country_idata,$campaign_id);
							}
							else
							{
								$this->do_targeting->delete($country_idata,$campaign_id);
							}
						}
						else
						{
							$this->do_targeting->delete($country_idata,$campaign_id);
						}
					
					/*}
					else if(clean_data($this->post('country_type'))=='exclude')
					{*/	
						$this->do_targeting->delete($country_edata,$campaign_id);
																
						if(clean_data($this->post('targ_geo_exclude')))
						{						
							$country_exclude = 	implode(',',clean_data($this->post('targ_geo_exclude')));
							
							if($country_exclude)
							{
								$country_edata['data']	=	$country_exclude;
								
								$this->do_targeting->add($country_edata,$campaign_id);
							}
							else
							{
								$this->do_targeting->delete($country_edata,$campaign_id);
							}
						}
						else
						{
							$this->do_targeting->delete($country_edata,$campaign_id);
						}
					//}						
					
					//City Targeting
					$city_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Geo:City",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	5,
										);
						
					if(clean_data($this->post('targ_city')))
					{													
						$city = 	implode(',',clean_data($this->post('targ_city')));
						if($city)
						{							
							$city_data['data']	=	$city;
							
							$this->do_targeting->add($city_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($city_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($city_data,$campaign_id);
					}

					//City EXCLUDE Targeting
					$cityEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Geo:City",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	5,
										);
						
					if(clean_data($this->post('targ_city_exclude')))
					{		
						$cityEx = 	implode(',',clean_data($this->post('targ_city_exclude')));
						
						if($cityEx)
						{							
							$cityEx_data['data']	=	$cityEx;
							
							$this->do_targeting->add($cityEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($cityEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($cityEx_data,$campaign_id);
					}
										
					//Zip Targeting
					$zip_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Geo:Zip",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	6,
										);
						
					if(clean_data($this->post('targ_zip')))
					{						
						$zip = 	clean_data($this->post('targ_zip'));
						
						if($zip)
						{
							$zip_data['data']	=	$zip;
							
							$this->do_targeting->add($zip_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($zip_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($zip_data,$campaign_id);
					}																			
					//ZipExclude Targeting
					$zipEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Geo:Zip",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	6,
										);
						
					if(clean_data($this->post('targ_zip_exclude')))
					{						
						$zipEx = 	clean_data($this->post('targ_zip_exclude'));
						
						if($zipEx)
						{
							$zipEx_data['data']	=	$zipEx;
							
							$this->do_targeting->add($zipEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($zipEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($zipEx_data,$campaign_id);
					}					
					//Manufacturer targeting
					
					$manu_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"handset",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	7,
										);
						
					if(clean_data($this->post('targ_mob_manu')))
					{						
						$manu = 	implode(',',clean_data($this->post('targ_mob_manu')));
						
						if($manu)
						{
							$manu_data['data']	=	$manu;
							
							$this->do_targeting->add($manu_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($manu_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($manu_data,$campaign_id);
					}

		//Manufacturer Exclude targeting
					
					$manuEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"handset",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	7,
										);
						
					if(clean_data($this->post('targ_mob_manu_excl')))
					{						
						$manuEx = 	implode(',',clean_data($this->post('targ_mob_manu_excl')));
						
						if($manuEx)
						{
							$manuEx_data['data']	=	$manuEx;
							
							$this->do_targeting->add($manuEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($manuEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($manuEx_data,$campaign_id);
					}					
					//Capability targeting
					$capab_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"capability",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	8,
										);
						
					if(clean_data($this->post('targ_mob_capability')))
					{						
						$capab = 	implode(',',clean_data($this->post('targ_mob_capability')));
						
						if($capab)
						{
							$capab_data['data']	=	$capab;
							
							$this->do_targeting->add($capab_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($capab_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($capab_data,$campaign_id);
					}

					//Capability targeting
					$capabEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"capability",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	8,
										);
						
					if(clean_data($this->post('targ_mob_capability_excl')))
					{						
						$capabEx = 	implode(',',clean_data($this->post('targ_mob_capability_excl')));
						
						if($capabEx)
						{
							$capabEx_data['data']	=	$capabEx;
							
							$this->do_targeting->add($capabEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($capabEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($capabEx_data,$campaign_id);
					}					
					//Connection targeting
					$connect_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"connection",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	9,
										);
						
					if(clean_data($this->post('targ_mob_connection')))
					{						
						$connection = 	implode(',',clean_data($this->post('targ_mob_connection')));
						
						if($connection)
						{
							$connect_data['data']	=	$connection;
							
							$this->do_targeting->add($connect_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($connect_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($connect_data,$campaign_id);
					}

					//Connection targeting
					$connectEx_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"connection",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	9,
										);
						
					if(clean_data($this->post('targ_mob_connection_excl')))
					{						
						$connectionEx = 	implode(',',clean_data($this->post('targ_mob_connection_excl')));
						
						if($connectionEx)
						{
							$connectEx_data['data']	=	$connectionEx;
							
							$this->do_targeting->add($connectEx_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($connectEx_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($connectEx_data,$campaign_id);
					}					
					//Carrier targeting
					$carrier_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"carrier",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	10,
										);
						
					if(clean_data($this->post('targ_mob_carrier')))
					{						
						$carrier = 	implode(',',clean_data($this->post('targ_mob_carrier')));
						
						if($carrier)
						{
							$carrier_data['data']	=	$carrier;
							
							$this->do_targeting->add($carrier_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($carrier_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($carrier_data,$campaign_id);
					}
					//Carrier targeting
					$carrierEX_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"carrier",
											"comparison"	=> 	"!=",
											"data"			=> 	FALSE,
											"executionorder"=> 	10,
										);						
					if(clean_data($this->post('targ_mob_carrier_excl')))
					{						
						$carrierEx = 	implode(',',clean_data($this->post('targ_mob_carrier_excl')));				
						if($carrierEx)
						{
							$carrierEX_data['data']	=	$carrierEx;							
							$this->do_targeting->add($carrierEX_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($carrierEX_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($carrierEX_data,$campaign_id);
					}					
					//Blacklist targeting
					$pblack_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"profile:preset_blacklist",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	11,
										);
															
					//Blacklist targeting
					$black_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"profile:blacklist",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	11,
										);
					
					//Whitelist targeting
					$white_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"profile:whitelist",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	11,
										);
						
					//Whitelist targeting
					$pwhite_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"profile:preset_whitelist",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	11,
										);											
					if(clean_data($this->post('targ_list'))=='black')
					{	
						$this->do_targeting->delete($pwhite_data,$campaign_id);
						
						if(clean_data($this->post('preset_black')))
						{						
							$pblack = 	implode(',',clean_data($this->post('preset_black')));
							if($pblack)
							{
								$pblack_data['data']	=	$pblack;
								
								$this->do_targeting->add($pblack_data,$campaign_id);
							}
							else
							{
								$this->do_targeting->delete($pblack_data,$campaign_id);
							}
						}
						else
						{
							$this->do_targeting->delete($pblack_data,$campaign_id);
						}
						
						$this->do_targeting->delete($white_data,$campaign_id);
											
						if(clean_data($this->post('targ_blacklist')))
						{						
							$black = 	clean_data($this->post('targ_blacklist'));//implode(',',clean_data($this->post('targ_blacklist')));
							if($black)
							{
								$black_data['data']	=	$black;
								
								$this->do_targeting->add($black_data,$campaign_id);
							}
							else
							{
								$this->do_targeting->delete($black_data,$campaign_id);
							}
						}
						else
						{
							$this->do_targeting->delete($black_data,$campaign_id);
						}
					}
					
					if(clean_data($this->post('targ_list'))=='white')
					{
						$this->do_targeting->delete($pblack_data,$campaign_id);
												
						if(clean_data($this->post('preset_white')))
						{						
							$pwhite = 	implode(',',clean_data($this->post('preset_white')));
							if($pwhite)
							{
								$pwhite_data['data']	=	$pwhite;
								
								$this->do_targeting->add($pwhite_data,$campaign_id);
							}
							else
							{
								$this->do_targeting->delete($pwhite_data,$campaign_id);
							}
						}
						else
						{
							$this->do_targeting->delete($pwhite_data,$campaign_id);
						}
						
						$this->do_targeting->delete($black_data,$campaign_id);
												
						if(clean_data($this->post('targ_whitelist')))
						{						
							$white = 	clean_data($this->post('targ_whitelist'));//implode(',',$this->post('targ_whitelist'));
							if($white)
							{
								$white_data['data']	=	$white;
								
								$this->do_targeting->add($white_data,$campaign_id);
							}
							else
							{
								$this->do_targeting->delete($white_data,$campaign_id);
							}
						}
						else
						{
							$this->do_targeting->delete($white_data,$campaign_id);
						}
					}
					
					//Hour targeting
					$hour_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"deliveryLimitations:Time:Hour",
											"comparison"	=> 	"=~",
											"data"			=> 	FALSE,
											"executionorder"=> 	11,
										);
					
					//Daypart Targeting
					$daypart_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"deliveryLimitations:Time:Day",
												"comparison"	=> 	"=~",
												"data"			=> 	FALSE,
												"executionorder"=> 	11,
											);
					
														
					if(clean_data($this->post('weekly_distribute'))=='custom')
					{							
						if(clean_data($this->post('targ_time')))
						{						
							$hour = 	implode(',',clean_data($this->post('targ_time')));
							if($hour)
							{
								$hour_data['data']	=	$hour;
								
								$this->do_targeting->add($hour_data,$campaign_id);
							}
							else
							{
								$this->do_targeting->delete($hour_data,$campaign_id);
							}
						}
						else
						{
							$this->do_targeting->delete($hour_data,$campaign_id);
						}						
						
						if(clean_data($this->post('targ_daypart')))
						{						
							$daypart = 	implode(',',clean_data($this->post('targ_daypart')));
							if($daypart!='')
							{
								$daypart_data['data']	=	$daypart;
								
								$this->do_targeting->add($daypart_data,$campaign_id);
							}
							else
							{
								$this->do_targeting->delete($daypart_data,$campaign_id);
							}
						}
						else
						{
							$this->do_targeting->delete($daypart_data,$campaign_id);
						}
							
						if(clean_data($this->post('daypart_time')))
						{						
							$daypart_time = 	implode(',',clean_data($this->post('daypart_time')));
							
							if($daypart_time)
							{
								$daypart_time_data	=	array('dj_weekly_distribute'=>$daypart_time);
								
								$this->do_campaign->add_campaign_favourite($campaign_id,$daypart_time_data);
							}
							else
							{
								$daypart_time_data	=	array('dj_weekly_distribute'=>'');
								
								$this->do_campaign->add_campaign_favourite($campaign_id,$daypart_time_data);
							}
						}
						else
						{
							$daypart_time_data	=	array('dj_weekly_distribute'=>'');
							
							$this->do_campaign->add_campaign_favourite($campaign_id,$daypart_time_data);
						}
					}	
					else
					{
						$this->do_targeting->delete($hour_data,$campaign_id);
						$this->do_targeting->delete($daypart_data,$campaign_id);
						$daypart_time_data	=	array('dj_weekly_distribute'=>'');
							
						$this->do_campaign->add_campaign_favourite($campaign_id,$daypart_time_data);
					}									
					
					//Url Keyword Targeting
					$urlkey_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:url",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	0,
											);
						
					if(clean_data($this->post('targ_url_keyword')))
					{						
						$urlkey = 	clean_data($this->post('targ_url_keyword'));
						
						if($urlkey)
						{
							$urlkey_data['data']	=	$urlkey;
							
							$this->do_targeting->add($urlkey_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($urlkey_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($urlkey_data,$campaign_id);
					}
					
					//Keyword Targeting
					
					$keyword_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:keyword",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	1,
											);

					if(clean_data($this->post('targ_profile_keyword')))
					{						
						$keyword = 	clean_data($this->post('targ_profile_keyword'));
						
						if($keyword)
						{
							$keyword_data['data']	=	$keyword;
													
							$this->do_targeting->add($keyword_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($keyword_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($keyword_data,$campaign_id);
					}

					//Keyword new Targeting
					
					$new_keyword_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:avail_keyword",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	1,
											);

					if(clean_data($this->post('avail_keys')))
					{						
						//$avail_keyword = 	clean_data($this->post('avail_keys'));
						$avail_keyword = 	implode(',',clean_data($this->post('avail_keys')));
						if($avail_keyword)
						{
							$new_keyword_data['data']	=	$avail_keyword;
													
							$this->do_targeting->add($new_keyword_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($new_keyword_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($new_keyword_data,$campaign_id);
					}
					
					//blocked Keyword Targeting
					
					$blocked_keyword_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:blocked_keyword",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	1,
											);

					if(clean_data($this->post('blocked_key_name')))
					{												
						$blocks_keyword = 	clean_data($this->post('blocked_key_name'));
						$block_keyword  =	str_replace( array('\r\n','\n\r','\n','\r'), ',' , $blocks_keyword );
						
						if($block_keyword)
						{
							$blocked_keyword_data['data']	=	$block_keyword;
													
							$this->do_targeting->add($blocked_keyword_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($blocked_keyword_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($blocked_keyword_data,$campaign_id);
					}
										
					//Age Targeting
					
					$age_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:age",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	2,
											);

					if(clean_data($this->post('targ_profile_age')))
					{						
						$age = 	implode(',',clean_data($this->post('targ_profile_age')));
						
						if($age)
						{
							$age_data['data']	=	$age;
													
							$this->do_targeting->add($age_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($age_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($age_data,$campaign_id);
					}
					
					//Gender Targeting
					$gender_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:gender",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	3,
											);

					if(clean_data($this->post('targ_profile_gender')))
					{						
						$gender = 	implode(',',clean_data($this->post('targ_profile_gender')));
						
						if($gender)
						{
							$gender_data['data']	=	$gender;
													
							$this->do_targeting->add($gender_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($gender_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($gender_data,$campaign_id);
					}
					
					//Color Targeting
					$color_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:color",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	4,
											);

					if(clean_data($this->post('targ_profile_color')))
					{						
						$color = 	implode(',',clean_data($this->post('targ_profile_color')));
						
						if($color)
						{
							$color_data['data']	=	$color;
													
							$this->do_targeting->add($color_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($color_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($color_data,$campaign_id);
					}
					
					//Height Targeting
					$height_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:height",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	5,
											);

					if(clean_data($this->post('targ_profile_height')))
					{						
						$height = 	implode(',',clean_data($this->post('targ_profile_height')));
						
						if($height)
						{
							$height_data['data']	=	$height;
													
							$this->do_targeting->add($height_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($height_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($height_data,$campaign_id);
					}
					
					//Height Targeting
					$weight_data	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"profile:weight",
												"comparison"	=> 	"==",
												"data"			=> 	FALSE,
												"executionorder"=> 	6,
											);

					if(clean_data($this->post('targ_profile_weight')))
					{						
						$weight = 	implode(',',clean_data($this->post('targ_profile_weight')));
						
						if($weight)
						{
							$weight_data['data']	=	$weight;
													
							$this->do_targeting->add($weight_data,$campaign_id);
						}
						else
						{
							$this->do_targeting->delete($weight_data,$campaign_id);
						}
					}
					else
					{
						$this->do_targeting->delete($weight_data,$campaign_id);
					}
					/* Activity Log for edit campaign - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(CAMPAIGNS,CAMP_EDIT);
					if($enable=='1')
					{				
						$this->cam_activity_log(CAMPAIGN,EDIT,$campaign_id);
					}
					/* Activity Log for edit campaign - End*/					
					/*********Message Requirements**************/
		
					$client_id 		=	$this->user_authentication->client_id;

					$account_type	=	$this->user_authentication->account_type;	
					$network_id	=	$this->user_authentication->network_account_id;					
					$agency_id	=	$this->user_authentication->agency_id;
					$result		=	$this->do_networks->agency_owner_details($agency_id);
					$admin_name    	= 	$result['name'];			
					$admin_email	= 	$result['email'];	
					$admin_id   	= 	$result['account_id'];

					if($account_type=='ADVERTISER')
					{
						$message  = $this->default_configurations->get('message_type');		
						
						if($account_type=='TRAFFICKER')
						{
							$affiliate_id	=	$this->user_authentication->affiliate_id;
							$user 			= 	$this->do_message->get_affiliate($affiliate_id); 

						}
						else{
							$user = $this->do_message->get_profile($admin_id); 
						}
						
						$acc_type='ADVERTISER';
						
						$type_details		=	array(
													'msg_type'		=> $message,
													'type'			=> "ADMIN_MESSAGE_SETTINGS",
													'string'		=> 'camp_edit',
													'column_name'	=> 'campaigns'
													);
							
							
						$reciever= $this->do_campaign->fetch_reciever($campaign_id);
						$message_data		=	array(
														'sender_id'		=>	$admin_id,
														'receiver_id'	=>	$reciever['account_id'],
														'subject'		=>	'Campaign Edited',
														'content'		=>	'Congrats! The campaign <b>'.clean_data($this->input->post('campaign_name')).'</b>  has been edited successfully ',
														'image_name'	=>	NULL,
														'file_name'		=>	NULL,
														'account_type'	=>	$acc_type,
														'status'		=>	'1',
														'network_id'	=>	$network_id,									
														'date'			=>	date('Y-m-d H:i:s')
														);

						$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details);

					}
					
					/*********Message Requirements**************/
					
					$link_name=strtolower($this->user_authentication->account_type);
					if($link_name=="advertiser")
					{
						$link="advertiser";
					}
					else
					{
						$link=$link_name;
					}
										
					$success = array(
									'response' 		=> 	'ok',
									'msg'	 		=> 	'Campaign sucessfully edited',
									'redirect'	 	=> 	site_url($link.'/campaigns'),
									'campaign_id'	=> 	$campaign_id,
									'campaign_name'	=> 	$campaign_name,
									'account_id'	=> 	$account_id,
									'status'		=>	$status
									);
					$this->response( $success, 200);
				}
				else
				{
					$link_name=strtolower($this->user_authentication->account_type);
					if($link_name=="advertiser")
					{
						$link="advertiser";
					}
					else
					{
						$link=$link_name;
					}
					$error = array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error. Please try again',
									'redirect'	=> 	site_url($link.'/campaigns'),
									'campaign_id'=> $campaign_id,
									'status'	=> 	$status
									);	
					$this->response( $error, 200);
				}
			}
			else
			{
				$error = array(
								'response' 	=> 	'error',
								'msg'	 	=> 	array('start_end_range'=>'Campaign start & end date should not be same'),
								//'redirect'	 => site_url('advertiser/campaigns'),
								);	
				$this->response( $error, 200);
			}	
			
		}
		
	}


	 /*
	 * 
	 * name: delete_get
	 * @param :
	 * @return : $creative_id
	 * 
	 * Delete the given campaign_id id
	 */
	
	function delete_get()
	{
		$del_campaign_id = $this->get('campaign_id');
		
		/**********************Message***********************/
		
		$account_id 			=	$this->user_authentication->account_id;
		
		$client_id 			=	$this->user_authentication->client_id;
	
		$account_type	=	$this->user_authentication->account_type;	
		$network_id	=	$this->user_authentication->network_account_id;					
		$agency_id	=	$this->user_authentication->agency_id;
		$result		=	$this->do_networks->agency_owner_details($agency_id);
		$admin_name    	= 	$result['name'];			
		$admin_email	= 	$result['email'];	
		$admin_id   	= 	$result['account_id'];
			$k='0';
		/*********************Message***********************/
		
		if($del_campaign_id)
		{
			$camp_id	=	explode(',',$del_campaign_id);
		
			if(is_array($camp_id))
			{
				$k='1';
				foreach($camp_id as $campaign_id)
				{					
					$campaign_det = $this->do_campaign->fetch_campaign_details($campaign_id);
					$campaignname .= $campaign_det[0]['campaignname'].',';			
					
					$receiver	= 	$this->do_campaign->fetch_reciever($campaign_id);
					
					$publist	=	$this->do_campaign->fetch_camp_publishers($campaign_id);
							
					if(!empty($publist))
					{
						foreach($publist as $pub):						
							$notify[$pub['account_id']]	=	$this->do_publisher->fetch_notification($pub['account_id']);
							$publisher 	= 	$this->do_publisher->get_profile($pub['account_id']);
							$msg_data	=	array(
												'sender_id'		=>	$receiver['account_id'],
												'receiver_id'	=>	$pub['account_id'],
												'subject'		=>	'Newsletter - Campaign Deleted',
												'content'		=>	'The campaign <b>'.$campaign_det[0]['campaignname'].'</b> has been deleted, So the ads will not get deliver from this campaign.',
												'image_name'	=>	NULL,
												'file_name'		=>	NULL,
												'account_type'	=>	'TRAFFICKER',
												'status'		=>	'1',
												'network_id'	=>	$network_id,									
												'date'			=>	date('Y-m-d H:i:s')												
												);
												
							if(!empty($notify[$pub['account_id']])):
								if($notify[$pub['account_id']][0]['campaign_news_enable']==1):
									$camids	=	($notify[$pub['account_id']][0]['campaign_id'])?explode($notify[$pub['account_id']][0]['campaign_id']):'';
									if($camids != '' && in_array($campaign_id,$camids))
										$this->notification->pub_mail($msg_data,$receiver,$publisher);
									else if($camids==''):
										if(($notify[$pub['account_id']][0]['campaign_news_type']=='member' && $campaign_det[0]['dj_favourite_status']==0) || ($notify[$pub['account_id']][0]['campaign_news_type']=='favorite' && $campaign_det[0]['dj_favourite_status']==1) || ($notify[$pub['account_id']][0]['campaign_news_type']=='both')):
											$this->notification->pub_mail($msg_data,$receiver,$publisher);
										endif;
									endif;
								endif;							
							endif;
						endforeach;
					}
				
					$success=	$this->delete_campaign($campaign_id);
					
				}
			
			}
			else
			{
				$campaign_det = $this->do_campaign->fetch_campaign_details($camp_id);
				$campaignname .= $campaign_det[0]['campaignname'].',';	
				
				$receiver	= 	$this->do_campaign->fetch_reciever($camp_id);
					
				$publist	=	$this->do_campaign->fetch_camp_publishers($camp_id);
							
				if(!empty($publist))
				{
					foreach($publist as $pub):						
						$notify[$pub['account_id']]	=	$this->do_publisher->fetch_notification($pub['account_id']);
						$publisher 	= 	$this->do_publisher->get_profile($pub['account_id']);
						$msg_data	=	array(
											'sender_id'		=>	$receiver['account_id'],
											'receiver_id'	=>	$pub['account_id'],
											'subject'		=>	'Campaign Deleted',
											'content'		=>	'The campaign <b>'.$campaign_det[0]['campaignname'].'</b> has been deleted.',
											'image_name'	=>	NULL,
											'file_name'		=>	NULL,
											'account_type'	=>	'TRAFFICKER',
											'status'		=>	'1',
											'network_id'	=>	$network_id,									
											'date'			=>	date('Y-m-d H:i:s')												
											);
											
						if(!empty($notify[$pub['account_id']])):
							if($notify[$pub['account_id']][0]['campaign_news_enable']==1):
								$camids	=	($notify[$pub['account_id']][0]['campaign_id'])?explode($notify[$pub['account_id']][0]['campaign_id']):'';
								if($camids != '' && in_array($camp_id,$camids))
									$this->notification->pub_mail($msg_data,$receiver,$publisher);
								else if($camids==''):
									if(($notify[$pub['account_id']][0]['campaign_news_type']=='member' && $campaign_det[0]['dj_favourite_status']==0) || ($notify[$pub['account_id']][0]['campaign_news_type']=='favorite' && $campaign_det[0]['dj_favourite_status']==1) || ($notify[$pub['account_id']][0]['campaign_news_type']=='both')):
										$this->notification->pub_mail($msg_data,$receiver,$publisher);
									endif;
								endif;
							endif;							
						endif;
					endforeach;
				}
			
				$success	=	$this->delete_campaign($camp_id);
			$k='0';
			}
			
			
				
			/**************Message Requirement******************/
					
			if($account_type=='ADVERTISER')
			{
				$msg_type 	= 	$this->default_configurations->get('message_type');		
		
				$user 		= 	$this->do_message->get_profile($admin_id); 
				if($k == '1'){
					$subjects ='The campaigns  <b>'.rtrim($campaignname,',').'</b> has been deleted successfully.';
				}
				else{
					$subjects ='The campaign  <b>'.rtrim($campaignname,',').'</b> has been deleted successfully.';
				}
				$message_data		=	array(
												'sender_id'		=>	$admin_id,
												'receiver_id'	=>	$receiver['account_id'],
												'subject'		=>	'Campaign Deleted',
												'content'		=>	$subjects,
												'image_name'	=>	NULL,
												'file_name'		=>	NULL,
												'account_type'	=>	$account_type,
												'status'		=>	'1',
												'network_id'	=>	$network_id,									
												'date'			=>	date('Y-m-d H:i:s')
												);	
				
				$type_details		=	array(
											'msg_type'		=> $msg_type,
											'type'			=> "ADMIN_MESSAGE_SETTINGS",
											'string'		=> 'camp_del',
											'column_name'	=> 'campaigns'
											);
		
				$this->notification->new_mail($message_data,$user,$receiver,$type_details);
				
			}
			
			/**************Message Requirement******************/		
			
			
			$this->response( $success, 200);
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Error, please try again'
					);
			
			$this->response( $error, 200);
		}		
	}
	
	function delete_campaign($campaign_id)
	{
			
		$account_type			=	$this->user_authentication->account_type;
		
		$account_id 			=	$this->user_authentication->account_id;
		
		$network_id				=	$this->do_message->fetch_admin_network_id();
		
		$message  = $this->default_configurations->get('message_type');		
	
		if($account_type=='TRAFFICKER')
			{
				$affiliate_id	=	$this->user_authentication->affiliate_id;
				$user = $this->do_message->get_affiliate($affiliate_id); 
			
			}
			else{
				$user = $this->do_message->get_profile($account_id); 
			}
		
		
		if($account_type=='MANAGER' || $account_type=='ADMIN' )
		{
			$acc_type='ADVERTISER';
			$reciever= $this->do_campaign->fetch_reciever($campaign_id);
		}
		else{
			$acc_type='ADMIN';
			$agency_id	=	$this->user_authentication->agency_id;
			$check= $this->do_message->fetch_receiever_det($agency_id);
			$reciever= $check[0];
			
			}
			/* Activity Log for delete campaign - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(CAMPAIGNS,CAMP_DEL);
					if($enable=='1')
					{				
						$this->cam_activity_log(CAMPAIGN,DELETE,$campaign_id);
					}
			/* Activity Log for delete campaign - End*/

			$campaign_det 	= 	$this->do_campaign->fetch_campaign_details($campaign_id);
			
		$campaign_det 	= 	$this->do_campaign->fetch_campaign_details($campaign_id);
				
		$message_data		=	array(
									'sender_id'		=>	$account_id,
									'receiver_id'	=>	$reciever['account_id'],
									'subject'		=>	'Campaign Deleted',
									'content'		=>	'The campaign <b>'.$campaign_det[0]['campaignname'].'</b> has been deleted',
									'image_name'	=>	NULL,
									'file_name'		=>	NULL,
									'account_type'	=>	$acc_type,
									'status'		=>	'1',
									'network_id'	=>	$network_id,									
									'date'			=>	date('Y-m-d H:i:s')
									);

		
		$campaign_balance	=	$this->do_payments->get_camp_bal($campaign_id);
		$wallet		=	$this->do_payments->get_wallet_bal_client($campaign_balance['clientid']);
		 
		$new_balance=$wallet+$campaign_balance['remain_amount']; 
		$clientids=$campaign_balance['clientid'];
		$campaign_balance	=	$this->do_payments->add_amt_deleted_camp($new_balance,$clientids);
		
		$campaign_details = $this->do_campaign->delete_campaign($campaign_id,$message_data,$user,$reciever,$message);
		
		$success 	= 	array(	'response'=> 'ok',
								'msg'		=> 'Campaign has been deleted'
							);
		
		return $success;		
	}
	 /*
	 * 
	 * name: run_get
	 * @param :
	 * @return : $campaign_id
	 * 
	 * Run the given campaign_id id
	 */
	
	function run_get()
	{
		$run_campaign_id = $this->get('run_campaign_id');

		/********************* Message *******************/
		$account_id 	=	$this->user_authentication->account_id;
		
		$client_id 		=	$this->user_authentication->client_id;
	
		$account_type	=	$this->user_authentication->account_type;	
		$network_id	=	$this->user_authentication->network_account_id;					
		$agency_id	=	$this->user_authentication->agency_id;
		$result		=	$this->do_networks->agency_owner_details($agency_id);
		$admin_name    	= 	$result['name'];			
		$admin_email	= 	$result['email'];	
		$admin_id   	= 	$result['account_id'];
		/********************* Message *******************/
			
		if($run_campaign_id)
		{
			$camp_id	=	explode(',',$run_campaign_id);
			
			if(is_array($camp_id))
			{
				foreach($camp_id as $campaign_id)
				{	
					$campaign_det = $this->do_campaign->fetch_campaign_details($campaign_id);
					$campaignname .= $campaign_det[0]['campaignname'].',';
					$success=	$this->run_campaign($campaign_id,$campaign_det[0]['dj_is_approved']);
					
					$receiver		= 	$this->do_campaign->fetch_reciever($campaign_id);
					
					$publist	=	$this->do_campaign->fetch_camp_publishers($campaign_id);
								
					if(!empty($publist))
					{
						foreach($publist as $pub):						
							$notify[$pub['account_id']]	=	$this->do_publisher->fetch_notification($pub['account_id']);
							$publisher 	= 	$this->do_publisher->get_profile($pub['account_id']);
							$msg_data	=	array(
												'sender_id'		=>	$receiver['account_id'],
												'receiver_id'	=>	$pub['account_id'],
												'subject'		=>	'Newsletter - Campaign Activated',
												'content'		=>	'The campaign <b>'.$campaign_det[0]['campaignname'].'</b> has been activated, So the ads will get deliver from this campaign.',
												'image_name'	=>	NULL,
												'file_name'		=>	NULL,
												'account_type'	=>	'TRAFFICKER',
												'status'		=>	'1',
												'network_id'	=>	$network_id,									
												'date'			=>	date('Y-m-d H:i:s')												
												);
												
							if(!empty($notify[$pub['account_id']])):
								if($notify[$pub['account_id']][0]['campaign_news_enable']==1):
									$camids	=	($notify[$pub['account_id']][0]['campaign_id'])?explode($notify[$pub['account_id']][0]['campaign_id']):'';
									if($camids != '' && in_array($campaign_id,$camids))
										$this->notification->pub_mail($msg_data,$receiver,$publisher);
									else if($camids==''):
										if(($notify[$pub['account_id']][0]['campaign_news_type']=='member' && $campaign_det[0]['dj_favourite_status']==0) || ($notify[$pub['account_id']][0]['campaign_news_type']=='favorite' && $campaign_det[0]['dj_favourite_status']==1) || ($notify[$pub['account_id']][0]['campaign_news_type']=='both')):
											$this->notification->pub_mail($msg_data,$receiver,$publisher);
										endif;
									endif;
								endif;							
							endif;
						endforeach;
					}
				
				}
			}
			else
			{
				$campaign_det = $this->do_campaign->fetch_campaign_details($camp_id);
				$campaignname .= $campaign_det[0]['campaignname'].',';	
				$success	=	$this->run_campaign($camp_id,$campaign_det[0]['dj_is_approved']);
				
				$receiver	= 	$this->do_campaign->fetch_reciever($camp_id);
				$publist	=	$this->do_campaign->fetch_camp_publishers($camp_id);
								
				if(!empty($publist))
				{
					foreach($publist as $pub):						
						$notify[$pub['account_id']]	=	$this->do_publisher->fetch_notification($pub['account_id']);
						$publisher 	= 	$this->do_publisher->get_profile($pub['account_id']);
						$msg_data	=	array(
											'sender_id'		=>	$receiver['account_id'],
											'receiver_id'	=>	$pub['account_id'],
											'subject'		=>	'Campaign Activated',
											'content'		=>	'The campaign <b>'.$campaign_det[0]['campaignname'].'</b>  has been activated.',
											'image_name'	=>	NULL,
											'file_name'		=>	NULL,
											'account_type'	=>	'TRAFFICKER',
											'status'		=>	'1',
											'network_id'	=>	$network_id,									
											'date'			=>	date('Y-m-d H:i:s')												
											);
											
						if(!empty($notify[$pub['account_id']])):
							if($notify[$pub['account_id']][0]['campaign_news_enable']==1):
								$camids	=	($notify[$pub['account_id']][0]['campaign_id'])?explode($notify[$pub['account_id']][0]['campaign_id']):'';
								if($camids != '' && in_array($camp_id,$camids))
									$this->notification->pub_mail($msg_data,$receiver,$publisher);
								else if($camids==''):
									if(($notify[$pub['account_id']][0]['campaign_news_type']=='member' && $campaign_det[0]['dj_favourite_status']==0) || ($notify[$pub['account_id']][0]['campaign_news_type']=='favorite' && $campaign_det[0]['dj_favourite_status']==1) || ($notify[$pub['account_id']][0]['campaign_news_type']=='both')):
										$this->notification->pub_mail($msg_data,$receiver,$publisher);
									endif;
								endif;
							endif;							
						endif;
					endforeach;
				}
			
			}
			
		
			/**************Message Requirement******************/
			
		
			if($account_type=='ADVERTISER')
			{
				$msg_type  	= 	$this->default_configurations->get('message_type');		
		
				$user 		= 	$this->do_message->get_profile($admin_id); 
			
				$message_data		=	array(
												'sender_id'		=>	$admin_id,
												'receiver_id'	=>	$receiver['account_id'],
												'subject'		=>	'Campaign Activated',
												'content'		=>	'Congrats! The campaigns  <b>'.$campaignname.'</b>  has  been activated successfully.',
												'image_name'	=>	NULL,
												'file_name'		=>	NULL,
												'account_type'	=>	$account_type,
												'status'		=>	'1',
												'network_id'	=>	$network_id,									
												'date'			=>	date('Y-m-d H:i:s')
												);	
				
				$type_details		=	array(
												'msg_type'		=> $msg_type,
												'type'			=> "ADMIN_MESSAGE_SETTINGS",
												'string'		=> 'camp_act',
												'column_name'	=> 'campaigns'
												);
			
				if($success['campaign_status']=='activate')
				{
					$this->notification->new_mail($message_data,$user,$receiver,$type_details);
				}
			}
			
			/**************Message Requirement******************/
			
			$this->response( $success, 200);
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Error, please try again'
					);
			
			$this->response( $error, 200);
		}
	}
	
	function run_campaign($campaign_id,$approve=false)
	{
		//check house ad campaign
		if($this->get('hs') ==1)
		{
			$campaign_data = $this->do_campaign->fetch_houseads_campaign($campaign_id);
		}else
		{
			$campaign_data = $this->do_campaign->fetch_campaign($campaign_id);
		}	
		
		$client_id=$campaign_data[0]['clientid'];
		$activate_time=$campaign_data[0]['activate_time'];
		$expire_time=$campaign_data[0]['expire_time'];
		$campaign_budget=$campaign_data[0]['dj_campaign_budget'];

		$status=$this->validate_campaign_status($client_id,$activate_time,$expire_time,$campaign_budget,'run',$approve,$campaign_id);
				
		$update_data=array("status"=>$status);
	
		$campaign_details = $this->do_campaign->camapign_status($campaign_id,$update_data);
	
			/* Activity Log for RUN campaign - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(CAMPAIGNS,CAMP_ACT);
					if($enable=='1')
					{				
						$this->cam_activity_log(CAMPAIGN,RUN,$campaign_id);
					}
			/* Activity Log for RUN campaign - End*/
		if($status ==1)
		{
			$success = array('response'	=> 'info',
							 'msg'		=> 'Sorry You have reached your daily budget.'
							 );
		}else if($status ==2){
			$success = array('response'	=> 'info',
							 'msg'		=> 'It will be in Awaiting status, will run on '.date('dS M, Y',strtotime($activate_time)).''
							 );	
		}
		else if($status ==3)
		{
			$success = array('response'	=> 'info',
							 'msg'		=> 'Sorry Your campaign budget has been completed'
							 );
		}		
		else if($status ==5)
		{
			$success = array('response'	=> 'info',
							 'msg'		=> 'Sorry Your Account Balance is Too low to run this campaign'
							 );
		}
		else if($status ==6)
		{
			$success = array('response'	=> 'info',
							 'msg'		=> 'Sorry your campign has not been approved by admin.'
							 );
		}
		else if($status ==8)
		{
			$success = array('response'	=> 'info',
							 'msg'		=> 'Sorry your campign daily budget reached'
							 );
		}
		else{	
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Campaign has been activated successfully',
							 'campaign_status'	=> 'activate'
							 );
		}
		
		return $success;
	}
	
	 /*
	 * 
	 * name: pause_get
	 * @param :
	 * @return : $campaign_id
	 * 
	 * Delete the given campaign_id 
	 */
	
	function pause_get()
	{
		$pause_campaign_id = $this->get('pause_campaign_id');
		/***************** Messages **************************/
		$account_id 	=	$this->user_authentication->account_id;
		
		$client_id 		=	$this->user_authentication->client_id;
	
		$account_type	=	$this->user_authentication->account_type;	
		$network_id		=	$this->user_authentication->network_account_id;					
		$agency_id		=	$this->user_authentication->agency_id;
		$result			=	$this->do_networks->agency_owner_details($agency_id);
		$admin_name    	= 	$result['name'];			
		$admin_email	= 	$result['email'];	
		$admin_id   	= 	$result['account_id'];		
		
		/***************** Messages **************************/
		
		if($pause_campaign_id)
		{
			$camp_id	=	explode(',',$pause_campaign_id);
			
			if(is_array($camp_id))
			{
				foreach($camp_id as $campaign_id)
				{	
					$campaign_det 	= 	$this->do_campaign->fetch_campaign_details($campaign_id);
					$campaignname .= $campaign_det[0]['campaignname'].',';			
					$success=	$this->pause_campaign($campaign_id,$campaign_det[0]['dj_is_approved']);
					
					$receiver		= 	$this->do_campaign->fetch_reciever($campaign_id);
					
					$publist	=	$this->do_campaign->fetch_camp_publishers($campaign_id);
					
					if(!empty($publist))
					{
						foreach($publist as $pub):						
							$notify[$pub['account_id']]	=	$this->do_publisher->fetch_notification($pub['account_id']);
							$publisher 	= 	$this->do_publisher->get_profile($pub['account_id']);
							$msg_data	=	array(
												'sender_id'		=>	$receiver['account_id'],
												'receiver_id'	=>	$pub['account_id'],
												'subject'		=>	'Newsletter - Campaign Stopped',
												'content'		=>	'The campaign <b>'.$campaign_det[0]['campaignname'].'</b> has been stopped, So the ads will not get deliver from this campaign.',
												'image_name'	=>	NULL,
												'file_name'		=>	NULL,
												'account_type'	=>	'TRAFFICKER',
												'status'		=>	'1',
												'network_id'	=>	$network_id,									
												'date'			=>	date('Y-m-d H:i:s')												
												);
												
							if(!empty($notify[$pub['account_id']])):
								if($notify[$pub['account_id']][0]['campaign_news_enable']==1):
									$camids	=	($notify[$pub['account_id']][0]['campaign_id'])?explode($notify[$pub['account_id']][0]['campaign_id']):'';
									if($camids != '' && in_array($campaign_id,$camids))
										$this->notification->pub_mail($msg_data,$receiver,$publisher);
									else if($camids==''):
										if(($notify[$pub['account_id']][0]['campaign_news_type']=='member' && $campaign_det[0]['dj_favourite_status']==0) || ($notify[$pub['account_id']][0]['campaign_news_type']=='favorite' && $campaign_det[0]['dj_favourite_status']==1) || ($notify[$pub['account_id']][0]['campaign_news_type']=='both')):
											$this->notification->pub_mail($msg_data,$receiver,$publisher);
										endif;
									endif;
								endif;							
							endif;
						endforeach;
					}
				
				}
			}
			else
			{
				$campaign_det = $this->do_campaign->fetch_campaign_details($camp_id);
				$campaignname .= $campaign_det[0]['campaignname'].',';
				$success	=	$this->pause_campaign($camp_id,$campaign_det[0]['dj_is_approved']);
				
				$receiver		= 	$this->do_campaign->fetch_reciever($camp_id);
				$publist	=	$this->do_campaign->fetch_camp_publishers($camp_id);
								
				if(!empty($publist))
				{
					foreach($publist as $pub):						
						$notify[$pub['account_id']]	=	$this->do_publisher->fetch_notification($pub['account_id']);
						$publisher 	= 	$this->do_publisher->get_profile($pub['account_id']);
						$msg_data	=	array(
											'sender_id'		=>	$receiver['account_id'],
											'receiver_id'	=>	$pub['account_id'],
											'subject'		=>	'Campaign Stopped',
											'content'		=>	'The campaign <b>'.$campaign_det[0]['campaignname'].'</b>  has been stopped.',
											'image_name'	=>	NULL,
											'file_name'		=>	NULL,
											'account_type'	=>	'TRAFFICKER',
											'status'		=>	'1',
											'network_id'	=>	$network_id,									
											'date'			=>	date('Y-m-d H:i:s')												
											);
											
						if(!empty($notify[$pub['account_id']])):
							if($notify[$pub['account_id']][0]['campaign_news_enable']==1):
								$camids	=	($notify[$pub['account_id']][0]['campaign_id'])?explode($notify[$pub['account_id']][0]['campaign_id']):'';
								if($camids != '' && in_array($camp_id,$camids))
									$this->notification->pub_mail($msg_data,$receiver,$publisher);
								else if($camids==''):
									if(($notify[$pub['account_id']][0]['campaign_news_type']=='member' && $campaign_det[0]['dj_favourite_status']==0) || ($notify[$pub['account_id']][0]['campaign_news_type']=='favorite' && $campaign_det[0]['dj_favourite_status']==1) || ($notify[$pub['account_id']][0]['campaign_news_type']=='both')):
										$this->notification->pub_mail($msg_data,$receiver,$publisher);
									endif;
								endif;
							endif;							
						endif;
					endforeach;
				}
			
			}
			
			
			/**************Message Requirement******************/
			
			if($account_type=='ADVERTISER')
			{
				$msg_type  	= 	$this->default_configurations->get('message_type');		
		
				$user 		= 	$this->do_message->get_profile($admin_id); 
											
				$message_data		=	array(
												'sender_id'		=>	$admin_id,
												'receiver_id'	=>	$receiver['account_id'],
												'subject'		=>	'Campaign Deactivated',
												'content'		=>	'Congrats! The campaigns  <b>'.$campaignname.'</b> has been deactivated successfully.',
												'image_name'	=>	NULL,
												'file_name'		=>	NULL,
												'account_type'	=>	$account_type,
												'status'		=>	'1',
												'network_id'	=>	$network_id,									
												'date'			=>	date('Y-m-d H:i:s')
												);	
				
				$type_details		=	array(
											'msg_type'		=> $msg_type,
											'type'			=> "ADMIN_MESSAGE_SETTINGS",
											'string'		=> 'camp_deact',
											'column_name'	=> 'campaigns'
											);
			
							
				$this->notification->new_mail($message_data,$user,$receiver,$type_details);
		
			}
			
			/**************Message Requirement******************/
			
			$this->response( $success, 200);
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Error, please try again'
					);
			
			$this->response( $error, 200);
		}		
	}
	
	
	 /*
	 * 
	 * name: move_get   
	 * @param :
	 * @return : $campaign_id
	 * 
	 * The given campaign_id 
	 */
	
	function move_get()
	{
			$move_campaign_id = $this->get('move_campaign_id');
			
			$select_group_name=$this->get('select_group_name');
			
			
		if($move_campaign_id)
		{	
			
			$success=$this->do_campaign->move_campaign($move_campaign_id,$select_group_name);
			
			/* Activity Log for move campaign - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(CAMPAIGNS,CAMP_MOVED);
					if($enable=='1')
					{				
						$this->cam_activity_log(CAMPAIGN,MOVE,$move_campaign_id);
					}
			/* Activity Log for move campaign - End*/
			 
			
			if($success=="1")
			{
				$success_message="Campaign has been linked with this group and updated ";
			}
			else if($success=="2")
			{
				$success_message="Campaign has been already linked with this group";
			}
			else if($success=="3")
			{
				$success_message="Campaign has been successfully Moved to group";
			}		
			
			$success 	= 	array('response'	=> 'ok','msg'=> $success_message );
		
			$this->response( $success, 200);
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Error, please try again'
					);
			
			$this->response( $error, 200);
		}		
	}
	
	
	function duplicate_get()
	{
		$duplicate_campaign_id = $this->get('duplicate_campaign_id');
		
		if($duplicate_campaign_id)
		{			
			$success=$this->do_campaign->duplicate_campaign($duplicate_campaign_id);
			/* Activity Log for duplicate campaign - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(CAMPAIGNS,CAMP_DUP);
					if($enable=='1')
					{				
						$this->cam_activity_log(CAMPAIGN,DUPLICATE,$duplicate_campaign_id);
					}
			/* Activity Log for duplicate campaign - End*/
			$success 	= 	array('response'	=> 'ok',
							      'msg'		    => 'Campaign has been duplicated successfully'
						 );					
			$this->response( $success, 200);
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Error, please try again'
					);
			
			$this->response( $error, 200);
		}	
	}
	
	
	function pause_campaign($campaign_id,$approve=false)
	{		
		
		$update_data	=	array("status"=>'1');

		$campaign_details = $this->do_campaign->camapign_status($campaign_id,$update_data);
		/* Activity Log for PAUSE campaign - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(CAMPAIGNS,CAMP_DEACT);
					if($enable=='1')
					{				
						$this->cam_activity_log(CAMPAIGN,PAUSE,$campaign_id);
					}
			/* Activity Log for PAUSE campaign - End*/
	
		$success 	= 	array('response'	=> 'ok',
							'msg'		=> 'Campaign has been successfully stopped!'
						 );
		
		return $success;
	}
	
		
	/*
	 * name: complete_campaign_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will update the campaign wizard status when all the campaign is set up is completed
	 * 
	 */
	public function complete_campaign_post()
	{
		$campaign_id = clean_data($this->post('_campaign_id'));
		
		if(!empty($campaign_id))
		{
			$campaign_status_data	=	array('dj_wizard_status'=>clean_data('1'));
			
			$campaign_completed = $this->do_campaign->complete_campaign($campaign_id,$campaign_status_data);
			if($campaign_completed)
			{
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Campaign sucessfully added',
									'redirect'	 => site_url('advertiser/campaigns'),
									);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => 'Error. Please try again',
								'redirect'	 => site_url('advertiser/campaigns'),
								);	
				$this->response( $error, 200);
			}
		}
		else
		{
			$error = array(
								'response' => 'error',
								'msg'	 => 'Error. Please try again',
								'redirect'	 => site_url('advertiser/campaigns'),
								);	
			$this->response( $error, 200);
			
		}
	}
	
		
	public function checkout_campaign_post()
	{		
		$campaign_name=clean_data($this->post('_camp_name'));		
		
		$this->form_validation->set_rules('company_name','Company Name', 'required|trim');
		$this->form_validation->set_rules('email', 'Email', 'required|trim');
		$this->form_validation->set_rules('city','City', 'required|trim');
		$this->form_validation->set_rules('state', 'State', 'required|trim');
		$this->form_validation->set_rules('country','Country', 'required|trim');
		$this->form_validation->set_rules('mobile_no', 'Mobile Number', 'required|trim');
		$this->form_validation->set_rules('payment_mode', 'payment Mode', 'required|trim');
		
		if($this->form_validation->run() === FALSE)
		{			
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{	
			$update_data	=	array(	'dj_company_name' 	=> clean_data($this->post('company_name')),
										'dj_email_address' 	=> clean_data($this->post('email')),
										'dj_company_address'=> clean_data($this->post('company_address')),
										'dj_company_city' 	=> clean_data($this->post('city')),
										'dj_company_state' 	=> clean_data($this->post('state')),
										'dj_company_country'=> clean_data($this->post('country')),
										'dj_mobile_number' 	=> clean_data($this->post('mobile_no'))
									);
										
			$campaign_id 	= 	clean_data($this->post('_campaign_id'));
			
			
			$campaign_update = $this->do_campaign->complete_campaign($campaign_id,$update_data);
		
			if($campaign_update)
			{
				$payment_mode = clean_data($this->post('payment_mode'));
				if($payment_mode!='')
				{
					$amount = clean_data($this->post('_camp_budget'));
								
					if($payment_mode=="2")
					{
						$site_url = site_url('site/paypal/add_payment/'.$campaign_id.'/'.$amount.'/'.$campaign_name.'/new');
					}
					else if($payment_mode=="5")
					{
						$site_url = site_url('site/authorize/add_payment/'.$campaign_id.'/'.$amount.'/'.$campaign_name.'/'.urlencode(clean_data($this->post('email'))).'/new');
					}
					else if($payment_mode=="4")
					{
						$site_url = site_url('site/bitpay/add_payment/'.$campaign_id.'/'.$amount.'/'.$campaign_name.'/'.urlencode(clean_data($this->post('email'))).'/new');
					}
					
					$success = array(
								'response' 	=> 	'ok',
								'redirect'	=>	$site_url,
								'msg'	 	=> 	'Payment Process',
							);
					$this->response($success, 200);
				}
				else
				{
					$success = array(
									'response' => 'error',
									'msg'	 => 'Updated!',
									'redirect'	 => site_url('site/campaigns'),
									);	
					$this->response( $success, 200);
				}
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => 'Error. Please try again',
								'redirect'	 => site_url(),
								);	
				$this->response( $error, 200);
			}
		}
	}	
		
	/*
	 * name: fetch_linked_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the creatives linked to given campaign id
	 * 
	 */
	public function fetch_linked_creative_get()
	{
		 $campaign_id = $this->get('campaign_id');
		
		if(!empty($campaign_id))
		{
			$existing_creative = $this->do_campaign->fetch_linked_creative($campaign_id);
			//$this->response( $this->db->last_query(), 200);
			if($existing_creative)
			{
				$this->response( $existing_creative, 200);
			}
		}
		else
		{
			$error = array(
								'response' => 'error',
								'msg'	 => 'Error. Please try again',
								'redirect'	 => site_url('advertiser/campaigns'),
								);	
			$this->response( $error, 200);
			
		}
	}
	
	
	
	public function fetch_linking_zone_get()
	{
		$banner_id = $this->get('bannerid');
		
		if(!empty($banner_id))
		{
			$existing_zone = $this->do_campaign->fetch_linked_zone($banner_id);
			if($existing_zone)
			{
				$this->response( $existing_zone, 200);
			}
		}
		else
		{
			$error = array(
								'response' => 'error',
								'msg'	 => 'Error. Please try again',
								'redirect'	 => site_url('publisher/campaigns'),
								);	
			$this->response( $error, 200);
			
		}
	}		
	
	/*
	 * name: validate_campaign_status
	 * @param
	 * @return:response array
	 * 
	 * In this method will link a creative to campaign
	 * 
	 */
	public function validate_campaign_status($client_id=false, $activate_time=false,$expire_time=false,$campaign_budget=false,$action=false,$approve=false,$campaign_id=false)
	{	
		if(!empty($client_id) AND !empty($activate_time) ) //  AND !empty($campaign_budget)
		{		
			//Check list for default advertiser
			
			$is_default_advertiser  	= 	$this->do_advertiser->is_default_advertiser($client_id);
			$current_date=date('Y-m-d H:i:s');

			if($is_default_advertiser==FALSE AND !empty($campaign_budget))
			{
				$payment_type  	= 	$this->do_advertiser->payment_type($client_id);
						
				if($payment_type['dj_payment_type']=='1')
					$payment_type="PREPAID";
				else
					$payment_type="POSTPAID";

				switch($payment_type)
				{
					case "PREPAID":
						$advertiser_balance  	= 	$this->do_advertiser->current_balance($client_id);
						$account_balance=$advertiser_balance['dj_cur_balance'];
						
						$budget_status 	= 	$this->do_advertiser->budget_status($campaign_id);						
						$daily_budget_status=$budget_status['dj_budget_status'];
																																										
						if($account_balance<=0 || ($account_balance>0 && $account_balance<$campaign_budget))
						$status='5';//Low balance =>Campaign Draft  
						else if(!empty($campaign_id) && $daily_budget_status=='1')
							{								
								$status=8;								
							}
						else 
						{   																										
							if($action=='add')
							{
								$status	=	'6';
							}
							else
							{
								if($approve!=false && $approve==1)
								{
									$status	=	'6';
								}
								else
								{
									//Has enough balance , go through.
									if($expire_time==NULL)//Don't expire
									{
										$flag_1=strtotime($activate_time);
										$flag_2=strtotime($current_date);
										if($flag_1 <= $flag_2)
											//Date is in the past =>Campaign Running
											 $status='0';
										else
											 //Date is in the future =>Campaign awaiting
											 $status='2';
									}
									else
									{
										//If end date available
										$flag_1=strtotime($activate_time);
										$flag_2=strtotime($current_date);
										if($flag_1 <= $flag_2)
										{
											$flag_3=strtotime($expire_time);
											$flag_4=strtotime($current_date);
											$current_dates=date('Y-m-d 00:00:00');
											$flag_5=strtotime($current_dates);
											if($flag_3 < $flag_5)
												//Date is in the past =>Campaign completed
												$status='3';
											else
												//Date is in the future =>Campaign running
												$status='0';
										}
										else
											//Date is in the future =>Campaign awaiting
											$status='2';
									}
								}
							}
							
						}
					break;
					
					case "POSTPAID":
						
						if($action=='add')
						{
							$status='6';
						}
						else
						{
							//He is apost paid user
							if($expire_time==NULL)//Don't expire
							{
								$flag_1=strtotime($activate_time);
								$flag_2=strtotime($current_date);
								if($flag_1 <= $flag_2)
									 //Date is in the past =>Campaign running
									 $status='0';
								else
									  //Date is in the future =>Campaign awaiting
									 $status='2';
							}
							else
							{
								//If end date available
								$flag_1=strtotime($activate_time);
								$flag_2=strtotime($current_date);
								if($flag_1 <= $flag_2)
								{
									$flag_3=strtotime($expire_time);
									$flag_4=strtotime($current_date);
									$current_dates=date('Y-m-d 00:00:00');
									$flag_5=strtotime($current_dates);
									if($flag_3 < $flag_5)
										//Date is in the past =>Campaign completed
										$status='3';
									else
										//Date is in the future =>Campaign running
										$status='0';
								}
								else
									//Date is in the future =>Campaign awaiting
									$status='2';
							}
						}
					
					break;
				}
				return $status;
			}
			else if($is_default_advertiser)
			{
				//He is default advertiser
				if($expire_time==NULL)//Don't expire
				{
					$flag_1=strtotime($activate_time);
					$flag_2=strtotime($current_date);
					if($flag_1 <= $flag_2)
						 //Date is in the past =>Campaign running
						 $status='0';
					else
						  //Date is in the future =>Campaign awaiting
						 $status='2';
				}
				else
				{
					//If end date available
					$flag_1=strtotime($activate_time);
					$flag_2=strtotime($current_date);
					if($flag_1 <= $flag_2)
					{
						$flag_3=strtotime($expire_time);
						$flag_4=strtotime($current_date);
						$current_dates=date('Y-m-d 00:00:00');
						$flag_5=strtotime($current_dates);
						if($flag_3 < $flag_5)
							//Date is in the past =>Campaign completed
							$status='3';
						else
							//Date is in the future =>Campaign running
							$status='0';
					}
					else
						//Date is in the future =>Campaign awaiting
						$status='2';
				}
				return $status;
			}
		}
		else
			return false;
	}
	/*
	 * name: link_creative_post
	 * @param
	 * @return:response array
	 * 
	 * In this method will link a creative to campaign
	 * 
	 */
	public function link_creative_post()
	{
		$campaign_id=clean_data($this->post('_campaign_id'));
		$creative_id=clean_data($this->post('creative_id'));

		if(!empty($campaign_id)  AND !empty($creative_id))
		{
			$campaign_crative_link= $this->do_campaign->add_campaign_creative_assoc($campaign_id,$creative_id);

			if($campaign_crative_link)
			{
				$success = array(
							'response' => 'ok',
							'msg'	 => 'Creative linked sucessfully',
							'redirect'	 => site_url('advertiser/campaigns'),
							'campaign_id'	 => $campaign_id,
							);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => 'Error. Please try again',
								'redirect'	 => site_url('advertiser/campaigns'),
								);	
				$this->response( $error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Error. Please try again',
							'redirect'	 => site_url('advertiser/campaigns'),
							);	
			$this->response( $error, 200);
		}
	}
	/*
	 * name: fetch_tracker_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch campaign trackers
	 * 
	 */
	public function fetch_tracker_get()
	{
		$campaign_id=$this->get('campaign_id');
      	$s2s=$this->get('s2s');
		
		if(!empty($campaign_id))
		{
			$tracker= $this->do_campaign->fetch_campaign_tracker($campaign_id);
			
			if($tracker)
			{
				if($s2s=='1')
			    {
					//$tracker=$tracker[0]['trackerid'];
					$this->response( $tracker, 200);
			    }
			    else
			    {
					$tracker=$tracker[0]['trackerid'];
					$this->response( $tracker, 200);
			    }	
			}
			else
			{
				$this->response( 'error', 200);
			}
		}
		else
		{
			$this->response( 'error', 200);
		}
	}
	
	
	function fetch_get_trackercode_get()
	{
		$campaign_id=$this->get('campaignid');
		if(!empty($campaign_id))
		{
		$tracker_detail= $this->do_campaign->fetch_get_trackercode($campaign_id);
		}
		if($tracker_detail)
		{
			$this->response($tracker_detail,200);
		}
		else
		{
			$this->response('error',200);  
		}
		
	}
	
	/*
	 * name: fetch_sel_camp_targeting_get
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the associated targeting with this campaign
	 * 
	 */
	
	public function fetch_sel_camp_targeting_get()
	{
			
		
	}
	
	
	/*
	 * name: fetch_publisher_campaign_get 
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the associated campaign with this publisher.
	 * 
	 */
	
	public function fetch_publisher_campaign_get()
	{		
		$creative_list = $this->do_campaign->fetch_publisher_campaign();
		if($creative_list)
		{
			$this->response($creative_list, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No creatives'),404);
		}
	}
	
	/*
	 * 
	 * name: fetch_rotator_campaign_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists a particular campaign of an advertiser
	 */
	
	function fetch_rotator_campaign_get()
	{
		
		$campaign_id = $this->get('campaign_ids');
			//print_r($campaign_id);exit;
		if($campaign_id)
		{
			$campaign_data = $this->do_campaign->fetch_rotator_campaign($campaign_id);
			
			if($campaign_data)
			{
			  $this->response($campaign_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	/*
	 * 
	 * name: fetch_exist_banner_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists a particular campaign of an advertiser
	 */
	
	function fetch_exist_banner_get()
	{
		
		$campaign_id = $this->get('campaign_ids');
		$width = $this->get('width');
		$height = $this->get('height');
			//print_r($campaign_id);exit;
		if($campaign_id)
		{
			$campaign_data = $this->do_campaign->fetch_exist_banner($campaign_id,$width,$height);
			
			if($campaign_data)
			{
			  $this->response($campaign_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	
	/*
	 * 
	 * name: fetch_campaign_banner_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists a banners of selected campaign
	 */
	
	function fetch_campaign_banner_get()
	{		
		$campaign_id = $this->get('campaign_id');
			//print_r($campaign_id);exit;
		if($campaign_id)
		{
			$campaign_data = $this->do_campaign->fetch_campaign_banner($campaign_id);
					
			if($campaign_data)
			{
			  $this->response($campaign_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	
	function fetch_campaign_banner_display_get()
	{		
		$campaign_id = $this->get('campaign_id'); 
		$width=$this->get('width');
		$height=$this->get('height');	
		$lang=$this->get('lang');
			
		if($campaign_id)
		{
			if($width!='all' && $height!='all')
			{  
				$campaign_data = $this->do_campaign->fetch_campaign_banner_display($campaign_id,$width,$height,$lang);
			}
			else
			{		
				//$campaign_data = $this->do_campaign->fetch_campaign_banner($campaign_id);
				$campaign_data = $this->do_campaign->fetch_campaign_banner_display($campaign_id,$width,$height,$lang);
			}
			
			if($campaign_data)
			{
			  $this->response($campaign_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}

		
		
	}
	
	function fetch_banner_count_get()
	{
		$campaign_id = $this->get('campaign_id'); 
		$width=$this->get('width');
		$height=$this->get('height');
		$banner_data=$this->do_campaign->fetch_banner_count($campaign_id,$width,$height);
		if($banner_data)
		{
			$this->response($banner_data, 200);
		}
		else
		{
			$this->response(array('error'=>'No details'),404);
		}
		
	}
	
	
	/*
	 * 
	 * name: fetch_campaign_country_bidding_get
	 * @param :
	 * @return : $country_bidding_list
	 * 
	 * Lists of country bidding for selected campaign
	 */
	
	function fetch_campaign_country_bidding_get()
	{		
		$campaign_id = $this->get('campaign_id');
			
		if($campaign_id)
		{
			$campaign_data = $this->do_campaign->fetch_campaign_country_bidding($campaign_id);
			
			if($campaign_data)
			{
			  $this->response($campaign_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}
	
	/*
	 * 
	 * name: fetch_campaign_language_get
	 * @param :
	 * @return : $lang_list
	 * 
	 * Lists of languages for selected campaign
	 */
	
	function fetch_campaign_language_get()
	{		
			$lang_data = $this->do_campaign->fetch_campaign_language();
			
			if($lang_data)
			{
			  $this->response($lang_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		
	}	
	
	function fetch_group_get()
	{
		$campaign_id 	= 	$this->get('campaignid');
		
		$group_data=$this->do_campaign->fetch_group($campaign_id);
		
		if($group_data)
		{
			$this->response($group_data, 200); 
		}
		else
		{
			$this->response('', 200);
		}
		
	}
	
	function group_list_get()
	{
		$campaign_id 	= 	$this->get('campaign_id');
		
		$group_data=$this->do_campaign->fetch_group_list($campaign_id);
		
		if($group_data)
		{
			$this->response($group_data, 200); 
		}
		else
		{
			$this->response('', 200);
		}
		
	}
	
	/*
	 * 
	 * name: fetch_campaign_creative_size_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists creative size  of selected campaign
	 */
	
	function fetch_campaign_creative_size_get()
	{		
		$campaign_id = $this->get('campaign_id');
			//print_r($campaign_id);exit;
		if($campaign_id)
		{
			$campaign_data = $this->do_campaign->fetch_campaign_creative_size($campaign_id);
			
			if($campaign_data)
			{
			  $this->response($campaign_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		}
	}	  
	
	function fetch_adsize_list_get()
	{
		$campaignid=$this->get('campaignid');
		$width=$this->get('width');
		$height = $this->get('height');
		$lang=$this->get('lang');
		
		$ad_list=$this->do_campaign->display_fetch_adsize($campaignid,$width,$height,$lang);
		if($ad_list)
		{
			$this->response($ad_list,200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No details'),404);
		}
		
	}
	
	function fetch_display_banner_get()
	{
		$bannerid=$this->get('bannerid');
		$imageid=$this->get('imageid');
		$width=$this->get('width');
		$height=$this->get('height');
		$ad_list=$this->do_campaign->display_banner($bannerid,$imageid,$width,$height);
		if($ad_list)
		{
			$this->response($ad_list,200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No details'),404);
		}
		
	}
		
	/*
	 * name: add_favourite_campaigns_post
	 * @param
	 * @return:response array
	 * 
	 * In this method will add favourite campaign
	 * 
	 */
	public function add_favourite_campaigns_post()
	{
		$campaign_id=clean_data($this->post('campaignid'));
		$favourite_status=clean_data($this->post('favourite_status'));
		if($favourite_status == 0){$fav=1;}else{$fav=0;}
		$update_data	=	array('dj_favourite_status' => clean_data($fav)
		);
		if(!empty($campaign_id))
		{
			$campaign_fav= $this->do_campaign->add_campaign_favourite($campaign_id,$update_data);

			if($campaign_fav)
			{
				$success = array(
							'response' => 'ok',
							'msg'	 => 'Added favourite campaign sucessfully',
							'redirect'	 => site_url('publisher/campaigns'),
							'campaign_id'	 => $campaign_fav,
							);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => 'Error. Please try again',
								'redirect'	 => site_url('publisher/campaigns'),
								);	
				$this->response( $error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Error. Please try again',
							'redirect'	 => site_url('advertiser/campaigns'),
							);	
			$this->response( $error, 200);
		}
	}
	
	/*
	 * 
	 * name: fetch_campaign_fav
	 * @param : $fav
	 * @return : list_data
	 * 
	 * Converts the data into display format
	 */
	
	function fetch_campaign_fav_get()
	{
		$fav=$this->get('fav');
				
	
			$campaign_data = $this->do_campaign->fetch_campaign_fav($fav);
			//$this->response($this->db->last_query(),200);
			
			if($campaign_data)
			{
			  $this->response($campaign_data, 200); // 200 being the HTTP response code
			}
			else
			{
			  $this->response(array('error'=>'No details'),404);
			}
		
	}
	
	/*
	 * name: fetch_publisher_selected_campaign_get 
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch all the associated campaign with this publisher.
	 * 
	 */
	
	public function fetch_publisher_selected_campaign_get()
	{		 
		$zoneid=$this->get('zoneid');
		$campaign_id = $this->get('campaign_id');
		$creative_list = $this->do_campaign->fetch_publisher_selected_campaign($zoneid,$campaign_id);
		if($creative_list)
		{
			$this->response($creative_list, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No creatives'),404);
		}
	}
	
	/*
	 * name: fetch_adblock_size_get 
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch adblock size based on zoneid.
	 * 
	 */
	
	public function fetch_adblock_size_get()
	{		 
		$zone_id=$this->get('zone_id');
		$adblock = $this->do_campaign->fetch_adblock_size($zone_id);
		if($adblock)
		{
			$this->response($adblock, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No creatives'),404);
		}
	}
	
	/*
	 * name: fetch_zone_campaigns_post
	 * @param
	 * @return:response array
	 * 
	 * In this method will add favourite campaign
	 * 
	 */
	public function fetch_zone_campaigns_get()
	{
		$zone_id=$this->get('zoneid');	
		
		if(!empty($zone_id))
		{
			$campaign_zne= $this->do_campaign->fetch_zone_campaigns($zone_id);

			if($campaign_zne)
			{
				$success = array(
							'response' => 'ok',
							'msg'	 => 'Added favourite campaign sucessfully',
							'redirect'	 => site_url('publisher/campaigns'),
							'campaign_id'	 => $campaign_zne,
							);
				$this->response( $campaign_zne, 200);
			}
			else
			{
				$error = array(
								'response' => 'error',
								'msg'	 => 'Error. Please try again',
								'redirect'	 => site_url('publisher/campaigns'),
								);	
				//$this->response( $error, 200);
				$this->response(array('error'=>'No creatives'),404);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Error. Please try again',
							'redirect'	 => site_url('advertiser/campaigns'),
							);	
			//$this->response( $error, 200);
			$this->response(array('error'=>'No creatives'),404);
		}
	}
	
	/*
	 * name: fetch_zone_details_get 
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch adblock size based on zoneid.
	 * 
	 */
	
	public function fetch_zone_details_get()
	{		 
		$zone_id=$this->get('zoneid');
		$adblock = $this->do_campaign->fetch_zone_details($zone_id);
		if($adblock)
		{
			$this->response($adblock, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No creatives'),404);
		}
	}
	/*
	 * name: fetch_ban_type_get 
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch adblock size based on zoneid.
	 * 
	 */
	
	public function fetch_ban_type_get()
	{		 
		$zone_id=$this->get('zone_id');
	
		$adblock = $this->do_campaign->fetch_ban_type($zone_id);
		if($adblock)
		{
			$this->response($adblock, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No creatives'),404);
		}
	}
	function fetch_video_filename_get()
	{
		$bannerid=$this->get('bannerid');
		
		$ad_list=$this->do_campaign->fetch_video_filename($bannerid);
		if($ad_list)
		{
			$this->response($ad_list,200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No details'),404);
		}
		
	}
	function fetch_video_overlay_details_get()
	{
		$bannerid=$this->get('bannerid');
		
		$ad_list=$this->do_campaign->fetch_video_overlay_details($bannerid);
		if($ad_list)
		{
			$this->response($ad_list,200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No details'),404);
		}
		
	}
	/*
	 * name: fetch_admarket_advertiser_get 
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch adblock size based on zoneid.
	 * 
	 */
	
	public function fetch_admarket_advertiser_get()
	{		 
		
		$advertiser = $this->do_advertiser->fetch_admarket_advertiser();
		if($advertiser)
		{
			$this->response($advertiser, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No advertiser'),404);
		}
	}
	
	/*
	 * name: list_admarket_advertiser_wise_campaign 
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch adblock size based on zoneid.
	 * 
	 */
	
	public function list_admarket_advertiser_wise_campaign_post()
	{		 
		$account_id=clean_data($this->post('account_id'));
		$adv_camp = $this->do_campaign->fetch_admarket_advertiser_campaign($account_id);
		if($adv_camp)
		{
			$this->response($adv_camp, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No advertiser'),404);
		}
	}
	/*
	 * name: get_admarket_campaign_wise_creatives 
	 * @param
	 * @return:response array
	 * 
	 * In this method will fetch adblock size based on zoneid.
	 * 
	 */
	
	public function get_admarket_campaign_wise_creatives_post()
	{		 
		$campaignid=clean_data($this->post('campaignid'));
		$camp_creatives = $this->do_campaign->fetch_admarket_campaign_creatives($campaignid);
		if($camp_creatives)
		{
			$this->response($camp_creatives, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No advertiser'),404);
		}
	}
	
	/**
       * 
       * name : disallow_get()
       * 
       * disallow the advertiser from listing in admarket
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function disallow_get()
	{	
		$account_id = $this->get('disallow_account_id');	
		
		if($account_id)
		{
			$advertiser 	= 	$this->do_campaign->disallow($account_id);
			
			if($advertiser)
			{
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Advertiser has been disallowed successfully..'
										);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
									);
				$this->response( $error, 200);
			}
			
		}
		else
		{
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Advertiser does not found.'
								);
			$this->response( $error, 200);
		}
	}
	/**
       * 
       * name : allow_get()
       * 
       * allow the advertiser for publish in admarket
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function allow_get()
	{	
		$account_id = $this->get('allow_account_id');	
		
		if($account_id)
		{
			$advertiser 	= 	$this->do_campaign->allow($account_id);
			
			if($advertiser)
			{
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Advertiser has been allowed successfully..'
										);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
									);
				$this->response( $error, 200);
			}
			
		}
		else
		{
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Advertiser does not found.'
								);
			$this->response( $error, 200);
		}
	}
	/**
       * 
       * name : disallow_campaign_get()
       * 
       * disallow the campaign from listing in admarket
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function disallow_campaign_get()
	{	
		$campaign_id = $this->get('disallow_campaign_id');	
		
		if($campaign_id)
		{
			$campaign 	= 	$this->do_campaign->disallow_campaign($campaign_id);
			
			if($campaign)
			{
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Campaign has been disallowed successfully..'
										);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
									);
				$this->response( $error, 200);
			}
			
		}
		else
		{
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Campaign does not found.'
								);
			$this->response( $error, 200);
		}
	}
	/**
       * 
       * name : allow_campaign_get()
       * 
       * allow the campaign from listing in admarket
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function allow_campaign_get()
	{	
		$campaign_id = $this->get('allow_campaign_id');	
		
		if($campaign_id)
		{
			$campaign 	= 	$this->do_campaign->allow_campaign($campaign_id);
			
			if($campaign)
			{
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Campaign has been allowed successfully..'
										);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
									);
				$this->response( $error, 200);
			}
			
		}
		else
		{
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Campaign does not found.'
								);
			$this->response( $error, 200);
		}
	}
	/**
       * 
       * name : disallow_banner_get()
       * 
       * disallow the banner from listing in admarket
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function disallow_banner_get()
	{	
		$banner_id = $this->get('disallow_banner_id');	
		
		if($banner_id)
		{
			$banner 	= 	$this->do_campaign->disallow_banner($banner_id);
			
			if($banner)
			{
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Banner has been disallowed successfully..'
										);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
									);
				$this->response( $error, 200);
			}
			
		}
		else
		{
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Banner does not found.'
								);
			$this->response( $error, 200);
		}
	}
	/**
       * 
       * name : allow_banner_get()
       * 
       * allow the banner from listing in admarket
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function allow_banner_get()
	{	
		$banner_id = $this->get('allow_banner_id');	
		
		if($banner_id)
		{
			$banner 	= 	$this->do_campaign->allow_banner($banner_id);
			
			if($banner)
			{
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Banner has been allowed successfully..'
										);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
									);
				$this->response( $error, 200);
			}
			
		}
		else
		{
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Banner does not found.'
								);
			$this->response( $error, 200);
		}
	}
	
	//Traffic Sources
	
	/*
	* 
	* name: fetch_campaign_traffic_get
	* @param :
	* @return : $fetch_campaign_traffic_get
	* 
	* Lists a particular traffic of an campaign
	*/
	
	function fetch_campaign_traffic_get()
	{		
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}
		
		$campaign_id = $this->get('campaign_id');  
		
		$campaign_data = $this->do_campaign->get_campaign_traffic($campaign_id,$account_id);
		
		$this->response($campaign_data, 200); // 200 being the HTTP response code	
		
	}
	
	function fetch_publisher_traffic_get()
	{		
		$publisher_id = $this->get('publisher_id');
		
		if($publisher_id)
		{
			$publisher_data = $this->do_campaign->get_publisher_traffic($publisher_id);
			
			$this->response($publisher_data, 200); // 200 being the HTTP response code
			
		}
	}
	
	//Zone bidding
	
	/*
	* 
	* name: fetch_campaign_zone_bidding_get
	* @param :
	* @return : $fetch_campaign_zone_bidding_get
	* 
	* Lists a particular zone of an campaign
	*/
	
	function fetch_campaign_zone_bidding_get()
	{		
		$campaign_id = $this->get('campaign_id');
		
		if($this->user_authentication->account_type=='ADVERTISER')
		{
			$account_id = $this->user_authentication->account_id;
		}
			
		$campaign_data = $this->do_campaign->get_campaign_zone_bidding($campaign_id,$account_id);
		
		$this->response($campaign_data, 200); // 200 being the HTTP response code
			
		
	}
	
	
	
	/*
	* 
	* name: fetch_campaign_bidding_get
	* @param :
	* @return : $fetch_campaign_bidding_get
	* 
	* Lists a particular bidding of an campaign
	*/
	
	function fetch_campaign_bidding_get()
	{		
		$campaign_id = $this->get('campaign_id');
		
		if($campaign_id)
		{
			$campaign_data = $this->do_campaign->get_campaign_country_bidding($campaign_id);
			
			$this->response($campaign_data, 200); // 200 being the HTTP response code
			
		}
	}
	
	/*
	* 
	* name: fetch_targeting_list_get
	* @param :
	* @return : $campaign_target_data
	* 
	* Lists targeting details
	*/
	
	function fetch_targeting_list_get()
	{
		$campaign_id 	= 	$this->get('campaign_id');
		$type			=	$this->get('target_type');
		
		if($campaign_id)
		{
			$where	=	array('campaignid'	=>	$campaign_id,'type'	=>	$type);
			
			$campaign_target_data = $this->do_campaign->fetch_camapign_targeting($where);
			
			if($campaign_target_data)
			{
				$this->response($campaign_target_data, 200); // 200 being the HTTP response code
			}
			else
			{
				$this->response(array('error'=>'No details'),404);
			}
		}
	}
	
	/*
	* 
	* name: fetch_realtime_bidding_get
	* @param :
	* @return : $bid_data
	* 
	* Lists targeting details
	*/
	
	function fetch_realtime_bidding_get()
	{		
		$bid_data = $this->do_campaign->fetch_realtime_bidding($this->get());
		
		//$this->response($bid_data,200);
		
		if($bid_data)
		{
			$this->response($bid_data, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response('error', 200);
		}		
	}
	
	/*
	* 
	* name: fetch_realtime_bidding_get
	* @param :
	* @return : $bid_data
	* 
	* Lists targeting details
	*/
	
	function fetch_language_get()
	{		
		$lang_data = $this->do_campaign->fetch_language();
		
		if($lang_data)
		{
			$this->response($lang_data, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response('error', 200);
		}		
	}
	
	public function edit_checkout_campaign_post()
	{		
		$campaign_name=clean_data($this->post('_camp_name'));		
		
		$this->form_validation->set_rules('company_name','Company Name', 'required|trim');
		$this->form_validation->set_rules('email', 'Email', 'required|trim');
		$this->form_validation->set_rules('city','City', 'required|trim');
		$this->form_validation->set_rules('state', 'State', 'required|trim');
		$this->form_validation->set_rules('country','Country', 'required|trim');
		$this->form_validation->set_rules('mobile_no', 'Mobile Number', 'required|trim');
		
		if($this->form_validation->run() === FALSE)
		{			
			$error_msg = $this->form_validation->error_array();
			$error = array(
							'response' => 'error',
							'msg' =>  $error_msg
						  );
			$this->response( $error, 200);
		}
		else
		{	
			$update_data	=	array(	'dj_company_name' 	=> clean_data($this->post('company_name')),
										'dj_email_address' 	=> clean_data($this->post('email')),
										'dj_company_address'=> clean_data($this->post('company_address')),
										'dj_company_city' 	=> clean_data($this->post('city')),
										'dj_company_state' 	=> clean_data($this->post('state')),
										'dj_company_country'=> clean_data($this->post('country')),
										'dj_mobile_number' 	=> clean_data($this->post('mobile_no'))
									);
										
			$campaign_id 	= 	clean_data($this->post('_campaign_id'));
			
			
			$campaign_update = $this->do_campaign->complete_campaign($campaign_id,$update_data);
		
			if($campaign_update)
			{
				$success = array(
							'response' 	=> 	'ok',
							'redirect'	=>	site_url('site/campaigns'),
							'msg'	 	=> 	'Payment Process',
						);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Error. Please try again',
								'redirect'	=> 	site_url(),
								);	
				$this->response( $error, 200);
			}
		}
	}
	
	function valid_city_check()
	{
		if(clean_data($this->post('targ_city')))
		{
			//$cities	=	explode(',',trim($this->post('targ_city'),','));	
			$citi 	= 	implode(',',clean_data($this->post('targ_city')));	
			$cities	=	explode(",",$citi);
			$valid	=	array();
			
			foreach($cities as $city)
			{
				$where	=	array('city'	=>	ucfirst($city));
				$cit	=	$this->do_targeting->fetch_city_country($where);
				
				if($cit==FALSE)
				{
					$valid[]	=	$city;
				}
			}	
			
			if(!empty($valid))
			{
				$msg	=	(count($valid)>1)?implode(', ',$valid)." are not valid city name":implode(', ',$valid)." is not valid city name";
				$this->form_validation->set_message('valid_city_check', $msg);
				return FALSE;
			}
			else
			{
				return TRUE;
			}		
		}
		else
		{
			return TRUE;
		}
	}	
	
	/*
	 * 
	 * name: fetch_campaign_get
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists a particular campaign of an advertiser
	 */
	
	function fetch_camp_adv_details_get()
	{		
		$campaign_id = $this->get('campaign_id');
		
		if($campaign_id)
		{
			
			$adv_data = $this->do_campaign->fetch_camp_adv_details($campaign_id);
			
			if($adv_data)
			{
				$this->response($adv_data, 200); // 200 being the HTTP response code
			}
			else
			{
				$this->response('error',200);
			}
		}
	}
	
	function duplicate_multiple_post()
	{
		$account_id	=	$this->user_authentication->account_id;
		 
		$duplicate_campaign_id = $this->post('duplicate_campaign_id');
		 
		if($duplicate_campaign_id)
		{			
			$dupli_data	=	$this->do_campaign->duplicate_multiple_campaign($account_id,$this->post());
			
			if($dupli_data =='no_suff_amount')
			{
				$error 	= 	array('response'	=> 'error',
									  'msg'		    => 'Campaign is not duplicated due to insufficient amount'
							 );					
				$this->response( $error, 200);
			}
			elseif($dupli_data)
			{
				$success 	= 	array('response'	=> 'ok',
									  'msg'		    => 'Campaign has been duplicated successfully'
							 );					
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Campaign is not duplicated.'
					);
			
				$this->response( $error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Error, please try again'
					);
			
			$this->response( $error, 200);
		}	
	}
	
	/*
	* 
	* name: fetch_approve_campaigns
	* @param :
	* @return : $campaign_list
	* 
	* Lists a campaigns of an advertiser
	*/
	
	function fetch_approve_campaigns_get()
	{		
		$is_approve		=	$this->get('is_approve');
    	
		$campaign_details = $this->do_campaign->fetch_approval_campaigns($is_approve);
		
		if($campaign_details)
		{
			$this->response($campaign_details, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response(array('error'=>'No details found'),404);
		}
	}
	
	/*
	* 
	* name: approve_creative_get
	* @param :
	* @return : $success
    */
	public function approve_campaign_post()
	{
		$campaign_id = 	$this->post('campaign_id');
	    if($campaign_id)
		{
			$campaign_ids	=	explode(',',$campaign_id);
			if(is_array($campaign_ids))
			{
				foreach($campaign_ids as $campid)
				{
					$campupdate	=	$this->campaign_approve($campid);
				}
			}
			else
			{ 
				$campupdate	=	$this->campaign_approve($campaign_ids);
			}	
				$success = array('response'	=> 'ok',
								'msg'		=> 'Campaign has been Approved successfully'
								); 
				$this->response($success);
			//}
		}
	}
	
	/*
	* 
	* name: campaign_approve_get
	* @param :
	* @return : $success
    */
	public function campaign_approve($campaign_id)
	{	
		$agency_id	= 	$this->user_authentication->agency_id;	
		
		$campaign_data 	= 	$this->do_campaign->fetch_campaign($campaign_id);
		
		$client_id		=	$campaign_data[0]['clientid'];
		$activate_time	=	$campaign_data[0]['activate_time'];
		$expire_time	=	$campaign_data[0]['expire_time'];
		$campaign_budget=	$campaign_data[0]['dj_campaign_budget'];

		$status			=	$this->validate_campaign_status($client_id,$activate_time,$expire_time,$campaign_budget,'approve');
		
		$update_data	=	array("status"			=>	$status,
								  "dj_is_approved"	=>	0,
								  "updated"			=>	date('Y-m-d H:m:s')
								);
	
		//Approve campaign
		$camp_approve	=	$this->do_campaign->campaign_approve($campaign_id,$update_data);
		
		if($camp_approve)
		{
			/* Activity Log for approve campaign - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(CAMPAIGNS,CAMP_APP);
					if($enable=='1')
					{				
						$this->cam_activity_log(CAMPAIGN,APPROVE,$campaign_id);
					}
			/* Activity Log for approve campaign - End*/	
			
			$result			=	$this->do_networks->agency_owner_details($agency_id);
			$camp_details	=	$this->do_campaign->fetch_campaign_mail($campaign_id);
			
			//Get advertiser details
			$advertiser_details=$this->do_advertiser->get_profile($camp_details['account_id']);
			//$this->response($advertiser_details,200);
			$admin_name    	= 	$result['name'];			
			$admin_email   	= 	$result['email'];
			$account_id=$camp_details['account_id'];
			$user 			= $this->do_message->get_profile(ADMIN_ID);	
			$network_id	=	$this->do_message->fetch_admin_network_id();	
			$campaignid 		= $camp_details['campaignid']; 
			$cam_name 			= $camp_details['campaignname']; 
			$to_name 			= $camp_details['username']; 
			$dj_targetting_type = $camp_details['dj_targetting_type']; 
			$status				= $camp_details['status'] == 0 ? 'Active' : 'Inactive'; 
		
			$activate_time 		= isset($camp_details['activate_time']) ? $camp_details['activate_time'] : ' ' ; 
			
			$expire_time 		= isset($camp_details['expire_time']) ? ' To '.date("Y-m-d", strtotime($camp_details['expire_time'])) : ' '; 
					
			$to_email 			= $camp_details['email']; 
			$budget				= $camp_details['budget']; 
			$revenue_type		= $camp_details['formated_revenue_type'];  
			$user_id  			=  urlencode(base64_encode($campaignid));
			
			$acc_type	=	'ADMIN';
			$msg_type 	= 	$this->default_configurations->get('message_type');
			
			$type_details	=	array(
									'msg_type'		=> $msg_type,
									'type'			=> "CAMPAIGN_APPROVE",
									'string'		=> 'camp_app',
									'column_name'	=> 'campaigns'
									);
			
			$message_data	=	array(
									'sender_id'		=>	ADMIN_ID,
									'receiver_id'	=>	$account_id ,
									'subject'		=>	'Campaign Approved',
									'content'		=> 	'The Campaign <b>'.$cam_name.'</b> has been approved successfully',
									'image_name'	=>	NULL,
									'file_name'		=>	NULL,
									'account_type'	=>	"ADVERTISER",
									'status'		=>	'1',
									'network_id'	=>	$network_id,									
									'date'			=>	date('Y-m-d H:i:s')
									);
			$admin_name   	=	$user['first_name'].' '.$user['last_name'];	
			$admin_email   	=	$user['email'];
			$user_email    	=	$advertiser_details['email'];
			$user_name     	=	$advertiser_details['first_name'].' '.$advertiser_details['last_name'];
			$from 		   	= 	$admin_email;
			$to  		   	= 	$user_email;
						
			$mail_content	=	array(
											"subject" 		=> 	"Campaign Approved",
											"to_name" 		=> 	$to_name,
											"cam_name" 		=> 	$cam_name,
											"from_name"		=> 	$admin_name,
											"email"  		=> 	$to_email,
											"activate_time"	=>	$activate_time,
											"expire_time"	=>	$expire_time,
											"budget"		=>	$budget,
											"revenue_type"	=>	$revenue_type,
											"status"		=>	$status,
											"user_id"		=>	$user_id
									);
																
			$dat = $this->notification->new_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);									
					
	
			/*$success 	=	array('response'	=> 'ok',
								  'msg'			=> 'Campaign has been approved successfully',
								
						 ); 
			$this->response($success,200);*/
		}
		else
		{
			$error 		= 	array('response'	=> 'ok',
								  'msg'			=> 'Error! Please try again...'
						 ); 
			$this->response($error,200);
		}		
	}
	
	/*
	 * 
	 * name: fetch
	 * @param :
	 * @return : $creative_list
	 * 
	 * Lists all the campaign of an advertiser
	 */
	 	 
	function fetch_pub_campaigns_get()
	{ 
		if($this->user_authentication->account_type=='TRAFFICKER')
		{
			$account_id 	= 	$this->user_authentication->account_id;
		}
		else
		{
			$account_id 	= 	$this->get('account_id');
		}
					
		$camp_list 	= 	$this->do_campaign->fetch_pub_campaigns($account_id);
		
		$this->response($camp_list, 200);
	}
	
	
	function cam_activity_log($module,$process,$campaign_id)
	{
				/* Activity Log for Add/Edit/Delete site - Start	*/			
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:sa");							
				$account_id=$this->user_authentication->account_id;
				$advertiser_id =	$this->user_authentication->client_id;
				//$module=$module;
				//$process=$process;				
				//$campaign_id=$campaign_id;
				
				$activity_log=array(				
								"account_id"=>$account_id,
								"useragent"=>$user_agent,
								"browser"=>$browser,
								"os"=>$os,
								"ip"=>$ip,
								"date"=>$date,
								"module"=>$module,
								"process"=>$process,
								"advertiser_id"=>$advertiser_id,
								"campaign_id"=>$campaign_id,
								
								);				
																									
				$this->do_app_config->activity_log($account_id,$activity_log);
				/* Activity Log for Add/edit/Delete site - End*/			
		
	}
	/*
	* 
	* name: fetch_targeting_list_get
	* @param :
	* @return : $campaign_target_data
	* 
	* Lists targeting details
	*/
	
	function fetch_frequency_list_get()
	{
		$frequency_data = $this->do_campaign->fetch_frequency_data();
		
		if($frequency_data)
		{
			$this->response($frequency_data, 200); // 200 being the HTTP response code
		}
		else
		{
			$this->response('error', 200);
		}		
	}
	
	function fetch_realtime_bidding_value_get()
	{			
		$country_include_exclude=$this->get('country_include_exclude');
		$device_include_exclude=$this->get('device_include_exclude');
		$campaign_targeting_type=$this->get('campaign_targeting_type');
		$campaign_target_type1=$this->get('campaign_target_type1');
		$targ_include_device=$this->get('targ_include_device');
		$targ_exclude_device=$this->get('targ_exclude_device');
		$target_device=$this->get('target_device');
		$target_browser=$this->get('target_browser');
		$target_browser_lang=$this->get('target_browser_lang');
		$target_browser_version=$this->input->get('target_browser_version');
		$target_os=$this->get('target_os');
		$target_os_version=$this->get('target_os_version');
		$target_mobile_manufacture=$this->get('target_mobile_manufactures');
		$target_mobile_capability=$this->get('target_mobile_capability');
		$connection_type=$this->get('connection_type');
		$carrier=$this->get('carrier');
		$geo_include=$this->get('geo_include');
		$geo_exclude=$this->get('geo_exclude');
		$region=$this->get('region');
		$city=$this->get('city');
		$zip=$this->get('zip');
		$age=$this->get('age');
		$gender=$this->get('gender');
		$color=$this->get('color');
		$height=$this->get('height');
		$weight=$this->get('weight');
		$profile_keyword=$this->get('profile_keyword');
		$url_keyword=$this->get('url_keyword');
		$preset_black=$this->get('preset_black');
		$blacklist=$this->get('blacklist');
		$preset_white=$this->get('preset_white');
		$whitelist=$this->get('whitelist');
		$frequency_capping_imp=$this->get('frequency_capping_imp');
		$targ_hour=$this->get('targ_hour')*3600;
		
		$where=array(			
				'country_include_exclude'=>$country_include_exclude,
				'device_include_exclude'=>$device_include_exclude,
				'device'=>$target_device,
				'device_type'=>$campaign_targeting_type,
				'campaign_target_type1'=>$campaign_target_type1,
				'targ_include_device'=>$targ_include_device,
				'targ_exclude_device'=>$targ_exclude_device,
				'browser'=>$target_browser,
				'browser_lang'=>$target_browser_lang,
				'browser_version'=>$target_browser_version,
				'os'=>$target_os,
				'os_version'=>$target_os_version,
				'manufacturer'=>$target_mobile_manufacture,
				'capability'=>$target_mobile_capability,
				'connection_type'=>$connection_type,
				'carrier'=>$carrier,
				'geo_include'=>$geo_include,
				'geo_exclude'=>$geo_exclude,
				'region'=>$region,
				'city'=>$city,
				'zip'=>$zip,
				'age'=>$age,
				'gender'=>$gender,
				'color'=>$color,
				'height'=>$height,
				'weight'=>$weight,
				'profile_keyword'=>$profile_keyword,
				'url_keyword'=>$url_keyword,
				'preset_black'=>$preset_black,
				'blacklist'=>$blacklist,
				'preset_white'=>$preset_white,
		        'whitelist'=>$whitelist,
		        'frequency_capping_imp'=>$frequency_capping_imp,
		        'targ_hour'=>$targ_hour
		);
	//	print_r($where);exit;
		$realtime_data=$this->do_campaign->fetch_realtime_bidding_value($where);	
	//$this->response($this->db->last_query(), 200);	
		if($realtime_data)
		{			
		$load_data = 	array('response'	=> 'ok',
							  'min'	 => $realtime_data[0]['min_bid_rate'],
							  'best' => $realtime_data[0]['best_bid_rate'],
							  'max'  => $realtime_data[0]['max_bid_rate']							  
							); 
			
		$this->response($load_data, 200); // 200 being the HTTP response code
		}
		else
		{
		$this->response(array('error'=>'No details'),200);
		}
		
	}
	
	function fetch_load_campaign_detail_get()
	{		
		$campaign_id = $this->get('campaign_id');
		
		if($campaign_id)
		{			
			$campaign_data = $this->do_campaign->fetch_campaign($campaign_id);
			
			$tracker_data = $this->do_campaign->fetch_campaign_tracker($campaign_id);
			
			$group_data	 = 	$this->do_campaign->fetch_selected_group($campaign_id);
			
			$time_target_type="deliveryLimitations:Time:Hour";
			
			$time_where	=	array('campaignid'	=>	$campaign_id,'type'	=>	$time_target_type);
			
			$time_details = $this->do_campaign->fetch_camapign_targeting($time_where);			
			
			$day_target_type="deliveryLimitations:Time:Day";
			
			$day_where	=	array('campaignid'	=>	$campaign_id,'type'	=>	$day_target_type);
			
			$daypart_details   =  $this->do_campaign->fetch_camapign_targeting($day_where); 
								
			$device_details = $this->do_campaign->fetch_campaign_device_targeting($campaign_id);
			
			$include_country="Include:country";
			
			$include_where	=	array('campaignid'=>$campaign_id,'type'	=>$include_country);
			
			$include_details   =  $this->do_campaign->fetch_camapign_targeting($include_where); 
									
			$exclude_country="Exclude:country";
			
			$exclude_where	=	array('campaignid'=>$campaign_id,'type'	=>$exclude_country);
			
			$exclude_details   =  $this->do_campaign->fetch_camapign_targeting($exclude_where); 
			
			$city_where	=	array('campaignid'=>$campaign_id,'type'	=>"deliveryLimitations:Geo:City");
            
			$city_details =	$this->do_campaign->fetch_camapign_targeting($city_where); 
			
			$zip_where=array('campaignid'=>$campaign_id,'type'=>"deliveryLimitations:Geo:Zip");
			
			$zip_details =	$this->do_campaign->fetch_camapign_targeting($zip_where); 			
								
			$browser_where=array('campaignid'=>$campaign_id,'type'=>'deliveryLimitations:Client:Browser');
			
			$browser_details =	$this->do_campaign->fetch_camapign_targeting($browser_where); 
			
			$lang_where=array('campaignid'=>$campaign_id,'type'=>'deliveryLimitations:Client:Language');
			
			$lang_details	= 	$this->do_campaign->fetch_camapign_targeting($lang_where);
			
			$lang_version_where=array('campaignid'=>$campaign_id,'type'=>'deliveryLimitations:Client:BrowserVersion');
			
			$lang_version_details	= 	$this->do_campaign->fetch_camapign_targeting($lang_version_where);
			
			$os_where=array('campaignid'=>$campaign_id,'type'=>'deliveryLimitations:Client:Os');
			
			$os_details =	$this->do_campaign->fetch_camapign_targeting($os_where); 
			
			$os_vers_where=array('campaignid'=>$campaign_id,'type'=>'deliveryLimitations:Client:Os_version');
			
			$os_vers_details =	$this->do_campaign->fetch_camapign_targeting($os_vers_where); 
			
			$mobile_where = array('campaignid'=>$campaign_id,'type'=>'handset');
			
			$mobile_manu_details = $this->do_campaign->fetch_camapign_targeting($mobile_where);
			
			$cap_where=array('campaignid'=>$campaign_id,'type'=>'capability');
			
			$mobile_capa_details= 	$this->do_campaign->fetch_camapign_targeting($cap_where);
			
			$connect_where=array('campaignid'=>$campaign_id,'type'=>'connection');
			
			$connect_details	= 	$this->do_campaign->fetch_camapign_targeting($connect_where);
			
			$carrier_where=array('campaignid'=>$campaign_id,'type'=>'carrier');
			
			$carrier_details	= 	$this->do_campaign->fetch_camapign_targeting($carrier_where);
			
			$age_where=array('campaignid'=>$campaign_id,'type'=>'profile:age');
			
			$profile_age_data = $this->do_campaign->fetch_camapign_targeting($age_where);
			
			$gender_where=array('campaignid'=>$campaign_id,'type'=>'profile:gender');
			
			$profile_gender_data = $this->do_campaign->fetch_camapign_targeting($gender_where);
			
			$color_where=array('campaignid'=>$campaign_id,'type'=>'profile:color');
			
			$profile_color_data = $this->do_campaign->fetch_camapign_targeting($color_where);
			
			$height_where=array('campaignid'=>$campaign_id,'type'=>'profile:height');
			
			$profile_height_data = $this->do_campaign->fetch_camapign_targeting($height_where);
			
			$weight_where=array('campaignid'=>$campaign_id,'type'=>'profile:weight');
			
			$profile_weight_data = $this->do_campaign->fetch_camapign_targeting($weight_where);
			
			$keyword_where = array('campaignid' => $campaign_id,'type' => 'profile:keyword');
			
            $profile_keyword_data = $this->do_campaign->fetch_camapign_targeting($keyword_where);
			
			$url_where = array('campaignid' => $campaign_id,'type' => 'profile:url');
			
            $url_data = $this->do_campaign->fetch_camapign_targeting($url_where);
			
			$pblack_where = array('campaignid' => $campaign_id,'type' => 'profile:preset_blacklist');
			
			$pblack_details	= $this->do_campaign->fetch_camapign_targeting($pblack_where); 
			
			$pwhite_where = array('campaignid' => $campaign_id,'type' => 'profile:preset_whitelist');	
			
			$pwhite_details	= $this->do_campaign->fetch_camapign_targeting($pwhite_where); 
			
			$traffic_data = $this->do_campaign->get_campaign_traffic($campaign_id);
								
			$country_bid = $this->do_campaign->get_campaign_country_bidding($campaign_id);
									
			if($campaign_data)
			{
				$campaign_load_data = 	array('response'	=> 'ok',
								              'data'		=> $campaign_data,
											  'tracker_data' => $tracker_data,
											  'group_data'  => $group_data,
											  'time_data'  => $time_details,
											  'day_data' => $daypart_details,
											  'device_details'=>$device_details,
											  'include_data'=>$include_details,
											  'exclude_data'=>$exclude_details,
											  'city_data'=>$city_details,
											  'zip_data'=>$zip_details,
											  'browser_data'=>$browser_details,
											  'lang_data'=>$lang_details,
											  'lang_vers_data'=>$lang_version_details,
											  'os_data'=>$os_details,
											  'os_vers_data'=>$os_vers_details,
											  'mobile_manu'=>$mobile_manu_details,
											  'mobile_capability'=>$mobile_capa_details,
											  'connect_data'=>$connect_details,
											  'carrier_data'=>$carrier_details,  
											  'age_data'=>$profile_age_data,
											  'gender_data'=>$profile_gender_data,
											  'color_data'=>$profile_color_data,
											  'height_data'=>$profile_height_data,
											  'weight_data'=>$profile_weight_data,
											  'keyword_data'=>$profile_keyword_data,
											  'url_data'=>$url_data,
											  'block_data'=>$pblack_details,
											  'white_data'=>$pwhite_details,
											  'traffic_data'=>$traffic_data,
											  'country_bid_data'=>$country_bid   
											  ); 
			
				$this->response($campaign_load_data, 200); // 200 being the HTTP response code
			}
			else
			{
				$this->response(array('error'=>'No details'),200);
			}
		}
	}
	
	



	public function select_city_get()
	{
		$where		=	array('country'	=>	$this->get('country'));
		$city_val	=	$this->do_targeting->fetch_country_cities($where);	
		//$this->response($this->db->last_query(), 200);	
		//print_r($city_val);exit;
		if($city_val)
		{
			$this->response($city_val, 200);	
		}
		else
		{
			$this->response(array('error'=>'No details'),200);
		}
	}

	public function select_zipcode_get()
	{
		$where		=	array('country'	=>	$this->get('country'));
		$zip_val	=	$this->do_targeting->fetch_zip_codes($where);	
		//$this->response($this->db->last_query(), 200);	
		//print_r($city_val);exit;
		if($zip_val)
		{
			$this->response($zip_val, 200);	
		}
		else
		{
			$this->response(array('error'=>'No details'),200);
		}
	}	
	function fetch_targeting_devicelist_get()
	{
		$campaign_id 	= 	$this->get('campaign_id');
		$type			=	$this->get('target_type');
		
		if($campaign_id)
		{
			
			
			$campaign_target_data = $this->do_campaign->fetch_camapign_devicetargeting($campaign_id,$type);
			
			if($campaign_target_data)
			{
				$this->response($campaign_target_data, 200); // 200 being the HTTP response code
			}
			else
			{
				$this->response(array('error'=>'No details'),404);
			}
		}
	}
	
	public function country_bid_get()
	{
		$country_code = $this->get('country_code');
		$country_bid_val	=	$this->do_campaign->fetch_country_bid($country_code);	

		if($country_bid_val)
		{
			$this->response($country_bid_val, 200);	
		}
		else
		{
			$this->response('',200);
		}
	}
	public function wallet_balances_get()
	{
		$acc_id = $this->user_authentication->account_id;
		$get_accid=$this->get('acc_id');
		if($get_accid)
		{
			$acc_id =$get_accid;
		}
		$wallet_amt = $this->do_payments->get_wallet_bal($acc_id);
		
		if($wallet_amt<=0)
		{
			$this->response('No Wallet amount', 200);	
		}
		if($wallet_amt)
		{
			$this->response($wallet_amt, 200);	
		}
		else
		{
			$this->response('',200);
		}
	}

	public function select_cities_get()
	{
		$where		=	array('country'	=>	$this->get('country'));
		$city		=	implode(",",$this->get('city_names'));
		$city		=	explode(",",$city);
		
		$city_val	=	$this->do_targeting->fetch_country_city($where,$city);	

		if($city_val)
		{
			$this->response($city_val, 200);	
		}
		else
		{
			$this->response('',200);
		}
	}	
	public function select_city_name_get()
	{
		$where		=	explode(',',$this->get('id'));		
		$city_name	=	$this->do_targeting->fetch_city_name($where);	
		if($city_name)
		{
			$this->response($city_name, 200);	
		}
		else
		{
			$this->response('',200);
		}
	}	
		
	public function select_zipcodes1_get()
	{
		$where		=	array('country'	=>	$this->get('country'));
		$zip		=	explode(',',$this->get('zip'));		
		$zip_val	=	$this->do_targeting->fetch_zip_codes1($where,$zip);	

		if($zip_val)
		{
			$this->response($zip_val, 200);	
		}
		else
		{
			$this->response('',200);
		}
	}
	function getLatestFile($directoryPath)
	{
		$directoryPath = rtrim($directoryPath, '/');
	
		$max = array('path' => null, 'timestamp' => 0);	
		
		foreach (scandir($directoryPath, SCANDIR_SORT_NONE) as $file)
		{
			$path = $directoryPath . '/' . $file;
			if (!is_file($path)) {	
				continue;
			}
			$timestamp = filemtime($path);		
			if ($timestamp > $max['timestamp']) {
				$max['path'] = $path;
				$max['timestamp'] = $timestamp;
			}
		}	
		
    return $max['path'];
	}
	//added for campaign upload
	public function import_campaign_file_post()
	{	
		
		$file_id=$this->post('upload_name');	
	
		if($file_id!='')
		{
			$upload_extension = explode(".", $file_id);		
			
			if($upload_extension[1]=='csv' || $upload_extension[1]=='txt'|| $upload_extension[1]=='xml')
			{
				
					$csvfilepath 	= $this->config->item('read_csv');	
					$file_name		= $this->getLatestFile($csvfilepath);
						if($upload_extension[1]=='xml')
						{
							
						$xml = simplexml_load_file($file_name, 'SimpleXMLElement');	
						$data = json_decode(json_encode((array)$xml), TRUE);
						if(!empty($data['campaign'][0]))
							{
								 $data=$data['campaign'];
							}
							else{
							$datum[0]=$data['campaign'];
							$data=$datum;
							}
						//$data=$datas['campaign'];
						
						}
						else
						{
						$data = $this->csvreader->parse_file($file_name);
						}

					
					$counter		= '1';	
					$ext_counter=1;
					$insert_rec=array();
					$exist_rec=array();
					$num_rows=count($data);	
						
					if($num_rows>0)
					{
						foreach($data as $row)
						{
							
							if($row['campaignname']!='' && $row['clientid']!='' )
							{
								$campaignname			= trim($row['campaignname']);
							    $clientid				= trim($row['clientid']);
								$views					= trim($row['views']);
								$clicks					= trim($row['clicks']);
								$conversions			= trim($row['conversions']);
								$priority				= trim($row['priority']);
								$weight					= trim($row['weight']);
								$revenue				= trim($row['revenue']);
								$revenue_type			= trim($row['revenue_type']);
								$block					= trim($row['block']);
								$capping				= trim($row['capping']);
								$session_capping		= trim($row['session_capping']);
								$status					= trim($row['status']);
								$dj_budget_status		= trim($row['dj_budget_status']);
								$viewwindow				= trim($row['viewwindow']);
								$clickwindow			= trim($row['clickwindow']);
								$ecpm					= trim($row['ecpm']);
								$min_impressions		= trim($row['min_impressions']);
								$activate_time			= trim($row['activate_time']);
								$expire_time			= trim($row['end_time']);
								$cpv_percentage			= trim($row['cpv_percentage']);
								$an_status				= trim($row['cam_status']);
								$dj_campaign_budget		= trim($row['dj_campaign_budget']);
								$dj_is_retargeted		= trim($row['dj_is_retargeted']);
								$behavior				= trim($row['behavior']);
								$dj_max_retargetting	= trim($row['dj_max_retargetting']);
								$dj_daily_budget		= trim($row['dj_daily_budget']);
								$daily_budget_unlimit	= trim($row['daily_budget_unlimit']);
								$dj_campaign_remain_budget	= trim($row['dj_campaign_remain_budget']);
								$dj_campaign_remain_total_budget	= trim($row['dj_campaign_remain_total_budget']);
								$dj_current_date		= trim($row['dj_current_date']);
								$dj_targetting_type		= trim($row['dj_targetting_type']);
								$group_id				= trim($row['group_id']);
								$global_tracker			= trim($row['global_tracker']);
								$trackerid				= trim($row['trackerid']);
								
							
							if(empty($expire_time) || $expire_time==''){
								
								$expire_time1	= NULL;
								}
								else{
								
									$expire_time1=$expire_time;
									}
									
									$import_campaign_data	=	array(
											 'campaignname'			=>	clean_data($campaignname),
											 'clientid'				=>	clean_data($clientid),
											 'views'				=>	clean_data($views),
											 'clicks'  			     =>  clean_data($clicks),  
											 'conversions'			=>  clean_data($conversions),
											 'priority'				=>  $priority,
											 'weight'				=>  clean_data($weight),
											 'revenue'				=>  clean_data($revenue),
											 'revenue_type'			=>	clean_data($revenue_type),
											 'block'				=>	clean_data($block),
											 'capping'				=>	clean_data($capping),
											 'session_capping'		=>	clean_data($session_capping),
											 'status'				=>	clean_data($status),
											 'dj_budget_status'		=>	clean_data($dj_budget_status),
											 'viewwindow'			=>	clean_data($viewwindow),
											 'clickwindow'			=>	clean_data($clickwindow),
											 'ecpm'					=>	clean_data($ecpm),
											 'min_impressions'		=>	clean_data($min_impressions),
											 'activate_time'		=>	clean_data($activate_time),
											 'expire_time'			=>	$expire_time1,
											 'cpv_percentage'		=>	clean_data($cpv_percentage),
											 'an_status'		    =>	clean_data($an_status),	
											 'dj_campaign_budget' 	=> 	clean_data($dj_campaign_budget),
											 'dj_is_retargeted' 	=> 	clean_data($dj_is_retargeted),
											 'behavior'				=>	clean_data($behavior),
											 'dj_max_retargetting'	=>	clean_data($dj_max_retargetting),
											 'dj_daily_budget'		=>	clean_data($dj_daily_budget),
											 'daily_budget_unlimit'	=> 	$daily_budget_unlimit,
											 'dj_campaign_remain_budget'=>	$dj_campaign_remain_budget,
											 'dj_campaign_remain_total_budget'		=> 	$dj_campaign_remain_total_budget,
											 'dj_targetting_type'		=> 	$dj_targetting_type,
											
										);
										
									
											
															
								if(!empty($import_campaign_data))
								{
											
									$result[]=$this->do_campaign->add_import_campaign($import_campaign_data,$group_id,$trackerid,$global_tracker);
								
										
										$insert_rec[] =$counter;
										
								}
								else
								{
										$exist_rec[]=$ext_counter;
								}
						$counter++;	
						$ext_counter++;						
						
					}
					else
					{
						$error = array('response'	=> 'error',
												// 'msg'		=> 'required fields are empty',
												// 'error_msg'=> $ex_count.' uploaded file(s) are already Exists !' 
												'msg'	 => 'The file contains invalid data for this operation..'
												 ); 
								$this->response($error,200);
					}
					}
						if(count($insert_rec)>0 && count($exist_rec) >0)
						{
								$ins_count = count($insert_rec);
								$ex_count= count($exist_rec);
								$success = array('response'	=> 'ok_error',
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												 'error_msg'=> $ex_count.' uploaded file(s) are already Exists !',
												  'id'		=>	$result
												 ); 
								$this->response($success,200);
						}
						else if(count($insert_rec)>0 && count($exist_rec)<=0)
						{
							
								$ins_count = count($insert_rec);
								$success = array('response'	=> 'ok',
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												  'id'		=>	$result
												 ); 
								$this->response($success,200);
						}
						else if(count($exist_rec) >0&& count($insert_rec)<=0)
						{
								$ex_count= count($exist_rec);
									$error = array(
										   'response' => 'error',
										   'msg' =>  $ex_count.' uploaded file(s) are already Exists ! '
										  );
									$this->response( $error, 200);
						}
					}
					else
					{
						$error = array(
									'response' => 'error',
									'redirect'=>site_url('advertiser/campaigns/'),
									'msg'	 => 'There is no datas in the file!..'
									);
				  
						$this->response($error, 200);	
					}														
			}
			else
			{
				$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV/TXT/XML file to upload!..'
							);
	  
				$this->response($error, 200);	
					
			}		
		}
		else
		{
			$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV/TXT/XML file to upload!..'
						);
	  
			$this->response($error, 200);
		}		
		
						
	}
		
	//export campaign downlaod
	
public function fetch_export_data_get()
	{
		$campaign_id=$this->get('campaign_id');
		
		$export_data = $this->do_campaign->fetch_export_campaign_data($campaign_id);
      	
		if(!empty($campaign_id))
		{
				$this->response( $export_data, 200);
			
		}
		else
		{
			$this->response( 'error', 200);
		}
	}	
public function fetch_pixeltest_result_get()
	{
		$transaction_id=$this->get('id');
		
		$trans_data = $this->do_campaign->fetch_tracker_value($transaction_id);
      	
		if(!empty($trans_data))
		{
				$this->response($trans_data, 200);
			
		}
		else
		{
			$this->response( 'error', 200);
		}
		
    }		
	
		
//get campaign details for export display
public function fetch_export_campaign_display_get()
	{
		$campaign_id=$this->get('campaign_id');
	$camp_imp	=implode(',', $campaign_id);
	$cam_str="'".str_replace(",","','",$camp_imp)."'";

		$export_data = $this->do_campaign->fetch_export_campaign_data($cam_str);
     	
		if(!empty($export_data))
		{
				$this->response($export_data, 200); 
			
		}
		else
		{
			$success = array('response'	=> 'error'				 
												 ); 
								$this->response($success,200);
		}
	}
	
	//pixel convertion tracking count
	public function fetch_convertion_tracking_get()
	{
		$zone_id=$this->get('value');
		$date = get_search_date($settings['DEFAULT_INTERVAL']);

		$search['date_from'] = $date['to_date'].' 00:00:00';
		$search['date_to'] = $date['to_date'].' 23:00:00';
			$pixen_convertion_data = $this->do_campaign->fetch_convertion_tracking_data($zone_id,$search);
		
		if(!empty($pixen_convertion_data))
		{
			$this->response($pixen_convertion_data, 200); 
		}
		else
		{
			$success = array('response'	=> 'error'				 
												 ); 
								$this->response($success,200);
		}
	}	
	
	//updating new pixel tracking targeting url
	public function update_new_pixel_url_get()
	{
		$pixel_url=$this->get('dest');
		$pixen_url_data = $this->do_campaign->update_pixel_url_data($pixel_url);
		if(!empty($pixen_url_data))
		{
			$this->response($pixen_url_data, 200); 
		}
		else
		{
			$success = array('response'	=> 'error'				 
												 ); 
								$this->response($success,200);
		}
	}	
	//fetch test pixel url		
		
	public function fetch_pixeltest_url_get()
	{
		
		$testpixen_url_data = $this->do_campaign->fetch_testpixel_data();
		if(!empty($testpixen_url_data))
		{
			$this->response($testpixen_url_data, 200); 
		}
		else
		{
			$success = array('response'	=> 'error'				 
												 ); 
								$this->response($success,200);
		}
	}	
	//zone optimization
	public function fetch_campaign_zone_optimization_get()
	{
			
		$campaign_id = $this->get('campaign_id');
		
		if($campaign_id)
		{
			$zone_optimization_data = $this->do_campaign->get_campaign_zone_optimization($campaign_id);
			
			$this->response($zone_optimization_data, 200); // 200 being the HTTP response code
			
		}
	}
	//country optimization
	public function fetch_campaign_country_optimization_get()
	{
			
		$campaign_id = $this->get('campaign_id');
		
		if($campaign_id)
		{
			$country_optimization_data = $this->do_campaign->get_campaign_country_optimization($campaign_id);
	
			$this->response($country_optimization_data, 200); // 200 being the HTTP response code
			
		}
	}
	//traffic sources optimization
	
	public function fetch_campaign_traffic_optimization_get()
	{
		$campaign_id = $this->get('campaign_id');
		
		if($campaign_id)
		{
			$traffic_optimization_data = $this->do_campaign->get_campaign_traffic_optimization($campaign_id);
			//$this->response($this->db->last_query(), 200);
			$this->response($traffic_optimization_data, 200); // 200 being the HTTP response code
			
		}
	}
	//remove country optimization
	
	public function remove_country_optimization_get()
	{
		$campaign_id = $this->get('id');
		$country_value = $this->get('country');
		$country_condition = $this->get('value');
		
		if($country_condition=='BLOCK')
		{
		
	
		$country_edata	=	array(
												"campaignid"	=> 	$campaign_id,
												"logical"		=> 	"or",
												"type"			=> 	"Exclude_country",
												"comparison"	=> 	"=~",
												"data"			=> 	FALSE,
												"executionorder"=> 	4,
											);
					
		
		$country_edata['data']=$country_value;
		
		$exclude_country =	$this->do_targeting->fetch_country_optimization($campaign_id,$country_value,$country_edata);	
		
		$this->response($exclude_country, 200);
		}
		elseif($country_condition=='UNBLOCK')
		{
		
		$exclude_country =	$this->do_targeting->fetch_country_unblock_optimization($campaign_id,$country_value);	
		
		$this->response($exclude_country, 200);
		}
								
																	
	}		
	//remove zone optimization
	public function remove_zone_optimization_get()
	{
		$campaign_id 		 = $this->get('id');
		$zone_id			 = $this->get('zone_id');
		$zone_condition		 = $this->get('value');
		$black_data	=	array(
											"campaignid"	=> 	$campaign_id,
											"logical"		=> 	"or",
											"type"			=> 	"profile:blacklist",
											"comparison"	=> 	"==",
											"data"			=> 	FALSE,
											"executionorder"=> 	11,
										);
		
		if($zone_condition == 'BLOCK')
		{
				
		$black_data['data']=$zone_id;
		$exclude_zone =	$this->do_targeting->fetch_zone_block_optimization($campaign_id,$zone_id,$black_data);	
		$this->response($exclude_zone, 200);
		}
		else if($zone_condition=='UNBLOCK')
		{
	
		
		$exclude_zone =	$this->do_targeting->fetch_zone_unblock_optimization($campaign_id,$zone_id,$black_data);	
		$this->response($exclude_zone, 200);
		}
	}
	
	//remove traffic sources optimization
	
	public function remove_traffic_optimization_get()
	{
		$campaign_id 		 = $this->get('id');
		$condition_value 	 = $this->get('value');
		$zone_id		 	 = $this->get('zone_id');
		if($campaign_id)
		{
			$traffic_optimization	=	$this->do_campaign->update_traffic_sources_optimization($campaign_id,$zone_id,$condition_value);
			$this->response($traffic_optimization, 200);
		}
	}
}
