<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Auto_link
 *
 * Auto linking between creative and ad blocks will be handelled here.
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Ramya P
 * @link		http://www.djaxadserver.com
*/

class Auto_link extends REST_Controller
{
	
	function __construct()
	{
		parent::__construct();
		$this->load->model('do_auto_link');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
	}
	
	/*
	 * 
	 * name:link_ads_get
	 * @param : zone_id
	 * @return : NULL
	 * 
	 * Link zone to creative
	 */
	function link_ads_get()
	{
		$zone_id = $this->get('zone_id');
		$this->do_auto_link->link_ads($zone_id);
	}
	
	/*function link_ads_get()
	{
		$zone_id = $this->get('zone_id');
			
		if($zone_id)
		{
			// Unlink the previously linked creatives for zone
			$this->unlink_ads($zone_id);
			
			$zone_details = $this->do_auto_link->fetch_adblock($zone_id);
			$zone = $zone_details[0];
			$delivery_type = $zone['delivery'];
			switch($delivery_type)
			{
				case WEB_AD_BLOCK_BANNER:
								$where_web = array(
												"width" => $zone['width'],
												"height" => $zone['height']
											);
								$creatives = $this->do_auto_link->fetch_web_creatives($where_web);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->do_auto_link->add_link_ads($link_assoc_data);	
									}
								}
								break;
				case WEB_AD_BLOCK_TEXT:
								$creatives = $this->do_auto_link->fetch_text_creatives();
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->do_auto_link->add_link_ads($link_assoc_data);	
									}
								}
								break;
				case WEB_AD_BLOCK_DHTML:
								$where_dhtml = array(
												"width" => $zone['width'],
												"height" => $zone['height']
											);
								$creatives = $this->do_auto_link->fetch_dhtml_creatives($where_dhtml);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->do_auto_link->add_link_ads($link_assoc_data);	
									}
								}
								break;
				case VIDEO_AD_BLOCK_OVERLAY:
								$where_overlay = array(
												"width" => $zone['width'],
												"height" => $zone['height']
											);
								$creatives = $this->do_auto_link->fetch_overlay_creatives($where_overlay);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->do_auto_link->add_link_ads($link_assoc_data);	
									}
								}
								break;
				case VIDEO_AD_BLOCK_INLINE:
								$where_inline = array(
												"width" => $zone['width'],
												"height" => $zone['height']
											);
								$creatives = $this->do_auto_link->fetch_inline_creatives($where_inline);
								if($creatives!=FALSE)
								{
									foreach($creatives as $c)
									{
										//UPDATE ZONE AND CREATIVE MAPPING	
										$link_assoc_data 	=	array('zone_id' =>	$zone_id, 'ad_id' => $c['bannerid']);
										$this->do_auto_link->add_link_ads($link_assoc_data);	
									}
								}
								break;
				
			}
			//$this->response($zone);
		}
	}*/
	
	/*
	 * 
	 * name:unlink_ads_get
	 * @param : zone_id
	 * @return : NULL
	 * 
	 * UnLink zone to creative
	 */
	 
	 function unlink_ads()
	 {
	 	$zone_id = $this->get('zone_id');
		if($zone_id)
		{
			$this->do_auto_link->unlink_ads($zone_id);
		}
	 }
	 
	 /*
	 * 
	 * name:link_adblocks_get
	 * @param : campaign_id, banner_id
	 * @return : NULL
	 * 
	 * Link creative to adblocks
	 */
	 function link_adblocks_get()
	{
		$creative_id = $this->get('creative_id');
		//$campaign_id = $this->get('campaign_id');
		$this->do_auto_link->link_adblocks($creative_id);
	}
	/*
	 * 
	 * name:unlink_blocks_get
	 * @param : creative_id
	 * @return : NULL
	 * 
	 * UnLink creative to blocks
	 */
	 
	 function unlink_blocks()
	 {
	 	$creative_id = $this->get('creative_id');
		if($creative_id)
		{
			$this->do_auto_link->unlink_blocks($creative_id);
		}
	 }
	 
	 /*
	 * 
	 * name:link_rotator_camapign_ads_get
	 * @param : zone_id
	 * @return : NULL
	 * 
	 * Link zone to creative
	 */
	function link_rotator_camapign_ads_get()
	{
		$zone_id = $this->get('zone_id');
		$campaign_id = $this->get('campaign_id');
		$size = $this->get('size');
		$banner_type = $this->get('banner_type');
		if($campaign_id){
		$link =$this->do_auto_link->link_rotator_camapign_ads($zone_id,$campaign_id,$size,$banner_type);
		$this->response( $link, 200);
		/*$success = array('response'	=> 'ok',
							'link'		=> 	$link,
							 'msg'		=> 'Linking camapign creative with zone success'
							 );*/
			
			//$this->response( $success, 200);
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Campaign id is not found'
					);
			
			$this->response( $error, 200);
		}
	}
}
