<?php defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Apps extends REST_Controller
{
	public 	$min_floor_price;
	
	function __construct(){

		parent::__construct();
		$this->load->library('redis_library');		
		$this->load->model('do_site');
		$this->load->model('do_apps');
		$this->load->model('do_networks');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');	
		$this->load->model('do_web_adblock');
		$this->load->model('do_auto_link');			
		$this->min_floor_price 		=  	$this->default_configurations->get('pub_min_floor_price');
		$this->floor_price_enable 	=  	$this->default_configurations->get('floor_price_enable');
		
        $this->load->library('user_authentication');
	    $key		=	$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = 	$this->user_authentication;
        $this->load->model('do_message');
		$this->load->library('notification');
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }		   
	}
	
	
	//api/v1/app/add
	function add_post(){
		
		$this->form_validation->set_rules('app_name','App Name', 'required|trim|alpha_numeric_dash_space');
		$this->form_validation->set_rules('app_url', 'Mobile Application URL', 'required|trim|callback_url_check|is_unique['.TAB_TEMP_URL.'.app_url]'); //|url_exists
		$this->form_validation->set_message('is_unique', 'Already this Playstore url is being registered. please enter the unique one');
				
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$user_auth  = 	$this->user_authentication;
			$agency_id 	= 	$user_auth->agency_id; 	 	
			
			if($this->user_authentication->account_type=='TRAFFICKER')
			  {
				$account_id = $this->user_authentication->account_id;
			  }
			  else
			  {
				  if($this->post('account_id')!='')
				{
					$account_id = $this->post('account_id');  
				}
				else
				{
					$account_id = $this->post('acc_id');
				}
				
			  }
			
			
			$status=0;
			$app_url=$this->url_creation($this->post('app_url'));
			$app_id = $this->do_apps->add($account_id,$agency_id,$this->post('os_type'),$app_url,$this->post('app_name'),$status);
			if($app_id != FALSE){			
				
				if(is_array($this->post('category')) && count($this->post('category')) > 0 && (!in_array('all',$this->post('category')))){
					$this->do_apps->set_assoc_category($app_id,$this->post('category'));				
				}
				
			$success = array(
						'response' => 'ok',
						'msg'	 => 'Mobile Application has been added successfully!..'
					);
					
			/* Activity Log for Add App - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(APPS,APP_ADD);
				if($enable=='1')
				{							
				$this->activity_log(APPS,ADD,$app_id);
				}
			/* Activity Log for Add App - End*/				
						
							
			/* Mail send to publisher after app creation*/		
			$account_id = 	$this->user_authentication->account_id;
			$account_type	=	$this->user_authentication->account_type;	
			$network_id	=	$this->do_message->fetch_admin_network_id();
			$agency_id	=	$this->user_authentication->agency_id;
			$result		=	$this->do_networks->agency_owner_details($agency_id);
			$admin_name    	= 	$result['name'];			
			$admin_email	= 	$result['email'];	
			$admin_id   	= 	$result['account_id'];			
			if($account_type=='TRAFFICKER')
			{
				$affiliate_id	=	$this->user_authentication->affiliate_id;
				$reciever = $this->do_message->get_affiliate($affiliate_id); 
		 
			}
			 
			$user = $this->do_message->get_profile(ADMIN_ID);
			
			$mail_type = "PUBLISHER_APP_ADD";
			$acc_type='TRAFFICKER';
			
			$type_details		=	array(
				'msg_type'		=> $message,
				'type'			=> "PUBLISHER_APP_ADD",
				'string'		=> 'app_add',
				'column_name'	=> 'apps'
				);
				$message_data		=	array(
					'sender_id'		=>	ADMIN_ID,
					'receiver_id'	=>	$account_id,
					'subject'		=>	'Publisher - Mobile Application',
					'content'		=> 	'Mobile Application added successfully',
					'image_name'	=>	NULL,
					'file_name'		=>	NULL,
					'account_type'	=>	"TRAFFICKER",
					'status'		=>	'1',
					'network_id'	=>	$network_id,	
					'notification_type'	=>	"App",									
					'date'			=>	date('Y-m-d H:i:s')
					);
																	
					
					$user_email    =$reciever['email'];
					$user_name     =$reciever['name'];
					$from 		   = $admin_email;
					$to  		   = $user_email;		
												
					/*$mail_content=array(
						"subject" 	   => "Mobile Application Add",
						"to_name" 	   => $user_name,				
						"from_name"	   => $admin_name,
						"os_type"      => $this->post('os_type'),
						"app_url"      => $this->post('app_url'),
						"app_name"     => $this->post('app_name')					 
					);*/
					$attachement='';					
					
					/*$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);	*/	

					$notification_value ='app_add';  
					$notification_msg = $this->do_message->get_notification_msg($notification_value); 
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
						
					$searchStr=$this->config->item('macros');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}				
					if($count>0)
					{
					$app_url=$this->url_creation($this->post('app_url'));
					$os_type=$this->post('os_type');
					$app_name=$this->post('app_name');
					$msg = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{publisher_name}}",$reciever['name'],$msg);	
					$msg = str_replace("{{app_name}}",$app_name,$msg);
					$msg = str_replace("{{app_url}}",$app_url,$msg);
					$msg = str_replace("{{app_type}}",$os_type,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'">Login</a>' ,$msg);  
					$mail_content = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('click_directADS').'</a>' ,$msg);					
					}
					else
					{
						$mail_content=$notification_content;  
					}
					
					$dat = $this->notification->pub_notification_mail($message_data,$user,$reciever,$type_details,$mail_content);				
										
					/***************************************/	  
					$this->response( $success, 200);
			}
						
		}
	}
	
	
	function fetch_apps_get()
	{
		$app_id = $this->get('app_id');
		//Get from library file
		if($this->user_authentication->account_type=='TRAFFICKER')
		  {
			$account_id = $this->user_authentication->account_id;
		  }
		  else
		  {
			$account_id = $this->get('account_id');
		  }	
					
			$app_list = $this->do_apps->fetch($account_id,$app_id);			
			
			$this->response($app_list);
		
	}
	
	
	function fetch_app_cat_get(){
		
		 $app_id = $this->get('app_id');
		
		if($app_id){
			
			$app_cat_assoc = $this->do_apps->get_app_category_assoc($app_id);
			$this->response($app_cat_assoc);
			
		}else{
			$error = array(
								'response' => 'error',
								'msg' =>  'Not a correct site id'
							);

			 $this->response( $error, 200);	
		}
	}
	
	
	
	/**
       * 
       * name : update_post()
       * 
       * Updates the app information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	function update_post()
	{
		$this->form_validation->set_rules('app_name','App Name', 'required|trim|alpha_numeric_dash_space');
		//$this->form_validation->set_rules('app_url', 'Mobile Application URL', 'required|trim|valid_url|edit_unique['.TAB_TEMP_URL.'~app_url~app_id~'.$this->post('app_id').']'); //|url_exists
				
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$app_id = $this->do_apps->update($this->post());
			$app_cat= $this->post('category');
			if (($key = array_search('all', $app_cat)) !== false) {
			    unset($app_cat[$key]);
			}
			
			$this->do_apps->set_assoc_category($app_id,$app_cat);
			
				
			$success = array(
									'response' => 'ok',
									'msg'	 => 'Mobile Application has been updated successfully!..'
					);
					
			/* Activity Log for Update App - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(APPS,APP_EDIT);
				if($enable=='1')
				{		
				$this->activity_log(APPS,EDIT,$app_id);
				}
			/* Activity Log for Update App - End*/				
					
					
					
			$update_site = $this->post('app_name');			
			$account_id = 	$this->user_authentication->account_id;
			$agency_id	=	$this->user_authentication->agency_id;
			$result		=	$this->do_networks->agency_owner_details($agency_id);
			$admin_name    	= 	$result['name'];			
			$admin_email	= 	$result['email'];	
			$admin_id   	= 	$result['account_id'];
			 
			$account_type	=	$this->user_authentication->account_type;	
			$network_id	=	$this->do_message->fetch_admin_network_id();	 		
			if($account_type=='TRAFFICKER')
			{
				$affiliate_id	=	$this->user_authentication->affiliate_id;
				$reciever = $this->do_message->get_affiliate($affiliate_id); 
			
			}
			 
			$user = $this->do_message->get_profile(ADMIN_ID);
			
			$mail_type = "PUBLISHER_SITE_UPDATE";
			$acc_type='TRAFFICKER';
			
			$type_details		=	array(
				'msg_type'		=> $message,
				'type'			=> "PUBLISHER_SITE_UPDATE",
				'string'		=> 'app_edit',
				'column_name'	=> 'apps'
				);
				$message_data		=	array(
					'sender_id'		=>	ADMIN_ID,
					'receiver_id'	=>	$account_id,
					'subject'		=>	'Publisher - Mobile Application',
					'content'		=> 	'Mobile Application updated successfully',
					'image_name'	=>	NULL,
					'file_name'		=>	NULL,
					'account_type'	=>	"TRAFFICKER",
					'notification_type'	=>	"App",	
					'status'		=>	'1',
					'network_id'	=>	$network_id,									
					'date'			=>	date('Y-m-d H:i:s')
					);
					
													
			
			$user_email    =$reciever['email'];
			$user_name     =$reciever['name'];
			$from 		   = $admin_email;
			$to  		   = $user_email;		
										
				/*$mail_content=array(
						"subject" 	   => "Mobile Application Update",
						"to_name" 	   => $user_name,				
						"from_name"	   => $admin_name,					 
						"site_names"   => $update_site						 
					);*/
						$attachement='';
					
					
			//$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);*/
			
			        $notification_value ='app_edit';  
					$notification_msg = $this->do_message->get_notification_msg($notification_value); 
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
						
					$searchStr=$this->config->item('macros');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}				
					if($count>0)
					{
					$app_url=$this->url_creation($this->post('app_url'));
					$os_type=$this->post('os_type');
					$app_name=$this->post('app_name');
					$msg = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{publisher_name}}",$reciever['name'],$msg);	
					$msg = str_replace("{{app_name}}",$app_name,$msg);
					$msg = str_replace("{{app_url}}",$app_url,$msg);
					$msg = str_replace("{{app_type}}",$os_type,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'">Login</a>' ,$msg);  
					$mail_content = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('click_directADS').'</a>' ,$msg);					
					}
					else
					{
						$mail_content=$notification_content;  
					}
					
					$dat = $this->notification->pub_notification_mail($message_data,$user,$reciever,$type_details,$mail_content);					
										
					
					/***************************************/  
			$this->response($success, 200);
		}
			
		
	}
	
	/**
       * 
       * name : delete_get()
       * 
       * deletes the site information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_get()
	{
		$app_id = $this->get('app_id');	
		$app_name=array(); 
		$app_url=array();
		$app_type=array();
		if($app_id)
		{
			$appdel_id	=	explode(',',$app_id);
			if(is_array($appdel_id))
			{ 
				foreach($appdel_id as $app_id)
				{	
					/*App Details */				
					$app_res=$this->do_apps->fetch_appinformation($app_id);
					$app_name[]= $app_res[0]['app_name'];
					$app_url[] = $app_res[0]['app_url'];
					$app_type[]= $app_res[0]['os_type']; 
					/*End*/
					
					/* Activity Log for Delete App - Start*/
					$enable	=  	$this->default_configurations->activity_log_setting(APPS,APP_DEL);
					if($enable=='1')
					{								
					$this->activity_log(APPS,DELETE,$app_id);
					}
					/* Activity Log for Delete App - End*/				
			
					$app_id = $this->do_apps->remove($app_id);
				}
			}
			else
			{
				/* Activity Log for Delete App - Start*/
				$enable	=  	$this->default_configurations->activity_log_setting(APPS,APP_DEL);
				if($enable=='1')
				{				
				$this->activity_log(APPS,DELETE,$app_id);
				}
				/* Activity Log for Delete App - End*/		

				/*App Details */				
					$app_res=$this->do_apps->fetch_appinformation($app_id);
					$app_name= $app_res[0]['app_name'];
					$app_url = $app_res[0]['app_url'];
					$app_type= $app_res[0]['os_type']; 
				/*End*/
			
				$app_id = $this->do_apps->remove($app_id);			
			}
			$app_lists ='';
					 
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Mobile Application has been deleted'
							 );						 
			$account_type	=	$this->user_authentication->account_type;	
			$network_id	=	$this->do_message->fetch_admin_network_id();
			$account_id = 	$this->user_authentication->account_id;
			$agency_id	=	$this->user_authentication->agency_id;
			$result		=	$this->do_networks->agency_owner_details($agency_id);
			$admin_name    	= 	$result['name'];			
			$admin_email	= 	$result['email'];	
			$admin_id   	= 	$result['account_id'];
			if($account_type=='TRAFFICKER')
			{
				$affiliate_id	=	$this->user_authentication->affiliate_id;
				$reciever = $this->do_message->get_affiliate($affiliate_id); 	 
			}
			 
			$user = $this->do_message->get_profile(ADMIN_ID);
			
			$mail_type = "PUBLISHER_SITE_DELETE";
			$acc_type='TRAFFICKER';
			
						
			$type_details		=	array(
				'msg_type'		=> $message,
				'type'			=> "PUBLISHER_SITE_DELETE",
				'string'		=> 'app_del',
				'column_name'	=> 'apps'
				);
				$message_data		=	array(
					'sender_id'		=>	ADMIN_ID,
					'receiver_id'	=>	$account_id,
					'subject'		=>	'Publisher - Mobile Application',
					'content'		=> 	'Mobile Application deleted successfully',
					'image_name'	=>	NULL,
					'file_name'		=>	NULL,
					'account_type'	=>	"TRAFFICKER",
					'notification_type'	=>	"App",	
					'status'		=>	'1',
					'network_id'	=>	$network_id,									
					'date'			=>	date('Y-m-d H:i:s')
					);
					
													
			$user_email    =$reciever['email'];
			$user_name     =$reciever['name'];
			$from 		   = $admin_email;
			$to  		   = $user_email;		
										
				/*$mail_content=array(
						"subject" 	   => "Site delete",
						"to_name" 	   => $user_name,				
						"from_name"	   => $admin_name,					 
						"site_names"   => $del_site_name						 
					);*/
			$attachement='';				 
					
			/*$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content); */
					$notification_value ='app_delete';  
					$notification_msg = $this->do_message->get_notification_msg($notification_value); 
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
						
					$searchStr=$this->config->item('macros');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}				
					if($count>0)
					{
					$app_name=(count($app_name)>0)?implode(",",$app_name):$app_name;
					$app_url=(count($app_url)>0)?implode(",",$app_url):$app_url;
					$os_type=(count($app_type)>0)?implode(",",$app_type):$app_type;					
					$msg = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{publisher_name}}",$reciever['name'],$msg);	
					$msg = str_replace("{{app_name}}",$app_name,$msg);
					$msg = str_replace("{{app_url}}",$app_url,$msg);
					$msg = str_replace("{{app_type}}",$os_type,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'">Login</a>' ,$msg);  
					$mail_content = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('click_directADS').'</a>' ,$msg);					
					}
					else
					{
						$mail_content=$notification_content;  
					}									
					$dat = $this->notification->pub_notification_mail($message_data,$user,$reciever,$type_details,$mail_content);
					
			/***************************************/  
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Site id is not found'
					);
			$this->response( $error, 200);
		}
	}
	
	function fetch_applisting_get()
	{
		if($this->user_authentication->account_type=='TRAFFICKER')
		{
			$account_id = 	$this->user_authentication->account_id;
		}
		else
		{
			$account_id	=	'';
		}	
		
		$app_id=$this->get('app_id');
		$app_list = $this->do_apps->fetch_appinfo_for_activitylog($account_id,$app_id);
		$this->response($app_list);
	}
	
	
	function fetch_applist_get(){
		
		if($this->user_authentication->account_type=='TRAFFICKER')
		{
			$account_id = 	$this->user_authentication->account_id;
		}
		else
		{
			$account_id	=	'';
		}	
		
		$app_id=$this->get('app_id');
		$app_list = $this->do_apps->fetch_appinfo($account_id,$app_id);
		$this->response($app_list);
		
	}
	
	
	
	
	public function fetch_affiliate_get()
	{		
		$site_id=$this->get('site_id'); 
		
		$aff_list 	= 	$this->do_site->fetch_affiliate_site($site_id);
			
		$this->response($aff_list);
		
	}
    
    
	public function fetch_adblocks_get()
	{					
		#$account_id 	= 	$this->get('account_id');
		if($this->user_authentication->account_type=='TRAFFICKER')
		 {
				$user_auth  	= 	$this->user_authentication;
				$account_id 	= 	$user_auth->account_id;
		}
		else
		{
			$account_id 	= 	$this->get('account_id');
		}
		$site_id	   	= 	$this->get('site_id');
		$zone_id	   	= 	$this->get('zone_id');	
		$rotator_adblock= 	$this->get('rotator_block_status');
	
		//if($account_id){			
			$adb_list 	= 	$this->do_site->fetch_adblocks($account_id,$site_id,$zone_id,$rotator_adblock);
			
			$this->response($adb_list);
		//}
	}
	
	/******** AD BLOCK - FIRST STEP *******/
	
	/* Add Ad block type by site
	 * 
	 * name: add_ad_block_post
	 * 
	 * @return boolean (or) string Returns the object on TRUE (or) FALSE
	 **/
	
    public function add_ad_block_post()
    {		
		$this->form_validation->set_rules('zone_type','Zone Type', 'required|trim');		
		
		$zsize	=	array(WEB_AD_BLOCK_BANNER,WEB_AD_BLOCK_DHTML,WEB_AD_BLOCK_LAYER,WEB_AD_BLOCK_CATFISH);
		
		if(in_array($this->post('zone_type'),$zsize))
		{		
			$this->form_validation->set_rules('ad_block_size','Ad Block Size', 'required|trim');
		}
		
		$ztype	=	array(WEB_AD_BLOCK_SITESKIN,MOBILE_AD_BLOCK_SLIDER,MOBILE_AD_BLOCK_PULL);
		
		if(in_array($this->post('zone_type'),$ztype))
		{
			$this->form_validation->set_rules('ad_block_type','Ad Block Type', 'required|trim');
			$adposition	=	clean_data($this->post('ad_block_type'));
		}
		else
		{
			$adposition	=	'';
		}
		
		if($this->form_validation->run() === FALSE)
		{
			 $error_msg = 	$this->form_validation->error_array();			

			 $error 	= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$user_auth  = 	$this->user_authentication;
			$account_id = 	$user_auth->account_id; 
			$agency_id 	= 	$user_auth->agency_id; 	 		
			
			if($account_id)
			{
				/* Fetch Affiliateid */	
				
				$site_id	=	($this->post('site_id')!='')?$this->post('site_id'):$this->post('site_list_id');
				
				if($this->user_authentication->account_type=='TRAFFICKER')
			    {			
					$affiliate	=	$this->do_site->fetch_affiliate($account_id);
			    }
			    else
			    {					
					$aff_list 	= 	$this->do_site->fetch_affiliate_site($site_id);
					$affiliate 	= 	$aff_list[0];					
				}			
				
												
				if($this->post('ad_block_size'))
				{
					$adbsize	=	$this->post('ad_block_size');
				}
				else
				{
					$adbsize	=	$this->post('adb_size');
				}
				
				$size			=	explode('x',$adbsize);	
				$width			=	$size[0];
				$height			=	$size[1];
				
				if($this->post('mobile_ad_type')!='')
				{
					$zone_type	=	0;
				}
				else
				{
					$zone_type	=	3;
				}
				if($this->post('rotator') == 'Y'){
					$rotator_adblock = 1;
				}
				else{
					$rotator_adblock = 0;
				}
				//delivery number
				$delivery 		= 	delivery_value($this->post('zone_type'));
				
				$add_adblock	=	array(	
										"affiliateid"		=>	$affiliate['affiliateid'],
										"zonetype"			=>	$zone_type,
										"delivery"			=>  $delivery,										
										"width"				=>  clean_data($width),
										"height"			=>  clean_data($height),
										"dj_ad_position"	=>  $adposition,
										"dj_zone_type"		=>	clean_data($this->post('zone_type')),
										"dj_mobile_ad_type"	=>	$this->post('mobile_ad_type'),
										"dj_added_date"		=>	date("Y-m-d H:i:s"),
										"rotator_block_status"	=>	$rotator_adblock
										/*,
										"dj_banner_autoreload"=> $this->post('banner_autoload')*/
									); 
									
																 
													
				if($this->post('_adblock_id')=='')
				{
					$add_adblock["zonename"]=	'adblock'.date('d').'_'.rand(100, 999);
					$zone_id		=	$this->do_web_adblock->add($add_adblock);				
									
					$add_adbAssoc 	= 	array(
											"site_id"	=> 	$site_id,
											"zone_id"	=> 	$zone_id	
											);
					
					$this->do_web_adblock->addAssoc($add_adbAssoc);				
				
				}
				else
				{	
					$zone_id	=	$this->post('_adblock_id');
					$where		=	array(
										"affiliateid"		=>	$affiliate['affiliateid'],
										"zoneid"			=>	$zone_id
									);
									
					$update		= 	$this->do_site->update_ad_block($add_adblock,$where,$agency_id);
				}				
				
				if($zone_id)
				{
					//Auto Linking ofZones
					if($this->post('rotator') == 'Y'){
					
					}
					else{
					$this->do_auto_link->link_ads($zone_id,$agency_id);
					}
					$success 	= 	array(
										'response' 			=> 	'ok',
										'adblock_id'		=> 	$zone_id,
										'adblock_type'		=> 	$this->post('zone_type'),
										'mobile_ad_type'	=> $this->post('mobile_ad_type'),
										'adblock_size'		=> 	$adbsize,
										'floor_price_enable'=> 	$this->floor_price_enable,
										'pub_enable'		=>	$affiliate['floor_price_enable'],
										'msg'				=> 	'Ad blocks are added successfully!..'
									);				
								
					$this->response($success, 200);
				}
				else
				{
					$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error! Please try Again..'
								);	
					$this->response($error, 200);
				}
		
			}else{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Not an valid accountid!..'
								);	
				$this->response($error, 200);
			}
		}

	}
	
	/******** AD BLOCK - SECOND STEP *******/
	
	/* Complete Ad block by site
	 * 
	 * name: complete_ad_block_post
	 * 
	 * @return boolean (or) string Returns the object on TRUE (or) FALSE
	 * */
	
    public function complete_ad_block_post()
    {	
		

		$user_auth  = 	$this->user_authentication;
		$account_id = 	$user_auth->account_id;
		$agency_id 	= 	$user_auth->agency_id;	
		
		/* Fetch Affiliateid */	
		
		if($this->user_authentication->account_type=='TRAFFICKER')
		{			
			$affiliate	=	$this->do_site->fetch_affiliate($account_id);
		}
		else
		{
			$zone_id	=	$this->post('_adblock_id');
			$aff_list 	= 	$this->do_site->fetch_affiliate_zone($zone_id);
			$affiliate 	= 	$aff_list[0];					
		}
			
		$this->form_validation->set_rules('adblock_name','Ad Block Name', 'required|trim');		
		
		if($this->floor_price_enable=='enable')
		{
			if($affiliate['floor_price_enable']=='1')
			{
				$this->form_validation->set_rules('floor_price','Floor Price', 'required|trim|greater_than_equal_to['.$this->min_floor_price.']');
			}
		}
		
		if($this->form_validation->run() === FALSE)
		{
			 $error_msg = 	$this->form_validation->error_array();			

			 $error 	= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{			
			
			if($account_id)
			{	
			
				$zone_id		=	$this->post('_adblock_id');
				
				$site_id		=	$this->post('site_id');					
				
				$where			=	array(
											"affiliateid"		=>	$affiliate['affiliateid'],
											"zoneid"			=>	$zone_id
										);
				$select_cpm		= $this->post('select_cpm');
				
				if($select_cpm==1)
				{
					$fixed_cpm = $this->post('fixed_cpm_rate');
					$fixed_system_cpm = 0;
				}
				else if($select_cpm==2)
				{
					$fixed_cpm = 0;
					$fixed_system_cpm = $this->post('fixed_system_cpm_rate');
				}
				else
				{
					$fixed_cpm = 0;
					$fixed_system_cpm = 0;
				}
												

					if($this->post('html_template'))
					{ 
						$update_adblock	=	array(							
											"zonename"  		=>	clean_data($this->post('adblock_name')),
											"dj_passback_tag"	=>	stripslashes($this->post('passback')),
											"fixed_cpm"			=>	$fixed_cpm,
											"fixed_system_cpm" 	=> 	$fixed_system_cpm,
											'custom_css'	 	=> $this->post('custom_css'),
											'bg_color' 			=> $this->post('bg_color'),
											'sponsored_prefix'	=> $this->post('sponsored_prefix'),
											'inline_video'   	=> $this->post('inline_video_val'),
											'height'			=> $this->post('image_height'),
											'width'				=> $this->post('image_width'),
											'html_template'		=> $this->post('html_template'),
											'css_path'			=> $this->post('css_path')				
											);
					}
					else{
						$update_adblock	=	array(							
											"zonename"  		=>	clean_data($this->post('adblock_name')),
											"dj_passback_tag"	=>	stripslashes($this->post('passback')),
											"fixed_cpm"			=>	$fixed_cpm,
											"fixed_system_cpm" 	=> 	$fixed_system_cpm
											
											);		
					}				
								
				if($this->post('floor_price'))
				{
					$update_adblock["dj_floor_price"]	=	$this->post('floor_price');
				}			
							
				$update			=	$this->do_site->update_ad_block($update_adblock,$where,$agency_id);					
				
	
				if($update)
				{
					
					$success 		= 	array(
											'response' 	=> 'ok',
											'msg'	 	=> 'Ad blocks input are added successfully!..'
										); 
			 
		
			$account_type	=	$this->user_authentication->account_type;	
			$network_id	=	$this->do_message->fetch_admin_network_id();	 
			if($account_type=='TRAFFICKER')
			{
				$affiliate_id	=	$this->user_authentication->affiliate_id;
				$reciever = $this->do_message->get_affiliate($affiliate_id); 
			
			}
			
			$user = $this->do_message->get_profile(ADMIN_ID);
			
			$mail_type = "PUBLISHER_ADBLOCK_ADD";
			$acc_type='TRAFFICKER';
		
			$type_details		=	array(
				'msg_type'		=> $message,
				'type'			=> "PUBLISHER_ADBLOCK_ADD",
				'string'		=> 'adb_add',
				'column_name'	=> 'adblock'
				);
				$message_data		=	array(
					'sender_id'		=>	ADMIN_ID,
					'receiver_id'	=>	$account_id,
					'subject'		=>	'Publisher - Adblock',
					'content'		=> 	'Adblock Add/Update successfully',
					'image_name'	=>	NULL,
					'file_name'		=>	NULL,
					'account_type'	=>	"TRAFFICKER",
					'status'		=>	'1',
					'network_id'	=>	$network_id,
					'notification_type'	=>	"adcodes",										
					'date'			=>	date('Y-m-d H:i:s')
					);
					
													
			$admin_name   =$user['first_name'].' '.$user['last_name'];	
			$admin_email   =$user['email'];
			$user_email    =$reciever['email'];
			$user_name     =$reciever['name'];
			$from 		   = $admin_email;
			$to  		   = $user_email;		
									
				$mail_content=array(
						"subject" 	   => "Adblock add/update",
						"to_name" 	   => $user_name,				
						"from_name"	   => $admin_name,
					 
						"zonename"   => $this->post('adblock_name')
						 
					);
						$attachement='';
					
					
			$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details,$mail_content);
					
					
					/***************************************/	
					$this->response($success, 200);
				}
				else
				{
					$error = array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Error! Please try Again..'
							);	
				
					$this->response($error, 200);
				}					
		
			}else{
				$error = array(
								'response' => 'error',
								'msg'	 => 'Not an valid accountid!..'
				);	
				
				$this->response($error, 200);
			}
		}

	}
	
	/*********************** AD CODE GENERATION *********************/
	
	/**
       * 
       * name : generate_adtags_post()
       * 
       * Generates the Ad tags with custom settings
       * 
       * @return the generated response
    */
	
	
	public function generate_adtags_post()
	{
		
		$zone_id 	= 	$this->post('id');	
		
		if($zone_id)
		{			
			$adblock_tag 	= 	$this->generate_adblock_tag($this->post());
			
			$success 		= 	array(
									'response'	=>	'ok',
									'msg'		=>	$adblock_tag
									);	
			
			$this->response($success);
			
		}else{
			
			$error = array(
							'response' 	=> 'error',
							'msg'	 	=> 'Adblock id is not found'
					);
			
			$this->response( $error, 200);
		}
	}	
	
	public function generate_adblock_tag($values =FALSE)
	{
		$site_url 		= 	$this->config->item("adserving_url");		
		$path 			= 	$site_url.$values['adbtype'];
		
						
		if($values['adbtype']!='' && $values['adbtype']!='iframe' && $values['adbtype']!='layer_iframe' )
		{
			$adbtype	=	$values['adbtype'];
			unset($values['api_key']);
			unset($values['adbtype']);	
			
			//Remove empty values		
			foreach($values as $key=>$value)
			{
				if($value=='')
				{
					unset($values[$key]);
				}
			}
			
			$encoded_string =	http_build_query($values);
			
			if($adbtype=='direct')
			{			
				$code	=	$path.'.php?'.$encoded_string;	
			}
			else
			{
				$code	=	'<script type="text/javascript" src="'.$path.'.js?'.$encoded_string.'"></script>';
			}		
		}
		else if($values['adbtype']=='iframe' || $values['adbtype']=='layer_iframe')
		{
			$ran1 	= 	'a'.substr(md5(uniqid('', 1)), 0, 7);	
			
			$code	=	"<iframe id='".$ran1."' name='".$ran1."' src='".$site_url.$values['adbtype'].".php?reload=".$values['refresh_val']."&id=".$values['id']."&target=_blank&cb=INSERT_RANDOM_NUMBER_HERE' frameborder='0' scrolling='no' width='".$values['width']."' height='".(($values['adbtype']=='layer_iframe')?$values['height']+200:$values['height'])."' ></iframe>";
		}
		else
		{
			$code	=	'<script type="text/javascript" src="'.$site_url.'banners.js?id='.$values['id'].'"></script>';
		}
						
		return $code;	
	}
	
	
	public function generate_adblock_video_tag($values =FALSE)
	{
		$site_url 		= 	$this->config->item("adserving_url");		
		$path 			= 	$site_url.$values['adbtype'];
										
		if($values['adbtype']!='' && $values['adbtype']!='iframe' && $values['adbtype']!='layer_iframe' )
		{
			$adbtype	=	$values['adbtype'];
			unset($values['api_key']);
			unset($values['adbtype']);	
			
			//Remove empty values		
			foreach($values as $key=>$value)
			{
				if($value=='')
				{
					unset($values[$key]);
				}
			}
			
			$encoded_string =	http_build_query($values);
			
			if($adbtype=='direct')
			{			
				$code	=	$path.'.php?'.$encoded_string;	
			}
			else if($adbtype=='inline')
			{
				$player=$values['inplayer'];
				$roll=$values['roll'];
				$vast_version=$values['vast_version'];
				if($roll=='1'){$roll_val="preroll";}if($roll=='2'){$roll_val="midroll";}if($roll=='3'){$roll_val="postroll";}
				$limit=$values['limit'];
				  if($player=='4')
				  {
					  
					  if(!empty($limit) && ($vast_version=='vast_pod' || $vast_version=='vast_pod_wrapper'))
					  {
						  $code= $site_url."fc.php?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&zones=".$roll_val.":0.0-0%3D".$values['id']."&nz=1&source=&r=R0.05822725687175989&block=1&limit=".$limit."&format=".$vast_version."&charset=UTF-8";
					  }
					  else
					  {
						  $code= $site_url."fc.php?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&zones=".$roll_val.":0.0-0%3D".$values['id']."&nz=1&source=&r=R0.05822725687175989&block=1&format=".$vast_version."&charset=UTF-8";
					  }
					
				  }
				  else if($player=="3")
				  {
					 $code	=	'<script type="text/javascript" src="'.$site_url.'inline.js?id='.$values['id'].'"></script>';
				  }
				  else
				  {
					 $code	=	'<script type="text/javascript" src="'.$site_url.'inline.js?id='.$values['id'].'"></script>';
				  }
			}
			
			else if($adbtype=='overlay')
			{					
				$player=$values['ol_player'];
				$vast_version=$values['vast_version'];
				$roll_val="overlay"; 
				if($player=='4')
				  {					 
					 $code= $site_url."fc.php?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&zones=".$roll_val.":0.0-0%3D".$values['id']."&nz=1&source=&r=R0.05822725687175989&block=1&format=".$vast_version."&charset=UTF-8";					  		
				  }
				  else if($player=="3")
				  {					
					 $code	=	'<script type="text/javascript" src="'.$site_url.'overlay.js?id='.$values['id'].'"></script>';
				  }
				  else
				  {					
					 $code	=	'<script type="text/javascript" src="'.$site_url.'overlay.js?id='.$values['id'].'"></script>';
				  }
			}			
			else
			{
				$code	=	'<script type="text/javascript" src="'.$path.'.js?'.$encoded_string.'"></script>';
			}		
		}
		else if($values['adbtype']=='iframe' || $values['adbtype']=='layer_iframe')
		{
			$ran1 	= 	'a'.substr(md5(uniqid('', 1)), 0, 7);	
			
			$code	=	"<iframe id='".$ran1."' name='".$ran1."' src='".$site_url.$values['adbtype'].".php?refresh=".$values['refresh_val']."&id=".$values['id']."&target=_blank&cb=INSERT_RANDOM_NUMBER_HERE' frameborder='0' scrolling='no' width='".$values['width']."' height='".(($values['adbtype']=='layer_iframe')?$values['height']+200:$values['height'])."' ></iframe>";
		}
		else
		{
			$code	=	'<script type="text/javascript" src="'.$site_url.'banners.js?id='.$values['id'].'"></script>';
		}
						
		return $code;	
	}	
	
	/** 
     * name: top_bottom_adblock_post
     * @params : account_id and zone_id
     * 
     * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
    
	public function top_bottom_adblock_post()
	{					
		#$account_id 	= 	$this->get('account_id');
		$user_auth  	= 	$this->user_authentication;
		$account_id 	= 	$user_auth->account_id;
		$site_id	   	= 	$this->post('site_id');
		$zone	=	array(	'width'	=>	$this->post('width'),
							'height'=>	$this->post('height')
						);
		
		if($account_id){	
			$adb_list 	= 	$this->do_site->fetch_topbottom_adblocks($account_id,$site_id,$zone);
			if($adb_list)
			{
				$this->response($adb_list);	
			}
			else
			{
				$this->response('error',200);
			}
		}
	}		
	
	/************************** Save Tag settings *************************/
	
	public function save_tag_settings_post()
	{
		if($this->user_authentication->account_type=='TRAFFICKER')
		{			
			$account_id  = 	$this->user_authentication->account_id;
		}
		else
		{
					
			$zone_id 	= 	$this->post('id');			
			$aff_list 	= 	$this->do_site->fetch_affiliate_zone($zone_id);		
			$account_id =   $aff_list[0]['account_id'];							
		}				
		
		$zoneid 	= 	$this->post('id');	
				
		if($zoneid)
		{	
			//Common Parameters
			if($this->post('adbtype')=='popup' || $this->post('adbtype')=='popunder' || $this->post('adbtype')=='inline' || $this->post('adbtype')=='real' || $this->post('adbtype')=='small' || $this->post('adbtype')=='box' || $this->post('adbtype')=='head' || $this->post('adbtype')=='overlay')
			{
				$auto_reload			=	-1;
				$reload_time			=	-1;				
				$views_count			=	-1;
				$views_time				=	-1;
				$reload_trigger			=	-1;
			}
			else
			{
				if($this->post('banner_autoload')=='enable')
				{
					$auto_reload			=	$this->post('autoreload');
					$reload_time 			=	($this->post('autoreload')!=0)?$this->post('reloadtime'):-1;
				}
				else
				{
					$auto_reload			=	-1;
					$reload_time			=	-1;
				}
				
				$reload_trigger			=	 ($this->post('trigger_option'))?$this->post('trigger_option'):-1;
								
				
				if($this->post('adbtype')=='layer' || $this->post('adbtype')=='catfish'|| $this->post('adbtype')=='slider')
				{
						//$time_set=$this->post('time_set');	
					//	$views_count			=	(clean_data($this->post('session_cap_zone')))?clean_data($this->post('session_cap_zone')):-1;
					//	$views_time				=	(clean_data($this->post('block_zone')))?clean_data($this->post('block_zone')):-1;
					
					if($time_set=="min")
					{
						$views_time=$this->post('layer_block_zone')*60;
					}
					else if($time_set=="hour")
					{
						$views_time=$this->post('layer_block_zone')*3600;
					}
					elseif($time_set=="day")
					{
						$views_time=$this->post('layer_block_zone')*86400;
					}
					else
					{
						$views_time=$this->post('layer_block_zone');
					}	

					$views_count			=	($this->post('layer_session_cap_zone'))?$this->post('layer_session_cap_zone'):-1;
					
				}
				else
				{ 
					$views_count			=	($this->post('session_cap_zone'))?$this->post('session_cap_zone'):-1;
					$views_time				=	($this->post('block_zone'))?$this->post('block_zone'):-1;
				}
			}				
				
			//Popup/popunder Parameters
			$popup_count			=	-1;
			$popup_time				=	-1;
			$popup_time_setting		=	-1;
			$pcwr					=	-1;
			$pcwor					=	-1;
			$pdwr					=	-1;
			$pdwor					=	-1;
			
			//Layer/Slider Parameters
			$width					=	-1;
			$height					=	-1;
			$time_setting			=   '';
			$layer_position         =   '';
			$float_position			=	'';
			$clicks_count			=	'';
			$clicks_time			=	'';
			$automatic_close		=	'';
			$automatic_close_time   =   '';
			$auto_scroll			=	'';
			$layer_border			=	'';
			$layer_border_option    =	'';
			$border_backgroundcolor	=	'';			
			$title					=	'';
			$color_style			=	-1;
			$border_color			=	'';
			$mouseover_color		=	'';
			$background_color		=	'';
			$exit_link_color		=	'';
			$title_color			=	'';
			$exit_link				=	-1;
			$frame_url				=	'';
			$exit_link_text			=	'';
			$close_link_position	=	'';
			$top_banner				=	-1;
			$top_adblock			=	-1;
			$bottom_banner			=	-1;
			$bottom_adblock			=	-1;
			$top_background_color	=	'';
			$bottom_background_color=	'';
			$layer_top_option    	=	'';
			$layer_bottom_option    =	'';
			
			//Gamebox Parameters
			$border					=	-1;
			$size					=	-1;
			$ads_count				=	-1;
			$disable_title			=	-1;										
			$auto_scrolling			=	-1;
			$scroll_time			=	-1;
			
			//Bannerbox Parameters
			$title_background_color	=	'';
			$title_link_color		=	'';
			$show_website_url		=	-1;
			$position				=	'';
			$show_website_description=	-1;			
			$website_background_color=	'';
			$banner_background_color=	'';
			
			//Site-skin parameters
			$content_width			=	-1;
			$left_offset 			=	-1;
			$top_offset				=	-1;
			$right_offset			=	-1;
			$z_index				=	0;
			$fixed					=	-1;
			$hide					=	'';
			
			//Inline/overlay parameters
			$vast_version		=	'';
			$player				=	-1;
			$width				=	-1;
			$height				=	-1;
			$video_type			=	-1;
			$progressive_url	=	'';
			$streaming_url		=	'';
			$rtmp_file			=	'';
			$image_url			=	'';
			$auto_play			=	-1;
			$show_companion		=	-1;
			$companion_width	=	-1;
			$companion_height	=	-1;
			$ad_position		=	-1;
			$ad_schedule		=	-1;
			$limit				=   -1;
			$html_video_url     =   '';
					
			if($this->post('adbtype')=='popup' || $this->post('adbtype')=='popunder')
			{
				$popup_count			=	($this->post('popcount'))?$this->post('popcount'):-1;
				$popup_time				=	($this->post('popresettime'))?$this->post('popresettime'):-1;
				$popup_time_setting		=	($this->post('pop_time_set'))?$this->post('pop_time_set'):-1;  
				
				    if($popup_time_setting=="min")
					{
						$popup_time=$this->post('popresettime')*60;  
					}
					else if($popup_time_setting=="hour")
					{
						$popup_time=$this->post('popresettime')*3600;
					}
					elseif($popup_time_setting=="day")
					{
						$popup_time=$this->post('popresettime')*86400;
					}
					else
					{
						$popup_time=$this->post('popresettime');
					}						
					
				$pcwr					=	($this->post('pcwr'))?$this->post('pcwr'):-1;
				$pcwor					=	($this->post('pcwor'))?$this->post('pcwor'):-1;
				$pdwr					=	($this->post('pdwr'))?$this->post('pdwr'):-1;
				$pdwor					=	($this->post('pdwor'))?$this->post('pdwor'):-1;								
			}
			elseif($this->post('adbtype')=='web_inters' || $this->post('adbtype')=='mob_interstital')
			{
				$exit_link				=	$this->post('exits');
				$frame_url				=	($this->post('exit_url') && $this->post('exits')==3)?$this->post('exit_url'):'';
			}
			elseif($this->post('adbtype')=='layer')
			{
				$reload_trigger			=   ($this->post('trigger_option'))?$this->post('trigger_option'):-1;
				$width					=	($this->post('width'))?$this->post('width'):-1;
				$height					=	($this->post('height'))?$this->post('height'):-1;
				$time_setting			=	($this->post('time_set'))?$this->post('time_set'):'';
				$layer_position			=	($this->post('layer_position'))?$this->post('layer_position'):'';
				$float_position			=	($this->post('position'))?$this->post('position'):'';
				$clicks_count			=	($this->post('clicks_session_cap_zone'))?$this->post('clicks_session_cap_zone'):'';
				$clicks_time			=	($this->post('clicks_block_zone'))?$this->post('clicks_block_zone'):'';
				$automatic_close		=	($this->post('automatically_close'))?$this->post('automatically_close'):'';
				$automatic_close_time   =   ($this->post('automatically_close_time'))?$this->post('automatically_close_time'):'';
				$auto_scroll			=	($this->post('auto_scroll'))?$this->post('auto_scroll'):'';
				$layer_border			=	($this->post('layer_border'))?$this->post('layer_border'):'';
				$layer_border_option    =	($this->post('layer_border_option'))?$this->post('layer_border_option'):'';
				if($layer_border_option!="yes")
				{
					$border_backgroundcolor	=	($this->post('border_backgroundcolor'))?$this->post('border_backgroundcolor'):'';							
				}			
				$disable_title			=	$this->post('layer_title');										
				$title					=	($this->post('layer_title')==2 || $this->post('layer_title')==3)?(($this->post('layer_title')==2)?$this->post('layer_custom_text'):$this->post('layer_custom_link')):'';
				$border					=	($this->post('lborder') || $this->post('lborder')==0)?$this->post('lborder'):-1;
				$border_color			=	($this->post('bordercolor') && $this->post('lborder')==1)?$this->post('bordercolor'):'';
				$color_style			=	$this->post('layerstyle');
				$background_color		=	($this->post('backgroundcolor') && $this->post('layerstyle')==1)?$this->post('backgroundcolor'):'';
				$exit_link_color		=	($this->post('exitcolor') && $this->post('layerstyle')==1)?$this->post('exitcolor'):'';
				$title_color			=	($this->post('titlecolor') && $this->post('layerstyle')==1)?$this->post('titlecolor'):'';
				$exit_link				=	$this->post('exit');
				$frame_url				=	($this->post('exit_url') && $this->post('exit')==3)?$this->post('exit_url'):'';
				$exit_link_text			=	($this->post('close_txt'))?$this->post('close_txt'):'';
				$close_link_position	=	($this->post('close_position'))?$this->post('close_position'):'';
				$top_banner				=	$this->post('top');
				$top_adblock			=	($this->post('topzone') && $this->post('top')==1)?$this->post('topzone'):-1;
				$layer_top_option    	=	($this->post('layer_top_option'))?$this->post('layer_top_option'):'';
				$bottom_banner			=	$this->post('bottom');
				$bottom_adblock			=	($this->post('bottomzone') && $this->post('bottom')==1)?$this->post('bottomzone'):-1;
				$layer_bottom_option    =	($this->post('layer_bottom_option'))?$this->post('layer_bottom_option'):'';
				if($layer_top_option!='yes')
				{
					$top_background_color	=	($this->post('top_backgroundcolor'))?$this->post('top_backgroundcolor'):'';
				}
				if($layer_bottom_option!='yes')
				{
					$bottom_background_color=	($this->post('bottom_backgroundcolor'))?$this->post('bottom_backgroundcolor'):'';
				}
				
			}
			elseif($this->post('adbtype')=='slider')
			{
				$reload_trigger			=   ($this->post('trigger_option'))?$this->post('trigger_option'):-1;
				$width 					=	($this->post('width'))?$this->post('width'):-1;
				$height					=	($this->post('height'))?$this->post('height'):-1;
				$time_setting			=	($this->post('time_set'))?$this->post('time_set'):'';
				$clicks_count			=	($this->post('clicks_session_cap_zone'))?$this->post('clicks_session_cap_zone'):'';
				$clicks_time			=	($this->post('clicks_block_zone'))?$this->post('clicks_block_zone'):'';				
				$automatic_close		=	($this->post('automatically_close'))?$this->post('automatically_close'):'';
				$automatic_close_time   =   ($this->post('automatically_close_time'))?$this->post('automatically_close_time'):'';
				$auto_scroll			=	($this->post('sauto_scroll'))?$this->post('sauto_scroll'):'';
				$float_position			=	($this->post('direction'))?$this->post('direction'):'';
				$disable_title			=	$this->post('slider_title');										
				$title					=	($this->post('slider_title')==2 || $this->post('slider_title')==3)?(($this->post('slider_title')==2)?$this->post('slider_custom_text'):$this->post('slider_custom_link')):'';
				$border					=	($this->post('sborder') || $this->post('sborder')==0)?$this->post('sborder'):-1;
				$border_color			=	($this->post('bordercolor') && $this->post('sborder')==1)?$this->post('bordercolor'):'';
				$color_style			=	$this->post('sliderstyle');
				$background_color		=	($this->post('backgroundcolor') && $this->post('sliderstyle')==1)?$this->post('backgroundcolor'):'';
				$exit_link_color		=	($this->post('exitcolor') && $this->post('sliderstyle')==1)?$this->post('exitcolor'):'';
				$title_color			=	($this->post('titlecolor') && $this->post('sliderstyle')==1)?$this->post('titlecolor'):'';
				$exit_link				=	$this->post('sexit');
				$frame_url				=	($this->post('exit_url') && $this->post('sexit')==3)?$this->post('exit_url'):'';
				$exit_link_text			=	($this->post('close_txt'))?$this->post('close_txt'):'';
				$close_link_position	=	($this->post('close_position'))?$this->post('close_position'):'';
			}
			elseif($this->post('adbtype')=='gamebox')
			{
				$border					=	($this->post('border') || $this->post('border')==0)?$this->post('border'):-1;
				$border_color			=	($this->post('bordercolor') && $this->post('border')==1)?$this->post('bordercolor'):'';
				$size					=	$this->post('direction');
				$width 					=	($this->post('width'))?$this->post('width'):-1;
				$height					=	($this->post('height'))?$this->post('height'):-1;
				$ads_count				=	($this->post('gamecount'))?$this->post('gamecount'):-1;
				$disable_title			=	$this->post('disable_title');										
				$title					=	($this->post('title') && $this->post('disable_title')==0)?$this->post('title'):'';
				$title_color			=	($this->post('titlecolor') && $this->post('disable_title')==0)?$this->post('titlecolor'):'';
				$auto_scrolling			=	$this->post('scroll');
				$scroll_time			=	($this->post('scrolltime') && $this->post('scroll')==1)?$this->post('scrolltime'):-1;
			}
			elseif($this->post('adbtype')=='bannerbox')
			{
				$size					=	$this->post('direction');
				$width 					=	($this->post('width'))?$this->post('width'):-1;
				$height					=	($this->post('height'))?$this->post('height'):-1;
				$ads_count				=	($this->post('bannercount'))?$this->post('bannercount'):-1;
				$disable_title			=	$this->post('bdisable_title');
				$title					=	($this->post('title') && $this->post('bdisable_title')==0)?$this->post('title'):'';
				$title_background_color	=	($this->post('title_backgroundcolor') && $this->post('bdisable_title')==0)?$this->post('title_backgroundcolor'):'';
				$title_link_color		=	($this->post('title_linkcolor') && $this->post('bdisable_title')==0)?$this->post('title_linkcolor'):'';
				$show_website_url		=	$this->post('website_url');
				$position				=	($this->post('urlposition') && $this->post('website_url')==1)?$this->post('urlposition'):'';
				$show_website_description=	$this->post('wdescription');
				$border_color			=	($this->post('bordercolor'))?$this->post('bordercolor'):'';
				$website_background_color=	($this->post('website_backgroundcolor'))?$this->post('website_backgroundcolor'):'';
				$banner_background_color=	($this->post('banner_backgroundcolor'))?$this->post('banner_backgroundcolor'):'';
			}
			elseif($this->post('adbtype')=='catfish')
			{
				$reload_trigger			=   ($this->post('trigger_option'))?$this->post('trigger_option'):-1;
				$time_setting			=	($this->post('time_set'))?$this->post('time_set'):'';
				$background_color		=	($this->post('backgroundcolor'))?$this->post('backgroundcolor'):'';
				$border					=	($this->post('cborder') || $this->post('cborder')==0)?$this->post('cborder'):-1;
				$border_color			=	($this->post('bordercolor') && $this->post('cborder')==1)?$this->post('bordercolor'):'';
				$mouseover_color		=	($this->post('mouseovercolor'))?$this->post('mouseovercolor'):'';
				$close_link_position	=	($this->post('close_position'))?$this->post('close_position'):'';
				$clicks_count			=	($this->post('clicks_session_cap_zone'))?$this->post('clicks_session_cap_zone'):'';
				$clicks_time			=	($this->post('clicks_block_zone'))?$this->post('clicks_block_zone'):'';								
			}
			elseif($this->post('adbtype')=='site-skin')
			{
				$content_width			=	($this->post('contentWidth'))?$this->post('contentWidth'):-1;
				$left_offset 			=	($this->post('leftpadding'))?$this->post('leftpadding'):-1;
				$top_offset				=	($this->post('topOffset'))?$this->post('topOffset'):-1;
				$right_offset			=	($this->post('rightpadding'))?$this->post('rightpadding'):-1;
				$z_index				=	($this->post('zindex'))?$this->post('zindex'):0;
				$fixed					=	$this->post('fixed');
				$hide					=	($this->post('hide'))?$this->post('hide'):'';
			}
			elseif($this->post('adbtype')=='inline')
			{
				$player				=	($this->post('inplayer'))?$this->post('inplayer'):-1;
				$width				=	($this->post('pwidth'))?$this->post('pwidth'):-1;
				$height				=	($this->post('pheight'))?$this->post('pheight'):-1;
				$video_type			=	($this->post('ptype'))?$this->post('ptype'):-1;
				$progressive_url	=	($this->post('pvideo') && $this->post('ptype')==1)?$this->post('pvideo'):'';
				$streaming_url		=	($this->post('rtmpurl') && $this->post('ptype')==2)?$this->post('rtmpurl'):'';
				$rtmp_file			=	($this->post('rtmpfile') && $this->post('ptype')==2)?$this->post('rtmpfile'):'';
				$image_url			=	($this->post('pimg'))?$this->post('pimg'):'';
				$auto_play			=	($this->post('autoplay'))?$this->post('autoplay'):-1;
				$show_companion		=	$this->post('incompad');
				$companion_width	=	($this->post('cwidth') && $this->post('incompad')==1)?$this->post('cwidth'):-1;
				$companion_height	=	($this->post('cheight') && $this->post('incompad')==1)?$this->post('cheight'):-1;
				$ad_position		=	($this->post('oposition'))?$this->post('oposition'):-1;
				$ad_schedule		=	($this->post('adstime') && $this->post('oposition')==2)?$this->post('adstime'):-1;
				$vast_version       =   ($this->post('vast_version'))?$this->post('vast_version'):'';
				$limit       		=   ($this->post('limit'))?$this->post('limit'):-1;
				$html_video_url     =   ($this->post('html_video_url'))?$this->post('html_video_url'):'';
			}
			elseif($this->post('adbtype')=='real')
			{
				$player				=	($this->post('inplayer'))?$this->post('inplayer'):-1;
				$width				=	($this->post('pwidth'))?$this->post('pwidth'):-1;
				$height				=	($this->post('pheight'))?$this->post('pheight'):-1;
				$video_type			=	($this->post('ptype'))?$this->post('ptype'):-1;
				$progressive_url	=	($this->post('pvideo') && $this->post('ptype')==1)?$this->post('pvideo'):'';
				$streaming_url		=	($this->post('rtmpurl') && $this->post('ptype')==2)?$this->post('rtmpurl'):'';
				$rtmp_file			=	($this->post('rtmpfile') && $this->post('ptype')==2)?$this->post('rtmpfile'):'';
				$image_url			=	($this->post('pimg'))?$this->post('pimg'):'';
				$auto_play			=	($this->post('autoplay'))?$this->post('autoplay'):-1;
				$show_companion		=	$this->post('incompad');
				$companion_width	=	($this->post('cwidth') && $this->post('incompad')==1)?$this->post('cwidth'):-1;
				$companion_height	=	($this->post('cheight') && $this->post('incompad')==1)?$this->post('cheight'):-1;
				$ad_position		=	($this->post('oposition'))?$this->post('oposition'):-1;
				$ad_schedule		=	($this->post('adstime') && $this->post('oposition')==2)?$this->post('adstime'):-1;
			}
			
			elseif($this->post('adbtype')=='small')
			{
				$player				=	($this->post('inplayer'))?$this->post('inplayer'):-1;
				$width				=	($this->post('pwidth'))?$this->post('pwidth'):-1;
				$height				=	($this->post('pheight'))?$this->post('pheight'):-1;
				$video_type			=	($this->post('ptype'))?$this->post('ptype'):-1;
				$progressive_url	=	($this->post('pvideo') && $this->post('ptype')==1)?$this->post('pvideo'):'';
				$streaming_url		=	($this->post('rtmpurl') && $this->post('ptype')==2)?$this->post('rtmpurl'):'';
				$rtmp_file			=	($this->post('rtmpfile') && $this->post('ptype')==2)?$this->post('rtmpfile'):'';
				$image_url			=	($this->post('pimg'))?$this->post('pimg'):'';
				$auto_play			=	($this->post('autoplay'))?$this->post('autoplay'):-1;
				$show_companion		=	$this->post('incompad');
				$companion_width	=	($this->post('cwidth') && $this->post('incompad')==1)?$this->post('cwidth'):-1;
				$companion_height	=	($this->post('cheight') && $this->post('incompad')==1)?$this->post('cheight'):-1;
				$ad_position		=	($this->post('oposition'))?$this->post('oposition'):-1;
				$ad_schedule		=	($this->post('adstime') && $this->post('oposition')==2)?$this->post('adstime'):-1;
			}
			
			elseif($this->post('adbtype')=='box')
			{
				$player				=	($this->post('inplayer'))?$this->post('inplayer'):-1;
				$width				=	($this->post('pwidth'))?$this->post('pwidth'):-1;
				$height				=	($this->post('pheight'))?$this->post('pheight'):-1;
				$video_type			=	($this->post('ptype'))?$this->post('ptype'):-1;
				$progressive_url	=	($this->post('pvideo') && $this->post('ptype')==1)?$this->post('pvideo'):'';
				$streaming_url		=	($this->post('rtmpurl') && $this->post('ptype')==2)?$this->post('rtmpurl'):'';
				$rtmp_file			=	($this->post('rtmpfile') && $this->post('ptype')==2)?$this->post('rtmpfile'):'';
				$image_url			=	($this->post('pimg'))?$this->post('pimg'):'';
				$auto_play			=	($this->post('autoplay'))?$this->post('autoplay'):-1;
				$show_companion		=	$this->post('incompad');
				$companion_width	=	($this->post('cwidth') && $this->post('incompad')==1)?$this->post('cwidth'):-1;
				$companion_height	=	($this->post('cheight') && $this->post('incompad')==1)?$this->post('cheight'):-1;
				$ad_position		=	($this->post('oposition'))?$this->post('oposition'):-1;
				$ad_schedule		=	($this->post('adstime') && $this->post('oposition')==2)?$this->post('adstime'):-1;
			}
			
			elseif($this->post('adbtype')=='head')
			{
				$player				=	($this->post('inplayer'))?$this->post('inplayer'):-1;
				$width				=	($this->post('pwidth'))?$this->post('pwidth'):-1;
				$height				=	($this->post('pheight'))?$this->post('pheight'):-1;
				$video_type			=	($this->post('ptype'))?$this->post('ptype'):-1;
				$progressive_url	=	($this->post('pvideo') && $this->post('ptype')==1)?$this->post('pvideo'):'';
				$streaming_url		=	($this->post('rtmpurl') && $this->post('ptype')==2)?$this->post('rtmpurl'):'';
				$rtmp_file			=	($this->post('rtmpfile') && $this->post('ptype')==2)?$this->post('rtmpfile'):'';
				$image_url			=	($this->post('pimg'))?$this->post('pimg'):'';
				$auto_play			=	($this->post('autoplay'))?$this->post('autoplay'):-1;
				$show_companion		=	$this->post('incompad');
				$companion_width	=	($this->post('cwidth') && $this->post('incompad')==1)?$this->post('cwidth'):-1;
				$companion_height	=	($this->post('cheight') && $this->post('incompad')==1)?$this->post('cheight'):-1;
				$ad_position		=	($this->post('oposition'))?$this->post('oposition'):-1;
				$ad_schedule		=	($this->post('adstime') && $this->post('oposition')==2)?$this->post('adstime'):-1;
			}
			
			
			elseif($this->post('adbtype')=='overlay')
			{
				$player				=	($this->post('olplayer'))?$this->post('olplayer'):-1;
				$width				=	($this->post('pwidth'))?$this->post('pwidth'):-1;
				$height				=	($this->post('pheight'))?$this->post('pheight'):-1;
				$video_type			=	($this->post('ptype'))?$this->post('ptype'):-1;
				$progressive_url	=	($this->post('pvideo') && $this->post('ptype')==1)?$this->post('pvideo'):'';
				$streaming_url		=	($this->post('rtmpurl') && $this->post('ptype')==2)?$this->post('rtmpurl'):'';
				$rtmp_file			=	($this->post('rtmpfile') && $this->post('ptype')==2)?$this->post('rtmpfile'):'';
				$image_url			=	($this->post('pimg'))?$this->post('pimg'):'';
				$auto_play			=	($this->post('autoplay'))?$this->post('autoplay'):-1;
				$show_companion		=	$this->post('olcompad');
				$companion_width	=	($this->post('cwidth') && $this->post('olcompad')==1)?$this->post('cwidth'):-1;
				$companion_height	=	($this->post('cheight') && $this->post('olcompad')==1)?$this->post('cheight'):-1;
				$ad_schedule		=	($this->post('adstime'))?$this->post('adstime'):-1;
				$vast_version       =   ($this->post('overlay_vast_version'))?$this->post('overlay_vast_version'):'';				
			}	
							
			$tag_parameters	=	array(
										'tag_id'						=>	$zoneid,
										'publisher_id'					=>	$account_id,
										'auto_reload'					=>	$auto_reload,
										'reload_time' 					=>	$reload_time,
										'views_count'					=>	$views_count,
										'views_time'					=>	$views_time,
										'time_setting'                  =>  $time_setting,
										'reload_trigger'				=>	$reload_trigger,
										'popup_count' 					=>	$popup_count,
										'popup_time'					=>	$popup_time,
										'popup_time_setting'            =>  $popup_time_setting,
										'popup_count_with_reload'		=>	$pcwr,
										'popup_count_without_reload'	=>	$pcwor,
										'popup_delay_with_reload'		=>	$pdwr,
										'popup_delay_without_reload'	=>	$pdwor,										
										'width' 						=>	$width,
										'height'						=>	$height,
										'float_position'				=>	$float_position,
										'layer_position'				=>	$layer_position,
										'clicks_count'					=>  $clicks_count,
										'clicks_time'					=>	$clicks_time,
										'automatically_close'			=>	$automatic_close,
										'automatically_close_time'   	=>  $automatic_close_time,
										'auto_scroll'			        =>  $auto_scroll,
										'layer_border'			        =>	$layer_border,
										'layer_border_option'           =>  $layer_border_option,
										'border_backgroundcolor'        =>  $border_backgroundcolor,										
										'title'							=>	$title,
										'color_style'					=>	$color_style,
										'border_color'					=>	$border_color,
										'background_color'				=>	$background_color,
										'exit_link_color'				=>	$exit_link_color,
										'title_color'					=>	$title_color,
										'exit_link'						=>	$exit_link,
										'frame_url'						=>	$frame_url,
										'exit_link_text'				=>	$exit_link_text,
										'close_link_position'			=>	$close_link_position,
										'top_banner'					=>	$top_banner,
										'top_adblock'					=>	$top_adblock,
										'layer_top_option'              =>  $layer_top_option,
										'layer_bottom_option'           =>  $layer_bottom_option,
										'bottom_banner'					=>	$bottom_banner,
										'bottom_adblock'				=>	$bottom_adblock,
										'top_backgroundcolor'			=>	$top_background_color,
										'bottom_backgroundcolor'        =>  $bottom_background_color,
										'border'						=>	$border,										
										'size'							=>	$size,										
										'ads_count'						=>	$ads_count,
										'disable_title'					=>	$disable_title,
										'auto_scrolling'				=>	$auto_scrolling,
										'scroll_time'					=>	$scroll_time,
										'title_background_color'		=>	$title_background_color,
										'title_link_color'				=>	$title_link_color,
										'show_website_url'				=>	$show_website_url,										
										'position'						=>	$position,
										'show_website_description'		=>	$show_website_description,
										'website_background_color'		=>	$website_background_color,
										'banner_background_color'		=>	$banner_background_color,
										'content_width'					=>	$content_width,
										'left_offset' 					=>	$left_offset,
										'top_offset'					=>	$top_offset,
										'right_offset'					=>	$right_offset,
										'z_index'						=>	$z_index,										
										'fixed'							=>	$fixed,										
										'hide'							=>	$hide,										
										'player'						=>	$player,
										'video_type'					=>	$video_type,
										'progressive_url'				=>	$progressive_url,
										'streaming_url'					=>	$streaming_url,
										'rtmp_file'						=>	$rtmp_file,
										'image_url'						=>	$image_url,
										'auto_play'						=>	$auto_play,
										'show_companion'				=>	$show_companion,
										'companion_width'				=>	$companion_width,
										'companion_height'				=>	$companion_height,
										'ad_position'					=>	$ad_position,
										'ad_schedule'					=>	$ad_schedule,
										'mouseover_color'				=>	$mouseover_color,
										'vast_version'                  =>  $vast_version,
										'limit'                         =>  $limit,
										'html_video_url'                =>  $html_video_url
									);	
			$where	=	array(
								'tag_id'		=>	$zoneid,
								'publisher_id'	=>	$account_id
							);
							
			$tagparam	=	$this->do_site->fetch_tag_parameters($where);
			
			if($tagparam!=FALSE)
			{
				$tag 	= 	$this->do_site->update_tag_parameters($where,$tag_parameters);
				
			}
			else
			{
				$tag 	= 	$this->do_site->add_tag_parameters($tag_parameters);
				
			}			
			
			if($tag)
			{
				
				/* Memcache start*/
				
				$mc = new Memcached();

				$isMemcacheAvailable=$mc->addServer("127.0.0.1", 11211);

				if ($isMemcacheAvailable)
				{
					$key="id_".$zoneid;
							
					$mc->set($key,$tag_parameters);	
				}		
				
				/* Memcache -End*/			 
				
				
				$ad_type=$this->post('adbtype');
				$in_player=$this->post('inplayer');				
				$ol_player=$this->post('olplayer');
								
								
				if(!empty($ad_type) && $in_player!='')
				{
					$vast_version=$this->post('vast_version');
					$roll=$this->post('oposition');
					$values['adbtype']=$ad_type;
					$values['inplayer']=$in_player;
					$values['vast_version']=$vast_version;
					$values['roll']=$roll; 
					$values['id']=$zoneid;
					$values['limit']=$limit;
					
					
					$adblock_tag 	= 	$this->generate_adblock_video_tag($values);
														
					$success 		= 	array(
									'response'	=>	'ok',
									'msg'		=>	$adblock_tag,
									'inplayer'  =>  $in_player  
									);	
				}
				else if(!empty($ad_type) && $ol_player!='')
				{
					$vast_version=$this->post('overlay_vast_version');
					$values['vast_version']=$vast_version;
					$values['adbtype']=$ad_type;
					$values['ol_player']=$ol_player;					
					$values['id']=$zoneid;
					
					$adblock_tag 	= 	$this->generate_adblock_video_tag($values);
														
					$success 		= 	array(
									'response'	=>	'ok',
									'msg'		=>	$adblock_tag,
									'inplayer'  =>  $ol_player  
									);
				}
				else
				{
					$adblock_tag 	= 	$this->generate_adblock_tag($this->post());
					
					$success 		= 	array(
									'response'	=>	'ok',
									'msg'		=>	$adblock_tag
									);	
				}			
				$this->response($success);
			}
			else
			{
				$error = array(
							'response' 	=> 'error',
							'msg'	 	=> 'Error! please try again...'
					);
			
				$this->response( $error, 200);
			}		
			
		}else{
			
			$error = array(
							'response' 	=> 'error',
							'msg'	 	=> 'Adblock id is not found'
					);
			
			$this->response( $error, 200);
		}
	}
	
	/** 
    * name: top_bottom_adblock_post
    * @params : account_id and zone_id
    * 
    * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
    
	public function reset_adtags_post()
	{					
		$tag_id	= 	$this->post('id');
		$where	=	array('tag_id'	=>	$tag_id);
		
		if($tag_id){	
			$tag 			= 	$this->do_site->reset_tag_parameters($where);
			
			if($tag)
			{
				$adblock_tag 	= 	$this->generate_adblock_tag($this->post());
				$success = array(
								'response' 	=> 'ok',
								'msg'	 	=> $adblock_tag
							);
				$this->response( $success, 200);
			}
			else
			{
				$error = array(
								'response' 	=> 'error',
								'msg'	 	=> 'Sorry! Tag parameters are not available to reset.'
							);
				$this->response( $error, 200);
			}
			
		}
	}

	public function fetch_siteid_get()
	{
		if($this->user_authentication->account_type=='TRAFFICKER')
		  {
			$account_id = $this->user_authentication->account_id;
		  }
		  else
		  {
			$account_id = $this->get('account_id');
		  }	  
		
		$zone_id = $this->get('zone_id');  
		
		$site_res  = $this->do_site->fetch_siteid($zone_id,$account_id);
		
		
		
		if($site_res)
		{
				
			$this->response( $site_res, 200);
		}
		else
		{
			$error = array(
								'response' 	=> 'error',
								'msg'	 	=> 'Sorry! No Records Found'
							);
				
			$this->response( $error, 200);
		}
		
	}
	
	
	function activity_log($module,$process,$app_id)
	{
				/* Activity Log for Add/Edit/Delete App - Start*/				
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");							
				$account_id=$this->user_authentication->account_id;
				$publisher_id =	$this->user_authentication->affiliate_id;
				$module=$module;
				$process=$process;				
				$app_id=$app_id;
				
				$activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$user_agent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,
				"module"=>$module,
				"process"=>$process,
				"advertiser_id"=>'',
				"campaign_id"=>'',
				"banner_id"=>'',
				"publisher_id"=>$publisher_id,
				"site_id"=>'',
				"app_id"=>$app_id,
				"adblock_id"=>'');				
					
				$this->redis_library->logcount($account_id,$activity_log);  
				//$this->do_app_config->activity_log($account_id,$activity_log);
				/* Activity Log for Add/edit/Delete site - End*/			
		
	}
	

	public function url_check($url)
	{
		$pattern = "/([A-Z0-9][A-Z0-9_-]*(?:\.[A-Z0-9][A-Z0-9_-]*)+):?(\d+)?\/?/i";

		if (preg_match($pattern, $url)) 
		  {
			return TRUE;
		  }
		else
		{
			$this->form_validation->set_message('url_check', 'Please Enter Valid url');
			return FALSE;
		}	
    }	
    public function url_creation($url)
	{
		
		if (!preg_match("~^(?:f|ht)tps?://~i", $url)) 
		{
           $site_url = "http://" . $url;
        }
        else
        {
		   $site_url = $url;	
		}	
		//$this->response($site_url,200);
		return $site_url;
    }
}
