<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Admin to approve their network users activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Approval extends REST_Controller
{
	
	function __construct()
	{

		parent::__construct();
		$this->load->library('redis_library');
		$this->load->model('do_approval');
		$this->load->model('do_creative');
		$this->load->model('do_campaign');
		$this->load->model('do_payments');
		$this->load->model('do_advertiser');
		$this->load->model('do_publisher');
		$this->load->model('do_site');
		$this->load->model('do_tracker');
        $this->load->model('do_networks');
        $this->load->model('do_app_config');
        $this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
        $this->load->library('user_authentication');
        $this->load->library('notification');
		$this->load->model('do_message');
        $key=clean_data($this->input->get_post('api_key'));
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
        if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}
	
	 /*
	 * 
	 * name: fetch_get
	 * @param :
	 * @return : $adv_list
	 * 
	 * fetch all network( pub or adv )users
	 */
	public function fetch_user_get()
	{
		$account_type = $this->get('account_type');
		$agency_id = $this->user_authentication->agency_id;
		$where=array( 'account_type' =>$account_type,
		              'agency_id' =>$agency_id
		            );
	    $adv_list =$this->do_approval->fetch_user($where); 
		$this->response($adv_list);
	}
	
	
	 /*
	 * Approval
	 * name: approve_get
	 * @param :
	 * @return : $adv_list
	 * fetch all network( pub or adv )users
	 */
	public function approve_get(){

		$temp_user_id = $this->get('user_id');
		if($temp_user_id)
		{
			$tuser_id	=	explode(',',$temp_user_id);
		
			if(is_array($tuser_id))
			{ 
				foreach($tuser_id as $tmpuser_id)
				{				
					$tempObj = $this->aprv($tmpuser_id);
				}
			}
			else
			{ 
				$tempObj = $this->aprv($temp_user_id);
			}
			$success = array(
						'response' => 'ok',
						'redirect'=>site_url('admin/approval'),
						'msg'	 => 'Approval Success!..'
						);

			$this->response( $success, 200);
		}
	}
			
	
	
	function aprv($temp_user_id)	
	{
		$tempObj = $this->do_advertiser->get_temp_user($temp_user_id);
        #print_r($tempObj);exit;
		if($tempObj != FALSE){
            if($tempObj['referral_id'])
				{
				 $allowed_count=$this->do_publisher->check_referral_count('total_count',$tempObj);
				 $count = $this->do_publisher->check_referral_count('active_count',$tempObj);
				// $this->response("lkjh", 200);
				 if($allowed_count['active_referrals'] == $count['count'])
				 {
					 $success=array( 
		                'response'=>'ok',
		                'redirect'=>site_url('admin/approval'),
						'msg'=>'This year active refferal count reached for reffered publisher'
		               );
	                 $this->response( $success, 200);
				 }
				 
					 
			    }
			    
			$advObj = $this->create($tempObj);			
			
			$this->do_advertiser->remove_temp_user($temp_user_id);
			$pixel_data 	= 	array(
									"clientid"			=>	clean_data($advObj['client_id']),
									"trackername"		=>	clean_data('default_tracker'),
									"pixel_type" 		=> 	clean_data('html'),
									"pixel_category"	=>	clean_data('sale'),
									"protocol"			=>	clean_data('http'),
									"pixel_goal" 		=> 	clean_data('1'),
									"status"			=>	clean_data('1'),
									"appendcode"		=>	clean_data($advObj['first_name'].'_default_tracker'),
									"updated"			=>	date('Y-m-d H:i:s'),
									"admarket"			=>	'',
									"destination_url"	=>	''
								);
			$pixel_data_admarket 	= 	$pixel_data;
			$pixel_data_admarket["admarket"]='1';
			// SEND APPROVAL EMAIL to USER
			if($this->user_authentication->account_type == "ADMIN" )
			{
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->do_networks->agency_owner_details($agency_id);
			
				$admin_name    = $result['name'];			
				$admin_email   = $result['email'];
			
				$account_type=$advObj['account_type'];
				$user_email=$advObj['email'];
				$password=$advObj['password'];
				$user_name=$advObj['first_name']." ".$advObj['last_name'];
				$type='';		
				if($account_type=="ADVERTISER")
				{
					/**Adding default pixel tracker for advertiser on adv approve DAC094 20/09/2018*/
					
					
					$pixel_add		=	$this->do_tracker->add_tracker($pixel_data,$campaign_id);			
					$pixel_add_admarket =	$this->do_tracker->add_tracker($pixel_data_admarket,$campaign_id);			
					/**Adding default pixel tracker for advertiser on adv approve DAC094 20/09/2018*/
					$type="ADV_LOGIN_CREDENTIAL";
					
					/* Activity Log for Advertiser Approval - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_APPROVALS,ADV_APPROVE);
					if($enable=='1')
					{							
					$this->activity_log(ADVERTISER,APPROVE);
					}
					/* Activity Log for Advertiser Approval - End*/	
						
				}
				if($account_type=="TRAFFICKER")
				{
					$type="PUB_LOGIN_CREDENTIAL";
					
					/* Activity Log for Publisher Approval- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_APPROVALS,PUB_APPROVE);
					if($enable=='1')
					{							
					$this->activity_log(PUBLISHER,APPROVE);
					}
					/* Activity Log for Publisher Approval - End*/						
					
				}		
						
				
			
				$from 	=  $admin_email;
				$to  	=  $user_email;			
				$mail_content=array(
					"subject" 		=> "Login Credentials",
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email,
					"password"		=> $password								
					);			
				send_mail($type,$from,$to,$mail_content);
				
			}
			else
			{
				// IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
				$manager_user_id = $this->user_authentication->manager_user_id;
				$is_manager = $this->do_networks->get_manager_role($manager_user_id);
				if($is_manager == 1)
				{	
					// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);
					
					$network_admin=$this->do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
				
					$account_type=$advObj['account_type'];
					$user_email=$advObj['email'];
					$password=$advObj['password'];
					$user_name=$advObj['first_name']." ".$advObj['last_name'];
					$type='';		
					if($account_type=="ADVERTISER")
					{
						$type="ADV_LOGIN_CREDENTIAL";
						/**Adding default pixel tracker for advertiser on adv approve DAC094 20/09/2018*/		
						$pixel_add		=	$this->do_tracker->add_tracker($pixel_data,$campaign_id);			
						$pixel_add_admarket =	$this->do_tracker->add_tracker($pixel_data_admarket,$campaign_id);			
						/**Adding default pixel tracker for advertiser on adv approve DAC094 20/09/2018*/
							/* Activity Log for Advertiser Approval - Start*/	
							$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_APPROVALS,ADV_APPROVE);
							if($enable=='1')
							{							
							$this->activity_log(ADVERTISER,APPROVE);
							}
							/* Activity Log for Advertiser Approval - End*/	
							
					}
					if($account_type=="TRAFFICKER")
					{
						$type="PUB_LOGIN_CREDENTIAL";
						
						/* Activity Log for Publisher Approval- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_APPROVALS,PUB_APPROVE);
					if($enable=='1')
					{							
					$this->activity_log(PUBLISHER,APPROVE);
					}
					/* Activity Log for Publisher Approval - End*/	
					
					}
					
				
					$from 	=  $admin_email;
					$to  	=  $user_email;			
					$mail_content=array(
						"subject" 		=> "Login Credentials",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						"password"		=> $password								
						);	
					$attachement="";			
					send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
					
				}
				else
				{
					// GET NETWORK USERS MAILING DETAILS
					$user_mailing_details = $this->do_networks->get_network_users_detail($manager_user_id);
					$admin_email = $user_mailing_details['email_address'];
					$admin_name = $user_mailing_details['contact_name'];
					
					// GET NETWORK MANAGER MAILING DETAIL FOR BCC
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);
					$bcc = $result['email'];
					
					$account_type=$advObj['account_type'];
					$user_email=$advObj['email'];
					$password=$advObj['password'];
					$user_name=$advObj['first_name']." ".$advObj['last_name'];
					$type='';		
					if($account_type=="ADVERTISER")
					{
						$type="ADV_LOGIN_CREDENTIAL";
						
						/* Activity Log for Advertiser Approval - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_APPROVALS,ADV_APPROVE);
					if($enable=='1')
					{							
					$this->activity_log(ADVERTISER,APPROVE);
					}
					/* Activity Log for Advertiser Approval - End*/	
					
						
					}
					if($account_type=="TRAFFICKER")
					{
						$type="PUB_LOGIN_CREDENTIAL";
						
						/* Activity Log for Publisher Approval- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_APPROVALS,PUB_APPROVE);
					if($enable=='1')
					{							
					$this->activity_log(PUBLISHER,APPROVE);
					}
					/* Activity Log for Publisher Approval - End*/	
					
					}
					
				
					$from 	=  $admin_email;
					$to  	=  $user_email;			
					$mail_content=array(
						"subject" 		=> "Login Credentials",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						"password"		=> $password								
						);	
					$attachement="";			
					send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
					
				}		
			}
		}
		else
		{
			$success=array( 
		                'response'=>'ok',
		                'redirect'=>site_url('admin/approval'),
						'msg'=>'This user is already approved / rejected by admin!..'
		               );
	        $this->response( $success, 200);
		}
	}

    /*
	* 
	* name: reject_get
	* @param :
	* @return : true or false
	* 
    */
	public function reject_get(){
	  
	  $temp_user_id = $this->get('rej_user_id');
	 
	  if($temp_user_id)
		{
			$tuser_id	=	explode(',',$temp_user_id);
		
			if(is_array($tuser_id))
			{ 
				foreach($tuser_id as $tmpuser_id)
				{				
					$tempObj = $this->rejct($tmpuser_id);
				}
			}
			else
			{ 
				$tempObj = $this->rejct($temp_user_id);
			}
			$success = array(
						'response' => 'ok',
						'redirect'=>site_url('admin/approval'),
						'msg'	 => 'Rejected Successfully!..'
						);
			$this->response( $success, 200);
		}
	}
	
	function rejct($temp_user_id)
	{
			
	  //CHECK THIS USER ID IS EXIT OR NOT
	  $temp_user_details=$this->do_advertiser->get_temp_user($temp_user_id);
	  //$user_info=$temp_user_details[0];
	  
	  
	  if($temp_user_details!=FALSE)
	  {
	  	$check = $this->do_advertiser->remove_temp_user($temp_user_id);
	  	//SEND EMAIL TO REJECTED USER
	  	$result=$this->do_networks->get_network_details();			
		$admin_name    = $result['firstname']." ".$result['lastname'];			
		$admin_email   = $result['email'];
		
		$user_email    = $temp_user_details['email'];
		$user_name     = $temp_user_details['first_name']." ".$temp_user_details['last_name'];
		$user_acc_type = $temp_user_details['account_type'];
		
				
		if($user_acc_type=="ADVERTISER")
		{
				/* Activity Log for Advertiser Reject - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_APPROVALS,ADV_REJECT);
					if($enable=='1')
					{							
					$this->activity_log(ADVERTISER,REJECT);
					}
					/* Activity Log for Advertiser Reject - End*/	
		}
		
		if($user_acc_type=="TRAFFICKER")
		{
				/* Activity Log for Publisher Reject - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_APPROVALS,PUB_REJECT);
					if($enable=='1')
					{							
					$this->activity_log(PUBLISHER,REJECT);
					}
					/* Activity Log for Publisher Reject - End*/	
		}
		
		
		$type     ="ACCOUNT_REJECT_NOTIFY";
		$from 	=  $admin_email;
		$to  	=  $user_email;	
		
		$mail_content=array(
						"subject" 		=> "Account Rejected",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						"account_type"	=> $user_acc_type
						);
		$attachement='';	
		send_mail($type,$from,$to,$mail_content,$attachement);
		
	  	
	  }
	  else
	  {
	    $success=array( 
		                'response'=>'ok',
		                'redirect'=>site_url('admin/approval'),
						'msg'=>'This user is already approved / rejected  by admin!..'
		               );
	    $this->response( $success, 200);
	  }
	  
	}

   	/*
	* 
	* name: create
	* @param :
	* @return : adv / pub details
	* 
    */
	public function create($advObj){

		if($advObj != FALSE){

			if($advObj['account_type'] == "ADVERTISER"){
				$advObj = $this->do_advertiser->add($advObj);
			}else if($advObj['account_type'] === "TRAFFICKER"){
				
				
				
			   
			
				$advObj = $this->do_publisher->add($advObj);
			}

			// Send Mail to Advertiser & Manager

			if($advObj != FALSE){
				return $advObj;
			}
			else
			{
				return FALSE;
			}

		}
	}
	/*
	* 
	* name: fetch_creative_get
	* @param :
	* @return : $creative_list
	* 
	* fetch all creatives
    */
	public function fetch_creative_get()
	{   
	    $agency_id=$this->user_authentication->agency_id;
		$filter	=	clean_data($this->get('filter'));
		$creative_list =$this->do_creative->fetch_all_creative($agency_id,$filter); 
		
		$this->response($creative_list);  
		//$this->rest->debug();
	}
	
	/*
	*
	*name:fetch_mobile_application
	*@param:
	*@return :$mobile_app_list
	*
	* fetch all mobile applications
	*/
	
	public function fetch_mobile_application_get()
	{
		$agency_id=$this->user_authentication->agency_id;
		$status="0";
		$mobile_app_list =$this->do_publisher->fetch_mobile_app($agency_id,$status); 		
		$this->response($mobile_app_list);
	
	}
	/*
	* 
	* name: approve_creative_get
	* @param :
	* @return : $success
    */
	public function approve_creative_get()
	{
	   $banner_id = $this->get('creativeid');
	      	   
	   if($banner_id)
		{
			$banner_ids	=	explode(',',$banner_id);
			
			if(is_array($banner_ids) && count($banner_ids)>1)
			{
				foreach($banner_ids as $ban_id)
				{
					$this->creative_appr($ban_id);
				}
				
				$success = array('response'	=> 'ok',
								 'msg'		=> 'Creatives have been Approved successfully'
										 ); 
										 
				$this->response($success);
			}
			else
			{ 
				$this->creative_appr($banner_id);
				
				$success = array('response'	=> 'ok',
								 'msg'		=> 'Creative has been Approved successfully'
										 ); 
										 
				$this->response($success);
			}
		}
	}
	
	/* dac055 - campaign approval */
	
	/*public function approve_creative_get()
	{
	   $campaignid = $this->get('campaignid');
	   $this->response($campaignid);
	      	   
	   if($campaignid)
		{
			$banner_ids	=	explode(',',$banner_id);
			if(is_array($banner_ids))
			{
				foreach($banner_ids as $banner_id)
				{
					$success=$this->creative_appr($banner_id);
				}
				$success = array('response'	=> 'ok',
								 'msg'		=> 'Creative has been Approved successfully'
										 ); 
				$this->response($success);
			}
		}
	}*/
	/* dac055 - campaign approval */
	
	public function approve_mobileapp_get()
	{
	   $app_id = $this->get('app_id');
	   if($app_id)
		{
			$app_ids	=	explode(',',$app_id);
			if(is_array($app_ids))
			{
				foreach($app_ids as $app_id)
				{
					$success=$this->mobileapp_appr($app_id);
				}				
				$success = array('response'	=> 'ok',
								 'msg'		=> 'Mobile application has been Approved successfully'
										 ); 
				$this->response($success);
			}
		}
	}
	
	function mobileapp_appr($app_id)
	{
	   //CHECK THE MOBILE APP IS APPROVED / REJECTED PREVIOUSLY
	   $application_id =$this->do_creative->is_app_id($app_id);	   
	   if($application_id!='')
	   {   
			$approve_list =$this->do_creative->approve_mobileapp($app_id);	
			
			/* Activity Log for MobileApp Approval - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_APPROVALS,APP_APPROVAL);
					if($enable=='1')
					{							
					$this->activity_log(MOBILE_APP,APPROVE);
					}
			/* Activity Log for MobileApp Approval - End*/	
						
			
					
			
			if($approve_list)
			{
				//Get admin details
				if($this->user_authentication->account_type == "ADMIN" )
				{
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->do_networks->agency_owner_details($agency_id);			 
						$user = $this->do_message->get_profile(ADMIN_ID);
						$network_id	=	$this->do_message->fetch_admin_network_id();
						$type = "PUBLISHER_MOBILEAPP_APPROVAL";
						$acc_type='ADMIN';
																							
						$admin_name   =$user['first_name'].' '.$user['last_name'];	
						$admin_email  =$user['email'];
						$from 		  = $admin_email;
						$to  		  = $approve_list['email'];		
									
						$mail_content=array(
							"subject" 	   => "Mobile Application approved",
							"from_name"	   => $admin_name,
							"email"  	   => $approve_list['email'],
							"app_url"	   => $approve_list['app_url'],
							"app_name"	   => $approve_list['app_name'],
							"os_type"	   => $approve_list['os_type']
						);	
							
						send_mail($type,$from,$to,$mail_content,$subject); 
						
						
				}
				else
				{
					// IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
					$manager_user_id = $this->user_authentication->manager_user_id;
					$is_manager = $this->do_networks->get_manager_role($manager_user_id);
					if($is_manager == 1)
					{
						// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->do_networks->agency_owner_details($agency_id);
						// GET NETWORK ADMIN DETAILS FOR BCC
						$network_admin=$this->do_networks->get_network_details();
						
						$bcc		   = $network_admin['email'];
						$admin_name    = $result['name'];			
						$admin_email   = $result['email'];
						$user_email    = $approve_list['email'];
						$type     	   = "PUBLISHER_MOBILEAPP_APPROVAL";
						$from 		   = $admin_email;
						$to  		   =  $user_email;			
						$mail_content=array(
							"subject" 	   => "Mobile Application approved",
							"from_name"	   => $admin_name,
							"email"  	   => $approve_list['email'],
							"app_url"	   => $approve_list['app_url'],
							"app_name"	   => $approve_list['app_name'],
							"os_type"	   => $approve_list['os_type']
						);
						$network_id	=	$this->do_message->fetch_admin_network_id();	
						$user = $this->do_message->get_profile(ADMIN_ID);
						$network_id	=	$this->do_message->fetch_admin_network_id();
						$mail_type = "PUBLISHER_MOBILEAPP_APPROVAL";
						$acc_type='ADMIN';
											
						send_mail($type,$from,$to,$mail_content,$bcc,$subject); 					  
				    }
				    else
				    {
						// GET NETWORK USERS MAILING DETAILS
						$user_mailing_details = $this->do_networks->get_network_users_detail($manager_user_id);
						$admin_email = $user_mailing_details['email_address'];
						$admin_name = $user_mailing_details['contact_name'];
						
						// GET NETWORK MANAGER MAILING DETAIL FOR BCC
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->do_networks->agency_owner_details($agency_id);
						$bcc = $result['email'];
												
						$user = $this->do_message->get_profile(ADMIN_ID);
						$account_id = $approve_list['dj_account_id'];
						$network_id	=	$this->do_message->fetch_admin_network_id();
						$type = "PUBLISHER_MOBILEAPP_APPROVAL";
						$acc_type='ADMIN';
						$user_email    = $approve_list['email'];
                        $from 		   = $admin_email;
						$to  		   =  $user_email;			
						
						$mail_content=array(
							"subject" 	   => "Mobile Application approved",							
							"from_name"	   => $admin_name,
							"email"  	   => $user_email,
							"app_url"	   => $approve_list['app_url'],
							"app_name"	   => $approve_list['app_name'],
							"os_type"	   => $approve_list['os_type']							 
						);
							
						send_mail($type,$from,$to,$mail_content,$bcc,$subject); 
					}
				} 
				
			
			
			}
	   }
	   else
	   {  
	      $success = array('response'	=> 'ok',
							 'msg'		=> 'Mobile Application has been Approved / Rejected Previously by admin'
							 ); 
		   $this->response($success);
	   }
	}
	
	function creative_appr($banner_id)
	{
	   //CHECK THE CREATIVE IS APPROVED / REJECTED PREVIOUSLY
	   $creative_id =$this->do_creative->is_creative_id($banner_id);
		$approve_creative_camp =$this->do_creative->approve_creative_camp($banner_id);
			
	   if($creative_id!='')
	   { 
			$approve_list =$this->do_creative->approve_creative($banner_id);
				
			# print_r($approve_list);exit;
			if($approve_list)
			{
				/* Activity Log for approve creative - Start*/				
		//$this->appr_activity_log(CAMPAIGN,PAUSE,$campaign_id);
				$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_APPR);
					if($enable=='1')
					{				
						$this->activity_log(BANNER,APPROVE);
					}
		/* Activity Log for approve creative - End*/
				//Get advertiser details
				$advertiser_details=$this->do_advertiser->get_profile($approve_list['dj_account_id']);
				 
				
				//$mail_msg=$this->do_mailmsg->fetch_notifications($approve_list['dj_account_id']);
			 
				$msg_val=$mail_msg['0']['msg_type'];
				$creative_appr=$mail_msg['0']['campaigns'];
				$creative_appr_val	=	explode(',',$creative_appr);
				//Get admin details
				if($this->user_authentication->account_type == "ADMIN" )
				{
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);
								
					 
				 
						$user = $this->do_message->get_profile(ADMIN_ID);
						$account_id = $approve_list['dj_account_id'];
						$network_id	=	$this->do_message->fetch_admin_network_id();
						$mail_type = "ADVERTISER_CREATIVE_APPROVAL";
						$acc_type='ADMIN';

						$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "ADVERTISER_CREATIVE_APPROVAL",
						'string'		=> 'creative_appr',
						'column_name'	=> 'campaigns'
						); 
						$message_data		=	array(
						'sender_id'		=>	ADMIN_ID,
						'receiver_id'	=>	$approve_list['dj_account_id'],
						'dj_is_admarket'=>	$approve_creative_camp[0]['dj_is_admarket'],
						'subject'		=>	'Creative Approved',
						'content'		=> 	'Creative <b>'.$approve_list['description'].'</b>approved successfully',
						'image_name'	=>	NULL,
						'file_name'		=>	NULL,
						'account_type'	=>	"ADVERTISER",
						'status'		=>	'1',
						'network_id'	=>	$network_id,	
						'notification_type'	=>	"campaign_setting",									
						'date'			=>	date('Y-m-d H:i:s')
						);

											
						$admin_name   =$user['first_name'].' '.$user['last_name'];	
						$admin_email   =$user['email'];
						$user_email    =$advertiser_details['email'];
						$user_name     =$advertiser_details['first_name'].' '.$advertiser_details['last_name'];
						$from 		   = $admin_email;
						$to  		   = $user_email;		
									
						$mail_content=array(
							"subject" 	   => "Creative approved",
							"to_name" 	   => $user_name,				
							"from_name"	   => $admin_name,
							"email"  	   => $user_email,
							'banner_name'  => $approve_list['description']
							 
						);
							$attachement='';

			$notification_msg = $this->do_message->get_notification_msg('creative_appr'); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
											
			}		
			$advertiser_name=$advertiser_details['first_name'].$advertiser_details['last_name'];
			$adgate_url	=	base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$advertiser_name,$msg_replace);	

			$msg_replace = str_replace("{{creative_name}}",$mail_content['banner_name'],$msg_replace);
			$msg_replace = str_replace("{{storage_type}}",$approve_list['storagetype'],$msg_replace);
			$msg_replace = str_replace("{{admin_name}}",$user['first_name'].' '.$user['last_name'] ,$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$this->config->item('click_directADS').'</a>' ,$msg_replace);		
			//$this->response($msg_replace,200);
			
						//	$this->response($advertiser_details,200);
						//$dat = $this->notification->new_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);						
						
						$dat = $this->notification->notify_mail($message_data,$user,$advertiser_details,$type_details,$mail_content,$msg_replace);

			 
			 
				}
				else
				{
					// IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
					$manager_user_id = $this->user_authentication->manager_user_id;
					$is_manager = $this->do_networks->get_manager_role($manager_user_id);
					if($is_manager == 1)
					{
						// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->do_networks->agency_owner_details($agency_id);
						// GET NETWORK ADMIN DETAILS FOR BCC
						$network_admin=$this->do_networks->get_network_details();
						
						$bcc		   = $network_admin['email'];
						$admin_name    = $result['name'];			
						$admin_email   = $result['email'];
						$user_email    = $advertiser_details['email'];
						$user_name     = $advertiser_details['first_name']." ".$advertiser_details['last_name'];
						$type     	   = "ADVERTISER_CREATIVE_APPROVAL";
						$from 		   = $admin_email;
						$to  		   =  $user_email;			
						$mail_content=array(
							"subject" 	   => "Creative approved",
							"to_name" 	   => $user_name,				
							"from_name"	   => $admin_name,
							"email"  	   => $user_email,
							'banner_name'  => $approve_list['description'],
							'contenttype'  => $approve_list['dj_banner_type']
						 );
						 $network_id	=	$this->do_message->fetch_admin_network_id();	
						$user = $this->do_message->get_profile(ADMIN_ID);
						$account_id = $approve_list['dj_account_id'];
						$network_id	=	$this->do_message->fetch_admin_network_id();
						$mail_type = "ADVERTISER_CREATIVE_APPROVAL";
						$acc_type='ADMIN';

						$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "ADVERTISER_CREATIVE_APPROVAL",
						'string'		=> 'creative_appr',
						'column_name'	=> 'campaigns'
						); 
						$message_data		=	array(
						'sender_id'		=>	ADMIN_ID,
						'receiver_id'	=>	$approve_list['dj_account_id'],
						'subject'		=>	'Advertiser - Creative',
						'content'		=> 	'Creative approved successfully',
						'image_name'	=>	NULL,
						'file_name'		=>	NULL,
						'account_type'	=>	"ADVERTISER",
						'status'		=>	'1',
						'network_id'	=>	$network_id,	
						'notification_type'	=>	"campaign_setting",									
						'date'			=>	date('Y-m-d H:i:s')
						);

											
						$admin_name   =$user['first_name'].' '.$user['last_name'];	
						$admin_email   =$user['email'];
						$user_email    =$advertiser_details['email'];
						$user_name     =$advertiser_details['first_name'].' '.$advertiser_details['last_name'];
						$from 		   = $admin_email;
						$to  		   = $user_email;		
									
						$mail_content=array(
							"subject" 	   => "Creative approved",
							"to_name" 	   => $user_name,				
							"from_name"	   => $admin_name,
							"email"  	   => $user_email,
							'banner_name'  => $approve_list['description']
							 
						);
							$attachement='';

						//	$this->response($advertiser_details,200);
						$dat = $this->notification->new_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);

					  
				    }
				    else
				    {
						// GET NETWORK USERS MAILING DETAILS
						$user_mailing_details = $this->do_networks->get_network_users_detail($manager_user_id);
						$admin_email = $user_mailing_details['email_address'];
						$admin_name = $user_mailing_details['contact_name'];
						
						// GET NETWORK MANAGER MAILING DETAIL FOR BCC
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->do_networks->agency_owner_details($agency_id);
						$bcc = $result['email'];
						
						 
						$attachement='';	
						$user = $this->do_message->get_profile(ADMIN_ID);
						$account_id = $approve_list['dj_account_id'];
						$network_id	=	$this->do_message->fetch_admin_network_id();
						$mail_type = "ADVERTISER_CREATIVE_APPROVAL";
						$acc_type='ADMIN';

						$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "ADVERTISER_CREATIVE_APPROVAL",
						'string'		=> 'creative_appr',
						'column_name'	=> 'campaigns'
						); 
						$message_data		=	array(
						'sender_id'		=>	ADMIN_ID,
						'receiver_id'	=>	$approve_list['dj_account_id'],
						'subject'		=>	'Advertiser - Creative',
						'content'		=> 	'Creative approved successfully',
						'image_name'	=>	NULL,
						'file_name'		=>	NULL,
						'account_type'	=>	"ADVERTISER",
						'status'		=>	'1',
						'network_id'	=>	$network_id,	
						'notification_type'	=>	"campaign_setting",									
						'date'			=>	date('Y-m-d H:i:s')
						);

											
						$admin_name   =$user['first_name'].' '.$user['last_name'];	
						$admin_email   =$user['email'];
						$user_email    =$advertiser_details['email'];
						$user_name     =$advertiser_details['first_name'].' '.$advertiser_details['last_name'];
						$from 		   = $admin_email;
						$to  		   =  $user_email;			
						$mail_content=array(
							"subject" 	   => "Creative approved",
							"to_name" 	   => $user_name,				
							"from_name"	   => $admin_name,
							"email"  	   => $user_email,
							'banner_name'  => $approve_list['description']
							 
						);
							$attachement='';

						//	$this->response($advertiser_details,200);
						$dat = $this->notification->new_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);
					   
					}
				} 
				
			}
	   }
	   else
	   {
	      $success = array('response'	=> 'ok',
							 'msg'		=> 'Creative has been Approved / Rejected Previously by admin'
							 ); 
		   $this->response($success);
	   }
	}
	
	/*
	* 
	* name: reject_creative_get
	* @param :
	* @return : $success
    */
	public function reject_creative_get()
	{
	   $banner_id = $this->get('reject_creativeid');
	    if($banner_id)
		{
			$banner_ids	=	explode(',',$banner_id);
			
			if(is_array($banner_ids) && count($banner_ids)>1)
			{
				foreach($banner_ids as $ban_id)
				{
					$this->creative_rejc($ban_id);
				}
				$success = array('response'	=> 'ok',
									'msg'	=> 'Creatives have been rejected successfully'
									); 
				$this->response($success);
			}
			else
			{ 
				$this->creative_rejc($banner_id);
				
				$success = array('response'	=> 'ok',
								 'msg'		=> 'Creative has been rejected successfully'
										 ); 
										 
				$this->response($success);
			}
		}
	}
	
	function creative_rejc($banner_id)
	{
	   //CHECK THE CREATIVE IS APPROVED / REJECTED PREVIOUSLY
	   $creative_id =$this->do_creative->is_creative_id($banner_id);
	   if($creative_id!='')
	   { 
			$reject_list =$this->do_creative->reject_creative($banner_id); #print_r($reject_list);exit;
			$approve_creative_camp =$this->do_creative->approve_creative_camp($banner_id);
			if($reject_list)
			{
				
				/* Activity Log for reject creative - Start*/				
		
				$enable	=  	$this->default_configurations->activity_log_setting(CREATIVES,CREATIVE_REJ);
					if($enable=='1')
					{																									
						$this->activity_log(BANNER,REJECT);
					}
		/* Activity Log for reject creative - End*/
				//Get advertiser details
				$advertiser_details=$this->do_advertiser->get_profile($reject_list['dj_account_id']);
				//$mail_msg=$this->do_mailmsg->fetch_notifications($reject_list['dj_account_id']);
				
				
				$msg_val=$mail_msg['0']['msg_type']; 
			 
				$creative_reject=$mail_msg['0']['campaigns'];
				$creative_reject_val	=	explode(',',$creative_reject);
				
				//Get admin details
				if($this->user_authentication->account_type == "ADMIN" )
				{
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);			
					 
						
						$user = $this->do_message->get_profile(ADMIN_ID);
						$account_id = $reject_list['dj_account_id'];
						 
						
						$network_id	=	$this->do_message->fetch_admin_network_id();
						$mail_type = "ADVERTISER_CREATIVE_REJECTED";
						$acc_type='ADMIN';

						$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "ADVERTISER_CREATIVE_REJECTED",
						'string'		=> 'creative_reject',
						'column_name'	=> 'campaigns'
						); 
						$message_data		=	array(
						'sender_id'		=>	ADMIN_ID,
						'receiver_id'	=>	$account_id,
						'dj_is_admarket'=>	$approve_creative_camp[0]['dj_is_admarket'],
						'subject'		=>	'Advertiser - Creative',
						'content'		=> 	'Creative rejected successfully',
						'image_name'	=>	NULL,
						'file_name'		=>	NULL,
						'account_type'	=>	"ADVERTISER",
						'status'		=>	'1',
						'network_id'	=>	$network_id,
						'notification_type'	=>	"campaign_setting",										
						'date'			=>	date('Y-m-d H:i:s')
						);

											
						$admin_name   =$user['first_name'].' '.$user['last_name'];	
						$admin_email   =$user['email'];
						$user_email    =$advertiser_details['email'];
						$user_name     =$advertiser_details['first_name'].' '.$advertiser_details['last_name'];
						$from 		   = $admin_email;
						$to  		   = $user_email;		
									
						$mail_content=array(
							"subject" 	   => "Creative rejected",
							"to_name" 	   => $user_name,				
							"from_name"	   => $admin_name,
							"email"  	   => $user_email,
							'banner_name'  => $reject_list['description']
							 
						);
							$attachement='';
			$notification_msg = $this->do_message->get_notification_msg('creative_reject'); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
											
			}		
			$advertiser_name=$advertiser_details['first_name'].$advertiser_details['last_name'];
			$adgate_url	=	base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$advertiser_name,$msg_replace);	

			$msg_replace = str_replace("{{creative_name}}",$mail_content['banner_name'],$msg_replace);
			$msg_replace = str_replace("{{storage_type}}",$reject_list['storagetype'],$msg_replace);
			$msg_replace = str_replace("{{admin_name}}",$user['first_name'].' '.$user['last_name'] ,$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$this->config->item('click_directADS').'</a>' ,$msg_replace);		
						
						
			$dat = $this->notification->notify_mail($message_data,$user,$advertiser_details,$type_details,$mail_content,$msg_replace);
						//	$this->response($advertiser_details,200);
						//$dat = $this->notification->new_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);

					
				}
				else
				{
					// IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
					$manager_user_id = $this->user_authentication->manager_user_id;
					$is_manager = $this->do_networks->get_manager_role($manager_user_id);
					if($is_manager == 1)
					{	
						// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->do_networks->agency_owner_details($agency_id);
						
						$user = $this->do_message->get_profile(ADMIN_ID);
						$account_id = $reject_list['dj_account_id'];
						 
						
						$network_id	=	$this->do_message->fetch_admin_network_id();
						$mail_type = "ADVERTISER_CREATIVE_REJECTED";
						$acc_type='ADMIN';

						$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "ADVERTISER_CREATIVE_REJECTED",
						'string'		=> 'creative_reject',
						'column_name'	=> 'campaigns'
						); 
						$message_data		=	array(
						'sender_id'		=>	ADMIN_ID,
						'receiver_id'	=>	$account_id,
						'dj_is_admarket'=>	$approve_creative_camp[0]['dj_is_admarket'],
						'subject'		=>	'Advertiser - Creative',
						'content'		=> 	'Creative rejected successfully',
						'image_name'	=>	NULL,
						'file_name'		=>	NULL,
						'account_type'	=>	"ADVERTISER",
						'status'		=>	'1',
						'network_id'	=>	$network_id,
						'notification_type'	=>	"campaign_setting",										
						'date'			=>	date('Y-m-d H:i:s')
						);

											
						$admin_name   =$user['first_name'].' '.$user['last_name'];	
						$admin_email   =$user['email'];
						$user_email    =$advertiser_details['email'];
						$user_name     =$advertiser_details['first_name'].' '.$advertiser_details['last_name'];
						$from 		   = $admin_email;
						$to  		   =  $user_email;			
						$mail_content=array(
							"subject" 	   => "Creative rejected",
							"to_name" 	   => $user_name,				
							"from_name"	   => $admin_name,
							"email"  	   => $user_email,
							'banner_name'  => $reject_list['description']
							 
						);
							$attachement='';

						//	$this->response($advertiser_details,200);
						$dat = $this->notification->new_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);

					}
					else
					{
						// GET NETWORK USERS MAILING DETAILS
						$user_mailing_details = $this->do_networks->get_network_users_detail($manager_user_id);
						$admin_email = $user_mailing_details['email_address'];
						$admin_name = $user_mailing_details['contact_name'];
						
						$user = $this->do_message->get_profile(ADMIN_ID);
						$account_id = $reject_list['dj_account_id'];
						 
						
						$network_id	=	$this->do_message->fetch_admin_network_id();
						$mail_type = "ADVERTISER_CREATIVE_REJECTED";
						$acc_type='ADMIN';

						$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "ADVERTISER_CREATIVE_REJECTED",
						'string'		=> 'creative_reject',
						'column_name'	=> 'campaigns'
						); 
						$message_data		=	array(
						'sender_id'		=>	ADMIN_ID,
						'receiver_id'	=>	$account_id,
						'dj_is_admarket'=>	$approve_creative_camp[0]['dj_is_admarket'],
						'subject'		=>	'Advertiser - Creative',
						'content'		=> 	'Creative rejected successfully',
						'image_name'	=>	NULL,
						'file_name'		=>	NULL,
						'account_type'	=>	"ADVERTISER",
						'status'		=>	'1',
						'network_id'	=>	$network_id,
						'notification_type'	=>	"campaign_setting",										
						'date'			=>	date('Y-m-d H:i:s')
						);

											
						$admin_name   =$user['first_name'].' '.$user['last_name'];	
						$admin_email   =$user['email'];
						$user_email    =$advertiser_details['email'];
						$user_name     =$advertiser_details['first_name'].' '.$advertiser_details['last_name'];
						$from 		   = $admin_email;
						$to  		   =  $user_email;			
						$mail_content=array(
							"subject" 	   => "Creative rejected",
							"to_name" 	   => $user_name,				
							"from_name"	   => $admin_name,
							"email"  	   => $user_email,
							'banner_name'  => $reject_list['description']
							 
						);
							$attachement='';


			$notification_msg = $this->do_message->get_notification_msg('creative_reject'); 
			if($notification_msg[0]['msg_type']=='1')
			{
				$notification_content = $notification_msg[0]['content'];
			}
			else
			{
				$template_filename = $notification_msg[0]['template_filename'];
				$csvfilepath 	= $this->config->item('read_settings');	
				$notification_content = file_get_contents($csvfilepath.$template_filename);
											
			}		
			$adgate_url	=	base_url();
			$prod_name	= 	$this->config->item('prod_name');
			$msg_replace = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
			$msg_replace = str_replace("{{advertiser_name}}",$reciever['name'],$msg_replace);	

			$msg_replace = str_replace("{{creative_name}}",$mail_content['banner_name'],$msg_replace);
			//$msg_replace = str_replace("{{storage_type}}",$content['creative_ml'],$msg_replace);
			$msg_replace = str_replace("{{admin_name}}",$user['first_name'].' '.$user['last_name'] ,$msg_replace);
			$msg_replace = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace);
			$msg_replace = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.$adgate_url.'">'.$this->config->item('click_directADS').'</a>' ,$msg_replace);	
			
			
						//	$this->response($advertiser_details,200);
						$dat = $this->notification->new_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);

						
					}
				}
			}
	   }
	   else
	   {
	       $success = array('response'	=> 'ok',
							 'msg'		=> 'Creative has been Approved / Rejected Previously by admin'
							 ); 
		   $this->response($success);
	   }
	}
	
	
	public function reject_mobileapp_get()
	{
	   $app_id = $this->get('reject_app_id');
	   
	   if($app_id)
		{
			$app_ids	=	explode(',',$app_id);
			if(is_array($app_ids))
			{
				foreach($app_ids as $app_id)
				{
					$success=$this->mobileapp_rejc($app_id);
				}
				$success = array('response'	=> 'ok',
									'msg'		=> 'Mobile Application has been rejected successfully'
									); 
				$this->response($success);
			}
		}
	}
	
	function mobileapp_rejc($app_id)
	{
	   //CHECK THE MOBILE APPLICATION IS APPROVED / REJECTED PREVIOUSLY
	   $application_id =$this->do_creative->is_app_id($app_id); 
	   
	   if($application_id!='')
	   { 
			$reject_list =$this->do_creative->reject_mobileapp($app_id); 
			
			/* Activity Log for MobileApp Reject - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_APPROVALS,APP_REJECT);
					if($enable=='1')
					{							
					$this->activity_log(MOBILE_APP,REJECT);
					}
			/* Activity Log for MobileApp Reject - End*/	
			
			
			if($reject_list)
			{				
				//Get admin details
				if($this->user_authentication->account_type == "ADMIN" )
				{
				     	$agency_id	=	$this->user_authentication->agency_id;
			     		$result=$this->do_networks->agency_owner_details($agency_id);						
						$user = $this->do_message->get_profile(ADMIN_ID);
						$user_email = $reject_list['email'];					
						$network_id	=	$this->do_message->fetch_admin_network_id();
						$type = "PUBLISHER_MOBILEAPP_REJECTED";
						$acc_type='ADMIN';
										
						$admin_name   =$user['first_name'].' '.$user['last_name'];	
						$admin_email   =$user['email'];
						$from 		   = $admin_email;
															
						$mail_content=array(
							"subject" 	   => "Creative rejected",
							"from_name"	   => $admin_name,
							"email"  	   => $user_email,
							"app_url"	   => $reject_list['app_url'],
							"app_name"	   => $reject_list['app_name'],
							"os_type"	   => $reject_list['os_type']												 
						);
						
						send_mail($type,$from,$to,$mail_content,$bcc,$subject); 					  
												
				}
				else
				{
					// IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
					$manager_user_id = $this->user_authentication->manager_user_id;
					$is_manager = $this->do_networks->get_manager_role($manager_user_id);
					if($is_manager == 1)
					{	
						// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->do_networks->agency_owner_details($agency_id);
						
						$user = $this->do_message->get_profile(ADMIN_ID);
											 
						
						$network_id	=	$this->do_message->fetch_admin_network_id();
						$type = "PUBLISHER_MOBILEAPP_REJECTED";
						$acc_type='ADMIN';
													
						$admin_name   =$user['first_name'].' '.$user['last_name'];	
						$admin_email   =$user['email'];
						$from 		   = $admin_email;
						$to  		   =  $reject_list['email'];			
						$mail_content=array(
							"subject" 	   => "Mobile Application rejected",
							"from_name"	   => $admin_name,
							"email"  	   => $to,
							"app_url"	   => $reject_list['app_url'],
							"app_name"	   => $reject_list['app_name'],
							"os_type"	   => $reject_list['os_type']												 
							 
						);
							send_mail($type,$from,$to,$mail_content,$bcc,$subject); 					  
					}
					else
					{
						// GET NETWORK USERS MAILING DETAILS
						$user_mailing_details = $this->do_networks->get_network_users_detail($manager_user_id);
						$admin_email = $user_mailing_details['email_address'];
						$admin_name = $user_mailing_details['contact_name'];
						
						$user = $this->do_message->get_profile(ADMIN_ID);
						$user_email = $reject_list['email'];
												
						$network_id	=	$this->do_message->fetch_admin_network_id();
						$type = "PUBLISHER_MOBILEAPP_REJECTED";
						$acc_type='ADMIN';

											
						$admin_name   =$user['first_name'].' '.$user['last_name'];	
						$admin_email   =$user['email'];
						$from 		   = $admin_email;
						$to  		   =  $user_email;			
						$mail_content=array(
							"subject" 	   => "Mobile Application rejected",							
							"from_name"	   => $admin_name,
							"email"  	   => $user_email,
							"app_url"	   => $reject_list['app_url'],
							"app_name"	   => $reject_list['app_name'],
							"os_type"	   => $reject_list['os_type']												 						 
						);
							
						send_mail($type,$from,$to,$mail_content,$subject); 					  
					}
				}
			}
	   }
	   else
	   {
	       $success = array('response'	=> 'ok',
							 'msg'		=> 'Creative has been Approved / Rejected Previously by admin'
							 ); 
		   $this->response($success);
	   }
	}
  
   /*
   * 
   * name: preview_creative_get
   * @param :
   * @return : $preview_creative
   */
	public function preview_creative_get()
	{
	   $banner_id = $this->get('banner_id');
	   
	  // echo "<br>welcom".$banner_id;
	   
	   $preview_creative =$this->do_creative->preview_creative($banner_id); 
	   
	   $this->response($preview_creative);
   }
   
   public function preview_adblock_get()
	{
	   $zone_id = $this->get('zone_id');
	  	     
	   $preview_adblock =$this->do_creative->preview_adblock($zone_id); 
	   
	   $this->response($preview_adblock);
   }
   
   public function preview_additional_adblock_get()
	{
	   $banner_id = $this->get('banner_id');
	  	     
	   $preview_additional_adblock =$this->do_creative->preview_additional_banners($banner_id); 
	   
	   $this->response($preview_additional_adblock);
   }
   
   
   /*
   * 
   * name: fetch_dcampaign_list_get
   * @param :
   * @return :Fetch list of direct campains need to be approve
   */
   public function fetch_dcampaign_list_get()
   {
	   	$dcampaign_list =$this->do_payments->fetch_dcampaign_list(); 
	   	$this->response($dcampaign_list);
   }
   
   /*
   * 
   * name: fetch_payment_list_get
   * @param :
   * @return :Fetch list of payments need to be approve
   */
   public function fetch_payment_list_get()
   {
       $agencyid = $this->user_authentication->agency_id;
	   $payment_list =$this->do_payments->fetch_payment_list($agencyid); 
	   $this->response($payment_list);
   }
   
   
   /*
	* 
	* name: payment_approve_get
	* @param :
	* @return : $success
    */
	public function payment_approve_post()
	{
		$ids=clean_data($this->post('pay_id'));
		$amount=clean_data($this->post('amount'));
		$account_id=clean_data($this->post('account_id')); 	

	   if($ids)
		{
			$id	=	explode(',',$ids);
		    $amount		=	explode(',',$amount);
		    $account_id	=	explode(',',$account_id);

			if(is_array($id))
			{ 
				
				$arrlength = count($id);
				for($x = 0; $x <  $arrlength; $x++) 
				{
					$tempObj = $this->pay_aprv($id[$x],$amount[$x],$account_id[$x]);
				}
				$success = array('response'	=> 'ok',
								 'msg'		=> 'Payment has been Approved successfully'
								); 
				$this->response($success,200);
			}
			else
			{ 
				$tempObj = $this->pay_aprv($id,$amount,$account_id);
				$success = array('response'	=> 'ok',
					 'msg'		=> 'Payment has been Approved successfully'
					); 
				$this->response($success,200);
			}

		}
	}
	function pay_aprv($id,$amount,$account_id)
	 
	{
		//CHECK WHETHER PAYMENT IS WAITING FOR APPROVE
		$payment_id=$this->do_payments->check_payment_process($id);

		
		$payment_approve=$this->do_payments->payment_approve($id,$amount,$account_id);   
     
		if($payment_approve!=0 && $payment_id)
		{
			
			/* Activity Log for approve payment - Start*/				
		
				$enable	=  	$this->default_configurations->activity_log_setting(PAYMENT,PAYMENT_APPR);
					if($enable=='1')
					{				
						$this->activity_log(PAYMENT,APPROVE);
					}
		/* Activity Log for approve payment - End*/	
	        //Sending mail to advertiser for approve their added fund
			//Get advertiser details
			$advertiser_details=$this->do_advertiser->get_profile($account_id); 

			$advertiser_email=$advertiser_details['email'];
			$advertiser_total_balance=$advertiser_details['dj_cur_balance'];
			//Get admin details
			if($this->user_authentication->account_type == "ADMIN" )
			{   
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->do_networks->agency_owner_details($agency_id);
				$admin_name    = $result['name'];			
				$admin_email   = $result['email'];
				$user_email    = $advertiser_email;
				$amount = $amount;
				$currency      = $this->config->item('currency');
				$total_amount  = $advertiser_total_balance;
				$user_name     = $advertiser_details['first_name']." ".$advertiser_details['last_name'];
				$type     ="ADV_APPROVE_ADD_FUND_EMAIL";
				$from 	=  $admin_email;
				$to  	=  $user_email;			
				/*$mail_content=array(
						"subject" 		=> "Approve Added Fund",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						"added_amount"  => $amount,
						"total_amount"  => $total_amount,
						"currency"      => $currency								
						);*/
				$attachement='';	
				$type_details		=	array(
				'msg_type'		=> $message,
				'type'			=> $type,
				'string'		=> "payment_appr",
				'column_name'	=> "payments");
				$user = $this->do_message->get_profile(ADMIN_ID);
				$network_id	=	$this->do_message->fetch_admin_network_id();
				$message_data		=	array(
						'sender_id'		=>	ADMIN_ID,
						'receiver_id'	=>	$account_id,
						'subject'		=>	'Fund Approved',
						'content'		=>	'Congrats! You amount $'.$amount.' successfully approved.',
						'image_name'	=>	NULL,
						'file_name'		=>	NULL,
						'account_type'	=>	'ADVERTISER',
						'notification_type'	=>	"payment_setting",	
						'status'		=>	'1',
						'network_id'	=>	$network_id,									
						'date'			=>	date('Y-m-d H:i:s')
						);
					$notification_value ='payment_appr';
					$notification_msg = $this->do_message->get_notification_msg($notification_value); 
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
						
					$searchStr=$this->config->item('macros');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}
					if($count>0)
					{
					$msg = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{advertiser_name}}",$user_name,$msg);	
					$msg = str_replace("{{amount}}",$amount,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'"/admin>Login</a>' ,$msg);
					$mail_content = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('click_directADS').'</a>' ,$msg);					
					}
					else
					{
						$mail_content=$notification_content;
					}
					
																	
			$dd = $this->notification->pub_notification_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);
			
			//$dd = $this->notification->new_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);
			
			//send_mail($type,$from,$to,$mail_content,$attachement);
				
			}
			else
			{   
				// IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
				$manager_user_id = $this->user_authentication->manager_user_id;
				$is_manager = $this->do_networks->get_manager_role($manager_user_id);
				if($is_manager == 1)
				{	
					// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);
					
					$network_admin=$this->do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $advertiser_email;
					$amount = $amount;
					$currency      = $this->config->item('currency');
					$total_amount  = $advertiser_total_balance;
					$user_name     = $advertiser_details['first_name']." ".$advertiser_details['last_name'];
					$type     ="ADV_APPROVE_ADD_FUND_EMAIL";
					$from 	=  $admin_email;
					$to  	=  $user_email;			
					$mail_content=array(
						"subject" 		=> "Approve Added Fund",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						"added_amount"  => $amount,
						"total_amount"  => $total_amount,
						"currency"      => $currency								
						);
					$type_details		=	array(
					'msg_type'		=> $message,
					'type'			=> $type,
					'string'		=> "payment_appr",
					'column_name'	=> "payments",
					'bcc'			=> $bcc
					);
					$user = $this->do_message->get_profile(ADMIN_ID);
					$network_id	=	$this->do_message->fetch_admin_network_id();
					$message_data		=	array(
							'sender_id'		=>	ADMIN_ID,
							'receiver_id'	=>	$account_id,
							'subject'		=>	'Fund Approved',
							'content'		=>	'Congrats! You amount $'.$amount.' successfully approved.',
							'image_name'	=>	NULL,
							'file_name'		=>	NULL,
							'account_type'	=>	'ADVERTISER',
							'notification_type'	=>	"payment_setting",	
							'status'		=>	'1',
							'network_id'	=>	$network_id,									
							'date'			=>	date('Y-m-d H:i:s')
							);		
					$attachement='';
					$notification_value ='payment_appr';
					$notification_msg = $this->do_message->get_notification_msg($notification_value); 
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
						
					$searchStr=$this->config->item('macros');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}
					if($count>0)
					{
					$msg = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{advertiser_name}}",$user_name,$msg);	
					$msg = str_replace("{{amount}}",$amount,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'"/admin>Login</a>' ,$msg);
					$mail_content = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('click_directADS').'</a>' ,$msg);					
					}
					else
					{
						$mail_content=$notification_content;
					}
												
					$dd = $this->notification->pub_notification_mail($message_data,$user,$advertiser_details,$type_details,		$mail_content);
					
					//$dd = $this->notification->new_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);
						
				}
				else
				{
					// GET NETWORK USERS MAILING DETAILS
					$user_mailing_details = $this->do_networks->get_network_users_detail($manager_user_id);
					$admin_email = $user_mailing_details['email_address'];
					$admin_name = $user_mailing_details['contact_name'];
					
					// GET NETWORK MANAGER MAILING DETAIL FOR BCC
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);
					$bcc = $result['email'];
					
					$user_email    = $advertiser_email;
					$amount = $amount;
					$currency      = $this->config->item('currency');
					$total_amount  = $advertiser_total_balance;
					$user_name     = $advertiser_details['first_name']." ".$advertiser_details['last_name'];
					$type     ="ADV_APPROVE_ADD_FUND_EMAIL";
					$from 	=  $admin_email;
					$to  	=  $user_email;			
					$mail_content=array(
						"subject" 		=> "Approve Added Fund",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						"added_amount"  => $amount,
						"total_amount"  => $total_amount,
						"currency"      => $currency								
						);
					$attachement='';	
					$type_details		=	array(
					'msg_type'		=> $message,
					'type'			=> $type,
					'string'		=> "payment_appr",
					'column_name'	=> "payments",
					'bcc'			=> $bcc
					);
					$user = $this->do_message->get_profile(ADMIN_ID);
					$network_id	=	$this->do_message->fetch_admin_network_id();
					$message_data		=	array(
							'sender_id'		=>	ADMIN_ID,
							'receiver_id'	=>	$account_id,
							'subject'		=>	'Fund Approved',
							'content'		=>	'Congrats! You amount $'.$amount.' successfully approved.',
							'image_name'	=>	NULL,
							'file_name'		=>	NULL,
							'account_type'	=>	'ADVERTISER',
							'notification_type'	=>	"payment_setting",	
							'status'		=>	'1',
							'network_id'	=>	$network_id,									
							'date'			=>	date('Y-m-d H:i:s')
							);		
					$attachement='';	
					$notification_value ='payment_appr';
					$notification_msg = $this->do_message->get_notification_msg($notification_value); 
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
						
					$searchStr=$this->config->item('macros');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}
					if($count>0)
					{
					$msg = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{advertiser_name}}",$user_name,$msg);	
					$msg = str_replace("{{amount}}",$amount,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'"/admin>Login</a>' ,$msg);
					$mail_content = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('click_directADS').'</a>' ,$msg);					
					}
					else
					{
						$mail_content=$notification_content;
					}
												
					$dd = $this->notification->pub_notification_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);
					//$dd = $this->notification->new_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);
					
						
				}
			}
		}
		else
		{
	      $error = array('response'	=> 'ok',
							 'msg'		=> 'Payment has been Approved / Rejected previously!..'
							 ); 
		 $this->response($error,200);
		}
	}
	
	/*
	* 
	* name: payment_reject_get
	* @param :
	* @return : $success
    */
	public function payment_reject_post()
	{
	 $id = clean_data($this->post('rej_pay_id'));
		if($id)
		{
			$pay_ids	=	explode(',',$id);
		
			if(is_array($pay_ids))
			{ 
				foreach($pay_ids as $id)
				{				
					$tempObj = $this->pay_rejct($id);
				}
			}
			else
			{ 
				$tempObj = $this->pay_rejct($id);
			}
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Payment has been rejected successfully'
							 ); 
			$this->response($success);
		}
	}
	
	function pay_rejct($id)
	{
	
	   //CHECK WHETHER PAYMENT IS WAITING FOR APPROVE
	   $payment_id=$this->do_payments->check_payment_process($id);
	   $account_id =$this->do_payments->payment_reject($id);
	   if($account_id && $payment_id){
		   
				/* Activity Log for approve payment - Start*/				
		
				$enable	=  	$this->default_configurations->activity_log_setting(PAYMENT,PAYMENT_REJECT);
					if($enable=='1')
					{				
						$this->activity_log(PAYMENT,REJECT);
					}
				/* Activity Log for approve payment - End*/	
		   
	        //Sending mail to advertiser for approve their added fund
			//Get advertiser details
			$advertiser_details=$this->do_advertiser->get_user_information($account_id); 
			$advertiser_info=$advertiser_details[0];
			//Get admin details
			if($this->user_authentication->account_type == "ADMIN" )
			{
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->do_networks->agency_owner_details($agency_id);			
				$admin_name    = $result['name'];			
				$admin_email   = $result['email'];
				$user_email    = $advertiser_info['email'];
				#$amount        = $added_amount;
				$user_name     = $advertiser_info['dj_first_name']." ".$advertiser_info['dj_last_name'];
				$type     ="ADV_REJECT_ADD_FUND_EMAIL";
				$from 	=  $admin_email;
				$to  	=  $user_email;			
				$mail_content=array(
					"subject" 		=> "Rejected Added Fund",
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email
					#"added_amount"  => $amount,
					#"currency"      => $currency								
					);
				$attachement='';	
				$type_details		=	array(
					'msg_type'		=> $message,
					'type'			=> $type,
					'string'		=> "payment_reject",
					'column_name'	=> "payments",
					
					);
					$user = $this->do_message->get_profile(ADMIN_ID);
					$network_id	=	$this->do_message->fetch_admin_network_id();
					$message_data		=	array(
							'sender_id'		=>	ADMIN_ID,
							'receiver_id'	=>	$account_id,
							'subject'		=>	'Fund Rejected',
							'content'		=>	'You amount rejected by admin.',
							'image_name'	=>	NULL,
							'file_name'		=>	NULL,
							'account_type'	=>	'ADVERTISER',
							'notification_type'	=>	"payment_setting",	
							'status'		=>	'1',
							'network_id'	=>	$network_id,									
							'date'			=>	date('Y-m-d H:i:s')
							);		
					$attachement='';	
					
					$notification_value ='payment_reject';
					$notification_msg = $this->do_message->get_notification_msg($notification_value); 
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
						
					$searchStr=$this->config->item('macros');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}
					if($count>0)
					{
					$msg = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{advertiser_name}}",$user_name,$msg);	
					//$msg = str_replace("{{amount}}",$amount,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'"/admin>Login</a>' ,$msg);
					$mail_content = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('click_directADS').'</a>' ,$msg);					
					}
					else
					{
						$mail_content=$notification_content;
					}
												
			        $dd = $this->notification->pub_notification_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);
					
					
					//$dd = $this->notification->new_mail($message_data,$user,$advertiser_info,$type_details,$mail_content);
				 
				
			}
			else
			{
				// IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
				$manager_user_id = $this->user_authentication->manager_user_id;
				$is_manager = $this->do_networks->get_manager_role($manager_user_id);
				if($is_manager == 1)
				{	
					// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);
				
					$network_admin=$this->do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $advertiser_info['email'];
					#$amount        = $added_amount;
					$user_name     = $advertiser_info['dj_first_name']." ".$advertiser_info['dj_last_name'];
					$type     ="ADV_REJECT_ADD_FUND_EMAIL";
					$from 	=  $admin_email;
					$to  	=  $user_email;			
					/*$mail_content=array(
						"subject" 		=> "Rejected Added Fund",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email
						#"added_amount"  => $amount,
						#"currency"      => $currency								
						);*/
					$attachement='';	
					$type_details		=	array(
					'msg_type'		=> $message,
					'type'			=> $type,
					'string'		=> "payment_reject",
					'column_name'	=> "payments",
					'bcc'			=> $bcc
					);
					$user = $this->do_message->get_profile(ADMIN_ID);
					$network_id	=	$this->do_message->fetch_admin_network_id();
					$message_data		=	array(
							'sender_id'		=>	ADMIN_ID,
							'receiver_id'	=>	$account_id,
							'subject'		=>	'Fund Rejected',
							'content'		=>	'You amount rejected by admin.',
							'image_name'	=>	NULL,
							'file_name'		=>	NULL,
							'account_type'	=>	'ADVERTISER',
							'notification_type'	=>	"payment_setting",	
							'status'		=>	'1',
							'network_id'	=>	$network_id,									
							'date'			=>	date('Y-m-d H:i:s')
							);		
					$attachement='';	
					$notification_value ='payment_reject';
					$notification_msg = $this->do_message->get_notification_msg($notification_value); 
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
						
					$searchStr=$this->config->item('macros');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}
					if($count>0)
					{
					$msg = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{advertiser_name}}",$user_name,$msg);	
					//$msg = str_replace("{{amount}}",$amount,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'"/admin>Login</a>' ,$msg);
					$mail_content = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('click_directADS').'</a>' ,$msg);					
					}
					else
					{
						$mail_content=$notification_content;
					}
												
			        $dd = $this->notification->pub_notification_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);			 
					 
				}
				else
				{
					// GET NETWORK USERS MAILING DETAILS
					$user_mailing_details = $this->do_networks->get_network_users_detail($manager_user_id);
					$admin_email = $user_mailing_details['email_address'];
					$admin_name = $user_mailing_details['contact_name'];
					
					// GET NETWORK MANAGER MAILING DETAIL FOR BCC
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);
					$bcc = $result['email'];
					
					$user_email    = $advertiser_info['email'];
					#$amount        = $added_amount;
					$user_name     = $advertiser_info['dj_first_name']." ".$advertiser_info['dj_last_name'];
					$type     ="ADV_REJECT_ADD_FUND_EMAIL";
					$from 	=  $admin_email;
					$to  	=  $user_email;			
					/*$mail_content=array(
						"subject" 		=> "Rejected Added Fund",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email
						#"added_amount"  => $amount,
						#"currency"      => $currency								
						);*/
					$attachement='';	
					$type_details		=	array(
					'msg_type'		=> $message,
					'type'			=> $type,
					'string'		=> "payment_reject",
					'column_name'	=> "payments",
					'bcc'			=> $bcc
					);
					$user = $this->do_message->get_profile(ADMIN_ID);
					$network_id	=	$this->do_message->fetch_admin_network_id();
					$message_data		=	array(
							'sender_id'		=>	ADMIN_ID,
							'receiver_id'	=>	$account_id,
							'subject'		=>	'Fund Rejected',
							'content'		=>	'You amount rejected by admin.',
							'notification_type'	=>	"payment_setting",	
							'image_name'	=>	NULL,
							'file_name'		=>	NULL,
							'account_type'	=>	'ADVERTISER',
							'status'		=>	'1',
							'network_id'	=>	$network_id,									
							'date'			=>	date('Y-m-d H:i:s')
							);		
					$attachement='';	
					//$dd = $this->notification->new_mail($message_data,$user,$advertiser_info,$type_details,$mail_content);
					$notification_value ='payment_reject';
					$notification_msg = $this->do_message->get_notification_msg($notification_value); 
					if($notification_msg[0]['msg_type']=='1')
					{
						$notification_content = $notification_msg[0]['content'];
					}
					else
					{
						$template_filename = $notification_msg[0]['template_filename'];
						$csvfilepath 	= $this->config->item('read_settings');	
						$notification_content = file_get_contents($csvfilepath.$template_filename);
					} 
						
					$searchStr=$this->config->item('macros');
					$count=0;
					foreach($searchStr as $search)
					{	
					 if (strpos($notification_content, $search) !== false)
						 {
						$count++;
						}
					}
					if($count>0)
					{
					$msg = str_replace("{{Product_name}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('prod_name').'</a>',$notification_content);
					$msg = str_replace("{{advertiser_name}}",$user_name,$msg);	
					//$msg = str_replace("{{amount}}",$amount,$msg);
					$msg = str_replace("{{admin_name}}",$admin_name ,$msg);
					$msg = str_replace("{{login}}",'<a href="'.base_url().'"/admin>Login</a>' ,$msg);
					$mail_content = str_replace("{{click_here}}",'<a style="color:#FFF;" href="'.base_url().'">'.$this->config->item('click_directADS').'</a>' ,$msg);					
					}
					else
					{
						$mail_content=$notification_content;
					}
												
			        $dd = $this->notification->pub_notification_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);			 
					  
				}		
			}
	    }
		else
		{
			$error = array('response'	=> 'ok',
							'msg'		=> 'Payment has been Approved / Rejected previously!..'
							); 
			$this->response($error,200);
		}
	}
	/******************** Direct Campaign Payment Approve/Reject ********************/
	/*
	* 
	* name: direct_campaign_approve_get
	* @param :
	* @return : $success
    */
	public function direct_campaign_approve_post()
	{	
		$agency_id	 	= 	$this->user_authentication->agency_id;	
		$campaignid	=	clean_data($this->post('campaign_id'));

		if($campaignid)
		{
           $campaignid	=	explode(',',$campaignid);
           if(is_array($campaignid))
		   {
		   	foreach($campaignid as $campaignidsnew)
	        {
					$campid	=	$this->do_campaign->get_campaign_values($campaignidsnew);
				
					$camp_approve	=	$this->do_campaign->direct_campaign_approve($campid);
					/* Activity Log for MobileApp Reject - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_APPROVALS,DRC_APPROVAL);
					if($enable=='1')
					{							
					$this->activity_log(DRCAMPAIGN,APPROVE);
					}
			/* Activity Log for MobileApp Reject - End*/
				$result			=	$this->do_networks->agency_owner_details($agency_id);
				$camp_details	=	$this->do_campaign->direct_campaign_mail($campid);
				
				$admin_name    	= 	$result['name'];			
				$admin_email   	= 	$result['email'];
						
				$campaignid 		= $camp_details['campid']; 
				$cam_name 			= $camp_details['username']; 
				$to_name 			= $camp_details['campaignname']; 
				$dj_targetting_type = $camp_details['dj_targetting_type']; 
				$status				= $camp_details['status'] == 0 ? 'Active' : 'Inactive'; 
			
				$activate_time 		= isset($camp_details['activate_time']) ? $camp_details['activate_time'] : ' ' ; 
				
				$expire_time 		= isset($camp_details['expire_time']) ? ' To '.date("Y-m-d", strtotime($camp_details['expire_time'])) : ' '; 
						
				$to_email 			= $camp_details['email']; 
				$budget				= $camp_details['budget']; 
				$revenue_type		= $camp_details['formated_revenue_type'];  
				$user_id  			=  urlencode(base64_encode($campid));
				
				
				$type 	= "Direct_Campaign_Approve";
						
				$mail_content	=	array(
												"subject" 		=> 	"Direct Campaign Approve",
												"to_name" 		=> 	$to_name,
												"cam_name" 		=> 	$cam_name,
												"from_name"		=> 	$admin_name,
												"email"  		=> 	$email,
												"activate_time"		=>	$activate_time,
												"expire_time"		=>	$expire_time,
												"budget"		=>	$budget,
												"revenue_type"	=>	$revenue_type,
												"status"		=>	$status,
												"user_id"		=>	$user_id
											);			
									
					
				//$attachement 	= 	$this->config->item('csv_report').$filename;
				
				
				
					send_mail($type,$admin_email,$to_email,$mail_content,'');
				}
		   }
		   else
		   {
		   	 $camp_approve	=	$this->do_campaign->direct_campaign_approve($campaignid);

		   	 /* Activity Log for MobileApp Reject - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_APPROVALS,DRC_APPROVAL);
					if($enable=='1')
					{							
					$this->activity_log(DRCAMPAIGN,APPROVE);
					}
			/* Activity Log for MobileApp Reject - End*/
				$result			=	$this->do_networks->agency_owner_details($agency_id);
				$camp_details	=	$this->do_campaign->direct_campaign_mail($campaignid);
				
				$admin_name    	= 	$result['name'];			
				$admin_email   	= 	$result['email'];
						
				$campaignid 		= $camp_details['campaignid']; 
				$cam_name 			= $camp_details['username']; 
				$to_name 			= $camp_details['campaignname']; 
				$dj_targetting_type = $camp_details['dj_targetting_type']; 
				$status				= $camp_details['status'] == 0 ? 'Active' : 'Inactive'; 
			
				$activate_time 		= isset($camp_details['activate_time']) ? $camp_details['activate_time'] : ' ' ; 
				
				$expire_time 		= isset($camp_details['expire_time']) ? ' To '.date("Y-m-d", strtotime($camp_details['expire_time'])) : ' '; 
						
				$to_email 			= $camp_details['email']; 
				$budget				= $camp_details['budget']; 
				$revenue_type		= $camp_details['formated_revenue_type'];  
				$user_id  			=  urlencode(base64_encode($campaignid));
				
				
				$type 	= "Direct_Campaign_Approve";
						
				$mail_content	=	array(
												"subject" 		=> 	"Direct Campaign Approve",
												"to_name" 		=> 	$to_name,
												"cam_name" 		=> 	$cam_name,
												"from_name"		=> 	$admin_name,
												"email"  		=> 	$email,
												"activate_time"		=>	$activate_time,
												"expire_time"		=>	$expire_time,
												"budget"		=>	$budget,
												"revenue_type"	=>	$revenue_type,
												"status"		=>	$status,
												"user_id"		=>	$user_id
											);			
									
					
				//$attachement 	= 	$this->config->item('csv_report').$filename;
				
				
				
					send_mail($type,$admin_email,$to_email,$mail_content,'');
		   }

		 
		if($camp_approve)
		{
			$success 	=	array('response'	=> 'ok',
								  'msg'			=> 'Campaign has been approved successfully'
						 ); 
			$this->response($success,200);
		}
		else
		{
			$error 		= 	array('response'	=> 'ok',
								  'msg'			=> 'Error! Please try again...'
						 ); 
			$this->response($error,200);
		}	
		
		}
		
	}
	
	
	/*
	* 
	* name: direct_payment_approve_get
	* @param :
	* @return : $success
    */
	public function direct_payment_approve_post()
	{
		$ids		=	clean_data($this->post('pay_id'));
		$amount		=	clean_data($this->post('amount'));
		$campaignid	=	clean_data($this->post('campaign_id'));
		
		//CHECK WHETHER PAYMENT IS WAITING FOR APPROVE
		//$payment_id=$this->do_payments->check_dirpayment_process($id);		
			$id			=	explode(',',$ids);
		    $amount		=	explode(',',$amount);
		    $campaignid	=	explode(',',$campaignid);

			if(is_array($id))
			{ 
				
					$arrlength = count($id);
					for($x = 0; $x <  $arrlength; $x++) 
					{
						$payment_approve	=	$this->do_payments->direct_payment_approve($id[$x],$amount[$x],$campaignid[$x]);
						
						/* Activity Log for direct payment Approval - Start*/	
						$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_APPROVALS,DRC_PAYMENT_APPROVAL);
						if($enable=='1')
						{							
						$this->activity_log(PUBLISHER,DRC_PAYMENT_APPROVAL);
						}
						/* Activity Log for direct payment Approval- End*/
				
					}
					

				$success 	= 	array('response'=> 	'ok',
									'msg'		=> 	'Payment has been approved successfully'
								); 
				$this->response($success,200);
				
			}
	}
	
	/*
	* 
	* name: direct_payment_reject_get
	* @param :
	* @return : $success
    */
	public function direct_payment_reject_post()
	{
	   $id = clean_data($this->post('rej_pay_id')); 
		if($id)
		{
			$rej_paymt_id	=	explode(',',$id);
			if(is_array($rej_paymt_id))
			{ 
				foreach($rej_paymt_id as $id)
				{
					$reject= $this->direct_pay_rej($id);
				}
			}
			else
			{
				$reject= $this->direct_pay_rej($id);
			}
		}
	}
	   
	function direct_pay_rej($id)
	{
	   //CHECK WHETHER PAYMENT IS WAITING FOR APPROVE
	   $payment	=	$this->do_payments->get_dirpayment_details($id);
	   if($payment!=FALSE)
	   {
			$pay	=	$payment[0];
			$transactionID 	= 	urlencode($pay['txn_id']);//Refund account - transation id(buyer transaction id)
			$refundType 	= 	urlencode('Full');  // or 'Partial'
			$amount			=	$pay['amount'];                          // required if Partial.
			$memo			=	'';                 // required if Partial.
			$subject		=	$pay['receiver_email'];
			$currencyID 	= 	urlencode('USD');   // or other currency ('GBP', 'EUR', 'JPY', 'CAD', 'AUD')
			// Add request-specific fields to the request string.
			$nvpStr = 	"&TRANSACTIONID=$transactionID&REFUNDTYPE=$refundType&CURRENCYCODE=$currencyID&SUBJECT=$subject";
			
			//Subject - API user paypal id
			
			if(isset($memo)) {
				$nvpStr .= "&NOTE=$memo";
			}
			 
			if(strcasecmp($refundType, 'Partial') == 0) {
				if(!isset($amount)) {
					$mmsg	=	'Partial Refund Amount is not specified.';
					$error 	= 	array(	'response'	=> 	'error',
										'msg'		=> 	$mmsg
									); 
					$this->response($error,200);
				}
				else {
					$nvpStr = $nvpStr."&AMT=$amount";
				}
				 
				if(!isset($memo)) {
					$mmsg	=	'Partial Refund Memo is not specified.';
					$error = array(	'response'	=> 	'error',
									'msg'		=> 	$mmsg
								 ); 
					$this->response($error,200);
				}
			}
			 
			// Execute the API operation; see the PPHttpPost function above.
			$httpParsedResponseAr = $this->PPHttpPost('RefundTransaction', $nvpStr);
			 
			
			if(strtoupper($httpParsedResponseAr["ACK"] == "SUCCESS" ) ||
			   strtoupper($httpParsedResponseAr["ACK"] == "SUCCESSWITHWARNING")) {
				
				$campaign_id 	=	$this->do_payments->direct_payment_reject($id);
				$alt_key		=	clean_data($this->post('alt_key'));
			   
				if(!empty($alt_key))
				{
					$mmsg	=	'Campaign has been rejected successfully';
					$agency_id	 	= 	$this->user_authentication->agency_id;	
					$result			=	$this->do_networks->agency_owner_details($agency_id);
					$camp_details	=	$this->do_campaign->direct_campaign_mail($campaign_id);
					
					/* Activity Log for MobileApp Reject - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_APPROVALS,DRC_REJECT);
					if($enable=='1')
					{							
					$this->activity_log(DRCAMPAIGN,REJECT);
					}
					/* Activity Log for MobileApp Reject - End*/
					
					$admin_name    	= 	$result['name'];			
					$admin_email   	= 	$result['email'];
							
					$campaignid 		= 	$camp_details['campaignid']; 
					$cam_name 			= 	$camp_details['username']; 
					$to_name 			= 	$camp_details['campaignname']; 
					$dj_targetting_type = 	$camp_details['dj_targetting_type']; 
					$status				= 	$camp_details['status'] == 0 ? 'Actvie' : 'Inactive'; 
				
					$activate_time 		= 	isset($camp_details['activate_time']) ? $camp_details['activate_time'] : ' ' ; 
					
					$expire_time 		= 	isset($camp_details['expire_time']) ? ' To '.date("Y-m-d", strtotime($camp_details['expire_time'])) : ' '; 
					
					
					$to_email 			= 	$camp_details['email']; 
					$budget				= 	$camp_details['budget']; 
					$revenue_type		= 	$camp_details['formated_revenue_type'];  
					$user_id  			=  	base64_encode($campaignid);
					
					$type     	   	= 	"DIRECT_CAMPAIGN_REJECT";			
					
					//If Admin change his password then it will works
					$attachement	=	'';
					$mail_content	=	array(
											"subject" 		=> 	"Direct Campaign Reject",
											"to_name" 		=> 	$to_name,
											"cam_name" 		=> 	$cam_name,
											"from_name"		=> 	$admin_name,
											"email"  		=> 	$email,
											"activate_time"	=>	$activate_time,
											"expire_time"	=>	$expire_time,
											"budget"		=>	$budget,
											"revenue_type"	=>	$revenue_type,
											"status"		=>	$status,
											"user_id"		=>	$user_id
										);
					send_mail($type,$admin_email,$to_email,$mail_content,$attachement,$admin_email); 

				}
				else
				{
					$mmsg	=	'Payment has been rejected successfully';
				}
								
				$success 	= 	array(	'response'	=> 'ok',
										'msg'		=> $mmsg
									); 
				$this->response($success,200);
			}
			else  {
				$mmsg	=	'Reject failed! because Authentication/Authorization failed('.$httpParsedResponseAr["L_ERRORCODE0"].') in Refund Transaction.';
				$error 	= 	array(	'response'	=> 'error',
									'msg'		=> $mmsg
								 ); 
				$this->response($error,200);
			}
		}
		
		else
		{
			$error 	= 	array(	'response'	=> 'error',
								'msg'		=> 'Invoice does not exist.'
							); 
			$this->response($error,200);
		}
		
	   /*if($campaign_id && $id){
	        //Sending mail to advertiser for approve their added fund
			//get account id
			$campaign_details=$this->do_campaign->fetch_campaign($campaign_id); 
			$advertiser_info=$campaign_details[0];
			//Get admin details
			if($this->user_authentication->account_type == "ADMIN" )
			{
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->do_networks->agency_owner_details($agency_id);			
				$admin_name    = $result['name'];			
				$admin_email   = $result['email'];
				$user_email    = $advertiser_info['email'];
				#$amount        = $added_amount;
				$user_name     = $advertiser_info['dj_first_name']." ".$advertiser_info['dj_last_name'];
				$type     ="ADV_REJECT_ADD_FUND_EMAIL";
				$from 	=  $admin_email;
				$to  	=  $user_email;			
				$mail_content=array(
					"subject" 		=> "Rejected Added Fund",
					"to_name" 		=> $user_name,				
					"from_name"		=> $admin_name,
					"email"  		=> $user_email
					#"added_amount"  => $amount,
					#"currency"      => $currency								
					);
				$attachement='';
				if(!empty($alt_key))
				{
					$mmsg='Campaign has been rejected successfully';
				}
				else
				{
					$mmsg='Payment has been rejected successfully';
				}
			   	send_mail($type,$from,$to,$mail_content,$attachement);
				$success = array('response'	=> 'ok',
								 'msg'		=> $mmsg
								 ); 
				$this->response($success);
			}
			else
			{
				// IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
				$manager_user_id = $this->user_authentication->manager_user_id;
				$is_manager = $this->do_networks->get_manager_role($manager_user_id);
				if($is_manager == 1)
				{	
					// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);
				
					$network_admin=$this->do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $advertiser_info['email'];
					#$amount        = $added_amount;
					$user_name     = $advertiser_info['dj_first_name']." ".$advertiser_info['dj_last_name'];
					$type     ="ADV_REJECT_ADD_FUND_EMAIL";
					$from 	=  $admin_email;
					$to  	=  $user_email;			
					$mail_content=array(
						"subject" 		=> "Rejected Added Fund",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email
						#"added_amount"  => $amount,
						#"currency"      => $currency								
						);
					if(!empty($alt_key))
					{
						$mmsg='Campaign has been rejected successfully';
					}
					else
					{
						$mmsg='Payment has been rejected successfully';
					}
					$attachement='';	
					send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
					$success = array('response'	=> 'ok',
									 'msg'		=> $mmsg
									 ); 
					$this->response($success);
				}
				else
				{
					// GET NETWORK USERS MAILING DETAILS
					$user_mailing_details = $this->do_networks->get_network_users_detail($manager_user_id);
					$admin_email = $user_mailing_details['email_address'];
					$admin_name = $user_mailing_details['contact_name'];
					
					// GET NETWORK MANAGER MAILING DETAIL FOR BCC
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);
					$bcc = $result['email'];
					
					$user_email    = $advertiser_info['email'];
					#$amount        = $added_amount;
					$user_name     = $advertiser_info['dj_first_name']." ".$advertiser_info['dj_last_name'];
					$type     ="ADV_REJECT_ADD_FUND_EMAIL";
					$from 	=  $admin_email;
					$to  	=  $user_email;			
					$mail_content=array(
						"subject" 		=> "Rejected Added Fund",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email
						#"added_amount"  => $amount,
						#"currency"      => $currency								
						);
					$attachement='';	
					if(!empty($alt_key))
					{
						$mmsg='Campaign has been rejected successfully';
					}
					else
					{
						$mmsg='Payment has been rejected successfully';
					}
					send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
					$success = array('response'	=> 'ok',
									 'msg'		=> $mmsg
									 ); 
					$this->response($success);
				}		
			}
	    }
		else
		{
			if(!empty($alt_key))
				{
					$mmsg='Campaign has been Approved / Rejected previously!..';
				}
				else
				{
					$mmsg='Payment has been Approved / Rejected previously!..';
				}
			$error = array('response'	=> 'ok',
							'msg'		=> $mmsg
							); 
			$this->response($error,200);
		}*/
	}
	/******************** Direct Campaign Payment Approve/Reject ********************/
	/*
	* 
	* name: payment_viewmore_get
	* @param :
	* @return : $success
    */
	 public function payment_viewmore_get()
	 {
	    $id = $this->get('id');
		$payment_details =$this->do_payments->payment_viewmore($id); 
		$this->response($payment_details);
	 }
	 
	/*
	 * 
	 * name: fetch_pub_payment_list
	 * @param :
	 * @return : $success
     */
	 public function fetch_pub_payment_list_get()
	 {
	   $agencyid=$this->get('agency_id');
	   $invoice='';
	   $payment_list =$this->do_payments->fetch_pub_payment_list($invoice,$agencyid); 
	   $this->response($payment_list); 
	 }
	
	/*
	 * 
	 * name: publisher_invoice_viewmore
	 * @param : invoice_id
	 * @return : Selected invoice info list
     */
	 public function publisher_invoice_viewmore_get()
	 {
	    $id = $this->get('id');
		$pub_invoice_details =$this->do_payments->fetch_individual_invoice($id); 
		$this->response($pub_invoice_details);
	 }
	 
	 public function check_invoice_payment_get()
	 {
	    $invoice_id=$this->get('id');
		$pub_invoice_details =$this->do_payments->check_invoice_payment_process($invoice_id); 
		
				/* Activity Log for Publisher payment- Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_APPROVALS,PUB_PAYMENT_APPROVAL);
				if($enable=='1')
				{							
				$this->activity_log(PUBLISHER,PUB_PAYMENT_APPROVAL);
				}
				/* Activity Log for Publisher payment- End*/
		
		if($pub_invoice_details!=FALSE)
		{
		     $success = array('response'	=> 'ok',
							  'msg'		=> 'Payment will be approved here after only...'
							 ); 
		    $this->response($success,200);
		}
	    else
		{
		     $error = array('response'	=> 'error',
							 'msg'		=> 'Publisher Payment has been approved / rejected previously'
							 ); 
		    $this->response($error,200);
	    }
	  
	 }
	 
	/*
	 * 
	 * 
	 * 
	 *
	 */
	 
	function PPHttpPost($methodName_, $nvpStr_) {
		$environment	=	'sandbox';		 
		$account_type	=	$this->user_authentication->account_type;
		$account_id		=	$this->user_authentication->account_id;
		 
		$pay	=	$this->do_networks->get_admin_paypal_info($account_id,$account_type);
		if($pay!=FALSE)
		{			
			// Set up your API credentials, PayPal end point, and API version.
			$API_UserName = urlencode(($pay[0]['api_username'])?$pay[0]['api_username']:'n.duraisamy3_api1.gmail.com');
			$API_Password = urlencode(($pay[0]['api_password'])?$pay[0]['api_password']:'GEYQLAYJD8DM8H5V');
			$API_Signature = urlencode(($pay[0]['api_signature'])?$pay[0]['api_signature']:'AFcWxV21C7fd0v3bYYYRCpSSRl31Al6ee3mIGuRnbYn4YpoYs3KAC8LO');
		}
		else
		{
			// Set up your API credentials, PayPal end point, and API version.
			$API_UserName = urlencode('n.duraisamy3_api1.gmail.com');
			$API_Password = urlencode('GEYQLAYJD8DM8H5V');
			$API_Signature = urlencode('AFcWxV21C7fd0v3bYYYRCpSSRl31Al6ee3mIGuRnbYn4YpoYs3KAC8LO');
		}
		 
		$API_Endpoint = "https://api-3t.paypal.com/nvp";
		if($this->config->item('paypal_sandbox_mode') || $environment=='sandbox') {
			$API_Endpoint = "https://api-3t.sandbox.paypal.com/nvp";
		}
		else
		{
			$API_Endpoint = "https://api-3t.paypal.com/nvp";
		}
		
		$version = urlencode('51.0');
		 
		// Set the curl parameters.
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $API_Endpoint);
		curl_setopt($ch, CURLOPT_VERBOSE, 1);
		 
		// Turn off the server and peer verification (TrustManager Concept).
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
		 
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		 
		// Set the API operation, version, and API signature in the request.
		$nvpreq = "METHOD=$methodName_&VERSION=$version&PWD=$API_Password&USER=$API_UserName&SIGNATURE=$API_Signature$nvpStr_";
		//echo $nvpreq;exit;
		// Set the request as a POST FIELD for curl.
		curl_setopt($ch, CURLOPT_POSTFIELDS, $nvpreq);
		 
		// Get response from the server.
		$httpResponse = curl_exec($ch);
		 
		if(!$httpResponse) {
			exit("$methodName_ failed: ".curl_error($ch).'('.curl_errno($ch).')');
		}
		 
		// Extract the response details.
		$httpResponseAr = explode("&", $httpResponse);
		 
		$httpParsedResponseAr = array();
		foreach ($httpResponseAr as $i => $value) {
			$tmpAr = explode("=", $value);
			if(sizeof($tmpAr) > 1) {
				$httpParsedResponseAr[$tmpAr[0]] = $tmpAr[1];
			}
		}
		 
		if((0 == sizeof($httpParsedResponseAr)) || !array_key_exists('ACK', $httpParsedResponseAr)) {
			exit("Invalid HTTP Response for POST request($nvpreq) to $API_Endpoint.");
		}
		 
		return $httpParsedResponseAr;
	}
	
	/*
	* 
	* name: reject_campaign_get
	* @param :
	* @return : $success
    */
	public function reject_campaign_post()
	{
		$campaign_id = $this->post('reject_campaign_id');
	    if($campaign_id)
		{
			$campaign_ids	=	explode(',',$campaign_id);
			if(is_array($campaign_ids))
			{								
				foreach($campaign_ids as $campid)
				{
					$campupdate	=	$this->campaign_reject($campid);
				}
				
				
				if($campupdate)
				{
					$enable	=  	$this->default_configurations->activity_log_setting(CAMPAIGNS,CAMP_REJECT);
					if($enable=='1')
					{				
						//$this->cam_activity_log(CAMPAIGN,DUPLICATE,$campaign_id);
						$this->activity_log(CAMPAIGN,REJECT);
					}
					
					$client_id 		=	$this->user_authentication->client_id;

					$account_type	=	$this->user_authentication->account_type;	
					$network_id	=	$this->user_authentication->network_account_id;					
					$agency_id	=	$this->user_authentication->agency_id;
					$result		=	$this->do_networks->agency_owner_details($agency_id);
					$admin_name    	= 	$result['name'];			
					$admin_email	= 	$result['email'];	
					$admin_id   	= 	$result['account_id'];

					if($account_type=='ADVERTISER')
					{
						$message  = $this->default_configurations->get('message_type');
							
						$user = $this->do_message->get_profile($admin_id); 
						
						$acc_type='ADVERTISER';
						
						$type_details		=	array(
													'msg_type'		=> $message,
													'type'			=> "ADMIN_MESSAGE_SETTINGS",
													'string'		=> 'camp_rej',
													'column_name'	=> 'campaigns'
													);
							
						$reciever= $this->do_campaign->fetch_reciever($campaign_id);
						
					
						$message_data		=	array(
													'sender_id'		=>	$admin_id,
													'receiver_id'	=>	$reciever['account_id'],
													'dj_is_admarket'=>	$reciever[0]['dj_is_admarket'],
													'subject'		=>	'Campaign Created',
													'content'		=>	'Your campaign  <b>'. $campaign_data['campaignname'].' </b>has been Rejected.',
													'image_name'	=>	NULL,
													'file_name'		=>	NULL,
													'account_type'	=>	$acc_type,
													'status'		=>	'1',
													'network_id'	=>	$network_id,	
													'notification_type'	=>	"campaign_setting",							'date'			=>	date('Y-m-d H:i:s'));
													
														

						$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details);
						
					}
					}
				$success = array('response'	=> 'ok',
								'msg'		=> 'Campaign has been rejected successfully'
								); 
				$this->response($success);
			}
		}
	}
	
	function campaign_reject($campaign_id)
	{
		//CHECK WHETHER PAYMENT IS WAITING FOR APPROVE
		$update_data	=	array("status"			=>	7,
								"dj_is_approved"	=>	-1,
								"dj_campaign_budget"	=>	0,
								"updated"			=>	date('Y-m-d H:m:s')
								);
								
				/**Wallet start***/
				
				$campaign_balance	=	$this->do_payments->get_camp_bal($campaign_id);	 
				$client_balance	=	$this->do_payments->get_wallet_bal_client($campaign_balance['clientid']);		
				$new_balance = $campaign_balance['remain_amount']+$client_balance;
				$reject_bal_update=$this->do_payments->add_amt_deleted_camp($new_balance,$campaign_balance['clientid']);
				
				/**Wallet stop***/
				
		$del_creative	=	$this->do_campaign->delete_campaign_creatives($campaign_id);
		$camp_details	=	$this->do_campaign->fetch_campaign_mail($campaign_id);
		$camp_update	=	$this->do_campaign->campaign_approve($campaign_id,$update_data);
		
		
	   
		if($camp_update!=FALSE)
		{	
			/* Activity Log for Add site - Start*/				
		//$this->appr_activity_log(CAMPAIGN,PAUSE,$campaign_id);
				$enable	=  	$this->default_configurations->activity_log_setting(CAMPAIGNS,CAMP_REJ);
					if($enable=='1')
					{				
						$this->activity_log(CAMPAIGN,REJECT);
					}
		/* Activity Log for Add site - End*/		
			$mmsg	=	'Campaign has been rejected successfully';
			$agency_id	 	= 	$this->user_authentication->agency_id;	
			$result			=	$this->do_networks->agency_owner_details($agency_id);
			$camp_details	=	$this->do_campaign->fetch_campaign_mail($campaign_id);
			//Get advertiser details
				$advertiser_details=$this->do_advertiser->get_profile($camp_details['account_id']);
				$reciever= $this->do_campaign->fetch_reciever($campaign_id);
			$admin_name    	= 	$result['name'];			
			$admin_email   	= 	$result['email'];
			$user 			= $this->do_message->get_profile(ADMIN_ID);	
			$network_id	=	$this->do_message->fetch_admin_network_id();
			$account_id			= 	$camp_details['account_id'];	
			$campaignid 		= 	$camp_details['campaignid']; 
			$cam_name 			= 	$camp_details['campaignname']; 
			$to_name 			= 	$camp_details['username']; 
			$dj_targetting_type = 	$camp_details['dj_targetting_type']; 
			$status				= 	$camp_details['status'] == 0 ? 'Actvie' : 'Inactive'; 
			$camp_mute			=	$camp_details['camp_mute'];
			$activate_time 		= 	isset($camp_details['activate_time']) ? $camp_details['activate_time'] : ' ' ; 
			$dj_is_admarket		=	($camp_details['dj_is_admarket']=='1')?'1':'0';
			$expire_time 		= 	isset($camp_details['expire_time']) ? ' To '.date("Y-m-d", strtotime($camp_details['expire_time'])) : ' '; 
			
			
			$to_email 			= 	$camp_details['email']; 
			$budget				= 	$camp_details['budget']; 
			$revenue_type		= 	$camp_details['formated_revenue_type'];  
			$user_id  			=  	base64_encode($campaignid);
			
			$type     	   	= 	"CAMPAIGN_REJECT";			
			$admin_name   =$user['first_name'].' '.$user['last_name'];	
			$admin_email   =$user['email'];
			$user_email    =$advertiser_details['email'];
			$user_name     =$advertiser_details['first_name'].' '.$advertiser_details['last_name'];
			$from 		   = $admin_email;
			$to  		   = $user_email;				
			
			
			$mail_type = "CAMPAIGN_REJECT";
			$acc_type='ADMIN';

			$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "ADMIN_MESSAGE_SETTINGS",
						'string'		=> 'camp_rej',
						'column_name'	=> 'campaigns'
					);
			$message_data		=	array(
						'sender_id'		=>	ADMIN_ID,
						'receiver_id'	=>	$account_id ,
						'dj_is_admarket'=>	$dj_is_admarket,
						'subject'		=>	'Campaign Rejected',
						'content'		=> 	'The Campaign <b>'.$cam_name.'</b> has been rejected successfully',
						'image_name'	=>	NULL,
						'file_name'		=>	NULL,
						'account_type'	=>	"ADVERTISER",
						'status'		=>	'1',
						'network_id'	=>	$network_id,	
						'notification_type'	=>	"campaign_setting",									
						'date'			=>	date('Y-m-d H:i:s')
					);		 
			//If Admin change his password then it will works
			$attachement	=	'';
			$mail_content	=	array(
									"subject" 		=> 	"Campaign Reject",
									"to_name" 		=> 	$user_name,
									"cam_name" 		=> 	$cam_name,
									"from_name"		=> 	$admin_name,
									"email"  		=> 	$email,
									"activate_time"	=>	$activate_time,
									"expire_time"	=>	$expire_time,
									"budget"		=>	$budget,
									"revenue_type"	=>	$revenue_type,
									"status"		=>	$status,
									"user_id"		=>	$user_id
								);
							
				$prod_name	= 	$this->config->item('prod_name');
				$adgate_url=base_url();
					if($dj_is_admarket=='1')
						{ 
						$notication_value ='ad_camp_rej';
						}
						else
						{
						$notication_value ='camp_rej';
						}
																
				$notification_msg = $this->do_message->get_notification_msg($notication_value); 
											
				if($notification_msg[0]['msg_type']=='1')
				{
					$notification_content = $notification_msg[0]['content'];
				}
				else
				{
					$template_filename = $notification_msg[0]['template_filename'];
					$csvfilepath 	= $this->config->item('read_settings');	
					$notification_content = file_get_contents($csvfilepath.$template_filename);
				}
							$msg_replace = str_replace("{{Product_name}}",'<a   style="color:#FFF;" href="'.$adgate_url.'">'.$prod_name.'</a>',$notification_content);
							$msg_replace1 = str_replace("{{advertiser_name}}",$advertiser_details['first_name'].$advertiser_details['last_name'],$msg_replace);	
							$msg_replace2 = str_replace("{{campaign_name}}",$cam_name,$msg_replace1);
							$msg_replace3 = str_replace("{{admin_name}}",$admin_name ,$msg_replace2);
							$msg_replace4 = str_replace("{{login}}",'<a href="'.$adgate_url.'"admin><img src="'.base_url().'template/flat/img/email-login.jpg"></a>' ,$msg_replace3);
							$msg_replace5 = str_replace("{{click_here}}",'<a  style="color:#FFF;" href="'.$adgate_url.'">'.$this->config->item('click_directADS').'</a>' ,$msg_replace4);	
									
				if($camp_mute!='1')
				{    
					$dat = $this->notification->notify_mail($message_data,$user,$advertiser_details,$type_details,$mail_content,$msg_replace5);
				}	
			//$this->response($dat,200);			
			//$dat = $this->notification->new_mail($message_data,$user,$reciever,$type_details);						
			//send_mail($type,$admin_email,$to_email,$mail_content,$attachement,$admin_email); 
	
			/*$success 	= 	array(	'response'	=> 'ok',
									'msg'		=> $mmsg
								); 
			$this->response($success,200);*/
			
		}
		
		else
		{
			$error 	= 	array(	'response'	=> 'error',
								'msg'		=> 'Campaign has not been rejected. Please try again !!'
							); 
			$this->response($error,200);
		}		
	}
	
	function activity_log($module,$process)
	{
				/* Activity Log  - Start*/				
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");							
				$account_id=$this->user_authentication->account_id;
				$module=$module;
				$process=$process;				
								
				$activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$user_agent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,
				"module"=>$module,
				"process"=>$process,
				"advertiser_id"=>'',
				"campaign_id"=>'',
				"banner_id"=>'',
				"publisher_id"=>'',
				"site_id"=>'',
				"app_id"=>'',
				"adblock_id"=>'');				
																									
				//$this->do_app_config->activity_log($account_id,$activity_log);
				$this->redis_library->logcount($account_id,$activity_log);  
				/* Activity Log - End*/			
		
	}						
	/*
	 * 
	 * name: fetch_pub_payment_approval
	 * @param :
	 * @return : $success
     */
	 public function fetch_pub_payment_approval_get()
	 {
	   $agencyid=$this->get('agency_id');
	   $pay_type=$this->get('pay_gate');
	 
	   $payment_list =$this->do_payments->fetch_pub_payment_approval($pay_type,$agencyid); 
	   $this->response($payment_list); 
	 }		
	
}
