<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Publisher Site related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class App_Settings extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->library('redis_library');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->model('do_app_config');
		$this->load->model('do_message');
		$this->load->model('do_publisher');
		$this->load->library('notification');
		$this->load->model('do_networks');
        $this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }	
	}
	
			
	public function set_value_post()
	{
	   $network_id = $this->post('pk');
	   $config_name = $this->post('name');
	   $config_value = $this->post('value');
	   
	   if(!empty($network_id) AND !empty($config_name) AND !empty($config_value)){

		  if($this->do_app_config->is_field_exists(TAB_APP_CONFIG,$config_name)){
		  
		  	 $res = $this->do_app_config->set_value($network_id,$config_name,$config_value);
		 
			 if($res !== FALSE){
					
					$success = array(
						'response' 	=> 'ok',
						'id'		=> $res,
						'msg'	 	=> 'Config Value Updated Successfully..'
						);
					$this->response($success,200); 
			 }
		  
		  }
		  else
		  {
		  		$error = array(
					'response' => 'error',
					'msg'	 => 'Config {$config_name} item does not exists.'
					);
  	 			$this->response($error,200); 
		  }

	   }
	   else
	   {
	   		$error = array(
					'response' => 'error',
					'msg'	 => 'Invalid Request!..'
					);
  	 		$this->response($error,200); 
	   }
	   
	}
	
	public function get_values_get(){   
		 $network_id = $this->get('network_id');
		 if($network_id){
		 	 $res = $this->do_app_config->fetch($network_id);
			 $this->response($res,200); 
			 
		 }
	}
	
	public function fetch_accountid_get()
	{
		$account_id	= 	$this->user_authentication->account_id;	
		$this->response($account_id,200);    		
	}
	
	public function fetch_activity_log_from_db_get()
	{
		$account_id	= 	$this->user_authentication->account_id;		
		if($account_id)
	    {
			$res = $this->do_app_config->fetch_activity_log($account_id);
			$this->response($res,200); 		
		}	
		
	}
	
	public function fetch_activity_log_get()
	{
		$account_id	= 	$this->user_authentication->account_id;	
        /* commented old code by sandhiya - 21-02-2018
		$res		=   $this->redis_library->getcount($account_id);   
		$this->response($res,200);   */ 	
		if($account_id)
	    {
			$res = $this->do_app_config->fetch_activity_log($account_id);
			$this->response($res,200); 		
		}	
			
	}
	
	public function fetch_post()
	{ 
		$api_key=$this->post('api_key'); 
		$device=$this->post('device'); 
		$from_date=$this->post('from_date'); 
		$to_date=$this->post('to_date'); 
		$site_id=$this->post('site_id');
		$app_id=$this->post('app_id');
		$adblock_id=$this->post('adblock_id'); 
		$campaign_id=$this->post('campaign_id'); 
		$banner_id=$this->post('banner_id'); 
		$zonelimit_id=$this->post('zonelimit_id');
		$traffic_id=$this->post('traffic_id'); 
		$tracker_id=$this->post('tracker_id'); 
		$bidding_id=$this->post('bidding_id');  
		$site_val='';
		$app_val='';
		$adblock_val='';$campaign_val='';$banner_val='';
		$zonelimit_val='';$traffic_val='';$tracker_val='';$bidding_val='';
		if($device=="site")
		{		
			$site_val=($site_id=='null' || $site_id=='')?'all':$site_id;
		}
		
		if($device=="apps")
		{
			$app_val=($app_id=='null' || $app_id=='')?'all':$app_id;
		}
		
		if($device=="adblock")
		{
			$adblock_val=($adblock_id=='null' || $adblock_id=='')?'all':$adblock_id;
		}
		if($device=="campaign")
		{
			$campaign_val=($campaign_id=='null' || $campaign_id=='')?'all':$campaign_id;
		}
		if($device=="banner")
		{
			$banner_val=($banner_id=='null' || $banner_id=='')?'all':$banner_id;
		}
		if($device==ZONE_LIMITATION)
		{
			$zonelimit_val=($zonelimit_id=='null' || $zonelimit_id=='')?'all':$zonelimit_id;
		}
		if($device==TRAFFIC_SOURCE)
		{
			$traffic_val=($traffic_id=='null' || $traffic_id=='')?'all':$traffic_id;
		}
		if($device==PIXEL_TRACKER)
		{
			$tracker_val=($tracker_id=='null' || $tracker_id=='')?'all':$tracker_id;
		}
		if($device==COUNTRY_BIDDING)
		{
			$bidding_val=($bidding_id=='null' || $bidding_id=='')?'all':$bidding_id;
		}					
		$account_id	= 	$this->user_authentication->account_id;		
		if($account_id)
	    {
			$input=array(
				'api_key'=>$api_key,
				'device'=>$device, 
				'from_date'=>$from_date,
				'to_date'=>$to_date, 
				'site_id'=>$site_val,
				'app_id'=>$app_val,
				'adblock_id'=>$adblock_val,
				'campaign_id'=>$campaign_val,
				'banner_id'=>$banner_val,
				'zonelimit_id'=>$zonelimit_val,
				'traffic_id'=>$traffic_val,
				'tracker_id'=>$tracker_val,
				'bidding_id'=>$bidding_val,
					
			    );
			$res = $this->do_app_config->fetch_activity_log($account_id,$input);
			$this->response($res,200); 		
		}	
		
	}
	
	
	
	public function fetch_payment_changes_get()
	{
		$account_id	= 	$this->user_authentication->account_id;
		
		if($account_id)
	    {
			$res = $this->do_app_config->fetch_payment_changes($account_id);
			$this->response($res,200); 		
		}
		
		
	}	
	
	/******************************************/
	/*			Invoice Amount For Publisher  */
	/******************************************/
	
	public function set_invoice_post()
	{
		$account_id	= 	$this->user_authentication->account_id;
	   
	    	if($account_id)
	    	{ 
			$update	=	array('min_invoice_amt'=>clean_data($this->post('value')));
			$res = $this->do_app_config->set_invoice($account_id,$update);
			$agency_id = $this->user_authentication->agency_id;
			$result=$this->do_networks->agency_owner_details($agency_id);
			
			 $publisher_details=$this->do_publisher->get_profile($account_id);
			
			$publisher_details['name']=$publisher_details['first_name'].' '.$publisher_details['last_name'];
			$type     ="PUB_MIN_AMOUNT";
			$network_id	=	$this->do_message->fetch_admin_network_id();
			$mail_content=array(
						"subject" 		=> 	"Minimum Payment",
						"to_name" 		=>  $publisher_details['name'],				
						"from_name"		=> 	$result['name'],
						"email"  		=>	$publisher_details['email'],
						"min_amt"		=>	$this->post('value'),
						#"added_amount"  => $amount,
						#"currency"      => $currency								
						);
			$type_details		=	array(
					'msg_type'		=> $message,
					'type'			=> $type,
					'string'		=> "payment_sett",
					'column_name'	=> "payments",
					'bcc'			=> $bcc
					);
			$message_data		=	array(
					'sender_id'		=>	ADMIN_ID,
					'receiver_id'	=>	$account_id,
					'subject'		=>	'Minimum amount',
					'content'		=>	'Your minimum invoice amount has been updated successfully',
					'image_name'	=>	NULL,
					'file_name'		=>	NULL,
					'account_type'	=>	'TRAFFICKER',
					'status'		=>	'1',
					'network_id'	=>	$network_id,
					'notification_type'	=>	"payment_setting",										
					'date'			=>	date('Y-m-d H:i:s')
					);		
			$attachement='';	
			$dd = $this->notification->new_mail($message_data,$result,$publisher_details,$type_details,$mail_content);
				 
		 
			if($res !== FALSE){
					
				$success = array(
							'response' 	=> 'ok',
							'msg'	 	=> 'Invoice amount updated Successfully..'
							);
				$this->response($success,200); 
			}
			else
			{
				$error 	= 	array(
							'response' 	=> 'error',
							'msg'	 	=> 'Invoice amount not updated Successfully..'
						);
				$this->response($error,200); 
			}
		}
		else
		{
	   		$error 	= 	array(
							'response' => 'error',
							'msg'	 => 'Invalid Request!..'
						);
			$this->response($error,200); 
		}	   
	}
	
	/*
	 * 
	 * name: log_settings_add
	 * @param :null
	 * @return : response Array
	 * 
	 * Add/update the Log Setting Information 
	 */
	
    public function log_settings_add_post(){	

				//$this->response('dfwerrgh',200);
			
			 $enable_log = $this->input->post('enable_log');
			
			// $this->response($this->input->post('campaign_tracking'),200); 	
			if($enable_log)
			{
				
				$notification['log_enable']= 1;
				
				
				$notification['creatives']= $this->input->post('creative_setting');
				$notification['apps']= $this->input->post('app_settings');
				$notification['campaigns']= $this->input->post('campaigns');
				$notification['payment']= $this->input->post('paymnt_val');
				$notification['account_settings']= $this->input->post('acct_val');
				$notification['network']= $this->input->post('network_set');
				$notification['adblock']= $this->input->post('adb_settings');
				$notification['site']= $this->input->post('site_settings');
				$notification['network_users']= $this->input->post('network_users');
				$notification['admin_approvals']= $this->input->post('admin_approvals');
				$notification['category_targeting']= $this->input->post('category_targeting');
				$notification['device_os']= $this->input->post('device_os');
				$notification['browsers_lang']= $this->input->post('browsers_lang');
				$notification['manufacture_cap']= $this->input->post('manufacture_cap');
				$notification['isp_connection']= $this->input->post('isp_connection');
				$notification['contextual']= $this->input->post('contextual');
				$notification['admin_settings']=$this->input->post('admin_settings');			
											
				$ret = $this->do_message->update_log_settings($notification);
				
			}
			else{
				$notification['log_enable']= 0;			
				$notification['creatives']= '';
				$notification['apps']='';
				$notification['campaigns']= '';
				$notification['payment']= '';
				$notification['account_settings']= '';
				$notification['network']= '';
				$notification['adblock']= '';
				$notification['site']= '';
				$notification['network_users']= '';
				$notification['admin_approvals']= '';
				$notification['category_targeting']= '';
				$notification['device_os']= '';
				$notification['browsers_lang']= '';
				$notification['manufacture_cap']= '';
				$notification['isp_connection']= '';
				$notification['contextual']= '';
				$notification['admin_settings']= '';						
				
				$ret = $this->do_message->update_log_settings($notification);
				//$this->response(print_r($ret).'sdfdsf',200); 
			}
			if($ret)
			{
			$success = array(
					'response' => 'ok',
					'msg'	 => 'Log Settings Information are updated successfully!..'
					); 
					
					$this->response($success,200);
			}
			else{
			$error = array(
					'response' => 'ok',
					'msg'	 => 'Error! PLease try again later!!'
					);
					
					$this->response($success,200); 
			}
			
	}
	
	function fetch_log_settings_get()
	{		
		//$account_id 	= 	$this->user_authentication->account_id;
		
		$notify_list 	= 	$this->do_message->fetch_log_settings();
		
		if($notify_list)
		{
			$this->response($notify_list,200);
		}
		else
		{
			$this->response('error',200);
		}	
		
	}
	
	function edit_select_type_get()
	{
		$select_type=$this->do_app_config->fetch_option_type();
		if($select_type)
		{
			$this->response($select_type,200);
		}
		else
		{
			$this->response('error',200);
		}	
	}
	
	function select_type_get()
	{
		$select_type	=	$this->get('type');
		$type_list 		= 	$this->do_app_config->fetch_type($select_type);   
		 
		 if($type_list)
		 {
			 $form_data='<select name="adv_pub_settings" id="adv_pub_settings" class="select2-me input-medium" data-nosearch="true" data-rule-required="true" onchange="select_option(this.value);>'; 
			 $form_data.='<option value="">'.$this->lang->line("slt_not_option").'</option>';
			 foreach($type_list as $sel)
			{
				$form_data.='<option value="'.$sel['value'].'">'.$sel['option_name'].'</option>';        
			}
			$form_data.='</select>';
			 $response = array(
							'response' 	=> 	'ok',
							'typelist'	=>	$form_data,
						);					
		    $this->response($response, 200);
		 }
		 else
		 {
			 $this->response(array('error'=>'Notification options could not be found'),404);
		 }
	}
	
	function create_notification_setting_post()
	{		
		$content=$this->post('content');
		$msg_type=$this->post('msg_type');
		$adv_pub_settings=$this->post('adv_pub_settings');
		$choose_type=$this->post('choose_type');
		$account_id	= 	$this->user_authentication->account_id;						
		
		if($msg_type=='1')
		{
			$all_value=$this->post(); 
			$content=$all_value['content'];
			$notification_details		=	array(
					'type'			=> $choose_type,
					'value'			=> $adv_pub_settings,
					'msg_type'		=> $msg_type,
					'content'		=> $content,
					'account_id'	=> $account_id,
					'product_name'  => 'DA'
					);
			$res = $this->do_app_config->include_content($notification_details);     
		}
		else
		{		
			$all_value=$this->post(); 
			$content=$all_value['content'];
			$random_no=rand();
			$fname="notification_settings".$random_no.".html";
			$filename=$this->config->item('read_settings').$fname; 
			$handle=fopen($filename, 'w') or die('Cannot open file:  '.$filename);  
			fwrite($handle,$content);  
			fclose($handle);
			
			
			$temp_notification_details		=	array(
					'type'			=> $choose_type,
					'value'			=> $adv_pub_settings,
					'msg_type'		=> $msg_type,
					'content'		=> '',
					'account_id'	=> $account_id,
					'template_filename' => $fname,
					'product_name'  => 'DA'
					);
			$res = $this->do_app_config->include_content($temp_notification_details);
			
		}
		if($res)
		{
		$response = array(
							'response' 	=> 	'ok',
							'redirect'	=>  site_url('admin/settings/notification_settings'),
							'msg'	    =>	'Notification settings content created successfully'
						);					
		$this->response($response, 200);				
		}
		else
		{
		$response = array(
							'response' 	=> 	'error',
							'redirect'	=>  site_url('admin/settings/notification_settings'),
							'msg'		=>	'Provide all data to fill message'
						);					
		$this->response($response, 200);
		}
					
	}
	
	function update_notification_setting_post()
	{
		$this->form_validation->set_rules('html_content','trim|required');
		
		$content = $this->post('html_content');
		$msg_id  = $this->post('msg_id');		
		$account_id	= 	$this->user_authentication->account_id;	
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			
			$fetch_data=$this->do_app_config->fetch_edit_msg($account_id,$msg_id);
			$message_type=$fetch_data[0]['message_type'];
			if($message_type!='1')
			{  
			$all_value=$this->post(); 
			$content=$all_value['html_content'];
			$random_no=rand();
			$fname="notification_settings".$random_no.".html";
			$filename=$this->config->item('read_settings').$fname; 
			$handle=fopen($filename, 'w') or die('Cannot open file:  '.$filename);  
			fwrite($handle,$content);  
			fclose($handle);		
			
			$temp_notification_details		=	array(
					'account_id'	=> $account_id,
					'template_filename' => $fname
					);
			$res = $this->do_app_config->update_content($temp_notification_details,$msg_id);
			}
			else
			{  
				$all_value=$this->post(); 
				$content=$all_value['html_content'];
				$notification_details		=	array(
						'content'		=> $content,
						'account_id'	=> $account_id
						);
				$res = $this->do_app_config->update_content($notification_details,$msg_id);    
			}			
			if($res)
			{
			$success = array(
								'response' 	=> 	'ok',
								'redirect'	=>  site_url('admin/settings/notification_settings'),
								'msg'	    =>	'Notification settings content updated successfully'
							);					
			$this->response($success, 200);				
			}		
		}					
	}	
	
	function fetch_edit_msg_get()
	{
		$account_id	= 	$this->user_authentication->account_id;	
		$id			=   $this->get('id');
		
		if($account_id)
	    {
			$res = $this->do_app_config->fetch_edit_msg($account_id,$id);
			$this->response($res,200); 		
		}	
	}

	
	public function fetch_notification_msg_get()
	{  
		$account_id	= 	$this->user_authentication->account_id;		
		
		if($account_id)
	    {
			$res = $this->do_app_config->fetch_notification_msg($account_id);
			$this->response($res,200); 		
		}	
		
	}
	
	public function remove_notification_msg_post()
	{
		$msg_id	=	clean_data($this->post('id')); 
		$remove_notification = $this->do_app_config->remove_notification_msg($msg_id);   
		$success = array( 
								'response'	=>	'ok',
								'msg'		=>	'Notification Message is removed successfully'
							);
		$this->response($success, 200);			
	}
	
	public function fetch_template_get()
	{
		$templates = $this->do_app_config->fetch_templates();  
		if($templates)
		{
			$this->response($templates,200);
		}
		else
		{
			$this->response('empty',200);
		}
	}
	
	public function template_data_get()
	{
		$id=$this->get('id');
		$template_data = $this->do_app_config->fetch_template_data($id);  
		
		if($template_data)
		{
			$this->response($template_data,200);
		}
		else
		{
			$success = array('response'	=> 'empty'); 
			$this->response($success,200);
		}
	}
	
	public function fetch_template_data_get()
	{		
		$id=$this->get('id');	
		$result = $this->do_app_config->fetch_template_filename($id);  
		$csvfilepath 	= $this->config->item('read_settings');	
		
		if($result['msg_type']!='1')
		{
		$load_data = file_get_contents($csvfilepath.$result['filename']);
		$msg=array('msg_type'=>'2',
				   'load_data'=>$load_data
				   );
		$this->response($msg,200);  
		}
		else
		{
		$load_data = $result['content'];  
		$msg=array('msg_type'=>'1',
				   'load_data'=>$load_data
				   );
		$this->response($msg,200);  	
		}
		 
	}
	
	public function redis_settings_get()
	{
		/* Enable/Disable option for redis settings*/
		$result = $this->do_app_config->redis_settings();  
		$this->response($result,200);
	}
	
	/*public function test_get()
	{
		$account_id	= 	$this->user_authentication->account_id;	
		$res		=   $this->redis_library->test();  
		print_r($res);
		//$this->response($res,200);    		
	}*/
	
	
	
}
