<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for Analytics (Generalize Things)
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Nalliappan
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Antifraud_click_stats extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->model('do_antifraud');
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}
	
	/* 
	* name: fetch_anti_fraud_stats_list
	* @param : null
	* @return : list of anti fraud statistics.
    */
	public function fetch_anti_fraud_stats_list_post()
	{
		
		$agency_id	=	$this->user_authentication->agency_id;
	   
		$columns	=	$this->post('columns');
		$group		=	$this->post('dimensions');
				
		if( $this->convert_sorting_data($datatable_obj))
		{
			$order = $this->convert_sorting_data($datatable_obj);
		}else{								
			$order='';
			if(!empty($group)):								
				foreach($group as $key):
					if($key=='HOUR'):
						$ord[] = 'r.date_time';
						$ord[] = $key;	
					elseif($key=='DATE' || $key=='MONTH'):
						$ord[] = 'r.date_time';
					else:										
						$ord[] = $key;	
					endif;									
				endforeach;
				$order	=	implode(',',$ord);
			endif;								
		}			
		
		if(clean_data($this->post('date_from')) != ''){
			$search['date_from'] = clean_data($this->post('date_from')); 
		}
		
		if(clean_data($this->post('date_to') != '')){
			$search['date_to'] = clean_data($this->post('date_to')); 
		}
		
		if($this->post('country_id') != '' AND $this->post('country_id') != 'all'){
			$search['country_id'] = $this->post('country_id'); 
		}
				
		if(clean_data($this->post('environment')) != '' AND clean_data($this->post('environment')) != 'all'){
			$search['environment'] = clean_data($this->post('environment')); 
		}
		
		if(clean_data($this->post('pub_account_id')) != '' AND clean_data($this->post('pub_account_id')) != 'all'){
			$search['pub_account_id'] = clean_data($this->post('pub_account_id')); 
		}
		
		if($this->post('site_id') != '' AND $this->post('site_id') != 'all'){
			$search['site_id'] = $this->post('site_id'); 
		}
		
		if($this->post('adblock_id') != '' AND $this->post('adblock_id') != 'all'){
			$search['adblock_id'] = $this->post('adblock_id'); 
		}
		
		if($this->post('country') != '' AND $this->post('country') != 'all'){
			$search['country'] 		= 	$this->post('country'); 
		}
				
		if($this->post('adsize') != '' AND $this->post('adsize') != 'all'){
			$search['adsize'] 		= 	$this->post('adsize'); 
		}
		
		if($this->post('timezone') != '' AND $this->post('timezone') != 'utc'){
			$tz	=	explode(')',$this->post('timezone'));
			$tz1	=	str_replace('(GMT','',$tz[0]);
			$search['timezone'] 		= 	substr($tz1,0,3).':'.substr($tz1,3); 
		}
		
		if($agency_id != FALSE){
			$search['agency_id'] = $agency_id; 				
		}
		
		$datatable_obj = $this->post('datatable_obj');
				
		$stats_list	=	$this->do_antifraud->antifraud_list($columns,$search,$group,$order);
		$no_records = 	($stats_list !== FALSE)?count($stats_list):0;
		
		if($stats_list):
			$result_data['sEcho'] 			= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 	= 	$no_records;
			$result_data['iTotalDisplayRecords'] = 	$no_records;
			$result_data['aaData'] = $stats_list;			
		else:
			$result_data['sEcho'] 			= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 	= 	$no_records;
			$result_data['iTotalDisplayRecords']= 	0;
			$result_data['aaData'] = array();
			$result_data['overview_chart_data'] = 	'';
		endif;
		
		$this->response($result_data,200);
	}
	
		/* 
	* name: fetch_anti_fraud_stats_list
	* @param : null
	* @return : list of anti fraud statistics.
    */
	public function fetch_anti_fraud_stats_imp_list_post()
	{
		
		$agency_id	=	$this->user_authentication->agency_id;
	   
		$columns	=	$this->post('columns');
		$group		=	$this->post('dimensions');
				
		if( $this->convert_sorting_data($datatable_obj))
		{
			$order = $this->convert_sorting_data($datatable_obj);
		}else{								
			$order='';
			if(!empty($group)):								
				foreach($group as $key):
					if($key=='HOUR'):
						$ord[] = 'r.date_time';
						$ord[] = $key;	
					elseif($key=='DATE' || $key=='MONTH'):
						$ord[] = 'r.date_time';
					else:										
						$ord[] = $key;	
					endif;									
				endforeach;
				$order	=	implode(',',$ord);
			endif;								
		}			
		
		if(clean_data($this->post('date_from')) != ''){
			$search['date_from'] = clean_data($this->post('date_from')); 
		}
		
		if(clean_data($this->post('date_to') != '')){
			$search['date_to'] = clean_data($this->post('date_to')); 
		}
		
		if($this->post('country_id') != '' AND $this->post('country_id') != 'all'){
			$search['country_id'] = $this->post('country_id'); 
		}
				
		if(clean_data($this->post('environment')) != '' AND clean_data($this->post('environment')) != 'all'){
			$search['environment'] = clean_data($this->post('environment')); 
		}
		
		if(clean_data($this->post('pub_account_id')) != '' AND clean_data($this->post('pub_account_id')) != 'all'){
			$search['pub_account_id'] = clean_data($this->post('pub_account_id')); 
		}
		
		if($this->post('site_id') != '' AND $this->post('site_id') != 'all'){
			$search['site_id'] = $this->post('site_id'); 
		}
		
		if($this->post('adblock_id') != '' AND $this->post('adblock_id') != 'all'){
			$search['adblock_id'] = $this->post('adblock_id'); 
		}
		
		if($this->post('country') != '' AND $this->post('country') != 'all'){
			$search['country'] 		= 	$this->post('country'); 
		}
				
		if($this->post('adsize') != '' AND $this->post('adsize') != 'all'){
			$search['adsize'] 		= 	$this->post('adsize'); 
		}
		
		if($this->post('timezone') != '' AND $this->post('timezone') != 'utc'){
			$tz	=	explode(')',$this->post('timezone'));
			$tz1	=	str_replace('(GMT','',$tz[0]);
			$search['timezone'] 		= 	substr($tz1,0,3).':'.substr($tz1,3); 
		}
		
		if($agency_id != FALSE){
			$search['agency_id'] = $agency_id; 				
		}
		
		$datatable_obj = $this->post('datatable_obj');
				
		$stats_list	=	$this->do_antifraud->antifraud_imp_list($columns,$search,$group,$order);
		$no_records = 	($stats_list !== FALSE)?count($stats_list):0;
		
		if($stats_list):
			$result_data['sEcho'] 			= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 	= 	$no_records;
			$result_data['iTotalDisplayRecords'] = 	$no_records;
			$result_data['aaData'] = $stats_list;			
		else:
			$result_data['sEcho'] 			= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 	= 	$no_records;
			$result_data['iTotalDisplayRecords']= 	0;
			$result_data['aaData'] = array();
			$result_data['overview_chart_data'] = 	'';
		endif;
		
		$this->response($result_data,200);
	}
	
	
	/* 
	* name: fetch_anti_valid_stats_list_get
	* @param : null
	* @return : list of valid statistics.
    */
	public function fetch_anti_valid_stats_list_post()
	{
		$agency_id	=	$this->user_authentication->agency_id;
		
		$columns	=	$this->post('columns');
		$group		=	$this->post('dimensions');
				
		if( $this->convert_sorting_data($datatable_obj))
		{
			$order = $this->convert_sorting_data($datatable_obj);
		}else{								
			$order='';
			if(!empty($group)):								
				foreach($group as $key):
					if($key=='HOUR'):
						$ord[] = 'r.date_time';
						$ord[] = $key;	
					elseif($key=='DATE' || $key=='MONTH'):
						$ord[] = 'r.date_time';
					else:										
						$ord[] = $key;	
					endif;									
				endforeach;
				$order	=	implode(',',$ord);
			endif;								
		}			
		
		if(clean_data($this->post('date_from')) != ''){
			$search['date_from'] = clean_data($this->post('date_from')); 
		}
		
		if(clean_data($this->post('date_to') != '')){
			$search['date_to'] = clean_data($this->post('date_to')); 
		}
		
		if($this->post('country_id') != '' AND $this->post('country_id') != 'all'){
			$search['country_id'] = $this->post('country_id'); 
		}
				
		if(clean_data($this->post('environment')) != '' AND clean_data($this->post('environment')) != 'all'){
			$search['environment'] = clean_data($this->post('environment')); 
		}
		
		if(clean_data($this->post('pub_account_id')) != '' AND clean_data($this->post('pub_account_id')) != 'all'){
			$search['pub_account_id'] = clean_data($this->post('pub_account_id')); 
		}
		
		if($this->post('site_id') != '' AND $this->post('site_id') != 'all'){
			$search['site_id'] = $this->post('site_id'); 
		}
		
		if($this->post('adblock_id') != '' AND $this->post('adblock_id') != 'all'){
			$search['adblock_id'] = $this->post('adblock_id'); 
		}
		
		if($this->post('country') != '' AND $this->post('country') != 'all'){
			$search['country'] 		= 	$this->post('country'); 
		}
		
		if($this->post('adsize') != '' AND $this->post('adsize') != 'all'){
			$search['adsize'] 		= 	$this->post('adsize'); 
		}
		
		if($this->post('timezone') != '' AND $this->post('timezone') != 'utc'){
			$tz	=	explode(')',$this->post('timezone'));
			$tz1	=	str_replace('(GMT','',$tz[0]);
			$search['timezone'] 		= 	substr($tz1,0,3).':'.substr($tz1,3); 
		}
		
		if($agency_id != FALSE){
			$search['agency_id'] = $agency_id; 				
		}
		
		$datatable_obj = $this->post('datatable_obj');
		
		$stats_list	=	$this->do_antifraud->antifraud_statistics_list($columns,$search,$group,$order);
		
		$no_records = 	($stats_list !== FALSE)?count($stats_list):0;
		
		if($stats_list):
			$result_data['sEcho'] 			= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 	= 	$no_records;
			$result_data['iTotalDisplayRecords'] = 	$no_records;
			$result_data['aaData'] = $stats_list;			
		else:
			$result_data['sEcho'] 			= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 	= 	$no_records;
			$result_data['iTotalDisplayRecords']= 	0;
			$result_data['aaData'] = array();
			$result_data['overview_chart_data'] = 	'';
		endif;
		
		$this->response($result_data,200);
	}
	
	
		/* 
	* name: fetch_anti_valid_stats_list_get
	* @param : null
	* @return : list of valid imp statistics.
    */
	public function fetch_anti_valid_imp_stats_list_post()
	{
		$agency_id	=	$this->user_authentication->agency_id;
		
		$columns	=	$this->post('columns');
		$group		=	$this->post('dimensions');
				
		if( $this->convert_sorting_data($datatable_obj))
		{
			$order = $this->convert_sorting_data($datatable_obj);
		}else{								
			$order='';
			if(!empty($group)):								
				foreach($group as $key):
					if($key=='HOUR'):
						$ord[] = 'r.date_time';
						$ord[] = $key;	
					elseif($key=='DATE' || $key=='MONTH'):
						$ord[] = 'r.date_time';
					else:										
						$ord[] = $key;	
					endif;									
				endforeach;
				$order	=	implode(',',$ord);
			endif;								
		}			
		
		if(clean_data($this->post('date_from')) != ''){
			$search['date_from'] = clean_data($this->post('date_from')); 
		}
		
		if(clean_data($this->post('date_to') != '')){
			$search['date_to'] = clean_data($this->post('date_to')); 
		}
		
		if($this->post('country_id') != '' AND $this->post('country_id') != 'all'){
			$search['country_id'] = $this->post('country_id'); 
		}
				
		if(clean_data($this->post('environment')) != '' AND clean_data($this->post('environment')) != 'all'){
			$search['environment'] = clean_data($this->post('environment')); 
		}
		
		if(clean_data($this->post('pub_account_id')) != '' AND clean_data($this->post('pub_account_id')) != 'all'){
			$search['pub_account_id'] = clean_data($this->post('pub_account_id')); 
		}
		
		if($this->post('site_id') != '' AND $this->post('site_id') != 'all'){
			$search['site_id'] = $this->post('site_id'); 
		}
		
		if($this->post('adblock_id') != '' AND $this->post('adblock_id') != 'all'){
			$search['adblock_id'] = $this->post('adblock_id'); 
		}
		
		if($this->post('country') != '' AND $this->post('country') != 'all'){
			$search['country'] 		= 	$this->post('country'); 
		}
		
		if($this->post('adsize') != '' AND $this->post('adsize') != 'all'){
			$search['adsize'] 		= 	$this->post('adsize'); 
		}
		
		if($this->post('timezone') != '' AND $this->post('timezone') != 'utc'){
			$tz	=	explode(')',$this->post('timezone'));
			$tz1	=	str_replace('(GMT','',$tz[0]);
			$search['timezone'] 		= 	substr($tz1,0,3).':'.substr($tz1,3); 
		}
		
		if($agency_id != FALSE){
			$search['agency_id'] = $agency_id; 				
		}
		
		$datatable_obj = $this->post('datatable_obj');
		
		$stats_list	=	$this->do_antifraud->antifraud_statistics_imp_list($columns,$search,$group,$order);
		
		$no_records = 	($stats_list !== FALSE)?count($stats_list):0;
		
		if($stats_list):
			$result_data['sEcho'] 			= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 	= 	$no_records;
			$result_data['iTotalDisplayRecords'] = 	$no_records;
			$result_data['aaData'] = $stats_list;			
		else:
			$result_data['sEcho'] 			= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 	= 	$no_records;
			$result_data['iTotalDisplayRecords']= 	0;
			$result_data['aaData'] = array();
			$result_data['overview_chart_data'] = 	'';
		endif;
		
		$this->response($result_data,200);
	}
	
	
	/*
	* 
	* name: fetch_anti_penality_list
	* @param : null
	* @return : list of anti penality
    */	
	public function fetch_anti_penality_list_post()
	{ 
		$agency_id	=	$this->user_authentication->agency_id;
		$columns	=	$this->post('columns');
		$group		=	$this->post('dimensions');
				
		if( $this->convert_sorting_data($datatable_obj))
		{
			$order = $this->convert_sorting_data($datatable_obj);
		}else{								
			$order='';
			if(!empty($group)):								
				foreach($group as $key):
					if($key=='HOUR'):
						$ord[] = 'r.date_time';
						$ord[] = $key;	
					elseif($key=='DATE' || $key=='MONTH'):
						$ord[] = 'r.date_time';
					else:										
						$ord[] = $key;	
					endif;									
				endforeach;
				$order	=	implode(',',$ord);
			endif;								
		}			
		
		if(clean_data($this->post('date_from')) != ''){
			$search['date_from'] = clean_data($this->post('date_from')); 
		}
		
		if(clean_data($this->post('date_to') != '')){
			$search['date_to'] = clean_data($this->post('date_to')); 
		}
		
		if($this->post('country_id') != '' AND $this->post('country_id') != 'all'){
			$search['country_id'] = $this->post('country_id'); 
		}
				
		if(clean_data($this->post('environment')) != '' AND clean_data($this->post('environment')) != 'all'){
			$search['environment'] = clean_data($this->post('environment')); 
		}
		
		if(clean_data($this->post('pub_account_id')) != '' AND clean_data($this->post('pub_account_id')) != 'all'){
			$search['pub_account_id'] = clean_data($this->post('pub_account_id')); 
		}
		
		if($this->post('site_id') != '' AND $this->post('site_id') != 'all'){
			$search['site_id'] = $this->post('site_id'); 
		}
		
		if($this->post('adblock_id') != '' AND $this->post('adblock_id') != 'all'){
			$search['adblock_id'] = $this->post('adblock_id'); 
		}
		
		if($this->post('country') != '' AND $this->post('country') != 'all'){
			$search['country'] 		= 	$this->post('country'); 
		}
		
		if($this->post('adsize') != '' AND $this->post('adsize') != 'all'){
			$search['adsize'] 		= 	$this->post('adsize'); 
		}
		
		if($this->post('timezone') != '' AND $this->post('timezone') != 'utc'){
			$tz	=	explode(')',$this->post('timezone'));
			$tz1	=	str_replace('(GMT','',$tz[0]);
			$search['timezone'] 		= 	substr($tz1,0,3).':'.substr($tz1,3); 
		}
		
		if($agency_id != FALSE){
			$search['agency_id'] = $agency_id; 				
		}
		
		$datatable_obj = $this->post('datatable_obj');
		
		$penality	=	$this->do_antifraud->penality_list($columns,$search,$group,$order);
		
		$no_records = 	($penality !== FALSE)?count($penality):0;
		
		if($penality):
			$result_data['sEcho'] 			= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 	= 	$no_records;
			$result_data['iTotalDisplayRecords'] = 	$no_records;
			$result_data['aaData'] = $penality;			
		else:
			$result_data['sEcho'] 			= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 	= 	$no_records;
			$result_data['iTotalDisplayRecords']= 	0;
			$result_data['aaData'] = array();
			$result_data['overview_chart_data'] = 	'';
		endif;
		
		$this->response($result_data,200);
	}
	
		/*
	* 
	* name: fetch_anti_penality_list
	* @param : null
	* @return : list of imp anti penality
    */	
	public function fetch_anti_penality_imp_list_post()
	{ 
		$agency_id	=	$this->user_authentication->agency_id;
		$columns	=	$this->post('columns');
		$group		=	$this->post('dimensions');
				
		if( $this->convert_sorting_data($datatable_obj))
		{
			$order = $this->convert_sorting_data($datatable_obj);
		}else{								
			$order='';
			if(!empty($group)):								
				foreach($group as $key):
					if($key=='HOUR'):
						$ord[] = 'r.date_time';
						$ord[] = $key;	
					elseif($key=='DATE' || $key=='MONTH'):
						$ord[] = 'r.date_time';
					else:										
						$ord[] = $key;	
					endif;									
				endforeach;
				$order	=	implode(',',$ord);
			endif;								
		}			
		
		if(clean_data($this->post('date_from')) != ''){
			$search['date_from'] = clean_data($this->post('date_from')); 
		}
		
		if(clean_data($this->post('date_to') != '')){
			$search['date_to'] = clean_data($this->post('date_to')); 
		}
		
		if($this->post('country_id') != '' AND $this->post('country_id') != 'all'){
			$search['country_id'] = $this->post('country_id'); 
		}
				
		if(clean_data($this->post('environment')) != '' AND clean_data($this->post('environment')) != 'all'){
			$search['environment'] = clean_data($this->post('environment')); 
		}
		
		if(clean_data($this->post('pub_account_id')) != '' AND clean_data($this->post('pub_account_id')) != 'all'){
			$search['pub_account_id'] = clean_data($this->post('pub_account_id')); 
		}
		
		if($this->post('site_id') != '' AND $this->post('site_id') != 'all'){
			$search['site_id'] = $this->post('site_id'); 
		}
		
		if($this->post('adblock_id') != '' AND $this->post('adblock_id') != 'all'){
			$search['adblock_id'] = $this->post('adblock_id'); 
		}
		
		if($this->post('country') != '' AND $this->post('country') != 'all'){
			$search['country'] 		= 	$this->post('country'); 
		}
		
		if($this->post('adsize') != '' AND $this->post('adsize') != 'all'){
			$search['adsize'] 		= 	$this->post('adsize'); 
		}
		
		if($this->post('timezone') != '' AND $this->post('timezone') != 'utc'){
			$tz	=	explode(')',$this->post('timezone'));
			$tz1	=	str_replace('(GMT','',$tz[0]);
			$search['timezone'] 		= 	substr($tz1,0,3).':'.substr($tz1,3); 
		}
		
		if($agency_id != FALSE){
			$search['agency_id'] = $agency_id; 				
		}
		
		$datatable_obj = $this->post('datatable_obj');
		
		$penality	=	$this->do_antifraud->penality_imp_list($columns,$search,$group,$order);
		
		$no_records = 	($penality !== FALSE)?count($penality):0;
		
		if($penality):
			$result_data['sEcho'] 			= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 	= 	$no_records;
			$result_data['iTotalDisplayRecords'] = 	$no_records;
			$result_data['aaData'] = $penality;			
		else:
			$result_data['sEcho'] 			= 	$datatable_obj['sEcho'];
			$result_data['iTotalRecords'] 	= 	$no_records;
			$result_data['iTotalDisplayRecords']= 	0;
			$result_data['aaData'] = array();
			$result_data['overview_chart_data'] = 	'';
		endif;
		
		$this->response($result_data,200);
	}
	
	/*
	* 
	* name: fetch_anti_fraud_stats_filter
	* @param : null
	* @return : network created date
    */	
	public function fetch_anti_fraud_stats_filter_get()
	{
	  $agencyid=$this->user_authentication->agency_id;
	   $from_dt =$this->get('f_date');
	   $to_dt	=$this->get('t_date');
	   $stats_list=$this->do_antifraud->antifraud_statistics_filter($agencyid,$from_dt,$to_dt);
		 if($stats_list)
		   $this->response($stats_list,200);
		 else 
		  $this->response( array('response'=>'error'), 200);
	}
	
	/*
	* 
	* name: fetch_anti_penality_stats_filter
	* @param : null
	* @return : network created date
    */	
	public function fetch_anti_penality_stats_filter_get()
	{
	  $agencyid=$this->user_authentication->agency_id;
	   $from_dt =$this->get('f_date');
	   $to_dt	=$this->get('t_date');
	   $stats_list=$this->do_antifraud->penality_statistics_filter($agencyid,$from_dt,$to_dt);
		 if($stats_list)
		   $this->response($stats_list,200);
		 else 
		  $this->response( array('response'=>'error'), 200);
	}	
	
	/*
	 * name: convert_sorting_data
	 * @param :
	 * @return : $output or false
	 * 
	 * convert data into order by array
	 */
	function convert_sorting_data($request_data = FALSE)
	{
		if($request_data)
		{
			if ( isset( $request_data['iSortCol_0'] ) )
			{
				//Initialize order by array
				$sorting_order = array();
				
				for ( $i=0 ; $i<intval( $request_data['iSortingCols'] ) ; $i++ )
				{
					if ( $request_data[ 'bSortable_'.intval($request_data['iSortCol_'.$i]) ] == "true" )
					{
						$sorting_order[$request_data[ 'mDataProp_'.intval($request_data['iSortCol_'.$i]) ]] = $request_data[ 'sSortDir_'.$i];	
					}
				}
				return $sorting_order;	
			}else{
				return FALSE;	
			}
		}else{
			return FALSE;	
		}	
		
		
	} 

}
