<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * User
 *
 * Here We have developed services for advertiser related activities
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Suganthi
 * @link		http://www.djaxadserver.com
*/

// This can be removed if you use __autoload() in config.php OR use Modular Extensions

class Advertiser extends REST_Controller
{
	
	function __construct(){

		parent::__construct();
		$this->load->library('redis_library');	
		$this->load->library('csvreader');		
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->model('do_advertiser');
		$this->load->model('do_email_check');
		$this->load->model('do_publisher');
		$this->load->helper('email');
		$this->load->model('do_networks');
		$this->load->model('do_message');
		$this->load->library('notification');
		$this->load->model('do_app_config');
		$this->load->library('user_authentication');
	    $key=$this->input->get_post('api_key'); 
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {

	   		$this->response($user_auth->error,200);
	    }

	}
	
	
	
	
	public function add_careers_post()
   
	{
		
		$this->form_validation->set_rules('job_category', 'job category','required|trim');
		$this->form_validation->set_rules('job_title','Job Title','required');
		$this->form_validation->set_rules('job_summary','Job summary', 'required|trim');
		$this->form_validation->set_rules('required_skills','Required skills', 'required|trim');
		$this->form_validation->set_rules('company_offer','Company offers', 'trim');
		$this->form_validation->set_rules('employment_type','Employment_type', 'required|trim');
		$this->form_validation->set_rules('work_experience','work Experience', 'required|trim');
		$this->form_validation->set_rules('location','Location', 'required|trim');




		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			
			$obj		=	array(
									'job_category'		=>	clean_data($this->post('job_category')),
									'job_title'			=>	clean_data($this->post('job_title')),
									'job_summary'		=>	clean_data($this->post('job_summary')),
									'required_skills'	=>	clean_data($this->post('required_skills')),
									'company_offer'	    =>	clean_data($this->post('company_offer')),
									'employment_type'	=>	clean_data($this->post('employment_type')),
									'work_experience'	=>	clean_data($this->post('work_experience')),
									'location'			=>	clean_data($this->post('location'))
									
									
									);
								
				$careers_add = 	$this->do_advertiser->add_careers($obj);
				if($careers_add !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Careers has been added successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in adding Careers!..'
					);
				
				$this->response( $success, 200);
			}
			}
			
						
		}
		
		
	
	
	
	/*
   * 
   * name: block_career
   * @param : careerid
   * @return : sucess msg
   * 
   */
	public function block_careers_get()
	{
	    $id=clean_data($this->get('id'));
		if($id)
		{
			$block_careers = $this->do_advertiser->block_careers($id);
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Career is blocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	   /*
   * 
   * name: unblock_career
   * @param : careerid
   * @return :sucess msg
   * 
   */
	public function unblock_careers_get()
	{
	    $id=clean_data($this->get('id'));
		if($id)
		{
			$block_careers = $this->do_advertiser->unblock_careers($id);
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Career is Un-blocked successfully'
							 );
			
			$this->response( $success, 200);
		}
	}
	
	
	/*
   * 
   * name: update_careers_post
   * @param : none
   * @return : careers id
   * 
   */ 
	public function update_careers_post()
	{
		
		
		$this->form_validation->set_rules('job_category', 'job category','required|trim');
		$this->form_validation->set_rules('job_title','Job Title','required|trim');
		$this->form_validation->set_rules('job_summary','Job summary', 'required|trim');
		$this->form_validation->set_rules('required_skills','Required skills', 'required|trim');
		$this->form_validation->set_rules('company_offer','Company offers', 'trim');
		$this->form_validation->set_rules('employment_type','Employment_type', 'required');
		$this->form_validation->set_rules('work_experience','work Experience', 'required|trim');
		$this->form_validation->set_rules('location','Location', 'required|trim');

	   // $this->form_validation->set_rules('device_os', 'Device Name', 'required|trim');
		//$this->form_validation->set_message('is_unique', 'Already this Device name is being registered. please enter the unique one');
		//$this->form_validation->set_rules('os_value', 'OS Value', 'required|trim');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			
			$careers = $this->do_advertiser->update_careers($this->post());
			
			if($careers !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Careers has been Updated successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in Careers!..'
					);
				
				$this->response( $success, 200);
			}
			
						
		}

	
	}
	
	/*
   * 
   * name: browser_list_get
   * @param : none
   * @return :slected  browser details.
   * 
   */
	public function careers_list_get(){
		
	   $id = clean_data($this->get('id'));
	 
	   if($id){
	   $careers_list = $this->do_advertiser->fetch_careers_select($id);
	   $this->response($careers_list);
       }
	}
  
	
	public function fetch_careers_get()
	{
	 	 $careers_list = $this->do_advertiser->fetch_careers();
		 $this->response($careers_list,200);
	}
	
	public function fetch_country_get()
	{
	 	 $country_list = $this->do_advertiser->fetch_country();
		 $this->response($careers_list,200);
	}
	
	
public function job_listing_get()
	{
		  //$this->response("yyy");
	 	 $job_listing = $this->do_advertiser->job_listing();
	 	 // $this->response("yyy");
	 	// $this->response($this->db->last_query());
		 $this->response($job_listing,200);
	
	}

public function delete_careers_get()
   {
      $id = clean_data($this->get('id'));
	  
	   if($id)
		{
			 $careers_list = $this->do_advertiser->delete_careers($id);
			
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Career has been deleted'
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Career id is not found'
					);
			
			$this->response( $error, 200);
		}

   }
	
	/**
       * 
       * name : fetch_get()
       * 
       * Fetches all advertiser information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_get()
	{	
		$network_account_id	=	$this->user_authentication->network_account_id;
		$network_id			=	$this->user_authentication->account_id;
		$agency_id			=	$this->user_authentication->agency_id;
		$account_id			=	clean_data($this->get('account_id'));
		
		if($account_id)
		{
			if($network_account_id)
			{
				$advertiser = 	$this->do_advertiser->fetch($network_id,$network_account_id,$account_id);
			}
			else
			{
				$advertiser = 	$this->do_advertiser->fetch($network_id,'',$account_id);
			}
		}
		else
		{
			if($network_account_id)
			{
				$advertiser = 	$this->do_advertiser->fetch($network_id,$network_account_id);
			}
			else
			{
				$advertiser = 	$this->do_advertiser->fetch($network_id);
			}
		}
		
		if($advertiser)
		{
			
			$this->response($advertiser,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	
	
		/**
       * 
       * name : fetch_get()
       * 
       * Fetches all advertiser information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function mass_email_fetch_get()
	{	
		$network_account_id	=	$this->user_authentication->network_account_id;
		$network_id			=	$this->user_authentication->account_id;
		$agency_id			=	$this->user_authentication->agency_id;
		$account_id			=	clean_data($this->get('account_id'));
		
		if($account_id)
		{
			if($network_account_id)
			{
				$advertiser = 	$this->do_advertiser->mass_email_fetch($network_id,$network_account_id,$account_id);
			}
			else
			{
				$advertiser = 	$this->do_advertiser->mass_email_fetch($network_id,'',$account_id);
			}
		}
		else
		{
			if($network_account_id)
			{
				$advertiser = 	$this->do_advertiser->mass_email_fetch($network_id,$network_account_id);
			}
			else
			{
				$advertiser = 	$this->do_advertiser->mass_email_fetch($network_id);
			}
		}
		
		if($advertiser)
		{
			
			$this->response($advertiser,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	
	
	
	
	
	/**
       * 
       * name : fetch_get()
       * 
       * Fetches all advertiser information.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function fetch_advertiser_get()
	{	
		$account_id			=	clean_data($this->get('account_id'));
		
		if($account_id)
		{
			if($network_account_id)
			{
				$advertiser = 	$this->do_advertiser->fetch($network_id,$network_account_id,$account_id);
			}
			else
			{
				$advertiser = 	$this->do_advertiser->fetch($network_id,'',$account_id);
			}
		}
		else
		{
			if($network_account_id)
			{
				$advertiser = 	$this->do_advertiser->fetch($network_id,$network_account_id);
			}
			else
			{
				$advertiser = 	$this->do_advertiser->fetch($network_id);
			}
		}
		
		if($advertiser)
		{
			
			$this->response($advertiser,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	
	/**
       * 
       * name : campaign_count_get()
       * 
       * Fetches all campaign count.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function campaign_count_get()
	{	
		$network_account_id		=	$this->user_authentication->network_account_id;
		$network_id				=	$this->user_authentication->account_id;
		$account_id				=	clean_data($this->get('account_id'));
		
		if($account_id)
		{
			if($network_account_id)
			{
				$count = 	$this->do_advertiser->campaign_count($network_id,$network_account_id,$account_id);
			}
			else
			{
				$count = 	$this->do_advertiser->campaign_count($network_id,'',$account_id);
			}
		}
		else
		{
			if($network_account_id)
			{
				$count = 	$this->do_advertiser->campaign_count($network_id,$network_account_id);
			}
			else
			{
				$count = 	$this->do_advertiser->campaign_count($network_id);
			}
		}
		if($count)
		{		
			$this->response($count,200);
		}
		else
		{
			$this->response('0', 200);
		}
	}
	
	/**
       * 
       * name : creative_count_get()
       * 
       * Fetches all campaign count.
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	function creative_count_get()
	{	
		$network_account_id		=	$this->user_authentication->network_account_id;
		$network_id				=	$this->user_authentication->account_id;
		$account_id				=	clean_data($this->get('account_id'));
		$campaign_id			=	clean_data($this->get('campaign_id'));
		
		if($account_id)
		{
			if($network_account_id)
			{
				if($campaign_id)
				{
					$count = 	$this->do_advertiser->creative_count($network_id,$network_account_id,$account_id,$campaign_id);
				}
				else
				{
					$count = 	$this->do_advertiser->creative_count($network_id,$network_account_id,$account_id);
				}
			}
			else
			{
				if($campaign_id)
				{
					$count = 	$this->do_advertiser->creative_count($network_id,'',$account_id,$campaign_id);
				}
				else
				{
					$count = 	$this->do_advertiser->creative_count($network_id,'',$account_id);
				}
			}
		}
		else
		{
			if($network_account_id)
			{
				$count = 	$this->do_advertiser->creative_count($network_id,$network_account_id);
			}
			else
			{
				$count = 	$this->do_advertiser->creative_count($network_id);
			}
		}
		
		if($count)
		{		
			$this->response($count,200);
		}
		else
		{
			$this->response('0', 200);
		}
	}
	
	//api/v1/advertiser/add
	function add_post()
	{	
		$this->form_validation->set_rules('first_name','First Name', 'required|trim|first_alpha_check|alpha_numeric_dash_space');
		$this->form_validation->set_rules('last_name', 'Last Name','required|trim|first_alpha_check|alpha_numeric_dash_space');
		$this->form_validation->set_rules('email_id', 'Email Address', 'required|trim|is_email|callback_email_check');
		$this->form_validation->set_rules('password', 'Password','required|trim');
		$this->form_validation->set_rules('confirm_password', 'Confirm Password','required|trim|matches[password]');

		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			$network_id		=	get_session('network_account_id');
			$account_id		=	get_session('account_id');
			
			$add_data		=	array(
									'first_name'	=>	clean_data($this->post('first_name')),
									'last_name'		=>	clean_data($this->post('last_name')),
									'email'			=>	clean_data($this->post('email_id')),
									'password'		=>	clean_data($this->post('password')),
									'budget'		=>	clean_data($this->post('budget')),
									'mob_no'		=>	clean_data($this->post('mob_no')),
									'skype_id'		=>	clean_data($this->post('skype_id')),
									'additional_info'=>	clean_data($this->post('additional_info')),									
									'account_type'	=>	'ADVERTISER',
									'created_date'	=>	date('Y-m-d H:i:s'),
									'security_id' => clean_data($this->post('security_question_id')),
									'security_answer'=>clean_data($this->post('security_answer')) 
									);	  		
									
			if($network_id)
			{						
				$advertiser_add = 	$this->do_advertiser->add($add_data,$account_id,$network_id);
			}
			else
			{
				$advertiser_add = 	$this->do_advertiser->add($add_data,$account_id);
			}
			
			/* Activity Log for Advertiser Add- Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,ADVERTISER_ADD);
				if($enable=='1')
				{							
				$this->activity_log(ADVERTISER,ADD,$advertiser_add['client_id']);  
				}
				/* Activity Log for Advertiser Add- End*/	
			
			if($advertiser_add != FALSE)
			{	
				// SEND LOGIN DETAILS to USER
				if($this->user_authentication->account_type == "ADMIN" )
				{
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);	
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$account_type=$advertiser_add['account_type'];
					$account_id=$advertiser_add['account_id'];
					$account_type  = $add_data['account_type'];
					$user_email    = $add_data['email'];
					$password      = $add_data['password'];
					$user_name     = $add_data['first_name']." ".$add_data['last_name'];
					$type          = 'ADV_LOGIN_CREDENTIAL';		
					$from 	       = $admin_email;
					$to  	       = $user_email;			
					$mail_content=array(
						"subject" 		=> "Login Credentials",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						"password"		=> $password								
						);			
						send_mail($type,$from,$to,$mail_content);
					

					$success 	= 	array(
										'response' 	=> 	'ok',
										'msg'	 	=> 	'Advertiser has been added successfully!..'
									);
					$this->response( $success, 200);
				}
				else
				{
					// IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
					$manager_user_id = $this->user_authentication->manager_user_id;
					$is_manager = $this->do_networks->get_manager_role($manager_user_id);
					if($is_manager == 1)
					{
						// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->do_networks->agency_owner_details($agency_id);
						// IF NOT NETWORK ADMIN ADMIN SEND BCC
						$network_admin=$this->do_networks->get_network_details();
						$bcc		   = $network_admin['email'];
						$admin_name    = $result['name'];			
						$admin_email   = $result['email'];
						$account_type=$advertiser_add['account_type'];
						$account_id=$advertiser_add['account_id'];
						$account_type  = $add_data['account_type'];
						$user_email    = $add_data['email'];
						$password      = $add_data['password'];
						$user_name     = $add_data['first_name']." ".$add_data['last_name'];
						$type          = 'ADV_LOGIN_CREDENTIAL';		
						$from 	       = $admin_email;
						$to  	       = $user_email;			
						$mail_content=array(
							"subject" 		=> "Login Credentials",
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,
							"email"  		=> $user_email,
							"password"		=> $password								
							);			
						$attachement = "";	
						send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
						

						$success 	= 	array(
											'response' 	=> 	'ok',
											'msg'	 	=> 	'Advertiser has been added successfully!..'
										);
						$this->response( $success, 200);
					}
					else
					{
						// GET NETWORK USERS MAILING DETAILS
						$user_mailing_details = $this->do_networks->get_network_users_detail($manager_user_id);
						$admin_email = $user_mailing_details['email_address'];
						$admin_name = $user_mailing_details['contact_name'];
						
						// GET NETWORK MANAGER MAILING DETAIL FOR BCC
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->do_networks->agency_owner_details($agency_id);
						$bcc = $result['email'];
						
						$account_type=$advertiser_add['account_type'];
						$account_id=$advertiser_add['account_id'];
						$account_type  = $add_data['account_type'];
						$user_email    = $add_data['email'];
						$password      = $add_data['password'];
						$user_name     = $add_data['first_name']." ".$add_data['last_name'];
						$type          = 'ADV_LOGIN_CREDENTIAL';		
						$from 	       = $admin_email;
						$to  	       = $user_email;			
						$mail_content=array(
							"subject" 		=> "Login Credentials",
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,
							"email"  		=> $user_email,
							"password"		=> $password								
							);			
						$attachement = "";	
						send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
						

						$success 	= 	array(
											'response' 	=> 	'ok',
											'msg'	 	=> 	'Advertiser has been added successfully!..'
										);
						$this->response( $success, 200);
					}	
				}
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
								);
				$this->response( $error, 200);
			}
						
		}
	}
	
	
	/**
       * 
       * name : update_post()
       * 
       * Updates the site information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	function update_post()
	{
		$account_id	=clean_data($this->post('account_id'));
		$this->form_validation->set_rules('first_name','First Name', 'required|trim|first_alpha_check|alpha_numeric_dash_space');
		$this->form_validation->set_rules('last_name', 'Last Name','required|trim|first_alpha_check|alpha_numeric_dash_space');
		$this->form_validation->set_rules('email_id', 'Email Address', 'required|trim|is_email|callback_edit_email_check');
		
		if($this->form_validation->run() === FALSE)
		{	
			$error_msg 	= 	$this->form_validation->error_array();
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg' 		=>  $error_msg
							);

			$this->response( $error, 200);
		}
		else
		{
			$update_data	=	array(
									'first_name'	=>	clean_data($this->post('first_name')),
									'last_name'		=>	clean_data($this->post('last_name')),
									'email'			=>	clean_data($this->post('email_id')),
									'account_type'	=>	'ADVERTISER',
									'cur_balance'	=>	clean_data($this->post('cur_balance')),
									);
									
			$adv_update 	= 	$this->do_advertiser->update($account_id,$update_data);
			
			$client_id=$this->do_advertiser->fetch_client_id($account_id);		
				
			
			/* Activity Log for Advertiser update- Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,ADVERTISER_EDIT);
				if($enable=='1')
				{							
				$this->activity_log(ADVERTISER,EDIT,$client_id[0]['clientid']);
				}
				/* Activity Log for Advertiser update- End*/	
			
			
			if($adv_update != FALSE)
			{	
				$success 	= 	array(
									'response' 	=> 	'ok',
									'msg'	 	=> 	'Advertiser has been updated successfully!..'
									);
				$this->response( $success, 200);
			}
			else
			{
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
									);
				$this->response( $error, 200);
			}			
		}
	}
	
	/**
       * 
       * name : delete_get()
       * 
       * deletes the advertiser information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_get()
	{	
		$account_id = $this->get('del_account_id');	
		
		$arrays	=	explode(',',$account_id);
		   if(is_array($arrays))
			{  
				foreach($arrays as $account_id)
				{
					 $results= $this->del_advr(clean_data($account_id));
					 
					  /* Activity Log for Advertiser Delete- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,ADVERTISER_DELETE);
					if($enable=='1')
					{							
					$this->activity_log(ADVERTISER,DELETE,$results['client_id']);
					}
					/* Activity Log for Advertiser Delete- End*/
					 
				}
					
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Advertiser has been deleted successfully..'
										);
					
					$this->response( $success, 200);
			}
			else
			{
				$results= $this->del_advr(clean_data($account_id));
				
				 /* Activity Log for Advertiser Delete- Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(NETWORK_USERS,ADVERTISER_DELETE);
					if($enable=='1')
					{							
					$this->activity_log(ADVERTISER,DELETE,$results['client_id']);
					}
					/* Activity Log for Advertiser Delete- End*/
				
				
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Advertiser has been deleted successfully..'
										);
					
				$this->response( $success, 200);
			}
	}
	
	function del_advr($account_id)
	{
		if($account_id)
		{
			$advertiser_details = 	$this->do_advertiser->get_profile($account_id);
			$advertiser = 	$this->do_advertiser->remove($account_id);
			
			if($advertiser)
			{   
			    // SEND DELETION MESSAGE TO USER
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->do_networks->agency_owner_details($agency_id);
				if($agency_id == 1)
				{
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $advertiser_details['email'];
					$user_name     = $advertiser_details['first_name']." ".$advertiser_details['last_name'];
					$type          = 'ADV_DELETION';		
					$from 	       = $admin_email;
					$to  	       = $user_email;			
					$mail_content  = array(
						"subject" 		=> "Advertiser Deletion",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email
						);			
					send_mail($type,$from,$to,$mail_content);
					
				}
				else
				{
					// IF NOT NETWORK ADMIN ADMIN SEND BCC
					$network_admin=$this->do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $advertiser_details['email'];
					$user_name     = $advertiser_details['first_name']." ".$advertiser_details['last_name'];
					$type          = 'ADV_DELETION';		
					$from 	       = $admin_email;
					$to  	       = $user_email;			
					$mail_content  = array(
						"subject" 		=> "Advertiser Deletion",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email
						);			
					send_mail($type,$from,$to,$mail_content);
											
				}	
			}
			else
			{
				$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Error..Please Try again.'
								);
			
				$this->response( $error, 200);
			}
		}
		else
		{
			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Advertiser does not found.'
								);
			
			$this->response( $error, 200);
		}
	}
	
	/**
       * 
       * name : block_get()
       * 
       * block the advertiser information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function block_get()
	{	
		$account_id = $this->get('block_account_id');	
		
		 $arrays	=	explode(',',$account_id);
		   if(is_array($arrays))
			{  
				foreach($arrays as $account_id)
				{
					 $results= $this->block_advr(clean_data($account_id));
				}
					
				$success 	= 	array('response'	=> 	'ok',
									  'msg'			=> 	'Advertiser has been blocked successfully..'
										);
					
				$this->response( $success, 200);
			}
			else
			{
				$results= $this->block_advr(clean_data($account_id));
				
				$success 	= 	array('response'	=> 	'ok',
									  'msg'			=> 	'Advertiser has been blocked successfully..'
										);
					
				$this->response( $success, 200);
			}
	}
	
	function block_advr($account_id)
	{
		if($account_id)
		{
			$advertiser 	= 	$this->do_advertiser->block($account_id);
			
			if($advertiser)
			{
				$client_id=$this->do_advertiser->fetch_client_id($account_id);		
				
				  /* Activity Log for block advertiser- Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,USER_ACCESS_BLOCK);
				if($enable=='1')
				{						
				$this->activity_log(ADVERTISER,BLOCK,$client_id[0]['clientid']);
				}
				/* Activity Log for block advertiser- End*/
				
				$advertiser_details 	= 	$this->do_advertiser->get_profile($account_id);
				
				//SEND MAIL TO THE BLOCKED ADVERTISER
				if($this->user_authentication->account_type == "ADMIN" )
				{
					$agency_id	=	$this->user_authentication->agency_id;
					$result=$this->do_networks->agency_owner_details($agency_id);
					$user = $this->do_message->get_profile(ADMIN_ID);
					
					$admin_name    = $result['name'];		
					$admin_email   = $result['email'];
					$user_email    = $advertiser_details['email'];
					$user_name     = $advertiser_details['first_name'].' '.$advertiser_details['last_name'];
					$type     	   = "BLOCK_ADVERTISER_ACCOUNT";
					$from 	       =  $admin_email;
					$to  	       =  $user_email;
					$network_id	=	$this->do_message->fetch_admin_network_id();
						$mail_type = "BLOCK_ADVERTISER_ACCOUNT";
						$acc_type='ADMIN';

						$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "BLOCK_ADVERTISER_ACCOUNT",
						'string'		=> 'user_access_block',
						'column_name'	=> 'account_settings'
						); 
						$message_data		=	array(
						'sender_id'		=>	ADMIN_ID,
						'receiver_id'	=>	$account_id,
						'subject'		=>	'Advertiser - Block',
						'content'		=> 	'Advertise blocked successfully',
						'image_name'	=>	NULL,
						'file_name'		=>	NULL,
						'account_type'	=>	"ADVERTISER",
						'status'		=>	'1',
						'network_id'	=>	$network_id,
						'notification_type'	=>	"setting_information",										
						'date'			=>	date('Y-m-d H:i:s')
						);			
					$mail_content=array(
						"subject" 		=> "Advertiser Blocked",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						);
					$attachement='';	
					//send_mail($type,$from,$to,$mail_content,$attachement);
					$dat = $this->notification->new_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);
				}
				else
				{
					// IF NOT NETWORK ADMIN SEND BCC TO APPROPRIATE MANAGER
					$manager_user_id = $this->user_authentication->manager_user_id;
					$is_manager = $this->do_networks->get_manager_role($manager_user_id);
					if($is_manager == 1)
					{
						// GET MANAGER MAILING DETAILS FOR FROM ADDRESS
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->do_networks->agency_owner_details($agency_id);
						// IF NOT NETWORK ADMIN ADMIN SEND BCC
						$network_admin=$this->do_networks->get_network_details();
						$user = $this->do_message->get_profile(ADMIN_ID);
						$bcc		   = $network_admin['email'];	
						$admin_name    = $result['name'];		
						$admin_email   = $result['email'];
						$user_email    = $advertiser_details['email'];
						$user_name     = $advertiser_details['first_name'].' '.$advertiser_details['last_name'];
						$type     	   = "BLOCK_ADVERTISER_ACCOUNT";
						$from 	       =  $admin_email;
						$to  	       =  $user_email;
						$network_id	=	$this->do_message->fetch_admin_network_id();
						$mail_type = "BLOCK_ADVERTISER_ACCOUNT";
						$acc_type='ADMIN';

						$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "BLOCK_ADVERTISER_ACCOUNT",
						'string'		=> 'user_access_block',
						'column_name'	=> 'account_settings'
						); 
						$message_data		=	array(
						'sender_id'		=>	ADMIN_ID,
						'receiver_id'	=>	$account_id,
						'subject'		=>	'Advertiser - Block',
						'content'		=> 	'Advertise blocked successfully',
						'image_name'	=>	NULL,
						'file_name'		=>	NULL,
						'account_type'	=>	"ADVERTISER",
						'status'		=>	'1',
						'network_id'	=>	$network_id,	
						'notification_type'	=>	"setting_information",									
						'date'			=>	date('Y-m-d H:i:s')
						);			
						$mail_content=array(
							"subject" 		=> "Advertiser Blocked",
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,
							"email"  		=> $user_email,
							);
						$attachement='';	
						//send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
						$dat = $this->notification->new_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);
					}
					else
					{
						// GET NETWORK USERS MAILING DETAILS
						$user_mailing_details = $this->do_networks->get_network_users_detail($manager_user_id);
						$admin_email = $user_mailing_details['email_address'];
						$admin_name = $user_mailing_details['contact_name'];
						
						// GET NETWORK MANAGER MAILING DETAIL FOR BCC
						$agency_id	=	$this->user_authentication->agency_id;
						$result=$this->do_networks->agency_owner_details($agency_id);
						$user = $this->do_message->get_profile(ADMIN_ID);
						$bcc = $result['email'];
						
						$user_email    = $advertiser_details['email'];
						$user_name     = $advertiser_details['first_name'].' '.$advertiser_details['last_name'];
						$type     	   = "BLOCK_ADVERTISER_ACCOUNT";
						$from 	       =  $admin_email;
						$to  	       =  $user_email;	
						$network_id	=	$this->do_message->fetch_admin_network_id();
						$mail_type = "BLOCK_ADVERTISER_ACCOUNT";
						$acc_type='ADMIN';

						$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "BLOCK_ADVERTISER_ACCOUNT",
						'string'		=> 'user_access_block',
						'column_name'	=> 'account_settings'
						); 
						$message_data		=	array(
						'sender_id'		=>	ADMIN_ID,
						'receiver_id'	=>	$account_id,
						'subject'		=>	'Advertiser - Block',
						'content'		=> 	'Advertise blocked successfully',
						'image_name'	=>	NULL,
						'file_name'		=>	NULL,
						'account_type'	=>	"ADVERTISER",
						'status'		=>	'1',
						'network_id'	=>	$network_id,	
						'notification_type'	=>	"setting_information",									
						'date'			=>	date('Y-m-d H:i:s')
						);		
						$mail_content=array(
							"subject" 		=> "Advertiser Blocked",
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,
							"email"  		=> $user_email,
							);
						$attachement='';	
						//send_mail($type,$from,$to,$mail_content,$attachement,$bcc);
						$dat = $this->notification->new_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);
					}	
				}
			}
			else
			{
				
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
									);
				
				$this->response( $error, 200);
			}
			
		}
		else
		{
			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Advertiser does not found.'
								);
			
			$this->response( $error, 200);
		}
	}
	
	/**
       * 
       * name : unblock_get()
       * 
       * block the advertiser information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function unblock_get()
	{	
		$account_id = $this->get('unblock_account_id');	
		
		$arrays	=	explode(',',$account_id);
		   if(is_array($arrays))
			{  
				foreach($arrays as $account_id)
				{
					 $results= $this->unblock_advr(clean_data($account_id));
				}
					
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Advertiser has been unblocked successfully..'
										);
					
				$this->response( $success, 200);
			}
			else
			{
				$results= $this->unblock_advr(clean_data($account_id));
				
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Advertiser has been unblocked successfully..'
										);
					
				$this->response( $success, 200);
			}
	}
	
	function unblock_advr($account_id)
	{
		if($account_id)
		{
			$advertiser 	= 	$this->do_advertiser->unblock($account_id);
			
			if($advertiser)
			{
				
				$client_id=$this->do_advertiser->fetch_client_id($account_id);		
				
				/* Activity Log for block advertiser- Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,USER_ACCESS_UNBLOCK);
				if($enable=='1')
				{											
				$this->activity_log(ADVERTISER,UNBLOCK,$client_id[0]['clientid']);
				}
				/* Activity Log for block advertiser- End*/
				$advertiser_details 	= 	$this->do_advertiser->get_profile($account_id);
				//SEND MAIL TO THE BLOCKED ADVERTISER
				$agency_id	=	$this->user_authentication->agency_id;
				$result=$this->do_networks->agency_owner_details($agency_id);
				$user = $this->do_message->get_profile(ADMIN_ID);	
				if($agency_id==1)
				{		
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $advertiser_details['email'];
					$user_name     = $advertiser_details['first_name'].' '.$advertiser_details['last_name'];
					$type     	   = "UNBLOCK_ADVERTISER_ACCOUNT";
					$from 	       =  $admin_email;
					$to  	       =  $user_email;
					$network_id	=	$this->do_message->fetch_admin_network_id();
						$mail_type = "UNBLOCK_ADVERTISER_ACCOUNT";
						$acc_type='ADMIN';

						$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "UNBLOCK_ADVERTISER_ACCOUNT",
						'string'		=> 'user_access_unblock',
						'column_name'	=> 'account_settings'
						); 
						$message_data		=	array(
						'sender_id'		=>	ADMIN_ID,
						'receiver_id'	=>	$account_id,
						'subject'		=>	'Advertiser - Unblock',
						'content'		=> 	'Advertise unblocked successfully',
						'image_name'	=>	NULL,
						'file_name'		=>	NULL,
						'account_type'	=>	"ADVERTISER",
						'status'		=>	'1',
						'network_id'	=>	$network_id,	
						'notification_type'	=>	"setting_information",									
						'date'			=>	date('Y-m-d H:i:s')
						);			
					$mail_content=array(
						"subject" 		=> "Advertiser Unblocked",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						);
						
					$attachement='';	
					//send_mail($type,$from,$to,$mail_content,$attachement,$from);
					$dat = $this->notification->new_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);
				}
				else
				{
					// IF NOT NETWORK ADMIN ADMIN SEND BCC
					$network_admin=$this->do_networks->get_network_details();
					$bcc		   = $network_admin['email'];
					$admin_name    = $result['name'];			
					$admin_email   = $result['email'];
					$user_email    = $advertiser_details['email'];
					$user_name     = $advertiser_details['first_name'].' '.$advertiser_details['last_name'];
					$type     	   = "UNBLOCK_ADVERTISER_ACCOUNT";
					$from 	       =  $admin_email;
					$to  	       =  $user_email;
					$network_id	=	$this->do_message->fetch_admin_network_id();
						$mail_type = "UNBLOCK_ADVERTISER_ACCOUNT";
						$acc_type='ADMIN';

						$type_details		=	array(
						'msg_type'		=> $message,
						'type'			=> "UNBLOCK_ADVERTISER_ACCOUNT",
						'string'		=> 'user_access_unblock',
						'column_name'	=> 'account_settings'
						); 
						$message_data		=	array(
						'sender_id'		=>	ADMIN_ID,
						'receiver_id'	=>	$account_id,
						'subject'		=>	'Advertiser - Unblock',
						'content'		=> 	'Advertise unblocked successfully',
						'image_name'	=>	NULL,
						'file_name'		=>	NULL,
						'account_type'	=>	"ADVERTISER",
						'status'		=>	'1',
						'network_id'	=>	$network_id,	
						'notification_type'	=>	"setting_information",									
						'date'			=>	date('Y-m-d H:i:s')
						);			
					$mail_content=array(
						"subject" 		=> "Advertiser Unblocked",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,
						"email"  		=> $user_email,
						);
					$attachement='';	
					//send_mail($type,$from,$to,$mail_content,$attachement,$from,$bcc);
					$dat = $this->notification->new_mail($message_data,$user,$advertiser_details,$type_details,$mail_content);
				}
			}
			else
			{
				
				$error 		= 	array(
									'response' 	=> 	'error',
									'msg'	 	=> 	'Error..Please Try again.'
									);
				
				$this->response( $error, 200);
			}
			
		}
		else
		{			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Advertiser does not found.'
								);
			
			$this->response( $error, 200);
		}
	}
	
	
	/*
	 * 
	 * name: user_information
	 * @param :null
	 * @return : response Array
	 * 
	 * get the user information for particular Advertiser
	 */	
		 
	 public function user_information_get()
	 {	
		$account_id = $this->user_authentication->account_id;

		$user_info=$this->do_advertiser->get_user_information($account_id);	  
		 
		 if($user_info)
		 {
			 $this->response($user_info, 200); // 200 being the HTTP response code
		 }
		
	 }
	
		
 /*
	 * 
	 * name: company_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the company Information for Particular Advertiser
	 */
	
    public function company_information_add_post()
    {		
		
		$this->form_validation->set_rules('company_name', 'Company Name', 'trim|required');
		$this->form_validation->set_rules('company_website', 'Company website', 'trim|valid_url');
		$this->form_validation->set_rules('company_address', 'Company Address', 'trim|required');
		$this->form_validation->set_rules('company_block_no', 'Company Block Number', 'trim|required');
		$this->form_validation->set_rules('company_address', 'Company Address', 'trim|required');
		$this->form_validation->set_rules('company_city', 'City', 'trim|required|alpha|callback_edit_company_test');
		$this->form_validation->set_rules('company_state', 'State', 'trim|required|alpha|callback_edit_company_check');
		$this->form_validation->set_rules('company_country', 'Company Country', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			
			$account_id = $this->user_authentication->account_id;
			
			$update_company_infoObj=array(							
										"company_name"  	=>	clean_data($this->post('company_name')),
										"company_website"  	=>	clean_data($this->post('company_website')),
										"company_address"	=>	clean_data($this->post('company_address')),
										"company_block_no" 	=>	clean_data($this->post('company_block_no')),
										"company_city"		=>  clean_data($this->post('company_city')),
										"company_state" 	=>	clean_data($this->post('company_state')),
										"company_country"	=>	clean_data($this->post('company_country')),
										"updated"			=>	date("Y-m-d H:i:s")
								);	
							
			
		    $this->do_advertiser->update_companyinfo($account_id,$update_company_infoObj);
		    
		     /* Activity Log for Company information - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,COMPANY_INFORMATION);
				if($enable=='1')
				{							
				$this->activity_log(COMPANY_INFORMATION,EDIT);
				}
			/* Activity Log for Company information - End*/	
		    
		    
		    
		    /* GET AGENCY ID FROM LIBRARY */
		    $agency_id	=	$this->user_authentication->agency_id;
			$client_id 		=	$this->user_authentication->client_id;
			/* GET DEFAULT MANAGER EMAIL ID */
			$result=$this->do_networks->agency_owner_details($agency_id);
			$admin_name    = $result['name'];			
			$admin_email   = $result['email'];		
			
			/* GET ADMIN EMAIL ID FOR bcc */
			$network_admin=$this->do_networks->get_network_details();
			$bcc		   = $network_admin['email'];
			$admin_set = $this->default_configurations->get('adv_pub_msg');
			$db = 'select * from djax_adv_pub_notification_settings where account_id='.$account_id;
			$jb = $this->db->query($db);
			$djax_adv_pub = $jb->result_array();
			//return $djax_adv_pub;
			$enable_disable = $djax_adv_pub[0]['msg_adv_pub_enable'];
			
			
			if($admin_set=='enable')
			{
				
			if($enable_disable)
			{
				$string = 'company_info';
				
				if(strpos($djax_adv_pub[0]['account_settings'],$string)!== false)
				{
					$msg_type = $djax_adv_pub[0]['msg_type'];
					//return 'array_match';
				}
				else{
					$msg_type = null;
					//return 'array doesnt match'; 
				}
			  
			}
			else{
				
				$msg_type = null;
				//return 'adv not willing to recieve';
			}
		}
			
			
			/* ADVERTISER DETAILS */
			$adv_result_array  =  $this->do_advertiser->get_user_information($account_id);
			$adv_result		   =  $adv_result_array[0];
			$user_name  	   =  $adv_result['clientname'];
			$user_email		   =  $adv_result['email'];
			
			$type   ="COMPANY_INFORMATION";
			$from 	=  $admin_email;
			$to  	=  $user_email;	
			
			/* Gender values */
			$company_country=$this->do_networks->country(clean_data($this->post('company_country')));
				
			//SEND EMAIL TO ADVERTISERS
			$mail_content=array(
							"subject" 		=> "Advertiser - Company Information",
							"to_name" 		=> $user_name,				
							"from_name"		=> $admin_name,							
							"company_name"  =>	clean_data($this->post('company_name')),
							"company_address"	=>	clean_data($this->post('company_address')),
							"company_block_no" 	=>	clean_data($this->post('company_block_no')),
							"company_city"		=>  clean_data($this->post('company_city')),
							"company_state"		=>  clean_data($this->post('company_state')),
							"company_country" 	=> $company_country['name']	,
							"account_type"	    => "advertiser"	,
							"company_website"  	=>	clean_data($this->post('company_website')),			
							);
			/* CHECK ADMIN EMAIL AND BCC EMAIL ARE SAME */				
			$bcc=($bcc!=$admin_email)?$bcc:'';
			$attachement = "";		
			
			
			$content = "<b>company_name :</b>".clean_data($this->post('company_name'))."<br><b>company_website :</b>".clean_data($this->post('company_website'))."<br><b>company_address :</b>".clean_data($this->post('company_address'))."<br><b>company_block_no: </b> ".clean_data($this->post('company_block_no'))."<br><b>company_city: </b>".clean_data($this->post('company_city'))."<br><b>company_state: </b>".clean_data($this->post('company_state'))."<br><b>company_country: </b>".$company_country['name']	."<br><b>account_type: </b>advertiser".clean_data($this->post('state'))."<br><b>country:</b>".$country['name'];
			//$this->response($content,200);
					/********message****/
			
			$account_type	=	$this->user_authentication->account_type;
		
			$network_id	=	$this->do_message->fetch_admin_network_id();
		
			$message  = $this->default_configurations->get('message_type');		
				
			
			$message_data		=	array(
											'sender_id'		=>	ADMIN_ID,
											'receiver_id'	=>	$account_id,
											'subject'		=>	'Advertiser - Company Information updated',
											'content'		=>	$content,
											'image_name'	=>	NULL,
											'file_name'		=>	NULL,
											'account_type'	=>	"advertiser",
											'status'		=>	'1',
											'network_id'	=>	$network_id,
											'notification_type'	=>	"setting_information",									
											'date'			=>	date('Y-m-d H:i:s')
											);
			
					
			/* CALL HELPHER FILE */
			  if($msg_type=='email')
			{
				/* CALL HELPHER FILE */
				send_mail($type,$from,$to,$mail_content,$attachement,$bcc);	
			}
			else if($msg_type=='msg')
			{
				$this->db->insert(TAB_MESSAGES,$message_data);
			
			}
			else if($msg_type=='both')
			{
				$this->db->insert(TAB_MESSAGES,$message_data);
			
				send_mail($type,$from,$to,$mail_content,$attachement,$bcc);	
				
			}		
			
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('advertiser/settings/company_information'),
							'msg'	 => 'Company Information are updated successfully!..'
			);
		
						
			$this->response($success, 200);
		}
		

	}
	
	 /*
	 * 
	 * name: personal_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the Personal Account Information for Particular Advertiser
	 */
	
    public function personal_information_add_post()
    {
		
		$this->form_validation->set_rules('first_name', 'First Name', 'trim|required');
		$this->form_validation->set_rules('last_name', 'Last Name', 'trim|required');
		$this->form_validation->set_rules('gender', 'Gender', 'trim|required');
		$this->form_validation->set_rules('date_of_birth', 'Date Of Birth', 'trim|required');
		$this->form_validation->set_rules('mobile_no', 'Mobile Number', 'trim|required');
		$this->form_validation->set_rules('city', 'City', 'trim|required|alpha|callback_edit_check');
		$this->form_validation->set_rules('state', 'State', 'trim|required|alpha|callback_edit_state');
		$this->form_validation->set_rules('country', 'Country', 'trim|required');
		
		$this->form_validation->set_rules('skype', 'Skype Address', 'trim|required');
		$this->form_validation->set_rules('icq', 'ICQ Address', 'trim|required');
		$this->form_validation->set_rules('jabber', 'Jabber Address', 'trim|required');		
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			
			$account_id = $this->user_authentication->account_id;
			$client_id 		=	$this->user_authentication->client_id;
			$org_date =clean_data($this->post('date_of_birth'));
			$date = new DateTime($org_date);
			$date_format=$date->format('Y-m-d'); // 2012-09-13
			
			$update_personal_infoObj=array(											
										"first_name"  	=>	clean_data($this->post('first_name')),
										"last_name"		=>	clean_data($this->post('last_name')),
										"gender" 		=>	clean_data($this->post('gender')),
										"dob"			=> 	$date_format ,
										"mobile_number" =>	clean_data($this->post('mobile_no')),
										"city" 			=>	clean_data($this->post('city')),
										"state" 		=>	clean_data($this->post('state')),
										"country" 		=>	clean_data($this->post('country')),
										"skype"         => 	clean_data($this->post('skype')),
										"icq"         	=> 	clean_data($this->post('icq')),
										"jabber"        => 	clean_data($this->post('jabber')),
										"vat_number"    =>  clean_data($this->post('european_vat')),
										"updated"		=>	date("Y-m-d H:i:s")										
								);	
									
			$account_setting_type="personal";											
		
		    $this->do_advertiser->update($account_id,$update_personal_infoObj,$account_setting_type);
		    
		    /* Activity Log for Personal information - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,PERSONAL_INFORMATION);
				if($enable=='1')
				{							
				$this->activity_log(PERSONAL_INFORMATION,EDIT);
				}
			/* Activity Log for Personal information - End*/	
		    	    
		    
		    //SEND EMAIL TO ADVERTISERS
		    
		    /* GET AGENCY ID FROM LIBRARY */
		    
		    
			$db = 'select * from djax_adv_pub_notification_settings where account_id='.$account_id;
			$jb = $this->db->query($db);
			$djax_adv_pub = $jb->result_array();
			//return $djax_adv_pub;
			$enable_disable = $djax_adv_pub[0]['msg_adv_pub_enable'];
			
			$admin_set = $this->default_configurations->get('adv_pub_msg');
			
			if($admin_set=='enable')
			{
				
			if($enable_disable)
			{
				$string = 'personal_info';
				
				if(strpos($djax_adv_pub[0]['account_settings'],$string)!== false)
				{
					$msg_type = $djax_adv_pub[0]['msg_type'];
					//return 'array_match';
				}
				else{
					$msg_type = null;
					//return 'array doesnt match'; 
				}
			  
			}
			else{
				
				$msg_type = null;
				//return 'adv not willing to recieve';
			}
		}
		
		
		
		//$this->response($msg_type,200);
		
		 $agency_id	=	$this->user_authentication->agency_id;
			
			/* GET DEFAULT MANAGER EMAIL ID */
			$result=$this->do_networks->agency_owner_details($agency_id);
			$admin_name    = $result['name'];			
			$admin_email   = $result['email'];		
			
			/* GET ADMIN EMAIL ID FOR bcc */
			$network_admin=$this->do_networks->get_network_details();
			$bcc		   = $network_admin['email'];
			
			/* ADVERTISER DETAILS */
			$adv_result_array  =  $this->do_advertiser->get_user_information($account_id);
			$adv_result		   =  $adv_result_array[0];
			$user_name  	   =  $adv_result['clientname'];
			$user_email		   =  $adv_result['email'];
			
			$type   ="PERSONAL_INFORMATION";
			$from 	=  $admin_email;
			$to  	=  $user_email;	
			/* Gender values */
			$gender=($this->post('gender')=='1')?'Male':'Female';
			$country=$this->do_networks->country($this->post('country'));
				
			$mail_content=array(
							"subject" 		=> 	"Advertiser - Personal Information updated",
							"to_name" 		=> 	$user_name,				
							"from_name"		=> 	$admin_name,							
							"first_name"    => 	clean_data($this->post('first_name')),
							"last_name" 	=> 	clean_data($this->post('last_name')),
							"gender"    	=> 	$gender,
							"dob"	        => 	$date_format ,
							"mobile_number" => 	clean_data($this->post('mobile_no')),
							"city"          => 	clean_data($this->post('city')),
							"state"         => 	clean_data($this->post('state')),
							"country" 		=> 	$country['name'],
							"skype"         => 	clean_data($this->post('skype')),
							"icq"         	=> 	clean_data($this->post('icq')),
							"jabber"        => 	clean_data($this->post('jabber')),
							"vat_number"    =>  clean_data($this->post('european_vat')),
							"account_type"	=> 	"advertiser"		
							);			
			/* CHECK ADMIN EMAIL AND BCC EMAIL ARE SAME */				
			$bcc=($bcc!=$admin_email)?$bcc:'';
			$attachement = "";	
			$content = "<b>first_name :</b>".clean_data($this->post('first_name'))."<br><b>last_name :</b>".clean_data($this->post('last_name'))."<br><b>gender: </b> ".$gender."<br><b>dob: </b>".$date_format."<br><b>mobile_number: </b>".clean_data($this->post('mobile_no'))."<br><b>city: </b>".clean_data($this->post('city'))."<br><b>state: </b>".clean_data($this->post('state'))."<br><b>country:</b>".$country['name']."<br><b>skype: </b>".clean_data($this->post('skype'))."<br><b>icq : </b>".clean_data($this->post('icq'))."<br><b>jabber :</b>".clean_data($this->post('jabber'))."<br><b>Europen VAT :</b>".clean_data($this->post('european_vat'));
					
			//$this->response($content,200);
					/********message****/
			
			$account_type	=	$this->user_authentication->account_type;
		
			$network_id	=	$this->do_message->fetch_admin_network_id();
		
			$message  = $this->default_configurations->get('message_type');		
				
			
			
			$message_data		=	array(
											'sender_id'		=>	ADMIN_ID,
											'receiver_id'	=>	$account_id,
											'subject'		=>	'Advertiser - Personal Information updated',
											'content'		=>	$content,
											'image_name'	=>	NULL,
											'file_name'		=>	NULL,
											'account_type'	=>	"advertiser",
											'status'		=>	'1',
											'network_id'	=>	$network_id,	
											'notification_type'	=>	"setting_information",									
											'date'			=>	date('Y-m-d H:i:s')
											);
			
			
			
			
			
			
			
			
		    
		    if($msg_type=='email')
			{
				/* CALL HELPHER FILE */
				send_mail($type,$from,$to,$mail_content,$attachement,$bcc);	
			}
			else if($msg_type=='msg')
			{
				$this->db->insert(TAB_MESSAGES,$message_data);
			
			}
			else if($msg_type=='both')
			{
				$this->db->insert(TAB_MESSAGES,$message_data);
			
				send_mail($type,$from,$to,$mail_content,$attachement,$bcc);	
				
			}
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('advertiser/settings/personal_information'),
							'msg'	 => 'Personal Information are updated successfully!..'
							);
		
						
			$this->response($success, 200);
		}

	}
	
	
	/*
	 * 
	 * name: Security_information_add
	 * @param : null
	 * @return : response Array
	 * 
	 * Add/update the Security Account Information for Particular Advertiser
	 */
	
    public function security_option_add_post()
    {		
		$this->form_validation->set_rules('security_name[]','Security Name','trim|required');
		$this->form_validation->set_rules('security_option[]', 'Security Option', 'trim|required');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();			

			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{	
			
			$account_id = $this->user_authentication->account_id;
			$security_name=$this->post('security_name');
			$security_option=$this->post('security_option'); 
			$mobile_no=$this->post('mobile_no');
			$email=$this->post('email');
			$question_id=$this->post('security_question');
			$security_answer=$this->post('security_answer');
			
			foreach($security_name as $secure_name){
					$secure_names.= $secure_name.',';
			}
			foreach($security_option as $secure_option){
					$secure_options.= $secure_option.',';
			}					
			$update_security_infoObj=array(											
										"security"  	=>	rtrim($secure_names, ','),
										"token_type"	=>	rtrim($secure_options, ','),
										"mobile_no"     	=> 	$mobile_no,
										"email"				=>	$email,
										"question_id" 		=>  $question_id,
										"security_answer"	=>  $security_answer,
										);											
				//$this->response($update_security_infoObj, 200);			
		    $this->do_advertiser->security_add($account_id,$update_security_infoObj);
		    
		    /* Activity Log for Security information - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,SECURTIY);
				if($enable=='1')
				{							
				$this->activity_log(SECURTIY,EDIT);
				}
			/* Activity Log for Security information - End*/	       	    		
			
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('advertiser/settings/security'),
							'msg'	 => 'Security are updated successfully!..'
							);
		
						
			$this->response($success, 200);
		}

	}
	
	
	public function security_get()
	 {	
		$account_id = $this->user_authentication->account_id;

		$user_info=$this->do_advertiser->get_security($account_id);	  
		 
		 if($user_info)
		 {
			 $this->response($user_info, 200); // 200 being the HTTP response code
		 }
		
	 }
	 
	public function sms_option_get()
	 {	
		$account_id = $this->user_authentication->account_id;

		$sms_info=$this->do_advertiser->app_config_notification();	  
		 
		 if($sms_info)
		 {
			 $this->response($sms_info, 200); // 200 being the HTTP response code
		 }
		
	 }
	 
	 public function security_question_get()
	 {	
		 $account_id = $this->user_authentication->account_id;
		 $security_question=$this->do_advertiser->get_security_question($account_id);		 
		 if($security_question)
		 {
			 $this->response($security_question, 200); // 200 being the HTTP response code
		 }
		
	 }
	 
	 public function add_security_get()
	 {
		 $account_id = $this->user_authentication->account_id;
		 $question=$this->get('add_additional_question');		 
		 $security_question=$this->do_advertiser->add_question($account_id,$question);	  
		 
		 if($question)
		 {			 
			 $success = array(
							'response' => 'ok',
							'redirect'=>site_url('advertiser/settings/security'),
							'msg'	 => 'Additional Question are added successfully!..'
			);
			 
			 $this->response($success, 200); // 200 being the HTTP response code
		 }
		 
	 }
	
	
		 
	/*
	 * 
	 * name: account_settings_add
	 * @param :null
	 * @return : response Array
	 * 
	 * Add/update the Account Setting Information for Particular Advertiser
	 */
	
    public function account_settings_add_post(){		
		
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|callback_acc_email_check');
		//$this->form_validation->set_rules('another_email','Another Email','trim|required|valid_email');
		//$this->form_validation->set_rules('currency_to_view', 'Currency', 'trim|required');
		$this->form_validation->set_rules('password', 'New password', 'trim|matches[conf_password]');
		$this->form_validation->set_rules('conf_password', 'Repeat password', 'trim|matches[password]');
		
		if($this->form_validation->run() === FALSE)
		{
			$error_msg = $this->form_validation->error_array();		
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else{	
			
			$account_id = $this->user_authentication->account_id;
			$client_id 		=	$this->user_authentication->client_id;
			$msg_type  = $this->default_configurations->get('message_type');	
			$account_setting_type="account";				
			 //GET ADVERTISER CURRENT PASSWORD
			$db_old_pass=$this->do_publisher->get_current_pass($account_id);	
			$current_password=trim($this->post('current_password'));
			if(md5($current_password)==$db_old_pass || $current_password=='')
			{				
			$update_setting_infoObj=array(
										
										"email"  =>	clean_data($this->post('email')),
										"alternate_email"	=>	clean_data($this->post('another_email')),
										"currency" 	=>	$this->post('currency_to_view'),
										"password"=>clean_data($this->post('password')),
										"email_updated"=>date("Y-m-d H:i:s")
																	
								);	
								
		    $this->do_advertiser->update($account_id,$update_setting_infoObj,$account_setting_type);
		    $enable_twofactor = clean_data($this->post('enable_twofactor'));
		    
		    if($enable_twofactor){
				$security_enable = 1; 	
			}
			else{
				$security_enable = 0; 
			}
					$security_info = array(
					"security_enable"=>$security_enable,
					
					);
				$this->do_app_config->update_security_info($account_id,$security_info);
		    /* Activity Log for Account settings - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,ACC_SETTINGS);
				if($enable=='1')
				{							
				$this->activity_log(ACC_SETTINGS,EDIT);
				}
			/* Activity Log for Account Settings - End*/	
			
			
		    //SEND EMAIL TO ADVERTISERS -ACCOUNT SETTINGS
		   
		    /* GET AGENCY ID FROM LIBRARY */
		    $agency_id	=	$this->user_authentication->agency_id;
			
			/* GET DEFAULT MANAGER EMAIL ID */
			$result=$this->do_networks->agency_owner_details($agency_id);
			$admin_name    = $result['name'];			
			$admin_email   = $result['email'];		
			
			/* GET ADMIN EMAIL ID FOR bcc */
			$network_admin=$this->do_networks->get_network_details();
			$bcc		   = $network_admin['email'];

			/* ADVERTISER DETAILS */
			$adv_result_array  =  $this->do_advertiser->get_user_information($account_id);
			$adv_result		   =  $adv_result_array[0];
			$user_name  	   =  $adv_result['clientname'];
			$user_email		   =  clean_data($this->post('email'));
			
			if($this->post('password')!=''){
			    //IF password changed
				$type   ="ADV_CHANGE_PASSWORD";
			}
			else
			{   
			    $type   ="SETTING_INFORMATION";
			}
			$from 	=  $admin_email;
			$to  	=  $user_email;
			if($this->post('password')=='')
			{
				//Send only email,alternate email to their email
				$mail_content=array(
								"subject" 		=> "Advertiser - Account Settings Information",
								"to_name" 		=> $user_name,				
								"from_name"		=> $admin_name,							
								"email"   		=> clean_data($this->post('email')),
								"alternate_email" => clean_data($this->post('another_email')),
								"account_type"	=> "advertiser"		
								);
				
				$content = "<b>email :</b>".clean_data($this->post('email'))."<br><b>alternate_email :</b>". clean_data($this->post('another_email'))."<br><b>account_type: </b>advertiser";
						
								
								
			 }
			else
			 {
				//Send all account setting informations if password is changed
				$mail_content=array(
						"subject" 		=> "Advertiser - Change Password",
						"to_name" 		=> $user_name,				
						"from_name"		=> $admin_name,							
						"email"   		=> clean_data($this->post('email')),
						"password"		=> clean_data($this->post('password'))							
						);	
						
				$content = "<b>email :</b>".clean_data($this->post('email'))."<br><b>password :</b>". clean_data($this->post('password'))."<br><b>account_type: </b>advertiser";
					
						
			 }	
			 
			$db = 'select * from djax_adv_pub_notification_settings where account_id='.$account_id;
			$jb = $this->db->query($db);
			$djax_adv_pub = $jb->result_array();
			//return $djax_adv_pub;
			$enable_disable = $djax_adv_pub[0]['msg_adv_pub_enable'];
			
			$admin_set = $this->default_configurations->get('adv_pub_msg');
			
			if($admin_set =='enable')
			{
				
			if($enable_disable)
			{
				$string = 'account_set';
				
				
				if(strpos($djax_adv_pub[0]['account_settings'],$string)!== false)
				{
					
					 
					
					$msg_type = $djax_adv_pub[0]['msg_type'];
				}
				else{
					$msg_type = null;
				}
			  
			}
			else{
				
				$msg_type = null;
			}
		}
			 
			//$this->response($msg_type,200);
					/********message****/
			
			$account_type	=	$this->user_authentication->account_type;
		
			$network_id	=	$this->do_message->fetch_admin_network_id();
		
			$message  = $this->default_configurations->get('message_type');		
				
			
			$message_data		=	array(
											'sender_id'		=>	ADMIN_ID,
											'receiver_id'	=>	$account_id,
											'subject'		=>	'Advertiser - Account Information updated',
											'content'		=>	$content,
											'image_name'	=>	NULL,
											'file_name'		=>	NULL,
											'account_type'	=>	"advertiser",
											'status'		=>	'1',
											'network_id'	=>	$network_id,
											'notification_type'	=>	"setting_information",									
											'date'			=>	date('Y-m-d H:i:s')
											);
			
					
			/* CALL HELPHER FILE */
			  if($msg_type=='email')
			{
				send_mail($type,$from,$to,$mail_content,$attachement,$bcc);	
			}
			else if($msg_type=='msg')
			{
				
				$this->db->insert(TAB_MESSAGES,$message_data);
			
			}
			else if($msg_type=='both')
			{
				$this->db->insert(TAB_MESSAGES,$message_data);
			
				send_mail($type,$from,$to,$mail_content,$attachement,$bcc);	
				
			}		
					
				
			/* CHECK ADMIN EMAIL AND BCC EMAIL ARE SAME */				
			 $bcc=($bcc!=$admin_email)?$bcc:'';
			    
			 $attachement = "";		
					
			/* CALL HELPHER FILE */
			
			$success = array(
							'response' => 'ok',
							'redirect'=>site_url('advertiser/settings/account_settings'),
							'msg'	 => 'Account Settings Information are updated successfully!..'
			);
		
						
			$this->response($success, 200);
		}
		else
		  { 
		       $success = array(
								'response' => 'error',
								'redirect'=>site_url('advertiser/settings/account_settings'),
								'msg'	 => 'Your old password mismatch!..'
				);
			  
			    $this->response($success, 200);
		  }
	 }
 }
 
 
	function admin_enable_get()
	{
		$setting_enable = $this->default_configurations->get('adv_pub_msg');
		
		$this->response($setting_enable);
		
	}
 
 
	function notification_information_get()
	{
		
		$account_id 	= 	$this->user_authentication->account_id;
		
		$notify_list 	= 	$this->do_advertiser->fetch_notification($account_id);
		
		if($notify_list)
		{
			$this->response($notify_list,200);
		}
		else
		{
			$this->response('error',200);
		}
		
		
	}
	
	function fetch_adgate_news_get()
	{
		
		$account_id 	= 	$this->user_authentication->account_id;
		
		$notify_list 	= 	$this->do_advertiser->fetch_adgate_news($account_id);
		
		if($notify_list)
		{
			$this->response($notify_list,200);
		}
		else
		{
			$this->response('error',200);
		}
		
		
	}
	
 
 
 
 
 
 /*
	 * 
	 * name: Message_settings_add
	 * @param :null
	 * @return : response Array
	 * 
	 * Add/update the Message Setting Information for Particular Advertiser
	 */
	
    public function message_settings_add_post(){	

				//$this->response('dfwerrgh',200);
			 //echo "post<pre>";print_r($_POST);die;
			 $enable_notification = $this->input->post('enable_notification');
			 $user_auth  	= 	$this->user_authentication;
			 $account_id 	= 	$user_auth->account_id;
			 $client_id 	= 	$user_auth->client_id;
			$account_type= $this->user_authentication->account_type;
			 $notification['account_id']= $account_id;
			 $notification['client_id']= $client_id;
			 $notification['account_type']= $account_type;
			  $enable_adgatenews = $this->input->post('enable_adgatenews');
			   $enable_specialoffer = $this->input->post('enable_specialoffer');
			   // $enable_security = $this->input->post('enable_security');
			    if($enable_adgatenews){$adgatenews=1;}
			    if($enable_specialoffer){$specialoffer=1;}
			   // if($enable_security){$security=1;}
			// $this->response($this->input->post('campaign_tracking'),200); 	
			if($enable_notification)
			{
				
				$notification['msg_adv_pub_enable']= 1;
				
				$notification['msg_type']= $this->input->post('message_type');
				$notification['campaign_tracking']= $this->post('campaign_tracking');
				$notification['conversion_limit']= $this->input->post('conversion_limit');
				$notification['impression_limit']= $this->input->post('impression_limit');
				$notification['budget_limit']= $this->input->post('budget_limit');
				$notification['threshold_limit']= $this->input->post('threshold_limit');
				$notification['checked_value']= $this->input->post('check_val');
				$notification['paymnt_value']= $this->input->post('paymnt_val');
				$notification['acct_value']= $this->input->post('acct_val');
				$notification['network_settings']= $this->input->post('network_set');
				$notification['Favourite_campaign']= 0;
				$notification['mute_campaign']= 0;
				$notification['highlight_zone']= 0;
				$notification['admarket_status']= 0;  
				$notification['adgate_news']= $adgatenews;
				$notification['special_offer']= $specialoffer;
				//$notification['security_messages']= $security;
				$notification['login_secure']= $this->input->post('login_secure');
				$ret = $this->do_message->update_notification_settings($notification);
				
			}
			else{
				$notification['msg_type']= '';
				$notification['campaign_tracking']= '';
				$notification['conversion_limit']= '';
				$notification['impression_limit']= '';
				$notification['budget_limit']= '';
				$notification['threshold_limit']= '';
				$notification['checked_value']= '';
				$notification['paymnt_value']= '';
				$notification['acct_value']= '';
				$notification['msg_adv_pub_enable']='';
				$notification['network_settings']='';
				$notification['adgate_news']=$adgatenews;//'';
				$notification['special_offer']= '';
				//$notification['security_messages']= '';
				$notification['login_secure']='';
				$notification['Favourite_campaign']= 0;
				$notification['mute_campaign']= 0;
				$notification['highlight_zone']= 0;
				$notification['admarket_status']= 0;
				//echo "notification<pre>";print_r($notification);die;
				$ret = $this->do_message->update_notification_settings($notification);
				//$this->response(print_r($ret).'sdfdsf',200); 
			}
			
			
			/* Activity Log for Notification settings information - Start*/	
				$enable	=  	$this->default_configurations->activity_log_setting(ACCOUNT_SETTINGS,NOTIFICATION_SETTINGS);
				if($enable=='1')
				{							
				$this->activity_log(NOTIFICATION_SETTINGS,EDIT);
				}
			/* Activity Log for Notification settings information - End*/	   
		     
			
			
			
			if($ret)
			{
			$success = array(
					'response' => 'ok',
					'msg'	 => $ret//'Notification Settings Information are updated successfully!..'
					); 
					
					$this->response($success,200);
			}
			else{
			$error = array(
					'response' => 'ok',
					'msg'	 => 'Error! PLease try again later!!'
					);
					
					$this->response($success,200); 
			}
			
	}
 
 
 
 
    public function test_add_post(){	 

				$this->response('dfw123errgh',200);
				
			
		}
 
	
	/*
	 * 
	 * name: upload_profile_image
	 * @param : null
	 * @return:response array
	 * 
	 * Upload the selected image
	 * 
	 */
	
	public function upload_profile_image_post()
	{
		$account_id=clean_data($this->post('account_id'));
		
		if($_FILES['profile_image'])
		{
			$profile_image=array(
					'file_name'   => $_FILES['profile_image']['name'],
					'source_name' => $_FILES['profile_image']['tmp_name'] 				 				
					);
		}
	
		$data=$this->image_lib->update_profile_image($profile_image);			
		
		$this->do_advertiser->update_image_information($account_id,$data['upload_data']['file_name']);
		 
		 $success = array(
							'response' => 'ok',
							'msg'	 => 'Profile Image updated successfully!..'
			);
			
			$this->response($success, 200);
		
	}
	
	/*
	 * 
	 * name: delete_profile_image
	 * @param : null
	 * @return :response array
	 * 
	 * Delete the image in user profile
	 */
	
	public function delete_profile_image_post()
	{
		#$account_id=$this->post('account_id');			
		 $user_auth  	= 	$this->user_authentication;
		 $account_id 	= 	$user_auth->account_id;		
		 $profile_name=$this->do_advertiser->get_user_information($account_id);
		 $delete_profile_name=$profile_name[0]['dj_profile_image'];
		 
				
		if($delete_profile_name)
		{
			$is_delete_profile=$this->image_lib->delete_profile_image($delete_profile_name);
			
			/* Delete Profile name in Database */			
			$this->do_advertiser->delete_profile_name($account_id);

			if($is_delete_profile)
			{
				$success = array(
							'response' => 'success',
							'msg'	 => 'Profile image deleted'
							);
				$this->response($success, 200);
			}
			else
			{
				$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the Profile Image'
							);
				$this->response($error, 200);
			}
		}
		else
		{
			$error = array(
							'response' => 'error',
							'msg'	 => 'Unable to delete the Profile Image'
							);
			$this->response($error, 200);
		}
	}
	
	/*
	 * 
	 * name: email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	
	public function email_check()
	{
		$email		=	clean_data($this->post('email_id'));
		
		$account_id		=	clean_data($this->post('account_id'));
		
		$count		=	$this->do_email_check->dup_email_check($email,$account_id);		
			   
		if($count>0 )
		{
			$this->form_validation->set_message('email_check', "This Email address already Exists");
			return FALSE;	
		}
		else
		{
			return true;
		}
	}	
	
	/*
	 * 
	 * name: edit_email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	public function edit_email_check()
	{
		$account_id	=	clean_data($this->post('account_id'));
		$email		=	clean_data($this->post('email_id'));
		$count 		= 	$this->do_email_check->dup_email_check($email,$account_id);
		
		if($count>0)
		{
			$this->form_validation->set_message('edit_email_check', "This Email address already Exists");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	
	/*
	 * 
	 * name: account_email_check
	 * @param : null
	 * @return : Email Count 
	 * 
	 * checked the email count
	 */
	
	public function acc_email_check()
	{

		$account_id	=	clean_data($this->post('account_id'));
		$email		=	clean_data($this->post('email'));
		$count 		= 	$this->do_email_check->dup_email_check($account_id,$email);

		if($count>0)
		{
			$this->form_validation->set_message('acc_email_check', "This Email address already Exists");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	/**
       * 
       * name : current_balance_post()
       * 
       * block the advertiser information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	public function current_balance_post()
	{	
		$account_id 	= 	clean_data($this->post('account_id'));	
		
		$account_type 	= 	clean_data($this->post('account_type'));	
		
		$balance 		= 	$this->do_advertiser->fetch_current_balance($account_id);
			
		if($balance)
		{
			$success 	= 	array('response'	=> 	'ok',
								  'msg'			=> 	$balance
								);
			
			$this->response( $success, 200);
		}
		else
		{			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	''
								);
			
			$this->response( $error, 200);
		}			
		
	}
	
	function check()
	{
		$t=clean_data($this->input->post('city'));
		if( ! preg_match("/^([-a-z_ ])+$/i", $t))
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
		
	}
	
	function state()
	{
		$s=clean_data($this->input->post('state'));
		if( ! preg_match("/^([-a-z_ ])+$/i", $s))
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
		
	}
	
	function company_test()
	{
		$tt=clean_data($this->input->post('company_city'));
		print_r($tt);exit;
		if(  !preg_match("/^([-a-z_ ])+$/i", $tt))
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
		
	}
	
	function company_check()
	{
		$ss=clean_data($this->input->post('company_state'));
		if( !preg_match("/^([-a-z_ ])+$/i", $ss))
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
		
	}
	
	
	/**
       * 
       * name : delete_activity_log_get()
       * 
       * deletes the advertiser information
       * 
       * @return boolean (or) string Returns the object on TRUE (or) FALSE
    */
	
	
	function delete_activity_log_get()
	{	
		$log_id = $this->get('log_id');	
		
		$arrays	=	explode(',',$log_id);
		   if(is_array($arrays))
			{  
				foreach($arrays as $logs_id)
				{
					 $results= $this->del_activity_log(clean_data($logs_id));
				}
					
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Advertiser has been deleted successfully..'
										);
					
					$this->response( $success, 200);
			}
			else
			{
				$results= $this->del_activity_log(clean_data($log_id));
				
				$success 	= 	array('response'	=> 	'ok',
										  'msg'			=> 	'Advertiser has been deleted successfully..'
										);
					
				$this->response( $success, 200);
			}
	}
	
	function del_activity_log($log_id)
	{
		if($log_id)
		{
			//$advertiser_details = 	$this->do_advertiser->get_profile($account_id);
			$log = 	$this->do_networks->delete_activity_log($log_id);
			
			if($log)
			{   
			   /* $success 		= 	array(
								'response' 	=> 	'ok',
								'msg'	 	=> 	'deleted'
								);
			
				$this->response( $success, 200);*/	
			}
			else
			{
				$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'Error..Please Try again.'
								);
			
				$this->response( $error, 200);
			}
		}
		else
		{
			
			$error 		= 	array(
								'response' 	=> 	'error',
								'msg'	 	=> 	'log does not found.'
								);
			
			$this->response( $error, 200);
		}
	}	
	
	function activity_log($module,$process,$advertiser_id=false)
	{
				/* Activity Log for EDIT setting information - Start*/				
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");							
				$account_id=$this->user_authentication->account_id;
				if($advertiser_id)
				{
					$advertiser_id=$advertiser_id;
				}
				else
				{
				$advertiser_id = $this->user_authentication->client_id;
				}	
				$module=$module;
				$process=$process;				
								
				$activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$user_agent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,
				"module"=>$module,
				"process"=>$process,
				"advertiser_id"=>$advertiser_id,
				"campaign_id"=>'',
				"banner_id"=>'',
				"publisher_id"=>'',
				"site_id"=>'',
				"app_id"=>'',
				"adblock_id"=>'');				
					
				$this->redis_library->logcount($account_id,$activity_log);
				/* Activity Log for edit settings information - End*/			
		
	}
	
	public function  advertiser_mass_import_post()
	{
		
		
		$file_id=$this->post('upload_name');	
		$admarket = $this->post('admarket'); // val is 1 admarket val is 0 normal campaign import
		if($file_id!='')
		{
			$upload_extension = explode(".", $file_id);		
			
			if($upload_extension[1]=='csv')
			{
				
					$csvfilepath 	= $this->config->item('read_csv');	
					
					$file_name		= $this->getLatestFile($csvfilepath);
						
						$data = $this->csvreader->parse_file($file_name);
						

					
					$counter		= '1';	
					$ext_counter=1;
					$insert_rec=array();
					$exist_rec=array();
					$num_rows=count($data);	
						
					if($num_rows>0)
					{
						foreach($data as $row)
						{
							$account_id		=	get_session('account_id');
							
							if($row['agencyid']!='' && $row['email']!='' )
							{
								$account_type			= 'ADVERTISER';
							    $clientname				= trim($row['clientname']);							 

								
							$add_data	=	array(
									'first_name'	=>	trim($row['first_name']),
									'last_name'	=>	trim($row['last_name']),
									'email'			=>	trim($row['email']),
									'password'		=>	trim($row['password']),
									'budget'		=>	trim($row['budget']),
									'mob_no'		=>	trim($row['contact']),
									'skype_id'		=>	trim($row['skype_id']),
									'additional_info'=>	trim($row['additional_info']),
									'account_type'	=>	'ADVERTISER',
									'created_date'	=>	date('Y-m-d H:i:s'),
									'security_id' => trim($row['security_question_id']),
									'security_answer'=>trim($row['security_answer']) 
									);	
									
									//~ if ($add_data)
									//~ {
									//~ //	$advertiser_add = 	$this->do_advertiser->add($add_data,$account_id);
									//~ }
									  	
							 
										
							
								if(!empty($add_data))
								{
											
									$result[]=$this->do_advertiser->add($add_data,$account_id);
								
										
										$insert_rec[] =$counter;
										
								}
								else
								{
										$exist_rec[]=$ext_counter;
								}
						$counter++;	
						$ext_counter++;						
						
					}
					else
					{
						$error = array('response'	=> 'error',
												// 'msg'		=> 'required fields are empty',
												// 'error_msg'=> $ex_count.' uploaded file(s) are already Exists !' 
												'msg'	 => 'The file contains invalid data for this operation..'
												 ); 
								$this->response($error,200);
					}
					
					}
						if(count($insert_rec)>0 && count($exist_rec) >0)
						{
								$ins_count = count($insert_rec);
								$ex_count= count($exist_rec);
								$success = array('response'	=> 'ok_error',
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												 'error_msg'=> $ex_count.' uploaded file(s) are already Exists !' ,
												  'id'		=>	$result
												 ); 
								$this->response($success,200);
						}
						else if(count($insert_rec)>0 && count($exist_rec)<=0)
						{
							
								$ins_count = count($insert_rec);
								$success = array('response'	=> 'ok',
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												 'id'		=>	$result
												 ); 
								$this->response($success,200);
						}
						else if(count($exist_rec) >0&& count($insert_rec)<=0)
						{
								$ex_count= count($exist_rec);
									$error = array(
										   'response' => 'error',
										   'msg' =>  $ex_count.' uploaded file(s) are already Exists ! '
										  );
									$this->response( $error, 200);
						}
					}
					else
					{
						$error = array(
									'response' => 'error',
									'redirect'=>site_url('advertiser/campaigns/'),
									'msg'	 => 'There is no data in the file!..'
									);
				  
						$this->response($error, 200);	
					}														
			}
			else
			{
				$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV file to upload!..'
							);
	  
				$this->response($error, 200);	
					
			}		
		}
		else
		{
			$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV file to upload!..'
						);
	  
			$this->response($error, 200);
		}		
		
						
	
		
	}
	function getLatestFile($directoryPath)
	{
		$directoryPath = rtrim($directoryPath, '/');
	
		$max = array('path' => null, 'timestamp' => 0);	
		
		foreach (scandir($directoryPath, SCANDIR_SORT_NONE) as $file)
		{
			$path = $directoryPath . '/' . $file;
			if (!is_file($path)) {	
				continue;
			}
			$timestamp = filemtime($path);		
			if ($timestamp > $max['timestamp']) {
				$max['path'] = $path;
				$max['timestamp'] = $timestamp;
			}
		}	
		
    return $max['path'];
	}
}
