<?php defined('BASEPATH') OR exit('No direct script access allowed');  
class Admarket extends REST_Controller
{		
	function __construct()
	{  
		parent::__construct();		 
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');	 
		$this->load->library('user_authentication'); 
		$this->load->model('do_admarket'); 
	    $key		=	$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key); 
        $user_auth  = 	$this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);  
	    }		   		
	}
		
	function fetch_all_publisher_list_get()
	{ 
		$user_auth  	= 	$this->user_authentication;  
		$account_id		=	$user_auth->account_id;	
		$filter			=	clean_data($this->get('filter'));
		$start_date		=	clean_data($this->get('from_date'));
		$end_date		=	clean_data($this->get('to_date'));
		
		$publisher = 	$this->do_admarket->fetch_allpublisher_list($filter,$start_date,$end_date);  
						
		if($publisher)
		{			
			$this->response($publisher,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	
	
	
	function fetch_publisher_list_get()
	{  
	
		$user_auth  	= 	$this->user_authentication;
		$account_id		=	$user_auth->account_id;	
		$filter			=	clean_data($this->get('filter'));
		$start_date		=	clean_data($this->get('from_date'));
		$end_date		=	clean_data($this->get('to_date'));
		$admarket		=	clean_data($this->get('admarket'));
		$publisher = 	$this->do_admarket->fetch_publisher_list($account_id,$filter,$start_date,$end_date,$admarket);  
		
		if($publisher)
		{			
			$this->response($publisher,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	
	function block_user_get()
	{
	  $user_auth  	= 	$this->user_authentication;
	  $account_id	=	$user_auth->account_id;					
	  $aff_id		=	$this->get('id');
	  $arrays		=	explode(',',$aff_id);
	  
	  if($aff_id)
      { 
  		if(count($arrays))
		{  
			//$this->response('one', 200);
		foreach($arrays as $pub_id)
		{
			 $results= $this->block_user($pub_id,$account_id);
     	}
 	    $success = array('response'	=> 'ok','msg'=> 'This Publisher is Blocked successfully');
 	     $this->response( $success, 200);	
		}

		else
		{  
           
		$results= $this->block_user($aff_id,$account_id);
		$success = array('response'	=> 'ok','msg'=> 'This Publisher is Blocked successfully');
		$this->response( $success, 200);
		} 
      }
	  else
	  {		
			$error = array(
							'response' => 'error',
							'msg'	 => 'Publisher is not found'  
					);
			$this->response( $error, 200);
	  }

	}

	function block_user($aff_id,$account_id)
	{		
		if($aff_id)
		{
			$block_user = $this->do_admarket->block_user($aff_id,$account_id);	
		}
	}
	
	function unblock_user_get()
	{		
	  $user_auth  	= 	$this->user_authentication;
	  $account_id	=	$user_auth->account_id;					
	  $aff_id		=	$this->get('id');  
	  $arrays=	explode(',',$aff_id);
	  if($aff_id)
      { 
  		if(count($arrays)>1)
		{  
		foreach($arrays as $pub_id)
		{
			 $results= $this->unblock_user($pub_id,$account_id);
     	}
 	    $success = array('response'	=> 'ok','msg'=> 'This Publisher is Un-Blocked successfully');
		$this->response( $success, 200);	
		}
		else
		{  
		$results= $this->unblock_user($aff_id,$account_id);
		$success = array('response'	=> 'ok','msg'=> 'This Publisher is Un-Blocked successfully');
		$this->response( $success, 200);
		}
      }
	  else
	  {		
			$error = array(
							'response' => 'error',
							'msg'	 => 'Publisher is not found'  
					);
			$this->response( $error, 200);
	  }

	}
	
	function unblock_user($aff_id,$account_id)
	{
		if($aff_id)
		{
			$block_user = $this->do_admarket->unblock_user($aff_id,$account_id);	
		}
	}
	
	function fetch_denied_publisher_list_get()
	{ 
		$user_auth  	= 	$this->user_authentication;
		$account_id		=	$user_auth->account_id;	
		$filter			=	clean_data($this->get('filter'));
		$start_date		=	clean_data($this->get('from_date'));
		$end_date		=	clean_data($this->get('to_date'));
			
			
		$publisher = 	$this->do_admarket->fetch_denied_publisher_list($account_id,$filter,$start_date,$end_date);  
					
		if($publisher)
		{			
			$this->response($publisher,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);  
		}
	}
	
	function description_post()
	{
		$html_content= $this->input->post('html_content');
		$html_descr= $this->input->post('html_descr');
		$heading= $this->input->post('heading');
		$user_auth  	= 	$this->user_authentication;
		$account_id		=	$user_auth->account_id;	
		$add_description  = $this->do_admarket->description_data($account_id,$html_content,$html_descr,$heading);
		if($add_description)
		{		
			$success = array(
				'response' => 'ok',
				'redirect'=>site_url('advertiser/admarket/description'),
				'msg'	 => 'Description has been updated successfully!..'
			);
			$this->response($success, 200); 
		}
		else
		{
			$error = array(
				'response' => 'error',
				'redirect'=>site_url('advertiser/admarket/description'),
				'msg'	 => 'Error! Try again..'
			);
			$this->response($error, 200); 
		}
	}
	function admarket_description_post()
	{
		$user_auth  	= 	$this->user_authentication;
		$account_id		=	$user_auth->account_id;	
		 
		 
		$get_description  = $this->do_admarket->fetch_description_data($account_id);
		 
		$this->response($get_description, 200); 
		 
	}
}
