<?php defined('BASEPATH') OR exit('No direct script access allowed');  
class Admarket extends REST_Controller
{		
	function __construct()
	{  
		parent::__construct();		 
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');	 
		$this->load->library('user_authentication'); 
		$this->load->model('do_admarket'); 
	    $key		=	$this->input->get_post('api_key'); 
        $this->user_authentication->is_valid_apikey($key); 
        $user_auth  = 	$this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);  
	    }		   		
	}
		 
	function fetch_all_publisher_list_get()
	{ 
		$user_auth  	= 	$this->user_authentication;  
		$account_id		=	$user_auth->account_id;	
		$filter			=	clean_data($this->get('filter'));
		$start_date		=	clean_data($this->get('from_date'));
		$end_date		=	clean_data($this->get('to_date'));
		
		$publisher = 	$this->do_admarket->fetch_allpublisher_list($filter,$start_date,$end_date);  
						
		if($publisher)
		{			
			$this->response($publisher,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	
	function fetch_admarketlist_get()
	{
		$user_auth  	= 	$this->user_authentication;  
		$account_id		=	$user_auth->account_id;	
		$adblock_list 	= 	$this->do_admarket->fetch_admarket_adblock_list($account_id);  
						
		if($adblock_list)
		{			
			$this->response($adblock_list,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	
	function fetch_publisher_list_get()
	{  
	
		$user_auth  	= 	$this->user_authentication;
		$account_id		=	$user_auth->account_id;	
		$filter			=	clean_data($this->get('filter'));
		$start_date		=	clean_data($this->get('from_date'));
		$end_date		=	clean_data($this->get('to_date'));
		$admarket		=	clean_data($this->get('admarket'));
		$publisher = 	$this->do_admarket->fetch_publisher_list($account_id,$filter,$start_date,$end_date,$admarket);  
		
		if($publisher)
		{			
			$this->response($publisher,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);
		}
	}
	
	function block_user_get()
	{
	  $user_auth  	= 	$this->user_authentication;
	  $account_id	=	$user_auth->account_id;					
	  $aff_id		=	$this->get('id');
	  $arrays		=	explode(',',$aff_id);
	  
	  if($aff_id)
      { 
  		if(count($arrays))
		{  
			//$this->response('one', 200);
		foreach($arrays as $pub_id)
		{
			 $results= $this->block_user($pub_id,$account_id);
     	}
 	    $success = array('response'	=> 'ok','msg'=> 'This Publisher is Blocked successfully');
 	     $this->response( $success, 200);	
		}

		else
		{  
           
		$results= $this->block_user($aff_id,$account_id);
		$success = array('response'	=> 'ok','msg'=> 'This Publisher is Blocked successfully');
		$this->response( $success, 200);
		} 
      }
	  else
	  {		
			$error = array(
							'response' => 'error',
							'msg'	 => 'Publisher is not found'  
					);
			$this->response( $error, 200);
	  }

	}

	function block_user($aff_id,$account_id)
	{		
		if($aff_id)
		{
			$block_user = $this->do_admarket->block_user($aff_id,$account_id);	
		}
	}
	
	function unblock_user_get()
	{		
	  $user_auth  	= 	$this->user_authentication;
	  $account_id	=	$user_auth->account_id;					
	  $aff_id		=	$this->get('id');  
	  $arrays=	explode(',',$aff_id);
	  if($aff_id)
      { 
  		if(count($arrays)>1)
		{  
		foreach($arrays as $pub_id)
		{
			 $results= $this->unblock_user($pub_id,$account_id);
     	}
 	    $success = array('response'	=> 'ok','msg'=> 'This Publisher is Un-Blocked successfully');
		$this->response( $success, 200);	
		}
		else
		{  
		$results= $this->unblock_user($aff_id,$account_id);
		$success = array('response'	=> 'ok','msg'=> 'This Publisher is Un-Blocked successfully');
		$this->response( $success, 200);
		}
      }
	  else
	  {		
			$error = array(
							'response' => 'error',
							'msg'	 => 'Publisher is not found'  
					);
			$this->response( $error, 200);
	  }

	}
	
	function unblock_user($aff_id,$account_id)
	{
		if($aff_id)
		{
			$block_user = $this->do_admarket->unblock_user($aff_id,$account_id);	
		}
	}
	
	function fetch_denied_publisher_list_get()
	{ 
		$user_auth  	= 	$this->user_authentication;
		$account_id		=	$user_auth->account_id;	
		$filter			=	clean_data($this->get('filter'));
		$start_date		=	clean_data($this->get('from_date'));
		$end_date		=	clean_data($this->get('to_date'));
			
			
		$publisher = 	$this->do_admarket->fetch_denied_publisher_list($account_id,$filter,$start_date,$end_date);  
					
		if($publisher)
		{			
			$this->response($publisher,200);
		}
		else
		{
			$this->response( array('response'=>'error'), 200);  
		}
	}
	
	function description_post()
	{
		$html_content= $this->input->post('html_content');
		$html_descr= $this->input->post('html_descr');
		$heading= $this->input->post('heading');
		$user_auth  	= 	$this->user_authentication;
		$account_id		=	$user_auth->account_id;	
		$add_description  = $this->do_admarket->description_data($account_id,$html_content,$html_descr,$heading);
		if($add_description)
		{		
			$success = array(
				'response' => 'ok',
				'redirect'=>site_url('advertiser/admarket/description'),
				'msg'	 => 'Description has been updated successfully!..'
			);
			$this->response($success, 200); 
		}
		else
		{
			$error = array(
				'response' => 'error',
				'redirect'=>site_url('advertiser/admarket/description'),
				'msg'	 => 'Error! Try again..'
			);
			$this->response($error, 200); 
		}
	}
	function admarket_description_post()
	{
		$user_auth  	= 	$this->user_authentication;
		$account_id		=	$user_auth->account_id;	
		 
		 
		$get_description  = $this->do_admarket->fetch_description_data($account_id);
		 
		$this->response($get_description, 200); 
		 
	}
	function link_advcamp_publisher_post()
	{
		
		$textarea=$this->post('textarea');
		$admarket_id=$this->post('admarket_id');
		$site_id	=$this->post('site_id');
		$textarea	=$this->post('textarea');
		$request	=$this->post('request');
		$subject	=$this->post('subject');
		$email		=$this->post('email');
		 
		$pub_account_id		= $this->user_authentication->account_id;  
		
		
		$pub_mail_id = $this->do_admarket->get_publisher_email($pub_account_id);
		
		
		
		
		$adv = $this->do_admarket->get_advertiser_acc_id($admarket_id);
		$adv_id = $adv[0]['account_id'];		
		/*Mail*/
		$adv_mail_id=$adv[0]['email'];
		//$adv_mail_id="renukadevi.s@djaxtech.com";
			
		$subject = $this->lang->line('pub_join_request');
		$content=$this->lang->line('site_name').":".$site_name."\r\n";
		$content.=$this->lang->line('site_url').":".$site_url."\r\n";
		$content.=$message."\r\n";
		$headers="From:".$pub_mail_id."\r\n";
		//$pub_mail_id="renukadevi.ciet@gmail.com";  
		
		$mail_send=mail($adv_mail_id,$subject,$content,$headers);
				
		/*Mail*/
		
		$array_send= array(
		'adv_id'=>$adv_id,
		'pub_id'=>$pub_account_id,
		'campaign_id'=>$admarket_id,
		'site_id'=>$site_id,
		'content'=>$textarea,
		'dj_request'=>$request,
		'dj_subject'=>$subject,
		'date'=>date("Y-m-d H:i:s"),
		
			
		);
		
		$send_request = $this->do_admarket->admarket_publisher_request($array_send);
	 
		if($send_request)
		{
			$success = array(
					'response' => 'ok',
					'redirect'=>site_url('publisher/campaigns'),
					'msg'	 => 'Request sent successfully'
			);
			
			
			$this->response($success, 200); 	
		}
		else
		{
			$error = array(
					'response' => 'ok',
					'redirect'=>site_url('publisher/campaigns'),
					'msg'	 => 'Request sending failed, try again..'
			);
			$this->response($error, 200); 	
		}
		
	}
	function mail_to_publisher_specific_campaign_post()
	{	
		$account_id		= $this->user_authentication->account_id;  
		$pub_mail_id 	= $this->post("publisher_mail_id");
		$site_name		= $this->post("site_name");
		$site_url       = $this->post("site_url"); 
		$message		= $this->post("mail_message"); 
		$site_id		= $this->post("site_id");			
		$campaign_id	= $this->post("campaign_id"); 		
		$adv_mail_id=$this->do_admarket->adv_mail($campaign_id);   		
		//$adv_mail_id="renukadevi.s@djaxtech.com";				
		$subject = $this->lang->line('pub_join_request');
		$content=$this->lang->line('site_name').":".$site_name."\r\n";
		$content.=$this->lang->line('site_url').":".$site_url."\r\n";
		$content.=$message."\r\n";
		$headers="From:".$adv_mail_id."\r\n";
		//$pub_mail_id="renukadevi.ciet@gmail.com";  
		
		$mail_send=mail($pub_mail_id,$subject,$content,$headers);
				
		$pub_acc_id=$this->do_admarket->get_publisher_accountid($site_id);		
		
		$this->do_admarket->linking($account_id,$pub_acc_id,$site_id,$campaign_id);
		
		if($mail_send)
		{
			$success = array(
					'response' => 'ok',
					'redirect'=>site_url('advertiser/admarket/publisher_list'),
					'msg'	 => 'Mail has been sent successfully!..'
			);
			$this->response($success, 200); 		
		}
		else
		{
			$error = array(
					'response' => 'error',
					'redirect'=>site_url('advertiser/admarket/publisher_list'),
					'msg'	 => 'Mail has not been sent to publishers!..'
			);
			$this->response($error, 200); 
		}
		
	}
	function admarket_update_linking_post()
	{
		$id = $this->post('id');
		$value = $this->post('update');
		$site_id = $this->post('site_id');
		$camp_id = $this->post('camp_id');
		
		$pub_account_id = $this->do_admarket->get_publisher_accountid($site_id);
		
		$pub_mail_id = $this->do_admarket->get_publisher_email($pub_account_id);
		
		$adv_account_id		= $this->user_authentication->account_id;  
		$adv = $this->do_admarket->get_advertiser_acc_id($camp_id);
		$adv_mail_id = $adv[0]['email'];		
		
		$msg = 'rejected';
		if($value == '1')
		{
			$msg = 'approved';
		}
		if($id && $value)
		{
			$return = $this->do_admarket->update_admarket_advpub($id,$value);
		}
		
		if($return)
		{
			/*Mail*/
					$adv_mail_id=$adv[0]['email'];
					//$adv_mail_id="renukadevi.s@djaxtech.com";
					
					$subject = $this->lang->line('pub_join_request').' '.$msg;
					$content=$this->lang->line('site_name').":".$site_name."\r\n";
					$content.=$this->lang->line('site_url').":".$site_url."\r\n";
					$content.=$message."\r\n";
					$headers="From:".$adv_mail_id."\r\n";
					//$pub_mail_id="renukadevi.ciet@gmail.com";  
					
					$mail_send=mail($pub_mail_id,$subject,$content,$headers);
				
			/*Mail*/
		
			$success = array(
				'response'=>'ok',
				'msg'=>'Admarket has been '.$msg.' successfully'
			);
			$this->response($success, 200); 
		}
		else
		{
			$error = array( 
				'response'=>'error',
				'msg'=>'Kindly try again'
			);
			$this->response($error, 200); 
		}		
	}
	function error_mail_reply_post()
	{
		
		
		$account_id		= $this->user_authentication->account_id;  
		$pub_mail_id 	= $this->post("publisher_mail_id");
		$message		= $this->post("mail_message"); 
		$site_id		= $this->post("site_id");			
		$campaign_id	= $this->post("campaign_id"); 		
		$id	= $this->post("row_id"); 		
		$adv_mail_id=$this->do_admarket->adv_mail($campaign_id);   		
		//$adv_mail_id="renukadevi.s@djaxtech.com";
				
		$subject = 'Material error fixed reply'; //$this->lang->line('pub_join_request');
		//~ $content=$this->lang->line('site_name').":".$site_name."\r\n";
		//~ $content.=$this->lang->line('site_url').":".$site_url."\r\n";
		//~ $content.=$message."\r\n";
		$headers="From:".$adv_mail_id."\r\n";
		//$pub_mail_id="renukadevi.ciet@gmail.com";  
		if($this->post("subject") !='')
		{
			$subject	= $this->post("subject"); 	
		}
		$mail_send=mail($pub_mail_id,$subject,$content,$headers);
		
		$mail_send_msg = $this->do_admarket->update_admarket_advpub_link($id,$message);				
		
		//$pub_acc_id=$this->do_admarket->get_publisher_accountid($site_id);		
		
		//$this->do_admarket->linking($account_id,$pub_acc_id,$site_id,$campaign_id);
		
		if($mail_send)
		{
			$success = array(
					'response' => 'ok',
					'redirect'=>site_url('advertiser/admarket/'),
					'msg'	 => 'Mail has been sent successfully!..'
			);
			$this->response($success, 200); 		
		}
		else
		{
			$error = array(
					'response' => 'error',
					'redirect'=>site_url('advertiser/admarket/'),
					'msg'	 => 'Mail has not been sent to publishers!..'
			);
			$this->response($error, 200); 
		}
		
		
		
	}
	function error_mail_post()
	{
		$camp_id = $this->post('camp_id');
				 	
		$mail_request = $this->do_admarket->fetch_publisher_error($camp_id,$contact);
		 
		if($mail_request)
		{
			$this->response($mail_request, 200); 
		}
				
	}
	function contact_mail_post()
	{
		$serial_id = $this->post('serial_id');	 
		 	
		$mail_request = $this->do_admarket->fetch_publisher_contact_mail($serial_id,$contact);
		 
		if($mail_request)
		{
			$this->response($mail_request, 200); 
		}
				
	}
	
	function fetch_advertiser_accept_post()
	{
		
		$zone_id = $this->post('zid');
		$groupby = $this->post('group_by');
		$pub_account_id		= $this->user_authentication->account_id;  
		$mail_request = $this->do_admarket->fetch_acc_banners($zone_id,$width,$height,$groupby);
		if ($mail_request)
		{
			$this->response($mail_request, 200); 
		}
		else $this->response(false, 200); 
	}
	function create_admarket_news_post()
	{
		$news = $this->post('news');
		$topics = $this->post('topics');
		$campaign_id = $this->post('admarket_id');
		
		$array_send= array(
		'campaign_id'=>$campaign_id,
		'dj_content'=>$news,
		'dj_subject'=>$topics,
		'date'=>date("Y-m-d H:i:s")
					
		);
		$news_update = $this->do_admarket->admarket_news_creation($array_send);
		if($news_update)
		{
			$success = array(
					'response' => 'ok',
					'redirect'=>site_url('advertiser/admarket'),
					'msg'	 => 'news created successfully'
			);
		$this->response($success, 200);  
		}
		
	}
	function admarket_faq_post()
	{
		$campid = $this->post('campid');//$this->response($campid, 200);  
		$faq_update = $this->do_admarket->admarket_faq_list($campid);
		if($faq_update)
		{
			$this->response($faq_update, 200);  
		}
	}
	
	function fetch_adv_pub_requestlist_post()
	{
		$campid = $this->post('campaign_id');
		$type = $this->post('type');
		//~ $this->response($this->post(), 200); 
		if($type=='error')
		{	
			$send_request = $this->do_admarket->fetch_publisher_error($campid);
		}
		elseif($type=='contact')
		{	
			$send_request = $this->do_admarket->fetch_publisher_contact($campid);
		}
		else
		{
			$send_request = $this->do_admarket->fetch_publisher_request($campid);
		}
		
		if($send_request)
		{
			$this->response($send_request, 200); 
		}
				
	}
	function mail_to_publisher_post()
	{	
		$account_id		= $this->user_authentication->account_id;  
		$pub_mail_id 	= $this->post("publisher_mail_id");
		$site_name		= $this->post("site_name");
		$site_url       = $this->post("site_url"); 
		$message		= $this->post("mail_message"); 
		$site_id		= $this->post("site_id");			
		$campaign_id	= $this->post("campaign_id"); 		
		$adv_mail_id=$this->do_admarket->adv_mail($campaign_id);   		
		//$adv_mail_id="renukadevi.s@djaxtech.com";
				
		$subject = $this->lang->line('pub_join_request');
		$content=$this->lang->line('site_name').":".$site_name."\r\n";
		$content.=$this->lang->line('site_url').":".$site_url."\r\n";
		$content.=$message."\r\n";
		$headers="From:".$adv_mail_id."\r\n";
		//$pub_mail_id="renukadevi.ciet@gmail.com";  
		
		$mail_send=mail($pub_mail_id,$subject,$content,$headers);
				
		$pub_acc_id=$this->do_admarket->get_publisher_accountid($site_id);		
		
		$this->do_admarket->linking($account_id,$pub_acc_id,$site_id,$campaign_id);
		
		if($mail_send)
		{
			$success = array(
					'response' => 'ok',
					'redirect'=>site_url('advertiser/admarket/message'),
					'msg'	 => 'Mail has been sent successfully!..'
			);
			$this->response($success, 200); 		
		}
		else
		{
			$error = array(
					'response' => 'error',
					'redirect'=>site_url('advertiser/admarket/message'),
					'msg'	 => 'Mail has not been sent to publishers!..'
			);
			$this->response($error, 200); 
		}
		
	}

	/*
	 * Linking admarket zone + creatives by admarket adv's id
	 * DAC 094
	 * 25/10/2018
	 * */
	function link_admarket_zone_advertiser_post() 
	{
		$zone_id	= $this->post('zone_id');
		$adv_id 	= $this->post('adv_ids');
		$adv_creatives = $this->do_admarket->fetch_admarket_advbanners($adv_id);
		$ad_zone_ids=array();
		$i=0;
		foreach($adv_creatives as $key => $value)
		{
			$ad_zone_ids[$i]['zone_id'] = $zone_id;
			$ad_zone_ids[$i]['ad_id'] 	= $value['bannerid'];
			$i++;
		} 
		$link_remove = $this->do_admarket->remove_all_ads($zone_id); // removing all existing ad ids linked to this zone
		
		if($link_remove)
		{
			$link_add = $this->do_admarket->add_adzone_assoc($ad_zone_ids);
			if ($link_add)
			{
				$result = array(
					'response' => 'ok',
				//	'redirect'=>site_url('advertiser/admarket'),
					'msg'	 => 'Ad Zone has been successfully linked'
				);
			}
			else
			{
				$result = array(
					'response' => 'error',
					//'redirect'=>site_url('advertiser/admarket'),
					'msg'	 => 'Error! try again later'
				);
			}
			
			
		}
		else
		{
			$result = array(
				'response' => 'error',
				//'redirect'=>site_url('advertiser/admarket'),
				'msg'	 => 'Error! try again later'
			);
		}
		
		$this->response($result, 200);
	}
	public function link_admarket_zone_banner_post()
	{
		$zone_id	= $this->post('zone_id');
		$adv_id	= $this->post('adv_id');
		$banner_ids	= $this->post('banner_ids');
		$adv_creatives = $this->do_admarket->fetch_admarket_advbanners($adv_id);
		$banner_ids_array = array();
		
		foreach( $adv_creatives as $key => $value)
		{
			$banner_ids_array[]=$value['bannerid'];
		}
		$i=0;
		foreach($adv_creatives as $key => $value)
		{
			$ad_zone_ids[$i]['zone_id'] = $zone_id;
			$ad_zone_ids[$i]['ad_id'] 	= $value['bannerid'];
			$i++;
		}
		$banid = explode(',',$banner_ids);
		$adding_ban = array();
		$j=0;		 
		foreach($banid as $key)
		{ 
			$adding_ban[$j]['zone_id'] = $zone_id;
			$adding_ban[$j]['ad_id'] = $key;
			$j++;
		}
		
		//~ print_r($adding_ban);	exit;	print_r($banner_ids_array);
		
		$link_remove = $this->do_admarket->remove_all_ads($zone_id,$banner_ids_array); // removing all existing adv ad ids linked to this zone
		//~ print_r($link_remove);
		$link_add = $this->do_admarket->add_adzone_assoc($adding_ban);
		//~ print_r($link_add);exit;
		if ($link_add)
		{
			$result = array(
				'response' => 'ok',
			//	'redirect'=>site_url('advertiser/admarket'),
				'msg'	 => 'Ad Zone has been successfully linked'
			);
		}
		else
		{
			$result = array(
				'response' => 'error',
				//'redirect'=>site_url('advertiser/admarket'),
				'msg'	 => 'Error! try again later'
			);
		}
			
		
		$this->response($result, 200);
	}
	
	public function fetch_linked_ads_post()
	{
		$zone_id	= $this->post('zone_id');
		$link_add = $this->do_admarket->get_adzone_assoc($zone_id);
		$this->response($link_add, 200);
	}
	public function fetch_advertiser_materials_post()
	{
		$adv_id	= $this->post('adv_id');
		$zone_id	= $this->post('zone_id');
		$adv_ads =  $this->do_admarket->fetch_adv_materials($adv_id,FALSE,$zone_id);
		$this->response($adv_ads, 200);
	}
	public function fetch_advertiser_linked_materials_post()
	{
		$zone_id	= $this->post('zone_id');
		$adv_id	= $this->post('adv_id');
		$data =  $this->do_admarket->fetch_adv_linked_materials($zone_id,$adv_id);
		$this->response($data, 200);
	}
	
	function fetch_advertiser_ads_post()
	{
		$zone_id= $this->post('zone_id');
		$adv_campaigns = $this->do_admarket->fetch_linked_campaigns($zone_id); //$this->response( $adv_campaigns, 200);
		if($adv_campaigns)
		{
			$camps_id =array_column($adv_campaigns,'campaignid');
			$adv_ads =  $this->do_admarket->fetch_adv_materials(false,$camps_id);//$this->response( $adv_ads, 200);
			$linked_ads =  $this->do_admarket->fetch_adv_linked_materials($zone_id);
			$result = array(
				'adv_ads' => $adv_ads,
				'linked_ads' => $linked_ads	);
		}
		
		$this->response( $result, 200);
	}	 
}
