<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Adblock_domains
 *
 * Adblock domains
 * 
 * @package		ADX
 * @subpackage	Access Users
 * @category	Controller
 * @author		Renukadevi S
 * @link		http://www.djaxadserver.com
*/

class Adblock_domains extends REST_Controller
{
	
	function __construct()
	{
		parent::__construct();
		$this->load->library('redis_library');		
		$this->load->library('memcached_library');		
		$this->load->library('Default_configurations');
		$this->load->library('csvreader');
		$this->load->model('do_adblock_domains');
		$this->load->model('do_app_config');
		$this->load->library('user_authentication');
		$key=$this->input->get_post('api_key'); 
	    //$this->response($key,200);
		$this->user_authentication->is_valid_apikey($key);
        $user_auth  = $this->user_authentication;
		if(isset($user_auth->error['response']))
	    {
	   		$this->response($user_auth->error,200);
	    }
	}
	
	/*
	 * 
	 * name:adblock_domain_list
	 * @param : NULL
	 * @return : NULL
	 * 
	 * List all domains
	 */
	function adblock_domain_list()
	{
		$result=$this->do_adblock_domains->fetch_domain();
		$this->response( $result, 200);
	}
	
	/*
	 * 
	 * name:fetch_get
	 * @param : Null
	 * @return : NULL
	 * 
	 */
	 
	 function fetch_get()
	{
		$domain_list = $this->do_adblock_domains->fetch_domain();
		$this->response($domain_list);
	}
	
	/*
   * 
   * name: fetch_data
   * @param : domain_id
   * @return :domain details
   * 
   */
	public function fetch_data_get()
	{
		$domain_id = $this->get('domain_id');
		if($domain_id)
		{
			$domain_list = $this->do_adblock_domains->fetch_select($domain_id);
			$this->response($domain_list);
		}
	}
	
	function getLatestFile($directoryPath)
	{
		$directoryPath = rtrim($directoryPath, '/');
	
		$max = array('path' => null, 'timestamp' => 0);	
		
		foreach (scandir($directoryPath, SCANDIR_SORT_NONE) as $file)
		{
			$path = $directoryPath . '/' . $file;
			if (!is_file($path)) {	
				continue;
			}
			$timestamp = filemtime($path);		
			if ($timestamp > $max['timestamp']) {
				$max['path'] = $path;
				$max['timestamp'] = $timestamp;
			}
		}	
		
    return $max['path'];
	}
	
	public function import_domain_file_post()
	{	
		$file_id=$this->post('upload_name');	
		
		if($file_id!='')
		{
			$upload_extension = explode(".", $file_id);		
			
			if($upload_extension[1]=='csv' || $upload_extension[1]=='txt')
			{
				
					$csvfilepath 	= $this->config->item('read_csv');	
					$file_name		= $this->getLatestFile($csvfilepath);					
				
					$data	 		= $this->csvreader->parse_file($file_name);
					
					$counter		= '1';	
					$ext_counter=1;
					$insert_rec=array();
					$exist_rec=array();
					$num_rows=count($data);					
					if($num_rows>0)
					{
						foreach($data as $row)
						{
							
								$url= trim($row['url']);
								$check_exist = $this->do_adblock_domains->exists_check($url);
								if($check_exist=='NULL')
								{
										$domain_id=$this->do_adblock_domains->add($url);
										$insert_rec[] =$counter;	
										/* Activity Log for Adblock Domain - Start*/	
										$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,DOMAIN_ADD);
										if($enable=='1')
										{							
										$this->activity_log(ADBLOCK_DOMAIN,ADD);
										}
										/* Activity Log for Adblock Domain - End*/	
										
								}
								else
								{
										$exist_rec[]=$ext_counter;
								}
						$counter++;	
						$ext_counter++;						
						}
						
						if(count($insert_rec)>0 && count($exist_rec) >0)
						{
								$ins_count = count($insert_rec);
								$ex_count= count($exist_rec);
								$success = array('response'	=> 'ok_error',
												 'msg'		=> $ins_count.' record(s) are inserted successfully',
												 'error_msg'=> $ex_count.' uploaded file(s) are already Exists !' 
												 ); 
								$this->response($success,200);
						}
						else if(count($insert_rec)>0 && count($exist_rec)<=0)
						{
								$ins_count = count($insert_rec);
								$success = array('response'	=> 'ok',
												 'msg'		=> $ins_count.' record(s) are inserted successfully'
												 ); 
								$this->response($success,200);
						}
						else if(count($exist_rec) >0&& count($insert_rec)<=0)
						{
								$ex_count= count($exist_rec);
									$error = array(
										   'response' => 'error',
										   'msg' =>  $ex_count.' uploaded file(s) are already Exists ! '
										  );
									$this->response( $error, 200);
						}
					}
					else
					{
						$error = array(
									'response' => 'error',
									'redirect'=>site_url('admin/adblock_domains/'),
									'msg'	 => 'There is no datas in the file!..'
									);
				  
						$this->response($error, 200);	
					}														
			}
			else
			{
				$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV/TXT file to upload!..'
							);
	  
				$this->response($error, 200);	
					
			}		
		}
		else
		{
			$error = array(
						'response' => 'error',
						'msg'	 => 'Please select a valid CSV/TXT file to upload!..'
						);
	  
			$this->response($error, 200);
		}		
		
						
	}
	public function delete_domain_get()
   {
      $id = $this->get('delete_domain_id');
	  
	  	  	  
	   if($id)
		{
			$domain_id	=	explode(',',$id);
			
			if(is_array($domain_id))
			{
				foreach($domain_id as $id)
				{	
										/* Activity Log for Adblock Domain -DELETE - Start*/	
										$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,DOMAIN_DELETE);
										if($enable=='1')
										{							
										$this->activity_log(ADBLOCK_DOMAIN,DELETE);
										}
										/* Activity Log for Adblock Domain - DELETE - End*/	
					
				 $cat_list = $this->do_adblock_domains->delete_domain($id);
				}
			}
			else
			{
				/* Activity Log for Adblock Domain -DELETE - Start*/	
					$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,DOMAIN_DELETE);
					if($enable=='1')
					{							
						$this->activity_log(ADBLOCK_DOMAIN,DELETE);
					}
					/* Activity Log for Adblock Domain - DELETE - End*/	
				$cat_list = $this->do_adblock_domains->delete_domain($id);
			}
					
			
			$success = array('response'	=> 'ok',
							 'msg'		=> 'Adblock Domain has been deleted'
							 );
			
			$this->response( $success, 200);
			
		}else{
			
			$error = array(
							'response' => 'error',
							'msg'	 => 'Adblock Domain id is not found'
					);
			
			$this->response( $error, 200);
		}

   }
	
	public function block_domain_get()
	{
	    $cat_id=$this->get('domain_id');
	    $arrays	=	explode(',',$cat_id);
	    if(is_array($arrays))
			{  
				foreach($arrays as $cat_id)
				{
					 $results= $this->do_adblock_domains->block_domain($cat_id);
					 /* Activity Log for Adblock Domain -BLOCK - Start*/	
						$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,DOMAIN_BLOCK);
						if($enable=='1')
						{							
							$this->activity_log(ADBLOCK_DOMAIN,BLOCK);
						}
					/* Activity Log for Adblock Domain - BLOCK - End*/	
				}
					
				$success 	= 	array('response'	=> 	'ok',
										  'msg'		=> 	'Adblock Domain is blocked successfully.. '
										);
					
					$this->response( $success, 200);
			}
			else
			{
				$results= $this->do_adblock_domains->block_domain($cat_id);
				
				 /* Activity Log for Adblock Domain -BLOCK - Start*/	
						$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,DOMAIN_BLOCK);
						if($enable=='1')
						{							
							$this->activity_log(ADBLOCK_DOMAIN,BLOCK);
						}
					/* Activity Log for Adblock Domain - BLOCK - End*/	
				
				$success 	= 	array('response'	=> 	'ok',
										  'msg'		=> 	'Adblock Domain is blocked successfully..'
										);
					
				$this->response( $success, 200);
			}

	}
	
	
	public function unblock_domain_get()
	{
	    $cat_id=$this->get('unblock_domain_id');
	    $arrays	=	explode(',',$cat_id);
				//$this->response( $this->get(), 200);
	    if(is_array($arrays))
			{  
				foreach($arrays as $cat_id)
				{
					 $results= $this->do_adblock_domains->unblock_domain($cat_id);
					 //$this->response( $cat_id, 200);
					  /* Activity Log for Adblock Domain - UNBLOCK - Start*/	
						$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,DOMAIN_UNBLOCK);
						if($enable=='1')
						{							
							$this->activity_log(ADBLOCK_DOMAIN,UNBLOCK);
						}
					/* Activity Log for Adblock Domain - UNBLOCK - End*/	
					 
				}
					//$this->response( $results, 200);
					if($results!=false)
					{
					$success 	= 	array('response'	=> 	'ok',
					                    	'result' => $results,
										  'msg'		=> 	'Adblock Domain is unblocked successfully.. '
										);
					}
					else
					{
						$success 	= 	array('response'	=> 	'ok',
												'result' => $results,
										  'msg'		=> 	'Already Domain has been enabled.. '
										);
						
					}
					
					$this->response( $success, 200);
			}
			else
			{
				$results= $this->do_adblock_domains->unblock_domain($cat_id);
				
				/* Activity Log for Adblock Domain - UNBLOCK - Start*/	
						$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,DOMAIN_UNBLOCK);
						if($enable=='1')
						{							
							$this->activity_log(ADBLOCK_DOMAIN,UNBLOCK);
						}
				/* Activity Log for Adblock Domain - UNBLOCK - End*/	
				
				
				$success 	= 	array('response'	=> 	'ok',
										  'msg'		=> 	'Adblock Domain is unblocked successfully..'
										);
					
				$this->response( $success, 200);
			}

	}
	
	public function update_domain_post()
	{	
		$this->form_validation->set_rules('domain_val', 'URL', 'required|trim|callback_domain_list_check');
		if($this->form_validation->run() === FALSE){
			
			$error_msg = $this->form_validation->error_array();
			$error = array(
								'response' => 'error',
								'msg' =>  $error_msg
							);

			 $this->response( $error, 200);
		}
		else
		{
			$domain_id		=   clean_data($this->post('domain_id'));
			$up_val	=array("url"=>clean_data($this->post('domain_val')));
			$up_data = $this->do_adblock_domains->update_domain_list($up_val,$domain_id);
			
			
					/* Activity Log for Adblock Domain - EDIT - Start*/	
						$enable	=  	$this->default_configurations->activity_log_setting(ADMIN_SETTINGS,DOMAIN_EDIT);
						if($enable=='1')
						{							
							$this->activity_log(ADBLOCK_DOMAIN,EDIT);
						}
					/* Activity Log for Adblock Domain - EDIT - End*/
		  
			
			
			if($up_data !== FALSE){
				
				$success = array(
									'response' => 'ok',
									'msg'	 => 'Adblock Domain has been Updated successfully!..'
					);
				
				$this->response( $success, 200);
			}
			else{
				
				$success = array(
									'response' => 'error',
									'msg'	 => 'Problem in updating Adblock Domain!..'
					);
				
				$this->response( $success, 200);
			}		
		}
	}
	
	function domain_list_check()
	{
		$domain_id		=   clean_data($this->post('domain_id'));
		$domain_value	=	clean_data($this->post('domain_val'));
		$table_name 	=   TAB_ADBLOCK_DOMAIN;
		$count 			= 	$this->do_adblock_domains->domain_list_check($table_name,$domain_value,$domain_id);
		
		if($count>0)
		{
			$this->form_validation->set_message('domain_list_check', 'Domain list already exist');
			return FALSE;
		}
		else
		{
			return TRUE;
		}	
	}
	
	
	function activity_log($module,$process)
	{
				/* Activity Log - Start*/				
				$user_agent=$this->user_authentication->user_agent;
				$browser=$this->user_authentication->browser;
				$os=$this->user_authentication->os;
				$ip=$_SERVER['REMOTE_ADDR'];
				$date=date("Y-m-d h:i:s");							
				$account_id=$this->user_authentication->account_id;
				$module=$module;
				$process=$process;				
								
				$activity_log=array(				
				"account_id"=>$account_id,
				"useragent"=>$user_agent,
				"browser"=>$browser,
				"os"=>$os,
				"ip"=>$ip,
				"date"=>$date,
				"module"=>$module,
				"process"=>$process,
				"advertiser_id"=>'',
				"campaign_id"=>'',
				"banner_id"=>'',
				"publisher_id"=>'',
				"site_id"=>'',
				"app_id"=>'',
				"adblock_id"=>'');				
					
				$this->redis_library->logcount($account_id,$activity_log);
				//$this->do_app_config->activity_log($account_id,$activity_log);
				/* Activity Log - End*/			
		
	}
   
	function fetch_dynamic_domain_get()
	{
		$domain_list = $this->do_adblock_domains->dynamic_domain_change();
		$this->response($domain_list);
		 
	}
	
}
