<?php

require 'bp_lib.php';
require 'config.php';

// create invoice
$posData 	= 	array($bit['price'],$bit['x_invoice_num'],$bit['x_cust_id']);
$options 	= 	array(
					'apiKey' 			=> 	$bpOptions['apiKey'],
					'notificationURL' 	=> 	$bit['notificationURL'],
					'fullNotifications' => 	$bit['fullNotifications'],
					'price' 			=> 	$bit['price'],
					'currency' 			=> 	$bit['currency'],
					'redirectURL' 		=> 	$bit['redirectURL'],
					'notificationEmail' => 	$bit['notificationEmail'],
					'buyerName' 		=> 	$bit['buyerName'],
					'buyerEmail' 		=> 	$bit['buyerEmail']
					);		

$invoice 	= 	bpCreateInvoice($bit['orderID'], $bit['price'], $posData, $options);

if (isset($invoice['error'])) {
	?>
	<div class="content">
		
		<div class="contenttitle">
			<h2 class="form"><span><?php echo $this->lang->line('lang_payment_failure'); ?></span></h2>
		</div><!--contenttitle-->
		<div class="form_default" align="center">
			<fieldset>
				<br/>
				<img src="<?php echo base_url(); ?>template/flat/img/no-payment.png" />
				
				<br/>
				<h3 class="pageTitle"><?php echo$this->lang->line('sry_pay_cancel');?></h3>
				<p>
					<?php echo ucfirst($invoice['error']['message']).', Please check authentication in admin.'; ?>
				</p>
				<p>
					<a class="btn btn-blue" href="<?php echo site_url('advertiser/payments'); ?>">
						<i class="icon-arrow-left"></i> <?php echo $this->lang->line('back_to_pay_his');?>
					</a>				
				</p> 
			
			</fieldset>
		</div>
	</div>

<?php 
}

if($invoice['id'])
{
	$this->session->set_userdata('bitpay_invoice_no',$invoice['id']);
}

// save bitpay invoice id in a file named after the ecwid invoice id
if($this->session->userdata('bitpay_invoice_no'))
{
	//redirect to bitpay
	header('Location: '.$invoice['url']);
}

?>
