<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Webmoney extends CI_Controller { 

	public function __construct()
	{
		parent::__construct();
		
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		
	}

	public function index()
	{
		$this->add_payment();
	}
	
	function add_payment($account_id=false,$amount=false)
	{
		$data['page_title'] 	= 	"Payment Gateway - Webmoney";
				
		$data['account_id']		= 	$account_id;		
		$data['amount'] 		= 	$amount;
		
		$webm_details			=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>3),'php');
		
		$data['webm']			=	$webm_details[0];
							
		$this->load->view('advertiser/webmoney/add_payment',$data);
	}

	
	public function payment_success()
	{
		$data['page_title']		= 	"payment success";
					
		$this->load->view('advertiser/webmoney/payment_success',$data);
	}
	
	public function payment_failure()
	{
		$data['page_title']		= 	"Payment process details";
		
		$this->load->view('advertiser/webmoney/payment_failure', $data);
	}
	
	public function payment_process()
	{
		$data['page_title']			= "Payment Success";
		
		$adm			=	$this->rest->get('api/v1/network/get_network_details',array('api_key'=>get_session('api_key')),'json'); 
		$admin			=	json_decode($adm);
		
		$data['trans_id'] 	= 	$_REQUEST['LMI_SYS_TRANS_NO'];
		$data['amount']		=	$_REQUEST['FIELD_2'];
		
		#Get Post values from Authorize.net	
		
		if($_REQUEST['LMI_SYS_TRANS_NO']) 
		{
			$invoice_code 	= 	$_REQUEST['LMI_SYS_INVS_NO'];
			$ipn_txn_id	 	= 	$_REQUEST['LMI_SYS_TRANS_NO'];
			
			$payment_data = array(
										'account_id'    =>  $_REQUEST['FIELD_1'],
										
										'payment_type'  =>  '3',

										'payer_email'   =>  get_session('email'),

										'receiver_email'=>  $admin->email,

										'txn_id'        =>  $ipn_txn_id,

										'ipn_track_id'  =>  $invoice_code,

										'payment_gross' =>  $_REQUEST['FIELD_2'],

										'mc_currency'   =>  $this->config->item('currency'),

										'item_name'     =>  'Advertiser Fund',

										'item_number'   =>  $_REQUEST['LMI_PAYMENT_NO'],

										'quantity'      =>  1,

										'payer_status'  =>  'verified',

										'payment_status'=>  'Completed',

										'payment_date'  =>  date('Y-m-d H:i:s'),
										
										'payment_paid_date'  =>  date('Y-m-d H:i:s',strtotime($_REQUEST['LMI_SYS_TRANS_DATE']))
									);			   
			
			$addfund_list	 = 	$this->rest->get('api/v1/payments/add_advertiser_fund',array('pay_data'=>$payment_data,'payer_id'=>$_REQUEST['FIELD_3'],'api_key'=>get_session('api_key')),'php');
			
			$this->load->view('advertiser/webmoney/payment_success',$data);
			
		}
		else
		{
			$data['page_title']		= 	"Payment Failure";			
			
			$this->load->view('advertiser/webmoney/payment_failure', $data);
		}
	}
}
