<?php 
class Tracker extends CI_Controller
{
   function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->helper('download');
		$this->load->library('default_configurations');
	}

	function index()
	{
		$this->pixel();  
	}

	/*
	 * 
	 * name		:countrywise_bidding
	 * @param   :Null
	 * @return  :List the countrywise bidding for particular Advertiser
	 */	

	public function pixel()
	{
		$data['page_title'] = 	"Pixel Tracker";
		
		$data['content'] = $this->load->view('tracker/pixel_tracker',$data,TRUE);
		
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_pixel_list()
	{
		$tracker_list	  = $this->rest->get('api/v1/tracker/fetch_tracker',array('api_key'=>get_session('api_key')),'json');		
		
		echo convert_to_datatable_format($tracker_list);
	}
	
	/*
	 * 
	 * name		:add_pixel_tracker
	 * @param   :Null
	 * @return  :Create the pixel
	 */	

	public function add_pixel_tracker()
	{		
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
		$data['campaign_data'] 	=	$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
		$data['admarket']=$admarket;
		$domain		= 	$this->rest->get('api/v1/campaign/fetch_domain',array("api_key"=>get_session('api_key')),'php');
		$data['domain_data']=	$domain[0]['url'];
		$data['content'] = $this->load->view('buyer/tracker/modal_tracker/content/add_tracker',$data,TRUE);		
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data); 
	}
	public function import_pixeltracker()
	{
	
		$data['content'] = $this->load->view('tracker/modal_tracker/layout/import_tracker',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	
	}
	 public function pixeltrackerexport_url()
	{
		$this->session->unset_userdata('pixeltracker_export_id');
		$this->session->set_userdata('pixeltracker_export_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('pixeltracker_export_id'));
		
	}
	public function pixeltrackerexport()
	{
		
		$data['campaign_id'] = $this->session->userdata('pixeltracker_export_id');
		$data['content'] = $this->load->view('tracker/export_pixel',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	/*
	 * 
	 * name		:edit_pixel_tracker
	 * @param   :Null
	 * @return  :Loads the pixel
	 */	
	public function edit_px_tracker_id()
	{
		
		$this->session->unset_userdata('edit_px_tracker_id');
		$this->session->set_userdata('edit_px_tracker_id_url', $_POST['url_id']);
		echo json_encode($this->session->userdata('edit_px_tracker_id_url'));

	}
	public function edit_pixel_tracker($tracker_id=false)
	{
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
			$tracker_id	= $this->session->userdata('edit_px_tracker_id_url');
		//Fetch available campaign's	
		$data['campaign_data'] 	=	$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
		
		$data['tracker_data'] 	= 	$this->rest->get('api/v1/tracker/fetch_tracker',array("tracker_id"=>$tracker_id,"api_key"=>get_session('api_key')),'php');
		
		$domain		= 	$this->rest->get('api/v1/campaign/fetch_domain',array("api_key"=>get_session('api_key')),'php');
			//print_r($domain[0]['url']);die("sdfsf");
			$data['domain_data']=	$domain[0]['url'];
		echo $this->load->view('tracker/modal_tracker/content/edit_tracker',$data);	
		$data['content'] = $this->load->view('tracker/modal_tracker/content/edit_tracker',$data,TRUE);		
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data); 
	}
	
	public function view_pixel_tracker_uri_id()
	{
		
		$this->session->unset_userdata('view_pixel_tracker_uri_id');
		$this->session->set_userdata('view_pixel_tracker_uri_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('view_pixel_tracker_uri_id'));

	}
	
	/*
	* 
	* name   : view_tracker
	* @param : campaign_id
	* @return: Fetch campaign tracker code for particular campaign
	*/	
	public function view_tracker($admarket = false)
	{
			$tracker_id	= $this->session->userdata('view_pixel_tracker_uri_id');
			$data['admarket'] = $admarket;
		$data['tracker_data'] = $this->rest->get('api/v1/tracker/fetch_tracker',array("tracker_id"=>$tracker_id,"api_key"=>get_session('api_key')),'php');
		
		//echo $this->load->view('tracker/modal_tracker/content/view_trackers',$data);
		$data['content'] = $this->load->view('tracker/modal_tracker/content/view_trackers',$data,TRUE);		
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data); 
	}
	public function tracker_link_edit()
	{
		$this->session->unset_userdata('track_link_edit_id');
		$this->session->set_userdata('track_link_edit_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('track_link_edit_id'));
	}
	/*
	* 
	* name   : link_tracker
	* @param : campaign_id
	* @return: Fetch link campaign tracker for particular campaign
	*/	
	public function link_tracker($tracker_id=false)
	{
		$data['page_title'] = 	"Link Campaigns";
		
		//$data['tracker_id']	=	$tracker_id;
		$data['tracker_id']	=	 $this->session->userdata('track_link_edit_id');
		
		$link 				= 	$this->rest->get('api/v1/tracker/fetch_tracker_campaign',array("api_key"=>get_session('api_key'),"tracker_id"=>$this->session->userdata('track_link_edit_id')),'php');
	
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key')),'php');
		
		$data['link_data']	=	($link!='error')?$link:'';
		//echo "<pre>";print_r($data);echo "</pre>";die("sdssf");
		$data['content']	=	$this->load->view('tracker/campaign_list',$data,TRUE);
		
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_campaign_list()
	{
		$campaign_list 	=	$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'json');
		
		echo convert_to_datatable_format($campaign_list);
	}	
	
	
	public function conversion_setting_edit_url()
	{
		$this->session->unset_userdata('conversion_setting_edit_url_id');
		$this->session->set_userdata('conversion_setting_edit_url_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('conversion_setting_edit_url_id'));
	}
	/*
	* 
	* name   : conversion_settings
	* @param : campaign_id
	* @return: Fetch campaign tracker code for particular campaign
	*/	
	public function conversion_settings($tracker_id=false,$campaign_id=false)
	{
		$tracker	=	 $this->session->userdata('conversion_setting_edit_url_id');
		$tracker_values = explode("/",$tracker);
						$tracker_id	=$tracker_values['0'];
						$campaign_id	=$tracker_values['1'];
		
		$data['tracker_data'] 	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		
		$data['tracker_id']		=	$tracker_id;
		
		$data['campaign_id']	=	$campaign_id;
		
	//	echo $this->load->view('tracker/modal_tracker/content/conversion_window',$data);
		$data['content']	=	$this->load->view('tracker/modal_tracker/content/conversion_window',$data,TRUE);
		
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	//campaign sample file download 
	function tracker_import_download_file()
	{ 
		
		$data = file_get_contents("./csv/upload/tracker_import.csv"); // Read the file's contents			
		ob_clean();
		$name = 'tracker_import.csv';
		force_download($name, $data);  
	}
	
	function tracker_import_download_file_txt()
	{ 
		$data = file_get_contents("./csv/upload/tracker_import.txt"); // Read the file's contents			
		ob_clean();
		$name = 'tracker_import.txt';
		force_download($name, $data);    
	}
	function tracker_import_download_file_xml()
	{ 
		$data = file_get_contents("./csv/upload/tracker_import.xml"); // Read the file's contents			
		ob_clean();
		$name = 'tracker_import.xml';
		force_download($name, $data);    
	}
	function admarket_tracker_import_download_file()
	{	
		$data = file_get_contents("./csv/upload/admarket_tracker_import.csv"); // Read the file's contents			
		$name = 'admarket_tracker_import.csv';
		ob_clean();
		force_download($name, $data);  
	}	
	function admarket_tracker_import_download_file_txt()
	{ 
		$data = file_get_contents("./csv/upload/admarket_tracker_import.txt"); // Read the file's contents			
		$name = 'admarket_tracker_import.txt';
		ob_clean();
		force_download($name, $data);    
	}	
	function admarket_tracker_import_download_file_xml()
	{ 
		$data = file_get_contents("./csv/upload/admarket_tracker_import.xml"); // Read the file's contents			
		$name = 'admarket_tracker_import.xml';
		ob_clean();
		force_download($name, $data);    
	}	
	function download($pixel_id=false,$format=false)
	{ 
		$pixelid= rawurldecode($pixel_id);  
		if($pixelid!=false)
		{	
			//$export_list=$this->rest->get('api/v1/campaign/testing',array('campaignid'=>$campaignid,'api_key'=>get_session('api_key')),'php');
			$pixelid=(explode(",",$pixelid));
			$pixel_list = 	$this->rest->get('api/v1/tracker/fetch_tracker',array("tracker_id"=>$pixelid,"api_key"=>get_session('api_key')),'json');
			
			$listed_data = json_decode($pixel_list, true);		
			foreach($listed_data as $cam_id)
			{
			$cam[]=$cam_id['trackerid'];
			}	
			$imp=implode(',',$cam);
			$cmp_s= str_replace(",","_trkid_",$imp);
			if($cmp_s)
			{
				$cmp_fn='trkid_'.$cmp_s;
			}
			else
			{
				$cmp_fn='trkid_'.$imp;
			}		
			
			
		//print_r($listed_data);die("dddwewew");				
			if($format=="csv")
			{				
					$filename=$cmp_fn.'.csv';
					header('Content-type: text/csv');
					header('Content-Disposition: attachment; filename='.$filename);

					$csv = "trackerid,trackername,pixel_type,type,pixel_category,protocol,pixel_goal,status,appendcode\n";
					
					for($i=0;$i<count($listed_data);$i++){
						
						$csv.= $listed_data[$i]['trackerid'].','.$listed_data[$i]['trackername'].','.$listed_data[$i]['pixel_type'].','.$listed_data[$i]['type'].','.$listed_data[$i]['pixel_category'].','.$listed_data[$i]['protocol'].','.$listed_data[$i]['pixel_goal'].','.$listed_data[$i]['status'].','.$listed_data[$i]['appendcode']."\n";
					}
					ob_clean();
					print_r($csv);  
			}
			else if($format =='txt')
			{
				$listed_txt = array ();
				$filename=$cmp_fn.'.txt';
				$delimiter = "\t";
				header('Content-type: text/tab-separated-values');
				header("Content-Disposition: attachment;filename=".$filename);	
											
				$txt = "trackerid,trackername,pixel_type,type,pixel_category,protocol,pixel_goal,status,appendcode\n";
					
					for($i=0;$i<count($listed_data);$i++){
						
						$txt.= $listed_data[$i]['trackerid'].','.$listed_data[$i]['trackername'].','.$listed_data[$i]['pixel_type'].','.$listed_data[$i]['type'].','.$listed_data[$i]['pixel_category'].','.$listed_data[$i]['protocol'].','.$listed_data[$i]['pixel_goal'].','.$listed_data[$i]['status'].','.$listed_data[$i]['appendcode']."\n";
					}	
					$no_blanks = str_replace("\r\n\r\n", "\r\n", $txt);
					ob_clean();
					print_r($no_blanks); 	
			}
			else if($format =='xml')
			{
				$filename=$cmp_fn.'.xml';
				header('Content-Type: text/xml');
				header("Content-Disposition: attachment;filename=".$filename);
				$xml = new SimpleXMLElement('<campaigns/>');
				$xml->addAttribute("xmlns", "http://tempuri.org/ds.xsd");
				for($i=0;$i<count($listed_data);$i++)
				{
						$pixel_list = $xml->addChild("pixel");
						$pixel_list->addChild('trackerid',$listed_data[$i]['trackerid']);
						$pixel_list->addChild('trackername',$listed_data[$i]['trackername']);
						$pixel_list->addChild('pixel_type', $listed_data[$i]['pixel_type']);
						$pixel_list->addChild('type', $listed_data[$i]['type']);
						$pixel_list->addChild('pixel_category', $listed_data[$i]['pixel_category']);
						$pixel_list->addChild('protocol', $listed_data[$i]['protocol']);
						$pixel_list->addChild('pixel_goal', $listed_data[$i]['pixel_goal']);
						$pixel_list->addChild('status', $listed_data[$i]['status']);
						$pixel_list->addChild('appendcode', $listed_data[$i]['appendcode']);						
				}
				ob_clean();
				print($xml->asXML());
				
			}			
		}
		
	}
	function admarket_download($pixel_id=false,$format=false)
	{
		$pixelid= rawurldecode($pixel_id);    
		if($pixelid!=false)
		{
			$pixelid=(explode(",",$pixelid));
			$pixel_list = 	$this->rest->get('api/v1/tracker/fetch_tracker',array("tracker_id"=>$pixelid,"api_key"=>get_session('api_key'),"admarket"=>'1'),'json');
			
			$listed_data = json_decode($pixel_list, true);		
			//print_r($pixel_list);die("dddwewew");      	  			
			if($format=="csv")
			{				
					$filename='admarket_pixel_list.csv';
					header('Content-type: text/csv');
					header('Content-Disposition: attachment; filename='.$filename);

					$csv = "trackerid,trackername,pixel_type,type,pixel_category,protocol,pixel_goal,status,appendcode,admarket\n";
					
					for($i=0;$i<count($listed_data);$i++){
						
						$csv.= $listed_data[$i]['trackerid'].','.$listed_data[$i]['trackername'].','.$listed_data[$i]['pixel_type'].','.$listed_data[$i]['type'].','.$listed_data[$i]['pixel_category'].','.$listed_data[$i]['protocol'].','.$listed_data[$i]['pixel_goal'].','.$listed_data[$i]['status'].','.$listed_data[$i]['appendcode'].','.$listed_data[$i]['admarket']."\n";
					}
					ob_clean();
					print_r($csv);  
			}
			else if($format =='txt')
			{
				$listed_txt = array ();
				$delimiter = "\t";
				header('Content-type: text/tab-separated-values');
				header("Content-Disposition: attachment;filename=admarket_pixel_list.txt");	
											
				$txt = "trackerid,trackername,pixel_type,type,pixel_category,protocol,pixel_goal,status,appendcode,admarket\n";
					
					for($i=0;$i<count($listed_data);$i++){
						
						$txt.= 
						$listed_data[$i]['trackerid'].','.$listed_data[$i]['trackername'].','.$listed_data[$i]['pixel_type'].','.$listed_data[$i]['type'].','.$listed_data[$i]['pixel_category'].','.$listed_data[$i]['protocol'].','.$listed_data[$i]['pixel_goal'].','.$listed_data[$i]['status'].','.$listed_data[$i]['appendcode'].','.$listed_data[$i]['admarket']."\n";
					}
					ob_clean();	
					print_r($txt); 	
			}
			else if($format =='xml')
			{
				header('Content-Type: text/xml');
				header("Content-Disposition: attachment;filename=admarket_pixel_list.xml");
				$xml = new SimpleXMLElement('<campaigns/>');
				$xml->addAttribute("xmlns", "http://tempuri.org/ds.xsd");  
				for($i=0;$i<count($listed_data);$i++)
				{
						$pixel_list = $xml->addChild("pixel");
						$pixel_list->addChild('trackerid',$listed_data[$i]['trackerid']);
						$pixel_list->addChild('trackername',$listed_data[$i]['trackername']);
						$pixel_list->addChild('pixel_type', $listed_data[$i]['pixel_type']);
						$pixel_list->addChild('type', $listed_data[$i]['type']);
						$pixel_list->addChild('pixel_category', $listed_data[$i]['pixel_category']);
						$pixel_list->addChild('protocol', $listed_data[$i]['protocol']);
						$pixel_list->addChild('pixel_goal', $listed_data[$i]['pixel_goal']);
						$pixel_list->addChild('status', $listed_data[$i]['status']);
						$pixel_list->addChild('appendcode', $listed_data[$i]['appendcode']);						
						$pixel_list->addChild('admarket', $listed_data[$i]['admarket']);						
				}
				ob_clean();
				print($xml->asXML());    
				
			}			
		}
		
	}
	public function eventlog()
	{
		$data['page_title'] = 	"Pixel Tracker";
		
		$data['content'] = $this->load->view('tracker/eventlog',$data,TRUE);
		
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	public function eventlog_listing()
	{
		$eventlog_list 	=	$this->rest->get('api/v1/tracker/fetch_eventlogs',array("api_key"=>get_session('api_key')),'json');
		//~ echo $this->rest->debug();exit;
		//~ print_r('hello');exit;
		echo convert_to_datatable_format($eventlog_list);
	}

}
