<?php 
class Settings extends CI_Controller
{
    function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}

	function index()
	{
		$this->personal_information();
	}

	/*
	 * 
	 * name		:personal_information
	 * @param   :Null
	 * @return  :List personal_information for a particular
	 * 			 Advertiser
	 */	

	public function personal_information()
	{
		$data['page_title'] = "Personal information";
		$data['breadcrumb'] = '';		
		$api_key=get_session('api_key');
		$personal_info=$this->rest->get('api/v1/advertiser/user_information',array('api_key'=>get_session('api_key')),'php');		
		$data['personal_info']=$personal_info[0];
		$country_val=$personal_info[0]['dj_country'];
		$country_value=$this->rest->get('api/v1/utilities/country_val',array("api_key"=>$api_key,"value"=>$country_val),'php');					
		$data['country_value']=$country_value[0]['value'];		
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
		$company_info=$this->rest->get('api/v1/advertiser/user_information',array('api_key'=>get_session('api_key')),'php');	
		$data['company_info']=$company_info[0];
			
		$account_info=$this->rest->get('api/v1/advertiser/user_information',array('api_key'=>get_session('api_key')),'php');	
		$data['account_info']=$account_info[0];	
		$seurity_info=$this->rest->get('api/v1/advertiser/security',array('api_key'=>get_session('api_key')),'php');	
		$data['seurity_info']=$seurity_info[0];	
		$data['currency']=$this->rest->get('api/v1/utilities/currencylist',array('api_key'=>get_session('api_key')),'php');
							
		$data['content'] = $this->load->view('settings/personal_information',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:company_information
	 * @param   :Null
	 * @return  :List company_information for a particular
	 * 			 Advertiser
	 */	
	public function company_information()
	{
		$data['page_title'] = "Company information";
		$data['breadcrumb'] = '';
		$company_info=$this->rest->get('api/v1/advertiser/user_information',array('api_key'=>get_session('api_key')),'php');	
		$data['company_info']=$company_info[0];
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');		
		$data['content'] = $this->load->view('settings/company_information',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:Message_mail Settings
	 * @param   :Null
	 * @return  :List of mail Setting information for advertiser
	 * 			 
	 */	
	public function message_settings()
	{
		$data['page_title'] = "Message Setting";
		$data['breadcrumb'] = '';
		$notify	=	$this->rest->get('api/v1/advertiser/notification_information',array('api_key'=>get_session('api_key')),'php');	
		$data['advertiser_notify']	=	($notify!='error')?$notify:'';
		//~ print_r($data['advertiser_notify']);exit;
		$adgatenews	=	$this->rest->get('api/v1/advertiser/fetch_adgate_news',array('api_key'=>get_session('api_key')),'php');	
		$data['client_settings']	=	($adgatenews!='error')?$adgatenews:'';
		
		$data['admin_enable']=$this->rest->get('api/v1/advertiser/admin_enable',array('api_key'=>get_session('api_key')),'php');	
		
		$data['content'] = $this->load->view('settings/message_settings',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	
	
	
	/*
	 * 
	 * name		:billing_information
	 * @param   :Null
	 * @return  :Loads the form to get user billing information
	 */	

	public function billing_information()
	{
		$data['page_title'] = "Billing information";
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/billing_information',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * 
	 * name		:security
	 * @param   :Null
	 * @return  :Loads the form to get user security
	 */	

	public function security()
	{
		$data['page_title'] = "Security";
		$data['breadcrumb'] = '';

		$sms_info=$this->rest->get('api/v1/advertiser/sms_option',array('api_key'=>get_session('api_key')),'php');
		$data['app_sms_info'] = $sms_info[0]['sms_verify'];
				
		$security_info=$this->rest->get('api/v1/advertiser/security',array('api_key'=>get_session('api_key')),'php');	
		$data['security_info']=$security_info[0];		
		$security_question=$this->rest->get('api/v1/advertiser/security_question',array('api_key'=>get_session('api_key')),'php');
		$data['security_question']=$security_question;	
		$personal_info=$this->rest->get('api/v1/advertiser/user_information',array('api_key'=>get_session('api_key')),'php');		
		$data['personal_info']=$personal_info[0];	
		$data['content'] = $this->load->view('settings/security',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * 
	 * name		:payment_settings
	 * @param   :Null
	 * @return  :Loads the form to get user payment information
	 */	

	public function payment_settings()
	{
		$data['page_title'] = "Payment setting";
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/payment_settings',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	/*
	 * 
	 * name		:email_preferences
	 * @param   :Null
	 * @return  :Loads the form to get user email preferences
	 */	

	public function email_preferences()
	{
		$data['page_title'] = "Email preferences";
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/email_preferences',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	/*
	 * 
	 * name		:referral_programs
	 * @param   :Null
	 * @return  :Loads the form to get user Referal programs
	 */	

	public function referral_program()
	{
		$data['page_title'] = "Referral program";
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/referral_program',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
		
	/*
	 * 
	 * name		: account_settings
	 * @param   : Null
	 * @return  : account_settings for a particular
	 * 			 Advertiser
	 */	

	public function account_settings()
	{
		$data['page_title'] = "Account settings";
		$data['breadcrumb'] = '';
		$account_info=$this->rest->get('api/v1/advertiser/user_information',array('api_key'=>get_session('api_key')),'php');	
		$data['account_info']=$account_info[0];	
		$seurity_info=$this->rest->get('api/v1/advertiser/security',array('api_key'=>get_session('api_key')),'php');	
		$data['seurity_info']=$seurity_info[0];	
		$data['currency']=$this->rest->get('api/v1/utilities/currencylist',array('api_key'=>get_session('api_key')),'php');			
		$data['content'] = $this->load->view('settings/account_settings',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	public function activity_log()
	{
		$data['page_title']=$this->lang->line('activity_log');
		$data['breadcrumb']='';
		$data['campaigns'] = $this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
		$data['creatives']	=   $this->rest->get('api/v1/creative/fetch',array("api_key"=>get_session('api_key')),'php');
		$data['zonelimit']	= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array("api_key"=>get_session('api_key')),'php');
		$data['trafficsource']= $this->rest->get('api/v1/network/fetch_traffic_sources',array("api_key"=>get_session('api_key')),'php');
		$data['pixeltracker']	= 	$this->rest->get('api/v1/tracker/fetch_tracker',array("api_key"=>get_session('api_key')),'php');
		$data['countrybidding']=$this->rest->get('api/v1/countrywise_bidding/fetch_biddingcountrylist',array('api_key'=>get_session('api_key')),'php');
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_OVERVIEW']['TABLE']['DEFAULT_INTERVAL']);
		//print_r($data['countrybidding']);exit;
		$data['content'] = $this->load->view('settings/activity_log',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_activity_log()
	{
		$activity_log		= $this->rest->get('api/v1/app_settings/fetch_activity_log',array("api_key"=>get_session('api_key')),'json');
		echo convert_to_datatable_format($activity_log);  
	}
	public function fetch_activity_log_filter($type=false,$format='json')
	{ 
		
		$device= 	clean_data($this->input->post('device'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$to_date	= 	clean_data($this->input->post('to_date'));		
		$campaign_id		= 	clean_data($this->input->post('campaign'));
		$creative_id		=   clean_data($this->input->post('creative'));
		$zonelimit_id		= 	clean_data($this->input->post('zonelimit'));
		$traffic_id		= 	clean_data($this->input->post('trafficsource'));
		$tracker_id		= 	clean_data($this->input->post('pixeltracker'));
		$bidding_id		= 	clean_data($this->input->post('countrybidding'));
		$api_key 	= 	get_session('api_key');
		
		$input = array(
						'api_key'	=>	$api_key,
						'device'	=>	$device,
						'from_date' => $from_date,
						'to_date'   => $to_date				
					  );
		
						
		if($campaign_id != 'all'){
			$input['campaign_id'] = ($campaign_id)?((is_array($campaign_id))?$campaign_id:explode(',',$campaign_id)):'';
		}
		
		if($creative_id != 'all'){
			$input['banner_id'] = ($creative_id)?((is_array($creative_id))?$creative_id:explode(',',$creative_id)):'';
		}
		
		if($zonelimit_id != 'all'){
			$input['zonelimit_id'] = ($zonelimit_id)?((is_array($zonelimit_id))?$zonelimit_id:explode(',',$zonelimit_id)):'';
		}
		if($traffic_id != 'all'){
			$input['traffic_id'] = ($traffic_id)?((is_array($traffic_id))?$traffic_id:explode(',',$traffic_id)):'';
		}
		if($tracker_id != 'all'){
			$input['tracker_id'] = ($tracker_id)?((is_array($tracker_id))?$tracker_id:explode(',',$tracker_id)):'';
		}
		if($bidding_id != 'all'){
			$input['bidding_id'] = ($bidding_id)?((is_array($bidding_id))?$bidding_id:explode(',',$bidding_id)):'';
		}	
			
		$data			= $this->rest->post('api/v1/app_settings/fetch',$input,'json');
		//print_r($input);
		//$this->rest->debug();
		echo convert_to_datatable_format($data);  
		
	}

	//mass email
	public function mass_email()
	{
		$data['page_title'] = "Mass Email";	
		$data['breadcrumb'] = '';
		$data['advertiser']	=	$this->rest->get('api/v1/advertiser/mass_email_fetch',array('api_key'=>get_session('api_key')),'php');
		$data['adv_count'] = count($data['advertiser']);
		$data['publisher']	=	$this->rest->get('api/v1/publisher/mass_email_fetch',array('netid'=>'2','api_key'=>get_session('api_key')),'php');
		$email_names = array_column($data['publisher'], 'email');

		$data['pubs_role_info']	=	$this->rest->get('api/v1/network/pubs_role_info',array('email_names'=>$email_names,'api_key'=>get_session('api_key')),'php');
		
		$data['temp_list']		= 	$this->rest->get('api/v1/newsletter_template/fetch_temp_deletion',array("api_key"=>get_session('api_key')),'php');
				
		//print_r($data['pubs_role_info']);exit;
		$data['user_role_info']	=	$this->rest->get('api/v1/network/user_role_info',array('api_key'=>get_session('api_key')),'php');
		
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
		$data['state']=$this->rest->get('api/v1/utilities/statelist',array('api_key'=>get_session('api_key')),'php');
		$data['search_date'] 	= 	get_search_date($set['ADVERTISER']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);
		$data['pub_count'] = count($data['publisher']);
		$data['increment_val']=250;
		$data['content'] = $this->load->view('settings/mass_email',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}

	public function notification_center()
	{
		$data['page_title'] = "Notification center";	
		$data['breadcrumb'] = '';
		$api_key = get_session('api_key');
		
		$data['to_id']	= $this->rest->get('api/v1/message/fetch_receiever_id',array('api_key'=>get_session('api_key')),'php');
		
		$data['inbox'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'inbox'),'php');
	
		$data['sent'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'sent'),'php');
		$data['trash'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'trash'),'php');
		$data['reciever_det']			= 	$this->rest->get('api/v1/message/fetch_data',array('api_key'=>get_session("api_key")),'php');
		
	
		$data['content'] = $this->load->view('settings/notification_center',$data,TRUE);	
		
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
		
	}

	public function notification_center_list()
	{
		$data['inbox'] 			= 	$this->rest->get('api/v1/message/fetch_messagenotify_list',array('api_key'=>get_session('api_key'),'message_type'=>'Creative added'),'json');
		
			echo convert_to_datatable_format($data['inbox']);  
	}
	public function fetch_notify_msg($step=false)
	{	
	//	$step=$_GET['step'];
		//$step=$this->input->POST('step');
		if($step == 'step1')
		{
		$message_type = 'campaign_setting';
		}
		elseif($step == 'step2')
		{
		$message_type = 'Impression Limit Reached';
		}
		elseif($step == 'step3')
		{
		$message_type = 'payment_setting';
		}
		elseif($step == 'step4')
		{
		$message_type = 'network_setting';
		}
		elseif($step == 'step5')
		{
		$message_type = 'setting_information';
		}
		elseif($step == 'step6')
		{
		$message_type = 'login_security';
		}
		else if($step == 'step7')
		{
		$message_type = 'all';	
		}
		
		$data['message_type'] 			= 	$this->rest->get('api/v1/message/fetch_messagenotify_list',array('api_key'=>get_session('api_key'),'message_type'=>$message_type),'json');
		
		echo convert_to_datatable_format($data['message_type']);  
		
		
	}
	public function delete_notification_msg()
	{
	$msg_id = $this->input->post('msg_id');
	$data['msg'] 			= 	$this->rest->get('api/v1/message/delete_notify_message',array('api_key'=>get_session('api_key'),'msg_id'=>$msg_id),'php');
	echo json_encode($data['msg']);
	}
	
	public function save_image()
	{		
		//$imagedata = $_POST['imgdata'];
		$imagedatas = $_POST['imagedata'];
		//$file_name = $_POST['fil_name'];
		$tags = $_POST['tags'];
		$content = file_get_contents($imagedatas);
		$package_path = explode('application',dirname(__DIR__));
			$fi = new FilesystemIterator($package_path[0].$this->config->item('read_template_data'), FilesystemIterator::SKIP_DOTS);
			$files_count = iterator_count($fi);
			if(empty($file_name))
			{
				$files_count = $files_count + 1;
				$file_name = 'Template '.$files_count.'.html';
				$img_file_name = 'Template '.$files_count.'.png';
			}
				
		$file_url = $package_path[0].$this->config->item('read_template_image').$img_file_name;
		$fp = fopen($file_url, "w");
		fwrite($fp, $content);
		fclose($fp); 
		$file_url1 = $package_path[0].$this->config->item('read_template_data').$file_name;
		$fp1 = fopen($file_url1, "w");
		fwrite($fp1, $tags);
		fclose($fp1); echo $file_url.$file_url1;exit;		
	}	
}
