<?php 
class Network extends CI_Controller
{
   function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->load->helper('download');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}

	function index()
	{
		$this->countrywise_bidding();  
	}

	/*
	 * 
	 * name		:countrywise_bidding
	 * @param   :Null
	 * @return  :List the countrywise bidding for particular Advertiser
	 */	

	public function countrywise_bidding()
	{
		$data['page_title'] = "Countrywise Bidding";
		$data['selected_country']=$this->rest->get('api/v1/countrywise_bidding/fetch_biddingcountrylist',array('api_key'=>get_session('api_key')),'php');
		
		$data['country_data'] = $this->rest->get('api/v1/countrywise_bidding/fetch_unbiddingcountrylist',array("api_key"=>get_session('api_key')),'php');		
		$data['campaign_data'] =$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');	
		$data['campaign_type']	= $this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');  
		
		$data['content'] = $this->load->view('bidding/countrywise_bidding',$data,TRUE);
		$this->template->set_layout('advertiser_layout');  
		$this->template->build('view', $data);
	}
	public function import_countrywise()
	{
		
		$data['content'] = $this->load->view('bidding/modal_bidding/content/import_countrywise_bidding',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	
	}
	 public function countrywiseexport_url()
	{
		$this->session->unset_userdata('adv_countrywise_export_url_id');
		$this->session->set_userdata('adv_countrywise_export_url_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('adv_countrywise_export_url_id'));
		
	}
	public function countrywiseexport()
	{
		
		$data['campaign_id'] = $this->session->userdata('adv_countrywise_export_url_id');
		$data['content'] = $this->load->view('bidding/export_countrywise',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	public function edit_countrywise_id()
	{
		$this->session->unset_userdata('network_countrywise_edit_id');
		$this->session->set_userdata('network_countrywise_edit_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('network_countrywise_edit_id'));
	}	
	
	public function fetch_country_list()
	{
		$country_list	  = $this->rest->get('api/v1/countrywise_bidding/fetch_biddingcountrylist',array('api_key'=>get_session('api_key')),'json');		
		echo convert_to_datatable_format($country_list);
	}
//country sample file download 
	function countrywise_import_download_file()
	{ 
		
		$data = file_get_contents("./csv/upload/countrywise_import.csv"); // Read the file's contents			
		$name = 'countrywise_import.csv';
		force_download($name, $data);  
	}
	
	function countrywise_import_download_file_txt()
	{ 
		$data = file_get_contents("./csv/upload/countrywise_import.txt"); // Read the file's contents			
		$name = 'countrywise_import.txt';
		force_download($name, $data);    
	}
	function countrywise_import_download_file_xml()
	{ 
		$data = file_get_contents("./csv/upload/countrywise_import.xml"); // Read the file's contents			
		$name = 'countrywise_import.xml';
		force_download($name, $data);    
	}
		
	//export countrywise download
	function export_download($campaign_id=false,$format=false)
	{
									
		$campaignid= rawurldecode($campaign_id);  
		
					
		if($campaignid!=false)
		{	
			//$export_list=$this->rest->get('api/v1/campaign/testing',array('campaignid'=>$campaignid,'api_key'=>get_session('api_key')),'php');
			
			$country_list = 	$this->rest->get('api/v1/countrywise_bidding/fetch_country_export_data',array("campaign_id"=>$campaignid,"api_key"=>get_session('api_key')),'json');

			$listed_data = json_decode($country_list, true);
																					
			foreach($listed_data as $cam_id)
			{
			$cam[]=$cam_id['c_id'];						
			}	
			$imp=implode(',',$cam);
									
			$cmp_s= str_replace(",","_geoid_",$imp);
			if($cmp_s)
			{
				$cmp_fn='geoid_'.$cmp_s;
			}
			else
			{
				$cmp_fn='geoid_'.$imp;
			}
			
			if($format=="csv")
			{				
					$filename=$cmp_fn.'.csv';
					header('Content-type: text/csv');
					header('Content-Disposition: attachment; filename='.$filename);
					ob_clean();
					$csv = "campaignid,account_id,campaignname,revenue_type,country_value,bidding_value,status,admarket\n";
					
					for($i=0;$i<count($listed_data);$i++){
						
						$csv.= $listed_data[$i]['campaignid'].','.$listed_data[$i]['account_id'].','.$listed_data[$i]['campaignname'].','.$listed_data[$i]['revenue_type'].','.$listed_data[$i]['country_value'].','.$listed_data[$i]['bidding_value'].','.$listed_data[$i]['status'].','.$listed_data[$i]['admarket']."\n";
					}
					
					print_r($csv);  
			}
			else if($format =='txt')
			{
				$listed_txt = array ();
				$delimiter = "\t";
				$filename=$cmp_fn.'.txt';
				header('Content-type: text/tab-separated-values');
				header("Content-Disposition: attachment;filename=".$filename);	
				ob_clean();				
				$txt = "campaignid,account_id,campaignname,revenue_type,country_value,bidding_value,status,admarket\n";		
											
				for($i=0;$i<count($listed_data);$i++)
				{					
					$txt.= $listed_data[$i]['campaignid'].','. $listed_data[$i]['account_id'].','.$listed_data[$i]['campaignname'].','.$listed_data[$i]['revenue_type'].','.$listed_data[$i]['country_value'].','.$listed_data[$i]['bidding_value'].','.$listed_data[$i]['status'].','.$listed_data[$i]['admarket']."\n";
				}	
				print_r($txt); 		
						
			}
			else if($format =='xml')
			{
				$filename=$cmp_fn.'.xml';
				header('Content-Type: text/xml');
				header("Content-Disposition: attachment;filename=".$filename);
				ob_clean();
				$xml = new SimpleXMLElement('<country/>');
				$xml->addAttribute("xmlns", "http://tempuri.org/ds.xsd");
				for($i=0;$i<count($listed_data);$i++)
				{
						$cam_list = $xml->addChild("country");
						$cam_list->addChild('campaignid',$listed_data[$i]['campaignid']);
						$cam_list->addChild('account_id',$listed_data[$i]['account_id']);
						$cam_list->addChild('campaignname',$listed_data[$i]['campaignname']);
						$cam_list->addChild('revenue_type', $listed_data[$i]['revenue_type']);
						$cam_list->addChild('country_value', $listed_data[$i]['country_value']);
						$cam_list->addChild('bidding_value', $listed_data[$i]['bidding_value']);
						$cam_list->addChild('status', $listed_data[$i]['status']);
						$cam_list->addChild('admarket', $listed_data[$i]['admarket']);
				}
				print($xml->asXML());
				
			}			
		}
		
	}
	
 


	public function S2S_Tracking()
	{		
		$data['breadcrumb'] = '';
		$data['content'] = $this->load->view('campaigns/s2scode',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	/*
	 * 
	 * name		:macro listing
	 * @param   :Null
	 * @return  :shows the macro usage
	 */		
	public function macros()
	{         
		$data['page_title'] 	= 	"Manage your Macros";
		$data['content'] = $this->load->view('macros/manage_macros',$data,TRUE);
	    $this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}		
	/*
	 * 
	 * name		:add_countrywise_bidding
	 * @param   :Null
	 * @return  :Loads the country
	 */	

	public function add_countrywise_bidding()
	{
			
		$data['country_data'] = $this->rest->get('api/v1/countrywise_bidding/fetch_unbiddingcountrylist',array("api_key"=>get_session('api_key')),'php');
		
		$data['campaign_data'] =$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
		
		$data['campaign_type']	= $this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		echo $this->load->view('bidding/modal_bidding/content/add_countrywise_bidding',$data);	
	}
	
	/*
	 * 
	 * name		:edit_countrywise_bidding
	 * @param   :Null
	 * @return  :Loads the country
	 */	

	public function edit_countrywise_bidding($country_id=false)
	{
		$country_id	=	 $this->session->userdata('network_countrywise_edit_id');
		$data['country_data'] = $this->rest->get('api/v1/countrywise_bidding/fetch_countrylist',array("api_key"=>get_session('api_key')),'php');
			
		$data['campaign_data'] =$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
		
		$data['campaign_type']		= $this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['countrybidding_data'] = $this->rest->get('api/v1/countrywise_bidding/editcountrylist',array("id"=>$country_id,"api_key"=>get_session('api_key')),'php');
		
		//echo $this->load->view('bidding/modal_bidding/content/edit_countrywise_bidding',$data);	
		$data['content'] = $this->load->view('bidding/modal_bidding/content/edit_countrywise_bidding',$data,TRUE);
		$this->template->set_layout('advertiser_layout');  
		$this->template->build('view', $data);
	}
	
	
	/* Zone bidding */	 
	public function zone_bidding()
	{ 
		$data['page_title'] = "Zone Bidding";
		
$data['zone_data'] =	$this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>get_session('api_key')),'php');
						
		$data['camp_lists']=$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
						
		$data['content'] = $this->load->view('zone_bidding/manage_zone_bidding',$data,TRUE);
	
		$this->template->set_layout('advertiser_layout');
	    	
		$this->template->build('view', $data);
	}
	public function import_zone_bidding()
	{
	
		$data['content'] = $this->load->view('zone_bidding/modal_zone_bidding/content/import_zone_bidding',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	
	}
	 public function zonebiddingexport_url()
	{
		$this->session->unset_userdata('zone_bidding_export_id');
		$this->session->set_userdata('zone_bidding_export_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('zone_bidding_export_id'));
		
	}
	public function zonebiddingexport()
	{
		
		$data['campaign_id'] = $this->session->userdata('zone_bidding_export_id');
		$data['content'] = $this->load->view('zone_bidding/export_zone_bidding',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	public function zone_limitation()
	{ 		
		$data['page_title'] = "Zone Limitation";
		$data['traffic_source']=$this->rest->get('api/v1/zone_limitations/fetch_traffic_sources',array("api_key"=>get_session('api_key')),'php');		
		$data['zone_list']=$this->rest->get('api/v1/zone_limitations/fetch_filter_zone',array("api_key"=>get_session('api_key')),'php');		
		$data['content'] = $this->load->view('zone_limitation/manage_zone_limitation',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	public function import_zonelimitation()
	{
	
		$data['content'] = $this->load->view('zone_limitation/modal_zone_limitation/content/import_zonelimit',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	
	}
	 public function zonelimitation_url()
	{
		$this->session->unset_userdata('zone_limitation_export_id');
		$this->session->set_userdata('zone_limitation_export_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('zone_limitation_export_id'));
		
	}
	public function zonelimitationexport()
	{
		
		$data['campaign_id'] = $this->session->userdata('zone_limitation_export_id');
		$data['content'] = $this->load->view('zone_limitation/export_zonelimits',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	public function fetch_zone_limitation_list()
	{
		$zonelist_list	  = $this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key')),'json');		
	    echo convert_to_datatable_format($zonelist_list);
	}
	/*
	 * 
	 * name		:add_zone_limitation
	 * @param   :Null
	 * @return  :Loads the zoneids
	 */	

	public function add_zone_limitation()
	{
		
		  $zone_list  = $this->rest->get('api/v1/zone_limitations/fetch_zonelist',array('api_key'=>get_session('api_key')),'php');	
		   $data['site_url_block']		= 	$this->rest->get('api/v1/zone_limitations/fetch_url_block_list',array('api_key'=>get_session('api_key')),'php');
		  
		   $site_url_data		= 	$this->rest->get('api/v1/zone_limitations/fetch_url_site_list',array('api_key'=>get_session('api_key')),'php');
		   $zone_site_data=array();
		   
		   $unsetzone_list = $this->rest->get('api/v1/zone_limitations/fetch_list_unsetzone_list',array('api_key'=>get_session('api_key')),'php');			
           $zone_list_array = array();
           foreach($zone_list as $zone){
           		$zone_list_array[] = $zone['zoneid'];
           }
           $unsetzone = array();
           foreach($unsetzone_list as $unset){
           	$unsetzone = array_merge($unsetzone, explode(',',$unset['selected_zone_ids']));
           }
           $result=  array_diff($zone_list_array, $unsetzone);
           $data['zone_list'] =$result;
           $data['content'] = $this->load->view('zone_limitation/modal_zone_limitation/content/add_list',$data,TRUE);
			$this->template->set_layout('advertiser_layout');
			$this->template->build('view', $data);
	}
	
		public function edit_zone_limitation_id()
	{
		$this->session->unset_userdata('network_zone_limitation_edit_id');
		$this->session->set_userdata('network_zone_limitation_edit_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('network_zone_limitation_edit_id'));
	}	
	
	/*
	 * 
	 * name		:edit_zone_limitation
	 * @param   :Null 
	 * @return  :Loads the zone
	 */	

	public function edit_zone_limitation($advertiser_id=false)
	{
		$advertiser_id	=	 $this->session->userdata('network_zone_limitation_edit_id');
		$zone_list= $this->rest->get('api/v1/zone_limitations/fetch_zonelist',array('api_key'=>get_session('api_key')),'php');
		$unsetzone_list = $this->rest->get('api/v1/zone_limitations/fetch_list_unsetzone_list',array('api_key'=>get_session('api_key')),'php');		
		$data['site_url_block']		= 	$this->rest->get('api/v1/zone_limitations/fetch_url_block_list',array('api_key'=>get_session('api_key')),'php');	
		$zone_list_array = array();
		foreach($zone_list as $zone){
			$zone_list_array[] = $zone['zoneid'];
		}
		$unsetzone = array();
		foreach($unsetzone_list as $unset){
			$unsetzone = array_merge($unsetzone, explode(',',$unset['selected_zone_ids']));
		}

		$result=  array_diff($zone_list_array, $unsetzone);
		$data['zone_limitation_data'] = $this->rest->get('api/v1/zone_limitations/edit_zone_limitation',array("id"=>$advertiser_id,"api_key"=>get_session('api_key')),'php');
		$data['zone_list'] =array_merge($result, explode(',',$data['zone_limitation_data'][0]['zoneids']));
	// 	echo $this->load->view('zone_limitation/modal_zone_limitation/content/edit_list',$data);	
	 	 $data['content'] = $this->load->view('zone_limitation/modal_zone_limitation/content/edit_list',$data,TRUE);
			$this->template->set_layout('advertiser_layout');
			$this->template->build('view', $data);
	}
	
	public function filter_country($campaignid=false,$revenueid=false)
	{
		$data['campaign_data'] = $this->rest->get('api/v1/countrywise_bidding/filter_country',array("api_key"=>get_session('api_key'), "campaignid" => $campaignid, "revenueid" => $revenueid),'php');
		echo $this->load->view('bidding/modal_bidding/content/filtercountry',$data);	
	}
	
	public function traffic_sources()
	{ 
        $data['page_title'] = "Traffic Sources";
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher_traffic',array("api_key"=>get_session('api_key')),'php');
		
		$data['camp_lists']=$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
		
		$data['traffic_sourced_list']= $this->rest->get('api/v1/network/fetch_traffic_sources',array("api_key"=>get_session('api_key')),'php');
		
		//echo $this->rest->debug();  die("123");
		
		$data['content'] = $this->load->view('special_bidding/traffic_sources',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	public function import_trafficsources()
	{
		
		$data['content'] = $this->load->view('special_bidding/traffic_layout',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	
	}
	 public function trafficsources_url()
	{
		$this->session->unset_userdata('adv_trafficsources_export_url_id');
		$this->session->set_userdata('adv_trafficsources_export_url_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('adv_trafficsources_export_url_id'));
		
	}
	public function trafficsourcesexport()
	{
		
		$data['campaign_id'] = $this->session->userdata('adv_trafficsources_export_url_id');
		$data['content'] = $this->load->view('special_bidding/export_traffic',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	public function traffic_sources_adv_list()
	{
		$advertiser_camp_id=$this->rest->get('api/v1/network/fetch_traffic_sources',array("api_key"=>get_session('api_key')),'json');
		
		echo convert_to_datatable_format($advertiser_camp_id);
	}
	
	/*public function traffic_sources_remove_list()
	{
		 $post = clean_data($this->post());
		 print_r($post); exit;
	}*/
	
	/*
	* 
	* name		:network
	* @param   :Null
	* @return  :Network page
	*/	
	 
	function networkkit()
	{		
		$data['page_title'] = 	"Media Kit";

		$data['breadcrumb'] = 	'';
		
		$data['api_key']			=	get_session('api_key');
		
		$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('netid'=>'2','api_key'=>get_session('api_key')),'php');
		
		$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>get_session('api_key')),'php');
		
		$data['browsers']		= 	$this->rest->get('api/v1/targeting/fetch_browsers',array('api_key'=>get_session('api_key')),'php');
		
		$data['os']				= 	$this->rest->get('api/v1/targeting/fetch_os',array('api_key'=>get_session('api_key')),'php');
				
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'	=>	$data['api_key']),'php');
		
		$set = $this->config->item('report_config');
				
		$data['search_date'] 	= 	get_search_date($set['ADVERTISER']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'	=>	$data['api_key']),'php');
		
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
						
		$data['content'] 		= 	$this->load->view('reports/network',$data,TRUE);
			//print_r($data['pub_data']);die;				
		$this->template->set_layout('advertiser_layout');
		
		$this->template->build('view', $data);
	}
	
	public function fetch_network_stat($format='json',$c,$from_date,$to_date)
	{
		
		$api_key		=	get_session('api_key');		
		
		$account_type 	= 	get_session('account_type');
		$page			= 	'REPORT_GEO_GRAPHICAL';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type,
						'stat_type'		=>	'NETWORK',
					  );
					  
		$env 		= 	$this->input->post('env');
		
		$country 	= 	$this->input->post('country');
		$adsize		= 	clean_data($this->input->post('adsize'));
		$camtyp 	= 	clean_data($this->input->post('revtype'));		
		$pub_id		= 	clean_data($this->input->post('publisher'));
		$adb_id		= 	clean_data($this->input->post('adblock'));
		$brow		= 	clean_data($this->input->post('browser'));
		$os			= 	clean_data($this->input->post('os'));
		//~ $dimensions	= 	clean_data($this->input->post('dimensions'));
		 $dimensions= array();
		 if($this->input->post('impression'))
		 {
			 $dimensions['impression']=$this->input->post('impression');
		 }
		 if($this->input->post('impression'))
		 { 
			 $dimensions['click']=$this->input->post('click');
		 }
		 if($this->input->post('impression'))
		 {
			 $dimensions['conversion']=$this->input->post('conversion');
		 }
		if($from_date == NULL){
		  $from_date = $this->input->post('from_date');
		}
		if($to_date == NULL){
			$to_date = $this->input->post('to_date');
		}
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		$input['dimensions'] = $dimensions;
		 	
		
		if($country != 'all'){
			$input['country_id'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
		
		if($camtyp != 'all'){
			$input['camtyp'] = ($camtyp)?((is_array($camtyp))?$camtyp:explode(',',$camtyp)):'';
		}
		
		if($pub_id != 'all'){
			$input['pub_account_id'] = ($pub_id)?((is_array($pub_id))?$pub_id:explode(',',$pub_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}
		
		if($brow != 'all'){
			$input['browser'] = ($brow)?((is_array($brow))?$brow:explode(',',$brow)):'';
		}
		
		if($os != 'all'){
			$input['os'] = ($os)?((is_array($os))?$os:explode(',',$os)):'';
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
					  
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
			
		$data	= 	$this->rest->post('api/v1/report/fetch',$input,'json');
		
		//$this->rest->debug();
		//~ echo $this->rest->debug();exit;
		echo $data;  
	
	}

	function download($zlimit_id=false,$format=false)
	{
		$zlid= rawurldecode($zlimit_id);  
		if($zlid!=false)
		{	
			//$export_list=$this->rest->get('api/v1/campaign/testing',array('campaignid'=>$campaignid,'api_key'=>get_session('api_key')),'php');
			
			$limit_list = 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array("zonelimit_id"=>$zlid,"api_key"=>get_session('api_key')),'json');
			
			$listed_data = json_decode($limit_list, true);		
				
			foreach($listed_data as $cam_id)
			{
			$cam[]=$cam_id['id'];
			}	
			$imp=implode(',',$cam);
			$cmp_s= str_replace(",","_zid_",$imp);
			if($cmp_s)
			{
				$cmp_fn='zid_'.$cmp_s;
			}
			else
			{
				$cmp_fn='zid_'.$imp;
			}			
			if($format=="csv")
			{				
					$filename=$cmp_fn.'.csv';
					header('Content-type: text/csv');
					header('Content-Disposition: attachment; filename='.$filename);
					ob_clean();

					$csv = "Name,Type,Zone_ids\n";
					
					for($i=0;$i<count($listed_data);$i++){
						
						if($listed_data[$i]['type']=="Black List")
						{
							$zone_list_type=0;
						}
						else
						{
							$zone_list_type=1;  
						}
						
						$csv.= $listed_data[$i]['name'].','.$zone_list_type.','.str_replace(",","_",$listed_data[$i]['zoneids'])."\n";
					}
					
					print_r($csv);  
			}
			else if($format =='txt')
			{
				//$listed_txt = array();
				$delimiter = "\t";
				$filename=$cmp_fn.'.txt';
				header('Content-type: text/tab-separated-values');
				header("Content-Disposition: attachment;filename=".$filename);
				ob_clean();				
				$listed_txt = "Name,Type,Zone_ids\n";							
				for($i=0;$i<count($listed_data);$i++)
				{
					if($listed_data[$i]['type']=="Black List")
						{
							$zone_list_type=0;
						}
						else
						{
							$zone_list_type=1;  
						}
						
					$listed_txt.= $listed_data[$i]['name'].','.$zone_list_type.','.str_replace(",","_",$listed_data[$i]['zoneids'])."\n";
				}				
				 print_r($listed_txt); 				
			}
			else if($format =='xml')
			{
				$filename=$cmp_fn.'.xml';
				header('Content-Type: text/xml');
				header("Content-Disposition: attachment;filename=".$filename);
				ob_clean();
				$xml = new SimpleXMLElement('<Advertiser/>');
				$xml->addAttribute("xmlns", "http://tempuri.org/ds.xsd");
				for($i=0;$i<count($listed_data);$i++)
				{
						if($listed_data[$i]['type']=="Black List")
						{
							$zone_list_type=0;
						}
						else
						{
							$zone_list_type=1;  
						}
					
						$zonelimit_list = $xml->addChild("Zonelimitation");
						$zonelimit_list->addChild('Name',$listed_data[$i]['name']);
						$zonelimit_list->addChild('Type', $zone_list_type);
						$zonelimit_list->addChild('Zone_ids', $listed_data[$i]['zoneids']);
											
				}
				print($xml->asXML());
				
			}			
		}
		
	}
function download_traffic($traffic_id=false,$format=false)
	{
		$tid= rawurldecode($traffic_id); 
		if($tid!=false)
		{				
			$traffic_list = 	$this->rest->get('api/v1/countrywise_bidding/fetch_traffic_sources',array("traffic_ids"=>$tid,"api_key"=>get_session('api_key')),'json');
			
			$listed_data = json_decode($traffic_list, true); 
			foreach($listed_data as $cam_id)
			{
			$cam[]=$cam_id['c_id'];						
			}	
			$imp=implode(',',$cam);
									
			$cmp_s= str_replace(",","_sid_",$imp);
			if($cmp_s)
			{
				$cmp_fn='sid_'.$cmp_s;
			}
			else
			{
				$cmp_fn='sid_'.$imp;  
			}
							
			
			if($format=="csv")
			{				
					$filename=$cmp_fn.'.csv';
					header('Content-type: text/csv');
					header('Content-Disposition: attachment; filename='.$filename);
					ob_clean();
					$csv = "account_id,campaignid,bidding_type,sourceid,bidrate,status,admarket\n";
					
					for($i=0;$i<count($listed_data);$i++){
						
						$csv.= $listed_data[$i]['account_id'].','.$listed_data[$i]['campaignid'].','.$listed_data[$i]['bidding_type'].','.$listed_data[$i]['sourceid'].','.$listed_data[$i]['bidrate'].','.$listed_data[$i]['status'].','.$listed_data[$i]['admarket']."\n";   
					}
					
					print_r($csv);  
			}			
			else if($format =='txt')
			{
				$listed_txt = array();
				$delimiter = "\t";
				$filename=$cmp_fn.'.txt';
				header('Content-type: text/tab-separated-values');
				header("Content-Disposition: attachment;filename=".$filename);
				ob_clean();								
			    $listed_txt	="accountid,campaignid,bidding_type,sourceid,bidrate,status,admarket\n";					
				for($i=0;$i<count($listed_data);$i++)
				{
					$listed_txt.= $listed_data[$i]['account_id'].','.$listed_data[$i]['campaignid'].','.$listed_data[$i]['bidding_type'].','.$listed_data[$i]['sourceid'].','.$listed_data[$i]['bidrate'].','.$listed_data[$i]['status'].','.$listed_data[$i]['admarket']."\n";					
				}				
				print_r($listed_txt); 			
			}
			else if($format =='xml')
			{
				$filename=$cmp_fn.'.xml';
				header('Content-Type: text/xml');
				header("Content-Disposition: attachment;filename=".$filename);
				ob_clean();				
				$xml = new SimpleXMLElement('<Advertiser/>');
				$xml->addAttribute("xmlns", "http://tempuri.org/ds.xsd");
				for($i=0;$i<count($listed_data);$i++)
				{
						$zonelimit_list = $xml->addChild("Trafficsource");
						$zonelimit_list->addChild('accountid',$listed_data[$i]['account_id']);
						$zonelimit_list->addChild('campaignid',$listed_data[$i]['campaignid']);
						$zonelimit_list->addChild('bidding_type',$listed_data[$i]['bidding_type']);
						$zonelimit_list->addChild('sourceid', $listed_data[$i]['sourceid']);
						$zonelimit_list->addChild('bidrate', $listed_data[$i]['bidrate']);
						$zonelimit_list->addChild('status', $listed_data[$i]['status']);
						$zonelimit_list->addChild('admarket', $listed_data[$i]['admarket']);
											
				}
				print($xml->asXML());
				
			}			
		}
		
	}

	function zone_import_download_file()
	{
		
		$data = file_get_contents("./csv/upload/zonelimit_import.csv"); // Read the file's contents			
		$name = 'zonelimit_import.csv'; 
		force_download($name, $data);  
	}
	
	function zone_import_download_file_txt()
	{ 
		$data = file_get_contents("./csv/upload/zonelimit_import.txt"); // Read the file's contents			
		$name = 'zonelimit_import.txt';
		force_download($name, $data);    
	}
	function zone_import_download_file_xml()
	{ 
		$data = file_get_contents("./csv/upload/zonelimit_import.xml"); // Read the file's contents			
		$name = 'zonelimit_import.xml';
		force_download($name, $data);    
	}
	function traffic_import_download_file()
	{
		
		$data = file_get_contents("./csv/upload/traffic_import.csv"); // Read the file's contents			
		$name = 'traffic_import.csv'; 
		force_download($name, $data);  
	}
	
	function traffic_import_download_file_txt()
	{ 
		$data = file_get_contents("./csv/upload/traffic_import.txt"); // Read the file's contents			
		$name = 'traffic_import.txt';
		force_download($name, $data);    
	}
	function traffic_import_download_file_xml()
	{ 
		$data = file_get_contents("./csv/upload/traffic_import.xml"); // Read the file's contents			
		$name = 'traffic_import.xml';
		force_download($name, $data);    
	}
	//top geo
	function top_geos()
	{
		$data['page_title'] = "Top Geos";   
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['api_key']			=	get_session('api_key');
		$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
		
		$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>get_session('api_key')),'php');
		
		$data['browsers']		= 	$this->rest->get('api/v1/targeting/fetch_browsers',array('api_key'=>get_session('api_key')),'php');
		
		$data['os']				= 	$this->rest->get('api/v1/targeting/fetch_os',array('api_key'=>get_session('api_key')),'php');
				
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'	=>	$data['api_key']),'php');
		
		$set = $this->config->item('report_config');
				
		$data['search_date'] 	= 	get_search_date($set['ADVERTISER']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'	=>	$data['api_key']),'php');
		
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
						
		
		$data['content'] = $this->load->view('network/top_geos',$data,TRUE);
	
		
		$this->template->set_layout('advertiser_layout');
	    
		$this->template->build('view', $data);
	}
	function top_sources()
	{
		$data['page_title'] = "Top Sources";   
		//$data['traffic_sourced_list'] =	$this->rest->get('api/v1/report/fetch_top_sources',array("api_key"=>get_session('api_key')),'php');    	
		//echo $this->rest->debug(); die();
		$data['content'] = $this->load->view('network/top_sources',$data,TRUE);
		$format=$_POST['page'];
		if($format=='ajaxcall')
		{
		$this->template->set_layout('advertiser_content');
	    }
	    else
	    {
		$this->template->set_layout('advertiser_layout');
	    }
		$this->template->build('view', $data);
	}
				
	public function fetch_top_sources_list()
	{ 
		$topsources_list	  = $this->rest->get('api/v1/report/fetch_top_sources',array('api_key'=>get_session('api_key')),'json');		
		echo convert_to_datatable_format($topsources_list);
	}
	
	function top_zones()
	{
		$data['page_title'] = "Top Zones";   
		/*$data['traffic_sourced_list'] =	$this->rest->get('api/v1/report/fetch_top_zones',array("api_key"=>get_session('api_key')),'php');     	*/
		//echo $this->rest->debug(); die();
		$data['content'] = $this->load->view('network/top_zones',$data,TRUE);
		$format=$_POST['page'];
		if($format=='ajaxcall')
		{
		$this->template->set_layout('advertiser_content');
	    }
	    else
	    {
		$this->template->set_layout('advertiser_layout');
	    }
		$this->template->build('view', $data);
	}
				
	public function fetch_top_zones_list()
	{ 
		$topzones_list	  = $this->rest->get('api/v1/report/fetch_top_zones',array('api_key'=>get_session('api_key')),'json');		
		echo convert_to_datatable_format($topzones_list);
	}
	
				
	public function fetch_top_geos_list()
	{ 
		$topgeos_list	  = $this->rest->get('api/v1/report/fetch_top_geos',array('api_key'=>get_session('api_key')),'json');		
		echo convert_to_datatable_format($topgeos_list);
	}
	
		
	//export zonebidding download
	function export_zonebidding_download($zone_bid_id=false,$format=false)
	{
					
		$zonebid_id= rawurldecode($zone_bid_id);  
							
		if($zonebid_id!=false)
		{		
			$zonebid_list = 	$this->rest->get('api/v1/countrywise_bidding/fetch_zonebidding_export_data',array("zone_bid_id"=>$zonebid_id,"api_key"=>get_session('api_key')),'json');
			//print_r($zonebid_list);exit;		
			$listed_data = json_decode($zonebid_list, true);
			
			foreach($listed_data as $cam_id)
			{
			$cam[]=$cam_id['c_id'];						
			}	
			$imp=implode(',',$cam);
									
			$cmp_s= str_replace(",","_zbid_",$imp);
			if($cmp_s)
			{
				$cmp_fn='zbid_'.$cmp_s;
			}
			else
			{
				$cmp_fn='zbid_'.$imp;
			}
			
			
			if($format=="csv")
			{				
					$filename=$cmp_fn.'.csv';
					header('Content-type: text/csv');
					header('Content-Disposition: attachment; filename='.$filename);
					ob_clean();
					$csv = "account_id,campaignid,bidding_type,zone_id,bidrate,status,admarket\n";
					
					for($i=0;$i<count($listed_data);$i++){
						
						$csv.= $listed_data[$i]['account_id'].','.$listed_data[$i]['campaignid'].','.$listed_data[$i]['bidding_type'].','.$listed_data[$i]['zoneid'].','.$listed_data[$i]['bidrate'].','.$listed_data[$i]['status'].','.$listed_data[$i]['admarket']."\n";   
					}
					
					print_r($csv);  
			}
			else if($format =='txt')
			{
				$listed_txt = array ();
				$delimiter = "\t";
				$filename=$cmp_fn.'.txt';
				header('Content-type: text/tab-separated-values');
				header('Content-Disposition: attachment;filename='.$filename);	
				ob_clean();
				$txt = "account_id,campaignid,bidding_type,zone_id,bidrate,status,admarket\n";
				
											
				for($i=0;$i<count($listed_data);$i++)
				{
					
					$txt.= $listed_data[$i]['account_id'].','. $listed_data[$i]['campaignid'].','.$listed_data[$i]['bidding_type'].','.$listed_data[$i]['zoneid'].','.$listed_data[$i]['bidrate'].','.$listed_data[$i]['status'].','.$listed_data[$i]['admarket']."\n";
				
				}				
					print_r($txt); 		
				
			}
			else if($format =='xml')
			{
				$filename=$cmp_fn.'.xml';
				header('Content-Type: text/xml');
				header('Content-Disposition: attachment;filename='.$filename);
				ob_clean();
				$xml = new SimpleXMLElement('<zonebidding/>');
				$xml->addAttribute("xmlns", "http://tempuri.org/ds.xsd");
				for($i=0;$i<count($listed_data);$i++)
				{
						$cam_list = $xml->addChild("zonebidding");
						$cam_list->addChild('account_id',$listed_data[$i]['account_id']);
						$cam_list->addChild('campaignid',$listed_data[$i]['campaignid']);
						$cam_list->addChild('bidding_type',$listed_data[$i]['bidding_type']);
						$cam_list->addChild('zoneid', $listed_data[$i]['zoneid']);
						$cam_list->addChild('bidrate', $listed_data[$i]['bidrate']);
						$cam_list->addChild('status', $listed_data[$i]['status']);
						$cam_list->addChild('admarket',$listed_data[$i]['admarket']);  
						}
				print($xml->asXML());
				
			}	
		}
		
	}
	function zonebidding_import_download_file()
	{ 		
		$data = file_get_contents("./csv/upload/zonebidding_import.csv"); // Read the file's contents			
		$name = 'zonebidding_import.csv';
		force_download($name, $data);  
	}
	
	function zonebidding_import_download_file_txt()
	{ 
		$data = file_get_contents("./csv/upload/zonebidding_import.txt"); // Read the file's contents			
		$name = 'zonebidding_import.txt';
		force_download($name, $data);    
	}
	function zonebidding_import_download_file_xml()
	{ 
		$data = file_get_contents("./csv/upload/zonebidding_import.xml"); // Read the file's contents			
		$name = 'zonebidding_import.xml';
		force_download($name, $data);      
	}
	
}
