<?php 
class Messages extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		
		$this->load->helper('download');
		
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		//$this->load->model('api_v.1/do_creative','asd');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->messages();		
	}
	
	/*
	 * 
	 * name		: Messages
	 * @param   : Null
	 * @return  : List all the messages for admin
	 */	
	 	
	public function messages()
	{	
		$data['page_title'] 	= 	"Messages";
		$data['breadcrumb'] 	= 	'';	
		
		$data['to_id']			= 	$this->rest->get('api/v1/message/fetch_receiever_id',array('api_key'=>get_session("api_key")),'php');
		$data['reciever_det']			= 	$this->rest->get('api/v1/message/fetch_data',array('api_key'=>get_session("api_key")),'php');
		
		$data['inbox'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session("api_key"),'message_type'=>'inbox'),'php');
		
		$data['sent'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session("api_key"),'message_type'=>'sent'),'php');
		
		$data['trash'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session("api_key"),'message_type'=>'trash'),'php');
		
		$data['content'] 		= 	$this->load->view('messages/messages',$data,TRUE);		
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}

	/*
	*    : Admarket messages
	* @param  : Null
	* @return : List all messages for admarket 
	*/

	public function admarket_messages()
	{
		$data['page_title'] 	= 	"admarket Messages";	
		$data['breadcrumb'] 	= 	'';	
		
		$data['to_id']			= 	$this->rest->get('api/v1/message/fetch_receiever_id',array('api_key'=>get_session("api_key")),'php');
		$data['reciever_det']			= 	$this->rest->get('api/v1/message/fetch_data',array('api_key'=>get_session("api_key")),'php');
		
		$data['inbox'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session("api_key"),'message_center'=>'admarket','message_type'=>'inbox'),'php');
	
		
		$data['sent'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session("api_key"),'message_type'=>'sent','message_center'=>'admarket_sent'),'php');
		
		$data['trash'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session("api_key"),'message_type'=>'trash','message_center'=>'admarket_tr'),'php');
		
		$data['content'] 		= 	$this->load->view('messages/messages',$data,TRUE);		
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}

	
	/*
	 * 
	 * name		: Messages
	 * @param   : Null
	 * @return  : List all the messages for admin
	 */	
	
	public function fetch_message($type=FALSE,$adm_msg=false)
	{
		
		$message 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session("api_key"),'message_type'=>$type,'message_center'=>$adm_msg),'json');
		//echo "test<pre>";print_r($message);exit();

		//$this->rest->debug();
		echo convert_to_datatable_format($message);
	}
	
	/*
	 * 
	 * name		: send_message
	 * @param   : Null
	 * @return  : Send new messages to advertiser/publisher
	 */	
	
	public function send_message()
	{		
		$data['to_id']	= $this->rest->get('api/v1/message/fetch_receiever_id',array('api_key'=>get_session("api_key")),'php');
		//$this->rest->debug();
		echo $this->load->view('messages/modal_messages/content/send_message',$data);		
	}
	
	/*
	 * 
	 * name		: read_message
	 * @param   : Null
	 * @return  : read messages
	 */	
	
	public function read_message($type=FALSE,$msg_id=FALSE)
	{
		$message 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session("api_key"),'message_type'=>$type,'message_id'=>$msg_id),'php');
		
		
		$data['read']		=	$message[0];
		if($type=='inbox')
		{
			$this->rest->get('api/v1/message/update_message_status',array('api_key'=>get_session("api_key"),'message_id'=>$msg_id),'php');
			
			echo $this->load->view('messages/modal_messages/content/read_reply_message',$data);		
		}
		else
		{
			echo $this->load->view('messages/modal_messages/content/read_message',$data);		
		}
	}
	
	/*
	 * 
	 * name		: fetch_message_count
	 * @param   : Null
	 * @return  : count messages
	 */	
	
	public function fetch_message_count($type=FALSE, $admarket=FALSE)
	{	
		
		$message 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>$type,'message_center'=>$admarket),'php');

		if($type=='inbox')
		{
			$inbox_count		=	0;
			if(!empty($message)):
				foreach($message as $msg):
					if($msg['status']==1)
					{
						$inbox_count	+=	1;
					}
				endforeach;
			endif;
			
			echo $inbox_count;
		}
		elseif($type=='sent')
		{	
			echo (!empty($message))?count($message):'0';		
		}
		else
		{
			echo '0';		
		}
	}
	
	/*
	 * 
	 * name		: download_file
	 * @param   : Null
	 * @return  : download image/file
	 */	
	
	public function download_file($file_name=0)
	{	
		
	/*	$testvar = glob($_SERVER["DOCUMENT_ROOT"])[0];
		$ters = str_replace('data/', '', $testvar);
		$ters = $ters.'./message/tmp_upload';
		/*echo "tt<pre>";print_r($ters);
		exit();
		$data 	= 	file_get_contents($ters.'/0202d59194f54bd1a8b32a6ce2a55f52.jpg');*/ 

		$data 	= 	file_get_contents($this->config->item('message_upload_path').'/'.$file_name); // Read the file's contents
		$name 	=	$file_name;
		force_download($name, $data);                                 
	}
	
	/*
	 * 
	 * name		: readdir()
	 * @param   : Null
	 * @return  : read messages
	 */	
	
	public function read($type=FALSE,$msg_id=FALSE)
	{	
		
		//$msg_id=$this->session->userdata('advg_edt_msg_id'); // old code
        
		  $link = $_SERVER['PHP_SELF'];
		 
          $link_array = explode('/',$link);
          $msg_id1 = end($link_array);
 
		$data['inbox'] 		= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'inbox'),'php');
		
		$data['sent'] 		= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'sent'),'php');
		$data['trash'] 		= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'trash'),'php');
		
		$message 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>$type,'message_id'=>$msg_id),'php');
		
		$data['read']		=	$message[0];
		
		
		$data['type']		=	$type;
		
		$data['msg_id']		=	$msg_id;
		
		if($type=='inbox')
		{
			$this->rest->get('api/v1/message/update_message_status',array('api_key'=>get_session('api_key'),'message_id'=>$msg_id),'php');
			
		}
		
		$data['to_id']			= 	$this->rest->get('api/v1/message/fetch_receiever_id',array('api_key'=>get_session("api_key")),'php');
		
		$data['reciever_det']			= 	$this->rest->get('api/v1/message/fetch_data',array('api_key'=>get_session("api_key")),'php');

		
		$data['content'] 		= 	$this->load->view('messages/messages',$data,TRUE);

		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
}
