<?php 
 
class Campaigns extends CI_Controller
{
    function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->load->helper('download');
		$this->load->library('user_authentication');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}

	function index()
	{
		$this->campaigns();
	}
	
	public function add_campaigns()
	{ 
		
		$data['page_title'] = "Add campaigns";

		$data['breadcrumb'] = '';
		
		/************ Video Enable/Disable *************/
		$this->load->library('default_configurations');
		
		$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
		
		//Minimum Budget & Bid Rate & creatives allowed
		$data['min_budget']		=	$this->default_configurations->get('min_budget');
		
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
		
		$data['creat_allowed']	=	$this->default_configurations->get('direct_creative_type');
		
		/************ Video Enable/Disable *************/  
		
		$data['creative_size'] 		= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'php');
		
		$data['mob_screen_size']	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>get_session('api_key')),'php');
		
		$data['lang_data'] 			=	$this->rest->get('api/v1/campaign/fetch_language',array('api_key'=>get_session('api_key')),'php');
					
		//Fetch Publisher
		$adm						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$data['pub_data'] 			=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$adm[0]['api_key'],'netid'=>'2'),'php');
		$data['adb_data'] 			=	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$adm[0]['api_key']),'php');		
		$data['preset_black']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'black'),'php');		
						
		$data['preset_white']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'white'),'php');		
		
		//URL BLOCK LIST
		$data['site_url_block']		= 	$this->rest->get('api/v1/zone_limitations/fetch_url_block_list',array('api_key'=>get_session('api_key')),'php');	
		
		/*$domain		= 	$this->rest->get('api/v1/campaign/fetch_domain',array("api_key"=>get_session('api_key')),'php');
			//print_r($domain[0]['url']);die("sdfsf");
			$data['domain_data']=	$domain[0]['url'];	*/
		//Fetch available site categories
		$data['campaign_category']	=	$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>get_session('api_key')),'php');

		$data['camp_sub_category']	=	$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>get_session('api_key')),'php');

		//Fetch Country
		$data['countrylist']		=	$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>get_session('api_key')),'php');		
		
		$data['group']				=	$this->rest->get('api/v1/creative/fetch_group',array('api_key'=>get_session("api_key")),'php');

		$data['browser_vers']		=	$this->rest->get('api/v1/creative/fetch_browser_versions',array('api_key'=>get_session("api_key")),'php');		
		
		$data['os_vers']		=	$this->rest->get('api/v1/targeting/fetch_os_version',array('api_key'=>get_session("api_key")),'php');
				
		$data['tracker']			= 	$this->rest->get('api/v1/tracker/fetch_tracker',array('api_key'=>get_session('api_key')),'php');		
		
		//Fetch available campaign type
		$data['campaign_type']		= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
	
	    //print_r($data['campaign_type']);  die();
	
		$data['target']				=	$this->targeting_list();
		
				
		/**** Cookie setup -- start ************/
		$prod_name = $this->config->item('prod_name'); 
		
		$bid_data 					=	$this->rest->get('api/v1/campaign/fetch_realtime_bidding',array('api_key'=>get_session('api_key')),'php');
						
		$data['best_bid_rate']			=	($bid_data!='error')?$bid_data[0]['best_bid_rate']:'';
		$data['min_bid_rate']			=	($bid_data!='error')?$bid_data[0]['min_bid_rate']:'';
		$data['max_bid_rate']			=	($bid_data!='error')?$bid_data[0]['max_bid_rate']:'';
		
		//Traffic sources
		$publisher_id=$this->session->userdata("buy_link_publisher_id"); 
		$data['traffic_data']			= 	$this->rest->get('api/v1/campaign/fetch_publisher_traffic',array("publisher_id"=>$publisher_id,"api_key"=>get_session('api_key')),'php');  

		$zone_id=$this->session->userdata("buy_link_zone_id");  
		$data['buy_zone_id'] = $zone_id;
		$data['zone_data']			= 	$this->rest->get('api/v1/campaign/fetch_zone_traffic',array("zone_id"=>$zone_id,"api_key"=>get_session('api_key')),'php'); 
						
		//For available ssp categories
        $data['ssp_category'] 		= 	$this->rest->get('api/v1/utilities/ssplist', array("api_key" => get_session('api_key')) , 'php');
		
		$data['freq_capp']	=	$this->rest->get('api/v1/campaign/fetch_frequency_list', array("api_key" => get_session('api_key')) , 'php');
		
		$data['previous_campaigns']		= $this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');		
		
		$data['wallet_balance']		= $this->rest->get('api/v1/campaign/wallet_balances',array("api_key"=>get_session('api_key')),'php');			
		
		if(isset($_COOKIE[$prod_name.'_adv_campaign_user_data'])!='') 
		{   
			$campaign_id		=	$_COOKIE[$prod_name.'_adv_campaign_user_data'];				
			
			//Fetch Campaign details
			$campaign_details	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		
			$data['campaign_det']=	$campaign_details[0];	
			
			
			$s2s_details		= 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"s2s"=>'1',"api_key"=>get_session('api_key')),'php');
			
			//Fetch browser targeting details
			$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch os targeting details
			$os_details			= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch profile targeting details
			$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_gender		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_color		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_height		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_weight		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_keyword	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');
			
			//Fetch mobile os targeting details
			$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile manufactures targeting details
			$mobile_manu_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile capability details
			$mobile_capa_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch geo targeting details
			$geoinclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Include:country","api_key"=>get_session('api_key')),'php');
			
			$geoexclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Exclude:country","api_key"=>get_session('api_key')),'php');
							
			//Language
			$lang_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Client:Language","api_key"=>get_session('api_key')),'php');
			
			//City
			$city_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:City","api_key"=>get_session('api_key')),'php');
			
			//Zip
			$zip_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:Zip","api_key"=>get_session('api_key')),'php');
			
			//Device
			$device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"device:".strtolower($data['campaign_det']['dj_targetting_type']),"api_key"=>get_session('api_key')),'php');
			
			//Blacklist
			$black_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$white_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:whitelist","api_key"=>get_session('api_key')),'php');
				
			//Blacklist
			$pblack_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$pwhite_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_whitelist","api_key"=>get_session('api_key')),'php');
							
			//Time
			$time_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Hour","api_key"=>get_session('api_key')),'php');
			
			//Daypart
			$daypart_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Day","api_key"=>get_session('api_key')),'php');
			
			//Day time
			//$daytime_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Day:Time","api_key"=>get_session('api_key')),'php');
			
			//URL Keyword
			$url_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:url","api_key"=>get_session('api_key')),'php');
			
			//Connection
			$connect_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"connection","api_key"=>get_session('api_key')),'php');
			
			//Carrier
			$carrier_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"carrier","api_key"=>get_session('api_key')),'php');
			
			$data['targ_geo_include']	=	$geoinclude_details[0];
			$data['targ_geo_exclude']	=	$geoexclude_details[0];
			$data['targ_lang']			=	$lang_details[0];
			$data['targ_city']			=	$city_details[0];
			$data['targ_zip']			=	$zip_details[0];
			$data['targ_device']		=	$device_details[0];
			$data['targ_black']			=	$black_details[0];
			$data['targ_white']			=	$white_details[0];
			$data['targ_pblack']		=	$pblack_details[0];
			$data['targ_pwhite']		=	$pwhite_details[0];
			
			$data['targ_time']			=	$time_details[0];
			$data['targ_daypart']		=	$daypart_details[0];
			//$data['targ_day_time']	=	$daytime_details[0];				
			$data['targ_url']			=	$url_details[0];
			$data['targ_connect']		=	$connect_details[0];
			$data['targ_carrier']		=	$carrier_details[0];
				
			
			//Country Bidding
			$data['country_bid']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_bidding',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			$selected_group			 	= 	$this->rest->get('api/v1/creative/fetch_select_group',array("campaign_id"=>$campaign_id,"api_key"=>get_session("api_key")),'php');
			
			$data['select_group']		=	(!empty($selected_group) && $selected_group[0])?$selected_group[0]['group_id']:'';
			
			$sel_tracker				= 	$this->rest->get('api/v1/tracker/fetch_campaign_tracker',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key')),'php');		
			
			$data['select_tracker']		=	($sel_tracker!='error' && !empty($sel_tracker))?$sel_tracker[0]['trackerid']:'';
			
			$data['campaign_id']		=	$campaign_id;				
			$data['s2s_details']		=	$s2s_details[0];
			$data['targ_browser']		=	$browser_details[0];
			$data['targ_os']			=	$os_details[0];
			$data['targ_time']			=	$time_details[0];
			
			$data['profile_age']		=	$profile_age[0];
			$data['profile_gender']		=	$profile_gender[0];
			$data['profile_color']		=	$profile_color[0];
			$data['profile_height']		=	$profile_height[0];
			$data['profile_weight']		=	$profile_weight[0];
			
			$data['profile_keyword']	=	$profile_keyword[0];
			
			$data['targ_mob_manu']		=	$mobile_manu_details[0];
			$data['targ_mob_capa']		=	$mobile_capa_details[0];
			$data['targ_mob_tele']		=	$mobile_telecom_details[0];
			
	    }
		//Traffic sources
		$data['traffic']			= 	$this->rest->get('api/v1/campaign/fetch_campaign_traffic',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		
		//print_r($data['traffic']);  die("test");
		
		//Zone bidding
		$data['zonebid']           =  $this->rest->get('api/v1/campaign/fetch_campaign_zone_bidding',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');		
		
			
		$browser_admin		= $this->rest->get('api/v1/campaign/country_bid',array('api_key'=>get_session('api_key')),'php');
		$data['browser_admin'] = $browser_admin;
		
		//textpixel url
		$data['pixeltest_url']		= 	$this->rest->get('api/v1/campaign/fetch_pixeltest_url',array('api_key'=>get_session('api_key')),'php');	
		/**** Cookie setup-- end ************/
		
		 $data['content'] = $this->load->view('campaigns/add_camp',$data,TRUE);
		
		$format=$_POST['page'];
		if($format=='ajaxcall')
		{
			
		$this->template->set_layout('advertiser_content');
	    }
	    else
	    {
			$this->template->set_layout('advertiser_layout');
	    }
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:campaigns
	 * @param   :Null
	 * @return  :List all the campaigns for a particular
	 *
	 */	

	public function campaigns()
	{
		
		$data['page_title'] 	= 	"Manage your campaign";

		$data['daily_data']	    =   $this->rest->get('api/v1/creative/fetch_daily_statistics',array("api_key"=>get_session('api_key'),'admarket'=>0),'php');
					
		$data['total_balance']	=  $this->rest->get('api/v1/campaign/current_balance',array("api_key"=>get_session('api_key')),'php');		
						
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key')),'php');
		$campaign_details		= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("api_key"=>get_session('api_key')),'php');	
		
		
			
		$data['campaign_det']	=	$campaign_details[0];
		$data['groups'] 		=	$this->rest->get('api/v1/creative/fetch_group',array('api_key'=>get_session("api_key")),'php');
		$data['msg_dat']		= 	$this->rest->get('api/v1/message/fetch_data',array('api_key'=>get_session("api_key")),'php');
		
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['MANAGE_CAMPAIGN']['CHART']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('campaigns/manage_campaigns',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	public function admarket_campaigns()
	{

		$data['page_title'] 	= 	"Manage your Admarket campaign";

		$data['campaign_data'] 	= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key')),'php');
		$campaign_details	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("api_key"=>get_session('api_key')),'php');	
			
		$data['campaign_det']	=	$campaign_details[0];
		$data['groups'] 		=	$this->rest->get('api/v1/creative/fetch_group',array('api_key'=>get_session("api_key")),'php');
		$data['msg_dat']		= 	$this->rest->get('api/v1/message/fetch_data',array('api_key'=>get_session("api_key")),'php');	
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['MANAGE_CAMPAIGN']['CHART']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('campaigns/manage_admarket_campaigns',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}

	public function campaign_details($campaign_id)
	{
		$campaign_details			= 	$this->rest->get('api/v1/campaign/preview_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		$data['campaigns']		=	$campaign_details[0];
		$data['content'] = $this->load->view('campaigns/campaign_detail',$data,TRUE);	
	    $this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
		
	public function preview_campaign($campaign_id)
	 {	
		//echo $this->rest->debug();  die("test");  
		
		$campaigns= $this->rest->get('api/v1/campaign/preview_campaign',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');	
		$data['campaigns']=$campaigns[0];
		$targetting_type=$campaigns[0]['dj_targetting_type'];  
		$category_id=$campaigns[0]['dj_category_id']; 
		$sub_category_id=$campaigns[0]['dj_sub_category'];
		
		$category	=	$this->rest->get('api/v1/utilities/category_list',array("api_key"=>get_session('api_key'),"category_id"=>$category_id),'php');
		$data['campaigns']['category_name']=$category[0]['category_name'];
		
		$category	=	$this->rest->get('api/v1/utilities/category_list',array("api_key"=>get_session('api_key'),"category_id"=>$sub_category_id),'php');
		$data['campaigns']['sub_category_name']=$category[0]['category_name'];
		
		$global_tracker=$this->rest->get('api/v1/campaign/global_tracker',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');
		$data['campaigns']['global_tracker']=$global_tracker[0]['cookieless_tracker'];
		
		$sel_tracker	= 	$this->rest->get('api/v1/tracker/fetch_tracker_name',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key')),'php');
		$data['campaigns']['trackername']=$sel_tracker[0]['trackername'];
		
		$group=$this->rest->get('api/v1/campaign/group_list',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');
		$data['campaigns']['group']=$group[0]['group_name'];
	
		$device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"device:".strtolower($targetting_type),"api_key"=>get_session('api_key')),'php');
		
		$data['campaigns']['device']=$device_details[0]['data'];
		
		$geoinclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Include:country","api_key"=>get_session('api_key')),'php');			
		$geoexclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Exclude:country","api_key"=>get_session('api_key')),'php');
		
		$inc=explode(",",$geoinclude_details[0]['data']);
		$include='';	
		foreach($inc as $incl)
		{	
			$include.="'".$incl."'".",";
		}
		$include = rtrim($include,",");  
		
		$exc=explode(",",$geoexclude_details[0]['data']);
		$exclude='';	
		foreach($exc as $excl)
		{	
			$exclude.="'".$excl."'".",";
		}
		$exclude = rtrim($exclude,","); 

		$country='';
		
		if($include!='')
		{
			$country_type="1";
			$include_country = 	$this->rest->get('api/v1/utilities/fetch_country_name',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key'),'country_val'=>$include),'php');
			foreach($include_country as $inc_country)
			{
				$country.=$inc_country['name'].",";
			}
		}
		else
		{
			$country_type="2";
			$exclude_country = 	$this->rest->get('api/v1/utilities/fetch_country_name',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key'),'country_val'=>$exclude),'php');
			foreach($exclude_country as $exc_country)
			{
				$country.=$exc_country['name'].",";
			}
		}		
		$country = rtrim($country,",");
		$data['campaigns']['country_type']=$country_type;
		$data['campaigns']['country']=$country;		
		
		$city='';
		$city_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:City","api_key"=>get_session('api_key')),'php');
		$city_de=explode(",",$city_details[0]['data']);
		foreach ($city_de as $cit)
		{
			 $city_det=explode("|",$cit);  			 
			 $city.=$city_det[1].",";						
		}
		$city=rtrim($city,",");
		$data['campaigns']['city']=$city;	
		
		$zip_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:Zip","api_key"=>get_session('api_key')),'php');
		$data['campaigns']['zip']=$zip_details[0]['data'];
		
		$browser='';
		$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		$bro=explode(",",$browser_details[0]['data']);
		foreach($bro as $brow)
		{	
			$browser.="'".$brow."'".",";
		}
		$browser = rtrim($browser,","); 
		$browser_name='';
		$browser_detail = 	$this->rest->get('api/v1/utilities/fetch_browser_name',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key'),'browser_val'=>$browser),'php');
		foreach($browser_detail as $browser)
		{	
			$browser_name.=$browser['name'].",";
		}		
		$browsername=rtrim($browser_name,",");			
		$data['campaigns']['browser_name']=$browsername;
		
		$lang_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Client:Language","api_key"=>get_session('api_key')),'php');		
		$lang=explode(",",$lang_details[0]['data']);
		$language='';
		foreach ($lang as $lan)
		{			
			$language.="'".$lan."'".",";						
		}
		$language=rtrim($language,",");					
		$lang_name='';
		$lang_detail = 	$this->rest->get('api/v1/utilities/fetch_browser_language_name',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key'),'lang_val'=>$language),'php');
		foreach($lang_detail as $lang_det)
		{	
			$lang_name.=$lang_det['name'].",";
		}		
		$langname=rtrim($lang_name,",");			
		$data['campaigns']['lang_name']=$langname;  
		
		$os_details			= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		$os=explode(",",$os_details[0]['data']);
		$operating_system='';
		foreach ($os as $operating)
		{			
			$operating_system.="'".$operating."'".",";						
		}
		$operating_system=rtrim($operating_system,",");	
		$os_name='';
		$os_detail = 	$this->rest->get('api/v1/utilities/fetch_operating_system',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key'),'os_val'=>$operating_system),'php');
		foreach($os_detail as $os_det)
		{	
			$os_name.=$os_det['name'].",";
		}		
		$osname=rtrim($os_name,",");			
		$data['campaigns']['osname']=$osname; 
		
		$mobile_manu_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		$manu_detail=explode(",",$mobile_manu_details[0]['data']);
		$manufactures_detail='';
		foreach ($manu_detail as $manu_det)
		{			
			$manufactures_detail.="'".$manu_det."'".",";						
		}
		$manufactures_detail=rtrim($manufactures_detail,",");	
		$manu_name='';
		$manufacture_detail = 	$this->rest->get('api/v1/utilities/fetch_manufacture_name',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key'),'manufacture_val'=>$manufactures_detail),'php');
		foreach($manufacture_detail as $manu_det)
		{	
			$manu_name.=$manu_det['name'].",";
		}		
		$manuname=rtrim($manu_name,",");	
		$data['campaigns']['manuname']=$manuname; 
		
		/*Mobile Capability*/
		$mobile_capa_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		$capa_detail=explode(",",$mobile_capa_details[0]['data']);
		$capability_detail='';
		foreach ($capa_detail as $cap_det)
		{			
			$capability_detail.="'".$cap_det."'".",";						
		}
		$capability_detail=rtrim($capability_detail,",");	
		$cap_name='';
		$capabilities_detail = 	$this->rest->get('api/v1/utilities/fetch_cap_name',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key'),'capability_val'=>$capability_detail),'php');
		foreach($capabilities_detail as $capb_det)
		{	
			$cap_name.=$capb_det['name'].",";
		}		
		$capname=rtrim($cap_name,",");	
		$data['campaigns']['capname']=$capname; 
		
		/*Connection Type*/  
		$connect_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"connection","api_key"=>get_session('api_key')),'php');
		$connect_detail=explode(",",$connect_details[0]['data']);
		$conn_detail='';
		foreach ($connect_detail as $con_det)
		{			
			$conn_detail.="'".$con_det."'".",";						
		}
		$conn_detail=rtrim($conn_detail,",");
		$connection_name='';
		$connection_detail = 	$this->rest->get('api/v1/utilities/fetch_connection_name',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key'),'connection_val'=>$conn_detail),'php');
		foreach($connection_detail as $conn_det)
		{	
			$connection_name.=$conn_det['name'].",";
		}		
		$connectionname=rtrim($connection_name,",");	
		$data['campaigns']['connectionname']=$connectionname; 
		
		/*Mobile isp carrier details */
		$carrier_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"carrier","api_key"=>get_session('api_key')),'php');
		$carrier_detail=explode(",",$carrier_details[0]['data']);
		$car_detail='';
		foreach ($carrier_detail as $carrier_det)
		{			
			$car_detail.="'".$carrier_det."'".",";						
		}
		$car_detail=rtrim($car_detail,",");
		$isp_name='';
		$isp_detail = 	$this->rest->get('api/v1/utilities/fetch_isp_name',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key'),'isp_val'=>$car_detail),'php');
		foreach($isp_detail as $isp_det)
		{	
			$isp_name.=$isp_det['country']."-".$isp_det['carriername'].",";
		}		
		$ispname=rtrim($isp_name,",");	
		$data['campaigns']['ispname']=$ispname; 

		$profile_age = 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		$data['campaigns']['profile_age']=$profile_age[0]['data']; 
		
		$profile_gender		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		$data['campaigns']['profile_gender']=$profile_gender[0]['data']; 
		
		$profile_color		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		$data['campaigns']['profile_color']=$profile_color[0]['data']; 
		
		$profile_height		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		$data['campaigns']['profile_height']=$profile_height[0]['data']; 
		
		$profile_weight		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		$data['campaigns']['profile_weight']=$profile_weight[0]['data']; 
		
		$profile_keyword	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');
		$data['campaigns']['profile_keyword']=$profile_keyword[0]['data']; 
		
		$url_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:url","api_key"=>get_session('api_key')),'php');
		$data['campaigns']['url_keyword']=$url_details[0]['data']; 
		
		
		//Blacklist
		$black_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:blacklist","api_key"=>get_session('api_key')),'php');
		$data['campaigns']['blacklist_1']=$black_details[0]['data']; 	
		//Blacklist
		$pblack_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_blacklist","api_key"=>get_session('api_key')),'php');
		$block_detail=explode(",",$pblack_details[0]['data']);
		$blk_detail='';
		foreach ($block_detail as $blk_det)
		{			
			$blk_detail.="'".$blk_det."'".",";						
		}
		$blk_detail=rtrim($blk_detail,",");
		$blocklist_name='';
		$blocklist_detail = $this->rest->get('api/v1/utilities/fetch_list_name',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key'),'blocklist_val'=>$blk_detail),'php');
		foreach($blocklist_detail as $blk_list_det)
		{	
			$blocklist_name.=$blk_list_det['adblock_list_name'].",";
		}		
		$blocklistname=rtrim($blocklist_name,",");	
		$data['campaigns']['blacklist_2']=$blocklistname; 
							
		//Whitelist
		$white_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:whitelist","api_key"=>get_session('api_key')),'php');
		$data['campaigns']['whitelist_1']=$white_details[0]['data']; 	
			
		//Whitelist
		$pwhite_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_whitelist","api_key"=>get_session('api_key')),'php');
		$white_detail=explode(",",$pwhite_details[0]['data']);
		$wht_detail='';
		foreach ($white_detail as $wht_det)
		{			
			$wht_detail.="'".$wht_det."'".",";						
		}
		$wht_detail=rtrim($wht_detail,",");
		$whitelist_name='';
		$whitelist_detail = $this->rest->get('api/v1/utilities/fetch_list_name',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key'),'blocklist_val'=>$wht_detail),'php');
		foreach($whitelist_detail as $wht_list_det)
		{	
			$whitelist_name.=$wht_list_det['adblock_list_name'].",";
		}		
		$whitelistname=rtrim($whitelist_name,",");	
		$data['campaigns']['whitelist_2']=$whitelistname;

		$traffic = 	$this->rest->get('api/v1/campaign/fetch_campaign_traffic',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		$data['campaigns']['traffic']=$traffic;
		
		$country_bid		= 	$this->rest->get('api/v1/campaign/fetch_campaign_bidding',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		$data['campaigns']['country_bid']=$country_bid;	
		
		$ad=$this->rest->get('api/v1/creative/fetch',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');

		$data['campaigns']['ad']=$ad;	  
				
		echo $this->load->view('campaigns/content/preview_campaign',$data);		
	 }  
	/*
	 * 
	 * name		:fetch_campaign
	 * @param   :Null
	 * @return  :List all the creatives for a particular
	 * 			 advertiser
	 */	

	public function fetch_campaign()
	{
		
		//$group=$this->input->get('group');
		//$status=$this->input->get('status');
		$revenue_type=$this->input->get('revenue_type');
		if(!empty($group) || !empty($status) || !empty($revenue_type))
		{ 
			//$group_val= ($group)?((is_array($group))?$group:explode(',',$group)):'';
			//$status_val= ($status)?((is_array($status))?$status:explode(',',$status)):'';
			//$type_val= ($revenue_type)?((is_array($revenue_type))?$revenue_type:explode(',',$revenue_type)):'';					
						
			$api_key=get_session('api_key');
			$input = array('api_key'	=>	$api_key);
			$input['group'] = ($group)?((is_array($group))?$group:explode(',',$group)):'';
			$input['status']= ($status)?((is_array($status))?$status:explode(',',$status)):'';
			$input['revenue_type']= ($revenue_type)?((is_array($revenue_type))?$revenue_type:explode(',',$revenue_type)):'';								
			
			$campaigns		= $this->rest->get('api/v1/campaign/fetch_filter',$input,'php');	
			
		}
		else
		{    
			$campaigns		= $this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
		}
		
		#$this->rest->debug();
		
		echo convert_to_datatable_format(json_encode($campaigns));
	}
	
	
	/*
	* 
	* name   : add_campaigns
	* @param : Null
	* @return: Loads a page to create a new campaign
	* 
	*/	
 
	public function new_add_campaigns()
	{ 
		
		$data['page_title'] = "Add campaigns";

		$data['breadcrumb'] = '';
		
		/************ Video Enable/Disable *************/
		$this->load->library('default_configurations');
		
		$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
		
		//Minimum Budget & Bid Rate & creatives allowed
		$data['min_budget']		=	$this->default_configurations->get('min_budget');
		
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
		
		$data['creat_allowed']	=	$this->default_configurations->get('direct_creative_type');
		
		/************ Video Enable/Disable *************/  
		
		$data['creative_size'] 		= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'php');
		
		$data['mob_screen_size']	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>get_session('api_key')),'php');
		
		$data['lang_data'] 			=	$this->rest->get('api/v1/campaign/fetch_language',array('api_key'=>get_session('api_key')),'php');
					
		//Fetch Publisher
		$adm						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$data['pub_data'] 			=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$adm[0]['api_key'],'netid'=>'2'),'php');
		$data['adb_data'] 			=	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$adm[0]['api_key']),'php');		
		$data['preset_black']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'black'),'php');		
						
		$data['preset_white']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'white'),'php');		
		
		//URL BLOCK LIST
		$data['site_url_block']		= 	$this->rest->get('api/v1/zone_limitations/fetch_url_block_list',array('api_key'=>get_session('api_key')),'php');	
		
		$domain		= 	$this->rest->get('api/v1/campaign/fetch_domain',array("api_key"=>get_session('api_key')),'php');
			//print_r($domain[0]['url']);die("sdfsf");
			$data['domain_data']=	$domain[0]['url'];	
		//Fetch available site categories
		$data['campaign_category']	=	$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>get_session('api_key')),'php');

		$data['camp_sub_category']	=	$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>get_session('api_key')),'php');

		//Fetch Country
		$data['countrylist']		=	$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>get_session('api_key')),'php');		
		
		$data['group']				=	$this->rest->get('api/v1/creative/fetch_group',array('api_key'=>get_session("api_key")),'php');

		$data['browser_vers']		=	$this->rest->get('api/v1/creative/fetch_browser_versions',array('api_key'=>get_session("api_key")),'php');		
		
		$data['os_vers']		=	$this->rest->get('api/v1/targeting/fetch_os_version',array('api_key'=>get_session("api_key")),'php');
				
		$data['tracker']			= 	$this->rest->get('api/v1/tracker/fetch_tracker',array('api_key'=>get_session('api_key')),'php');		
		
		//Fetch available campaign type
		$data['campaign_type']		= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
	
	    //print_r($data['campaign_type']);  die();
	
		$data['target']				=	$this->targeting_list();
		
				
		/**** Cookie setup -- start ************/
		$prod_name = $this->config->item('prod_name'); 
		
		$bid_data 					=	$this->rest->get('api/v1/campaign/fetch_realtime_bidding',array('api_key'=>get_session('api_key')),'php');
						
		$data['best_bid_rate']			=	($bid_data!='error')?$bid_data[0]['best_bid_rate']:'';
		$data['min_bid_rate']			=	($bid_data!='error')?$bid_data[0]['min_bid_rate']:'';
		$data['max_bid_rate']			=	($bid_data!='error')?$bid_data[0]['max_bid_rate']:'';
		
		//Traffic sources
		$publisher_id=$this->session->userdata("buy_link_publisher_id"); 
		$data['traffic_data']			= 	$this->rest->get('api/v1/campaign/fetch_publisher_traffic',array("publisher_id"=>$publisher_id,"api_key"=>get_session('api_key')),'php');  

		$zone_id=$this->session->userdata("buy_link_zone_id");  
		$data['buy_zone_id'] = $zone_id;
		$data['zone_data']			= 	$this->rest->get('api/v1/campaign/fetch_zone_traffic',array("zone_id"=>$zone_id,"api_key"=>get_session('api_key')),'php'); 
						
		//For available ssp categories
        $data['ssp_category'] 		= 	$this->rest->get('api/v1/utilities/ssplist', array("api_key" => get_session('api_key')) , 'php');
		
		$data['freq_capp']	=	$this->rest->get('api/v1/campaign/fetch_frequency_list', array("api_key" => get_session('api_key')) , 'php');
		
		$data['previous_campaigns']		= $this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');		
		
		$data['wallet_balance']		= $this->rest->get('api/v1/campaign/wallet_balances',array("api_key"=>get_session('api_key')),'php');			
		
		if(isset($_COOKIE[$prod_name.'_adv_campaign_user_data'])!='') 
		{   
			$campaign_id		=	$_COOKIE[$prod_name.'_adv_campaign_user_data'];				
			
			//Fetch Campaign details
			$campaign_details	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		
			$data['campaign_det']=	$campaign_details[0];	
			
			
			$s2s_details		= 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"s2s"=>'1',"api_key"=>get_session('api_key')),'php');
			
			//Fetch browser targeting details
			$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch os targeting details
			$os_details			= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch profile targeting details
			$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_gender		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_color		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_height		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_weight		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_keyword	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');
			
			//Fetch mobile os targeting details
			$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile manufactures targeting details
			$mobile_manu_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile capability details
			$mobile_capa_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch geo targeting details
			$geoinclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Include:country","api_key"=>get_session('api_key')),'php');
			
			$geoexclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Exclude:country","api_key"=>get_session('api_key')),'php');
							
			//Language
			$lang_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Client:Language","api_key"=>get_session('api_key')),'php');
			
			//City
			$city_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:City","api_key"=>get_session('api_key')),'php');
			
			//Zip
			$zip_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:Zip","api_key"=>get_session('api_key')),'php');
			
			//Device
			$device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"device:".strtolower($data['campaign_det']['dj_targetting_type']),"api_key"=>get_session('api_key')),'php');
			
			//Blacklist
			$black_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$white_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:whitelist","api_key"=>get_session('api_key')),'php');
				
			//Blacklist
			$pblack_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$pwhite_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_whitelist","api_key"=>get_session('api_key')),'php');
							
			//Time
			$time_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Hour","api_key"=>get_session('api_key')),'php');
			
			//Daypart
			$daypart_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Day","api_key"=>get_session('api_key')),'php');
			
			//Day time
			//$daytime_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Day:Time","api_key"=>get_session('api_key')),'php');
			
			//URL Keyword
			$url_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:url","api_key"=>get_session('api_key')),'php');
			
			//Connection
			$connect_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"connection","api_key"=>get_session('api_key')),'php');
			
			//Carrier
			$carrier_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"carrier","api_key"=>get_session('api_key')),'php');
			
			$data['targ_geo_include']	=	$geoinclude_details[0];
			$data['targ_geo_exclude']	=	$geoexclude_details[0];
			$data['targ_lang']			=	$lang_details[0];
			$data['targ_city']			=	$city_details[0];
			$data['targ_zip']			=	$zip_details[0];
			$data['targ_device']		=	$device_details[0];
			$data['targ_black']			=	$black_details[0];
			$data['targ_white']			=	$white_details[0];
			$data['targ_pblack']		=	$pblack_details[0];
			$data['targ_pwhite']		=	$pwhite_details[0];
			
			$data['targ_time']			=	$time_details[0];
			$data['targ_daypart']		=	$daypart_details[0];
			//$data['targ_day_time']	=	$daytime_details[0];				
			$data['targ_url']			=	$url_details[0];
			$data['targ_connect']		=	$connect_details[0];
			$data['targ_carrier']		=	$carrier_details[0];
				
			
			//Country Bidding
			$data['country_bid']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_bidding',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			$selected_group			 	= 	$this->rest->get('api/v1/creative/fetch_select_group',array("campaign_id"=>$campaign_id,"api_key"=>get_session("api_key")),'php');
			
			$data['select_group']		=	(!empty($selected_group) && $selected_group[0])?$selected_group[0]['group_id']:'';
			
			$sel_tracker				= 	$this->rest->get('api/v1/tracker/fetch_campaign_tracker',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key')),'php');		
			
			$data['select_tracker']		=	($sel_tracker!='error' && !empty($sel_tracker))?$sel_tracker[0]['trackerid']:'';
			
			$data['campaign_id']		=	$campaign_id;				
			$data['s2s_details']		=	$s2s_details[0];
			$data['targ_browser']		=	$browser_details[0];
			$data['targ_os']			=	$os_details[0];
			$data['targ_time']			=	$time_details[0];
			
			$data['profile_age']		=	$profile_age[0];
			$data['profile_gender']		=	$profile_gender[0];
			$data['profile_color']		=	$profile_color[0];
			$data['profile_height']		=	$profile_height[0];
			$data['profile_weight']		=	$profile_weight[0];
			
			$data['profile_keyword']	=	$profile_keyword[0];
			
			$data['targ_mob_manu']		=	$mobile_manu_details[0];
			$data['targ_mob_capa']		=	$mobile_capa_details[0];
			$data['targ_mob_tele']		=	$mobile_telecom_details[0];
			
	    }
		//Traffic sources
		$data['traffic']			= 	$this->rest->get('api/v1/campaign/fetch_campaign_traffic',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		
		//print_r($data['traffic']);  die("test");
		
		//Zone bidding
		$data['zonebid']           =  $this->rest->get('api/v1/campaign/fetch_campaign_zone_bidding',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');		
		
			
		$browser_admin		= $this->rest->get('api/v1/campaign/country_bid',array('api_key'=>get_session('api_key')),'php');
		$data['browser_admin'] = $browser_admin;
		
		//textpixel url
		$data['pixeltest_url']		= 	$this->rest->get('api/v1/campaign/fetch_pixeltest_url',array('api_key'=>get_session('api_key')),'php');	
		/**** Cookie setup-- end ************/
		
		 $data['content'] = $this->load->view('campaigns/new_add_camp',$data,TRUE);
		
		$format=$_POST['page'];
		if($format=='ajaxcall')
		{
			
		$this->template->set_layout('advertiser_content');
	    }
	    else
	    {
			$this->template->set_layout('advertiser_layout');
	    }
		$this->template->build('view', $data);
	}
	public function add_campaigns_test()
	{ 
		$data['page_title'] = "Add campaigns";

		$data['breadcrumb'] = '';
		
		/************ Video Enable/Disable *************/
		$this->load->library('default_configurations');
		
		$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
		
		//Minimum Budget & Bid Rate & creatives allowed
		$data['min_budget']		=	$this->default_configurations->get('min_budget');
		
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
		
		$data['creat_allowed']	=	$this->default_configurations->get('direct_creative_type');
		
		/************ Video Enable/Disable *************/  
		
		$data['creative_size'] 		= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'php');
		
		$data['mob_screen_size']	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>get_session('api_key')),'php');
		
		$data['lang_data'] 			=	$this->rest->get('api/v1/campaign/fetch_language',array('api_key'=>get_session('api_key')),'php');
					
		//Fetch Publisher
		$adm						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$data['pub_data'] 			=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$adm[0]['api_key']),'php');
		$data['adb_data'] 			=	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$adm[0]['api_key']),'php');		
		$data['preset_black']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'black'),'php');		
						
		$data['preset_white']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'white'),'php');		
		
		
				
		//Fetch available site categories
		$data['campaign_category']	=	$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>get_session('api_key')),'php');

		$data['camp_sub_category']	=	$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>get_session('api_key')),'php');

		//Fetch Country
		$data['countrylist']		=	$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>get_session('api_key')),'php');		
		
		$data['group']				=	$this->rest->get('api/v1/creative/fetch_group',array('api_key'=>get_session("api_key")),'php');

		$data['browser_vers']		=	$this->rest->get('api/v1/creative/fetch_browser_versions',array('api_key'=>get_session("api_key")),'php');		
		
		$data['os_vers']		=	$this->rest->get('api/v1/targeting/fetch_os_version',array('api_key'=>get_session("api_key")),'php');
				
		$data['tracker']			= 	$this->rest->get('api/v1/tracker/fetch_tracker',array('api_key'=>get_session('api_key')),'php');		
		
		//Fetch available campaign type
		$data['campaign_type']		= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
	
	    //print_r($data['campaign_type']);  die();
	
		$data['target']				=	$this->targeting_list();
		
		//$data['key_avg_val']		= 	$this->rest->get('api/v1/creative/fetch_avg_cpm',array("api_key"=>get_session('api_key'),"keywords"=>$data['target']['keywords']),'php');		
	
		/**** Cookie setup -- start ************/
		$prod_name = $this->config->item('prod_name'); 
		
		$bid_data 					=	$this->rest->get('api/v1/campaign/fetch_realtime_bidding',array('api_key'=>get_session('api_key')),'php');
						
		$data['best_bid_rate']			=	($bid_data!='error')?$bid_data[0]['best_bid_rate']:'';
		$data['min_bid_rate']			=	($bid_data!='error')?$bid_data[0]['min_bid_rate']:'';
		$data['max_bid_rate']			=	($bid_data!='error')?$bid_data[0]['max_bid_rate']:'';
		
		//echo $this->rest->debug();exit;
			
		//For available ssp categories
        $data['ssp_category'] 		= 	$this->rest->get('api/v1/utilities/ssplist', array("api_key" => get_session('api_key')) , 'php');
		
		$data['freq_capp']	=	$this->rest->get('api/v1/campaign/fetch_frequency_list', array("api_key" => get_session('api_key')) , 'php');
		
		$data['previous_campaigns']		= $this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');		
		
		$data['wallet_balance']		= $this->rest->get('api/v1/campaign/wallet_balances',array("api_key"=>get_session('api_key')),'php');	
		if(isset($_COOKIE[$prod_name.'_adv_campaign_user_data'])!='') 
		{
			$campaign_id		=	$_COOKIE[$prod_name.'_adv_campaign_user_data'];				
			
			//Fetch Campaign details
			$campaign_details	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		
			$data['campaign_det']=	$campaign_details[0];
			
			$s2s_details		= 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"s2s"=>'1',"api_key"=>get_session('api_key')),'php');
			
			//Fetch browser targeting details
			$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch os targeting details
			$os_details			= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch profile targeting details
			$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_gender		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_color		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_height		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_weight		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_keyword	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');
			
			//Fetch mobile os targeting details
			$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile manufactures targeting details
			$mobile_manu_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile capability details
			$mobile_capa_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch geo targeting details
			$geoinclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Include:country","api_key"=>get_session('api_key')),'php');
			
			$geoexclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Exclude:country","api_key"=>get_session('api_key')),'php');
							
			//Language
			$lang_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Client:Language","api_key"=>get_session('api_key')),'php');
			
			//City
			$city_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:City","api_key"=>get_session('api_key')),'php');
			
			//Zip
			$zip_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:Zip","api_key"=>get_session('api_key')),'php');
			
			//Device
			$device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"device:".strtolower($data['campaign_det']['dj_targetting_type']),"api_key"=>get_session('api_key')),'php');
			
			//Blacklist
			$black_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$white_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:whitelist","api_key"=>get_session('api_key')),'php');
				
			//Blacklist
			$pblack_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$pwhite_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_whitelist","api_key"=>get_session('api_key')),'php');
							
			//Time
			$time_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Hour","api_key"=>get_session('api_key')),'php');
			
			//Daypart
			$daypart_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Day","api_key"=>get_session('api_key')),'php');
			
			//Day time
			//$daytime_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Day:Time","api_key"=>get_session('api_key')),'php');
			
			//URL Keyword
			$url_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:url","api_key"=>get_session('api_key')),'php');
			
			//Connection
			$connect_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"connection","api_key"=>get_session('api_key')),'php');
			
			//Carrier
			$carrier_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"carrier","api_key"=>get_session('api_key')),'php');
			
			$data['targ_geo_include']	=	$geoinclude_details[0];
			$data['targ_geo_exclude']	=	$geoexclude_details[0];
			$data['targ_lang']			=	$lang_details[0];
			$data['targ_city']			=	$city_details[0];
			$data['targ_zip']			=	$zip_details[0];
			$data['targ_device']		=	$device_details[0];
			$data['targ_black']			=	$black_details[0];
			$data['targ_white']			=	$white_details[0];
			$data['targ_pblack']		=	$pblack_details[0];
			$data['targ_pwhite']		=	$pwhite_details[0];
			
			$data['targ_time']			=	$time_details[0];
			$data['targ_daypart']		=	$daypart_details[0];
			//$data['targ_day_time']	=	$daytime_details[0];				
			$data['targ_url']			=	$url_details[0];
			$data['targ_connect']		=	$connect_details[0];
			$data['targ_carrier']		=	$carrier_details[0];
			
			//Traffic sources
			$data['traffic']			= 	$this->rest->get('api/v1/campaign/fetch_campaign_traffic',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Country Bidding
			$data['country_bid']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_bidding',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			$selected_group			 	= 	$this->rest->get('api/v1/creative/fetch_select_group',array("campaign_id"=>$campaign_id,"api_key"=>get_session("api_key")),'php');
			
			$data['select_group']		=	(!empty($selected_group) && $selected_group[0])?$selected_group[0]['group_id']:'';
			
			$sel_tracker				= 	$this->rest->get('api/v1/tracker/fetch_campaign_tracker',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key')),'php');		
			
			$data['select_tracker']		=	($sel_tracker!='error' && !empty($sel_tracker))?$sel_tracker[0]['trackerid']:'';
			
			$data['campaign_id']		=	$campaign_id;				
			$data['s2s_details']		=	$s2s_details[0];
			$data['targ_browser']		=	$browser_details[0];
			$data['targ_os']			=	$os_details[0];
			$data['targ_time']			=	$time_details[0];
			
			$data['profile_age']		=	$profile_age[0];
			$data['profile_gender']		=	$profile_gender[0];
			$data['profile_color']		=	$profile_color[0];
			$data['profile_height']		=	$profile_height[0];
			$data['profile_weight']		=	$profile_weight[0];
			
			$data['profile_keyword']	=	$profile_keyword[0];
			
			$data['targ_mob_manu']		=	$mobile_manu_details[0];
			$data['targ_mob_capa']		=	$mobile_capa_details[0];
			$data['targ_mob_tele']		=	$mobile_telecom_details[0];
			
	    }
		$data['datas']		=	$data;
		/**** Cookie setup-- end ************/
		
		$data['content'] = $this->load->view('campaigns/add_campaign_yo',$data,TRUE);
		
		$format=$_POST['page'];
		if($format=='ajaxcall')
		{
			
		$this->template->set_layout('advertiser_content');
	    }
	    else
	    {
			$this->template->set_layout('advertiser_layout');
	    }
		$this->template->build('view', $data);
	}
	
	public function buy_link_publisher_id()
	{
		$this->session->unset_userdata('buy_link_publisher_id');
		$this->session->set_userdata('buy_link_publisher_id', $_POST['pub_id']);
		echo json_encode($this->session->userdata('buy_link_publisher_id'));
	}
	
	public function buy_link_zone_id()
	{
		$this->session->unset_userdata('buy_link_zone_id');
		$this->session->set_userdata('buy_link_zone_id', $_POST['zone_id']);
		echo json_encode($this->session->userdata('buy_link_zone_id'));   
	}
	
	public function edit_campaign_without_id()
	{
		$this->session->unset_userdata('campaign_edit_id');
		$this->session->set_userdata('campaign_edit_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('campaign_edit_id'));
	}
	public function view_tracker_uri_id()
	{
		$this->session->unset_userdata('adv_campaign_tracker_id');
		$this->session->set_userdata('adv_campaign_tracker_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('adv_campaign_tracker_id'));
	}
	public function duplicate_copy_compaign_url()
	{
		$this->session->unset_userdata('adv_campaign_duplicate_id');
		$this->session->set_userdata('adv_campaign_duplicate_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('adv_campaign_duplicate_id'));
		
	}
	public function campaign_view_creative_demo_url()
	{
		$this->session->unset_userdata('adv_campaign_creative_demo_id');
		$this->session->set_userdata('adv_campaign_creative_demo_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('adv_campaign_creative_demo_id'));
		
	}
	
	
	public function view_creative_demo($campaign_id=false)
	{
		$campaign_id=$this->session->userdata('adv_campaign_creative_demo_id');
	
		$data['campaign_id']	= $campaign_id;
		
		$data['campaign_data'] = 	$this->rest->get('api/v1/creative/fetch_demo_creative_campaign',array("cam_id"=>$data['campaign_id'],"api_key"=>get_session('api_key')),'php');
		//echo "<pre>"; print_r($data['campaign_data']); echo "</pre>";die("ddd");
		foreach($data['campaign_data'] as $val)
		{
		        $banner_type[]=$val['banner_type'];
		      	//echo 'api/v1/creative/fetch_demo_additional_creative',array("creative_id"=>$val['bannerid']);die("ddd");
		      	if( $val['banner_type']=="M_MR_REV" || $val['banner_type']=="W_SS" || $val['banner_type']=="M_RS_PL" || $val['banner_type']=="M_RS_FL" || $val['banner_type']=="M_RS_FS" || $val['banner_type']=="W_GB" || $val['banner_type']="W_BB" || $val['banner_type']=="M_MR_EXP" || $val['banner_type']=="M_RS_ADH"|| $val['banner_type']=="W_SS")
		      	{
			      $additional_banners[]=$this->rest->get('api/v1/creative/fetch_demo_additional_creative',array("creative_id"=>$val['bannerid'],"api_key"=>get_session('api_key')),'php');
			    } 
			
	    }	
	    $data['bannertype']=$banner_type;
	    $data['additional_banners']=$additional_banners;
	//	echo "<pre>";print_r($data['bannertype']); echo "</pre>";die("ddd12");
		//echo $this->load->view('campaigns/view_creative_content',$data);	
		$data['content'] = $this->load->view('campaigns/view_creative_content',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
    }	
	
	
	
	/*
	* 
	* name   : edit_campaign
	* @param : Null
	* @return: Loads a page to edit a new campaign
	* 
	*/	

	public function edit_campaign($campaign_id=false)
	{
		$campaign_id=$this->session->userdata('campaign_edit_id');
		if($campaign_id)
		{
			$data['page_title'] = "Optimize campaign";

			$data['breadcrumb'] = '';
			
			/************ Video Enable/Disable *************/
			$this->load->library('default_configurations');
			
			$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
			
			//Minimum Budget & Bid Rate & creatives allowed
			$data['min_budget']		=	$this->default_configurations->get('min_budget');
			
			$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
			
			$data['creat_allowed']	=	$this->default_configurations->get('direct_creative_type');
			
			/************ Video Enable/Disable *************/
			
			$data['creative_size'] 		= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'php');
			
			$data['mob_screen_size']	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>get_session('api_key')),'php');
			
			$data['lang_data'] 			=	$this->rest->get('api/v1/campaign/fetch_language',array('api_key'=>get_session('api_key')),'php');
			//fetch domain for for global tracker url
			$domain		= 	$this->rest->get('api/v1/campaign/fetch_domain',array("api_key"=>get_session('api_key')),'php');
			//print_r($domain[0]['url']);die("sdfsf");
			$data['domain_data']=	$domain[0]['url'];
			//Fetch Publisher
			$adm						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
			$data['pub_data'] 			=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$adm[0]['api_key']),'php');
			$data['adb_data'] 			=	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$adm[0]['api_key']),'php');
			$data['preset_black']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'black'),'php');		
			$data['preset_white']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'white'),'php');		
				
			//Fetch available site categories
			$data['campaign_category']	=	$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>get_session('api_key')),'php');

			$data['camp_sub_category']	=	$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>get_session('api_key')),'php');

			//Fetch Country
			$data['countrylist']		=	$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>get_session('api_key')),'php');		
			
			//Fetch available campaign type
			$data['campaign_type']		= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
			
			$data['ssp_category'] 		= 	$this->rest->get('api/v1/utilities/ssplist', array("api_key" => get_session('api_key')) , 'php');
			
			$data['target']				=	$this->targeting_list();
			
			$data['group']				=	$this->rest->get('api/v1/creative/fetch_group',array("api_key"=>get_session('api_key')),'php');
			
			
			$data['tracker']			= 	$this->rest->get('api/v1/tracker/fetch_tracker',array('api_key'=>get_session('api_key')),'php');
			
			$selected_group			 	= 	$this->rest->get('api/v1/creative/fetch_select_group',array("campaign_id"=>$campaign_id,"api_key"=>get_session("api_key")),'php');
			
			$data['traffic_report_preview'] 	=	$this->rest->get('api/v1/report/fetch_traffic_report',array("campaign_id"=>$campaign_id,"api_key"=>get_session("api_key")),'php'); //DAC094 campaign preview 24-10-2017
			
			$select_group				=	(!empty($selected_group))?$selected_group:'';
			
			
			foreach ($select_group as $sel)
			{
				$sel_group[]=$sel['group_id'];   
			}
			
			$data['sel_group']=$sel_group;
			
			$sel_tracker				= 	$this->rest->get('api/v1/tracker/fetch_campaign_tracker',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key')),'php');		
			
			$data['select_tracker']		=	($sel_tracker!='error' && !empty($sel_tracker))?$sel_tracker[0]['trackerid']:'';
			
			//Fetch Campaign details
			$campaign_details			= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				
			$data['campaign_det']		=	$campaign_details[0];
			
			$s2s_details		= 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"s2s"=>'1',"api_key"=>get_session('api_key')),'php');
			
			//Fetch browser targeting details
			$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');

			$browser_version_details	= 	$this->rest->get('api/v1/campaign/fetch_brow_vers_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			$os_vers_details	= 	$this->rest->get('api/v1/campaign/fetch_os_version_data',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//print_r($os_vers_details);exit;
			$data['browser_vers']		=	$this->rest->get('api/v1/creative/fetch_browser_versions',array('api_key'=>get_session("api_key")),'php');
			
			$data['os_vers']		=	$this->rest->get('api/v1/targeting/fetch_os_version',array('api_key'=>get_session("api_key")),'php');		

			
			//Fetch os targeting details
			$os_details			= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch profile targeting details
			$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_gender		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_color		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_height		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_weight		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_keyword	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');
			$avail_keyword	= 	$this->rest->get('api/v1/campaign/fetch_avail_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');
			$blocked_keyword	= 	$this->rest->get('api/v1/campaign/fetch_blocked_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');
			
			//Fetch mobile os targeting details
			$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile manufactures targeting details
			$mobile_manu_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile capability details
			$mobile_capa_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch geo targeting details
			$geoinclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Include_country","api_key"=>get_session('api_key')),'php');
			
			$geoexclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Exclude_country","api_key"=>get_session('api_key')),'php');
							
			//Language
			$lang_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Client:Language","api_key"=>get_session('api_key')),'php');
			
			//City
			$city_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:City","api_key"=>get_session('api_key')),'php');
			
			//Zip
			$zip_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:Zip","api_key"=>get_session('api_key')),'php');
			
			$device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_devicelist',array("campaign_id"=>$campaign_id,"target_type"=>"device:","api_key"=>get_session('api_key')),'php');			
			
			/*$included_device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_devicelist',array("campaign_id"=>$campaign_id,"target_type"=>"device:","api_key"=>get_session('api_key')),'php');
			//Device
			$excluded_device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_devicelist',array("campaign_id"=>$campaign_id,"target_type"=>"device:","api_key"=>get_session('api_key')),'php');
			if($included_device_details)
			{
				$device_details_type="include";
				$device_details		= $included_device_details;
			}
			else if($excluded_device_details)
			{
				$device_details_type="exclude";
				$device_details		= $excluded_device_details;
			}
			else
			{
				$device_details_type="";
				$device_details		= "";
			}*/
									
			//Blacklist
			$black_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$white_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:whitelist","api_key"=>get_session('api_key')),'php');
			
			//Blacklist
			$pblack_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$pwhite_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_whitelist","api_key"=>get_session('api_key')),'php');
								
			//Time
			$time_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Hour","api_key"=>get_session('api_key')),'php');
			
			//Daypart
			$daypart_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Day","api_key"=>get_session('api_key')),'php');
			
			//Day time
			//$daytime_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Day:Time","api_key"=>get_session('api_key')),'php');
			
			//URL Keyword
			$url_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:url","api_key"=>get_session('api_key')),'php');
			
			//Connection
			$connect_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"connection","api_key"=>get_session('api_key')),'php');
			
			//Carrier
			$carrier_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"carrier","api_key"=>get_session('api_key')),'php');
			
			$data['freq_capp']	=	$this->rest->get('api/v1/campaign/fetch_frequency_list', array("api_key" => get_session('api_key')) , 'php');
			
			$data['site_url_block']		= 	$this->rest->get('api/v1/zone_limitations/fetch_url_block_list',array('api_key'=>get_session('api_key')),'php');
				
			$browser_details[$browser_details[0]['comparison']] = $browser_details[0]['data'];
			$browser_details[$browser_details[1]['comparison']] = $browser_details[1]['data'];
			
			$lang_details[$lang_details[0]['comparison']] = $lang_details[0]['data'];
			$lang_details[$lang_details[1]['comparison']] = $lang_details[1]['data'];
			
			$browser_version_details[$browser_version_details[0]['comparison']] = $browser_version_details[0]['data'];
			$browser_version_details[$browser_version_details[1]['comparison']] = $browser_version_details[1]['data'];
			
			$os_details[$os_details[0]['comparison']] = $os_details[0]['data'];
			$os_details[$os_details[1]['comparison']] = $os_details[1]['data'];
			
			$os_vers_details[$os_vers_details[0]['comparison']] = $os_vers_details[0]['data'];
			$os_vers_details[$os_vers_details[1]['comparison']] = $os_vers_details[1]['data'];
			
			$mobile_manu_details[$mobile_manu_details[0]['comparison']] = $mobile_manu_details[0]['data'];
			$mobile_manu_details[$mobile_manu_details[1]['comparison']] = $mobile_manu_details[1]['data'];
			
			$mobile_capa_details[$mobile_capa_details[0]['comparison']] = $mobile_capa_details[0]['data'];
			$mobile_capa_details[$mobile_capa_details[1]['comparison']] = $mobile_capa_details[1]['data'];
			
			$connect_details[$connect_details[0]['comparison']] = $connect_details[0]['data'];
			$connect_details[$connect_details[1]['comparison']] = $connect_details[1]['data'];
			
			$carrier_details[$carrier_details[0]['comparison']] = $carrier_details[0]['data'];
			$carrier_details[$carrier_details[1]['comparison']] = $carrier_details[1]['data'];

			$city_details[$city_details[0]['comparison']] = $city_details[0]['data'];
			$city_details[$city_details[1]['comparison']] = $city_details[1]['data'];
			
			$zip_details[$zip_details[0]['comparison']] = $zip_details[0]['data'];
			$zip_details[$zip_details[1]['comparison']] = $zip_details[1]['data'];

			$device_details[$device_details[0]['comparison']] = $device_details[0]['data'];
			$device_details[$device_details[1]['comparison']] = $device_details[1]['data'];
		
		
			$data['targ_geo_include']	=	$geoinclude_details[0];
			$data['targ_geo_exclude']	=	$geoexclude_details[0];
			$data['targ_lang']			=	$lang_details;
			$data['targ_city']			=	$city_details;
			$data['targ_zip']			=	$zip_details;
			$data['targ_device']		=	$device_details;
			//$data['included_device_details']		=	$device_details['=='];
			//$data['excluded_device_details']		=	$device_details['!='];
			$data['browser_version_details'] 	=	$browser_version_details;
			$data['os_vers_details'] 	=	$os_vers_details;
			$data['device_details_type']=	$device_details_type;			
			$data['targ_black']			=	$black_details[0];
			$data['targ_white']			=	$white_details[0];
			$data['targ_pblack']		=	$pblack_details[0];
			$data['targ_pwhite']		=	$pwhite_details[0];
			
			$data['targ_time']			=	$time_details[0];
			$data['targ_daypart']		=	$daypart_details[0];
			//$data['targ_day_time']	=	$daytime_details[0];				
			$data['targ_url']			=	$url_details[0];
			$data['targ_connect']		=	$connect_details;
			$data['targ_carrier']		=	$carrier_details;
			
			//Traffic sources
			$data['traffic']			= 	$this->rest->get('api/v1/campaign/fetch_campaign_edit_traffic',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			
//echo $this->rest->debug();  die("ddd");
									
			$data['pix_track_report'] = $this->rest->get('api/v1/report/fetch_pixtrack_report',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');			
			
			//Zone bidding
			$data['zonebid']           =  $this->rest->get('api/v1/campaign/fetch_campaign_zone_bidding',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');	
			$data['zone_bid_report'] = $this->rest->get('api/v1/report/fetch_zonebid_tot',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			//Country Bidding
			$data['country_bid']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_bidding',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');  
			//zone optimization
			$data['zone_optimization']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_zone_optimization',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$data['country_bid_report'] = $this->rest->get('api/v1/report/fetch_countrybid_tot',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			//country optimization
			$data['country_optimization']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_country_optimization',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php'); 
			//print_r($data['country_optimization']);exit;
			//traffic optimization
			$data['traffic_optimization']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_traffic_optimization',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php'); 
		//	print_r($data['traffic_optimization']);exit;
			
			$data['campaign_id']		=	$campaign_id;				
			$data['s2s_details']		=	$s2s_details[0];
			$data['targ_browser']		=	$browser_details;
			$data['targ_os']			=	$os_details;
			$data['targ_time']			=	$time_details[0];
			
			$data['profile_age']		=	$profile_age[0];
			$data['profile_gender']		=	$profile_gender[0];
			$data['profile_color']		=	$profile_color[0];
			$data['profile_height']		=	$profile_height[0];
			$data['profile_weight']		=	$profile_weight[0];
			
			$data['profile_keyword']	=	$profile_keyword[0];
			
			$data['targ_mob_manu']		=	$mobile_manu_details;
			$data['targ_mob_capa']		=	$mobile_capa_details;
			$data['targ_mob_tele']		=	$mobile_telecom_details;
			$data['avail_keyword']		=	$avail_keyword;
			$data['blocked_keyword']	=	$blocked_keyword;
			$browser_admin		= $this->rest->get('api/v1/campaign/country_bid',array('api_key'=>get_session('api_key')),'php');
			$data['browser_admin'] = $browser_admin;		
			//textpixel url
		    $data['pixeltest_url']		= 	$this->rest->get('api/v1/campaign/fetch_pixeltest_url',array('api_key'=>get_session('api_key')),'php');		
			/***********End campaign details*********************/
			//print_r($data);exit;
			$data['content'] = $this->load->view('campaigns/edit_campaigns',$data,TRUE);
			
			$this->template->set_layout('advertiser_layout');
			$this->template->build('view', $data);
		}
	}

	/*
	 * 
	 * name   : fetch_campaign_crative
	 * @param : campaign_id
	 * @return: Fetch creative for particular campaign
	 */	

	public function fetch_campaign_creative($campaign_id=false)
	{
		$campaign_id= $this->input->post('_campaign_id');
		
		//Fetch available linked creatives
		$data['existing_creative']	= $this->rest->get('api/v1/campaign/fetch_linked_creative',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		
		#echo $this->rest->debug();exit;

		echo $this->load->view('campaigns/existing_creative',$data);

	}
	
	public function campaign_overview()
	{
		$campaignid=$this->session->userdata('campaign_detail_id');  
		$campaign_detail = $this->rest->get('api/v1/campaign/fetch_campaign_overview',array("campaign_id"=>$campaignid,"api_key"=>get_session('api_key')),'php');
		$data['campaign_detail']=$campaign_detail[0]; 
		
		$category = $this->rest->get('api/v1/campaign/fetch_category',array("category_id"=>$campaign_detail[0]['dj_category_id'],"api_key"=>get_session('api_key')),'php');
		
		$sub_category = $this->rest->get('api/v1/campaign/fetch_category',array("category_id"=>$campaign_detail[0]['dj_sub_category'],"api_key"=>get_session('api_key')),'php');
				
		$data['category_detail']=$category[0]; 
		$data['sub_category_detail']=$sub_category[0]; 
		
		$group = $this->rest->get('api/v1/campaign/fetch_group_name',array("campaign_id"=>$campaignid,"api_key"=>get_session('api_key')),'php');
		$data['group_name']=$group[0]['group_name'];  
		
		$device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaignid,"target_type"=>"device:".strtolower($campaign_detail[0]['dj_targetting_type']),"api_key"=>get_session('api_key')),'php');
		$data['device_details']=$device_details[0]['data'];  
		
		$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaignid,"api_key"=>get_session('api_key')),'php');
		$bro=explode(",",$browser_details[0]['data']);
		foreach($bro as $brow)
		{	
			$browser.="'".$brow."'".",";
		}
		$browser = rtrim($browser,","); 
		$browser_name='';
		$browser_detail = 	$this->rest->get('api/v1/utilities/fetch_browser_name',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key'),'browser_val'=>$browser),'php');
		foreach($browser_detail as $browser)
		{	
			$browser_name.=$browser['name'].",";
		}		
		$browsername=rtrim($browser_name,",");			
		$data['browser_details']=$browsername;
		
		$lang_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaignid,"target_type"=>"deliveryLimitations:Client:Language","api_key"=>get_session('api_key')),'php');		
		$lang=explode(",",$lang_details[0]['data']);
		$language='';
		foreach ($lang as $lan)
		{			
			$language.="'".$lan."'".",";						
		}
		$language=rtrim($language,",");					
		$lang_name='';
		$lang_detail = 	$this->rest->get('api/v1/utilities/fetch_browser_language_name',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key'),'lang_val'=>$language),'php');
		foreach($lang_detail as $lang_det)
		{	
			$lang_name.=$lang_det['name'].",";
		}		
		$langname=rtrim($lang_name,",");			
		$data['lang_details']=$langname;  
		
		$browser_version_details	= 	$this->rest->get('api/v1/campaign/fetch_brow_vers_targeting',array("campaign_id"=>$campaignid,"api_key"=>get_session('api_key')),'php');
		$browser_ver_detail=explode(",",$browser_version_details[0]['data']);
		
		$browser_version_values		=	$this->rest->get('api/v1/campaign/fetch_browser_versions',array('api_key'=>get_session("api_key"),'browser_version'=>$browser_ver_detail),'php');
		$version_name='';
		foreach($browser_version_values as $ver_det)
		{	
			$version_name.=$ver_det['text'].",";
		}		
		$version_name=rtrim($version_name,",");			
		$data['browser_version_value']=$version_name;
				
		$os_details			= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaignid,"api_key"=>get_session('api_key')),'php');
		$os=explode(",",$os_details[0]['data']);
		$operating_system='';
		foreach ($os as $operating)
		{			
			$operating_system.="'".$operating."'".",";						
		}
		$operating_system=rtrim($operating_system,",");	
		$os_name='';
		$os_detail = 	$this->rest->get('api/v1/utilities/fetch_operating_system',array("campaign_id"=>$campaignid,'api_key'=>get_session('api_key'),'os_val'=>$operating_system),'php');
		foreach($os_detail as $os_det)
		{	
			$os_name.=$os_det['name'].",";
		}		
		$osname=rtrim($os_name,",");			
		$data['os_details']=$osname; 

		//Fetch mobile manufactures targeting details
		$mobile_manu_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaignid,"api_key"=>get_session('api_key')),'php');
		$data['mobile_manu_details']=$mobile_manu_details[0]['data'];
			
		//Fetch mobile capability details
		$mobile_capa_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaignid,"api_key"=>get_session('api_key')),'php');
		$mobile_capa_detail=explode(",",$mobile_capa_details[0]['data']);		
		$capability_details=$this->rest->get('api/v1/utilities/fetch_capability_details',array("campaign_id"=>$campaignid,'api_key'=>get_session('api_key'),'capability_val'=>$mobile_capa_detail),'php');
		$capability_name='';
		foreach ($capability_details as $cap_name)
		{			
			$capability_name.=$cap_name['name'].",";						
		}
		$capabilityname=rtrim($capability_name,",");			
		$data['capability_details']=$capabilityname;
		
		//Fetch connection type
		$connection_details= 	$this->rest->get('api/v1/campaign/fetch_connection_targeting',array("campaign_id"=>$campaignid,"api_key"=>get_session('api_key')),'php');		
		$data['connection_detail']=$connection_details[0]['data'];		
		
		// Fetch Carrier Details
		$carrier_details= $this->rest->get('api/v1/campaign/fetch_carrier_targeting',array("campaign_id"=>$campaignid,"api_key"=>get_session('api_key')),'php');
		$carrier_detail=explode(",",$carrier_details[0]['data']); 
		
		$carrier_name_details=$this->rest->get('api/v1/utilities/fetch_carrier_details',array("campaign_id"=>$campaignid,'api_key'=>get_session('api_key'),'carrier_detail'=>$carrier_detail),'php');
		$carrier_name='';		
		foreach ($carrier_name_details as $name)
		{			
			$carrier_name.=$name['carriername'].",";						
		}
		$carriername=rtrim($carrier_name,",");			
		$data['carrier_details']=$carriername;	
		
		$geoinclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaignid,"target_type"=>"Include_country","api_key"=>get_session('api_key')),'php');
		$countrydata='';
		if(!empty($geoinclude_details[0]['data']))
		{
			$country_detail=explode(",",$geoinclude_details[0]['data']);			
			foreach($country_detail as $country_data)
			{					
				$countrydata.=$country_data.",";							
			}					
		}			
		$geoexclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaignid,"target_type"=>"Exclude_country","api_key"=>get_session('api_key')),'php');
		if(!empty($geoexclude_details[0]['data']))
		{
			$country_detail=explode(",",$geoexclude_details[0]['data']);			
			foreach($country_detail as $country_data)
			{					
				$countrydata.=$country_data.",";							
			}			
		}		
		$countrydata=rtrim($countrydata,",");    

		
		$country_name_details=$this->rest->get('api/v1/utilities/fetch_country_details',array("campaign_id"=>$campaignid,'api_key'=>get_session('api_key'),'country_detail'=>$countrydata),'php');
		$country_name='';		
		foreach ($country_name_details as $name)
		{			
			$country_name.=$name['name'].",";						
		}
		$countryname=rtrim($country_name,",");			
		$data['country_details']=$countryname;
						
		//City
		$city_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaignid,"target_type"=>"deliveryLimitations:Geo:City","api_key"=>get_session('api_key')),'php');
		$citydata='';
		if(!empty($city_details[0]['data']))
		{
			$city_detail=explode(",",$city_details[0]['data']);			
			foreach($city_detail as $city_data)
			{					
				$citydata.="'".$city_data."'".",";							
			}			
		}		
		$citydata=rtrim($citydata,",");   
		$city_name_details=$this->rest->get('api/v1/utilities/fetch_city_details',array("campaign_id"=>$campaignid,'api_key'=>get_session('api_key'),'city_detail'=>$city_detail),'php');
		$city_name='';		
		foreach ($city_name_details as $name)
		{			
			$city_name.=$name['city'].",";						
		}
		$cityname=rtrim($city_name,",");			
		$data['city_details']=$cityname;
		
					
		//Zip
		$zip_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaignid,"target_type"=>"deliveryLimitations:Geo:Zip","api_key"=>get_session('api_key')),'php');
		$data['zip_details'] = $zip_details;
		
		
		
		
		$data['content'] = $this->load->view('campaigns/campaign_overview',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
	    $this->template->build('view', $data);
	}
	
	public function campaign_overview_id()
	{
		$this->session->unset_userdata('campaign_detail_id');
		$this->session->set_userdata('campaign_detail_id', $_POST['id']);
		echo json_encode($this->session->userdata('campaign_detail_id'));		
	}
	
	/*
	 * 
	 * name   : overview
	 * @param : campaign_id
	 * @return: Fetch creative for particular campaign
	 */	

	public function overview($campaign_id=false)
	{
		$campaign_id= $this->input->post('_campaign_id');

		//Fetch Campaign details
		$camapaign_details['campaign_details']= $this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key'),"view_type"=>'formated'),'json');
		$camp_details_to_php_array=json_decode($camapaign_details['campaign_details']);//For verification
		if($camp_details_to_php_array[0]->dj_targetting_type=='WEB')
		{
			//Fetch browser targeting details
			$browser_details= $this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_browsers_display_name='';
			if(isset($browser_details[0]['data']) AND !empty($browser_details[0]['data']))
			{
				$browser_details_array=explode(',',$browser_details[0]['data']);
				foreach($browser_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_BROWSERS);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_browsers_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch os targeting details
			$os_details= $this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_os_display_name='';
			if(isset($os_details[0]['data']) AND !empty($os_details[0]['data']))
			{
				$os_details_array=explode(',',$os_details[0]['data']);
				foreach($os_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_OS);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_os_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch time targeting details
			$time_details= $this->rest->get('api/v1/campaign/fetch_time_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_time_display_name='';
			if(isset($time_details[0]['data']) AND !empty($time_details[0]['data']))
			{
				$targ_time_array=array('0'=>'0:00-0:59','1'=>'1:00-1:59' ,'2'=>'2:00-2:59' ,'3'=>'3:00-3:59','4'=>'4:00-4:59','5'=>'5:00-5:59' ,'6'=> '6:00-6:59','7'=> '7:00-7:59','8'=>'8:00-8:59' ,'9'=> '9:00-9:59','10'=>'10:00-10:59' ,'11'=>'11:00-11:59','12'=>'12:00-12:59','13'=>'13:00-13:59','14'=>'14:00-14:59' ,'15'=>'15:00-15:59' ,'16'=>'16:00-16:59','17'=> '17:00-17:59','18'=> '18:00-18:59','19'=>'19:00-19:59' ,'20'=>'20:00-20:59','21'=> '21:00-21:59','22'=> '22:00-22:59','23'=>'23:00-23:59');
				$time_details_array=explode(',',$time_details[0]['data']);
				foreach($time_details_array as $value)
				{
					if(isset($targ_time_array[$value]) AND !empty($targ_time_array[$value]))
						$targetted_time_display_name.=ucfirst($targ_time_array[$value]).',';
				}
			}
			
			//Fetch geo targeting details
			$geo_details= $this->rest->get('api/v1/campaign/fetch_geo_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_geo_display_name='';
			if(isset($geo_details[0]['data']) AND !empty($geo_details[0]['data']))
			{
				$geo_details_array=explode(',',$geo_details[0]['data']);
				foreach($geo_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_COUNTRY);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_geo_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			
			$capping=$camp_details_to_php_array[0]->capping;
			$block=$camp_details_to_php_array[0]->block/3600;
			$frequency_capping=$capping.'&nbsp;impression in '.$block.'&nbsp;Hours';
			
			//Fetch keyword targeting details

			$profile_keyword = $this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');

			$targetted_profile_keyword_display_name='';

			if(isset($profile_keyword[0]['data']) AND !empty($profile_keyword[0]['data']))

			{

				$profile_keyword_array=explode(',',$profile_keyword[0]['data']);

				foreach($profile_keyword_array as $value)

				{
				

					$this->db->select('keyword');

					$this->db->where('keyword',$value);

					$query = $this->db->get(TAB_TARG_KEYWORD);	

					$result = $query->result_array();
					

					if(isset($result[0]['keyword']) AND !empty($result[0]['keyword']))

						$targetted_profile_keyword_display_name.=ucfirst($result[0]['keyword']).',';

				}

			}

			//Fetch profile targeting details
			$profile_age= $this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_age_display_name='';
			if(isset($profile_age[0]['data']) AND !empty($profile_age[0]['data']))
			{
				$targ_profile_age_array=array('less_than_20'=>'Age less than 20','T_20_35'=>'Age around: 20-35','T_35_45'=>'Age around: 35-45','more_than_45'=>'Age more than 45');
				$profile_age_details_array=explode(',',$profile_age[0]['data']);
				foreach($profile_age_details_array as $value)
				{
					if(isset($targ_profile_age_array[$value]) AND !empty($targ_profile_age_array[$value]))
						$targetted_profile_age_display_name.=ucfirst($targ_profile_age_array[$value]).',';
				}
			}
			
			$profile_gender= $this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_gender_display_name='';
			if(isset($profile_gender[0]['data']) AND !empty($profile_gender[0]['data']))
			{
				$targ_profile_gender_array=array('male'=>'Gender: Male','female'=>'Gender: Female');
				$profile_gender_details_array=explode(',',$profile_gender[0]['data']);
				foreach($profile_gender_details_array as $value)
				{
					if(isset($targ_profile_gender_array[$value]) AND !empty($targ_profile_gender_array[$value]))
						$targetted_profile_gender_display_name.=ucfirst($targ_profile_gender_array[$value]).',';
				}
			}
			$profile_color= $this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_color_display_name='';
			if(isset($profile_color[0]['data']) AND !empty($profile_color[0]['data']))
			{
				$targ_profile_color_array=array('fair'=>'Color: Fair','weatish'=>'Color: Weatish','dark'=>'Color: Dark');
				$profile_color_details_array=explode(',',$profile_color[0]['data']);
				foreach($profile_color_details_array as $value)
				{
					if(isset($targ_profile_color_array[$value]) AND !empty($targ_profile_color_array[$value]))
						$targetted_profile_color_display_name.=ucfirst($targ_profile_color_array[$value]).',';
				}
			}
			$profile_height= $this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_height_display_name='';
			if(isset($profile_height[0]['data']) AND !empty($profile_height[0]['data']))
			{
				$targ_profile_height_array=array('less_than_140'=>'Height less than 140','T_140_155'=>'Height around: 140-155','T_155_175'=>'Height around: 155-175','more_than_175'=>'Height more than 175');
				$profile_height_details_array=explode(',',$profile_height[0]['data']);
				foreach($profile_height_details_array as $value)
				{
					if(isset($targ_profile_height_array[$value]) AND !empty($targ_profile_height_array[$value]))
						$targetted_profile_height_display_name.=ucfirst($targ_profile_height_array[$value]).',';
				}
			}
			$profile_weight= $this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_weight_display_name='';
			if(isset($profile_weight[0]['data']) AND !empty($profile_weight[0]['data']))
			{
				$targ_profile_weight_array=array('less_than_20'=>'Weight less than 20','T_20_35'=>'Weight around: 20-35','T_35_45'=>'weight around: 35-45','more_than_45'=>'weight more than 45');
				$profile_weight_details_array=explode(',',$profile_weight[0]['data']);
				foreach($profile_weight_details_array as $value)
				{
					if(isset($targ_profile_weight_array[$value]) AND !empty($targ_profile_weight_array[$value]))
						$targetted_profile_weight_display_name.=ucfirst($targ_profile_weight_array[$value]).',';
				}
			}
			$final_profile_targ=$targetted_profile_age_display_name.''.$targetted_profile_gender_display_name.''.$targetted_profile_color_display_name.''.$targetted_profile_height_display_name.''.$targetted_profile_weight_display_name;

			$final_targeting=array($camp_details_to_php_array[0]->dj_targetting_type=>array('targ_1'=>$targetted_browsers_display_name,'targ_2'=>$targetted_os_display_name,'targ_3'=>$targetted_time_display_name,'targ_4'=>$targetted_geo_display_name,'targ_5'=>$frequency_capping,'targ_6'=>$final_profile_targ,'targ_7'=>$targetted_profile_keyword_display_name)
			);
		}
		elseif($camp_details_to_php_array[0]->dj_targetting_type=='MOBILE')
		{
			//Fetch mobile os targeting details
			$mobile_os_details= $this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_os_display_name='';
			if(isset($mobile_os_details[0]['data']) AND !empty($mobile_os_details[0]['data']))
			{
				$mobile_os_details_array=explode(',',$mobile_os_details[0]['data']);
				foreach($mobile_os_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_MOB_OS);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_os_display_name.=ucfirst($result[0]['name']).',';
				}
			}

			//Fetch mobile manufactures targeting details
			$mobile_manu_details= $this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_manu_display_name='';
			if(isset($mobile_manu_details[0]['data']) AND !empty($mobile_manu_details[0]['data']))
			{
				$mobile_manu_details_array=explode(',',$mobile_manu_details[0]['data']);
				foreach($mobile_manu_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_MOB_MANU);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_manu_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch mobile capability details
			$mobile_capa_details= $this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_capa_display_name='';
			if(isset($mobile_capa_details[0]['data']) AND !empty($mobile_capa_details[0]['data']))
			{
				$mobile_capa_details_array=explode(',',$mobile_capa_details[0]['data']);
				foreach($mobile_capa_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_MOB_CAPA);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_capa_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch mobile tecom details
			$mobile_telecom_details= $this->rest->get('api/v1/campaign/fetch_mobile_telecom_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_telecom_display_name='';
			if(isset($mobile_telecom_details[0]['data']) AND !empty($mobile_telecom_details[0]['data']))
			{
				$mobile_telecom_details_array=explode(',',$mobile_telecom_details[0]['data']);
				foreach($mobile_telecom_details_array as $value)
				{
					$this->db->select("id as id,CONCAT(country,'-',carriername) as name",false);
					$this->db->where('id',$value);
					$query = $this->db->get(TAB_TARG_MOBILE_CARRIER);		
					$result = $query->result_array();
					if(isset($result[0]['id']) AND !empty($result[0]['name']))
						$targetted_mob_telecom_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch moblie geo targetting details
			$mobile_geo_details= $this->rest->get('api/v1/campaign/fetch_mobile_geo_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_geo_display_name='';
			if(isset($mobile_geo_details[0]['data']) AND !empty($mobile_geo_details[0]['data']))
			{
				$mobile_geo_details_array=explode(',',$mobile_geo_details[0]['data']);
				foreach($mobile_geo_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_MOB_CAPA);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_geo_display_name.=ucfirst($result[0]['name']).',';
				}
			}


            ///Fetch keyword targeting details

			$profile_keyword= $this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');

			$targetted_profile_keyword_display_name='';

			if(isset($profile_keyword[0]['data']) AND !empty($profile_keyword[0]['data']))

			{

				$profile_keyword_array=explode(',',$profile_keyword[0]['data']);

				foreach($profile_keyword_array as $value)

				{

					$this->db->select('keyword');

					$this->db->where('keyword',$value);

					$query = $this->db->get(TAB_TARG_KEYWORD);		

					$result = $query->result_array();

					if(isset($result[0]['keyword']) AND !empty($result[0]['keyword']))

						$targetted_profile_keyword_display_name.=ucfirst($result[0]['keyword']).',';

				}

			}
			
			

			//Fetch profile targeting details
			$profile_age= $this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_age_display_name='';
			if(isset($profile_age[0]['data']) AND !empty($profile_age[0]['data']))
			{
				$targ_profile_age_array=array('less_than_20'=>'Age less than 20','T_20_35'=>'Age around: 20-35','T_35_45'=>'Age around: 35-45','more_than_45'=>'Age more than 45');
				$profile_age_details_array=explode(',',$profile_age[0]['data']);
				foreach($profile_age_details_array as $value)
				{
					if(isset($targ_profile_age_array[$value]) AND !empty($targ_profile_age_array[$value]))
						$targetted_profile_age_display_name.=ucfirst($targ_profile_age_array[$value]).',';
				}
			}
			
			$profile_gender= $this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_gender_display_name='';
			if(isset($profile_gender[0]['data']) AND !empty($profile_gender[0]['data']))
			{
				$targ_profile_gender_array=array('male'=>'Gender: Male','female'=>'Gender: Female');
				$profile_gender_details_array=explode(',',$profile_gender[0]['data']);
				foreach($profile_gender_details_array as $value)
				{
					if(isset($targ_profile_gender_array[$value]) AND !empty($targ_profile_gender_array[$value]))
						$targetted_profile_gender_display_name.=ucfirst($targ_profile_gender_array[$value]).',';
				}
			}
			$profile_color= $this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_color_display_name='';
			if(isset($profile_color[0]['data']) AND !empty($profile_color[0]['data']))
			{
				$targ_profile_color_array=array('fair'=>'Color: Fair','weatish'=>'Color: Weatish','dark'=>'Color: Dark');
				$profile_color_details_array=explode(',',$profile_color[0]['data']);
				foreach($profile_color_details_array as $value)
				{
					if(isset($targ_profile_color_array[$value]) AND !empty($targ_profile_color_array[$value]))
						$targetted_profile_color_display_name.=ucfirst($targ_profile_color_array[$value]).',';
				}
			}
			$profile_height= $this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_height_display_name='';
			if(isset($profile_height[0]['data']) AND !empty($profile_height[0]['data']))
			{
				$targ_profile_height_array=array('less_than_140'=>'Height less than 140','T_140_155'=>'Height around: 140-155','T_155_175'=>'Height around: 155-175','more_than_175'=>'Height more than 175');
				$profile_height_details_array=explode(',',$profile_height[0]['data']);
				foreach($profile_height_details_array as $value)
				{
					if(isset($targ_profile_height_array[$value]) AND !empty($targ_profile_height_array[$value]))
						$targetted_profile_height_display_name.=ucfirst($targ_profile_height_array[$value]).',';
				}
			}
			$profile_weight= $this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_weight_display_name='';
			if(isset($profile_weight[0]['data']) AND !empty($profile_weight[0]['data']))
			{
				$targ_profile_weight_array=array('less_than_20'=>'Weight less than 20','T_20_35'=>'Weight around: 20-35','T_35_45'=>'weight around: 35-45','more_than_45'=>'weight more than 45');
				$profile_weight_details_array=explode(',',$profile_weight[0]['data']);
				foreach($profile_weight_details_array as $value)
				{
					if(isset($targ_profile_weight_array[$value]) AND !empty($targ_profile_weight_array[$value]))
						$targetted_profile_weight_display_name.=ucfirst($targ_profile_weight_array[$value]).',';
				}
			}
			$final_profile_targ=$targetted_profile_age_display_name.''.$targetted_profile_gender_display_name.''.$targetted_profile_color_display_name.''.$targetted_profile_height_display_name.''.$targetted_profile_weight_display_name;

			$final_targeting=array($camp_details_to_php_array[0]->dj_targetting_type=>array('targ_1'=>$targetted_mob_os_display_name,'targ_2'=>$targetted_mob_manu_display_name,'targ_3'=>$targetted_mob_capa_display_name,'targ_4'=>$targetted_mob_telecom_display_name,'targ_5'=>$targetted_mob_geo_display_name,'targ_6'=>$final_profile_targ,'targ_7'=>$targetted_profile_keyword_display_name)
			);
		}

		$existing_creative	= $this->rest->get('api/v1/campaign/fetch_linked_creative',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		if(!empty($existing_creative))
			$no_of_creative['no_of_linked_creative']=sizeof($existing_creative);
		else
			$no_of_creative['no_of_linked_creative']='0';
		
		$result_tmp=array_merge($camapaign_details,$no_of_creative);
		
		if(isset($final_targeting))
		{
			$result=json_encode(array_merge($result_tmp,$final_targeting));
			print_r($result);
		}
		else
		{
			$result=json_encode($result_tmp);
			print_r($result);
		}
		
		
	} 

	
	/*
	 * 
	 * name   : view_tracker
	 * @param : campaign_id
	 * @return: Fetch campaign tracker code for particular campaign
	 */	
	public function view_tracker($campaign_id=false)
	{
		$campaign_id=$this->session->userdata('adv_campaign_tracker_id');
	$data['track_id'] = 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'json');
	//	print_r($data['track_id']);exit;
		$tracker_data		=	array();
		if($data['track_id']!='error')
		{
			$tracker_data 	= 	$this->rest->get('api/v1/tracker/fetch_tracker',array("tracker_id"=>str_replace('"', "", $data['track_id']),"api_key"=>get_session('api_key')),'php');
		}
		
		$data['tracker_data']	=	$tracker_data;
	
		//echo $this->load->view('campaigns/view_trackers_content',$data);	
		$data['content'] = $this->load->view('campaigns/view_trackers_content',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);		
	}
	
	public function targeting_list()
	{
		$api_key		=	get_session('api_key');
		
		$data['browsers']	= 	$this->rest->get('api/v1/utilities/fetch_target_browsers',array("api_key"=>$api_key),'php');
		
		$data['language']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'language'),'php');
		
		$data['os_set']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'os_set'),'php');
		
		$data['os']			= 	$this->rest->get('api/v1/utilities/fetch_target_os',array("api_key"=>$api_key),'php');
		
		//$data['keywords']	= 	$this->rest->get('api/v1/utilities/fetch_target_keyword',array("api_key"=>$api_key),'php');
		
		$data['keywords']	= 	$this->rest->get('api/v1/creative/fetch_keyword',array("api_key"=>$api_key),'php');

		$data['mobile_os']	= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_os',array("api_key"=>$api_key),'php');
		
		$data['manu']		= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_manu',array("api_key"=>$api_key),'php');
		
		$data['capability']	= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_capability',array("api_key"=>$api_key),'php');
		
		$data['carrier']	= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_carrier',array("api_key"=>$api_key),'php');
		
		$data['continent']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'continent'),'php');
		
		$data['countries']	= 	$this->rest->get('api/v1/utilities/fetch_target_countries',array("api_key"=>$api_key),'php');
		
		$data['time']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'time'),'php');
		
		$data['days']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'days'),'php');
		
		$data['dev_type']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'dev_type'),'php');
		
		$data['device']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'device'),'php');
		
		$data['connection']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'connection'),'php');
		
		
		return $data;
	}
	
	public function add_group()
	{
		$data	=	'';
		$api_key=	get_session('api_key'); 
	    echo  $this->load->view('creatives/modal_creatives/content/add_group',$data);	
	}
	
	/*
	* 
	* name   : duplicate
	* @param : campaign_id
	* @return: Fetch campaign tracker code for particular campaign
	*/	
	public function duplicate($campaignid=false,$campname=false)
	{
		//Fetch Country
		$campaign_values = $this->session->userdata('adv_campaign_duplicate_id');
		
		$campaign_split = explode("/",$campaign_values);
		
		$data['countries']		= 	$this->rest->get('api/v1/utilities/fetch_target_countries',array("api_key"=>get_session("api_key")),'php');
		
		//Fetch available campaign type
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
	
		$data['campaignid']		=	$campaign_split[0];
		
		$data['campname']		=	$campaign_split[1];
		
		//echo $this->load->view('campaigns/content/duplicate_campaign_multiple',$data);		
		
		$data['content'] = $this->load->view('campaigns/content/duplicate_campaign_multiple',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);	
	}
//campaign sample file download 
	function campaign_import_download_file()
	{ 
		
		$data = file_get_contents("./csv/upload/camp_import.csv"); // Read the file's contents		
		$name = 'camp_import.csv';
		 ob_clean();
		force_download($name, $data);  
	}
	
	function campaign_import_download_file_txt()
	{ 
		$data = file_get_contents("./csv/upload/camp_import.txt"); // Read the file's contents			
		$name = 'camp_import.txt';
		 ob_clean();
		force_download($name, $data);    
	}
		function campaign_import_download_file_xml()
	{ 
		$data = file_get_contents("./csv/upload/camp_import.xml"); // Read the file's contents			
		$name = 'camp_import.xml';
		 ob_clean();
		force_download($name, $data);    
	}
	
	function download($campaign_id=false,$format=false)
	{
		$campaignid= rawurldecode($campaign_id);  
		if($campaignid!=false)
		{	

			//$export_list=$this->rest->get('api/v1/campaign/testing',array('campaignid'=>$campaignid,'api_key'=>get_session('api_key')),'php');
			
			$campaign_list = 	$this->rest->get('api/v1/campaign/fetch_export_data',array("campaign_id"=>$campaignid,"api_key"=>get_session('api_key')),'json');
		
			$listed_data = json_decode($campaign_list, true);	
			foreach($listed_data as $cam_id)
			{
			$cam[]=$cam_id['campaignid'];
			}	
			$imp=implode(',',$cam);
			$cmp_s= str_replace(",","_cid_",$imp);
			if($cmp_s)
			{
				$cmp_fn='cid_'.$cmp_s;
			}
			else
			{
				$cmp_fn='cid_'.$imp;
			}
						
			if($format=="csv")
			{				
					$filename=$cmp_fn.'.csv';
					header('Content-type: text/csv');
					header('Content-Disposition: attachment; filename='.$filename);
                    ob_clean();
					$csv = "campaignname,clientid,views,clicks,conversions,priority,weight,revenue,revenue_type,block,capping,session_capping,status,dj_budget_status,viewwindow,clickwindow,ecpm,min_impressions,activate_time,end_time,cpv_percentage,cam_status,dj_campaign_budget,dj_is_retargeted,behavior,dj_max_retargetting,dj_daily_budget,daily_budget_unlimit,dj_campaign_remain_budget,dj_campaign_remain_total_budget,dj_current_date,dj_targetting_type,group_id,global_tracker,trackerid\n";
					
					for($i=0;$i<count($listed_data);$i++){
						
						$csv.= $listed_data[$i]['cam_name'].','.$listed_data[$i]['clientid'].','.$listed_data[$i]['views'].','.$listed_data[$i]['clicks'].','.$listed_data[$i]['conversions'].','.$listed_data[$i]['priority'].','.$listed_data[$i]['weight'].','.$listed_data[$i]['revenue'].','.$listed_data[$i]['revenue_type'].','.$listed_data[$i]['block'].','.$listed_data[$i]['capping'].','.$listed_data[$i]['session_capping'].','.$listed_data[$i]['status'].','.$listed_data[$i]['dj_budget_status'].','.$listed_data[$i]['viewwindow'].','.$listed_data[$i]['clickwindow'].','.$listed_data[$i]['ecpm'].','.$listed_data[$i]['min_impressions'].','.$listed_data[$i]['start_time'].','.$listed_data[$i]['end_time'].','.$listed_data[$i]['cpv_percentage'].','.$listed_data[$i]['cam_status'].','.$listed_data[$i]['dj_campaign_budget'].','.$listed_data[$i]['dj_is_retargeted'].','.$listed_data[$i]['behavior'].','.$listed_data[$i]['dj_max_retargetting'].','.$listed_data[$i]['dj_daily_budget'].','.$listed_data[$i]['daily_budget_unlimit'].','.$listed_data[$i]['dj_campaign_remain_budget'].','.$listed_data[$i]['dj_campaign_remain_total_budget'].','.$listed_data[$i]['dj_current_date'].','.$listed_data[$i]['dj_targetting_type'].','.$listed_data[$i]['group_id'].','.$listed_data[$i]['global_tracker'].','.$listed_data[$i]['trackerid']."\n";
					}
					
					print_r($csv);  
			}
			else if($format =='txt')
			{
				$listed_txt = array ();
				$delimiter = "\t";
				$filename=$cmp_fn.'.txt';
				header('Content-type: text/tab-separated-values');
				header("Content-Disposition: attachment;filename=".$filename);	
				ob_clean();
				$txt = "campaignname,clientid,views,clicks,conversions,priority,weight,revenue,revenue_type,block,capping,session_capping,status,dj_budget_status,viewwindow,clickwindow,ecpm,min_impressions,activate_time,end_time,cpv_percentage,cam_status,dj_campaign_budget,dj_is_retargeted,behavior,dj_max_retargetting,dj_daily_budget,daily_budget_unlimit,dj_campaign_remain_budget,dj_campaign_remain_total_budget,dj_current_date,dj_targetting_type,group_id,global_tracker,trackerid\n";
				
											
				for($i=0;$i<count($listed_data);$i++)
				{
					
					$txt.= $listed_data[$i]['cam_name'].','.$listed_data[$i]['clientid'].','.$listed_data[$i]['views'].','.$listed_data[$i]['clicks'].','.$listed_data[$i]['conversions'].','.$listed_data[$i]['priority'].','.$listed_data[$i]['weight'].','.$listed_data[$i]['revenue'].','.$listed_data[$i]['revenue_type'].','.$listed_data[$i]['block'].','.$listed_data[$i]['capping'].','.$listed_data[$i]['session_capping'].','.$listed_data[$i]['status'].','.$listed_data[$i]['dj_budget_status'].','.$listed_data[$i]['viewwindow'].','.$listed_data[$i]['clickwindow'].','.$listed_data[$i]['ecpm'].','.$listed_data[$i]['min_impressions'].','.$listed_data[$i]['start_time'].','.$listed_data[$i]['end_time'].','.$listed_data[$i]['cpv_percentage'].','.$listed_data[$i]['cam_status'].','.$listed_data[$i]['dj_campaign_budget'].','.$listed_data[$i]['dj_is_retargeted'].','.$listed_data[$i]['behavior'].','.$listed_data[$i]['dj_max_retargetting'].','.$listed_data[$i]['dj_daily_budget'].','.$listed_data[$i]['daily_budget_unlimit'].','.$listed_data[$i]['dj_campaign_remain_budget'].','.$listed_data[$i]['dj_campaign_remain_total_budget'].','.$listed_data[$i]['dj_current_date'].','.$listed_data[$i]['dj_targetting_type'].','.$listed_data[$i]['group_id'].','.$listed_data[$i]['global_tracker'].','.$listed_data[$i]['trackerid']."\n";
					
				/*	$listed_txt[] = array($listed_data[$i]['cam_name'],$listed_data[$i]['clientid'],$listed_data[$i]['views'],$listed_data[$i]['clicks'],
					$listed_data[$i]['conversions'],$listed_data[$i]['priority'],$listed_data[$i]['weight'],$listed_data[$i]['revenue'],$listed_data[$i]['revenue_type'],$listed_data[$i]['block'],$listed_data[$i]['capping'],$listed_data[$i]['session_capping'],$listed_data[$i]['status'],$listed_data[$i]['dj_budget_status'],$listed_data[$i]['viewwindow'],$listed_data[$i]['clickwindow'],$listed_data[$i]['ecpm'],$listed_data[$i]['min_impressions'],$listed_data[$i]['start_time'],$listed_data[$i]['end_time'],$listed_data[$i]['cpv_percentage'],$listed_data[$i]['cam_status'],$listed_data[$i]['dj_campaign_budget'],$listed_data[$i]['dj_is_retargeted'],$listed_data[$i]['behavior'],$listed_data[$i]['dj_max_retargetting'],$listed_data[$i]['dj_daily_budget'],$listed_data[$i]['daily_budget_unlimit'],$listed_data[$i]['dj_campaign_remain_budget'],$listed_data[$i]['dj_campaign_remain_total_budget'],$listed_data[$i]['dj_current_date'],$listed_data[$i]['dj_targetting_type']);*/
				}	
					print_r($txt); 		
				//~ foreach ($txt as $listkey => $list) 
				//~ {
						//~ $dataRowString = implode($delimiter, $list);
						//~ print $dataRowString . "\r\n";
				//~ }				
			}
			else if($format =='xml')
			{
				$filename=$cmp_fn.'.xml';
				header('Content-Type: text/xml');
				header("Content-Disposition: attachment;filename=".$filename);
				ob_clean();
				$xml = new SimpleXMLElement('<campaigns/>');
				$xml->addAttribute("xmlns", "http://tempuri.org/ds.xsd");
				for($i=0;$i<count($listed_data);$i++)
				{
						$cam_list = $xml->addChild("campaign");
						$cam_list->addChild('campaignname',$listed_data[$i]['cam_name']);
						$cam_list->addChild('clientid', $listed_data[$i]['clientid']);
						$cam_list->addChild('views', $listed_data[$i]['views']);
						$cam_list->addChild('clicks', $listed_data[$i]['clicks']);
						$cam_list->addChild('conversions', $listed_data[$i]['conversions']);
						$cam_list->addChild('priority', $listed_data[$i]['priority']);
						$cam_list->addChild('weight', $listed_data[$i]['weight']);
						$cam_list->addChild('revenue', $listed_data[$i]['revenue']);
						$cam_list->addChild('revenue_type', $listed_data[$i]['revenue_type']);
						$cam_list->addChild('block', $listed_data[$i]['block']);
						$cam_list->addChild('capping', $listed_data[$i]['capping']);
						$cam_list->addChild('session_capping', $listed_data[$i]['session_capping']);
						$cam_list->addChild('status', $listed_data[$i]['status']);
						$cam_list->addChild('dj_budget_status', $listed_data[$i]['dj_budget_status']);
						$cam_list->addChild('viewwindow', $listed_data[$i]['viewwindow']);
						$cam_list->addChild('clickwindow', $listed_data[$i]['clickwindow']);
						$cam_list->addChild('ecpm', $listed_data[$i]['ecpm']);
						$cam_list->addChild('min_impressions', $listed_data[$i]['min_impressions']);
						$cam_list->addChild('activate_time', $listed_data[$i]['start_time']);
						$cam_list->addChild('end_time', $listed_data[$i]['end_time']);
						$cam_list->addChild('cpv_percentage',$listed_data[$i]['cpv_percentage']);
						$cam_list->addChild('cam_status',$listed_data[$i]['cam_status']);						
						$cam_list->addChild('dj_campaign_budget',$listed_data[$i]['dj_campaign_budget']);
						$cam_list->addChild('dj_is_retargeted',$listed_data[$i]['dj_is_retargeted']);
						$cam_list->addChild('behavior',$listed_data[$i]['behavior']);
						$cam_list->addChild('dj_max_retargetting',$listed_data[$i]['dj_max_retargetting']);
						$cam_list->addChild('dj_daily_budget',$listed_data[$i]['dj_daily_budget']);
						$cam_list->addChild('daily_budget_unlimit',$listed_data[$i]['daily_budget_unlimit']);
						$cam_list->addChild('dj_campaign_remain_budget',$listed_data[$i]['dj_campaign_remain_budget']);
						$cam_list->addChild('dj_campaign_remain_total_budget',$listed_data[$i]['dj_campaign_remain_total_budget']);
						$cam_list->addChild('dj_current_date',$listed_data[$i]['dj_current_date']);						
						$cam_list->addChild('dj_targetting_type',$listed_data[$i]['dj_targetting_type']);				
						$cam_list->addChild('group_id',$listed_data[$i]['group_id']);				
						$cam_list->addChild('global_tracker',$listed_data[$i]['global_tracker']);				
						$cam_list->addChild('trackerid',$listed_data[$i]['trackerid']);						
						}
				print($xml->asXML());
				
			}			
		}
		
	}
	
	public function add_camp_second_div()
	{        
		$data['page_title'] = "Add campaigns";

		$data['breadcrumb'] = '';
		
		/************ Video Enable/Disable *************/
		$this->load->library('default_configurations');
		
		$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
		
		//Minimum Budget & Bid Rate & creatives allowed
		$data['min_budget']		=	$this->default_configurations->get('min_budget');
		
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
		
		$data['creat_allowed']	=	$this->default_configurations->get('direct_creative_type');
		
		/************ Video Enable/Disable *************/  
		
		$data['creative_size'] 		= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'php');
		
		$data['mob_screen_size']	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>get_session('api_key')),'php');
		
		$data['lang_data'] 			=	$this->rest->get('api/v1/campaign/fetch_language',array('api_key'=>get_session('api_key')),'php');
					
		//Fetch Publisher
		$adm						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$data['pub_data'] 			=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$adm[0]['api_key']),'php');
		$data['adb_data'] 			=	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$adm[0]['api_key']),'php');		
		$data['preset_black']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'black'),'php');		
						
		$data['preset_white']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'white'),'php');		
		
		
				
		//Fetch available site categories
		$data['campaign_category']	=	$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>get_session('api_key')),'php');

		$data['camp_sub_category']	=	$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>get_session('api_key')),'php');

		//Fetch Country
		$data['countrylist']		=	$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>get_session('api_key')),'php');		
		
		$data['group']				=	$this->rest->get('api/v1/creative/fetch_group',array('api_key'=>get_session("api_key")),'php');

		$data['browser_vers']		=	$this->rest->get('api/v1/creative/fetch_browser_versions',array('api_key'=>get_session("api_key")),'php');		
		
		$data['os_vers']		=	$this->rest->get('api/v1/targeting/fetch_os_version',array('api_key'=>get_session("api_key")),'php');
				
		$data['tracker']			= 	$this->rest->get('api/v1/tracker/fetch_tracker',array('api_key'=>get_session('api_key')),'php');		
		
		//Fetch available campaign type
		$data['campaign_type']		= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
	
	    //print_r($data['campaign_type']);  die();
	
		$data['target']				=	$this->targeting_list();
		
		/**** Cookie setup -- start ************/
		$prod_name = $this->config->item('prod_name'); 
		
		$bid_data 					=	$this->rest->get('api/v1/campaign/fetch_realtime_bidding',array('api_key'=>get_session('api_key')),'php');
						
		$data['best_bid_rate']			=	($bid_data!='error')?$bid_data[0]['best_bid_rate']:'';
		$data['min_bid_rate']			=	($bid_data!='error')?$bid_data[0]['min_bid_rate']:'';
		$data['max_bid_rate']			=	($bid_data!='error')?$bid_data[0]['max_bid_rate']:'';
		
		//echo $this->rest->debug();exit;
			
		//For available ssp categories
        $data['ssp_category'] 		= 	$this->rest->get('api/v1/utilities/ssplist', array("api_key" => get_session('api_key')) , 'php');
		
		$data['freq_capp']	=	$this->rest->get('api/v1/campaign/fetch_frequency_list', array("api_key" => get_session('api_key')) , 'php');
		
		$data['previous_campaigns']		= $this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');		
		
		$data['wallet_balance']		= $this->rest->get('api/v1/campaign/wallet_balances',array("api_key"=>get_session('api_key')),'php');	
		if(isset($_COOKIE[$prod_name.'_adv_campaign_user_data'])!='') 
		{
			$campaign_id		=	$_COOKIE[$prod_name.'_adv_campaign_user_data'];				
			
			//Fetch Campaign details
			$campaign_details	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		
			$data['campaign_det']=	$campaign_details[0];
			
			$s2s_details		= 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"s2s"=>'1',"api_key"=>get_session('api_key')),'php');
			
			//Fetch browser targeting details
			$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch os targeting details
			$os_details			= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch profile targeting details
			$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_gender		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_color		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_height		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_weight		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_keyword	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');
			
			//Fetch mobile os targeting details
			$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile manufactures targeting details
			$mobile_manu_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile capability details
			$mobile_capa_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch geo targeting details
			$geoinclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Include:country","api_key"=>get_session('api_key')),'php');
			
			$geoexclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Exclude:country","api_key"=>get_session('api_key')),'php');
							
			//Language
			$lang_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Client:Language","api_key"=>get_session('api_key')),'php');
			
			//City
			$city_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:City","api_key"=>get_session('api_key')),'php');
			
			//Zip
			$zip_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:Zip","api_key"=>get_session('api_key')),'php');
			
			//Device
			$device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"device:".strtolower($data['campaign_det']['dj_targetting_type']),"api_key"=>get_session('api_key')),'php');
			
			//Blacklist
			$black_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$white_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:whitelist","api_key"=>get_session('api_key')),'php');
				
			//Blacklist
			$pblack_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$pwhite_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_whitelist","api_key"=>get_session('api_key')),'php');
							
			//Time
			$time_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Hour","api_key"=>get_session('api_key')),'php');
			
			//Daypart
			$daypart_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Day","api_key"=>get_session('api_key')),'php');
			
			//Day time
			//$daytime_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Day:Time","api_key"=>get_session('api_key')),'php');
			
			//URL Keyword
			$url_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:url","api_key"=>get_session('api_key')),'php');
			
			//Connection
			$connect_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"connection","api_key"=>get_session('api_key')),'php');
			
			//Carrier
			$carrier_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"carrier","api_key"=>get_session('api_key')),'php');
			
			$data['targ_geo_include']	=	$geoinclude_details[0];
			$data['targ_geo_exclude']	=	$geoexclude_details[0];
			$data['targ_lang']			=	$lang_details[0];
			$data['targ_city']			=	$city_details[0];
			$data['targ_zip']			=	$zip_details[0];
			$data['targ_device']		=	$device_details[0];
			$data['targ_black']			=	$black_details[0];
			$data['targ_white']			=	$white_details[0];
			$data['targ_pblack']		=	$pblack_details[0];
			$data['targ_pwhite']		=	$pwhite_details[0];
			
			$data['targ_time']			=	$time_details[0];
			$data['targ_daypart']		=	$daypart_details[0];
			//$data['targ_day_time']	=	$daytime_details[0];				
			$data['targ_url']			=	$url_details[0];
			$data['targ_connect']		=	$connect_details[0];
			$data['targ_carrier']		=	$carrier_details[0];
			
			//Traffic sources
			$data['traffic']			= 	$this->rest->get('api/v1/campaign/fetch_campaign_traffic',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Country Bidding
			$data['country_bid']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_bidding',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			$selected_group			 	= 	$this->rest->get('api/v1/creative/fetch_select_group',array("campaign_id"=>$campaign_id,"api_key"=>get_session("api_key")),'php');
			
			$data['select_group']		=	(!empty($selected_group) && $selected_group[0])?$selected_group[0]['group_id']:'';
			
			$sel_tracker				= 	$this->rest->get('api/v1/tracker/fetch_campaign_tracker',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key')),'php');		
			
			$data['select_tracker']		=	($sel_tracker!='error' && !empty($sel_tracker))?$sel_tracker[0]['trackerid']:'';
			
			$data['campaign_id']		=	$campaign_id;				
			$data['s2s_details']		=	$s2s_details[0];
			$data['targ_browser']		=	$browser_details[0];
			$data['targ_os']			=	$os_details[0];
			$data['targ_time']			=	$time_details[0];
			
			$data['profile_age']		=	$profile_age[0];
			$data['profile_gender']		=	$profile_gender[0];
			$data['profile_color']		=	$profile_color[0];
			$data['profile_height']		=	$profile_height[0];
			$data['profile_weight']		=	$profile_weight[0];
			
			$data['profile_keyword']	=	$profile_keyword[0];
			
			$data['targ_mob_manu']		=	$mobile_manu_details[0];
			$data['targ_mob_capa']		=	$mobile_capa_details[0];
			$data['targ_mob_tele']		=	$mobile_telecom_details[0];
			
	    }
		$data['datas']		=	$data;		
		$data['content'] = $this->load->view('campaigns/add_camp_second_div',$data);
		
	   
	}
	public function add_camp_third_div()
	{        
		$data['page_title'] = "Add campaigns";

		$data['breadcrumb'] = '';
		
		/************ Video Enable/Disable *************/
		$this->load->library('default_configurations');
		
		$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
		
		//Minimum Budget & Bid Rate & creatives allowed
		$data['min_budget']		=	$this->default_configurations->get('min_budget');
		
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
		
		$data['creat_allowed']	=	$this->default_configurations->get('direct_creative_type');
		
		/************ Video Enable/Disable *************/  
		
		$data['creative_size'] 		= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'php');
		
		$data['mob_screen_size']	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>get_session('api_key')),'php');
		
		$data['lang_data'] 			=	$this->rest->get('api/v1/campaign/fetch_language',array('api_key'=>get_session('api_key')),'php');
					
		//Fetch Publisher
		$adm						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$data['pub_data'] 			=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$adm[0]['api_key']),'php');
		$data['adb_data'] 			=	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$adm[0]['api_key']),'php');		
		$data['preset_black']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'black'),'php');		
						
		$data['preset_white']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'white'),'php');		
		
		
				
		//Fetch available site categories
		$data['campaign_category']	=	$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>get_session('api_key')),'php');

		$data['camp_sub_category']	=	$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>get_session('api_key')),'php');

		//Fetch Country
		$data['countrylist']		=	$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>get_session('api_key')),'php');		
		
		$data['group']				=	$this->rest->get('api/v1/creative/fetch_group',array('api_key'=>get_session("api_key")),'php');

		$data['browser_vers']		=	$this->rest->get('api/v1/creative/fetch_browser_versions',array('api_key'=>get_session("api_key")),'php');		
		
		$data['os_vers']		=	$this->rest->get('api/v1/targeting/fetch_os_version',array('api_key'=>get_session("api_key")),'php');
				
		$data['tracker']			= 	$this->rest->get('api/v1/tracker/fetch_tracker',array('api_key'=>get_session('api_key')),'php');		
		
		//Fetch available campaign type
		$data['campaign_type']		= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
	
	    //print_r($data['campaign_type']);  die();
	
		$data['target']				=	$this->targeting_list();
		
		/**** Cookie setup -- start ************/
		$prod_name = $this->config->item('prod_name'); 
		
		$bid_data 					=	$this->rest->get('api/v1/campaign/fetch_realtime_bidding',array('api_key'=>get_session('api_key')),'php');
						
		$data['best_bid_rate']			=	($bid_data!='error')?$bid_data[0]['best_bid_rate']:'';
		$data['min_bid_rate']			=	($bid_data!='error')?$bid_data[0]['min_bid_rate']:'';
		$data['max_bid_rate']			=	($bid_data!='error')?$bid_data[0]['max_bid_rate']:'';
		
		//echo $this->rest->debug();exit;
			
		//For available ssp categories
        $data['ssp_category'] 		= 	$this->rest->get('api/v1/utilities/ssplist', array("api_key" => get_session('api_key')) , 'php');
		
		$data['freq_capp']	=	$this->rest->get('api/v1/campaign/fetch_frequency_list', array("api_key" => get_session('api_key')) , 'php');
		
		$data['previous_campaigns']		= $this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');		
		
		$data['wallet_balance']		= $this->rest->get('api/v1/campaign/wallet_balances',array("api_key"=>get_session('api_key')),'php');	
		if(isset($_COOKIE[$prod_name.'_adv_campaign_user_data'])!='') 
		{
			$campaign_id		=	$_COOKIE[$prod_name.'_adv_campaign_user_data'];				
			
			//Fetch Campaign details
			$campaign_details	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		
			$data['campaign_det']=	$campaign_details[0];
			
			$s2s_details		= 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"s2s"=>'1',"api_key"=>get_session('api_key')),'php');
			
			//Fetch browser targeting details
			$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch os targeting details
			$os_details			= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch profile targeting details
			$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_gender		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_color		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_height		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_weight		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_keyword	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');
			
			//Fetch mobile os targeting details
			$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile manufactures targeting details
			$mobile_manu_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile capability details
			$mobile_capa_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch geo targeting details
			$geoinclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Include:country","api_key"=>get_session('api_key')),'php');
			
			$geoexclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Exclude:country","api_key"=>get_session('api_key')),'php');
							
			//Language
			$lang_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Client:Language","api_key"=>get_session('api_key')),'php');
			
			//City
			$city_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:City","api_key"=>get_session('api_key')),'php');
			
			//Zip
			$zip_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:Zip","api_key"=>get_session('api_key')),'php');
			
			//Device
			$device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"device:".strtolower($data['campaign_det']['dj_targetting_type']),"api_key"=>get_session('api_key')),'php');
			
			//Blacklist
			$black_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$white_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:whitelist","api_key"=>get_session('api_key')),'php');
				
			//Blacklist
			$pblack_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$pwhite_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_whitelist","api_key"=>get_session('api_key')),'php');
							
			//Time
			$time_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Hour","api_key"=>get_session('api_key')),'php');
			
			//Daypart
			$daypart_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Day","api_key"=>get_session('api_key')),'php');
			
			//Day time
			//$daytime_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Day:Time","api_key"=>get_session('api_key')),'php');
			
			//URL Keyword
			$url_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:url","api_key"=>get_session('api_key')),'php');
			
			//Connection
			$connect_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"connection","api_key"=>get_session('api_key')),'php');
			
			//Carrier
			$carrier_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"carrier","api_key"=>get_session('api_key')),'php');
			
			$data['targ_geo_include']	=	$geoinclude_details[0];
			$data['targ_geo_exclude']	=	$geoexclude_details[0];
			$data['targ_lang']			=	$lang_details[0];
			$data['targ_city']			=	$city_details[0];
			$data['targ_zip']			=	$zip_details[0];
			$data['targ_device']		=	$device_details[0];
			$data['targ_black']			=	$black_details[0];
			$data['targ_white']			=	$white_details[0];
			$data['targ_pblack']		=	$pblack_details[0];
			$data['targ_pwhite']		=	$pwhite_details[0];
			
			$data['targ_time']			=	$time_details[0];
			$data['targ_daypart']		=	$daypart_details[0];
			//$data['targ_day_time']	=	$daytime_details[0];				
			$data['targ_url']			=	$url_details[0];
			$data['targ_connect']		=	$connect_details[0];
			$data['targ_carrier']		=	$carrier_details[0];
			
			//Traffic sources
			$data['traffic']			= 	$this->rest->get('api/v1/campaign/fetch_campaign_traffic',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Country Bidding
			$data['country_bid']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_bidding',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			$selected_group			 	= 	$this->rest->get('api/v1/creative/fetch_select_group',array("campaign_id"=>$campaign_id,"api_key"=>get_session("api_key")),'php');
			
			$data['select_group']		=	(!empty($selected_group) && $selected_group[0])?$selected_group[0]['group_id']:'';
			
			$sel_tracker				= 	$this->rest->get('api/v1/tracker/fetch_campaign_tracker',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key')),'php');		
			
			$data['select_tracker']		=	($sel_tracker!='error' && !empty($sel_tracker))?$sel_tracker[0]['trackerid']:'';
			
			$data['campaign_id']		=	$campaign_id;				
			$data['s2s_details']		=	$s2s_details[0];
			$data['targ_browser']		=	$browser_details[0];
			$data['targ_os']			=	$os_details[0];
			$data['targ_time']			=	$time_details[0];
			
			$data['profile_age']		=	$profile_age[0];
			$data['profile_gender']		=	$profile_gender[0];
			$data['profile_color']		=	$profile_color[0];
			$data['profile_height']		=	$profile_height[0];
			$data['profile_weight']		=	$profile_weight[0];
			
			$data['profile_keyword']	=	$profile_keyword[0];
			
			$data['targ_mob_manu']		=	$mobile_manu_details[0];
			$data['targ_mob_capa']		=	$mobile_capa_details[0];
			$data['targ_mob_tele']		=	$mobile_telecom_details[0];
			
	    }
		$data['datas']		=	$data;		
		$data['content'] = $this->load->view('campaigns/add_camp_third_div',$data);
		
	   
	}
	public function add_camp_fourth_div()
	{        
		$data['page_title'] = "Add campaigns";

		$data['breadcrumb'] = '';
		
		/************ Video Enable/Disable *************/
		$this->load->library('default_configurations');
		
		$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
		
		//Minimum Budget & Bid Rate & creatives allowed
		$data['min_budget']		=	$this->default_configurations->get('min_budget');
		
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
		
		$data['creat_allowed']	=	$this->default_configurations->get('direct_creative_type');
		
		/************ Video Enable/Disable *************/  
		
		$data['creative_size'] 		= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'php');
		
		$data['mob_screen_size']	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>get_session('api_key')),'php');
		
		$data['lang_data'] 			=	$this->rest->get('api/v1/campaign/fetch_language',array('api_key'=>get_session('api_key')),'php');
					
		//Fetch Publisher
		$adm						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$data['pub_data'] 			=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$adm[0]['api_key']),'php');
		$data['adb_data'] 			=	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$adm[0]['api_key']),'php');		
		$data['preset_black']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'black'),'php');		
						
		$data['preset_white']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'white'),'php');		
		
		
				
		//Fetch available site categories
		$data['campaign_category']	=	$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>get_session('api_key')),'php');

		$data['camp_sub_category']	=	$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>get_session('api_key')),'php');

		//Fetch Country
		$data['countrylist']		=	$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>get_session('api_key')),'php');		
		
		$data['group']				=	$this->rest->get('api/v1/creative/fetch_group',array('api_key'=>get_session("api_key")),'php');

		$data['browser_vers']		=	$this->rest->get('api/v1/creative/fetch_browser_versions',array('api_key'=>get_session("api_key")),'php');		
		
		$data['os_vers']		=	$this->rest->get('api/v1/targeting/fetch_os_version',array('api_key'=>get_session("api_key")),'php');
				
		$data['tracker']			= 	$this->rest->get('api/v1/tracker/fetch_tracker',array('api_key'=>get_session('api_key')),'php');		
		
		//Fetch available campaign type
		$data['campaign_type']		= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
	
	    //print_r($data['campaign_type']);  die();
	
		$data['target']				=	$this->targeting_list();
		
		/**** Cookie setup -- start ************/
		$prod_name = $this->config->item('prod_name'); 
		
		$bid_data 					=	$this->rest->get('api/v1/campaign/fetch_realtime_bidding',array('api_key'=>get_session('api_key')),'php');
						
		$data['best_bid_rate']			=	($bid_data!='error')?$bid_data[0]['best_bid_rate']:'';
		$data['min_bid_rate']			=	($bid_data!='error')?$bid_data[0]['min_bid_rate']:'';
		$data['max_bid_rate']			=	($bid_data!='error')?$bid_data[0]['max_bid_rate']:'';
		
		//echo $this->rest->debug();exit;
			
		//For available ssp categories
        $data['ssp_category'] 		= 	$this->rest->get('api/v1/utilities/ssplist', array("api_key" => get_session('api_key')) , 'php');
		
		$data['freq_capp']	=	$this->rest->get('api/v1/campaign/fetch_frequency_list', array("api_key" => get_session('api_key')) , 'php');
		
		$data['previous_campaigns']		= $this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');		
		
		$data['wallet_balance']		= $this->rest->get('api/v1/campaign/wallet_balances',array("api_key"=>get_session('api_key')),'php');	
		if(isset($_COOKIE[$prod_name.'_adv_campaign_user_data'])!='') 
		{
			$campaign_id		=	$_COOKIE[$prod_name.'_adv_campaign_user_data'];				
			
			//Fetch Campaign details
			$campaign_details	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		
			$data['campaign_det']=	$campaign_details[0];
			
			$s2s_details		= 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"s2s"=>'1',"api_key"=>get_session('api_key')),'php');
			
			//Fetch browser targeting details
			$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch os targeting details
			$os_details			= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch profile targeting details
			$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_gender		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_color		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_height		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_weight		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_keyword	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');
			
			//Fetch mobile os targeting details
			$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile manufactures targeting details
			$mobile_manu_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile capability details
			$mobile_capa_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch geo targeting details
			$geoinclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Include:country","api_key"=>get_session('api_key')),'php');
			
			$geoexclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Exclude:country","api_key"=>get_session('api_key')),'php');
							
			//Language
			$lang_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Client:Language","api_key"=>get_session('api_key')),'php');
			
			//City
			$city_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:City","api_key"=>get_session('api_key')),'php');
			
			//Zip
			$zip_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:Zip","api_key"=>get_session('api_key')),'php');
			
			//Device
			$device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"device:".strtolower($data['campaign_det']['dj_targetting_type']),"api_key"=>get_session('api_key')),'php');
			
			//Blacklist
			$black_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$white_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:whitelist","api_key"=>get_session('api_key')),'php');
				
			//Blacklist
			$pblack_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$pwhite_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_whitelist","api_key"=>get_session('api_key')),'php');
							
			//Time
			$time_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Hour","api_key"=>get_session('api_key')),'php');
			
			//Daypart
			$daypart_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Day","api_key"=>get_session('api_key')),'php');
			
			//Day time
			//$daytime_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Day:Time","api_key"=>get_session('api_key')),'php');
			
			//URL Keyword
			$url_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:url","api_key"=>get_session('api_key')),'php');
			
			//Connection
			$connect_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"connection","api_key"=>get_session('api_key')),'php');
			
			//Carrier
			$carrier_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"carrier","api_key"=>get_session('api_key')),'php');
			
			$data['targ_geo_include']	=	$geoinclude_details[0];
			$data['targ_geo_exclude']	=	$geoexclude_details[0];
			$data['targ_lang']			=	$lang_details[0];
			$data['targ_city']			=	$city_details[0];
			$data['targ_zip']			=	$zip_details[0];
			$data['targ_device']		=	$device_details[0];
			$data['targ_black']			=	$black_details[0];
			$data['targ_white']			=	$white_details[0];
			$data['targ_pblack']		=	$pblack_details[0];
			$data['targ_pwhite']		=	$pwhite_details[0];
			
			$data['targ_time']			=	$time_details[0];
			$data['targ_daypart']		=	$daypart_details[0];
			//$data['targ_day_time']	=	$daytime_details[0];				
			$data['targ_url']			=	$url_details[0];
			$data['targ_connect']		=	$connect_details[0];
			$data['targ_carrier']		=	$carrier_details[0];
			
			//Traffic sources
			$data['traffic']			= 	$this->rest->get('api/v1/campaign/fetch_campaign_traffic',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Country Bidding
			$data['country_bid']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_bidding',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			$selected_group			 	= 	$this->rest->get('api/v1/creative/fetch_select_group',array("campaign_id"=>$campaign_id,"api_key"=>get_session("api_key")),'php');
			
			$data['select_group']		=	(!empty($selected_group) && $selected_group[0])?$selected_group[0]['group_id']:'';
			
			$sel_tracker				= 	$this->rest->get('api/v1/tracker/fetch_campaign_tracker',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key')),'php');		
			
			$data['select_tracker']		=	($sel_tracker!='error' && !empty($sel_tracker))?$sel_tracker[0]['trackerid']:'';
			
			$data['campaign_id']		=	$campaign_id;				
			$data['s2s_details']		=	$s2s_details[0];
			$data['targ_browser']		=	$browser_details[0];
			$data['targ_os']			=	$os_details[0];
			$data['targ_time']			=	$time_details[0];
			
			$data['profile_age']		=	$profile_age[0];
			$data['profile_gender']		=	$profile_gender[0];
			$data['profile_color']		=	$profile_color[0];
			$data['profile_height']		=	$profile_height[0];
			$data['profile_weight']		=	$profile_weight[0];
			
			$data['profile_keyword']	=	$profile_keyword[0];
			
			$data['targ_mob_manu']		=	$mobile_manu_details[0];
			$data['targ_mob_capa']		=	$mobile_capa_details[0];
			$data['targ_mob_tele']		=	$mobile_telecom_details[0];
			
	    }
		$data['datas']		=	$data;		
		$data['content'] = $this->load->view('campaigns/add_camp_fourth_div',$data);
		
	   
	}
	public function view_retarget_uri_id()
	{
		$this->session->unset_userdata('adv_campaign_retarget_id');
		$this->session->set_userdata('adv_campaign_retarget_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('adv_campaign_retarget_id'));
	}
	public function view_retargeting($campaign_id = false)
	{
		
		$campaign_id=$this->session->userdata('adv_campaign_retarget_id');
		//$data['track_id'] = 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'json');
		
		/*$tracker_data		=	array();
		if($data['track_id']!='error')
		{
			$tracker_data 	= 	$this->rest->get('api/v1/tracker/fetch_tracker',array("tracker_id"=>str_replace('"', "", $data['track_id']),"api_key"=>get_session('api_key')),'php');
		}
		*/
		$data['campaignid']	=	$campaign_id;
		
		//echo $this->load->view('campaigns/view_retargeting_content',$data);	
		$data['content'] = $this->load->view('campaigns/view_retargeting_content',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);		
	}
	public function map_function()
	{         
		$data['page_title'] 	= 	"Manage your maps";
		$data['content'] = $this->load->view('campaigns/map_function',$data);

	}
	
			
}
