<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Bitpay extends CI_Controller { 

	public function __construct()
	{
		parent::__construct();
				
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));		
		
	}

	public function index()
	{
		$this->add_payment();
	}
	
	function add_payment($account_id=false,$amount=false)
	{
		$data['page_title'] 	= 	"Payment Gateway - Bitcoin";		
		
		$data['account_id']		= 	$account_id;		
		$data['amount'] 		= 	$amount;
		
		$data['email'] 			= 	get_session('email');
		
		$bit_info				= 	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>'4'),'php');
		$data['bit_info']		=	($bit_info)?$bit_info[0]:'';		
		
		$this->load->view('advertiser/bitpay/add_payment',$data);	
	 }

	
	public function payment_success()
	{
		$data['page_title']		= 	"payment success";
		
		$adm			=	$this->rest->get('api/v1/network/get_network_details',array('api_key'=>get_session('api_key')),'json'); 
		$admin			=	json_decode($adm);
		
		$pay_info				= 	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>'4'),'php');
		$data['apiKey']			=	$pay_info[0]['api_signature'];		
		
		$data['trans_id'] 		= 	$_POST['id'];
		$data['trans_amount'] 	= 	$_POST['price'];
		$data['trans_code'] 	= 	$_POST['status'];
		$data['cust_id']		=	$_POST['x_cust_id'];
		
		#Get Post values from Authorize.net	
		
		if($_POST['status']=='paid') 
		{
			$invoice_code 	= 	$_POST['x_invoice_num'];
			$ipn_no		 	= 	$_POST['id'];
			$ipn_txn_id	 	= 	$_POST['id'];
			
			$payment_data = array(
									'account_id'    =>  $_POST['x_cust_id'],
									
									'payment_type'  =>  '4',

									'payer_email'   =>  get_session('email'),

									'receiver_email'=>  $admin->email,

									'txn_id'        =>  $ipn_txn_id,

									'ipn_track_id'  =>  $invoice_code,

									'payment_gross' =>  $_POST['price'],

									'mc_currency'   =>  $_POST['currency'],

									'item_name'     =>  'Advertiser Fund',

									//'item_number'   =>  $_POST['id'],

									'quantity'      =>  1,

									'payer_status'  =>  'verified',

									'payment_status'=>  $_POST['status'],

									'payment_date'  =>  date('Y-m-d H:i:s'),
									
									'payment_paid_date'  =>  date('Y-m-d H:i:s')
								);
			   
			$addfund_list	 = 	$this->rest->get('api/v1/payments/add_advertiser_fund',array('pay_data'	=>	$payment_data,'payer_id'	=>	$data['apiKey'],'api_key'	=>	get_session('api_key')),'php');
			 
			 
			$this->rest->post('api/v1/payments/gateway_add_fundlog',array('api_key'=>get_session('api_key'),'amount'=>array('amount'=>$this->input->post('price')),'acc_id'=>$this->input->post('x_cust_id'),'gateway'=>'BITCOIN'));
			
			if($addfund_list)
			{
				$this->session->unset_userdata('bitpay_invoice_no');
			}	
				
			$this->load->view('advertiser/bitpay/payment_success',$data);
		}
		else
		{
			$data['page_title']		= 	"Payment Failure";
			
			$this->session->unset_userdata('bitpay_invoice_no');
			
			$this->load->view('advertiser/bitpay/payment_failure', $data);
		}	
	}
	
	public function payment_failure()
	{
		$data['page_title']		= 	"Payment process details";
		
		$this->session->unset_userdata('bitpay_invoice_no');
		
		$this->load->view('advertiser/bitpay/payment_failure', $data);
	}
	
	public function payment_process()
	{
		$data['page_title']		= 	"Payment Process";
		
		$pay_info				= 	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>'4'),'php');
		
		$data['apiKey']			=	$pay_info[0]['api_signature'];
				
		$this->load->view('advertiser/bitpay/payment_process', $data);
	}
	
	public function redirect2bitpay()
	{
		$data['page_title']		= 	"Payment process details";
		
		$pay_info				= 	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>'4'),'php');
		
		$data['apiKey']			=	($pay_info)?$pay_info[0]['api_signature']:'';
		
		$data['bit']			=	$_POST;
		
		$this->load->view('advertiser/bitpay/redirect2bitpay', $data);
	}
	
	public function ipn()
	{
		$data['page_title']		= 	"Payment IPN details";
		
		$this->load->view('advertiser/bitpay/callback', $data);
	}
}
