<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Authorize extends CI_Controller { 

	public function __construct()
	{
		parent::__construct();
		
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		
	}

	public function index()
	{
		$this->add_payment();
	}
	
	function add_payment($account_id=false,$amount=false)
	{
		$data['page_title'] 	= 	"Payment Gateway - Authorize.net";		
		
		$data['account_id']		= 	$account_id;		
		$data['amount'] 		= 	$amount;
		
		$auth_info				= 	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>'5'),'php');
		
		$data['auth_api_id'] 	= 	$auth_info[0]['api_username'];
		$data['auth_trans_key'] = 	$auth_info[0]['api_signature'];
				
		$this->load->view('advertiser/authorize/add_payment',$data);		
	}
	
	public function payment_success()
	{
		$data['page_title']		= 	"payment success";
		
		$adm			=	$this->rest->get('api/v1/network/get_network_details',array('api_key'=>get_session('api_key')),'json'); 
		$admin			=	json_decode($adm);
		
		$auth_info				= 	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>'5'),'php');
		
		$data['auth_api_id'] 	= 	$auth_info[0]['api_username'];
		$data['auth_trans_key'] = 	$auth_info[0]['api_signature'];
		
		$data['code'] 		= 	clean_data($_POST['x_response_code']);
		$data['trans_id'] 	= 	clean_data($_POST['x_trans_id']);
		$data['amount']		=	clean_data($_POST['x_amount']);
		$data['cust_id']	=	clean_data($_POST['x_cust_id']);
		
		#Get Post values from Authorize.net	
		
		if($_POST['x_response_code']==1) 
		{
			$invoice_code 	= 	clean_data($_POST['x_invoice_num']);
			$ipn_no		 	= 	clean_data($_POST['x_trans_id']);
			$ipn_txn_id	 	= 	clean_data($_POST['x_trans_id']);
			
			$payment_data = array(
										'account_id'    =>  clean_data($_POST['x_cust_id']),
										
										'payment_type'  =>  '5',

										'payer_email'   =>  get_session('email'),

										'receiver_email'=>  $admin->email,

										'txn_id'        =>  $ipn_txn_id,

										'ipn_track_id'  =>  $ipn_no,

										'payment_gross' =>  clean_data($_POST['x_amount']),

										'mc_currency'   =>  $this->config->item('currency'),

										'item_name'     =>  'Advertiser Fund',

										'item_number'   =>  clean_data($_POST['x_trans_id']),

										'quantity'      =>  1,

										'payer_status'  =>  'verified',

										'payment_status'=>  'Completed',

										'payment_date'  =>  date('Y-m-d H:i:s'),
										
										'payment_paid_date'  =>  date('Y-m-d H:i:s')
									);
			   
			$addfund_list	 = 	$this->rest->get('api/v1/payments/add_advertiser_fund',array('pay_data'=>$payment_data,'payer_id'=>$data['auth_api_id'],'payer_key'=>$data['auth_trans_key'],'api_key'=>get_session('api_key')),'php');
			$this->rest->post('api/v1/payments/gateway_add_fundlog',array('api_key'=>get_session('api_key'),'amount'=>array('amount'=>$this->input->post('x_amount')),'acc_id'=>$this->input->post('x_cust_id'),'gateway'=>'AUTHORIZE'));
			$this->load->view('advertiser/authorize/payment_success',$data);
		}
		else
		{
			$data['page_title']		= 	"Payment Failure";
			
			$this->load->view('advertiser/authorize/payment_failure', $data);
		}
	}
	
	public function payment_failure()
	{
		$data['page_title']		= 	"Payment process details";
		
		$this->load->view('advertiser/authorize/payment_failure', $data);
	}
	
	public function payment_process()
	{
		$data['page_title']	= 	"Payment Process";
		
		$data['auth_info']	=	clean_data($_POST);
		
		$this->load->view('advertiser/authorize/payment_process',$data);
	}
}
