<?php 

class Admarket extends CI_Controller
{
    function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->load->library('user_authentication');
		$this->load->helper('download');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}

	function index()
	{
		$this->campaigns();
	}
	
	/*
	 * 
	 * name		:campaigns
	 * @param   :Null
	 * @return  :List all the campaigns for a particular
	 *
	 */	

	public function campaigns()
	{
          
          
		$data['page_title'] 	= 	"Manage your campaign";

		$data['campaign_data'] 	= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key'),"admarket"=>'1'),'php');
		$data['campaign_det']	=	$campaign_details[0];
		$data['groups'] 		=	$this->rest->get('api/v1/creative/fetch_group',array('api_key'=>get_session("api_key")),'php');
		$data['msg_dat']		= 	$this->rest->get('api/v1/message/fetch_data',array('api_key'=>get_session("api_key")),'php');	
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADVERTISER']['MANAGE_CAMPAIGN']['CHART']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('admarket/campaigns/manage_campaigns',$data,TRUE);
		//$format=$_POST['page'];
		/*if($format=='ajaxcall')
		{
		$this->template->set_layout('advertiser_content');
	    }
	    else
	    {
			$this->template->set_layout('advertiser_layout');
	    }	*/
	    $this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	/*
	 * 
	 * name		:fetch_campaign
	 * @param   :Null
	 * @return  :List all the creatives for a particular
	 * 			 advertiser
	 */	

	public function fetch_campaign()
	{
		
		
		//$group=$this->input->get('group');
		//$status=$this->input->get('status');
		$revenue_type=$this->input->get('revenue_type');
		if(!empty($group) || !empty($status) || !empty($revenue_type))
		{ 
			//$group_val= ($group)?((is_array($group))?$group:explode(',',$group)):'';
			//$status_val= ($status)?((is_array($status))?$status:explode(',',$status)):'';
			//$type_val= ($revenue_type)?((is_array($revenue_type))?$revenue_type:explode(',',$revenue_type)):'';					
						
			$api_key=get_session('api_key');
			$input = array('api_key'	=>	$api_key);
			$input['group'] = ($group)?((is_array($group))?$group:explode(',',$group)):'';
			$input['status']= ($status)?((is_array($status))?$status:explode(',',$status)):'';
			$input['revenue_type']= ($revenue_type)?((is_array($revenue_type))?$revenue_type:explode(',',$revenue_type)):'';								
			
			$campaigns		= $this->rest->get('api/v1/campaign/fetch_filter',$input,'json');	
			
		}
		else
		{    
			$campaigns		= $this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'json');
		}
		//print_r();die("dd");
		#$this->rest->debug();
		
		echo convert_to_datatable_format($campaigns);
	}
	
	
	/*
	* 
	* name   : add_campaigns
	* @param : Null
	* @return: Loads a page to create a new campaign
	* 
	*/	

	public function add_campaigns()
	{
		$data['page_title'] = "Add campaigns";

		$data['breadcrumb'] = '';
		
		/************ Video Enable/Disable *************/
		$this->load->library('default_configurations');
		
		$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
		
		//Minimum Budget & Bid Rate & creatives allowed
		$data['min_budget']		=	$this->default_configurations->get('min_budget');
		
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
		
		$data['creat_allowed']	=	$this->default_configurations->get('direct_creative_type');
		
		/************ Video Enable/Disable *************/
		
		$data['creative_size'] 		= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'php');
		
		$data['mob_screen_size']	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>get_session('api_key')),'php');
		
		$data['lang_data'] 			=	$this->rest->get('api/v1/campaign/fetch_language',array('api_key'=>get_session('api_key')),'php');
		
		//Fetch Publisher
		$adm						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$data['pub_data'] 			=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$adm[0]['api_key']),'php');
		$data['adb_data'] 			=	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$adm[0]['api_key']),'php');
		
		$data['preset_black']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'black'),'php');		
		$data['preset_white']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'white'),'php');		
				
		//Fetch available site categories
		$data['campaign_category']	=	$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>get_session('api_key')),'php');

		$data['camp_sub_category']	=	$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>get_session('api_key')),'php');

		//Fetch Country
		$data['countrylist']		=	$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>get_session('api_key')),'php');		
		
		$data['group']				=	$this->rest->get('api/v1/creative/fetch_group',array('api_key'=>get_session("api_key")),'php');
		
		$data['tracker']			= 	$this->rest->get('api/v1/tracker/fetch_tracker',array('api_key'=>get_session('api_key')),'php');		
		
		//Fetch available campaign type
		$data['campaign_type']		= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
	
	   
	
		$data['target']				=	$this->targeting_list();
		
		/**** Cookie setup -- start ************/
		$prod_name = $this->config->item('prod_name'); 
		
		$bid_data 					=	$this->rest->get('api/v1/campaign/fetch_realtime_bidding',array('api_key'=>get_session('api_key')),'php');
		
		$data['bid_data']			=	($bid_data!='error')?$bid_data[0]:'';
			
		//For available ssp categories
        $data['ssp_category'] 		= 	$this->rest->get('api/v1/utilities/ssplist', array("api_key" => get_session('api_key')) , 'php');
		
		$data['freq_capp']	=	$this->rest->get('api/v1/campaign/fetch_frequency_list', array("api_key" => get_session('api_key')) , 'php');
		
		if(isset($_COOKIE[$prod_name.'_adv_campaign_user_data'])!='') 
		{
			$campaign_id		=	$_COOKIE[$prod_name.'_adv_campaign_user_data'];				
			
			//Fetch Campaign details
			$campaign_details	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
	
			$data['campaign_det']=	$campaign_details[0];
			
			$s2s_details		= 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"s2s"=>'1',"api_key"=>get_session('api_key')),'php');
			
			//Fetch browser targeting details
			$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch os targeting details
			$os_details			= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch profile targeting details
			$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_gender		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_color		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_height		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_weight		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_keyword	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');
			
			//Fetch mobile os targeting details
			$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile manufactures targeting details
			$mobile_manu_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile capability details
			$mobile_capa_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch geo targeting details
			$geoinclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Include:country","api_key"=>get_session('api_key')),'php');
			
			$geoexclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Exclude:country","api_key"=>get_session('api_key')),'php');
							
			//Language
			$lang_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Client:Language","api_key"=>get_session('api_key')),'php');
			
			//City
			$city_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:City","api_key"=>get_session('api_key')),'php');
			
			//Zip
			$zip_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:Zip","api_key"=>get_session('api_key')),'php');
			
			//Device
			$device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"device:".strtolower($data['campaign_det']['dj_targetting_type']),"api_key"=>get_session('api_key')),'php');
			
			//Blacklist
			$black_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$white_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:whitelist","api_key"=>get_session('api_key')),'php');
				
			//Blacklist
			$pblack_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$pwhite_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_whitelist","api_key"=>get_session('api_key')),'php');
							
			//Time
			$time_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Hour","api_key"=>get_session('api_key')),'php');
			
			//Daypart
			$daypart_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Day","api_key"=>get_session('api_key')),'php');
			
			//Day time
			//$daytime_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Day:Time","api_key"=>get_session('api_key')),'php');
			
			//URL Keyword
			$url_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:url","api_key"=>get_session('api_key')),'php');
			
			//Connection
			$connect_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"connection","api_key"=>get_session('api_key')),'php');
			
			//Carrier
			$carrier_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"carrier","api_key"=>get_session('api_key')),'php');
			
			$data['targ_geo_include']	=	$geoinclude_details[0];
			$data['targ_geo_exclude']	=	$geoexclude_details[0];
			$data['targ_lang']			=	$lang_details[0];
			$data['targ_city']			=	$city_details[0];
			$data['targ_zip']			=	$zip_details[0];
			$data['targ_device']		=	$device_details[0];
			$data['targ_black']			=	$black_details[0];
			$data['targ_white']			=	$white_details[0];
			$data['targ_pblack']		=	$pblack_details[0];
			$data['targ_pwhite']		=	$pwhite_details[0];
			
			$data['targ_time']			=	$time_details[0];
			$data['targ_daypart']		=	$daypart_details[0];
			//$data['targ_day_time']	=	$daytime_details[0];				
			$data['targ_url']			=	$url_details[0];
			$data['targ_connect']		=	$connect_details[0];
			$data['targ_carrier']		=	$carrier_details[0];
			
			//Traffic sources
			$data['traffic']			= 	$this->rest->get('api/v1/campaign/fetch_campaign_traffic',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Country Bidding
			$data['country_bid']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_bidding',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			$selected_group			 	= 	$this->rest->get('api/v1/creative/fetch_select_group',array("campaign_id"=>$campaign_id,"api_key"=>get_session("api_key")),'php');
			
			$data['select_group']		=	(!empty($selected_group) && $selected_group[0])?$selected_group[0]['group_id']:'';
			
			$sel_tracker				= 	$this->rest->get('api/v1/tracker/fetch_campaign_tracker',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key')),'php');		
			
			$data['select_tracker']		=	($sel_tracker!='error' && !empty($sel_tracker))?$sel_tracker[0]['trackerid']:'';
			
			$data['campaign_id']		=	$campaign_id;				
			$data['s2s_details']		=	$s2s_details[0];
			$data['targ_browser']		=	$browser_details[0];
			$data['targ_os']			=	$os_details[0];
			$data['targ_time']			=	$time_details[0];
			
			$data['profile_age']		=	$profile_age[0];
			$data['profile_gender']		=	$profile_gender[0];
			$data['profile_color']		=	$profile_color[0];
			$data['profile_height']		=	$profile_height[0];
			$data['profile_weight']		=	$profile_weight[0];
			
			$data['profile_keyword']	=	$profile_keyword[0];
			
			$data['targ_mob_manu']		=	$mobile_manu_details[0];
			$data['targ_mob_capa']		=	$mobile_capa_details[0];
			$data['targ_mob_tele']		=	$mobile_telecom_details[0];
			
	    }
		
		/**** Cookie setup-- end ************/
	
		$data['content'] = $this->load->view('admarket/campaigns/add_campaign',$data,TRUE);
		
		$format=$_POST['page'];
		if($format=='ajaxcall')
		{
			
		$this->template->set_layout('advertiser_content');
	    }
	    else
	    {
			$this->template->set_layout('advertiser_layout');
	    }	
		$this->template->build('view', $data);
	}
	
	/*
	* 
	* name   : edit_campaign
	* @param : Null
	* @return: Loads a page to edit a new campaign
	* 
	*/	

	public function edit_campaign($campaign_id=false)
	{
		if($campaign_id)
		{
			$data['page_title'] = "Optimize campaign";

			$data['breadcrumb'] = '';
			
			/************ Video Enable/Disable *************/
			$this->load->library('default_configurations');
			
			$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
			
			//Minimum Budget & Bid Rate & creatives allowed
			$data['min_budget']		=	$this->default_configurations->get('min_budget');
			
			$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
			
			$data['creat_allowed']	=	$this->default_configurations->get('direct_creative_type');
			
			/************ Video Enable/Disable *************/
			
			$data['creative_size'] 		= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'php');
			
			$data['mob_screen_size']	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>get_session('api_key')),'php');
			
			$data['lang_data'] 			=	$this->rest->get('api/v1/campaign/fetch_language',array('api_key'=>get_session('api_key')),'php');
			
			//Fetch Publisher
			$adm						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
			$data['pub_data'] 			=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$adm[0]['api_key']),'php');
			$data['adb_data'] 			=	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$adm[0]['api_key']),'php');
			$data['preset_black']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'black'),'php');		
			$data['preset_white']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'adblock_type'=>'white'),'php');		
				
			//Fetch available site categories
			$data['campaign_category']	=	$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>get_session('api_key')),'php');

			$data['camp_sub_category']	=	$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>get_session('api_key')),'php');

			//Fetch Country
			$data['countrylist']		=	$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>get_session('api_key')),'php');		
			
			//Fetch available campaign type
			$data['campaign_type']		= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
			
			$data['ssp_category'] 		= 	$this->rest->get('api/v1/utilities/ssplist', array("api_key" => get_session('api_key')) , 'php');
			
			$data['target']				=	$this->targeting_list();
			
			$data['group']				=	$this->rest->get('api/v1/creative/fetch_group',array("api_key"=>get_session('api_key')),'php');
			
			
			$data['tracker']			= 	$this->rest->get('api/v1/tracker/fetch_tracker',array('api_key'=>get_session('api_key')),'php');
			
			$selected_group			 	= 	$this->rest->get('api/v1/creative/fetch_select_group',array("campaign_id"=>$campaign_id,"api_key"=>get_session("api_key")),'php');
			
			$select_group				=	(!empty($selected_group))?$selected_group:'';
			
			
			foreach ($select_group as $sel)
			{
				$sel_group[]=$sel['group_id'];   
			}
			
			$data['sel_group']=$sel_group;
			
			$sel_tracker				= 	$this->rest->get('api/v1/tracker/fetch_campaign_tracker',array("campaign_id"=>$campaign_id,'api_key'=>get_session('api_key')),'php');		
			
			$data['select_tracker']		=	($sel_tracker!='error' && !empty($sel_tracker))?$sel_tracker[0]['trackerid']:'';
			
			//Fetch Campaign details
			$campaign_details			= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
				
			$data['campaign_det']		=	$campaign_details[0];
			
			$s2s_details		= 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"s2s"=>'1',"api_key"=>get_session('api_key')),'php');
			
			//Fetch browser targeting details
			$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch os targeting details
			$os_details			= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch profile targeting details
			$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_gender		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_color		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_height		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_weight		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$profile_keyword	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');
			
			//Fetch mobile os targeting details
			$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile manufactures targeting details
			$mobile_manu_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch mobile capability details
			$mobile_capa_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Fetch geo targeting details
			$geoinclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Include:country","api_key"=>get_session('api_key')),'php');
			
			$geoexclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Exclude:country","api_key"=>get_session('api_key')),'php');
							
			//Language
			$lang_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Client:Language","api_key"=>get_session('api_key')),'php');
			
			//City
			$city_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:City","api_key"=>get_session('api_key')),'php');
			
			//Zip
			$zip_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:Zip","api_key"=>get_session('api_key')),'php');
			
			//Device
			$device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"device:".strtolower($data['campaign_det']['dj_targetting_type']),"api_key"=>get_session('api_key')),'php');
			
			//Blacklist
			$black_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$white_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:whitelist","api_key"=>get_session('api_key')),'php');
			
			//Blacklist
			$pblack_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_blacklist","api_key"=>get_session('api_key')),'php');
			
			//Whitelist
			$pwhite_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_whitelist","api_key"=>get_session('api_key')),'php');
								
			//Time
			$time_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Hour","api_key"=>get_session('api_key')),'php');
			
			//Daypart
			$daypart_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Day","api_key"=>get_session('api_key')),'php');
			
			//Day time
			//$daytime_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Day:Time","api_key"=>get_session('api_key')),'php');
			
			//URL Keyword
			$url_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:url","api_key"=>get_session('api_key')),'php');
			
			//Connection
			$connect_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"connection","api_key"=>get_session('api_key')),'php');
			
			//Carrier
			$carrier_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"carrier","api_key"=>get_session('api_key')),'php');
			
			$data['freq_capp']	=	$this->rest->get('api/v1/campaign/fetch_frequency_list', array("api_key" => get_session('api_key')) , 'php');
			
			$data['targ_geo_include']	=	$geoinclude_details[0];
			$data['targ_geo_exclude']	=	$geoexclude_details[0];
			$data['targ_lang']			=	$lang_details[0];
			$data['targ_city']			=	$city_details[0];
			$data['targ_zip']			=	$zip_details[0];
			$data['targ_device']		=	$device_details[0];
			$data['targ_black']			=	$black_details[0];
			$data['targ_white']			=	$white_details[0];
			$data['targ_pblack']		=	$pblack_details[0];
			$data['targ_pwhite']		=	$pwhite_details[0];
			
			$data['targ_time']			=	$time_details[0];
			$data['targ_daypart']		=	$daypart_details[0];
			//$data['targ_day_time']	=	$daytime_details[0];				
			$data['targ_url']			=	$url_details[0];
			$data['targ_connect']		=	$connect_details[0];
			$data['targ_carrier']		=	$carrier_details[0];
			
			//Traffic sources
			$data['traffic']			= 	$this->rest->get('api/v1/campaign/fetch_campaign_traffic',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			//Country Bidding
			$data['country_bid']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_bidding',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			
			$data['campaign_id']		=	$campaign_id;				
			$data['s2s_details']		=	$s2s_details[0];
			$data['targ_browser']		=	$browser_details[0];
			$data['targ_os']			=	$os_details[0];
			$data['targ_time']			=	$time_details[0];
			
			$data['profile_age']		=	$profile_age[0];
			$data['profile_gender']		=	$profile_gender[0];
			$data['profile_color']		=	$profile_color[0];
			$data['profile_height']		=	$profile_height[0];
			$data['profile_weight']		=	$profile_weight[0];
			
			$data['profile_keyword']	=	$profile_keyword[0];
			
			$data['targ_mob_manu']		=	$mobile_manu_details[0];
			$data['targ_mob_capa']		=	$mobile_capa_details[0];
			$data['targ_mob_tele']		=	$mobile_telecom_details[0];
			/***********End campaign details*********************/
			
			$data['content'] = $this->load->view('admarket/campaigns/edit_campaigns',$data,TRUE);
			
			$this->template->set_layout('advertiser_layout');
			$this->template->build('view', $data);
		}
	}

	/*
	 * 
	 * name   : fetch_campaign_crative
	 * @param : campaign_id
	 * @return: Fetch creative for particular campaign
	 */	

	public function fetch_campaign_creative($campaign_id=false)
	{
		$campaign_id= $this->input->post('_campaign_id');
		
		//Fetch available linked creatives
		$data['existing_creative']	= $this->rest->get('api/v1/campaign/fetch_linked_creative',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		
		#echo $this->rest->debug();exit;

		echo $this->load->view('campaigns/existing_creative',$data);

	}
	/*
	 * 
	 * name   : overview
	 * @param : campaign_id
	 * @return: Fetch creative for particular campaign
	 */	

	public function overview($campaign_id=false)
	{
		$campaign_id= $this->input->post('_campaign_id');

		//Fetch Campaign details
		$camapaign_details['campaign_details']= $this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key'),"view_type"=>'formated'),'json');
		$camp_details_to_php_array=json_decode($camapaign_details['campaign_details']);//For verification
		if($camp_details_to_php_array[0]->dj_targetting_type=='WEB')
		{
			//Fetch browser targeting details
			$browser_details= $this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_browsers_display_name='';
			if(isset($browser_details[0]['data']) AND !empty($browser_details[0]['data']))
			{
				$browser_details_array=explode(',',$browser_details[0]['data']);
				foreach($browser_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_BROWSERS);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_browsers_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch os targeting details
			$os_details= $this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_os_display_name='';
			if(isset($os_details[0]['data']) AND !empty($os_details[0]['data']))
			{
				$os_details_array=explode(',',$os_details[0]['data']);
				foreach($os_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_OS);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_os_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch time targeting details
			$time_details= $this->rest->get('api/v1/campaign/fetch_time_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_time_display_name='';
			if(isset($time_details[0]['data']) AND !empty($time_details[0]['data']))
			{
				$targ_time_array=array('0'=>'0:00-0:59','1'=>'1:00-1:59' ,'2'=>'2:00-2:59' ,'3'=>'3:00-3:59','4'=>'4:00-4:59','5'=>'5:00-5:59' ,'6'=> '6:00-6:59','7'=> '7:00-7:59','8'=>'8:00-8:59' ,'9'=> '9:00-9:59','10'=>'10:00-10:59' ,'11'=>'11:00-11:59','12'=>'12:00-12:59','13'=>'13:00-13:59','14'=>'14:00-14:59' ,'15'=>'15:00-15:59' ,'16'=>'16:00-16:59','17'=> '17:00-17:59','18'=> '18:00-18:59','19'=>'19:00-19:59' ,'20'=>'20:00-20:59','21'=> '21:00-21:59','22'=> '22:00-22:59','23'=>'23:00-23:59');
				$time_details_array=explode(',',$time_details[0]['data']);
				foreach($time_details_array as $value)
				{
					if(isset($targ_time_array[$value]) AND !empty($targ_time_array[$value]))
						$targetted_time_display_name.=ucfirst($targ_time_array[$value]).',';
				}
			}
			
			//Fetch geo targeting details
			$geo_details= $this->rest->get('api/v1/campaign/fetch_geo_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_geo_display_name='';
			if(isset($geo_details[0]['data']) AND !empty($geo_details[0]['data']))
			{
				$geo_details_array=explode(',',$geo_details[0]['data']);
				foreach($geo_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_COUNTRY);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_geo_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			
			$capping=$camp_details_to_php_array[0]->capping;
			$block=$camp_details_to_php_array[0]->block/3600;
			$frequency_capping=$capping.'&nbsp;impression in '.$block.'&nbsp;Hours';
			
			//Fetch keyword targeting details

			$profile_keyword = $this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');

			$targetted_profile_keyword_display_name='';

			if(isset($profile_keyword[0]['data']) AND !empty($profile_keyword[0]['data']))

			{

				$profile_keyword_array=explode(',',$profile_keyword[0]['data']);

				foreach($profile_keyword_array as $value)

				{
				

					$this->db->select('keyword');

					$this->db->where('keyword',$value);

					$query = $this->db->get(TAB_TARG_KEYWORD);	

					$result = $query->result_array();
					

					if(isset($result[0]['keyword']) AND !empty($result[0]['keyword']))

						$targetted_profile_keyword_display_name.=ucfirst($result[0]['keyword']).',';

				}

			}

			//Fetch profile targeting details
			$profile_age= $this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_age_display_name='';
			if(isset($profile_age[0]['data']) AND !empty($profile_age[0]['data']))
			{
				$targ_profile_age_array=array('less_than_20'=>'Age less than 20','T_20_35'=>'Age around: 20-35','T_35_45'=>'Age around: 35-45','more_than_45'=>'Age more than 45');
				$profile_age_details_array=explode(',',$profile_age[0]['data']);
				foreach($profile_age_details_array as $value)
				{
					if(isset($targ_profile_age_array[$value]) AND !empty($targ_profile_age_array[$value]))
						$targetted_profile_age_display_name.=ucfirst($targ_profile_age_array[$value]).',';
				}
			}
			
			$profile_gender= $this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_gender_display_name='';
			if(isset($profile_gender[0]['data']) AND !empty($profile_gender[0]['data']))
			{
				$targ_profile_gender_array=array('male'=>'Gender: Male','female'=>'Gender: Female');
				$profile_gender_details_array=explode(',',$profile_gender[0]['data']);
				foreach($profile_gender_details_array as $value)
				{
					if(isset($targ_profile_gender_array[$value]) AND !empty($targ_profile_gender_array[$value]))
						$targetted_profile_gender_display_name.=ucfirst($targ_profile_gender_array[$value]).',';
				}
			}
			$profile_color= $this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_color_display_name='';
			if(isset($profile_color[0]['data']) AND !empty($profile_color[0]['data']))
			{
				$targ_profile_color_array=array('fair'=>'Color: Fair','weatish'=>'Color: Weatish','dark'=>'Color: Dark');
				$profile_color_details_array=explode(',',$profile_color[0]['data']);
				foreach($profile_color_details_array as $value)
				{
					if(isset($targ_profile_color_array[$value]) AND !empty($targ_profile_color_array[$value]))
						$targetted_profile_color_display_name.=ucfirst($targ_profile_color_array[$value]).',';
				}
			}
			$profile_height= $this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_height_display_name='';
			if(isset($profile_height[0]['data']) AND !empty($profile_height[0]['data']))
			{
				$targ_profile_height_array=array('less_than_140'=>'Height less than 140','T_140_155'=>'Height around: 140-155','T_155_175'=>'Height around: 155-175','more_than_175'=>'Height more than 175');
				$profile_height_details_array=explode(',',$profile_height[0]['data']);
				foreach($profile_height_details_array as $value)
				{
					if(isset($targ_profile_height_array[$value]) AND !empty($targ_profile_height_array[$value]))
						$targetted_profile_height_display_name.=ucfirst($targ_profile_height_array[$value]).',';
				}
			}
			$profile_weight= $this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_weight_display_name='';
			if(isset($profile_weight[0]['data']) AND !empty($profile_weight[0]['data']))
			{
				$targ_profile_weight_array=array('less_than_20'=>'Weight less than 20','T_20_35'=>'Weight around: 20-35','T_35_45'=>'weight around: 35-45','more_than_45'=>'weight more than 45');
				$profile_weight_details_array=explode(',',$profile_weight[0]['data']);
				foreach($profile_weight_details_array as $value)
				{
					if(isset($targ_profile_weight_array[$value]) AND !empty($targ_profile_weight_array[$value]))
						$targetted_profile_weight_display_name.=ucfirst($targ_profile_weight_array[$value]).',';
				}
			}
			$final_profile_targ=$targetted_profile_age_display_name.''.$targetted_profile_gender_display_name.''.$targetted_profile_color_display_name.''.$targetted_profile_height_display_name.''.$targetted_profile_weight_display_name;

			$final_targeting=array($camp_details_to_php_array[0]->dj_targetting_type=>array('targ_1'=>$targetted_browsers_display_name,'targ_2'=>$targetted_os_display_name,'targ_3'=>$targetted_time_display_name,'targ_4'=>$targetted_geo_display_name,'targ_5'=>$frequency_capping,'targ_6'=>$final_profile_targ,'targ_7'=>$targetted_profile_keyword_display_name)
			);
		}
		elseif($camp_details_to_php_array[0]->dj_targetting_type=='MOBILE')
		{
			//Fetch mobile os targeting details
			$mobile_os_details= $this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_os_display_name='';
			if(isset($mobile_os_details[0]['data']) AND !empty($mobile_os_details[0]['data']))
			{
				$mobile_os_details_array=explode(',',$mobile_os_details[0]['data']);
				foreach($mobile_os_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_MOB_OS);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_os_display_name.=ucfirst($result[0]['name']).',';
				}
			}

			//Fetch mobile manufactures targeting details
			$mobile_manu_details= $this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_manu_display_name='';
			if(isset($mobile_manu_details[0]['data']) AND !empty($mobile_manu_details[0]['data']))
			{
				$mobile_manu_details_array=explode(',',$mobile_manu_details[0]['data']);
				foreach($mobile_manu_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_MOB_MANU);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_manu_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch mobile capability details
			$mobile_capa_details= $this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_capa_display_name='';
			if(isset($mobile_capa_details[0]['data']) AND !empty($mobile_capa_details[0]['data']))
			{
				$mobile_capa_details_array=explode(',',$mobile_capa_details[0]['data']);
				foreach($mobile_capa_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_MOB_CAPA);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_capa_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch mobile tecom details
			$mobile_telecom_details= $this->rest->get('api/v1/campaign/fetch_mobile_telecom_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_telecom_display_name='';
			if(isset($mobile_telecom_details[0]['data']) AND !empty($mobile_telecom_details[0]['data']))
			{
				$mobile_telecom_details_array=explode(',',$mobile_telecom_details[0]['data']);
				foreach($mobile_telecom_details_array as $value)
				{
					$this->db->select("id as id,CONCAT(country,'-',carriername) as name",false);
					$this->db->where('id',$value);
					$query = $this->db->get(TAB_TARG_MOBILE_CARRIER);		
					$result = $query->result_array();
					if(isset($result[0]['id']) AND !empty($result[0]['name']))
						$targetted_mob_telecom_display_name.=ucfirst($result[0]['name']).',';
				}
			}
			//Fetch moblie geo targetting details
			$mobile_geo_details= $this->rest->get('api/v1/campaign/fetch_mobile_geo_targeting',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_mob_geo_display_name='';
			if(isset($mobile_geo_details[0]['data']) AND !empty($mobile_geo_details[0]['data']))
			{
				$mobile_geo_details_array=explode(',',$mobile_geo_details[0]['data']);
				foreach($mobile_geo_details_array as $value)
				{
					$this->db->select('name');
					$this->db->where('value',$value);
					$query = $this->db->get(TAB_TARG_MOB_CAPA);		
					$result = $query->result_array();
					if(isset($result[0]['name']) AND !empty($result[0]['name']))
						$targetted_mob_geo_display_name.=ucfirst($result[0]['name']).',';
				}
			}


            ///Fetch keyword targeting details

			$profile_keyword= $this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>get_session('api_key'),"campaign_id"=>$campaign_id),'php');

			$targetted_profile_keyword_display_name='';

			if(isset($profile_keyword[0]['data']) AND !empty($profile_keyword[0]['data']))

			{

				$profile_keyword_array=explode(',',$profile_keyword[0]['data']);

				foreach($profile_keyword_array as $value)

				{

					$this->db->select('keyword');

					$this->db->where('keyword',$value);

					$query = $this->db->get(TAB_TARG_KEYWORD);		

					$result = $query->result_array();

					if(isset($result[0]['keyword']) AND !empty($result[0]['keyword']))

						$targetted_profile_keyword_display_name.=ucfirst($result[0]['keyword']).',';

				}

			}
			
			

			//Fetch profile targeting details
			$profile_age= $this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_age_display_name='';
			if(isset($profile_age[0]['data']) AND !empty($profile_age[0]['data']))
			{
				$targ_profile_age_array=array('less_than_20'=>'Age less than 20','T_20_35'=>'Age around: 20-35','T_35_45'=>'Age around: 35-45','more_than_45'=>'Age more than 45');
				$profile_age_details_array=explode(',',$profile_age[0]['data']);
				foreach($profile_age_details_array as $value)
				{
					if(isset($targ_profile_age_array[$value]) AND !empty($targ_profile_age_array[$value]))
						$targetted_profile_age_display_name.=ucfirst($targ_profile_age_array[$value]).',';
				}
			}
			
			$profile_gender= $this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_gender_display_name='';
			if(isset($profile_gender[0]['data']) AND !empty($profile_gender[0]['data']))
			{
				$targ_profile_gender_array=array('male'=>'Gender: Male','female'=>'Gender: Female');
				$profile_gender_details_array=explode(',',$profile_gender[0]['data']);
				foreach($profile_gender_details_array as $value)
				{
					if(isset($targ_profile_gender_array[$value]) AND !empty($targ_profile_gender_array[$value]))
						$targetted_profile_gender_display_name.=ucfirst($targ_profile_gender_array[$value]).',';
				}
			}
			$profile_color= $this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_color_display_name='';
			if(isset($profile_color[0]['data']) AND !empty($profile_color[0]['data']))
			{
				$targ_profile_color_array=array('fair'=>'Color: Fair','weatish'=>'Color: Weatish','dark'=>'Color: Dark');
				$profile_color_details_array=explode(',',$profile_color[0]['data']);
				foreach($profile_color_details_array as $value)
				{
					if(isset($targ_profile_color_array[$value]) AND !empty($targ_profile_color_array[$value]))
						$targetted_profile_color_display_name.=ucfirst($targ_profile_color_array[$value]).',';
				}
			}
			$profile_height= $this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_height_display_name='';
			if(isset($profile_height[0]['data']) AND !empty($profile_height[0]['data']))
			{
				$targ_profile_height_array=array('less_than_140'=>'Height less than 140','T_140_155'=>'Height around: 140-155','T_155_175'=>'Height around: 155-175','more_than_175'=>'Height more than 175');
				$profile_height_details_array=explode(',',$profile_height[0]['data']);
				foreach($profile_height_details_array as $value)
				{
					if(isset($targ_profile_height_array[$value]) AND !empty($targ_profile_height_array[$value]))
						$targetted_profile_height_display_name.=ucfirst($targ_profile_height_array[$value]).',';
				}
			}
			$profile_weight= $this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
			$targetted_profile_weight_display_name='';
			if(isset($profile_weight[0]['data']) AND !empty($profile_weight[0]['data']))
			{
				$targ_profile_weight_array=array('less_than_20'=>'Weight less than 20','T_20_35'=>'Weight around: 20-35','T_35_45'=>'weight around: 35-45','more_than_45'=>'weight more than 45');
				$profile_weight_details_array=explode(',',$profile_weight[0]['data']);
				foreach($profile_weight_details_array as $value)
				{
					if(isset($targ_profile_weight_array[$value]) AND !empty($targ_profile_weight_array[$value]))
						$targetted_profile_weight_display_name.=ucfirst($targ_profile_weight_array[$value]).',';
				}
			}
			$final_profile_targ=$targetted_profile_age_display_name.''.$targetted_profile_gender_display_name.''.$targetted_profile_color_display_name.''.$targetted_profile_height_display_name.''.$targetted_profile_weight_display_name;

			$final_targeting=array($camp_details_to_php_array[0]->dj_targetting_type=>array('targ_1'=>$targetted_mob_os_display_name,'targ_2'=>$targetted_mob_manu_display_name,'targ_3'=>$targetted_mob_capa_display_name,'targ_4'=>$targetted_mob_telecom_display_name,'targ_5'=>$targetted_mob_geo_display_name,'targ_6'=>$final_profile_targ,'targ_7'=>$targetted_profile_keyword_display_name)
			);
		}

		$existing_creative	= $this->rest->get('api/v1/campaign/fetch_linked_creative',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		if(!empty($existing_creative))
			$no_of_creative['no_of_linked_creative']=sizeof($existing_creative);
		else
			$no_of_creative['no_of_linked_creative']='0';
		
		$result_tmp=array_merge($camapaign_details,$no_of_creative);
		
		if(isset($final_targeting))
		{
			$result=json_encode(array_merge($result_tmp,$final_targeting));
			print_r($result);
		}
		else
		{
			$result=json_encode($result_tmp);
			print_r($result);
		}
		
		
	}

	
	/*
	 * 
	 * name   : view_tracker
	 * @param : campaign_id
	 * @return: Fetch campaign tracker code for particular campaign
	 */	
	public function view_tracker($campaign_id)
	{
		$data['track_id'] = 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'json');
		
		$tracker_data		=	array();
		if($data['track_id']!='error')
		{
			$tracker_data 	= 	$this->rest->get('api/v1/tracker/fetch_tracker',array("tracker_id"=>str_replace('"', "", $data['track_id']),"api_key"=>get_session('api_key')),'php');
		}
		
		$data['tracker_data']	=	$tracker_data;
		
		echo $this->load->view('campaigns/view_trackers_content',$data);		
	}
	
	public function targeting_list()
	{
		$api_key		=	get_session('api_key');
		
		$data['browsers']	= 	$this->rest->get('api/v1/utilities/fetch_target_browsers',array("api_key"=>$api_key),'php');
		
		$data['language']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'language'),'php');
		
		$data['os_set']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'os_set'),'php');
		
		$data['os']			= 	$this->rest->get('api/v1/utilities/fetch_target_os',array("api_key"=>$api_key),'php');
		
		$data['keywords']	= 	$this->rest->get('api/v1/utilities/fetch_target_keyword',array("api_key"=>$api_key),'php');
		
		$data['mobile_os']	= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_os',array("api_key"=>$api_key),'php');
		
		$data['manu']		= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_manu',array("api_key"=>$api_key),'php');
		
		$data['capability']	= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_capability',array("api_key"=>$api_key),'php');
		
		$data['carrier']	= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_carrier',array("api_key"=>$api_key),'php');
		
		$data['continent']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'continent'),'php');
		
		$data['countries']	= 	$this->rest->get('api/v1/utilities/fetch_target_countries',array("api_key"=>$api_key),'php');
		
		$data['time']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'time'),'php');
		
		$data['days']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'days'),'php');
		
		$data['dev_type']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'dev_type'),'php');
		
		$data['device']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'device'),'php');
		
		$data['connection']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'connection'),'php');
		
		
		return $data;
	}
	
	public function add_group()
	{
		$data	=	'';
		$api_key=	get_session('api_key'); 
		echo $this->load->view('creatives/modal_creatives/content/add_group',$data);	
	}
	
	/*
	* 
	* name   : duplicate
	* @param : campaign_id
	* @return: Fetch campaign tracker code for particular campaign
	*/	
	public function duplicate($campaignid=false,$campname=false)
	{
		//Fetch Country
		$data['countries']		= 	$this->rest->get('api/v1/utilities/fetch_target_countries',array("api_key"=>get_session("api_key")),'php');
		
		//Fetch available campaign type
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
	
		$data['campaignid']		=	$campaignid;
		
		$data['campname']		=	$campname;
		
		echo $this->load->view('campaigns/content/duplicate_campaign_multiple',$data);		
	}
	
	public function countrywise_bidding()
	{
		$data['page_title'] = $this->lang->line('admkt_countrywise_bidding');
		$data['selected_country']=$this->rest->get('api/v1/countrywise_bidding/fetch_biddingcountrylist',array('api_key'=>get_session('api_key'),'admarket'=>'1'),'php');
		$data['content'] = $this->load->view('admarket/bidding/countrywise_bidding',$data,TRUE);  
		$format=$_POST['page'];
		if($format=='ajaxcall')
		{
		$this->template->set_layout('advertiser_content');
	    }
	    else
	    {
		$this->template->set_layout('advertiser_layout');
	    }			
		$this->template->build('view', $data);
	}
	
	function countrywise_import_download_file()
	{	 
		$data = file_get_contents("./csv/upload/admarket_countrywise_import.csv"); // Read the file's contents	   		
		$name = 'admarket_countrywise_import.csv';
		force_download($name, $data);  
	}	
	function countrywise_import_download_file_txt()
	{    
		$data = file_get_contents("./csv/upload/admarket_countrywise_import.txt"); // Read the file's contents			
		$name = 'admarket_countrywise_import.txt';
		force_download($name, $data);    
	}
	function countrywise_import_download_file_xml()
	{ 
		$data = file_get_contents("./csv/upload/admarket_countrywise_import.xml"); // Read the file's contents			
		$name = 'admarket_countrywise_import.xml';
		force_download($name, $data);    
	}
	
	//export countrywise download
	function export_download($campaign_id=false,$format=false)
	{									
		$campaignid= rawurldecode($campaign_id);      
			
		$admarket=1;
	
		if($campaignid!=false)
		{	
			$country_list = 	$this->rest->get('api/v1/countrywise_bidding/fetch_country_export_data',array("campaign_id"=>$campaignid,"api_key"=>get_session('api_key'),"admarket"=>$admarket),'json');
					
			$listed_data = json_decode($country_list, true);		
									
			if($format=="csv")
			{				
					$filename='admarket_country_list.csv';
					header('Content-type: text/csv');
					header('Content-Disposition: attachment; filename='.$filename);

					$csv = "campaignid,account_id,campaignname,revenue_type,country_value,bidding_value,status,admarket\n";
					
					for($i=0;$i<count($listed_data);$i++){
						
						$csv.= $listed_data[$i]['campaignid'].','.$listed_data[$i]['account_id'].','.$listed_data[$i]['campaignname'].','.$listed_data[$i]['revenue_type'].','.$listed_data[$i]['country_value'].','.$listed_data[$i]['bidding_value'].','.$listed_data[$i]['status'].','.$listed_data[$i]['admarket']."\n";
					}
					
					print_r($csv);  
			}
			else if($format =='txt')
			{
				$listed_txt = array ();
				$delimiter = "\t";
				header('Content-type: text/tab-separated-values');
				header("Content-Disposition: attachment;filename=admarket_country_list.txt");	
				
				$txt = "campaignid,account_id,campaignname,revenue_type,country_value,bidding_value,status,admarket\n";
				
											
				for($i=0;$i<count($listed_data);$i++)
				{
					
					$txt.= $listed_data[$i]['campaignid'].','. $listed_data[$i]['account_id'].','.$listed_data[$i]['campaignname'].','.$listed_data[$i]['revenue_type'].','.$listed_data[$i]['country_value'].','.$listed_data[$i]['bidding_value'].','.$listed_data[$i]['status'].','.$listed_data[$i]['admarket']."\n";					
				}	
					print_r($txt); 		
								
			}
			else if($format =='xml')
			{
				header('Content-Type: text/xml');
				header("Content-Disposition: attachment;filename=admarket_country_list.xml");
				$xml = new SimpleXMLElement('<country/>');
				$xml->addAttribute("xmlns", "http://tempuri.org/ds.xsd");
				for($i=0;$i<count($listed_data);$i++)
				{
						$cam_list = $xml->addChild("country");
						$cam_list->addChild('campaignid',$listed_data[$i]['campaignid']);
						$cam_list->addChild('account_id',$listed_data[$i]['account_id']);
						$cam_list->addChild('campaignname',$listed_data[$i]['campaignname']);
						$cam_list->addChild('revenue_type', $listed_data[$i]['revenue_type']);
						$cam_list->addChild('country_value', $listed_data[$i]['country_value']);
						$cam_list->addChild('bidding_value', $listed_data[$i]['bidding_value']);
						$cam_list->addChild('status', $listed_data[$i]['status']);
						$cam_list->addChild('admarket', $listed_data[$i]['admarket']);
						}
				print($xml->asXML());
				   
			}			
		}
		
	}
	
	/* Traffic Sources */
	
	public function traffic_sources()
	{ 
        $data['page_title'] = $this->lang->line('admkt_traffic_sources');  
		
		$admarket=1;
		
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher_traffic',array("api_key"=>get_session('api_key')),'php');
		
		$data['camp_lists']=$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key'),"admarket"=>$admarket),'php');
		
		$data['traffic_sourced_list']= $this->rest->get('api/v1/network/fetch_traffic_sources',array("api_key"=>get_session('api_key'),"admarket"=>$admarket),'php');
						
		$data['content'] = $this->load->view('admarket/special_bidding/traffic_sources',$data,TRUE);     
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	/* Zone bidding */	
	public function zone_bidding()
	{ 
		$data['page_title'] = $this->lang->line('admkt_zone_bidding');
		
		$admarket=1;
		
		$data['zone_data']  = $this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>get_session('api_key')),'php');
						
		$data['camp_lists'] = $this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key'),"admarket"=>$admarket),'php');
						
		$data['content'] = $this->load->view('admarket/zone_bidding/manage_zone_bidding',$data,TRUE);  
		$format=$_POST['page'];
		if($format=='ajaxcall')
		{
		    $this->template->set_layout('advertiser_content');
	    }
	    else
	    {
			$this->template->set_layout('advertiser_layout');
	    }	
		$this->template->build('view', $data);
	}
	
	
	function zonebidding_import_download_file()
	{ 		
		$data = file_get_contents("./csv/upload/admarket_zonebidding_import.csv"); // Read the file's contents			
		$name = 'admarket_zonebidding_import.csv';
		force_download($name, $data);  
	}
	
	function zonebidding_import_download_file_txt()
	{ 
		$data = file_get_contents("./csv/upload/admarket_zonebidding_import.txt"); // Read the file's contents			
		$name = 'admarket_zonebidding_import.txt';
		force_download($name, $data);    
	}
	function zonebidding_import_download_file_xml()
	{ 
		$data = file_get_contents("./csv/upload/admarket_zonebidding_import.xml"); // Read the file's contents			
		$name = 'admarket_zonebidding_import.xml';
		force_download($name, $data);      
	}
	
	function export_zonebidding_download($zone_bid_id=false,$format=false)
	{
									
		$zonebid_id= rawurldecode($zone_bid_id); 

		$admarket=1;
							
		if($zonebid_id!=false)
		{	
			$zonebid_list = 	$this->rest->get('api/v1/countrywise_bidding/fetch_zonebidding_export_data',array("zone_bid_id"=>$zonebid_id,"api_key"=>get_session('api_key'),"admarket"=>$admarket),'json');
			
			$listed_data = json_decode($zonebid_list, true);
			
			if($format=="csv")
			{				
					$filename='Admarket_zonebidding_list.csv';
					header('Content-type: text/csv');
					header('Content-Disposition: attachment; filename='.$filename);

					$csv = "account_id,campaignid,bidding_type,zone_id,bidrate,status,admarket\n";
					
					for($i=0;$i<count($listed_data);$i++){
						
						$csv.= $listed_data[$i]['account_id'].','.$listed_data[$i]['campaignid'].','.$listed_data[$i]['bidding_type'].','.$listed_data[$i]['zoneid'].','.$listed_data[$i]['bidrate'].','.$listed_data[$i]['status'].','.$listed_data[$i]['admarket']."\n";   
					}
					
					print_r($csv);  
			}
			else if($format =='txt')
			{
				$listed_txt = array ();
				$delimiter = "\t";
				header('Content-type: text/tab-separated-values');
				header("Content-Disposition: attachment;filename=Admarket_zonebidding_list.txt");	
				
				$txt = "account_id,campaignid,bidding_type,zone_id,bidrate,status,admarket\n";
				
											
				for($i=0;$i<count($listed_data);$i++)
				{
					
					$txt.= $listed_data[$i]['account_id'].','. $listed_data[$i]['campaignid'].','.$listed_data[$i]['bidding_type'].','.$listed_data[$i]['zoneid'].','.$listed_data[$i]['bidrate'].','.$listed_data[$i]['status'].','.$listed_data[$i]['admarket']."\n";
				
				}				
					print_r($txt); 		
				
			}
			else if($format =='xml')
			{
				header('Content-Type: text/xml');
				header("Content-Disposition: attachment;filename=Admarket_zonebidding_list.xml");
				$xml = new SimpleXMLElement('<zonebidding/>');
				$xml->addAttribute("xmlns", "http://tempuri.org/ds.xsd");
				for($i=0;$i<count($listed_data);$i++)
				{
						$cam_list = $xml->addChild("zonebidding");
						$cam_list->addChild('account_id',$listed_data[$i]['account_id']);
						$cam_list->addChild('campaignid',$listed_data[$i]['campaignid']);
						$cam_list->addChild('bidding_type',$listed_data[$i]['bidding_type']);
						$cam_list->addChild('zoneid', $listed_data[$i]['zoneid']);
						$cam_list->addChild('bidrate', $listed_data[$i]['bidrate']);
						$cam_list->addChild('status', $listed_data[$i]['status']);
						$cam_list->addChild('admarket', $listed_data[$i]['admarket']);  
						}
				print($xml->asXML());
				
			}	
		}
		
	}
	
	
	function traffic_import_download_file()
	{		
		$data = file_get_contents("./csv/upload/admarket_traffic_import.csv"); // Read the file's contents			
		$name = 'admarket_traffic_import.csv'; 
		force_download($name, $data);  
	}
	
	function traffic_import_download_file_txt()
	{ 
		$data = file_get_contents("./csv/upload/admarket_traffic_import.txt"); // Read the file's contents			
		$name = 'admarket_traffic_import.txt';
		force_download($name, $data);    
	}
	function traffic_import_download_file_xml()
	{ 
		$data = file_get_contents("./csv/upload/admarket_traffic_import.xml"); // Read the file's contents			
		$name = 'admarket_traffic_import.xml';
		force_download($name, $data);    
	}
	
	function download_traffic($traffic_id=false,$format=false)
	{
		$tid= rawurldecode($traffic_id); 
		$admarket =1; 
		if($tid!=false)
		{							
			$traffic_list = 	$this->rest->get('api/v1/network/fetch_traffic_sources',array("traffic_ids"=>$tid,"api_key"=>get_session('api_key'),"admarket"=>$admarket),'json');
			 
			$listed_data = json_decode($traffic_list, true);   
						
			foreach($listed_data as $cam_id)
			{
			$cam[]=$cam_id['id'];
			}	
			
			$k=0;
			$new_listed_data=array();
			$exp_tid = explode(',',$tid);	 
			for($i=0;$i<count($exp_tid);$i++)
			{
				for($j=0;$j<count($listed_data);$j++)
				{
					if($listed_data[$j]['id']==$exp_tid[$i])
					{
						$new_listed_data[$k]=$listed_data[$j];
						$k++;
					}
				}
			}
			$imp=implode(',',$cam);
			$cmp_s= str_replace(",","_sid_",$tid);
			if($cmp_s)
			{
				$cmp_fn='sid_'.$cmp_s;
			}
			else
			{
				$cmp_fn='sid_'.$tid;
			}
			$listed_data=$new_listed_data;
			if($format=="csv")
			{		
					$filename=$cmp_fn.'.csv';
					
					header('Content-type: text/csv');
					header('Content-Disposition: attachment; filename='.$filename);

					$csv = "account_id,campaignid,sourceid,bidrate,status,campaignname,admarket,traffic_source_type\n";
					
					for($i=0;$i<count($listed_data);$i++){
						
						if($listed_data[$i]['campaign_id']!='0')
						{
							$campaign_id=$listed_data[$i]['campaign_id'];
						}
						else
						{
							$campaign_id=0;
						}	
						
						if($listed_data[$i]['campaignname']!='')
						{
							$campaign_name=$listed_data[$i]['campaignname'];
						}
						else
						{
							$campaign_name="All campaigns";
						}
						
						$csv.= $listed_data[$i]['account_id'].','.$campaign_id.','.$listed_data[$i]['traffic_id'].','.$listed_data[$i]['bid_rate'].','.$listed_data[$i]['status'].','.$campaign_name.','.$listed_data[$i]['admarket'].','.$listed_data[$i]['traffic_source_type']."\n";
					}
					
					print_r($csv);  
			}
			else if($format =='txt')
			{
				$listed_txt = array();
				$delimiter = "\t";
				$filename=$cmp_fn.'.txt';
				header('Content-type: text/tab-separated-values');
				header("Content-Disposition: attachment;filename=".$filename);	  
									
				$listed_txt	="account_id,campaignid,sourceid,bidrate,status,campaign name,admarket,traffic_source_type\n";					
				for($i=0;$i<count($listed_data);$i++)
				{
					    if($listed_data[$i]['campaign_id']!='0')
						{
							$campaign_id=$listed_data[$i]['campaign_id'];
						}
						else
						{
							$campaign_id=0;
						}	
						
						if($listed_data[$i]['campaignname']!='')
						{
							$campaign_name=$listed_data[$i]['campaignname'];
						}
						else
						{
							$campaign_name="All campaigns";
						}
						
					$listed_txt.= $listed_data[$i]['account_id'].','.$campaign_id.','.$listed_data[$i]['traffic_id'].','.$listed_data[$i]['bid_rate'].','.$listed_data[$i]['status'].','.$campaign_name.','.$listed_data[$i]['admarket'].','.$listed_data[$i]['traffic_source_type']."\n";
					
				}				
				print_r($listed_txt); 			
			}
			else if($format =='xml')
			{
				$filename=$cmp_fn.'.xml';
				header('Content-Type: text/xml');
				header("Content-Disposition: attachment;filename=".$filename);
				
				$xml = new SimpleXMLElement('<Advertiser/>');
				$xml->addAttribute("xmlns", "http://tempuri.org/ds.xsd");
				for($i=0;$i<count($listed_data);$i++)
				{
						if($listed_data[$i]['campaign_id']!='0')
						{
							$campaign_id=$listed_data[$i]['campaign_id'];
						}
						else
						{
							$campaign_id=0;
						}	
						
						if($listed_data[$i]['campaignname']!='')
						{
							$campaign_name=$listed_data[$i]['campaignname'];
						}
						else
						{
							$campaign_name="All campaigns";
						}
						
						$zonelimit_list = $xml->addChild("Trafficsource");
						$zonelimit_list->addChild('account_id',$listed_data[$i]['account_id']);
						$zonelimit_list->addChild('campaignid',$campaign_id);
						$zonelimit_list->addChild('sourceid', $listed_data[$i]['traffic_id']);
						$zonelimit_list->addChild('bidrate', $listed_data[$i]['bid_rate']);
						$zonelimit_list->addChild('status', $listed_data[$i]['status']);
						$zonelimit_list->addChild('campaignname', $campaign_name);
						$zonelimit_list->addChild('admarket', $listed_data[$i]['admarket']);
						$zonelimit_list->addChild('traffic_source_type',$listed_data[$i]['traffic_source_type']);
											
				}
				print($xml->asXML());
				
			}			
		}  
		
	}
	
	function publisher()
	{  
		$data['page_title'] = $this->lang->line('publishers');
						
		$data['publisher_data']  = $this->rest->get('api/v1/admarket/fetch_publisher_list',array("api_key"=>get_session('api_key'),"admarket"=>"1"),'php');	

		//$data['publisher_data']  = $this->rest->get('api/v1/publisher/fetch_publisher_list',array("api_key"=>get_session('api_key')),'php');

		$data['content'] = $this->load->view('admarket/publisher/publisher_list',$data,TRUE);    
		
		$format=$_POST['page'];
		if($format=='ajaxcall')
		{
		    $this->template->set_layout('advertiser_content');  
	    }
	    else
	    {
			$this->template->set_layout('advertiser_layout');
	    }	
		$this->template->build('view', $data);
	}
	//notification setting
	function notification_setting()  
	{
		$data['page_title'] = "Notification Setting";
		$data['breadcrumb'] = '';
		$notify	=	$this->rest->get('api/v1/advertiser/notification_information',array('api_key'=>get_session('api_key')),'php');	
		if($notify[0]['dj_admarket_status']==1)
		{
		$data['advertiser_notify'][0]=$notify[0];
		}
		else if($notify[1]['dj_admarket_status']==1)
		{
		
		$data['advertiser_notify'][0]=$notify[1];
		
		}
		else
		{
		$data['advertiser_notify']='';
		}
			
		//$data['advertiser_notify']	=	($notify!='error')?$notify:'';
	
		$adgatenews	=	$this->rest->get('api/v1/advertiser/fetch_adgate_news',array('api_key'=>get_session('api_key')),'php');	
		
		$data['client_settings']	=	($adgatenews!='error')?$adgatenews:'';
		
		$data['admin_enable']=$this->rest->get('api/v1/advertiser/admin_enable',array('api_key'=>get_session('api_key')),'php');	
		$data['content'] = $this->load->view('admarket/settings/message_settings',$data,TRUE);
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
		
	function publisher_applications()  
	{
		$data['page_title'] = $this->lang->line('denied_publishers');
						
		$data['publisher_data']  = $this->rest->get('api/v1/admarket/fetch_denied_publisher_list',array("api_key"=>get_session('api_key'),"admarket"=>"1"),'php');
																
		$data['content'] = $this->load->view('admarket/publisher/denied_publisher_list',$data,TRUE);    
		
		$format=$_POST['page'];
		if($format=='ajaxcall')
		{
		    $this->template->set_layout('advertiser_content');  
	    }
	    else
	    {
			$this->template->set_layout('advertiser_layout');
	    }	
		$this->template->build('view', $data);
		
	}
	
	function publisher_settings()
	{
		
	}
	
	function publisher_list()
	{
		$data['page_title'] = $this->lang->line('publishers');
						
		$data['publisher_data']  = $this->rest->get('api/v1/admarket/fetch_all_publisher_list',array("api_key"=>get_session('api_key')),'php'); 
																						
		$data['content'] = $this->load->view('admarket/publisher/all_publisher',$data,TRUE);    
		
		$format=$_POST['page'];
		
		if($format=='ajaxcall')
		{
		    $this->template->set_layout('advertiser_content');  
	    }
	    else
	    {
			$this->template->set_layout('advertiser_layout');  
	    }	
		$this->template->build('view', $data);
	}
	
	function tracker()
	{
		$data['page_title'] = 	$this->lang->line('admarket_pixel_tracker');		
		$data['content'] = $this->load->view('admarket/tracker/pixel_tracker',$data,TRUE);  
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	public function ad_tracker_link_edit()
	{
		$this->session->unset_userdata('ad_track_link_edit_id');
		$this->session->set_userdata('ad_track_link_edit_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('ad_track_link_edit_id'));
	}
	public function link_admarket_tracker($tracker_id=false)
	{
		$data['page_title'] = 	$this->lang->line('link_admarket_campaign');  
		
		//$data['tracker_id']	=	$tracker_id;
		$data['tracker_id']	=	 $this->session->userdata('ad_track_link_edit_id');
		
		$link 				= 	$this->rest->get('api/v1/tracker/fetch_admarket_tracker_campaign',array("tracker_id"=>$this->session->userdata('ad_track_link_edit_id'),"api_key"=>get_session('api_key'),"admarket"=>'1'),'php');		
		
		//echo $this->rest->debug();  
		
		//print_r($link);  die("tets");     
		
		$data['link_data']	=	($link!='error')?$link:'';  
		
		$data['content']	=	$this->load->view('admarket/tracker/campaign_list',$data,TRUE);   
		
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	public function description()
	{
		$data['page_title'] = 	$this->lang->line('description');	
		
		
		$data['admarket_content']= 	$this->rest->post('api/v1/admarket/admarket_description',array("api_key"=>get_session('api_key')),'php');	  //echo $this->rest->debug();exit;	
		$data['content'] 	= 	$this->load->view('admarket/description',$data,TRUE);  
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}

	public function creatives()
	{
		$data['page_title'] = "Manage creatives";
		
		$data['breadcrumb'] = '';

		//$data['campaign_id']	= $this->uri->segment(4);
		$data['campaign_id']	= $this->session->userdata('edit_campaignlist_creative_id');

		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>get_session('api_key')),'php');  

	
		// GET DEFAULT PERIOD FROM CONFIG FILE

		$set = $this->config->item('report_config');

		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_CREATIVE']['CHART']['DEFAULT_INTERVAL']);

		$data['lang_available']= $this->rest->get('api/v1/creative/fetch_language',array("api_key"=>get_session('api_key')),'php');
		$data['admarket_id'] = "1";
		$data['content'] = $this->load->view('creatives/manage_creatives',$data,TRUE);
		
         
		$format=$_POST['page'];
		
		if($format=='ajaxcall')
		{
			
		$this->template->set_layout('advertiser_content');
	    }
	    else
	    {
			$this->template->set_layout('advertiser_layout');
	    }	

		$this->template->build('view', $data);

	}

	public function add_web_creatives()

	{

		$data['page_title'] = "Add web creative";


		$data['breadcrumb'] = '';

		/************ Video Enable/Disable *************/
		$this->load->library('default_configurations');
		
		$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
		/************ Video Enable/Disable *************/

		$data['admarket_id'] = "1";
		
		$data['content'] = $this->load->view('creatives/add_web_creative',$data,TRUE);

		

		$this->template->set_layout('advertiser_layout');

		$this->template->build('view', $data);

	}


	public function add_mobile_creatives()

	{

		$data['page_title'] = "Add mobile creative";



		$data['breadcrumb'] = '';

		$data['admarket_id'] = "1";

		$data['content'] = $this->load->view('creatives/add_mobile_creative',$data,TRUE);

		

		$this->template->set_layout('advertiser_layout');

		$this->template->build('view', $data);

	}
}
