<?php 

class Users extends CI_Controller

{

    function __construct()

	{

		parent::__construct();

		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!

		$this->load->library('rest');

		//$this->load->model('api_v.1/do_creative','asd');

		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));

	}



	function index()

	{

		$this->managers();

	}



	/*

	 * 

	 * name: managers

	 * @param : null

	 * @return :manage all managers.

	 */	



	public function managers()

	{

		$data['page_title'] = 	"Managers";



		$data['breadcrumb'] = 	'';

		

		$data['content'] 	= 	$this->load->view('users/managers',$data,TRUE);

		$this->template->set_layout('admin_layout');

		$this->template->build('view', $data);

	}	

	

	/*

	 * 

	 * name		:manager_ajax

	 * @param   :Null

	 * @return  :List all the managers for admin

	 */	



	public function fetch_manager()

	{

		$manager	=	$this->rest->get('api/v1/manager/fetch',array('account_id'=>''),'json');

		

		echo convert_to_datatable_format($manager);

	}

	

	/*

	 * 

	 * name		: add_manager

	 * @param   : Null

	 * @return  : Fetch modal box for edit manager

	 */	

	 	

	public function add_manager()

	{	

		echo $this->load->view('users/modal_users/content/add_manager');

	}

	

	/*

	 * 

	 * name		: edit_manager

	 * @param   : Null

	 * @return  : Fetch individual manager details

	 */	

	 	

	public function edit_manager($account_id=FALSE)

	{	

		if($account_id)

		{

			$manager			=	$this->rest->get('api/v1/manager/fetch',array('account_id'=>$account_id),'php');

			$data['manager']	=	$manager[0];

			

			echo $this->load->view('users/modal_users/content/edit_manager',$data);

		}

	}

   

   

    /*

	 * 

	 * name: advertisers

	 * @param : null

	 * @return : manage all advertisers.

	 */	



	public function advertisers()

	{

		$data['page_title']	 	= 	"Manage Advertisers";



		$data['breadcrumb'] 	= 	'';

		

		#$network_id				=	get_session('account_id');

		

		#$network_account_id		=	get_session('network_account_id');

		

		$camp_count				=	$this->rest->get('api/v1/advertiser/campaign_count',array('api_key'	=> get_session('api_key')),'json');

		

		if($camp_count!='null')

		{

			$data['camp_count']	=	$camp_count;

		}

		else

		{

			$data['camp_count']	=	0;

		}

		

		$creative_count			=	$this->rest->get('api/v1/advertiser/creative_count',array('api_key'=>get_session('api_key')),'json');

		

		if($creative_count!='null')

		{

			$data['creative_count']	=	$creative_count;

		}

		else

		{

			$data['creative_count']	=	0;

		}


		$data['content'] 		= 	$this->load->view('users/advertisers',$data,TRUE);

		$this->template->set_layout('admin_layout');

		$this->template->build('view', $data);

	}

	

	/*

	 * 

	 * name		:advertiser_ajax

	 * @param   :Null

	 * @return  :List all the advertiser for admin

	 */	



	public function fetch_advertiser()

	{

		#$network_account_id	=	get_session('network_account_id');

		#$network_id			=	get_session('account_id');

		$advertiser			=	$this->rest->get('api/v1/advertiser/fetch',array('api_key'=>get_session('api_key')),'json');

		//$this->rest->debug();

		echo convert_to_datatable_format($advertiser);

	}

	

	/*

	 * 

	 * name		: add_advertiser

	 * @param   : Null

	 * @return  : Fetch modal box for edit manager

	 */	

	 	

	public function add_advertiser()

	{	
		$security_question      =   $this->rest->get('api/v1/advertiser/security_question',array('api_key'=>get_session('api_key')),'php');
		$data['security_question']=$security_question;					
		echo $this->load->view('users/modal_users/content/add_advertiser',$data);

	}

	

	/*

	 * 

	 * name		: edit_advertiser

	 * @param   : Null

	 * @return  : Fetch individual advertiser details

	 */	

	 	

	public function edit_advertiser($account_id=FALSE)

	{	

		if($account_id)

		{
			#$network_account_id	=	get_session('network_account_id');

			#$network_id			=	get_session('account_id');

			
	        $advertiser			=	$this->rest->get('api/v1/advertiser/fetch',array('api_key'=>get_session('api_key'),'account_id'=>$account_id),'php');

			$data['advertiser']	=	$advertiser[0];
						
			$security_question      =   $this->rest->get('api/v1/advertiser/security_question',array('api_key'=>get_session('api_key')),'php');
			$data['security_question']=$security_question;

			echo $this->load->view('users/modal_users/content/edit_advertiser',$data);

		}

	}

	

	/*

	 * 

	 * name		: fetch_campaign_count

	 * @param   : Null

	 * @return  : Fetch individual campaign count for advertiser

	 */	

	 	

	public function fetch_campaign_count($account_id=FALSE,$clientid=FALSE)

	{	

		if($account_id && $clientid)

		{

			$count	=	$this->rest->get('api/v1/advertiser/campaign_count',array('api_key'=>get_session('api_key'),'account_id'=>$account_id,'client_id'=>$clientid),'json');

			if($count!=0)

			{

				echo $count;

			}

			else

			{

				echo 0;

			}

		}

	}

	

	

	/*

	 * 

	 * name		: fetch_spend_amount

	 * @param   : Null

	 * @return  : Fetch individual spend amount for advertiser

	 */	

	 	

	public function fetch_spend_amount($account_id=FALSE,$clientid=FALSE)

	{	

		if($account_id && $clientid)

		{

			$amount	=	$this->rest->get('api/v1/advertiser/spend_amount',array('api_key'=>get_session('api_key'),'account_id'=>$account_id,'client_id'=>$clientid),'json');

			if($amount!=0)

			{

				echo $amount;

			}

			else

			{

				echo 0;

			}

		}

	}

	

	

	/*

	* 

	* name: publishers

	* @param : null

	* @return : manager all publishers.

	*/	



	public function publishers()

	{

		$data['page_title'] 	= 	"Manage Publishers";



		$data['breadcrumb']	 	= 	'';

		

		#$network_id				=	get_session('account_id');

		

		#$network_account_id		=	get_session('network_account_id');

		

		$site_count				=	$this->rest->get('api/v1/publisher/site_count',array('api_key'=>get_session('api_key')),'json');



		if($site_count!='null')

		{

			$data['site_count']	=	$site_count;

		}

		else

		{

			$data['site_count']	=	0;

		}

		

		$ad_block_count			=	$this->rest->get('api/v1/publisher/ad_block_count',array('api_key'=>get_session('api_key')),'json');




		if($ad_block_count!='null')

		{

			$data['ad_block_count']	=	$ad_block_count;

		}

		else

		{

			$data['ad_block_count']	=	0;

		}

		
		$data['content'] 		= 	$this->load->view('users/publishers',$data,TRUE);

		$this->template->set_layout('admin_layout');

		$this->template->build('view', $data);

	}

	

	/*

	 * 

	 * name		:publisher_ajax

	 * @param   :Null

	 * @return  :List all the publisher for admin

	 */	



	public function fetch_publisher()

	{

		
		$publisher			=	$this->rest->get('api/v1/publisher/fetch',array('api_key'=>get_session('api_key')),'json');

		echo convert_to_datatable_format($publisher);

	}

	

	/*

	 * 

	 * name		: add_publisher

	 * @param   : Null

	 * @return  : Fetch modal box for edit manager

	 */	

	 	

	public function add_publisher()

	{	
		$data['floor_price_enable']= 	$this->default_configurations->get('floor_price_enable');
		$security_question      =   $this->rest->get('api/v1/advertiser/security_question',array('api_key'=>get_session('api_key')),'php');
		$data['security_question']=$security_question;
		echo $this->load->view('users/modal_users/content/add_publisher',$data);

	}

	

	/*

	 * 

	 * name		: edit_publisher

	 * @param   : Null

	 * @return  : Fetch individual publisher details

	 */	

	 	

	public function edit_publisher($account_id=FALSE)

	{	

		if($account_id)

		{

			#$network_account_id	=	get_session('network_account_id');

			#$network_id			=	get_session('account_id');
			$security_question      =   $this->rest->get('api/v1/advertiser/security_question',array('api_key'=>get_session('api_key')),'php');
			$data['security_question']=$security_question;
			$data['floor_price_enable']= 	$this->default_configurations->get('floor_price_enable');

			$publisher			=	$this->rest->get('api/v1/publisher/fetch',array('api_key'=>get_session('api_key'),'account_id'	=>	$account_id),'php');
			
			$data['publisher']	=	$publisher[0];
			
			//print_r($data['publisher']);  die("test");

			echo $this->load->view('users/modal_users/content/edit_publisher',$data);

		}

	}

	

	/*

	 * 

	 * name		: fetch_site_count

	 * @param   : Null

	 * @return  : Fetch individual site count for publisher

	 */	

	 	

	public function fetch_site_count($account_id=FALSE)

	{	

		if($account_id)

		{

			$count	=	$this->rest->get('api/v1/publisher/site_count',array('account_id'=>$account_id),'json');

			if($count!=0)

			{

				echo $count;

			}

			else

			{

				echo 0;

			}

		}

	}

/* Switch user */        
	
	public function switch_user($account_id=false,$acc_type=false)
	{	
			
		$CI = &get_instance();
			$CI->load->library('encrypt');
		
			if($acc_type=="ADVERTISER")
			{					
				$this->db->select(
									'oxcl.dj_first_name as first_name,
									oxcl.dj_last_name as last_name,
									oxu.email_address as email,
									oxa.account_id as account_id,
									oxa.account_type as account_type,
									oxcl.agencyid as agencyid,
									oxu.active as is_active,
									oxcl.clientid as client_id,
									oxcl.dj_is_denied as denied,
									dua.api_key as api_key,
									oxcl.dj_onetime_wizard as onetime_wizard,
									dnm.network_account_id as network_account_id,
									oxu.user_id as user_id,
									oxu.parent_account_id as parent_account_id'
								);
				$this->db->join(TAB_ACCOUNTS.' as oxa','oxa.account_id=oxu.default_account_id');
				$this->db->join(TAB_CLIENTS.' as oxcl','oxcl.account_id=oxa.account_id');
				$this->db->join(TAB_AGENCY.' as oxag','oxag.agencyid=oxcl.agencyid');
				$this->db->join(TAB_USER_APIKEY.' as dua','dua.user_id=oxu.user_id');
				$this->db->join(TAB_NWK_MANAGERS.' as dnm','dnm.manager_account_id=oxag.account_id');
				$this->db->where('oxu.default_account_id',$account_id);	
				$this->db->where('oxu.parent_account_id','0');			
				$query 	= 	$this->db->get(TAB_USERS.' as oxu');
				
				if($query->num_rows() >0)
				{
					$result = 	$query->result_array();
				}	
			
			}	
			else if($acc_type=="TRAFFICKER")  
			{				
				$SQL = "SELECT  site_count, COALESCE(ROUND(SUM(oxds.dj_publisher_earnings),2),0) as earning, `oxaf`.`affiliateid`, `oxaf`.`agencyid`, `oxaf`.`name`, `oxaf`.`email`, `oxaf`.`website`, `oxaf`.`dj_first_name` as first_name, `oxaf`.`dj_last_name` as last_name, `oxaf`.`floor_price_enable`, `oxaf`.`dj_is_denied` as status, `oxaf`.`account_id` as account_id,`oxa`.`account_type` as account_type, dua.api_key as api_key,`oxu`.`user_id` as user_id,oxu.parent_account_id as parent_account_id
			FROM (".TAB_USERS." as oxu) 			
			JOIN ".TAB_AFFILIATE." as oxaf ON `oxaf`.`account_id`=`oxu`.`default_account_id` 
			JOIN ".TAB_USER_APIKEY." as dua ON dua.user_id=oxu.user_id 
			JOIN ".TAB_NWK_MANAGERS." as dnm ON `dnm`.`agency_id`=`oxaf`.`agencyid`            			
		    JOIN ".TAB_ACCOUNTS." as oxa ON `oxa`.`account_id`=`oxu`.`default_account_id` 			
			LEFT JOIN (SELECT dps.account_id,count(*) as site_count FROM ".TAB_PUB_SITES." as dps WHERE dps.is_deleted='0' GROUP BY dps.account_id) m ON `m`.`account_id`=`oxaf`.`account_id` 
			LEFT JOIN ".TAB_ZONES." as oxz ON `oxz`.`affiliateid`=`oxaf`.`affiliateid`
			LEFT JOIN ".TAB_DATA_SUM_AD_HOURLY." as oxds ON `oxds`.`zone_id`=`oxz`.`zoneid`";
			
			$SQL .= " WHERE dnm.is_deleted =0 AND oxaf.dj_is_deleted =0 ";	
			
			$SQL .= " AND oxaf.account_id= ".$account_id."";	
			$SQL .= " AND oxu.parent_account_id= 0";		
			$SQL .= " GROUP BY `oxaf`.`account_id` ORDER BY `oxaf`.`account_id` DESC";		
			
			$query=$this->db->query($SQL);
			if($query->num_rows() >0)
				{
					$result = 	$query->result_array();
				}		
			}
			$query_app = $this->db->query('select * from '.TAB_APP_CONFIG.'');
			if($query_app->num_rows() >0)
				{
					$result_app = 	$query_app->result_array();
				}			
			
			 $wheres	=	array(
						
						'oxu.user_id'		=>	$result[0]['user_id'],
						'oxsr.account_type'		=>	$acc_type,
						'oxsr.user_status'	=>	1,
						'oxsr.role_block'	=>	0
					);					
			$this->db->select('oxsr.role_id as role_id,
							   
							  '
							  );
			$this->db->join(TAB_SUB_ACCOUNT_ROLE_ASSOC.' as oxsr','oxsr.user_id=oxu.user_id');
			$this->db->where($wheres);
			
			$query_roles 	= 	$this->db->get(TAB_USERS.' as oxu');
			if($query_roles->num_rows() >0)
				{
					$result_roles = 	$query_roles->result_array();
				}
				
					
			$pdt_name = $CI->config->item('prod_name');		
			$common_existing_session=array('session_id','ip_address','user_agent','last_activity','user_data','time_zone',$pdt_name."_cur_login_time");
			$res[$pdt_name.'_first_name']=$result[0]['first_name'];
			$res[$pdt_name.'_last_name']=$result[0]['last_name'];
			$res[$pdt_name.'_email']=$result[0]['email'];
			$res[$pdt_name.'_account_id']=$result[0]['account_id'];
			$res[$pdt_name.'_account_type']=$result[0]['account_type'];
			$res[$pdt_name.'_agencyid']=$result[0]['agencyid'];
			$res[$pdt_name.'_is_active']=$result[0]['is_active']; 
			if($acc_type=="ADVERTISER")
			{
				$res[$pdt_name.'_client_id']=$result[0]['client_id']; 
			}
			if($acc_type=="TRAFFICKER")
			{
				$res[$pdt_name.'_affiliate_id']=$result[0]['affiliate_id'];
			}			
			$res[$pdt_name.'_denied']=$result[0]['denied'];
			$res[$pdt_name.'_api_key']=$result[0]['api_key'];
			$res[$pdt_name.'_onetime_wizard']=$result[0]['onetime_wizard'];
			$res[$pdt_name.'_network_account_id']=$result[0]['network_account_id'];
			$res[$pdt_name.'_adv_pub_msg']=$result_app[0]['adv_pub_msg'];
			$res[$pdt_name.'_user_id']=$result[0]['user_id'];
			$res[$pdt_name.'_subaccount_role_id']=$result_roles[0]['role_id'];
			$res[$pdt_name.'_parent_account_id']=$result[0]['parent_account_id'];
					
						
			if($acc_type=="ADVERTISER")
			{
				$new_advertiser_session=array($pdt_name.'_is_active',$pdt_name.'_client_id',$pdt_name.'_onetime_wizard',$pdt_name.'_network_account_id',$pdt_name.'_adv_pub_msg',$pdt_name.'_subaccount_role_id',$pdt_name.'_user_id',$pdt_name.'_parent_account_id');
				 $sess_array = array();			
				foreach($this->session->all_userdata() as $key=>$value)
				{	
					
					if(!in_array($key,$common_existing_session))
					{
						
						if(in_array($key,array_keys($res)))
						{
							$sess_array[$key] = $CI->encrypt->encode($res[$key]);
						}
						else
						{	
							if($key!='primary_id')
							{
							$this->session->unset_userdata($key);							
							}							
							
						}
						
					}
																			
				} 
				
					
						
				if(!empty($new_advertiser_session))
				{					
					foreach ($new_advertiser_session as $new_key)
					{
						if(in_array($new_key,array_keys($res)))
						{							    
							//$this->session->set_userdata($new_key,$CI->encrypt->encode($res[$new_key]));
							$sess_array[$new_key] = $CI->encrypt->encode($res[$new_key]);										
											
						}
					}
				}
				$this->session->set_userdata($sess_array);
				
								
		
			
				
				 /* Is logged  from admin */
					$is_log=$pdt_name.'_is_logged_from_admin';  
					$this->session->set_userdata($is_log,$CI->encrypt->encode('1'));
					redirect('advertiser/dashboard');
					//redirect('buyer/dashboard');
		
				
			}
			else if($acc_type=="TRAFFICKER")  
			{
				$new_publisher_session=array($pdt_name.'_is_active',$pdt_name.'_affiliate_id',$pdt_name.'_onetime_wizard',$pdt_name.'_network_account_id',$pdt_name.'_adv_pub_msg',$pdt_name.'_subaccount_role_id',$pdt_name.'_user_id',$pdt_name.'_parent_account_id');
				$pub_sess_array = array();	
				
				foreach($this->session->all_userdata() as $key=>$value)
				{
					if(!in_array($key,$common_existing_session))
					{		
						if(in_array($key,array_keys($res)))
						{
							//$this->session->set_userdata($key,$CI->encrypt->encode($res[$key]));
							$pub_sess_array[$key] = $CI->encrypt->encode($res[$key]);																	
						}
						else
						{
							if($key!='primary_id')
							{
							$this->session->unset_userdata($key);
							}
						}
					}
				}				
				
				if(!empty($new_publisher_session))
				{
					foreach ($new_publisher_session as $new_key)
					{
						if(in_array($new_key,array_keys($res)))
						{
								//$this->session->set_userdata($new_key,$CI->encrypt->encode($res[$new_key]));
								$pub_sess_array[$new_key] = $CI->encrypt->encode($res[$new_key]);										
						}
					}
				}
				$this->session->set_userdata($pub_sess_array);
				 /* Is logged  from admin */
					$is_log=$pdt_name.'_is_logged_from_admin';  
					$this->session->set_userdata($is_log,$CI->encrypt->encode('1'));			
					redirect('publisher/dashboard');			
			}		
	}

}

