<?php 
class Tracker extends CI_Controller
{
   function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		
		$this->load->library('default_configurations');
	}

	function index()
	{
		$this->pixel();  
	}

	/*
	 * 
	 * name		:pixel
	 * @param   :Null
	 * @return  :List the pixel tracker for particular admin
	 */	

	public function pixel()
	{
		$data['page_title'] = 	"Pixel Tracker";
		
		$data['content'] = $this->load->view('tracker/pixel_tracker',$data,TRUE);
		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_pixel_list()
	{
		$tracker_list	  = $this->rest->get('api/v1/tracker/fetch_tracker',array('api_key'=>get_session('api_key')),'json');		
		//echo $this->rest->debug();exit;
		echo convert_to_datatable_format($tracker_list);
	}
	
	/*
	 * 
	 * name		:add_pixel_tracker
	 * @param   :Null
	 * @return  :Create the pixel
	 */	

	public function add_pixel_tracker()
	{	
		$data['advertiser_list']	= 	$this->rest->get('api/v1/utilities/fetch_advertiser',array("api_key"=>get_session('api_key')),'php');
			
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
			
		//Fetch available campaign's
		$data['campaign_data'] 	=	$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
		
		echo $this->load->view('tracker/modal_tracker/content/add_tracker',$data);	
	}
	
	/*
	 * 
	 * name		:edit_pixel_tracker
	 * @param   :Null
	 * @return  :Loads the pixel
	 */	

	public function edit_pixel_tracker($tracker_id=false)
	{
		$data['advertiser_list']	= 	$this->rest->get('api/v1/utilities/fetch_advertiser',array("api_key"=>get_session('api_key')),'php');
		
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
		
		//Fetch available campaign's	
		$data['campaign_data'] 	=	$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
		
		$data['tracker_data'] 	= 	$this->rest->get('api/v1/tracker/fetch_tracker',array("tracker_id"=>$tracker_id,"api_key"=>get_session('api_key')),'php');
		
		echo $this->load->view('tracker/modal_tracker/content/edit_tracker',$data);	
	}
	
	/*
	* 
	* name   : view_tracker
	* @param : campaign_id
	* @return: Fetch campaign tracker code for particular campaign
	*/	
	public function view_tracker($tracker_id)
	{
		$data['tracker_data'] = $this->rest->get('api/v1/tracker/fetch_tracker',array("tracker_id"=>$tracker_id,"api_key"=>get_session('api_key')),'php');
		
		echo $this->load->view('tracker/modal_tracker/content/view_trackers',$data);
	}
	public function admin_edit_link_tracker()
	 {
		$this->session->unset_userdata('admin_edit_link_trak_id');
		$this->session->set_userdata('admin_edit_link_trak_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('admin_edit_link_trak_id'));
	
	 }	
	/*
	* 
	* name   : link_tracker
	* @param : campaign_id
	* @return: Fetch link campaign tracker for particular campaign
	*/	
	public function link_tracker($tracker_id=false)
	{
		$data['page_title'] = 	"Link Campaigns";
		$data['tracker_id']	=		$this->session->userdata('admin_edit_link_trak_id');
		//$data['tracker_id']	=	$tracker_id;
		
		$link 				= 	$this->rest->get('api/v1/tracker/fetch_tracker_campaign',array("tracker_id"=>$tracker_id,"api_key"=>get_session('api_key')),'php');
		
		$data['link_data']	=	($link!='error')?$link:'';
		
		$data['content']	=	$this->load->view('tracker/campaign_list',$data,TRUE);
		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_campaign_list()
	{
		$campaign_list 	=	$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'json');
	
		echo convert_to_datatable_format($campaign_list);
	}	
	
	/*
	* 
	* name   : conversion_settings
	* @param : campaign_id
	* @return: Fetch campaign tracker code for particular campaign
	*/	
	public function conversion_settings($tracker_id,$campaign_id)
	{
		$data['tracker_data'] 	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		
		$data['tracker_id']		=	$tracker_id;
		
		$data['campaign_id']	=	$campaign_id;
		
		echo $this->load->view('tracker/modal_tracker/content/conversion_window',$data);
	}
}
