<?php 
class Tracker extends CI_Controller
{
   function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		
		$this->load->library('default_configurations');
	}

	function index()
	{
		$this->pixel();  
	}

	/*
	 * 
	 * name		:pixel
	 * @param   :Null
	 * @return  :List the pixel tracker for particular admin
	 */	

	public function pixel($housead=FALSE)
	{
		$data['page_title'] = 	"Pixel Tracker";
		$data['housead'] = 	$housead?$housead:'normal';
		
		$data['content'] = $this->load->view('tracker/pixel_tracker',$data,TRUE);
		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_pixel_list($is_house_pixel=FALSE)
	{
		$admarket='';
		if($is_house_pixel=='admarket')
		{
			$admarket='1';$is_house_pixel='';
		}
		$tracker_list	  = $this->rest->get('api/v1/tracker/fetch_tracker',array('api_key'=>get_session('api_key'),'is_house_pixel'=>$is_house_pixel,'admarket'=>$admarket),'json');		
		//echo $this->rest->debug();exit;
		echo convert_to_datatable_format($tracker_list);
	}
	
	/*
	 * 
	 * name		:add_pixel_tracker
	 * @param   :Null
	 * @return  :Create the pixel
	 */	

	public function add_pixel_tracker($type=FALSE,$page=FALSE)
	{	
		$data['advertiser_list']	= 	$this->rest->get('api/v1/utilities/fetch_advertiser',array("api_key"=>get_session('api_key')),'php');
		if($type && $type=='housead')	
		{
			$data['type']=$type; 
		}	
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
			
		//Fetch available campaign's
		$data['campaign_data'] 	=	$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
					
			$data['content']	=	$this->load->view('tracker/modal_tracker/content/add_tracker',$data,TRUE);
		
			$this->template->set_layout('admin_layout');
			$this->template->build('view', $data);
		//~ echo $this->load->view('tracker/modal_tracker/content/add_tracker',$data);	
	}
		public function add_cam_pixel_tracker($type=FALSE,$page=FALSE)
	{	
		$data['advertiser_list']	= 	$this->rest->get('api/v1/utilities/fetch_advertiser',array("api_key"=>get_session('api_key')),'php');
		if($type && $type=='housead')	
		{
			$data['type']=$type; 
		}	
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
			
		//Fetch available campaign's
		$data['campaign_data'] 	=	$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
					
			//~ $data['content']	=	$this->load->view('tracker/modal_tracker/content/add_tracker',$data,TRUE);
		//~ 
			//~ $this->template->set_layout('admin_layout');
			//~ $this->template->build('view', $data);
		 echo $this->load->view('tracker/modal_tracker/content/add_tracker',$data);	
	}
	/*
	 * 
	 * name		:edit_pixel_tracker
	 * @param   :Null
	 * @return  :Loads the pixel
	 */	

	public function edit_pixel_tracker($tracker_id=false,$housead=false)
	{
		$data['advertiser_list']	= 	$this->rest->get('api/v1/utilities/fetch_advertiser',array("api_key"=>get_session('api_key')),'php');
		
		$tracker_id	= $this->session->userdata('edit_px_tracker_id_url');
		$housead	= $this->session->userdata('ishousepix');
		
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
		$data['housead']=$housead;
		//Fetch available campaign's	
		$data['campaign_data'] 	=	$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
		
		$data['tracker_data'] 	= 	$this->rest->get('api/v1/tracker/fetch_tracker',array("tracker_id"=>$tracker_id,"api_key"=>get_session('api_key'),"is_house_pixel"=>$housead),'php');
		
		//~ echo $this->load->view('tracker/modal_tracker/content/edit_tracker',$data);	
		$data['content']	=	$this->load->view('tracker/modal_tracker/content/edit_tracker',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	* 
	* name   : view_tracker
	* @param : campaign_id
	* @return: Fetch campaign tracker code for particular campaign
	*/	
	public function view_tracker($tracker_id)
	{
		$data['tracker_data'] = $this->rest->get('api/v1/tracker/fetch_tracker',array("tracker_id"=>$tracker_id,"api_key"=>get_session('api_key')),'php');
		
		echo $this->load->view('tracker/modal_tracker/content/view_trackers',$data);
	}
	public function admin_edit_link_tracker()
	 {
		$this->session->unset_userdata('edit_trackerid');
		$this->session->set_userdata('edit_trackerid', $_POST['url_id']);
		echo json_encode($this->session->userdata('edit_trackerid'));
	
	 }	
	/*
	* 
	* name   : link_tracker
	* @param : campaign_id
	* @return: Fetch link campaign tracker for particular campaign
	*/	
	public function link_tracker($tracker_id=false)
	{
		$data['page_title'] = 	"Link Campaigns";
		$data['tracker_id']	=		$this->session->userdata('edit_trackerid');
		//$data['tracker_id']	=	$tracker_id;
		if($tracker_id=='housead')
		{
			$data['housead']='1';
		}//print_r($this->session->userdata); exit;

		$link 				= 	$this->rest->get('api/v1/tracker/fetch_tracker_campaign',array("tracker_id"=>$this->session->userdata('edit_trackerid'),"api_key"=>get_session('api_key')),'php');
		//~ print_r($this->rest->debug());exit;
		$data['link_data']	=	($link!='error')?$link:'';
		//~ print_r($link);exit;
		$data['content']	=	$this->load->view('tracker/campaign_list',$data,TRUE);
		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_campaign_list($housead=false)
	{
		$filter	=	array(
						'campaign'	=>	($this->input->post('campaign')!='')?explode(',',$this->input->post('campaign')):'',
						'campaign_type'	=>	($this->input->post('campaign_type')!='')?explode(',',$this->input->post('campaign_type')):''
					);
		$tracker_id=		($this->input->post('track_id'))?$this->input->post('track_id'):'';
		//$campaign_list 	=	$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'json');
		$campaign_list 	=	$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key'),'filter'=>$filter,"tracker_id"=>$tracker_id,'type'=>$housead),'json');
		 //~ print_r($this->rest->debug());exit;
		echo convert_to_datatable_format($campaign_list);
	}	
	
	/*
	* 
	* name   : conversion_settings
	* @param : campaign_id
	* @return: Fetch campaign tracker code for particular campaign
	*/	
	public function conversion_settings($tracker_id,$campaign_id)
	{
		$data['tracker_data'] 	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>get_session('api_key')),'php');
		
		$data['tracker_id']		=	$tracker_id;
		
		$data['campaign_id']	=	$campaign_id;
		
		echo $this->load->view('tracker/modal_tracker/content/conversion_window',$data);
	}
	
	public function edit_px_tracker_id()
	{
		
		$this->session->unset_userdata('edit_px_tracker_id');
		$this->session->set_userdata('edit_px_tracker_id_url', $_POST['url_id']);
		$this->session->set_userdata('ishousepix', $_POST['ishousepix']);
		echo json_encode($this->session->userdata('edit_px_tracker_id_url'));

	}
}
