<?php 
class Template_settings extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->template_settings();		
	}
	
	/*
	 * 
	 * name		:CPM_settings
	 * @param   :Null
	 * @return  :List personal_information for Admin
	 * 		
	 */	
	public function template_settings()
	{
		$data['page_title'] = "Template Settings";	
		$data['breadcrumb'] = '';
		$data['api_key']=get_session('api_key');
		$data['country_list']		= $this->rest->get('api/v1/utilities/template',array('api_key'=>get_session('api_key')),'php');	
	//	$data['temp_deletion']		= 	$this->rest->get('api/v1/newsletter_template/fetch_temp_deletion',array("api_key"=>get_session('api_key')),'php'); 
		$data['content'] = $this->load->view('template_settings/tmpl_setting',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:fetch_geo_list
	 * @param   :Null
	 * @return  :List list of geo settings
	 * 		
	 */
	public function fetch_newsletter_list() 
	{
		$geo_sett		= $this->rest->get('api/v1/newsletter_template/fetch',array('api_key'=>get_session('api_key')),'json');
		#$this->rest->debug();
		echo convert_to_datatable_format($geo_sett);
	}
	
	/*
	 * 
	 * name		: edit_geo
	 * @param   : Null
	 * @return  : List all the Category for admin
	 */	
	 	
	public function edit_geo($geo_id=FALSE)
	{	
		$sett_list					= $this->rest->get('api/v1/geo_settings/geo_data',array('api_key'=>get_session('api_key'),'geo_id'=>$geo_id),'php');
		$data['geo_val']			= $sett_list[0];
		$data['country_list']		= $this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');	
		
		echo $this->load->view('geo_settings/modal_geo/content/edit_geo',$data);
	}
	
	public function fetch_template_list()
	{
		$temp_list		= 	$this->rest->get('api/v1/newsletter_template/fetch_temp_deletion',array("api_key"=>get_session('api_key')),'json'); 	
		//echo $this->rest->debug();  die("test");  
		//echo convert_to_datatable_format(json_encode($temp_list)); 
		echo convert_to_datatable_format($temp_list);      
	}
	public function save_image()
	{
		$imagedatas = $_POST['imagedata'];
		$file_name = $_POST['fil_name'];

		$content = file_get_contents($imagedatas);
		$package_path = explode('application',dirname(__DIR__));
		$file_url = $package_path[0].$this->config->item('read_template_folder').'csv/server/php/files/html_images/'.$file_name.'.png';

		$fp = fopen($file_url, "w");
		fwrite($fp, $content);
		fclose($fp); 
		//~ $file_url1 = $package_path[0].$this->config->item('read_template_folder').'html_template/'.$file_name.'.html';
		//~ $fp1 = fopen($file_url1, "w");
		//~ fwrite($fp1, $tags);
		//~ fclose($fp1); 
	}	
}
