<?php 
class Targeting extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->category();		
	}
	
	/*
	 * 
	 * name		: category
	 * @param   : Null
	 * @return  : List all the Category for admin
	 */	
	 	
	public function category()
	{	
		$data['page_title'] = "Category";	
		$data['breadcrumb'] = '';
		
		$data['category_list']		= $this->rest->get('api/v1/targeting/fetch_category_main',array('api_key'=>get_session('api_key')),'php');	
		$data['content'] = $this->load->view('targeting/category',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}
	
	/*
	 * 
	 * name		: add_category
	 * @param   : Null
	 * @return  : add the sub Category for admin
	 */	
	 	
	public function add_main_category()
	{	
		echo $this->load->view('targeting/modal_targeting/content/add_main_category',$data);
	}
	
	/*
	 * 
	 * name		: add_category
	 * @param   : Null
	 * @return  : add the sub Category for admin
	 */	
	 	
	public function add_category()
	{	
		$data['category_list']		= $this->rest->get('api/v1/targeting/fetch_category_main',array('api_key'=>get_session('api_key')),'php');	
		echo $this->load->view('targeting/modal_targeting/content/add_category',$data);
	}
	
	/*
	 * 
	 * name		: fetch_category
	 * @param   : Null
	 * @return  : List all the categoryies added by the admin
	 */	
	
	 public function fetch_category()
	 {
	    $cat_admin		= $this->rest->get('api/v1/targeting/fetch',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($cat_admin);
	 }
	
	/*
	 * 
	 * name		: editcategory
	 * @param   : Null
	 * @return  : List all the Category for admin
	 */	
	 	
	public function edit_category($category_id=FALSE)
	{	
		$cat_list					= $this->rest->get('api/v1/targeting/category',array('api_key'=>get_session('api_key'),'category_id'=>$category_id),'php');
		$par_value					= $cat_list[0]['parent_category_id'];
		$data['category_details']	= $cat_list[0];
		$data['root_val'] 			= $this->rest->get('api/v1/targeting/category_root',array('api_key'=>get_session('api_key'),'par_id'=>$par_value),'php');
		echo $this->load->view('targeting/modal_targeting/content/edit_category',$data);
	}
	
	
	/*
	 * 
	 * name		: Operating System
	 * @param   : Null
	 * @return  : List all the operating system for admin
	 */	
	 	
	public function operating_system()
	{	
		$data['page_title'] = "Operating System";	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/operating_system',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}

	public function os_version()
	{	
		$data['page_title'] = "Operating System Version";	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/os_version',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}
	
        /* 
	 * 
	 * name		: add_operating_system
	 * @param   : Null
	 * @return  :  echo the  link when  function is called 
	 */	
	              
	public function add_operating_system()
	{	
		$device=$this->rest->get('api/v1/utilities/fetch_target_option',array('api_key'=>get_session('api_key'),'type'=>'os_set'),'php');
		//print_r($device);exit;
		$data['device_list']=$device;//print_r($data['device_list']);exit;
		echo $this->load->view('targeting/modal_targeting/content/add_operating_system',$data);
	}
	
	public function add_os_version()
	{	
		$os_admin		= $this->rest->get('api/v1/targeting/fetch_os_name',array('api_key'=>get_session('api_key')),'json');
		//print_r($os_admin);exit;
		$data['os_admin']=$os_admin;//print_r($data['device_list']);exit;
		echo $this->load->view('targeting/modal_targeting/content/add_os_version',$data);
	}	
	
	 /*
	 * 
	 * name		: fetch_os
	 * @param   : Null
	 * @return  : List all the os added by the admin
	 */	
	
	 public function fetch_os()
	 {
	    $os_admin		= $this->rest->get('api/v1/targeting/fetch_os',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($os_admin);
	 }

	 public function fetch_os_version()
	 {
	    $os_admin		= $this->rest->get('api/v1/targeting/fetch_os_version',array('api_key'=>get_session('api_key')),'json');
		
		//echo $this->rest->debug();  exit;
		echo convert_to_datatable_format($os_admin);
	 }
	 
	 /*
	 * 
	 * name		: edit_os
	 * @param   : Null
	 * @return  : List all the Category for admin
	 */	
	 	
	public function edit_os($id=FALSE)
	{	
		$os_list=	$this->rest->get('api/v1/targeting/os_list',array('id'=>$id,'api_key'=>get_session('api_key')),'php');
		$device	=	$this->rest->get('api/v1/utilities/fetch_target_option',array('api_key'=>get_session('api_key'),'type'=>'os_set'),'php');
		$data['device_list']=	$device;
		$data['os_details']	=	$os_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_operating_system',$data);
	}

	public function edit_os_version($id=FALSE)
	{	
	
		$os_edit		= $this->rest->get('api/v1/targeting/fetch_os_vers_data',array('id'=>$id,'api_key'=>get_session('api_key')),'json');
		$data['os_edit']=	$os_edit;
					
		echo $this->load->view('targeting/modal_targeting/content/edit_os_version',$data);
	}
	
	/*
	 * 
	 * name		: Browsers
	 * @param   : Null
	 * @return  : List all the browsers for admin
	 */	
	 	
	public function browsers()
	{	
		$data['page_title'] = "Browsers";	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/browsers',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}

	public function browser_version()
	{	
		$data['page_title'] = "Browser Version";	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/browser_version',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}
        /*
	 * 
	 * name		: add_browsers
	 * @param   : Null
	 * @return  :  echo the  link when  function is called 
	 */	
	
	public function add_browsers()
	{	
		
		echo $this->load->view('targeting/modal_targeting/content/add_browsers');
	}
	public function add_browser_versions()
	{	
		$data['brow_list']		= $this->rest->get('api/v1/targeting/fetch_browsing',array('api_key'=>get_session('api_key')),'json');//print_r($data['brow_list']);exit;
		echo $this->load->view('targeting/modal_targeting/content/add_browser_versions',$data);
	}	
	/*
	 * 
	 * name		: fetch_category
	 * @param   : Null
	 * @return  : List all the categoryies added by the admin
	 */	
	
	 public function fetch_browsers()
	 {
	    $browser_admin		= $this->rest->get('api/v1/targeting/fetch_browsers',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($browser_admin);
	 }

	 public function fetch_browser_versions()
	 {
	    $browser_admin		= $this->rest->get('api/v1/targeting/fetch_browser_versions',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($browser_admin);
	 }
	 
	  /*
	 * 
	 * name		: edit_os
	 * @param   : Null
	 * @return  : List all the Category for admin
	 */	
	 	
	public function edit_browser($id=FALSE)
	{	
		$browser_list=$this->rest->get('api/v1/targeting/browser_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');
		$data['browser_details']=$browser_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_browser',$data);
	}

	public function edit_browser_versions($id=FALSE)
	{	
		$browser_version=$this->rest->get('api/v1/targeting/browser_version_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');
		$data['brow_list']		= $this->rest->get('api/v1/targeting/fetch_browsing',array('api_key'=>get_session('api_key')),'json');		
		$data['browser_version_details']=$browser_version[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_browser_version',$data);
	}

	/*
	 * 
	 * name		: manufacturers
	 * @param   : Null
	 * @return  : List all the manufacturers for admin
	 */	
	 	
	public function manufacturers()
	{	
		$data['page_title'] = "Manufacturers";	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/manufacturers',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}
	
	/*
	 * 
	 * name		: fetch_category
	 * @param   : Null
	 * @return  : List all the categoryies added by the admin
	 */	
	
	 public function fetch_manufacturers()
	 {
	    $manu_admin		= $this->rest->get('api/v1/targeting/fetch_manu',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($manu_admin);
	 }

     /*
	 * 
	 * name		: edit_manufacturers
	 * @param   : Null
	 * @return  : List all the Category for admin
	 */	
	 	
	public function edit_manufacturers($id=FALSE)
	{	
		$manu_list=$this->rest->get('api/v1/targeting/manu_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');
		$data['manu_details']=$manu_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_manufacturers',$data);
	}
	 
	
	/*
	 * 
	 * name		: Mobile Operating System
	 * @param   : Null
	 * @return  : List all the Mobile operating system for admin
	 */	
	 	
	public function mobile_operating_system()
	{	
		//print_r(get_session('api_key'));  die("test");
		$data['page_title'] = "Mobile Operating System";	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/mobile_operating_system',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}

 
        /* 
	 * 
	 * name		: add_mobile_operating_system
	 * @param   : Null
	 * @return  :  echo the  link when  function is called 
	 */	
	
	public function add_mobile_operating_system()
	{	
		
		echo $this->load->view('targeting/modal_targeting/content/add_mobile_operating_system');
	}
	
	
	 /*
	 * 
	 * name		: fetch_mobile_os
	 * @param   : Null
	 * @return  : List all the Mobile os added by the admin
	 */	
	
	 public function fetch_mobile_os()
	 {
	    $os_admin		= $this->rest->get('api/v1/targeting/fetch_mobile_os',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($os_admin);
	 }

	 /*
	 * 
	 * name		: edit_mobile_os
	 * @param   : Null
	 * @return  : List all the os for admin
	 */	
	 	
	public function edit_mobile_os($id=FALSE)
	{			
		$os_list=$this->rest->get('api/v1/targeting/mobile_os_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');
		$data['os_details']=$os_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_mobile_operating_system',$data);
	}	
	
	
	/*
	 * 
	 * name		: Mobile manufacturers
	 * @param   : Null
	 * @return  : List all the Mobile manufacturer for admin
	 */	
	 	
	public function mobile_manufacturers()
	{	
		$data['page_title'] = "Mobile Manufacturer";	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/mobile_manufacturers',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}



	/*
	 * 
	 * name		: add_mobile_manufacturers
	 * @param   : Null
	 * @return  :  echo the  link when  function is called 
	 */	
	
	public function add_mobile_manufacturers()
	{	
		
		echo $this->load->view('targeting/modal_targeting/content/add_mobile_manufacturers');
	}
	
	
	 /*
	 * 
	 * name		: fetch_mobile_manufacturers
	 * @param   : Null
	 * @return  : List all the Mobile manufacturer added by the admin
	 */	
	
	 public function fetch_mobile_manufacturers()
	 {
	    $manufacturer_admin		= $this->rest->get('api/v1/targeting/fetch_mobile_manufacturers',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($manufacturer_admin);
	 }

	 /*
	 * 
	 * name		: edit_mobile_manufacturers
	 * @param   : Null
	 * @return  : List all the Mobile manufacturers for admin
	 */	
	 	
	public function edit_mobile_manufacturers($id=FALSE)
	{			
		$manufacturer_list=$this->rest->get('api/v1/targeting/mobile_manufacturers_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');
		$data['mobile_manufacturer_details']=$manufacturer_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_mobile_manufacturers',$data);
	}	
	
	
	/*
	 * 
	 * name		: Mobile capability
	 * @param   : Null
	 * @return  : List all the Mobile capability for admin
	 */	
	 	
	public function mobile_capability()
	{	
		$data['page_title'] = "Mobile Capability";	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/mobile_capability',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}


        /* 
	 * 
	 * name		: add_mobile_capability
	 * @param   : Null
	 * @return  :  echo the  link when  function is called 
	 */	
	
	public function add_mobile_capability()
	{	
		
		echo $this->load->view('targeting/modal_targeting/content/add_mobile_capability');
	}
	
	
	 /*
	 * 
	 * name		: fetch_mobile_capability
	 * @param   : Null
	 * @return  : List all the Mobile Capability added by the admin
	 */	
	
	 public function fetch_mobile_capability()
	 {
	    $capability_admin		= $this->rest->get('api/v1/targeting/fetch_mobile_capability',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($capability_admin);
	 }

	 /*
	 * 
	 * name		: edit_mobile_capability
	 * @param   : Null
	 * @return  : List all the Mobile Capability for admin
	 */	
	 	
	public function edit_mobile_capability($id=FALSE)
	{	
		$capability_list=$this->rest->get('api/v1/targeting/mobile_capability_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');
		$data['mobile_capability_details']=$capability_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_mobile_capability',$data);
	}	
	
	/*
	 * 
	 * name		: telecom_operators
	 * @param   : Null
	 * @return  : List all the Mobile telecom operators for admin
	*/	
	
	public function telecom_operators()
	{
		$data['page_title'] = "Telecom Operators";	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/tele_operators',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: fetch_telecom_operators
	 * @param   : Null
	 * @return  : List all the Mobile telecom operators for admin
	*/
	public function fetch_telecom_operators()
	{
		$tele_vals		= $this->rest->get('api/v1/targeting/fetch_tele_operators',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($tele_vals);
	}
	
	/*
	 * 
	 * name		: main_category
	 * @param   : Null
	 * @return  : List all the Category for admin
	 */	
	 	
	public function main_category()
	{	
		$data['page_title'] = "Main Category";	
		$data['breadcrumb'] = '';	
		$data['content'] = $this->load->view('targeting/main_category',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
		
	}
	
	/*
	 * 
	 * name		: fetch_main_category
	 * @param   : Null
	 * @return  : List all the categoryies added by the admin
	 */	
	
	public function fetch_main_category()
	{
		$cat_admin		= $this->rest->get('api/v1/targeting/fetch_category_main',array('api_key'=>get_session('api_key')),'json');
		
		echo convert_to_datatable_format($cat_admin); 
	}
	
	/*
	 * 
	 * name		: edit_main_category
	 * @param   : Null
	 * @return  : List all the Category for admin
	 */	
	 	
	public function edit_main_category($category_id=FALSE)
	{	
		$cat_list=$this->rest->get('api/v1/targeting/category',array('api_key'=>get_session('api_key'),'category_id'=>$category_id),'php');
		$data['category_details']=$cat_list[0];
		echo $this->load->view('targeting/modal_targeting/content/edit_main_category',$data);
	}
	
	/*
	* 
	* name		: keyword
	* @param   : Null
	* @return  : List all the keyword for admin
	*/	
		
	public function keyword()
	{	
		$data['page_title'] = $this->lang->line('keywords');	
		$data['breadcrumb'] = '';	
		
		$data['content'] = $this->load->view('targeting/keyword',$data,TRUE);	
		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);		
	}

	/*
	* 
	* name		: fetch_keyword
	* @param   : Null
	* @return  : List all the keyword added by the admin
	*/	

	public function fetch_keyword()
	{
		$key_admin		= $this->rest->get('api/v1/targeting/fetch_keyword',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($key_admin);
	}
	
	/*
	 * 
	* name		: add keyword
	* @param   : Null
	* @return  : Add keyword for admin
	*/	
		
	public function add_keyword()
	{	
		echo $this->load->view('targeting/modal_targeting/content/add_keyword');
	}
	/*
	* 
	* name		: edit keyword
	* @param   : Null
	* @return  : edit the keyword for admin
	*/	
		
	public function edit_keyword($keyword_id=FALSE)
	{
		if($keyword_id)
		{	
			$key_list				=	$this->rest->get('api/v1/targeting/fetch_keyword',array('api_key'=>get_session('api_key'),'keyword_id'=>$keyword_id),'php');
			
			$data['keyword_details']=	$key_list[0];
			$data['keyword_id']		=	$keyword_id;
			
			echo $this->load->view('targeting/modal_targeting/content/edit_keyword',$data);
		}
	}
	
	/*
	* 
	* name	   : Device
	* @param   : Null
	* @return  : List all the device for admin
	*/	
	 	
	public function device()
	{	
		$data['page_title'] = 	"Devices";	
		$data['breadcrumb'] = 	'';	
		$data['content'] 	= 	$this->load->view('targeting/devices',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);		
	}
	
	/*
	* 
	* name	   : Carrier
	* @param   : Null
	* @return  : List all the carrier for admin
	*/	
	 	
	public function carrier()
	{	
		$data['page_title'] = 	"Carriers";	
		$data['breadcrumb'] = 	'';	
		$data['content'] 	= 	$this->load->view('targeting/carriers',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);		
	}
	
	/*
	* 
	* name	   : Connection
	* @param   : Null
	* @return  : List all the connection for admin
	*/	
	 	
	public function connection()
	{	
		$data['page_title'] = 	"Connections";	
		$data['breadcrumb'] = 	'';	
		$data['content'] 	= 	$this->load->view('targeting/connections',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);		
	}
	
	/*
	* 
	* name	   : Language
	* @param   : Null
	* @return  : List all the connection for admin
	*/	
	 	
	public function language()
	{	
		$data['page_title'] = 	"Languages";	
		$data['breadcrumb'] = 	'';	
		$data['content'] 	= 	$this->load->view('targeting/languages',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);		
	}
	
	/*
	* 
	* name	   : fetch_device
	* @param   : Null
	* @return  : List all the categoryies added by the admin
	*/	
	
	public function fetch_targ_list($type=FALSE)
	{
		$targ		=	array('language'=>TAB_TARG_BROWSER_LANG,'device'=>TAB_TARG_DEVICE,'connection'=>TAB_TARG_CONN_TYPE,'carrier'=>TAB_TARG_MOBILE_CARRIER);
				
		$device		= 	$this->rest->get('api/v1/targeting/fetch_targ_list',array('api_key'=>get_session('api_key'),'table'=>$targ[$type]),'json');
		echo convert_to_datatable_format($device);
	}
	
	/*
	* 
	* name	   : add_targeting
	* @param   : Null
	* @return  :  echo the link when function is called 
	*/	
	
	public function add_targeting($type=FALSE)
	{	
		echo $this->load->view('targeting/modal_targeting/content/add_'.$type);
	}
	
    /*
	* 
	* name		: 	edit_targeting
	* @param   	: 	Null
	* @return  	: 	List all the targeting for admin
	*/	
	 	
	public function edit_targeting($type=FALSE,$id=FALSE)
	{
		if($type=='language')
		{
			$view	=	'edit_language';
			$table	=	TAB_TARG_BROWSER_LANG;
		}
		else if($type=='device')
		{
			$view	=	'edit_device';
			$table	=	TAB_TARG_DEVICE;
		}
		else if($type=='connection')
		{
			$view	=	'edit_connection';
			$table	=	TAB_TARG_CONN_TYPE;
		}
		else if($type=='carrier')
		{
			$view	=	'edit_carrier';
			$table	=	TAB_TARG_MOBILE_CARRIER;
		}
		else
		{
			$view	=	'edit_device';
			$table	=	TAB_TARG_DEVICE;
		}
				
		$targ_list	= 	$this->rest->get('api/v1/targeting/fetch_targ_list',array('api_key'=>get_session('api_key'),'table'=>$table,'targ_id'=>$id),'php');
		$data['targ_list']	=	$targ_list[0];
		echo $this->load->view('targeting/modal_targeting/content/'.$view,$data);
	}
}
