<?php 
class Sites extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->site();		
	}
	
	/*
	 * 
	 * name		:sites
	 * @param   :Null
	 * @return  :List all the sites for a particular
	 * 			 Publisher
	 */	
	 	
	 public function edit_sites_url_id()
	 {
		$this->session->unset_userdata('admin_site_edit_ids');
		$this->session->set_userdata('admin_site_edit_ids', $_POST['url_id']);
		echo json_encode($this->session->userdata('admin_site_edit_ids'));
	
	 }	
	public function site($account_id = FALSE)
	{
		$account_id=$this->session->userdata('admin_site_edit_ids');
		$data['page_title'] = 	"Sites";
		$data['breadcrumb'] = 	'';
		$data['account_id']	= 	$account_id;		
		$data['sites'] = $this->rest->get('api/v1/site/fetch',array("api_key"=>get_session('api_key')),'php');				
		$data['content'] 	= 	$this->load->view('sites/sites',$data,TRUE);		
		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);		
	}
	
	/*
	 * 
	 * name		:add_website
	 * @param   :Null
	 * @return  :Adds the website
	 * 			 
	 */	
	
	public function add_website($account_id = FALSE)
	{
		$api_key 			=	get_session('api_key');
		$data['account_id']	=	$account_id;
	
		$data['publishers']	=	$this->rest->get('api/v1/publisher/fetch', array("api_key" => $api_key), 'php');
		
		$category 			=	$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>$api_key),'php');
		
		if(is_array($category))
		{
			$data['category'] = $category;	
		}else{
			$data['category'] = '';	
		}
	
		echo $this->load->view('sites/modal_sites/content/add_website',$data);
	}
	
	public function edit_website($site_id = FALSE)
	{
		$api_key 			=	get_session('api_key');
		$site_info 			=	$this->rest->get('api/v1/site/fetch_site',array('site_id'=>$site_id, "api_key"=>$api_key),'php');
		$sel_category_id	=	$this->rest->get('api/v1/site/fetch_site_cat',array('site_id'=>$site_id, "api_key"=>$api_key), 'json');
		$category			=	$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>$api_key),'php');
		
		if(is_array($category))
		{
			$data['category'] = $category;	
		}else{
			$data['category'] = '';	
		}
		
		if(!empty($sel_category_id))
		{  
		  $data['sel_category'] = json_decode($sel_category_id);
			
		}else{
			$data['sel_category'] = '';
		}
		
		$data['site_info'] 	=	$site_info[0];
		
		$pub_info 			=	$this->rest->get('api/v1/publisher/fetch', array('account_id'=>$data['site_info']['account_id'], "api_key"=>$api_key), 'php');
		$data['pub_info'] 	=	$pub_info[0];
		
		echo $this->load->view('sites/modal_sites/content/edit_website',$data);
	}
	
	
	public function fetch_sites($account_id	= FALSE)
	{			
		$api_key 	=	get_session('api_key');  
		$siteid=$this->input->post('siteid');
		
		if(!empty($siteid))
		{ 
			$input= ($siteid)?((is_array($siteid))?$siteid:explode(',',$siteid)):'';			
			
			$sites		= $this->rest->get('api/v1/site/fetch',array("api_key"=>$api_key,"site_id"=>$input,'account_id' => $account_id),'json');
		}
		else
		{ 
			$sites		= $this->rest->get('api/v1/site/fetch',array("api_key"=>$api_key,'account_id' => $account_id),'json');
		}	
		
		echo convert_to_datatable_format($sites);
	}
	
	/*
	 * Lists the Web ad blocks
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_adblocks($account_id = FALSE, $site_id = FALSE)
	{
		$api_key 		=	get_session('api_key'); 
		$zone_type='';
		$ad_type='';
		if(isset($_GET['ad_type']))
		{
			$ad_type=$this->input->get('ad_type');
		}
		if(isset($_GET['zone_type']))
		{
			$zone_type=$this->input->get('zone_type');
		}
		$adblocks		=	$this->rest->get('api/v1/web_adblock/fetch',array("api_key"=>$api_key, "account_id" => $account_id, "site_id" => $site_id,"zone_type"=>$zone_type,"ad_type"=>$ad_type),'json');
		//echo $this->rest->debug();
		//echo "<pre>";
		//		print_r($adblocks);
		//echo "</pre>";
		
			
		echo convert_to_datatable_format($adblocks);
	}
}
