<?php 
class Settings extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->load->helper('download');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->config('report_configurations');
	}
	
	function index()
	{
		$this->personal_information();		
	}
	
	/*
	 * 
	 * name		:personal_information
	 * @param   :Null
	 * @return  :List personal_information for Admin
	 * 		
	 */	
	
	public function personal_information()
	{		
		$data['page_title'] = "Personal Information";	
		$data['breadcrumb'] = '';	
		$personal_info=$this->rest->get('api/v1/network/user_information',array('api_key'=>get_session('api_key')),'php');		
		$data['personal_info']=$personal_info[0];
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');	
		$company_info=$this->rest->get('api/v1/network/user_information',array('api_key'=>get_session('api_key')),'php');	
		$data['company_info']=$company_info[0];
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
		$data['currency']=$this->rest->get('api/v1/utilities/currencylist',array('api_key'=>get_session('api_key')),'php');	
		$seurity_info=$this->rest->get('api/v1/advertiser/security',array('api_key'=>get_session('api_key')),'php');	
		$data['seurity_info']=$seurity_info[0];			
		 $account_info=$this->rest->get('api/v1/network/user_information',array('api_key'=>get_session('api_key')),'php');	
		  $data['account_info']=$account_info[0];	
		 
		if(get_session('account_type')!='MANAGER')
		{ //IF ADMIN LOGIN
		  $account_info=$this->rest->get('api/v1/network/user_information',array('api_key'=>get_session('api_key')),'php');	
		  $data['account_info']=$account_info[0];	
		 // $data['content'] = $this->load->view('settings/account_settings',$data,TRUE);
		  $data['account_type']	='admin';
		}
		else
		{ //IF MANAGER LOGIN
		  $account_info=$this->rest->get('api/v1/network/user_role_info',array('api_key'=>get_session('api_key')),'php');
		  $data['account_info']=$account_info[0];
		   $data['account_type']	='manager';	
		 // $data['content'] = $this->load->view('settings/account_settings_user_role',$data,TRUE);
		}				
		$data['content'] = $this->load->view('settings/personal_information',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * 
	 * name		:company_information
	 * @param   :Null
	 * @return  :List company_information for Admin
	 */	
	
	public function company_information()
	{		
		$data['page_title'] = "Company Information";
		$data['breadcrumb'] = '';	
		$company_info=$this->rest->get('api/v1/network/user_information',array('api_key'=>get_session('api_key')),'php');	
		$data['company_info']=$company_info[0];
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');			
		$data['content'] = $this->load->view('settings/company_information',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:configurations
	 * @param   :Null
	 * @return  :List configurations for Admin
	 */	
	
	public function configurations()
	{		
		$data['page_title'] = "configurations";	
		$data['breadcrumb'] = '';
		$config_item	= $this->rest->get('api/v1/app_settings/get_values',array("network_id"=>get_session('account_id'),'api_key'=>get_session('api_key')),'php');
		$data['config'] = $config_item[0];
		$data['content'] = $this->load->view('settings/configurations',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * 
	 * name		:billing_information
	 * @param   :Null
	 * @return  :List billing_information for Admin
	 */	
	
	public function billing_information()
	{		
		$data['page_title'] = "Billing Information";
		$data['breadcrumb'] = '';	
		$company_info=$this->rest->get('api/v1/network/user_information',array('api_key'=>get_session('api_key')),'php');	
		$data['company_info']=$company_info[0];
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');			
		$data['content'] = $this->load->view('settings/billing_information',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
		
	/*
	 * 
	 * name		:payment_settings
	 * @param   :Null
	 * @return  :List payment_settings for Admin
	 */	
	
	public function payment_settings()
	{		
		$data['page_title'] = "Payment settings";	
		$data['breadcrumb'] = '';	
		$payment_info		=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>1),'php');
		
		$paypal_info		=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>2),'php');
		
		$webmoney_info		=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>3),'php');
		$bitcoin_info		=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>4),'php');
		$auth_info			=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>get_session('api_key'),'payment_type'=>5),'php');
		
		$data['payment_details']	=	($payment_info!='error' && is_array($payment_info))?$payment_info[0]:'';
		
		$data['paypal']				=	($paypal_info!='error' && is_array($paypal_info))?$paypal_info[0]:'';	
		
		$data['webmoney_details']	=	($webmoney_info!='error' && is_array($webmoney_info))?$webmoney_info[0]:'';
		$data['bitcoin_details']	=	($bitcoin_info!='error' && is_array($bitcoin_info))?$bitcoin_info[0]:'';
		$data['authorize_details']	=	($auth_info!='error' && is_array($auth_info))?$auth_info[0]:'';
				
		$data['content'] = $this->load->view('settings/payment_settings',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * 
	 * name		:email_preferences
	 * @param   :Null
	 * @return  :List email_preferences for Admin
	 */	
	
	public function email_preferences()
	{		
		$data['page_title'] = "Email Preferences";	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/email_preferences',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function activity_log()
	{
		$data['page_title']=$this->lang->line('activity_log');
		$data['breadcrumb']='';
		$data['search_date']= 	get_search_date($set['ADMIN']['REPORT_OVERVIEW']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('settings/activity_log',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_activity_log()
	{
		$activity_log		= $this->rest->get('api/v1/app_settings/fetch_activity_log',array("api_key"=>get_session('api_key')),'json');
		//echo $this->rest->debug(); die();
		echo convert_to_datatable_format($activity_log);     
	}
	
	public function fetch_activity_log_filter($type=false,$format='json')
	{ 
		
		$device= 	clean_data($this->input->post('device'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$to_date	= 	clean_data($this->input->post('to_date'));		
		$api_key 	= 	get_session('api_key');
		
		$input = array(
						'api_key'	=>	$api_key,
						'device'	=>	$device,
						'from_date' => $from_date,
						'to_date'   => $to_date				
					  );
		
						
		$data			= $this->rest->post('api/v1/app_settings/fetch',$input,'json');
		//print_r($input);
		//$this->rest->debug();
		echo convert_to_datatable_format($data);  
		
	}
	
	
	
	
	public function delete_log()
	{
	}
	
	public function fetch_payment_changes()  
	{
		$payment_changes = $this->rest->get('api/v1/app_settings/fetch_payment_changes',array("api_key"=>get_session('api_key')),'json');		
		echo convert_to_datatable_format($payment_changes);  
	}
	
	
	/*
	 * 
	 * name		: Manager_permissions
	 * @param   : Null
	 * @return  : Manager_permissions for Admin
	 */	
	
	public function manager_permissions()
	{		
		$data['page_title'] = "Manager Permissions";	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/manager_permissions',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: web pages
	 * @param   : Null
	 * @return  : Web pages for Admin
	 */	
	
	public function web_pages()
	{		
		$data['page_title'] = "Web Pages";	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/web_pages',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: mass email to advertisers/publishers
	 * @param   : Null
	 * @return  : mass email to advertisers/publishers
	 */	
	 
	public function mass_email()
	{		
		$data['page_title'] = "Mass Email";	
		$data['breadcrumb'] = '';
		$data['advertiser']	=	$this->rest->get('api/v1/advertiser/mass_email_fetch',array('api_key'=>get_session('api_key')),'php');
		$data['adv_count'] = count($data['advertiser']);
		//$data['publisher']	=	$this->rest->get('api/v1/publisher/mass_email_fetch',array('api_key'=>get_session('api_key')),'php');
		$data['publisher'] = $this->rest->get('api/v1/publisher/mass_email_fetch',array('netid'=>'2','api_key'=>get_session('api_key')),'php');
		//print_r($data['publisher']);exit;
		$email_names = array_column($data['publisher'], 'email');
		$data['pubs_role_info'] = $this->rest->get('api/v1/network/pubs_role_info',array('email_names'=>$email_names,'api_key'=>get_session('api_key')),'php');
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
		$data['state']=$this->rest->get('api/v1/utilities/statelist',array('api_key'=>get_session('api_key')),'php');
		$data['temp_list']		= 	$this->rest->get('api/v1/newsletter_template/fetch_temp_image',array("api_key"=>get_session('api_key')),'php'); 
		$data['templates']= $this->rest->get('api/v1/app_settings/fetch_template',array("api_key"=>get_session('api_key')),'php');
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADVERTISER']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['pub_count'] = count($data['publisher']);
		$data['increment_val']=250;
		$data['content'] = $this->load->view('settings/mass_email',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: Newsletter Template
	 * @param   : Null
	 * @return  : new page for mass mail to advertisers/publishers
	 */	
	 
	public function newsletter_temp()
	{		
		$data['page_title'] = "Mass Email";	
		$data['breadcrumb'] = '';
	//	$data['advertiser']	=	$this->rest->get('api/v1/advertiser/mass_email_fetch',array('api_key'=>get_session('api_key')),'php');
		//$data['adv_count'] = count($data['advertiser']);
	//	$data['publisher']	=	$this->rest->get('api/v1/publisher/mass_email_fetch',array('api_key'=>get_session('api_key')),'php');
		//$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
		//$data['state']=$this->rest->get('api/v1/utilities/statelist',array('api_key'=>get_session('api_key')),'php');
	//	$data['pub_count'] = count($data['publisher']);
	//	$data['increment_val']=250;
	$data['temp_deletion']		= 	$this->rest->get('api/v1/newsletter_template/fetch_temp_deletion',array("api_key"=>get_session('api_key')),'php'); 
	$data['api_key']=get_session('api_key');
		$data['content'] = $this->load->view('newsletter/newletter_template',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
			
	
	/*
	 * 
	 * name		: Event planner
	 * @param   : Null
	 * @return  : Event planner for Admin
	 */	
	
	public function event_planner()
	{		
		$data['page_title'] = "Event Planner";	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/event_planner',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	
	/*
	 * 
	 * name		:referal_programs
	 * @param   :Null
	 * @return  :referal_programs for Admin
	 */	
	
	public function referal_programs()
	{		
		$data['page_title'] = "Referal Programs";	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/referal_programs',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: account_settings
	 * @param   : Null
	 * @return  : account_settings for Admin
	 */	
	
	public function account_settings()
	{	
		$api_key 	= 	get_session('api_key');
		//print_r($api_key); die("ff");
			
		$data['page_title'] = "Account Settings";	
		$data['breadcrumb'] = '';
		$data['currency']=$this->rest->get('api/v1/utilities/currencylist',array('api_key'=>get_session('api_key')),'php');	
		$seurity_info=$this->rest->get('api/v1/advertiser/security',array('api_key'=>get_session('api_key')),'php');	
		$data['seurity_info']=$seurity_info[0];			
		if(get_session('account_type')!='MANAGER')
		{ //IF ADMIN LOGIN
		  $account_info=$this->rest->get('api/v1/network/user_information',array('api_key'=>get_session('api_key')),'php');	
		  $data['account_info']=$account_info[0];	
		  $data['content'] = $this->load->view('settings/account_settings',$data,TRUE);
		}
		else
		{ //IF MANAGER LOGIN
		  $account_info=$this->rest->get('api/v1/network/user_role_info',array('api_key'=>get_session('api_key')),'php');
		  $data['account_info']=$account_info[0];	
		  $data['content'] = $this->load->view('settings/account_settings_user_role',$data,TRUE);
		}		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: mobile_screen_settings
	 * @param   : Null
	 * @return  : mobile screen for Admin
	*/
	public function mobile_screen_settings()
	{
		$data['page_title'] 	=	"Mobile Screen Settings";
		$data['breadcrump']		=	"";
		$data['content'] = $this->load->view('mobile_screen/mobile_screens',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: display_screen_settings
	 * @param   : Null
	 * @return  : display screen for Admin
	*/
	public function display_screen_settings()
	{
		$data['page_title'] 	=	"Display Screen Settings";
		$data['breadcrump']		=	"";
		$data['content'] = $this->load->view('display_screen/display_screens',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	/*
	 * 
	 * name		: display_keyword_settings
	 * @param   : Null
	 * @return  : display keywords for Admin
	*/
	public function keyword_settings()
	{
		$data['page_title'] 	=	"Add Keyword Settings";
		$data['breadcrump']		=	"";
		$data['content'] = $this->load->view('keywords/add_keywords',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function add_inline_keywords()
	{	
		echo $this->load->view('keywords/add_inline_keywords',$data);
	}
		public function fetch_keyword_list()
	{
		$key_admin		= $this->rest->get('api/v1/targeting/fetch_inline_keyword',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($key_admin);
	}
	public function edit_main_keywords($keyword_id=FALSE)
	{	
		$keyword_list=$this->rest->get('api/v1/targeting/inline_keyword_fetch',array('api_key'=>get_session('api_key'),'keyword_id'=>$keyword_id),'php');
		$data['keyword_details']=$keyword_list[0];
		echo $this->load->view('keywords/edit_main_keywords',$data);
	}
	/*
	 * 
	 * name		: fetch_display_screen_sizes
	 * @param   : Null
	 * @return  : display screen for Admin
	*/
	public function fetch_display_screen_sizes()
	{
		$screen_sizes = $this->rest->get('api/v1/network/fetch_display_screen',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($screen_sizes);
	}
	
	/*
	 * 
	 * name		: fetch_screen_sizes
	 * @param   : Null
	 * @return  : mobile screen for Admin
	*/
	public function fetch_screen_sizes()
	{
		$screen_sizes = $this->rest->get('api/v1/network/fetch_mobile_screen',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($screen_sizes);
	}
	
	/*
	 * 
	 * name		: edit_screen_sizes
	 * @param   : Null
	 * @return  : edit mobile screen for Admin
	*/
	public function edit_screen_sizes($screen_id=FALSE)
	{	
		if($screen_id)
		{	
			$screen			=	$this->rest->get('api/v1/network/edit_screen_size',array('api_key'=>get_session('api_key'),'screen_id'=>$screen_id),'php');
			$data['mobile_data']	=	$screen[0];
			echo $this->load->view('mobile_screen/modal_screen/content/edit_screen',$data);
		}
	}
	
	/*
	 * 
	 * name		: edit_display_screen_sizes
	 * @param   : Null
	 * @return  : edit display screen for Admin
	*/
	public function edit_display_screen_sizes($screen_id=FALSE)
	{	
		if($screen_id)
		{	
			$screen			=	$this->rest->get('api/v1/network/edit_display_screen_size',array('api_key'=>get_session('api_key'),'screen_id'=>$screen_id),'php');
			$data['display_data']	=	$screen[0];
			echo $this->load->view('display_screen/modal_screen/content/edit_screen',$data);
		}
	}
	
	/*
	 * 
	 * name		: add_display_new_screen
	 * @param   : Null
	 * @return  : add display screen for Admin
	*/
	public function add_display_new_screen()
	{
		echo $this->load->view('display_screen/modal_screen/content/add_screen');
	}
	
	/*
	 * 
	 * name		: add_new_screen
	 * @param   : Null
	 * @return  : add mobile screen for Admin
	*/
	public function add_new_screen()
	{
		echo $this->load->view('mobile_screen/modal_screen/content/add_screen');
	}
	
	/*
	 * 
	 * name		: Add a div link here
	 * @param   : Null
	 * @return  : Add a div link here
	 */	
	
	public function add_div_link()
	{		
		$data['page_title'] = 	"Add Div here Link";	
		$data['breadcrumb'] = 	'';
		
		$data['publisher']	=	$this->rest->get('api/v1/publisher/fetch',array('api_key'=>get_session('api_key')),'php');		
		
		$pub_link			=	$this->rest->get('api/v1/network/fetch_div_link',array('api_key'=>get_session('api_key'),'table'=>TAB_AFFILIATE,'is_div_link'=>'-1'),'php');
		
		$data['pub_count']	=	($pub_link!='error')?count($pub_link):0;
		
		$pub_list	=	$this->rest->get('api/v1/network/fetch_div_link',array('api_key'=>get_session('api_key'),'table'=>TAB_AFFILIATE,'is_div_link'=>'1'),'php');
		
		
		$select_pub	=	'';
		if($pub_list!='error'):
			foreach($pub_list as $pu):
				$select_pub[]	=	$pu['account_id'];
			endforeach;
		endif;
		
		$data['select_pub']	=	$select_pub;
		
		$data['adblock']	=	$this->rest->get('api/v1/publisher/fetch_adblocks_div',array('api_key'=>get_session('api_key'),'account_id'=>$select_pub),'php');
		
		$adb_link			=	$this->rest->get('api/v1/network/fetch_div_link',array('api_key'=>get_session('api_key'),'account_id'=>$select_pub,'table'=>TAB_ZONES,'is_div_link'=>'-1'),'php');
		
		$data['adb_count']	=	($adb_link!='error')?count($adb_link):0;
		//$this->rest->debug(); 
		
		$adb_list	=	$this->rest->get('api/v1/network/fetch_div_link',array('api_key'=>get_session('api_key'),'account_id'=>$select_pub,'table'=>TAB_ZONES,'is_div_link'=>'1'),'php');
		
				
		$select_adb	=	'';
		if($adb_list!='error'):
			foreach($adb_list as $ad):
				$select_adb[]	=	$ad['zoneid'];
			endforeach;
		endif;
		
		$data['select_adb']	=	$select_adb;
		
		$data['content'] 	= 	$this->load->view('settings/add_div_link',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * 
	 * name		:log_settings
	 * @param   :Null
	 * @return  :Loads the form to set log settings
	 */	

	public function log_settings()
	{
		$data['page_title'] = "Log Settings";
		$data['breadcrumb'] = '';
		$log_setting=$this->rest->get('api/v1/app_settings/fetch_log_settings',array('api_key'=>get_session('api_key')),'php');	
		$data['log_settings']=$log_setting;		
		
		
		$data['content'] = $this->load->view('settings/log_settings',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:security
	 * @param   :Null
	 * @return  :Loads the form to get user security
	 */	

	public function security()
	{
		$data['page_title'] = "Security";
		$data['breadcrumb'] = '';
		$security_info=$this->rest->get('api/v1/advertiser/security',array('api_key'=>get_session('api_key')),'php');	
		$data['security_info']=$security_info[0];		
		$security_question=$this->rest->get('api/v1/advertiser/security_question',array('api_key'=>get_session('api_key')),'php');
		$data['security_question']=$security_question;	
		$personal_info=$this->rest->get('api/v1/advertiser/user_information',array('api_key'=>get_session('api_key')),'php');		
		$data['personal_info']=$personal_info[0];	
		$data['content'] = $this->load->view('settings/security',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function news_create()
	{		
		$data['page_title'] = "News Create ";	
		$data['breadcrumb'] = '';
	 
		$data['content'] = $this->load->view('settings/news_create',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function add_notification_settings()
	{
		$data['templates']= $this->rest->get('api/v1/app_settings/fetch_template',array("api_key"=>get_session('api_key')),'php');
		$data['content'] = $this->load->view('settings/add_notification',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	//nodification settings Content for Advertiser/Publisher
	public function notification_settings()
	{		
		$data['page_title'] = $this->lang->line('notifi_sett_content');
		$data['templates']= $this->rest->get('api/v1/app_settings/fetch_template',array("api_key"=>get_session('api_key')),'php');
		$data['content'] = $this->load->view('settings/notification_email_list',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);   
	} 
	
	public function fetch_notification_msg()
	{
		$notification_msg		= $this->rest->get('api/v1/app_settings/fetch_notification_msg',array("api_key"=>get_session('api_key')),'json');
		//echo $this->rest->debug();  die("test");  
		echo convert_to_datatable_format($notification_msg);       
	}
	
	public function edit_notification_msg($id=FALSE)
	{ 
		$data['page_title'] = $this->lang->line('edit_notifi_sett_content');
		$data['templates']= $this->rest->get('api/v1/app_settings/fetch_edit_msg',array("api_key"=>get_session('api_key'),"id"=>$id),'php');
	
		$data['settings_option']=$this->rest->get('api/v1/app_settings/edit_select_type',array("api_key"=>get_session('api_key')),'php');
		$data['msg_id']=$id;
		$data['content'] = $this->load->view('settings/edit_notification',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data); 	
	}	

	public function save_image()
	{
		//$imagedata = $_POST['imgdata'];
		$imagedatas = $_POST['imagedata'];
		//$file_name = $_POST['fil_name'];
		$tags = $_POST['tags'];
		$content = file_get_contents($imagedatas);
		$package_path = explode('application',dirname(__DIR__));
			$fi = new FilesystemIterator($package_path[0].$this->config->item('read_template_data'), FilesystemIterator::SKIP_DOTS);
			$files_count = iterator_count($fi);
			if(empty($file_name))
			{
				$files_count = $files_count + 1;
				$file_name = 'Template '.$files_count.'.html';
				$img_file_name = 'Template '.$files_count.'.png';
			}
				
		$file_url = $package_path[0].$this->config->item('read_template_image').$img_file_name;
		$fp = fopen($file_url, "w");
		fwrite($fp, $content);
		fclose($fp); 
		$file_url1 = $package_path[0].$this->config->item('read_template_data').$file_name;
		$fp1 = fopen($file_url1, "w");
		fwrite($fp1, $tags);
		fclose($fp1); echo $file_url.$file_url1;exit;
	}
	
	/*
	 * Mass import 
	 * */
	public function mass_import()
	{
		$data['page_title'] = "Company Information";
		$data['breadcrumb'] = '';	
		$company_info=$this->rest->get('api/v1/network/user_information',array('api_key'=>get_session('api_key')),'php');	
		$data['company_info']=$company_info[0];
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');			
		$data['content'] = $this->load->view('settings/mass_import',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}	
	function import_download_file()
	{ 
		
		$data = file_get_contents("./csv/upload/import.zip"); // Read the file's contents		
		$name = 'import.zip';
		 ob_clean();
		force_download($name, $data);  
	}	
}
