<?php 
class RTB extends CI_Controller
{
    function __construct()
	{
		parent::__construct();
		
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	
	}

	function index()
	{
		$this->get_rtb();
	}

	/*
	 * 
	 * name: advertiser approvals
	 * @param : null
	 * @return :list of advertiser need to be approve.
	 */	

	public function get_rtb()
	{
		
		//$data['page_title'] = $this->lang->line('organize_rtb');
		$data['page_title'] = "RTB";
		$data['breadcrumb'] = '';
		$data['content'] = $this->load->view('rtb/rtb_list',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*********
	 name : @ fetch_rtb_list
	 params : none
	 @return : all rtb list 
	*******/
	public function fetch_rtb_list()
	{
	    $rtb_list		= $this->rest->get('api/v1/rtb/fetch',array("api_key"=>get_session('api_key')),'json');

		echo convert_to_datatable_format($rtb_list);

	}
	
	/*********
	 name : @ fetch_rtb_list
	 params : none
	 @return : all rtb list 
	*******/
	public function add_rtb()
	{	
		//For available currency types
		$data['currency_type']=$this->rest->get('api/v1/utilities/currency_type',array("api_key"=>get_session('api_key')),'php');		
		echo $this->load->view('rtb/modal_rtb/content/add_rtb',$data);
		
	}
	
	
	/*

	 * 

	 * name		: edit_rtb

	 * @param   : Null

	 * @return  : Fetch individual rtb details

	 */	

	 	

	public function edit_rtb($exchange_id=FALSE)

	{	
		
		if($exchange_id)
		{
			//For available currency types
		 $data['currency_type']=$this->rest->get('api/v1/utilities/currency_type',
		 array("api_key"=>get_session('api_key')),'php');
		 	$params=array('api_key'=>get_session('api_key'),'exchange_id'=>$exchange_id);
			$rtb_details  =  ($this->rest->get('api/v1/rtb/get_rtb_edit',$params,'php')); 
			$data['rtb_list']=$rtb_details[0];
			echo $this->load->view('rtb/modal_rtb/content/edit_rtb',$data);
	
		}

	}

}
