<?php 
class Reports extends CI_Controller
{
    function __construct()
	{
		parent::__construct();
		
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->config('report_configurations');
		$this->load->library("PHPExcel");
		$this->load->library("PHPExcel/IOFactory");
		
		$this->load->library('zip');
	}

	function index()
	{
		$this->advertisers(); 
	}

	/*
	 * 
	 * name: advertisers
	 * @param : null
	 * @return :list all advertiser statistics .
	 */	

	public function advertisers()
	{
		$data['page_title'] 	= 	"Advertiser reports";

		$data['breadcrumb'] 	= 	'';
		
		$api_key				=	get_session('api_key');

		/* Advertiser Filter */
		$data['adv_data'] 		=	$this->rest->get('api/v1/report/fetch_advertiser',array('api_key'=>get_session('api_key')),'php');
		
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>get_session('api_key')),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>get_session('api_key')),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADMIN']['REPORT_ADVERTISER']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] 		= 	$this->load->view('report/advertisers_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by advertiser
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_advertiser_stats($env='all',$adv_id='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_ADVERTISER';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($adv_id != 'all'){
			$input['adv_account_id'] = $adv_id;
		}
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}			  
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
					  
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');

		#$this->rest->debug();

		echo $data;
	}
    public function admin_advertisers_campaign_report_id()
	 {
		$this->session->unset_userdata('adm_adv_cam_rep');
		$this->session->set_userdata('adm_adv_cam_rep', $_POST['url_id']);
		echo json_encode($this->session->userdata('adm_adv_cam_rep'));
	
	 }
   
    /*
	 * 
	 * name: advertisers_campaign
	 * @param : null
	 * @return :list all campaign statistics .
	 */	

	public function advertisers_campaign($campaign_id=FALSE)
	{
		$data['page_title'] 	= 	"Campaign reports";

		$data['breadcrumb'] 	= 	'';

		$api_key				=	get_session('api_key');
		$campaign_id=$this->session->userdata('adm_adv_cam_rep');
		$data['campaign_id'] 	= 	($campaign_id!=FALSE)?$campaign_id:'';
		
		/* Advertiser Filter */
		$data['adv_data'] 		=	$this->rest->get('api/v1/report/fetch_advertiser',array('api_key'=>get_session('api_key')),'php');
		
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>get_session('api_key')),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>get_session('api_key')),'php');
		//~ print_r($this->rest->debug());exit;
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADMIN']['REPORT_CAMPAIGN']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] 		= 	$this->load->view('report/advertisers_campaign',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}

	/*
	 * Lists the Statistics by campaign
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_campaign_stats($env='all',$cam_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_CAMPAIGN';
		$display_type	= 	'TABLE';
		
		$input = array( 'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type,
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
					  
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
	    #$this->rest->debug();exit;
		echo $data;
		
		//echo convert_to_datatable_format($data);
	}
	 public function edit_advertisers_creative()
	 {
		$this->session->unset_userdata('admin_edit_adv_crtive_hou');
		$this->session->set_userdata('admin_edit_adv_crtive_hou', $_POST['url_id']);
		echo json_encode($this->session->userdata('admin_edit_adv_crtive_hou'));
	
	 }	
	
	/*
	 * 
	 * name: advertisers_creative
	 * @param : null
	 * @return :list all creative statistics .
	 */	

	public function advertisers_creative($creative_id=FALSE)
	{
		$data['page_title'] 	= 	"Creative reports";

		$data['breadcrumb'] 	= 	'';

		$api_key				=	get_session('api_key');
		$creative_id=$this->session->userdata('admin_edit_adv_crtive_hou');

		$data['creative_id'] 	= 	($creative_id!=FALSE)?$creative_id:'';
		
		/* Advertiser Filter */
		$data['adv_data'] 		=	$this->rest->get('api/v1/report/fetch_advertiser',array('api_key'=>get_session('api_key')),'php');
		
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>get_session('api_key')),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>get_session('api_key')),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADMIN']['REPORT_CREATIVE']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] 		= 	$this->load->view('report/advertisers_creative',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}

	/*
	 * Lists the Statistics by creative
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_creative_stats($env='all',$cam_id='all',$creative_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= 	get_session('api_key');
		$page		= 	'REPORT_CREATIVE';		
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'search_term'	=>	$_REQUEST['sSearch']
					  );
		
		$input['display_type'] 	= 'TABLE';
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($creative_id != 'all'){
			$input['creative_id'] = $creative_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		// Pagination Parameters
		if(isset($_REQUEST['sEcho'])){
		
		}
		
		// GET TOTAL RECORDS
		$input['result_type'] 	= 'COUNT';
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		$records = json_decode($data); 
		
		
		
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		
		$input['result_type'] 	= 'DATA';
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		//$this->rest->debug();
		//exit;
		
		//echo convert_to_datatable_format_with_server_pagination($data,$_REQUEST['sEcho'],$records->total);
		echo $data;
	
	}
	
	/*
	 * 
	 * name: publisher
	 * @param : null
	 * @return : list all publisher statistics .
	 */	

	public function publishers()
	{	
		$data['page_title'] = 	"Publisher reports";

		$data['breadcrumb'] = 	'';
		
		$api_key				=	get_session('api_key');
		
		/* Publisher Filter */
		$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$api_key),'php');
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>$api_key),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['ADMIN']['REPORT_PUBLISHER']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] 	= 	$this->load->view('report/publishers_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by advertiser
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_publisher_stats($env='all',$pub_id='all',$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_PUBLISHER';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] = $pub_id;
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}	
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}		  
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
					  
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');

		//$this->rest->debug();

		echo $data;
	}
		public function edit_publishers_site_id()
	 {
		$this->session->unset_userdata('admin_edit_pubs_sites_ids');
		$this->session->set_userdata('admin_edit_pubs_sites_ids', $_POST['url_id']);
		echo json_encode($this->session->userdata('admin_edit_pubs_sites_ids'));
	
	 }	
	/*
	 * 
	 * name: publisher_site
	 * @param : null
	 * @return : list all publisher statistics .
	 */	

	public function publishers_site($siteid=FALSE)
	{ 
		$data['page_title'] = 	"Sites report";

		$data['breadcrumb'] = 	'';
		
		$api_key			=	get_session('api_key');
		$siteid=$this->session->userdata('admin_edit_pubs_sites_ids');
		if(!empty($siteid))
		{
			$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key,"site_id"=>$siteid),'php');
		}
		else
		{
			// Fetch adblock list
			$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		
		}		
		/* Publisher Filter */
		$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$api_key),'php');
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
	
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>$api_key),'php');
						
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['site_id']=$siteid;
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['ADMIN']['REPORT_SITE']['CHART']['DEFAULT_INTERVAL']);		
		$data['content'] 	= 	$this->load->view('report/publishers_site',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	
	function sites_adblock($siteid=FALSE)
	{
		$api_key			=	get_session('api_key');
		$adb		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key,"site_id"=>$siteid),'php');
		
		$adblock='';
		$adblock="<select name='adblock' id='adblock' class='chosen-select' >
				  <option value='all'>".$this->lang->line('all_adb')."</option>";
				  if(!empty($adb)):
					foreach($adb as $ab):					
					$adblock.="<option value=".$ab['zoneid'].">".$ab['zonename']."</option>";
					endforeach; 
				  else:
					$adblock.="<option value=''>".$this->lang->line('no_adbl')."</option>";
				  endif;
		$adblock.="</select>";	
												

		echo $adblock;
		
	}
	
	/*
	 * Lists the Statistics by campaign
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 */	
	
	public function fetch_sites_stats($env='all',$site_id='all',$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_SITE';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
					  
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		echo $data;
	}
	public function edit_publishers_adblk_id()
	 {
		$this->session->unset_userdata('edit_pub_adk_id');
		$this->session->set_userdata('edit_pub_adk_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('edit_pub_adk_id'));
	
	 }	
	/*
	 * 
	 * name: publisher
	 * @param : null
	 * @return : list all publisher statistics .
	 */	

	public function publishers_adblock($adblock_id=FALSE)
	{
		$data['page_title'] 	= 	"Ad block reports";

		$data['breadcrumb'] 	= 	'';
		
		$api_key				=	get_session('api_key');
		$adblock_id = $this->session->userdata('edit_pub_adk_id');
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		
		// Fetch adblock list
		if(!empty($adblock_id))
		{
			$data['siteid']	= 	$this->rest->get('api/v1/report/fetch_site_adblock',array('api_key'=>$api_key,'adblock_id'=>$adblock_id),'php');
			$site_id=$data['siteid'][0]['site_id'];			
			$data['adblock']	= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key,'site_id'=>$site_id),'php');			
		}	
		else
		{
			$data['adblock']			= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		}
		/* Publisher Filter */
		$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$api_key),'php');
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		
		
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>$api_key),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE  
		$data['adblock_id']=$adblock_id;
		$data['site_id']=$data['siteid'][0];
				
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADMIN']['REPORT_ADBLOCK']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] 		= 	$this->load->view('report/publishers_adblock',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by campaign
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_adblock_stats($env='all',$site_id='all',$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_ADBLOCK';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
					  
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');

		echo $data;
	}
	
	
	
	/*
	 * 
	 * name: geo_report
	 * @param : null
	 * @return : list all geographical statistics .
	 */	

	public function geo_report()
	{
		$data['page_title'] 	= 	"Geographical reports";

		$data['breadcrumb'] 	= 	'';

		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$api_key				=	get_session('api_key');

		/* Advertiser Filter */
		$data['adv_data'] 		=	$this->rest->get('api/v1/report/fetch_advertiser',array('api_key'=>$api_key),'php');
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>$api_key),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>$api_key),'php');
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>$api_key),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>$api_key),'php');
		
		/* Publisher Filter */
		$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$api_key),'php');
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADMIN']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);
				
		$data['content'] 		= 	$this->load->view('report/geo_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}

	public function fetch_country_stat($env='all',$cam_id='all',$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$account_type 	= 	get_session('account_type');
		$page			= 	'REPORT_GEO_GRAPHICAL';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type,
						'stat_type'		=>	'COUNTRY',
					  );
		
		if($env != 'all'){
			$input['environment']= 	$env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id']= 	$cam_id;
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = 	$adb_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
					  
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
	
	
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
			//print_r($input);exit;
			//echo $this->rest->debug();exit;	
		echo $data;
	}
	
	
	 /*
	 * 
	 * name: earnings_report
	 * @param : null
	 * @return : list all earnings statistics .
	 */	

	public function earnings_report()
	{
		$data['page_title'] = "Earnings reports";

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('report/earnings_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: adx_report
	 * @param : null
	 * @return : list all adexchangeperformance statistics .
	 */	

	public function adx_report()
	{
		$data['page_title'] = "Ad exchange performance reports";

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('report/adx_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: environment_report
	 * @param : null
	 * @return : list all environment statistics .
	 */	

	public function environment_report()
	{
		$data['page_title'] 	= 	"Environment performance reports";

		$data['breadcrumb'] 	= 	'';
		
		$api_key 				= 	get_session('api_key');
		
		/* Advertiser Filter */
		$data['adv_data'] 		=	$this->rest->get('api/v1/report/fetch_advertiser',array('api_key'=>$api_key),'php');
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>$api_key),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>$api_key),'php');
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>$api_key),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>$api_key),'php');
		
		/* Publisher Filter */
		$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$api_key),'php');
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADMIN']['REPORT_ENVIRONMENT']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] 		= 	$this->load->view('report/environment_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function platform_report()
	{
		
		$data['page_title'] = "Platform reports";

		$data['breadcrumb'] = '';

		$api_key	=	get_session('api_key');
		
		/* Basic */
		$data['timezone'] 		=	$this->rest->get('api/v1/report/fetch_timezone',array('api_key'=>$api_key),'php');
		
		/* Advertiser Filter */
		$data['adv_data'] 		=	$this->rest->get('api/v1/report/fetch_advertiser',array('api_key'=>$api_key),'php');
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>$api_key),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>$api_key),'php');
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>$api_key),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>$api_key),'php');
		
		/* Publisher Filter */
		$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$api_key),'php');
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
			
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 	= 	$this->config->item('report_config');
		$data['search_date'] = 	get_search_date($set['ADMIN']['PLATFORM_REPORT']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/platform_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the Statistics by campaign
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_environment_stats($env='all',$cam_id='all',$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_ENVIRONMENT';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($cam_id != 'all'){
			$input['campaign_id'] = $cam_id;
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}			  
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';		  
					  
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		//$this->rest->debug();
		echo $data;
	}
	
	
	public function generate_csv()
	{
		
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_CREATIVE';
		
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'search_term'=>''
					  );
		
		$input['display_type'] 	= 'TABLE';
		
		
		
		
		$input['result_type'] 	= 'DATA';
		$data			= $this->rest->post('api/v1/report/fetch',$input,'csv');
		
		//~ $this->rest->debug();
		//~ exit;
		
		header('Content-type: text/csv');
		header('Content-Disposition: attachment; filename="downloaded.csv"');
			 
		
		//echo convert_to_datatable_format_with_server_pagination($data,$_REQUEST['sEcho'],$records->total);
		echo $data;
		
	}
	
	/*
	 * Lists the Statistics by creative
	 * 
	 * name		:fetch_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_platform_stats($format='json')
	{		
		$interval	= 	clean_data($this->input->post('interval'));
		
		$timezone	= 	clean_data($this->input->post('timezone'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$to_date	= 	clean_data($this->input->post('to_date'));
		
		$metrics	= 	clean_data($this->input->post('metrics'));

		$adv_id		= 	clean_data($this->input->post('advertiser'));
		$cam_id		=  	clean_data($this->input->post('campaign'));
		$cre_id		= 	clean_data($this->input->post('creative'));
		$pub_id		= 	clean_data($this->input->post('publisher'));
		$sit_id		= 	clean_data($this->input->post('site'));
		$adb_id		= 	clean_data($this->input->post('adblock'));
		$country	= 	clean_data($this->input->post('country'));
		$adsize		= 	clean_data($this->input->post('adsize'));
		$camtyp 	= 	clean_data($this->input->post('revtype'));	
		
		
		$dimens		= 	clean_data($this->input->post('dimensions'));

		$api_key 	= 	get_session('api_key');
		
		$page		= 	'PLATFORM_REPORT';
		
		$input = array(
						'api_key'	=>	$api_key,
						'page'		=>	$page,
						'interval'	=>	$interval,
						'timezone'	=>	$timezone											
					  );
		
		$input['display_type'] 	= 'TABLE';
		
		if($adv_id != 'all'){
			$input['adv_account_id'] = ($adv_id)?((is_array($adv_id))?$adv_id:explode(',',$adv_id)):'';	
		}
		
		if($cam_id != 'all'){
			$input['campaign_id'] = ($cam_id)?((is_array($cam_id))?$cam_id:explode(',',$cam_id)):'';
		}
		
		if($cre_id != 'all'){
			$input['creative_id'] = ($cre_id)?((is_array($cre_id))?$cre_id:explode(',',$cre_id)):'';
		}
		
		if($pub_id != 'all'){
			$input['pub_account_id'] = ($pub_id)?((is_array($pub_id))?$pub_id:explode(',',$pub_id)):'';
		}
		
		if($sit_id != 'all'){
			$input['site_id'] = ($sit_id)?((is_array($sit_id))?$sit_id:explode(',',$sit_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}
		
		if($country != 'all'){
			$input['country'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
		
		if($camtyp != 'all'){
			$input['camtyp'] = ($camtyp)?((is_array($camtyp))?$camtyp:explode(',',$camtyp)):'';
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		$input['metrics'] 	= 	($metrics)?((is_array($metrics))?$metrics:explode(',',$metrics)):'';	
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		if($interval!='CUMULATIVE')
		{
			if(!empty($input['dimensions']))
			{
				array_unshift($input['dimensions'],$interval);
			}
			else
			{
				$input['dimensions']	=	array($interval);
			}			
		}		
		
		if(!empty($input['dimensions']) && is_array($input['dimensions']))
		{			
			$input['columns']	=	array_merge($input['metrics'],$input['dimensions']);
		}
		else
		{
			$input['columns']	=	$input['metrics'];
		}				
			
		
		if($format!='php')
		{
			$input['stat_type']		=	'PLATFORM';
			
			$input['search_term']	=	$_REQUEST['sSearch'];
			
			if(isset($_REQUEST['iDisplayStart'])){
				$input['start'] = $_REQUEST['iDisplayStart'];
			}
			
			if(isset($_REQUEST['iDisplayLength'])){
				$input['end'] = ($_REQUEST['iDisplayLength']!='-1')?$_REQUEST['iDisplayLength']:'';
			}
			
			$input['datatable_obj'] = $_REQUEST;		
		
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
			
			//$this->rest->debug();
		
			echo $data;
		}
		else
		{
			$input['stat_type']		=	'EXPORT';
			$input['search_term']	=	'';
			
			$input['datatable_obj']['sSearch'] = '';
			$input['datatable_obj']['sEcho'] = '';
			$input['result_type'] 	= 'DATA';		
				
			$data	= 	$this->rest->post('api/v1/report/fetch',$input,'json');			
			//$this->rest->debug();
			
			return json_decode($data);
		}
	
	}
	
	/*
	 * 
	 * name: dsp
	 * @param : null
	 * @return : list all dsp statistics .
	 */	

	public function dsp()
	{	

		$data['page_title'] = $this->lang->line('dsp_report');

		$data['breadcrumb'] = '';
		
		#$network_account_id	=	get_session('network_account_id');
		#$network_id			=	get_session('account_id');
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);

		$data['content'] = $this->load->view('report/dsp_report',$data,TRUE);
		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: dsp
	 * @param : null
	 * @return : list all dsp statistics .
	 */	

	public function dsp_date($exchange_id=false)
	{	
		$data['page_title'] = $this->lang->line('dsp_date_report');

		$data['breadcrumb'] = '';
		
		#$network_account_id	=	get_session('network_account_id');
		#$network_id			=	get_session('account_id');
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
		$data['exchange_id']	=	$exchange_id;
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/dsp_date_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: dsp_details
	 * @param : null
	 * @return : list all dsp under date statistics .
	 */	

	public function dsp_details($exchange_id=false,$date=false)
	{	
		$data['page_title'] = $this->lang->line('dsp_detail_report');

		$data['breadcrumb'] = '';
		
		#$network_account_id	=	get_session('network_account_id');
		#$network_id			=	get_session('account_id');
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
		
		$data['exchange_id']	=	$exchange_id;
		$data['date']			=	$date;
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/dsp_detail_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: ssp
	 * @param : null
	 * @return : list all ssp statistics .
	 */	

	public function ssp()
	{	
		$data['page_title'] = $this->lang->line('ssp_report');

		$data['breadcrumb'] = '';
		
		#$network_account_id	=	get_session('network_account_id');
		#$network_id			=	get_session('account_id');
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
	
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_SSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/ssp_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: ssp_details
	 * @param : null
	 * @return : list all ssp under date statistics .
	 */	

	public function ssp_details($exchange_id=false)
	{	
		$data['page_title'] = $this->lang->line('ssp_detail_report');

		$data['breadcrumb'] = '';
		
		#$network_account_id	=	get_session('network_account_id');
		#$network_id			=	get_session('account_id');
		$data['pub_data'] =	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
		
		$data['exchange_id']		=	$exchange_id;
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_SSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/ssp_detail_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_dsp_stats($from_date=FALSE,$to_date=FALSE)
	{
	
			
		$api_key 		= 	get_session('api_key');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADMIN']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$input = array(
						'api_key'		=>	$api_key						
					  );
		
		/*if($env != 'all'){
			$input['environment'] 		= 	$env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] 	= 	$pub_id;
		}*/
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}	
		else
		{
			$input['date_to'] = $date['to_date'];
		}			
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 	= 	$_REQUEST['iDisplayLength'];
		}	
		
		$input['order']	=	array(
							'field'	=>	$_REQUEST['mDataProp_' . ($_REQUEST['iSortCol_0'] ? $_REQUEST['iSortCol_0'] : 0 )],
							'order'	=>	$_REQUEST['sSortDir_0']
							);	  
		
		$input['datatable_obj'] = 	$_REQUEST;
		$input['result_type'] 	= 	'DATA';
		//print_r($input);exit;
		$data	= 	$this->rest->post('api/v1/report/fetch_dsp',$input,'json');
		//$data	= 	$this->rest->post('api/v1/report/fetch',$input,'json');

		//$this->rest->debug();
	
	echo $data;
	}
	public function fetch_dsp_date_stats($exchange_id=false,$from_date=FALSE,$to_date=FALSE)
	{		
		$api_key 		= 	get_session('api_key');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADMIN']['REPORT_DSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$input = array(
						'api_key'		=>	$api_key,
						'exchange_id'	=>	$exchange_id						
					  );
		
		/*if($env != 'all'){
			$input['environment'] 		= 	$env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] 	= 	$pub_id;
		}*/
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}	
		else
		{
			$input['date_to'] = $date['to_date'];
		}			
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 	= 	$_REQUEST['iDisplayLength'];
		}	
		
		$input['order']	=	array(
							'field'	=>	$_REQUEST['mDataProp_' . ($_REQUEST['iSortCol_0'] ? $_REQUEST['iSortCol_0'] : 0 )],
							'order'	=>	$_REQUEST['sSortDir_0']
							);	  
		
		$input['datatable_obj'] = 	$_REQUEST;
		$input['result_type'] 	= 	'DATA';
		
		$data	= 	$this->rest->post('api/v1/report/fetch_dsp_date',$input,'json');
		//$data	= 	$this->rest->post('api/v1/report/fetch',$input,'json');

		//$this->rest->debug();

		echo $data;
	}
	
	public function fetch_dsp_detail_stats($exchange_id=false,$date=FALSE)
	{		
		$api_key 		= 	get_session('api_key');
		
		$input = array(
						'api_key'		=>	$api_key,
						'exchange_id'	=>	$exchange_id,
						'date'			=>	$date						
					  );		
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 	= 	$_REQUEST['iDisplayLength'];
		}		  
		
		$input['order']	=	array(
							'field'	=>	$_REQUEST['mDataProp_' . ($_REQUEST['iSortCol_0'] ? $_REQUEST['iSortCol_0'] : 0 )],
							'order'	=>	$_REQUEST['sSortDir_0']
							);	  
							
		$input['datatable_obj'] = 	$_REQUEST;
		$input['result_type'] 	= 	'DATA';
		
		//$data	=	$this->rest->get('api/v1/report/fetch_dsp_detail',$input,'json');				  
		$data	= 	$this->rest->post('api/v1/report/fetch_dsp_detail',$input,'json');

		//$this->rest->debug();

		echo $data;
	}
	
	public function fetch_ssp_stats($from_date=FALSE,$to_date=FALSE)
	{		
		$api_key 		= 	get_session('api_key');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADMIN']['REPORT_SSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$input = array(
						'api_key'		=>	$api_key						
					  );
		
		/*if($env != 'all'){
			$input['environment'] 		= 	$env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] 	= 	$pub_id;
		}*/
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}	
		else
		{
			$input['date_to'] = $date['to_date'];
		}			
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 	= 	$_REQUEST['iDisplayLength'];
		}	
		
		$input['order']	=	array(
							'field'	=>	$_REQUEST['mDataProp_' . ($_REQUEST['iSortCol_0'] ? $_REQUEST['iSortCol_0'] : 0 )],
							'order'	=>	$_REQUEST['sSortDir_0']
							);	  
		
		$input['datatable_obj'] = 	$_REQUEST;
		$input['result_type'] 	= 	'DATA';
		
		$data	= 	$this->rest->post('api/v1/report/fetch_ssp',$input,'json');
		//$data	= 	$this->rest->post('api/v1/report/fetch',$input,'json');

		//$this->rest->debug();

		echo $data;
	}
	
	public function fetch_ssp_detail_stats($exchange_id=FALSE,$from_date=FALSE,$to_date=FALSE)
	{		
		$api_key 		= 	get_session('api_key');
		
		$set 			=	$this->config->item('report_config');
		$date			= 	get_search_date($set['ADMIN']['REPORT_SSP']['TABLE']['DEFAULT_INTERVAL']);
		
		$input = array(
						'api_key'		=>	$api_key,
						'exchange_id'	=>	$exchange_id						
					  );		
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}
		else
		{
			$input['date_from'] = $date['from_date'];
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= $to_date;
		}	
		else
		{
			$input['date_to'] = $date['to_date'];
		}	
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 	= 	$_REQUEST['iDisplayLength'];
		}		  
		
		$input['order']	=	array(
							'field'	=>	$_REQUEST['mDataProp_' . ($_REQUEST['iSortCol_0'] ? $_REQUEST['iSortCol_0'] : 0 )],
							'order'	=>	$_REQUEST['sSortDir_0']
							);	  
							
		$input['datatable_obj'] = 	$_REQUEST;
		$input['result_type'] 	= 	'DATA';
		
		//$data	=	$this->rest->get('api/v1/report/fetch_dsp_detail',$input,'json');				  
		$data	= 	$this->rest->post('api/v1/report/fetch_ssp_detail',$input,'json');

		//$this->rest->debug();

		echo $data;
	}
	public function generate_zip($type=FALSE)
	{	
		
		$time	=	time();	
		
		$rep_name	=	'report_'.$time;
		
		if($type!=FALSE && $type=='adv')
		{
			$sdata		=	$this->fetch_advertiser_stats('php');
			$rname		=	"Advert_Report_".$time;
		}
		elseif($type!=FALSE && $type=='pub')
		{
			$sdata		=	$this->fetch_publisher_stats('php');
			$rname		=	"Publisher_Report_".$time;
		}
		else
		{
			$sdata		=	$this->fetch_platform_stats('php');
			$rname		=	"Platform_Report_".$time;
			
		}
		//print_r($sdata);exit;
		$interval	= 	clean_data($this->input->post('interval'));
		
		$from_date	= 	date('d/m/Y',strtotime(clean_data($this->input->post('from_date'))));
		$to_date	= 	date('d/m/Y',strtotime(clean_data($this->input->post('to_date'))));		
		
		$met		= 	clean_data($this->input->post('metrics'));
		$mcol		= 	clean_data($this->input->post('m_col'));
		
		$dim		= 	clean_data($this->input->post('dimensions'));
		$dcol		= 	clean_data($this->input->post('d_col'));
		$dname		= 	clean_data($this->input->post('d_name'));
		
		$metrics 	= 	($met)?((is_array($met))?$met:explode(',',$met)):'';
		$m_col 		= 	($mcol)?((is_array($mcol))?$mcol:explode(',',$mcol)):'';	
		$dimens		= 	($dim)?((is_array($dim))?$dim:explode(',',$dim)):'';			
		$d_col		= 	($dcol)?((is_array($dcol))?$dcol:explode(',',$dcol)):'';
		$d_name 	= 	($dname)?((is_array($dname))?$dname:explode(',',$dname)):'';	
		//print_r($from_date);
		
		if(!empty($sdata))
		{
			
			$objPHPExcel = new PHPExcel();
			
			$workSheet	=	 $objPHPExcel->getActiveSheet();			
			
			$objPHPExcel->getProperties()->setCreator("Administrator");
			$objPHPExcel->getProperties()->setLastModifiedBy("Administrator");
			$objPHPExcel->getProperties()->setTitle();			
			
			// Set password for readonly data
			$objPHPExcel->getActiveSheet()->getProtection()->setSheet(true);
			$objPHPExcel->getActiveSheet()->getProtection()->setPassword("password");

			//Default Style Settings For Excel Sheet
			$workSheet->getDefaultStyle()->getFont()->setName('Calibric')->setSize(10);
			$workSheet->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);		
			$workSheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);										

			// Set column width
			
			//Set the dimensions for the Table Title Attributes
			$i='A';
			
			$workSheet->getColumnDimension('B')->setWidth(20);
			
			if($interval!='CUMULATIVE'):				
				if($interval=='HOUR'):	
					if($i=='B')
					{
						$workSheet->getColumnDimension($i)->setWidth(20);
					}
					else
					{
						$workSheet->getColumnDimension($i)->setAutoSize(true);
					}
					
					$i++;
					if($i=='B')
					{
						$workSheet->getColumnDimension($i)->setWidth(20);
					}
					else
					{
						$workSheet->getColumnDimension($i)->setAutoSize(true);
					}
				else:				
					if($i=='B')
					{
						$workSheet->getColumnDimension($i)->setWidth(20);
					}
					else
					{
						$workSheet->getColumnDimension($i)->setAutoSize(true);
					}
				endif;
				$i++;
			endif;
			
			if(!empty($dimens)):
				foreach($dimens as $d):					
					if($i=='B')
					{
						$workSheet->getColumnDimension($i)->setWidth(20);
					}
					else
					{
						$workSheet->getColumnDimension($i)->setAutoSize(true);
					}	
					$i++;				
				endforeach;	
			endif;
			
			if(!empty($metrics)):
				foreach($metrics as $m):
					if($i=='B')
					{
						$workSheet->getColumnDimension($i)->setWidth(20);
					}
					else
					{
						$workSheet->getColumnDimension($i)->setAutoSize(true);
					}
					$i++;				
				endforeach;	
			endif;
			
			//Set the Row dimensions for Each Row 			
			$workSheet->getRowDimension(6)->setRowHeight(20);
			
			// Decalaration of Style in an Array 		
			
			$titleArray	=	array(
									'font'=>array(
												'bold'	=>	true,
												'size'	=> 	10,
												'name'  => 'Calibric'
											),
									'alignment' =>array(
										'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
									)	
								);
			$contentArray	=	array(
									'font'=>array(
												'bold'	=>	false,
												'size'	=> 	10,
												'name'  => 'Calibric'
											),
									'alignment' =>array(
										'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
									)	
								);	
								
			$dimensArray	=	array(
									'font'=>array(
												'bold'	=>	false,
												'size'	=> 	10,
												'name'  => 'Calibric'
											),
									'alignment' =>array(
										'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
									)	
								);		
									
			$metricsArray	=	array(
									'font'=>array(
												'bold'	=>	false,
												'size'	=> 	10,
												'name'  => 'Calibric'
											),
									'alignment' =>array(
										'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_CENTER
									)	
								);	
				
						
			// Add some data
			//echo date('H:i:s') . " Add some data\n";
			$objPHPExcel->setActiveSheetIndex(0);
			
			//Set the Title and Start Date ,End Date Details 
			$objPHPExcel->getActiveSheet()->SetCellValue('A1', "Report Name");
			$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($titleArray);
			$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Platform Report - '.$from_date.' to '.$to_date);
			$objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($contentArray);
			
			$objPHPExcel->getActiveSheet()->SetCellValue('A2', "Report ID");
			$objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($titleArray);
			$objPHPExcel->getActiveSheet()->SetCellValue('B2', $time);
			$objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($contentArray);
			
			$objPHPExcel->getActiveSheet()->SetCellValue('A3', "From Date");
			$objPHPExcel->getActiveSheet()->getStyle('A3')->applyFromArray($titleArray);
			$objPHPExcel->getActiveSheet()->SetCellValue('B3', $from_date);	
			$objPHPExcel->getActiveSheet()->getStyle('B3')->applyFromArray($contentArray);			
					
			$objPHPExcel->getActiveSheet()->SetCellValue('A4', "To Date");
			$objPHPExcel->getActiveSheet()->getStyle('A4')->applyFromArray($titleArray);
			$objPHPExcel->getActiveSheet()->SetCellValue('B4', $to_date);
			$objPHPExcel->getActiveSheet()->getStyle('B4')->applyFromArray($contentArray);
			
			$workSheet->getStyle(6)->applyFromArray($titleArray);
			
			$j='A';
			if($interval!='CUMULATIVE'):
				if($interval=='HOUR'):
					$workSheet->SetCellValue($j.'6',"Date");
					$j++;
					$workSheet->SetCellValue($j.'6',"Hour");	
				else:
					$workSheet->SetCellValue($j.'6',ucfirst(strtolower($interval)));	
				endif;
				$j++;
			endif;
			
			if(!empty($d_name)):
				foreach($d_name as $d):
					$workSheet->SetCellValue($j.'6',ucfirst($d));
					$j++;
				endforeach;	
			endif;
			
			if(!empty($m_col)):
				foreach($m_col as $m):
					$workSheet->SetCellValue($j.'6',ucfirst($m));
					$j++;
				endforeach;	
			endif;
						
			$col		=	0;
			$row		=	7;
			
			$k=0;
			
			foreach($sdata as $stat_data):
			
				$cv=0;
				if($interval!='CUMULATIVE'):
					if($interval=='HOUR'):
						$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->DATE);	
						$cv++;
						$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->HOUR);
					else:
						$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->$interval);	
					endif;
					$cv++;
				endif;
			
				if(!empty($d_col)):
					foreach($d_col as $dc):
					
						$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->$dc);
						$cv++;
					endforeach;	
				endif;
				
				if(!empty($metrics)):
					foreach($metrics as $m):
						if($m=='FILL_RATE')
						{
							$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->$m.'%');
						}
						else
						{
							$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->$m);
						}					
						
						$cv++;
					endforeach;	
				endif;
				
				
				$row++;	
			endforeach;			
			
			$filename	=		$rep_name.'.xls';
			
			//********* TO DOWNLOAD THE EXCEL FILE********
			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="'.$filename.'"');
			
			$objWriter = new PHPExcel_Writer_Excel5($objPHPExcel);		
			//$objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);		
			
			$objWriter->save($this->config->item('csv_report').$filename);
			
			if($row>1000)
			{
				// Download the file to your desktop. Name it "my_backup.zip"
				$this->zip->read_file($this->config->item('csv_report').$filename);			
				$this->zip->download($rep_name.'.zip');
			}
			else
			{
				$objWriter->save('php://output');
			}
		}
		else
		{
			return false;
		}	
	}
	
	/*
	 * 
	 * name		:request
	 * @param   :Null
	 * @return  :List all the  request by admin
	 * 			 
	 */	
	 	
	public function request()
	{
		$data['page_title'] =	"Request Report";
		$data['breadcrumb'] = 	'';
		
		// GET ALL SITES FOR PUBLISHER 
		$api_key			=	get_session('api_key');
		
		/* Advertiser Filter */
		$data['adv_data'] 		=	$this->rest->get('api/v1/report/fetch_advertiser',array('api_key'=>$api_key),'php');
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>$api_key),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>$api_key),'php');
	
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>$api_key),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>$api_key),'php');
		
		/* Publisher Filter */
		$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$api_key),'php');
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		
		//$data['download'] 	= 	$this->rest->get('api/v1/report/download_report',array('api_key'=>$api_key),'json');
	//	print_r($data['download']);exit;
		// GET DEFAULT PERIOD FROM CONFIG FILE		
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['ADMIN']['REPORT_ADVERTISER']['TABLE']['DEFAULT_INTERVAL']);
		
		//$this->rest->debug();
		//exit;
		$data['content'] 	= 	$this->load->view('report/request',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	* Lists the requests
	* 
	* name		:fetch_request
	* @param   :Null
	* @return  :returns the JSON Object for datatable
	*  			 
	*/	
	
	public function fetch_request()
	{
		$api_key	= 	get_session('api_key');
		$request	= 	$this->rest->get('api/v1/report/fetch_request',array("api_key"=>$api_key),'json');

		echo convert_to_datatable_format($request);
	}

	public function download_request()
	{ 
		//$res		=	$this->input->post('last_request');
	//	$date_from		=	$this->input->post('date_from');
	//	$date_to		=	$this->input->post('date_to');
	
		$api_key 	= 	get_session('api_key');
		
		$res 		= 	$this->rest->get('api/v1/report/download_report',array('api_key'=>$api_key),'json');

		if($res)
		{
			$stat	=	json_decode($res);
			
			$time		=	time();	
			$rep_name	=	'report_'.$time;
			
			$request	=	$stat->request;
			$post_data	=	$stat->search;
			$rep_data	=	$stat->data;
			
			$date_from	= 	date('d/m/Y',strtotime($post_data->date_from));
			//$date_from	= 	$date_from;
			$date_to	= 	date('d/m/Y',strtotime($post_data->date_to));
		//	$date_to	= 	$date_to;
		
			$search['frequency']	=	($post_data->frequency)?$post_data->frequency:'';
			$search['type']			=	($post_data->type)?$post_data->type:'';
			$search['format']		=	($post_data->format)?$post_data->format:'';
		
			$search['device']		= 	($post_data->device)?$post_data->device:'';	
			$search['display_by']	= 	($post_data->display_by)?$post_data->display_by:'';
			
			$search['advertiser']	= 	($post_data->advertiser)?$post_data->advertiser:'';
			$search['campaign']		= 	($post_data->campaign)?$post_data->campaign:'';
			$search['creative']		= 	($post_data->creative)?$post_data->creative:'';
			$search['publisher']	= 	($post_data->publisher)?$post_data->publisher:'';
			$search['site']			= 	($post_data->site)?$post_data->site:'';
			$search['zone']			= 	($post_data->zone)?$post_data->zone:'';
			$search['country']		= 	($post_data->country)?$post_data->country:'';
			$search['rtype']		= 	($post_data->rtype)?$post_data->rtype:'';
			$search['adsize']		= 	($post_data->adsize)?$post_data->adsize:'';
			
			$search['columns'] 		= 	($post_data->columns)?$post_data->columns:'';				
			$search['group_by']		= 	($post_data->group_by)?$post_data->group_by:'';
			
			$interval		=	$search['display_by'];
			$metrics		= 	($search['columns'])?((is_array($search['columns']))?$search['columns']:explode(',',$search['columns'])):'';			
			
			$dimens			= 	($search['group_by'])?((is_array($search['group_by']))?$search['group_by']:explode(',',$search['group_by'])):'';			
			
			$d_col			=	array('ADV_ID'=>'CLIENT_NAME','CAM_ID'=>'CAM_NAME','BAN_ID'=>'BAN_NAME','AFF_ID'=>'AFF_NAME','SITE_ID'=>'SITE_NAME','ZONE_ID'=>'ZONE_NAME','ADSIZE'=>'ADSIZE','RTYPE'=>'RTYPE','COUNTRY'=>'COUNTRY');					
			
			$d_name			=	array('ADV_ID'=>'advertiser','CAM_ID'=>'campaign','BAN_ID'=>'creative','AFF_ID'=>'publisher','SITE_ID'=>'site','ZONE_ID'=>'zone','ADSIZE'=>'adSize','RTYPE'=>'type','COUNTRY'=>'country');					
			
			$time		=	time();	
			$rep_name	=	'report_'.$time;		
			
			//~ if($rep_data)
			//~ {
				$objPHPExcel= 	new PHPExcel();
				$workSheet	=	$objPHPExcel->getActiveSheet();			
				
				$objPHPExcel->getProperties()->setCreator("Administrator");
				$objPHPExcel->getProperties()->setLastModifiedBy("Administrator");
				$objPHPExcel->getProperties()->setTitle();				

				//Default Style Settings For Excel Sheet
				$workSheet->getDefaultStyle()->getFont()->setName('Calibric')->setSize(10);
				$workSheet->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);		
				$workSheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);										

				// Set column width
				
				//Set the dimensions for the Table Title Attributes
				$i='A';
			
				$workSheet->getColumnDimension('B')->setWidth(20);
				
				if($interval!='CUMULATIVE'):				
					if($interval=='HOUR'):	
						if($i=='B')
						{
							$workSheet->getColumnDimension($i)->setWidth(20);
						}
						else
						{
							$workSheet->getColumnDimension($i)->setAutoSize(true);
						}
						
						$i++;
						if($i=='B')
						{
							$workSheet->getColumnDimension($i)->setWidth(20);
						}
						else
						{
							$workSheet->getColumnDimension($i)->setAutoSize(true);
						}
					else:				
						if($i=='B')
						{
							$workSheet->getColumnDimension($i)->setWidth(20);
						}
						else
						{
							$workSheet->getColumnDimension($i)->setAutoSize(true);
						}
					endif;
					$i++;
				endif;
				 
				if(!empty($dimens)):
					foreach($dimens as $d):	
						if($interval=='HOUR')
						{
							if($d!='DATE')
							{
								if($i=='B')
								{
									$workSheet->getColumnDimension($i)->setWidth(20);
								}
								else
								{
									$workSheet->getColumnDimension($i)->setAutoSize(true);
								}	
							}
						}
						else
						{
							if($i=='B')
							{
								$workSheet->getColumnDimension($i)->setWidth(20);
							}
							else
							{
								$workSheet->getColumnDimension($i)->setAutoSize(true);
							}	
						}
						$i++;				
					endforeach;	
				endif;
				
				if(!empty($metrics)):
					foreach($metrics as $m):
						if($i=='B')
						{
							$workSheet->getColumnDimension($i)->setWidth(20);
						}
						else
						{
							$workSheet->getColumnDimension($i)->setAutoSize(true);
						}
						$i++;				
					endforeach;	
				endif;
			
				//Set the Row dimensions for Each Row 			
				$workSheet->getRowDimension(6)->setRowHeight(20);
				
				// Decalaration of Style in an Array 		
				
				$titleArray	=	array(
										'font'=>array(
													'bold'	=>	true,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);
				$contentArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);	
									
				$dimensArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);		
										
				$metricsArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_CENTER
										)	
									);				
							
				// Add some data
				//echo date('H:i:s') . " Add some data\n";
				$objPHPExcel->setActiveSheetIndex(0);
				
				//Set the Title and Start Date ,End Date Details 
				$objPHPExcel->getActiveSheet()->SetCellValue('A1', "Report Name");
				$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($titleArray);
				$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Report - '.$date_from.' to '.$date_to);
				$objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($contentArray);
				
				$objPHPExcel->getActiveSheet()->SetCellValue('A2', "Report ID");
				$objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($titleArray);
				$objPHPExcel->getActiveSheet()->SetCellValue('B2', $time);
				$objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($contentArray);
				
				$objPHPExcel->getActiveSheet()->SetCellValue('A3', "From Date");
				$objPHPExcel->getActiveSheet()->getStyle('A3')->applyFromArray($titleArray);
				$objPHPExcel->getActiveSheet()->SetCellValue('B3', $date_from);	
				$objPHPExcel->getActiveSheet()->getStyle('B3')->applyFromArray($contentArray);			
						
				$objPHPExcel->getActiveSheet()->SetCellValue('A4', "To Date");
				$objPHPExcel->getActiveSheet()->getStyle('A4')->applyFromArray($titleArray);
				$objPHPExcel->getActiveSheet()->SetCellValue('B4', $date_to);
				$objPHPExcel->getActiveSheet()->getStyle('B4')->applyFromArray($contentArray);
				
				$workSheet->getStyle(6)->applyFromArray($titleArray);
				$j='A';
				if($interval!='CUMULATIVE'):
					if($interval=='HOUR'):
						$workSheet->SetCellValue($j.'6',"Date");
						$j++;
						$workSheet->SetCellValue($j.'6',"Hour");	
					else:
						$workSheet->SetCellValue($j.'6',ucfirst(strtolower($interval)));	
					endif;
					$j++;
				endif;
				
				if(!empty($dimens)):
					foreach($dimens as $d):
						$workSheet->SetCellValue($j.'6',ucfirst($d_name[$d]));
						$j++;
					endforeach;	
				endif;
				
				if(!empty($metrics)):
					foreach($metrics as $m):
						$workSheet->SetCellValue($j.'6',ucfirst($m));
						$j++;
					endforeach;	
				endif;
			
				$workSheet->getStyle('A6:H6')->applyFromArray($titleArray);
				
				$col		=	0;
				$row		=	7;
				
				$k=0;
				
				foreach($rep_data as $stat_data):
					$cv=0;
					if($interval!='CUMULATIVE'):
						if($interval=='HOUR'):
							$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->DATE);	
							$cv++;
							$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->HOUR);
						else:
							$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->$interval);	
						endif;
						$cv++;
					endif;
				
					if(!empty($dimens)):
						foreach($dimens as $dc):
							$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->$d_col[$dc]);
							$cv++;
						endforeach;	
					endif;
					
					if(!empty($metrics)):
						foreach($metrics as $m):
							if($m=='FILL_RATE')
							{
								$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->$m.'%');
							}
							else
							{
								$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->$m);
							}					
							
							$cv++;
						endforeach;	
					endif;
					
					$row++;	
				endforeach;			
			
				if($post_data->format=='xls'):
					$filename	=		$rep_name.'.xls';
					//********* TO DOWNLOAD THE EXCEL FILE********
					header('Content-Type: application/vnd.ms-excel');
					header('Content-Disposition: attachment;filename="'.$filename.'"');
					ob_clean();
					
				$objWriter = new PHPExcel_Writer_Excel5($objPHPExcel);	
				
				$objWriter->save('php://output');
				
				elseif($post_data->format=='csv'):
					
					$filename=$rep_name.'.csv';
					header('Content-type: text/csv');
					header('Content-Disposition: attachment; filename='.$filename);
                    ob_clean();
				$csv = "REQUEST,IMP,CLK,CON,SPEND,PUB_EARN,ADM_EARN,CTR,ECPM,ERPM,EPPM,FILL_RATE\n";
				
				for($i=0;$i<count($rep_data);$i++)
				{
					
				$csv.=$rep_data[$i]->REQUEST.','.$rep_data[$i]->IMP.','.$rep_data[$i]->CLK.','.$rep_data[$i]->CON.','.$rep_data[$i]->SPEND.','.$rep_data[$i]->PUB_EARN.','.$rep_data[$i]->ADM_EARN.','.$rep_data[$i]->CTR.','.$rep_data[$i]->ECPM.','.$rep_data[$i]->ERPM.','.$rep_data[$i]->EPPM.','.$rep_data[$i]->FILL_RATE."\n";
				
				}
				print_r($csv); 
				
				else:
				$listed_txt = array ();
				$delimiter = "\t";
				$filename=$rep_name.'.txt';
				header('Content-type: text/tab-separated-values');
				header("Content-Disposition: attachment;filename=".$filename);	
				ob_clean();
				$txt = "REQUEST,IMP,CLK,CON,SPEND,PUB_EARN,ADM_EARN,CTR,ECPM,ERPM,EPPM,FILL_RATE\n";
				
				for($i=0;$i<count($rep_data);$i++)
				{
					
				$txt.=$rep_data[$i]->REQUEST.','.$rep_data[$i]->IMP.','.$rep_data[$i]->CLK.','.$rep_data[$i]->CON.','.$rep_data[$i]->SPEND.','.$rep_data[$i]->PUB_EARN.','.$rep_data[$i]->ADM_EARN.','.$rep_data[$i]->CTR.','.$rep_data[$i]->ECPM.','.$rep_data[$i]->ERPM.','.$rep_data[$i]->EPPM.','.$rep_data[$i]->FILL_RATE."\n";
				
				}
				print_r($txt); 	
				endif;
				//~ 
			//~ }
			//~ else
			//~ {
				//~ echo 'No records';
			//~ }
		}
		else
		{
			echo 'error';
		}		
	}
	
	public function fetch_admin_filter_stats($type=false,$format='json')   
	{
		$interval	= 	clean_data($this->input->post('interval'));
		$environment= 	clean_data($this->input->post('device'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$from_date	= 	date("Y-m-d", strtotime($from_date));
		$to_date	= 	clean_data($this->input->post('to_date'));
		
		$metrics	= 	clean_data($this->input->post('metrics'));
		
		$adv_id		= 	clean_data($this->input->post('advertiser'));
		$cam_id		=  	clean_data($this->input->post('campaign'));
		$cre_id		= 	clean_data($this->input->post('creative'));
		$pub_id		= 	clean_data($this->input->post('publisher'));
		$sit_id		= 	clean_data($this->input->post('site'));
		$adb_id		= 	clean_data($this->input->post('adblock'));
		$country	= 	clean_data($this->input->post('country'));
		$adsize		= 	clean_data($this->input->post('adsize'));
		$camtyp 	= 	clean_data($this->input->post('revtype'));		
		
		$dimens		= 	clean_data($this->input->post('dimensions'));

		$api_key 	= 	get_session('api_key');
		
		if($type!=false && $type=='COUNTRY')
		{
			$page		=	'REPORT_GEO_GRAPHICAL';
		}
		elseif($type!=false && $type=='ENVIRONMENT')
		{
			$page		=	'REPORT_ENVIRONMENT';
		}
		elseif($type!=false && $type=='URL')
		{
			$page		=	'REPORT_URL';
		}
		elseif($type!=false && $type=='VIDEO')
		{
			$page		=	'REPORT_VIDEO';
		}
		else
		{
			$page		= 	'REPORT_CAMPAIGN';
		}
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'interval'		=>	$interval,
						'environment'	=>	$environment					
					  );		
		
		$input['display_type'] 	= 	'TABLE';
			
		if($adv_id != 'all'){
			$input['adv_account_id'] = ($adv_id)?((is_array($adv_id))?$adv_id:explode(',',$adv_id)):'';	
		}
		
		if($cam_id != 'all'){
			$input['campaign_id'] = ($cam_id)?((is_array($cam_id))?$cam_id:explode(',',$cam_id)):'';
		}
		
		if($cre_id != 'all'){
			$input['creative_id'] = ($cre_id)?((is_array($cre_id))?$cre_id:explode(',',$cre_id)):'';
		}
		
		if($pub_id != 'all'){
			$input['pub_account_id'] = ($pub_id)?((is_array($pub_id))?$pub_id:explode(',',$pub_id)):'';
		}
		
		if($sit_id != 'all'){
			$input['site_id'] = ($sit_id)?((is_array($sit_id))?$sit_id:explode(',',$sit_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}
				
		if($country != 'all'){
			$input['country'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
		
		if($camtyp != 'all'){
			$input['camtyp'] = ($camtyp)?((is_array($camtyp))?$camtyp:explode(',',$camtyp)):'';
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		$input['metrics'] 	= 	($metrics)?((is_array($metrics))?$metrics:explode(',',$metrics)):'';	
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		if($interval!='CUMULATIVE')
		{
			if(!empty($input['dimensions']))
			{
			 	array_unshift($input['dimensions'],$interval);
			}
			else
			{
				$input['dimensions']	=	array($interval);
			}			
		}		
		
		if(!empty($input['dimensions']) && is_array($input['dimensions']))
		{			
			$input['columns']	=	array_merge($input['metrics'],$input['dimensions']);   
		}
		else
		{
			$input['columns']	=	$input['metrics'];
		}
		
		if($format!='php')
		{
			$input['stat_type']		=	($type!=false)?$type:'PLATFORM';
			
			$input['search_term']	=	$_REQUEST['sSearch'];
			
			if(isset($_REQUEST['iDisplayStart'])){
				$input['start'] = $_REQUEST['iDisplayStart'];
			}
			
			if(isset($_REQUEST['iDisplayLength'])){
				$input['end'] = ($_REQUEST['iDisplayLength']!='-1')?$_REQUEST['iDisplayLength']:'';
			}
			
			$input['datatable_obj'] = $_REQUEST;		
		
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
			
			//echo $this->rest->debug();exit;
		
			echo $data;
		}
		else
		{
			$input['stat_type']		=	'EXPORT';
			$input['search_term']	=	'';
			
			$input['datatable_obj']['sSearch'] = '';
			$input['datatable_obj']['sEcho'] = '';
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/fetch',$input,'json');	
			//$this->rest->debug();
			
			return json_decode($data);
		}
	}

	/*
	* 
	* name		:network
	* @param   :Null
	* @return  :Network page
	*/	
	 
	function network()
	{		
		$data['page_title'] = 	"Network Kit";

		$data['breadcrumb'] = 	'';
		
		$data['api_key']			=	get_session('api_key');
		
		/* Additional Filter */
		$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>get_session('api_key')),'php');
		
		$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>get_session('api_key')),'php');
		
		$data['browsers']		= 	$this->rest->get('api/v1/targeting/fetch_browsers',array('api_key'=>get_session('api_key')),'php');
		
		$data['os']				= 	$this->rest->get('api/v1/targeting/fetch_os',array('api_key'=>get_session('api_key')),'php');
			
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		$set = $this->config->item('report_config');
				
		$data['search_date'] 	= 	get_search_date($set['ADMIN']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'	=>	$data['api_key']),'php');
						
		$data['content'] 		= 	$this->load->view('report/network',$data,TRUE);
				
		$this->template->set_layout('admin_layout');
		
		$this->template->build('view', $data);
	}
	
	public function fetch_network_stat($format='json',$c,$from_date,$to_date)
	{
		
		$api_key		=	get_session('api_key');		
		
		$account_type 	= 	get_session('account_type');
		$page			= 	'REPORT_GEO_GRAPHICAL';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type,
						'stat_type'		=>	'NETWORK',
					  );
					  
		$env 		= 	$this->input->post('env');
		
		$country 	= 	$this->input->post('country');
		$adsize		= 	clean_data($this->input->post('adsize'));
		$camtyp 	= 	clean_data($this->input->post('revtype'));
		$pub_id		= 	clean_data($this->input->post('publisher'));
		$adb_id		= 	clean_data($this->input->post('adblock'));
		$brow		= 	clean_data($this->input->post('browser'));
		$os			= 	clean_data($this->input->post('os'));		
		
		if($from_date == NULL){
		  $from_date = $this->input->post('from_date');
		}
		if($to_date == NULL){
			$to_date = $this->input->post('to_date');
		}
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($country != 'all'){
			$input['country_id'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
		
		if($camtyp != 'all'){
			$input['camtyp'] = ($camtyp)?((is_array($camtyp))?$camtyp:explode(',',$camtyp)):'';
		}
		
		if($pub_id != 'all'){
			$input['pub_account_id'] = ($pub_id)?((is_array($pub_id))?$pub_id:explode(',',$pub_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}
		
		if($brow != 'all'){
			$input['browser'] = ($brow)?((is_array($brow))?$brow:explode(',',$brow)):'';
		}
		
		if($os != 'all'){
			$input['os'] = ($os)?((is_array($os))?$os:explode(',',$os)):'';
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
					  
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
			
		$data	= 	$this->rest->post('api/v1/report/fetch',$input,'json');
		
		//$this->rest->debug();
		
		echo $data;
	
	}
	
	
	public function adv_detail_list($account_id=FALSE,$field_name=FALSE)
	{
		$data['page_title'] 	= 	"Advertiser reports";

		$data['breadcrumb'] 	= 	'';
		
		$data['account_id'] 	= 	$account_id;
		$data['field_name'] 	=   $field_name;
		$api_key				=	get_session('api_key');

		/* Advertiser Filter */
		$data['adv_data'] 		=	$this->rest->get('api/v1/report/fetch_advertiser',array('api_key'=>get_session('api_key')),'php');
		
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>get_session('api_key')),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>get_session('api_key')),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADMIN']['REPORT_ADVERTISER']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] 		= 	$this->load->view('report/adv_detail_list',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}	
	
	
	public function fetch_advertiser_detail_stats($account_id=FALSE,$field_name=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_ADVERTISER';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		if(!empty($_POST['advertiser']) && $_POST['advertiser'] != 'all')
		{
			$input['account_id'] 	= 	$_POST['advertiser'];
		}
		else			  
		{
			$input['account_id'] 	= 	$account_id;
		}
		$input['field_name'] 	=   $field_name;						
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($adv_id != 'all'){
			$input['adv_account_id'] = $adv_id;
		}
		
		if($_POST['campaign'] != 'all'){
			$input['cam_id'] = $_POST['campaign'];
		}
		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}
		if($_POST['creative'] != 'all'){
			$input['creative_id'] = $_POST['creative'];
		}
		if($_POST['country'] != 'all'){
			$input['country'] = $_POST['country'];
		}
		if($_POST['device'] != 'all'){
			$input['device'] = $_POST['device'];
		}
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}			  
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
			
		$data			= $this->rest->post('api/v1/report/fetch_detail_admin_advertiser',$input,'json');

		//echo $this->rest->debug();exit;

		echo $data;
	}	
	
	
	
	public function advertisers_campaign_details($campaign_id=FALSE,$field_name=FALSE)
	{
		$data['page_title'] 	= 	"Campaign reports";

		$data['breadcrumb'] 	= 	'';

		$api_key				=	get_session('api_key');

		$data['campaign_id'] 	= 	($campaign_id!=FALSE)?$campaign_id:'';
		$data['field_name'] 	= 	$field_name;
		
		/* Advertiser Filter */
		$data['adv_data'] 		=	$this->rest->get('api/v1/report/fetch_advertiser',array('api_key'=>get_session('api_key')),'php');
		
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>get_session('api_key')),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>get_session('api_key')),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADMIN']['REPORT_CAMPAIGN']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] 		= 	$this->load->view('report/advertisers_campaign_details',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	public function fetch_campaign_detail_stats($cam_id=FALSE,$field_name=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_CAMPAIGN';
		$display_type	= 	'TABLE';
		
		$input = array( 'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type,
					  );
		
		$input['field_name'] 	=   $field_name;			
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if(!empty($_POST['advertiser']) && $_POST['advertiser'] != 'all')
		{
			$input['account_id'] 	= 	$_POST['advertiser'];
		}		
		
		if(!empty($_POST['campaign']) && $_POST['campaign'] != 'all')
		{
			$input['cam_id'] = $_POST['campaign'];
		}
		else			  
		{
			$input['cam_id'] 	= 	$cam_id;
		}
				
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}
		if($_POST['creative'] != 'all'){
			$input['creative_id'] = $_POST['creative'];
		}
		if($_POST['country'] != 'all'){
			$input['country'] = $_POST['country'];
		}
		if($_POST['device'] != 'all'){
			$input['device'] = $_POST['device'];
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
					 
		$data			= $this->rest->post('api/v1/report/fetch_detail_admin_advertiser',$input,'json');
	    //echo $this->rest->debug();exit;
		echo $data;
		
		//echo convert_to_datatable_format($data);
	}
	
	
	
	public function advertisers_detail_creative($creative_id=FALSE,$field_name=FALSE)
	{
		$data['page_title'] 	= 	"Creative reports";

		$data['breadcrumb'] 	= 	'';

		$api_key				=	get_session('api_key');

		$data['creative_id'] 	= 	($creative_id!=FALSE)?$creative_id:'';
		
		/* Advertiser Filter */
		$data['adv_data'] 		=	$this->rest->get('api/v1/report/fetch_advertiser',array('api_key'=>get_session('api_key')),'php');
		
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>get_session('api_key')),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>get_session('api_key')),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADMIN']['REPORT_CREATIVE']['CHART']['DEFAULT_INTERVAL']);
		
		$data['field_name'] 	=   $field_name;
		$data['content'] 		= 	$this->load->view('report/advertisers_detail_creative',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}		
	
	public function fetch_creative_detail_stats($creative_id=FALSE,$field_name=FALSE)
	{
		$api_key 	= 	get_session('api_key');
		$page		= 	'REPORT_CREATIVE';		
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'search_term'	=>	$_REQUEST['sSearch']
					  );
		
		$input['display_type'] 	= 'TABLE';
		
		if($env != 'all'){
			$input['environment'] = $env;
		}
		
		if(!empty($_POST['advertiser']) && $_POST['advertiser'] != 'all')
		{
			$input['account_id'] 	= 	$_POST['advertiser'];
		}
					
		if(!empty($_POST['campaign']) && $_POST['campaign'] != 'all')
		{		
			$input['cam_id'] = $_POST['campaign'];
		}

		if(!empty($_POST['creative']) && $_POST['creative'] != 'all')
		{
			$input['creative_id'] = $_POST['creative'];
		}		
		else
		{
			$input['creative_id'] = $creative_id;
		}
		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}

		if($_POST['country'] != 'all'){
			$input['country'] = $_POST['country'];
		}
		if($_POST['device'] != 'all'){
			$input['device'] = $_POST['device'];
		}			  
		
		// Pagination Parameters
		if(isset($_REQUEST['sEcho'])){
		
		}
		
		// GET TOTAL RECORDS
		$input['result_type'] 	= 'COUNT';
		
		//$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		//$records = json_decode($data); 
		
		
		
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		
		
		$input['field_name'] 	=   $field_name;
		$input['result_type'] 	= 'DATA';
		$data			= $this->rest->post('api/v1/report/fetch_detail_admin_advertiser',$input,'json');
		
		//echo $this->rest->debug();
		//exit;
		
		
		echo $data;
	
	}
	
	
	public function publishers_detail_reports($account_id=FALSE,$field_name=FALSE)
	{	
		$data['page_title'] = 	"Publisher reports";

		$data['breadcrumb'] = 	'';
		
		$api_key				=	get_session('api_key');
		
		/* Publisher Filter */
		$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$api_key),'php');
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>$api_key),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['ADMIN']['REPORT_PUBLISHER']['CHART']['DEFAULT_INTERVAL']);
		
		$data['account_id'] 	= $account_id;
		$data['field_name'] 	= $field_name;
		
		$data['content'] 	= 	$this->load->view('report/publishers_detail_reports',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}	
	
	
	public function fetch_publisher_detail_stats($account_id=FALSE,$field_name=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_PUBLISHER';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	

		if(!empty($_POST['publisher']) && $_POST['publisher'] != 'all')
		{		
			$input['pub_account_id'] = $_POST['publisher'];
		}
		else
		{		
			$input['pub_account_id'] = $account_id;
		}

		if(!empty($_POST['site']) && $_POST['site'] != 'all')
		{		
			$input['site_id'] = $_POST['site'];
		}	
			
		if(!empty($_POST['adblock']) && $_POST['adblock'] != 'all')
		{		
			$input['adblock_id'] = $_POST['adblock'];
		}		

		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}

		if($_POST['country'] != 'all'){
			$input['country'] = $_POST['country'];
		}
		if($_POST['device'] != 'all'){
			$input['device'] = $_POST['device'];
		}	
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}		  
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
		$input['field_name'] 	= $field_name;
					  
		$data			= $this->rest->post('api/v1/report/fetch_detail_admin_publisher',$input,'json');

		//echo $this->rest->debug();exit;

		echo $data;
	}			
			

	public function publishers_detail_site($siteid=FALSE,$field_name=FALSE,$dates=FALSE)
	{ 
		$data['page_title'] = 	"Sites report";

		$data['breadcrumb'] = 	'';
		
		$api_key			=	get_session('api_key');
		
		if(!empty($siteid))
		{
			$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key,"site_id"=>$siteid),'php');
		}
		else
		{
			// Fetch adblock list
			$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		
		}		
		/* Publisher Filter */
		$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$api_key),'php');
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
	
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>$api_key),'php');
						
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['site_id']=$siteid;
		$data['field_name']=$field_name;
		$data['dates']=$dates;
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['ADMIN']['REPORT_SITE']['CHART']['DEFAULT_INTERVAL']);		
		$data['content'] 	= 	$this->load->view('report/publishers_detail_site',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	public function fetch_sites_detail_stats($site_id=FALSE,$field_name=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_SITE';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		if(!empty($_POST['publisher']) && $_POST['publisher'] != 'all')
		{		
			$input['pub_account_id'] = $_POST['publisher'];
		}
		if(!empty($_POST['site']) && $_POST['site'] != 'all')
		{		
			$input['site_id'] = $_POST['site'];
		}		
		else
		{
			$input['site_id'] = $site_id;
		}

		if(!empty($_POST['adblock']) && $_POST['adblock'] != 'all')
		{		
			$input['adblock_id'] = $_POST['adblock'];
		}		
		else
		{
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}

		if($_POST['country'] != 'all'){
			$input['country'] = $_POST['country'];
		}
		if($_POST['device'] != 'all'){
			$input['device'] = $_POST['device'];
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['field_name'] = $field_name;
		$input['result_type'] 	= 'DATA';
				
		$data			= $this->rest->post('api/v1/report/fetch_detail_admin_publisher',$input,'json');
		
		echo $data;
	}			
	
	
	public function publishers_detail_adblock($adblock_id=FALSE,$field_name=FALSE,$dates=FALSE)
	{
		$data['page_title'] 	= 	"Ad block reports";

		$data['breadcrumb'] 	= 	'';
		
		$api_key				=	get_session('api_key');
		
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		
		// Fetch adblock list
		if(!empty($adblock_id))
		{
			$data['siteid']	= 	$this->rest->get('api/v1/report/fetch_site_adblock',array('api_key'=>$api_key,'adblock_id'=>$adblock_id),'php');
			$site_id=$data['siteid'][0]['site_id'];			
			$data['adblock']	= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key,'site_id'=>$site_id),'php');			
		}	
		else
		{
			$data['adblock']			= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		}
		/* Publisher Filter */
		$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$api_key),'php');
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		
		
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>$api_key),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE  
		$data['adblock_id']=$adblock_id;
		$data['dates']=$dates;

		
		$data['field_name']=$field_name;		
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADMIN']['REPORT_ADBLOCK']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] 		= 	$this->load->view('report/publishers_detail_adblock',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	public function fetch_adblock_detail_stats($adb_id=FALSE,$field_name=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_ADBLOCK';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	

		if(!empty($_POST['publisher']) && $_POST['publisher'] != 'all')
		{		
			$input['pub_account_id'] = $_POST['publisher'];
		}	
			
		if(!empty($_POST['site']) && $_POST['site'] != 'all')
		{		
			$input['site_id'] = $_POST['site'];
		}		

		
		if(!empty($_POST['adblock']) && $_POST['adblock'] != 'all')
		{		
			$input['adblock_id'] = $_POST['adblock'];
		}		
		else
		{
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}

		if($_POST['country'] != 'all'){
			$input['country'] = $_POST['country'];
		}
		if($_POST['device'] != 'all'){
			$input['device'] = $_POST['device'];
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		$input['field_name'] = $field_name;
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
					  
		$data			= $this->rest->post('api/v1/report/fetch_detail_admin_publisher',$input,'json');

		echo $data;
	}
	
	
	public function geo_detail_report($date='all',$field_name=FALSE,$country=FALSE)
	{
		$data['page_title'] = 	"Geographic reports";

		$data['breadcrumb'] = 	'';
		
		// GET ALL SITES FOR PUBLISHER
		$api_key			=	get_session('api_key');
		
		/* Additional Filter */
		$data['country']	=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['size']		= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		/* Publisher Filter */
		$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>get_session('api_key')),'php');
		$data['adblock']	= 	$this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>get_session('api_key')),'php');
		
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$set 				= 	$this->config->item('report_config');

		$data['date'] = $date;
		$data['field_name'] = $field_name;
		$data['countries'] = $country;
				
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);	
		$data['content'] 	= 	$this->load->view('report/geo_detail_report',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);		
	}
	
	
	public function fetch_country_detail_stat($date=FALSE,$field_name=FALSE,$country=FALSE,$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_GEO_GRAPHICAL';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'COUNTRY',
						'date'=>$date
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($_POST['country'] != FALSE){
			$input['country'] = $_POST['country'];
		}		
		else
		{
			$input['country'] 	= 	$country;
			$input['report_type'] 	= 'geo';
		}
		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}

		if($_POST['device'] != FALSE){
			$input['device'] = $_POST['device'];
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		$input['date'] = $date;
		$input['field_name'] = $field_name;
				
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
					  
	
		$data			= $this->rest->post('api/v1/report/fetch_detail_overview',$input,'json');
		
		//echo $this->rest->debug();exit;
		
		echo $data;
	}	
	
		
		
	public function environment_detail_report($env=FALSE,$field_name=FALSE)
	{
		$data['page_title'] 	= 	"Environment performance reports";

		$data['breadcrumb'] 	= 	'';
		
		$api_key 				= 	get_session('api_key');
		
		/* Advertiser Filter */
		$data['adv_data'] 		=	$this->rest->get('api/v1/report/fetch_advertiser',array('api_key'=>$api_key),'php');
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>$api_key),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>$api_key),'php');
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>$api_key),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>$api_key),'php');
		
		/* Publisher Filter */
		$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$api_key),'php');
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['env']			= $env;
		$data['field_name'] = $field_name;
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADMIN']['REPORT_ENVIRONMENT']['CHART']['DEFAULT_INTERVAL']);
		
		$data['content'] 		= 	$this->load->view('report/environment_detail_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	
	public function fetch_environment_detail_stats($env=FALSE,$field_name=FALSE,$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_ENVIRONMENT';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		

		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}

		if($_POST['country'] != 'all'){
			$input['country'] = $_POST['country'];
		}
		if($_POST['device'] != 'all'){
			$input['device'] = $_POST['device'];
		}
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}			  
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';		  
		$input['field_name'] = $field_name;			  
		$data			= $this->rest->post('api/v1/report/fetch_environment_detail',$input,'json');
		//echo $this->rest->debug();exit;
		echo $data;
	}
				
	public function platform_detail_report($date=FALSE,$field_name=FALSE)
	{
		//print_r("asas");die();
		$data['page_title'] = "Platform reports";

		$data['breadcrumb'] = '';

		$api_key	=	get_session('api_key');
		
		/* Basic */
		$data['timezone'] 		=	$this->rest->get('api/v1/report/fetch_timezone',array('api_key'=>$api_key),'php');
		
		/* Advertiser Filter */
		$data['adv_data'] 		=	$this->rest->get('api/v1/report/fetch_advertiser',array('api_key'=>$api_key),'php');
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>$api_key),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>$api_key),'php');
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>$api_key),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>$api_key),'php');
		
		/* Publisher Filter */
		$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$api_key),'php');
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		
		$data['date'] = $date;
		$data['field_name'] = $field_name;	
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 	= 	$this->config->item('report_config');
		$data['search_date'] = 	get_search_date($set['ADMIN']['PLATFORM_REPORT']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] = $this->load->view('report/platform_detail_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_admin_filter_stats_custom($type=false,$format='json')   //DAC094 20-10-2017 for  camp preview
	{//print_r($this->input->get());exit;
		$interval	= 	'CUMULATIVE';
		$environment= 	'all';
		$date = new DateTime();
		$from_date	= 	clean_data($this->input->post('from_date'));
		$from_date	= 	$date->setTimestamp($from_date)->modify('+1 day')->format('Y/m/d');
		$to_date	= 	clean_data($this->input->post('to_date'));
		$to_date	= 	$date->setTimestamp($to_date)->modify('+1 day')->format('Y/m/d');
		
		$metrics	= 	'TIME_DATE,IMP,CLK,CON,SPEND,CTR,ECPM,FILL_RATE';//clean_data($this->input->get('metrics'));

		$cam_id		=  	clean_data($this->input->post('campaign'));
		$cre_id		= 	'all';//clean_data($this->input->get('creative'));
		$country	= 	'all';//clean_data($this->input->get('country'));
		$adsize		= 	'all';//clean_data($this->input->get('adsize'));
		$camtyp 	= 	'all';//clean_data($this->input->get('revtype'));		
		
		$dimens		= 	'CAM_ID,COUNTRY,DATE';//clean_data($this->input->get('dimensions'));

		$api_key 	= 	get_session('api_key');
		
		if($type!=false && $type=='COUNTRY')
		{
			$page		=	'REPORT_GEO_GRAPHICAL';
		}
		elseif($type!=false && $type=='URL')
		{
			$page		=	'REPORT_URL';
		}
		elseif($type!=false && $type=='VIDEO')
		{
			$page		=	'REPORT_VIDEO';
		}
		else
		{
			$page		= 	'REPORT_CAMPAIGN';
		}
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'interval'		=>	$interval,
						'environment'	=>	$environment					
					  );
		
		$input['display_type'] 	= 'TABLE';
				
		if($cam_id != 'all'){
			$input['campaign_id'] = ($cam_id)?((is_array($cam_id))?$cam_id:explode(',',$cam_id)):'';
		}
		
		if($cre_id != 'all'){
			$input['creative_id'] = ($cre_id)?((is_array($cre_id))?$cre_id:explode(',',$cre_id)):'';
		}
		
		if($country != 'all'){
			$input['country'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
		
		if($camtyp != 'all'){
			$input['camtyp'] = ($camtyp)?((is_array($camtyp))?$camtyp:explode(',',$camtyp)):'';
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		$input['metrics'] 	= 	($metrics)?((is_array($metrics))?$metrics:explode(',',$metrics)):'';	
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		if($interval!='CUMULATIVE')
		{
			if(!empty($input['dimensions']))
			{
			 	array_unshift($input['dimensions'],$interval);
			}
			else
			{
				$input['dimensions']	=	array($interval);
			}			
		}		
		
		if(!empty($input['dimensions']) && is_array($input['dimensions']))
		{			
			$input['columns']	=	array_merge($input['metrics'],$input['dimensions']);   
		}
		else
		{
			$input['columns']	=	$input['metrics'];
		}
		
		if($format!='php')
		{
			$input['stat_type']		=	($type!=false)?$type:'PLATFORM';
			
			$input['search_term']	=	$_REQUEST['sSearch'];
			
			if(isset($_REQUEST['iDisplayStart'])){
				$input['start'] = $_REQUEST['iDisplayStart'];
			}
			
			if(isset($_REQUEST['iDisplayLength'])){
				$input['end'] = ($_REQUEST['iDisplayLength']!='-1')?$_REQUEST['iDisplayLength']:'';
			}
			
			$input['datatable_obj'] = $_REQUEST;		
		
			$input['result_type'] 	= 'DATA';
			//print_r($input);exit;
			$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
			
			//echo $this->rest->debug();exit;
		
			echo $data;
		}
		else
		{
			$input['stat_type']		=	'EXPORT';
			$input['search_term']	=	'';
			
			$input['datatable_obj']['sSearch'] = '';
			$input['datatable_obj']['sEcho'] = '';
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/fetch',$input,'json');	
			//$this->rest->debug();
			
			return json_decode($data);
		}
	}
			public function camp_detail_list($campaign_id=FALSE,$field_name=FALSE,$camp_name=FALSE) 
	{
		$data['page_title'] 	= 	"Campaign Detail reports";

		$data['breadcrumb'] 	= 	'';

		$data['campaign_id'] 	= 	($campaign_id!=FALSE)?$campaign_id:'';
		$data['field_name'] 	= 	$field_name;
		$data['camp_name'] 		= 	$camp_name;
		
		/* Advertiser Filter */
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>get_session('api_key')),'php');
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>get_session('api_key')),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
				
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADVERTISER']['REPORT_CAMPAIGN']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['content'] 		= 	$this->load->view('report/camp_detail_list',$data,TRUE);
		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	public function fetch_topmenu_report($from_date=FALSE,$to_date=FALSE)
	{
		 

		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_DASHBOARD';
		$display_type	= 	'TABLE';
	
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
				
		 
			$input['date_from'] = 	$from_date;		
		 
		
		$input['datatable_obj'] = 	$_REQUEST;
		$input['report_type'] 	= 	'dash';
		$input['result_type'] 	= 	'DATA';
		
		$datk			= 	$this->rest->post('api/v1/report/fetch_topmenu_report',$input,'json');
	
		//~ echo $this->rest->debug();exit;
		$data= json_decode($datk,true);
		//~ print_r($data);exit;
	$return_value= array(
			'array_keys'=>	array($from_date),
			'array_imp'=>array((int)$data['counts'][0]['impressions']),
			'array_clk'=>array((int)$data['counts'][0]['clicks']),
			'array_conv'=>array((int)$data['counts'][0]['conversions']),
			);
		 
		echo json_encode($return_value);
	}

}
