<?php
/**
 * PayPal_Lib Controller Class (Paypal IPN Class)
 *
 * Paypal controller that provides functionality to the creation for PayPal forms, 
 * submissions, success and cancel requests, as well as IPN responses.
 *
 * The class requires the use of the PayPal_Lib library and config files.
 *
 * @package     CodeIgniter
 * @subpackage  Libraries
 * @category    Commerce
 * @author      Ran Aroussi <ran@aroussi.com>
 * @copyright   Copyright (c) 2006, http://aroussi.com/ci/
 *
 */

class Paypal extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		//installCheck();
		$this->load->library('Paypal_Lib');
		//$this->load->model('mod_payments');
		/* Libraries */
		$this->load->library('email');
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
	}

	function index()
	{
		$this->form();
	}
	
	/*
	 * Triggers the form for add fund or make payment according to type
	 * Method: form_get()
	 * @params : 
	 * @return :
	*/
	function form()
	{
		// GET Administrator PAYPAL Account ID 
		
		$paypal_info= 	$this->rest->get('api/v1/network/fetch_admin_paypal_info',array('api_key'=>get_session('api_key')),'php');
		$paypal_id 	= 	$paypal_info[0]['paypal_id'];
		$account_id	= 	$this->get('account_details');
		$amount 	= 	$this->get('amount'); 
		 
		// ASSIGN Administrator PAY PAL Account EMAIL ID 
		 
		$this->paypal_lib->add_field('business',$paypal_id);
	    $this->paypal_lib->add_field('return', site_url('api/v1/paypal/success'));
	    $this->paypal_lib->add_field('cancel_return', site_url('api/v1/paypal/cancel'));
	    $this->paypal_lib->add_field('notify_url', site_url('api/v1/paypal/ipn')); // <-- IPN url
	    $this->paypal_lib->add_field('custom', $account_id); // <-- Verify return

	    $this->paypal_lib->add_field('item_name', 'Add Fund to Ad Network');
	    $this->paypal_lib->add_field('item_number', '1');
		$this->paypal_lib->add_field('currency_code', $this->config->item('currency_transaction_symbol'));
	    $this->paypal_lib->add_field('amount', $amount);

		// if you want an image button use this:
		$this->paypal_lib->image('button_03.gif');
		
		// otherwise, don't write anything or (if you want to 
		// change the default button text), write this:
		// $this->paypal_lib->button('Click to Pay!');
		
	    $data['paypal_form'] = $this->paypal_lib->paypal_form();
	
        $this->load->view('advertiser/paypal/form', $data);
        
	}

	function auto_form($type ='default')
	{		
		if($this->input->is_ajax_request())
		{
			// GET Publisher PAYPAL Account ID 
			
			$admin_details 	= 	'ramya.p-facilitator@dreamajax.com';
			$paypal_id 		= 	$this->input->post('paypal_id');
			$invoice_id 	= 	$this->input->post('invoice_id');
			$amount 		= 	$this->input->post('amount');
			$account_id 	= 	$this->input->post('account_id');
			$custom 		= 	$account_id.':'.$invoice_id; 	
			
			// ASSIGN Administrator PAY PAL Account EMAIL ID 
			 
			$this->paypal_lib->add_field('business',$paypal_id);
			
			$this->paypal_lib->add_field('return', site_url('admin/paypal/success'));
			$this->paypal_lib->add_field('cancel_return', site_url('admin/paypal/cancel'));
			$this->paypal_lib->add_field('notify_url', site_url('admin/paypal/ipn')); // <-- IPN url
			$this->paypal_lib->add_field('custom', $custom); // <-- Verify return

			$this->paypal_lib->add_field('item_name', 'Make Payment');
			$this->paypal_lib->add_field('item_number', '1');
			$this->paypal_lib->add_field('currency_code', $this->config->item('currency_transaction_symbol'));
			$this->paypal_lib->add_field('amount', $amount);
							
			if($type==='default')
			{
				$this->paypal_lib->paypal_auto_form();
			}else{
			
				$this->paypal_lib->paypal_auto_form_custom();
			}
		}else{
			echo 'No permission';	
		}
	}
	
	function cancel()
	{
		log_message('info', 'We are in Failure...');
		/*-------------------------------------------------------------
			Breadcrumb Setup Start
		 -------------------------------------------------------------*/
		$link = breadcrumb();
		$data['breadcrumb'] = $link;
		/*-------------------------------------------------------------
				Embed current page content into template layout
		 -------------------------------------------------------------*/
		$data['content']	= $this->load->view('admin/paypal/cancel',$data,true);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);	
	}
	
	function success()
	{
		// This is where you would probably want to thank the user for their order
		// or what have you.  The order information at this point is in POST 
		// variables.  However, you don't want to "process" the order until you
		// get validation from the IPN.  That's where you would have the code to
		// email an admin, update the database with payment status, activate a
		// membership, etc.
	
		// You could also simply re-direct them to another page, or your own 
		// order status page which presents the user with the status of their
		// order based on a database (which can be modified with the IPN code 
		// below).
		log_message('info', 'We are Success...');
		
		$data['pp_info'] = $this->input->post();
		
		$this->rest->post('api/v1/paypal/ipn',array('ipn_data'=>$data['pp_info'],'transaction_type'=>'debit'),'json');
		
		/*-------------------------------------------------------------
				Embed current page content into template layout
		-------------------------------------------------------------*/
		$data['content']	= $this->load->view('admin/paypal/success',$data,true);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
			
	}
	
	function ipn()
	{		
		// Payment has been received and IPN is verified.  This is where you
		// update your database to activate or process the order, or setup
		// the database with the user's order details, email an administrator,
		// etc. You can access a slew of information via the ipn_data() array.
 
		// Check the paypal documentation for specifics on what information
		// is available in the IPN POST variables.  Basically, all the POST vars
		// which paypal sends, which we send back for validation, are now stored
		// in the ipn_data() array.
 
		// For this example, we'll just email ourselves ALL the data.
		$to = 'ramya.p@dreamajax.com';
		log_message('info', 'We are in IPN...');
		log_message('info','advertiser name');
						
		if ($this->paypal_lib->validate_ipn()) 
		{
			$this->rest->post('api/v1/paypal/ipn',array('ipn_data'=>$this->paypal_lib->ipn_data,'transaction_type'=>'debit'),'json');
        }
	}
	
}
?>
