<?php 
class Payments extends CI_Controller
{
    function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->library('pdf');
	}

	function index()
	{
		$this->advertiser_invoice();
	}

	/*
	 * 
	 * name: advertiser invoice
	 * @param : null
	 * @return :lsit all the advertiser invoice list.
	 */	

	public function advertiser_invoice()
	{
		$data['page_title'] = "Advertiser Invoice";

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('payments/advertiser_invoice',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
   
    /*
	 * 
	 * name: advertiser invoice view more 
	 * @param : null
	 * @return :detailed payment datas.
	 */	

	public function advertiser_invoice_viewmore()
	{
		$data['page_title'] = "Advertiser Invoice";

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('payments/advertiser_invoice_viewmore',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: publisher invoice
	 * @param : null
	 * @return :lsit all the publisher invoice list.
	 */	

	public function publisher_invoice()
	{
		$data['page_title'] = "Publisher Invoice";

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('payments/publisher_invoice',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: Referral invoice
	 * @param : null
	 * @return :lsit all the publisher invoice list.
	 */	

	public function referral_invoice()
	{
		$data['page_title'] = "Referral Invoice";

		$data['breadcrumb'] = '';
		
		$data['content'] = $this->load->view('payments/referral_invoice',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
   
	/*
	* 
	* name: fetch_referral_invoice_list
	* @param : null
	* @return : all the referral payment invoice details.
	*/
	public function fetch_referral_invoice_list()
	{
		$filter	=	array(
						'status'		=>	($this->input->post('status'))?explode(',',$this->input->post('status')):''/*,
						'payment_type'	=>	($this->input->post('payment_type'))?explode(',',$this->input->post('payment_type')):''*/
					);
		$invoice_list	  = $this->rest->get('api/v1/payments/fetch_referral_invoice_list',array('api_key'=>get_session('api_key'),'filter'=>$filter),'json');
	   //~ echo $this->rest->debug();exit;
		echo convert_to_datatable_format($invoice_list);
	}
   public function publisher_invoice_viewmore_edit_id()
	 {
		$this->session->unset_userdata('pub_inv_viewmore_id');
		$this->session->set_userdata('pub_inv_viewmore_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('pub_inv_viewmore_id'));
	
	 }	
    /*
	 * 
	 * name: publisher invoice view more 
	 * @param : null
	 * @return :detailed payment datas.
	 */	

	public function publisher_invoice_viewmore()
	{  
		$data['page_title'] = "Publisher Invoice";
		$data['breadcrumb'] = '';
		//$invoice_id=$this->uri->segment(4);
		$invoice_id=$this->session->userdata('pub_inv_viewmore_id');
		$network			=	$this->rest->get('api/v1/payments/fetch_network_details',array('api_key'=>get_session('api_key')),'php'); 
		$data['network']	=	$network[0];
		
		$invoice_details = $this->rest->get('api/v1/approval/publisher_invoice_viewmore',array('id'=>$invoice_id, 'api_key'=>get_session('api_key')),'php'); 
		
		$data['invoice_details'] = $invoice_details;
		
		$data['invoice_id'] = $invoice_id;
		
		$pub_account_id = $invoice_details[0]['account_id'];
		$publisher			=	$this->rest->get('api/v1/payments/fetch_publisher_details',array('id'=>$pub_account_id,'api_key'=>get_session('api_key')),'php'); 
		$data['publisher']	=	$publisher[0];
		
		/*print_r($publisher);
		exit;
		$this->rest->debug();*/
		
		$data['content'] = $this->load->view('payments/publisher_invoice_viewmore',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
   /*
	* 
	* name: payment history 
	* @param : null
	* @return : all the payment history details.
	*/	
	public function payment_history()
	{
		$data['page_title'] = "Payment History";
		$data['breadcrumb'] = '';
		$data['content'] = $this->load->view('payments/payment_history',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
   
   /*
   * 
   * name: fetch_publisher_invoice_list
   * @param : null
   * @return : all the publisher payment invoice details.
   */
   public function fetch_publisher_invoice_list()
   {
	   $status_val= explode(',',$this->input->post('status'));
	   $filter	=	array(
						'status'		=>	$status_val
						/*,
						'payment_type'	=>	($this->input->post('payment_type'))?explode(',',$this->input->post('payment_type')):''*/
					);
					
       $invoice_list	  = $this->rest->get('api/v1/payments/fetch_publisher_invoice_list',array('api_key'=>get_session('api_key'),'filter'=>$filter),'json');
	   //$this->rest->debug();
	   echo convert_to_datatable_format($invoice_list);
   }
   
   /*
   * 
   * name: publisher_payments_history
   * @param : null
   * @return : all the publisher payment invoice details.
   */
   public function publisher_payments_history()
   {
        $data['page_title'] = "Publisher Payment History";
		$data['breadcrumb'] = '';
		$data['content'] = $this->load->view('payments/publisher_payment_history',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
   }
   
   /*
   * 
   * name: list_advertiser_payment_details
   * @param : account id
   * @return : all the advertiser payment  details.
   */ 
   public function list_advertiser_payment_details()
   {
	   $payment_list=$this->rest->get('api/v1/payments/list_advertiser_payment_details',array('api_key'=>get_session('api_key')),'json'); 
	   
	   echo convert_to_datatable_format($payment_list);
   }
   
    /*
   * 
   * name: get_advertiser_date_wise_payment_history
   * @param : account id
   * @return : all the advertiser payment  details.
   */
   public function get_advertiser_date_wise_payment_history()
   {
	  $month=clean_data($this->input->post('month'));
	  $year=clean_data($this->input->post('year'));
	  $account_id=clean_data($this->input->post('accountid'));
	  $datewise=$this->rest->post('api/v1/payments/list_advertiser_payment_date_wise',array('account_id'=>$account_id,'month'=>$month,'year'=>$year,'api_key'=>get_session('api_key')),'json');
	  echo convert_to_datatable_format($datewise);
	}
	
	/*
   * 
   * name: list_publisher_payment_details
   * @param : none
   * @return : all the publisher payment  details.
   */ 
   public function list_publisher_payment_details()
   {
	   $payment_list=$this->rest->get('api/v1/payments/list_publisher_payment_history',array('api_key'=>get_session('api_key')),'json'); 
	   //$this->rest->debug();
	   echo convert_to_datatable_format($payment_list);
   }
   
   
   	/*
   * 
   * name: list_publisher_payment_details
   * @param : none
   * @return : all the publisher payment  details.
   */ 
   public function get_publisher_date_wise_payment_history()
   {
       $month=clean_data($this->input->post('month'));
	   $year=clean_data($this->input->post('year'));
	   $account_id=clean_data($this->input->post('accountid'));
	   $datewise=$this->rest->post('api/v1/payments/list_publisher_payment_date_wise',array('account_id'=>$account_id,'month'=>$month,'year'=>$year,'api_key'=>get_session('api_key')),'json');
		//this->rest->debug();
	   echo convert_to_datatable_format($datewise);
   }
   
   
   public function fetch_admin_payment_history()
   {
	   $payment_history=$this->rest->get('api/v1/payments/fetch_admin_payment_history',array('api_key'=>get_session('api_key')),'json');
	   echo convert_to_datatable_format($payment_history);
   }
   
   /*
   * 
   * name: advertiser_deposit
   * @param : none
   * @return : all the advertiser payment details.
   */
   public function advertiser_deposit()
   {
	    $data['page_title'] = "Deposit Amount Details";
		$data['breadcrumb'] = '';
		$data['content'] = $this->load->view('payments/deposits/deposit_details',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
   }
   
   /*
   * 
   * name: fetch_advertiser_deposit_list
   * @param : none
   * @return : all the advertiser payment details.
   */
   public function fetch_advertiser_deposit_list()
   {
		$filter	=	array(
						'status'		=>	$this->input->post('status')?$this->input->post('status'):'',
						'payment_type'	=>	$this->input->post('payment_type')?$this->input->post('payment_type'):''
					);
		$deposit_list	  = $this->rest->get('api/v1/payments/fetch_advertiser_deposit_amount_list',array('api_key'=>get_session('api_key'),'filter'=>$filter),'json');
		//~ echo $this->rest->debug();exit;
		echo convert_to_datatable_format($deposit_list);	
   }
   
   /*
   * 
   * name: fetch_billing_information
   * @param : none
   * @return : all the advertiser billing details.
   */
   public function fetch_billing_information()
   {	   
		$b_id=clean_data($this->input->post("b_id"));
		
		$data['billing_details']=$this->rest->get('api/v1/payments/advertiser_billing_details',array('api_key'=>get_session('api_key'),'billing_id'=>$b_id),'php');
		
		$content = $this->load->view('payments/billing_preview',$data,TRUE);
   }
   
  
    /*
   * 
   * name: earnings_report
   * @param : none
   * @return : call to view file.
   */  
   public function earnings_report()
   {
        $data['page_title'] = "Earnings Details";
		$data['breadcrumb'] = '';
		$data['content'] = $this->load->view('payments/revenue_report',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
   }
   
    /*
   * 
   * name: fetch_admin_revenue_list
   * @param : none
   * @return : all the revenue details in month wise.
   */
   public function fetch_admin_revenue_list() 
   {
     $agencyid=get_session('agencyid');
	 $revenue_list=$this->rest->get('api/v1/payments/admin_revenue_list',array('agencyid'=>$agencyid,'api_key'=>get_session('api_key')),'json');
	 echo convert_to_datatable_format($revenue_list);
   }
   
    /*
   * 
   * name: fetch_date_wise_revenue_details
   * @param : month,year,agencyid
   * @return : all the revenue details in date wise.
   */
   public function fetch_date_wise_revenue_details()	
   {
      $month=clean_data($this->input->post('month'));
	  $year=clean_data($this->input->post('year'));
	  $agency_id=clean_data($this->input->post('agency_id'));
	  $revenue_list=$this->rest->get('api/v1/payments/admin_revenue_list_date_wise',array('month'=>$month,'year'=>$year,'agency_id'=>$agency_id,'api_key'=>get_session('api_key')),'json');
	  echo convert_to_datatable_format($revenue_list);
   }
   
   /*
   * 
   * name: download_invoice_details
   * @param : invoice_id
   * @return : downloads the invoice in pdf version
   */
   
	public function download_invoice_details($invoice_id=false)
	{
		$invoice_arr = $this->input->post('down_invoice_id');

		$network_info		=	$this->rest->get('api/v1/payments/fetch_network_details',array('api_key'=>get_session('api_key')),'php'); 
		$data['network']	=	$network_info[0];
		
		if($invoice_id!=false)
		{
			$invoice_information=$this->rest->get('api/v1/approval/publisher_invoice_viewmore',array('id'=>$invoice_id,'api_key'=>get_session('api_key')),'php');
			
			if($invoice_information)
			{
				$data['invoice_details'] = $invoice_information;
				
				$pub_account_id = $invoice_information[0]['account_id'];
				$publisher			=	$this->rest->get('api/v1/payments/fetch_publisher_details',array('id'=>$pub_account_id,'api_key'=>get_session('api_key')),'php'); 
				$data['publisher']	=	$publisher[0];					
				$pdf_name = $this->config->item('prod_name').'_Invoice_'.date('d.m.Y');
				$this->pdf->load_view('publisher/payments/download_invoice',$data);
				$this->pdf->render();
				$this->pdf->stream("$pdf_name.pdf");	
			}else{
				return FALSE;
			}
		}
		else
		{	
			$invoicedata	=	explode(',',$invoice_arr);
			
			if(is_array($invoicedata))
			{
				ob_end_clean();
				ob_start();
				$objPHPExcel = new PHPExcel();
			
				$workSheet	=	 $objPHPExcel->getActiveSheet();			
				
				$objPHPExcel->getProperties()->setCreator("Administrator");
				$objPHPExcel->getProperties()->setLastModifiedBy("Administrator");
				$objPHPExcel->getProperties()->setTitle();			
				
				// Set password for readonly data
				$objPHPExcel->getActiveSheet()->getProtection()->setSheet(true);
				$objPHPExcel->getActiveSheet()->getProtection()->setPassword("password");

				//Default Style Settings For Excel Sheet
				$workSheet->getDefaultStyle()->getFont()->setName('Calibric')->setSize(10);
				$workSheet->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);		
				$workSheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);										

				$workSheet->getColumnDimension('B')->setWidth(20);
				$workSheet->getColumnDimension('C')->setWidth(20);
				$workSheet->getColumnDimension('D')->setWidth(10);
				$workSheet->getColumnDimension('E')->setWidth(25);
				$workSheet->getColumnDimension('F')->setWidth(15);
				$workSheet->getColumnDimension('G')->setWidth(15);
				$workSheet->getColumnDimension('H')->setWidth(45);
				$workSheet->getColumnDimension('I')->setWidth(10);
				
				//Set the Row dimensions for Each Row 			
				$workSheet->getRowDimension(3)->setRowHeight(80);
				$workSheet->getRowDimension(6)->setRowHeight(20);
				
				// Decalaration of Style in an Array 		
			
				$titleArray	=	array(
										'font'=>array(
													'bold'	=>	true,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);
				$contentArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);	
									
				$dimensArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);		
										
				$metricsArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_CENTER
										)	
									);	
					
							
				// Add some data
				//echo date('H:i:s') . " Add some data\n";
				$objPHPExcel->setActiveSheetIndex(0);
				
				$i=3;
				foreach($invoicedata as $inv_id)
				{
					$network	=	$network_info[0];
					$inv_info	=	$this->rest->get('api/v1/approval/publisher_invoice_viewmore',array('id'=>$inv_id,'api_key'=>get_session('api_key')),'php');
					
					if($inv_info)
					{						
						$pub_account_id = 	$inv_info[0]['account_id'];
						$pub			=	$this->rest->get('api/v1/payments/fetch_publisher_details',array('id'=>$pub_account_id,'api_key'=>get_session('api_key')),'php'); 
						$publisher		=	$pub[0];	
					
						$from_address	=	(($network['billing_company_name'])?$network['billing_company_name'].', '."\n":'').(($network['billing_block_no'])?$network['billing_block_no'].', '."\n":'').(($network['billing_address'])?$network['billing_address'].', '."\n":'').(($network['billing_city'])?$network['billing_city'].(($network['billing_state'])?','.$network['billing_state']:'').', '."\n":'').(($network['name'])?$network['name']."\n":'');				
						
						$to_address		=	(($publisher['dj_company_name'])?$publisher['dj_company_name'].', '."\n":'').(($publisher['dj_company_block_no'])?$publisher['dj_company_block_no'].', '."\n":'').(($publisher['dj_company_address'])?$publisher['dj_company_address'].', '."\n":'').(($publisher['dj_company_state'])?$publisher['dj_company_city'].(($publisher['dj_company_state'])?','.$publisher['dj_company_state']:'').', '."\n":'').(($publisher['name'])?$publisher['name']."\n":'');				
						
						
						$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i, "From");
						$objPHPExcel->getActiveSheet()->getStyle('B'.$i)->applyFromArray($titleArray);						
						$objPHPExcel->getActiveSheet()->getStyle('C'.$i)->getAlignment()->setWrapText(tr‌​ue); 
						$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i, ($from_address)?$from_address:'-');	
						$objPHPExcel->getActiveSheet()->getStyle('C'.$i)->applyFromArray($contentArray);			
							
						$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i, "To");
						$objPHPExcel->getActiveSheet()->getStyle('E'.$i)->applyFromArray($titleArray);
						$objPHPExcel->getActiveSheet()->getStyle('F'.$i)->getAlignment()->setWrapText(tr‌​ue); 
						$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i, ($to_address)?$to_address:'-');
						$objPHPExcel->getActiveSheet()->getStyle('F'.$i)->applyFromArray($contentArray);
							
						$i=$i+2;	
						
						$workSheet->getStyle($i)->applyFromArray($titleArray);
						$workSheet->getStyle('B'.$i.':I'.$i)->applyFromArray(
														array(
															'fill' => array(
																'type' => PHPExcel_Style_Fill::FILL_SOLID,
																'color' => array('rgb' => 'd3d3d3')
															)
														)
													);					
						$workSheet->SetCellValue('B'.$i,"Name");
						$workSheet->SetCellValue('C'.$i,"Invoice #");
						$workSheet->SetCellValue('D'.$i,"Date");
						$workSheet->SetCellValue('E'.$i,"Period");
						$workSheet->SetCellValue('F'.$i,"Invoice Amount");
						$workSheet->SetCellValue('G'.$i,"Invoice Status");					
						$workSheet->SetCellValue('H'.$i,"Description");
						$workSheet->SetCellValue('I'.$i,"Amount");			
						
												
						$i=$i+1;
						
						$workSheet->setCellValueByColumnAndRow('1',$i,$inv_info[0]['name']);
						$workSheet->setCellValueByColumnAndRow('2',$i,$inv_info[0]['invoice_code']);
						$workSheet->setCellValueByColumnAndRow('3',$i,$inv_info[0]['in_date']);
						$workSheet->setCellValueByColumnAndRow('4',$i,$inv_info[0]['start_date'].' to '.$inv_info[0]['end_date']);
						$workSheet->setCellValueByColumnAndRow('5',$i,$inv_info[0]['invoice_earn']);
						
						if($inv_info[0]['invoice_status']==1)
						{
							$inv_status	= 	"Paid";
						}						
						elseif($inv_info[0]['invoice_status']==0)						
						{
							$inv_status	= 	"Pending";
						}						
						elseif($inv_info[0]['invoice_status']==2)						
						{
							$inv_status	= 	"Cancelled";
						}
									
						$workSheet->setCellValueByColumnAndRow('6',$i,$inv_status);
						
						foreach($inv_info as $invin):
							$credit_desc	=	str_replace('Earnings','Credit Balance',$inv_info[0]['item_desc']);
							$workSheet->setCellValueByColumnAndRow('7',$i,(($invin['item_desc']=='0')?$credit_desc:$invin['item_desc']));
							$workSheet->setCellValueByColumnAndRow('8',$i,html_entity_decode($this->config->item('currency')).' '.$invin['amount']);
							$i=$i+1;
						endforeach;
						
						$workSheet->getStyle($i)->applyFromArray($titleArray);	
						$workSheet->setCellValueByColumnAndRow('7',$i,"Total");											
						$workSheet->setCellValueByColumnAndRow('8',$i,html_entity_decode($this->config->item('currency')).' '.ROUND($inv_info[0]['total_earn'],2));
						$i=$i+1;						
						$workSheet->getStyle($i)->applyFromArray($titleArray);
						$workSheet->setCellValueByColumnAndRow('7',$i,"Balance");
						$workSheet->setCellValueByColumnAndRow('8',$i,html_entity_decode($this->config->item('currency')).' '.$inv_info[0]['remaining_earn']);
						
					}
					$i=$i+2;					
				}
				
				$dfilename	=		$this->config->item('prod_name').'_Invoice_'.date('d.m.Y').'_'.time().'.xls';
			
				//********* TO DOWNLOAD THE EXCEL FILE********
				header('Content-Type: text/csv');
				header('Content-Disposition: attachment;filename="'.$dfilename.'"');
				
				$objWriter = new PHPExcel_Writer_Excel5($objPHPExcel);		
				//$objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);		
				
				$objWriter->save('php://output');
				
			}
			else{
				return FALSE;
			}		
			
		}
	}   
}
