<?php 
class News extends CI_Controller
{
   function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');$this->load->helper('download');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		
		$this->news_lists();
		
	}
	
	function news_lists()
	{
		$data['page_title'] = "News Lists ";	
		$data['breadcrumb'] = '';
	 
		$data['content'] = $this->load->view('news/news_list',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	public function news_create()
	{		
		$data['page_title'] = "News Create ";	
		$data['breadcrumb'] = '';
	 
		$data['content'] = $this->load->view('news/news_create',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	public function edit_news($newsid)
	{		
		$data['page_title'] = "News Edit ";	
		$data['breadcrumb'] = '';
		$news	=	$this->rest->post('api/v1/news/news_edit',array('api_key'=>get_session('api_key'),'n_id'=>$newsid),'php');
		$data['news']=$news[0];
		$data['content'] = $this->load->view('news/news_edit',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	function admin_news_list($month=FALSE,$year=FALSE)
	{		 
		$news	=	$this->rest->post('api/v1/news/admin_news',array('api_key'=>get_session('api_key'),'month'=>$month,'year'=>$year),'json');
		echo convert_to_datatable_format($news);
	}
	
	
}
