<?php 
class Network extends CI_Controller
{
   function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->helper('download');
	}

	function index()
	{
		$this->countrywise_bidding();  
	}

	/*
	 * 
	 * name		:countrywise_bidding
	 * @param   :Null
	 * @return  :List the countrywise bidding for particular Advertiser
	 */	

	public function countrywise_bidding()
	{
		$data['page_title'] = "Countrywise Bidding";
		$data['selected_country']=$this->rest->get('api/v1/countrywise_bidding/fetch_biddingcountrylist',array('api_key'=>get_session('api_key')),'php');
		$data['content'] = $this->load->view('bidding/countrywise_bidding',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
		
	public function fetch_country_list()
	{
		$filter	=	array(
						'campaign'	=>	($this->input->post('campaign')!='')?explode(',',$this->input->post('campaign')):'',
						'campaign_type'	=>	($this->input->post('campaign_type')!='')?explode(',',$this->input->post('campaign_type')):''
					);		
		$country_list	  = $this->rest->get('api/v1/countrywise_bidding/fetch_biddingcountrylist',array('api_key'=>get_session('api_key'),'filter'=>$filter),'json');		
		//echo $this->rest->debug();  
		echo convert_to_datatable_format($country_list);
	}
	public function S2S_Tracking()
	{		
		$data['breadcrumb'] = '';
		$data['content'] = $this->load->view('campaigns/s2scode',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
		
	/*
	 * 
	 * name		:add_countrywise_bidding
	 * @param   :Null
	 * @return  :Loads the country
	 */	

	public function add_countrywise_bidding()
	{
		$data['advertiser_list']	= 	$this->rest->get('api/v1/utilities/fetch_advertiser',array("api_key"=>get_session('api_key')),'php');
			
		$data['country_data'] = $this->rest->get('api/v1/countrywise_bidding/fetch_unbiddingcountrylist',array("api_key"=>get_session('api_key')),'php');
		
		$data['campaign_data'] =$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
		
		$data['campaign_type']	= $this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		echo $this->load->view('bidding/modal_bidding/content/add_countrywise_bidding',$data);	
	}
	
	/*
	 * 
	 * name		:edit_countrywise_bidding
	 * @param   :Null
	 * @return  :Loads the country
	 */	

	public function edit_countrywise_bidding($country_id=false)
	{
		$data['advertiser_list']	= 	$this->rest->get('api/v1/utilities/fetch_advertiser',array("api_key"=>get_session('api_key')),'php');
		
		$data['country_data'] 		= 	$this->rest->get('api/v1/countrywise_bidding/fetch_countrylist',array("api_key"=>get_session('api_key')),'php');
			
		$data['campaign_data'] 		=	$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
		
		$data['campaign_type']		= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['countrybidding_data'] = 	$this->rest->get('api/v1/countrywise_bidding/editcountrylist',array("id"=>$country_id,"api_key"=>get_session('api_key')),'php');
		
		echo $this->load->view('bidding/modal_bidding/content/edit_countrywise_bidding',$data);	
	}
	
	public function zone_limitation()
	{ 
		$data['page_title'] = 	"Zone Limitation";
		$data['traffic_source']=$this->rest->get('api/v1/zone_limitations/fetch_traffic_sources',array("api_key"=>get_session('api_key')),'php');
		$data['zone_list']=$this->rest->get('api/v1/zone_limitations/fetch_filter_zone',array("api_key"=>get_session('api_key')),'php');
		$data['content'] 	= 	$this->load->view('zone_limitation/manage_zone_limitation',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_zone_limitation_list()
	{
		$filter	=	array(
						'campaign_type'	=>	($this->input->post('campaign_type')!='')?explode(',',$this->input->post('campaign_type')):''
					);		
		$zonelist_list	= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>get_session('api_key'),'filter'=>$filter),'json');		
		//echo $this->rest->debug();  
	    echo convert_to_datatable_format($zonelist_list);
	}
	/*
	 * 
	 * name		:add_zone_limitation
	 * @param   :Null
	 * @return  :Loads the zoneids
	 */	

	public function add_zone_limitation()
	{	
		$data['advertiser_list']	= 	$this->rest->get('api/v1/utilities/fetch_advertiser',array("api_key"=>get_session('api_key')),'php');
		$data['site_url_block']		= 	$this->rest->get('api/v1/zone_limitations/fetch_url_block_list',array('api_key'=>get_session('api_key')),'php');	
		$zone_list  		= 	$this->rest->get('api/v1/zone_limitations/fetch_zonelist',array('api_key'=>get_session('api_key')),'php');	
		$unsetzone_list		= 	$this->rest->get('api/v1/zone_limitations/fetch_list_unsetzone_list',array('api_key'=>get_session('api_key')),'php');			
		$zone_list_array 	= 	array();
		foreach($zone_list as $zone){
			$zone_list_array[] = $zone['zoneid'];
		}
		$unsetzone = array();
		foreach($unsetzone_list as $unset){
			$unsetzone = array_merge($unsetzone, explode(',',$unset['selected_zone_ids']));
		}
		
		$result=  array_diff($zone_list_array, $unsetzone);
		$data['zone_list'] =$result;
		echo $this->load->view('zone_limitation/modal_zone_limitation/content/add_list',$data);	
	}
	
	/*
	 * 
	 * name		:edit_zone_limitation
	 * @param   :Null
	 * @return  :Loads the zone
	 */	

	public function edit_zone_limitation($advertiser_id=false)
	{
		$data['advertiser_list']	= 	$this->rest->get('api/v1/utilities/fetch_advertiser',array("api_key"=>get_session('api_key')),'php');
		$data['site_url_block']		= 	$this->rest->get('api/v1/zone_limitations/fetch_url_block_list',array('api_key'=>get_session('api_key')),'php');
		$zone_list			= 	$this->rest->get('api/v1/zone_limitations/fetch_zonelist',array('api_key'=>get_session('api_key')),'php');
		$unsetzone_list 	= 	$this->rest->get('api/v1/zone_limitations/fetch_list_unsetzone_list',array('api_key'=>get_session('api_key')),'php');			
		$zone_list_array 	= 	array();
		foreach($zone_list as $zone){
			$zone_list_array[] = $zone['zoneid'];
		}
		$unsetzone = array();
		foreach($unsetzone_list as $unset){
			$unsetzone 	= 	array_merge($unsetzone, explode(',',$unset['selected_zone_ids']));
		}

		$result	=  	array_diff($zone_list_array, $unsetzone);
		$data['zone_limitation_data'] = $this->rest->get('api/v1/zone_limitations/edit_zone_limitation',array("id"=>$advertiser_id,"api_key"=>get_session('api_key')),'php');
		$data['zone_list'] =array_merge($result, explode(',',$data['zone_limitation_data'][0]['zoneids']));
	 	echo $this->load->view('zone_limitation/modal_zone_limitation/content/edit_list',$data);	
	}
	
	public function filter_country($adv_id=false,$campaignid=false,$revenueid=false)
	{
		$data['campaign_data'] = $this->rest->get('api/v1/countrywise_bidding/filter_country',array("api_key"=>get_session('api_key'), "adv_id" => $adv_id, "campaignid" => $campaignid, "revenueid" => $revenueid),'php');
		echo $this->load->view('bidding/modal_bidding/content/filtercountry',$data);	
	}
	
	public function traffic_sources()
	{
		$data['advertiser_list']	= 	$this->rest->get('api/v1/utilities/fetch_advertiser',array("api_key"=>get_session('api_key')),'php');
		
        $data['page_title'] = 	"Traffic Sources";
		$data['pub_data'] 	=	$this->rest->get('api/v1/report/fetch_publisher_traffic',array("api_key"=>get_session('api_key')),'php');
		
		$data['camp_lists']	=	$this->rest->get('api/v1/campaign/fetch_camp_list',array("api_key"=>get_session('api_key')),'php');
		
		$data['traffic_sourced_list']= $this->rest->get('api/v1/network/fetch_traffic_sources',array("api_key"=>get_session('api_key')),'php');
		
		$data['content'] = $this->load->view('special_bidding/traffic_sources',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function traffic_sources_adv_list()
	{
		$filter	=	array(
						'campaign_type'	=>	($this->input->post('campaign_type')!='')?explode(',',$this->input->post('campaign_type')):''
					);				
		$advertiser_camp_id=$this->rest->get('api/v1/network/fetch_traffic_sources',array("api_key"=>get_session('api_key'),'filter'=>$filter),'json');
		//echo $this->rest->debug();  die();
		echo convert_to_datatable_format($advertiser_camp_id);
	}
	
	/*public function traffic_sources_remove_list()
	{
		 $post = clean_data($this->post());
		 print_r($post); exit;
	}*/
	
	/*
	* 
	* name		:network
	* @param   :Null
	* @return  :Network page
	*/	
	 
	function networkkit()
	{		
		$data['page_title'] = 	"Media Kit";

		$data['breadcrumb'] = 	'';
		
		$data['api_key']			=	get_session('api_key');
		
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'	=>	$data['api_key']),'php');
		
		$set = $this->config->item('report_config');
				
		$data['search_date'] 	= 	get_search_date($set['ADVERTISER']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'	=>	$data['api_key']),'php');
		
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>get_session('api_key')),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
						
		$data['content'] 		= 	$this->load->view('reports/network',$data,TRUE);
				
		$this->template->set_layout('admin_layout');
		
		$this->template->build('view', $data);
	}
	
	public function fetch_network_stat($format='json',$c,$from_date,$to_date)
	{
		
		$api_key		=	get_session('api_key');		
		
		$account_type 	= 	get_session('account_type');
		$page			= 	'REPORT_GEO_GRAPHICAL';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type,
						'stat_type'		=>	'NETWORK',
					  );
					  
		$env 		= 	$this->input->post('env');
		
		$country 	= 	$this->input->post('country');
		$adsize		= 	clean_data($this->input->post('adsize'));
		$camtyp 	= 	clean_data($this->input->post('revtype'));		
		
		if($from_date == NULL){
		  $from_date = $this->input->post('from_date');
		}
		if($to_date == NULL){
			$to_date = $this->input->post('to_date');
		}
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($country != 'all'){
			$input['country_id'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
		
		if($camtyp != 'all'){
			$input['camtyp'] = ($camtyp)?((is_array($camtyp))?$camtyp:explode(',',$camtyp)):'';
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
					  
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
			
		$data	= 	$this->rest->post('api/v1/report/fetch',$input,'json');
		
		//$this->rest->debug();
		
		echo $data;
	
	}
	/* Zone bidding */	
	public function zone_bidding()
	{ 
		$data['page_title'] = "Zone Bidding";
		
		$data['zone_data'] =	$this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>get_session('api_key')),'php');
						
		$data['camp_lists']=$this->rest->get('api/v1/campaign/fetch',array("api_key"=>get_session('api_key')),'php');
						
		$data['content'] = $this->load->view('zone_bidding/manage_zone_bidding',$data,TRUE);
	
		$this->template->set_layout('admin_layout');
	    	
		$this->template->build('view', $data);
	}	
	
	public function zone_bidding_adv_list()
	{  
		$filter	=	array(
						'campaign_type'	=>	($this->input->post('filter_campaign_type')!='')?explode(',',$this->input->post('filter_campaign_type')):''
					);
		$advertiser_camp_id=$this->rest->get('api/v1/network/fetch_zone_bidding',array("api_key"=>get_session('api_key'),"filter"=>$filter),'json');	
		//echo $this->rest->debug(); exit;		   
		echo convert_to_datatable_format($advertiser_camp_id);
	}
	function traffic_import_download_file()
	{
		
		$data = file_get_contents("./csv/upload/traffic_import.csv"); // Read the file's contents			
		$name = 'traffic_import.csv'; 
		force_download($name, $data);  
	}
	
	function traffic_import_download_file_txt()
	{ 
		$data = file_get_contents("./csv/upload/traffic_import.txt"); // Read the file's contents			
		$name = 'traffic_import.txt';
		force_download($name, $data);    
	}
	function traffic_import_download_file_xml()
	{ 
		$data = file_get_contents("./csv/upload/traffic_import.xml"); // Read the file's contents			
		$name = 'traffic_import.xml';
		force_download($name, $data);    
	}
	function download_traffic($traffic_id=false,$format=false)
	{
		$tid= rawurldecode($traffic_id);  
		if($tid!=false)
		{	
			//$export_list=$this->rest->get('api/v1/campaign/testing',array('campaignid'=>$campaignid,'api_key'=>get_session('api_key')),'php');
			
			$traffic_list = 	$this->rest->get('api/v1/network/fetch_traffic_sources',array("traffic_ids"=>$tid,"api_key"=>get_session('api_key')),'json');
			
			$listed_data = json_decode($traffic_list, true);

			foreach($listed_data as $cam_id)
			{
			$cam[]=$cam_id['id'];
			}
			$k=0;
			$new_listed_data=array();
			$exp_tid = explode(',',$tid);	 
			for($i=0;$i<count($exp_tid);$i++)
			{
				for($j=0;$j<count($listed_data);$j++)
				{
					if($listed_data[$j]['id']==$exp_tid[$i])
					{
						$new_listed_data[$k]=$listed_data[$j];
						$k++;
					}
				}
			}	
			$imp=implode(',',$cam);
			$cmp_s= str_replace(",","_sid_",$tid);
			if($cmp_s)
			{
				$cmp_fn='sid_'.$cmp_s;
			}
			else
			{
				$cmp_fn='sid_'.$tid;
			}
			$listed_data=$new_listed_data;		
					
			if($format=="csv")
			{		
					$filename=$cmp_fn.'.csv';
					
					header('Content-type: text/csv');
					header('Content-Disposition: attachment; filename='.$filename);
					ob_clean();
					$csv = "campaignid,bidding_type,sourceid,bidrate,status,admarket\n";
					
										
					for($i=0;$i<count($listed_data);$i++)
					{						
					$csv.= $listed_data[$i]['campaign_id'].','.$listed_data[$i]['source_type'].','.$listed_data[$i]['traffic_id'].','.$listed_data[$i]['bid_rate'].','.$listed_data[$i]['status'].','.$listed_data[$i]['admarket']."\n";							
					}
					
					print_r($csv);  
			}
			else if($format =='txt')
			{
				$listed_txt = array();
				$delimiter = "\t";
				$filename=$cmp_fn.'.txt';
				header('Content-type: text/tab-separated-values');
				header("Content-Disposition: attachment;filename=".$filename);	
				ob_clean();
					
				$listed_txt	="campaignid,bidding_type,sourceid,bidrate,status,admarket\n";					
				for($i=0;$i<count($listed_data);$i++)
				{
					$listed_txt.= $listed_data[$i]['campaign_id'].','.$listed_data[$i]['source_type'].','.$listed_data[$i]['traffic_id'].','.$listed_data[$i]['bid_rate'].','.$listed_data[$i]['status'].','.$listed_data[$i]['admarket']."\n";				
				}				
				print_r($listed_txt); 			
			}
			else if($format =='xml')
			{
				$filename=$cmp_fn.'.xml';
				header('Content-Type: text/xml');
				header("Content-Disposition: attachment;filename=".$filename);
				ob_clean();	  							
				$xml = new SimpleXMLElement('<Admin/>');
				$xml->addAttribute("xmlns", "http://tempuri.org/ds.xsd");
				for($i=0;$i<count($listed_data);$i++)
				{
						$zonelimit_list = $xml->addChild("Trafficsource");
						$zonelimit_list->addChild('campaignid',$listed_data[$i]['campaign_id']);
						$zonelimit_list->addChild('bidding_type',$listed_data[$i]['source_type']);
						$zonelimit_list->addChild('sourceid', $listed_data[$i]['traffic_id']);
						$zonelimit_list->addChild('bidrate', $listed_data[$i]['bid_rate']);
						$zonelimit_list->addChild('status', $listed_data[$i]['status']);
						$zonelimit_list->addChild('admarket', $listed_data[$i]['admarket']);
				}
				print($xml->asXML());
				
			}			
		}
		
	}
	//country sample file download 
	function countrywise_import_download_file()
	{ 
		
		$data = file_get_contents("./csv/upload/countrywise_import.csv"); // Read the file's contents			
		$name = 'countrywise_import.csv';
		force_download($name, $data);  
	}
	
	function countrywise_import_download_file_txt()
	{ 
		$data = file_get_contents("./csv/upload/countrywise_import.txt"); // Read the file's contents			
		$name = 'countrywise_import.txt';
		force_download($name, $data);    
	}
	function countrywise_import_download_file_xml()
	{ 
		$data = file_get_contents("./csv/upload/countrywise_import.xml"); // Read the file's contents			
		$name = 'countrywise_import.xml';
		force_download($name, $data);    
	}
		
	//export countrywise download
	function export_download($campaign_id=false,$format=false)
	{
									
		$campaignid= rawurldecode($campaign_id);  
			
		if($campaignid!=false)
		{	
				
			//$export_list=$this->rest->get('api/v1/campaign/testing',array('campaignid'=>$campaignid,'api_key'=>get_session('api_key')),'php');
			
			$country_list = 	$this->rest->get('api/v1/countrywise_bidding/fetch_country_export_data',array("campaign_id"=>$campaignid,"api_key"=>get_session('api_key')),'json');

			$listed_data = json_decode($country_list, true);
				
			foreach($listed_data as $cam_id)
			{
			$cam[]=$cam_id['c_id'];
			}	
			$imp=implode(',',$cam);
			
			$cmp_s= str_replace(",","_geoid_",$imp);
			if($cmp_s)
			{
				$cmp_fn='geoid_'.$cmp_s;
			}
			else
			{
				$cmp_fn='geoid_'.$imp;
			}
			
			if($format=="csv")
			{				
					$filename=$cmp_fn.'.csv';
					header('Content-type: text/csv');
					header('Content-Disposition: attachment; filename='.$filename);

					$csv = "advertiser,campaignid,account_id,campaignname,revenue_type,country_value,bidding_value,status\n";
					
					for($i=0;$i<count($listed_data);$i++){
						
						$csv.= $listed_data[$i]['account_name'].','.$listed_data[$i]['campaignid'].','.$listed_data[$i]['account_id'].','.$listed_data[$i]['campaignname'].','.$listed_data[$i]['revenue_type'].','.$listed_data[$i]['country_value'].','.$listed_data[$i]['bidding_value'].','.$listed_data[$i]['status']."\n";
					}
					
					print_r($csv);  
			}
			else if($format =='txt')
			{
				$listed_txt = array ();
				$delimiter = "\t";
				$filename=$cmp_fn.'.txt';
				header('Content-type: text/tab-separated-values');
				header("Content-Disposition: attachment;filename=".$filename);	
				
				$txt = "advertiser,campaignid,account_id,campaignname,revenue_type,country_value,bidding_value,status\n";
				
											
				for($i=0;$i<count($listed_data);$i++)
				{
					
					$txt.= $listed_data[$i]['account_name'].','.$listed_data[$i]['campaignid'].','. $listed_data[$i]['account_id'].','.$listed_data[$i]['campaignname'].','.$listed_data[$i]['revenue_type'].','.$listed_data[$i]['country_value'].','.$listed_data[$i]['bidding_value'].','.$listed_data[$i]['status']."\n";
					
				/*	$listed_txt[] = array($listed_data[$i]['cam_name'],$listed_data[$i]['clientid'],$listed_data[$i]['views'],$listed_data[$i]['clicks'],
					$listed_data[$i]['conversions'],$listed_data[$i]['priority'],$listed_data[$i]['weight'],$listed_data[$i]['revenue'],$listed_data[$i]['revenue_type'],$listed_data[$i]['block'],$listed_data[$i]['capping'],$listed_data[$i]['session_capping'],$listed_data[$i]['status'],$listed_data[$i]['dj_budget_status'],$listed_data[$i]['viewwindow'],$listed_data[$i]['clickwindow'],$listed_data[$i]['ecpm'],$listed_data[$i]['min_impressions'],$listed_data[$i]['start_time'],$listed_data[$i]['end_time'],$listed_data[$i]['cpv_percentage'],$listed_data[$i]['cam_status'],$listed_data[$i]['dj_campaign_budget'],$listed_data[$i]['dj_is_retargeted'],$listed_data[$i]['behavior'],$listed_data[$i]['dj_max_retargetting'],$listed_data[$i]['dj_daily_budget'],$listed_data[$i]['daily_budget_unlimit'],$listed_data[$i]['dj_campaign_remain_budget'],$listed_data[$i]['dj_campaign_remain_total_budget'],$listed_data[$i]['dj_current_date'],$listed_data[$i]['dj_targetting_type']);*/
				}	
					print_r($txt); 		
				//~ foreach ($txt as $listkey => $list) 
				//~ {
						//~ $dataRowString = implode($delimiter, $list);
						//~ print $dataRowString . "\r\n";
				//~ }				
			}
			else if($format =='xml')
			{
				$filename=$cmp_fn.'.xml';
				header('Content-Type: text/xml');
				header("Content-Disposition: attachment;filename=".$filename);
				$xml = new SimpleXMLElement('<country/>');
				$xml->addAttribute("xmlns", "http://tempuri.org/ds.xsd");
				for($i=0;$i<count($listed_data);$i++)
				{
						$cam_list = $xml->addChild("country");
						$cam_list->addChild('advertiser',$listed_data[$i]['account_name']);
						$cam_list->addChild('campaignid',$listed_data[$i]['campaignid']);
						$cam_list->addChild('account_id',$listed_data[$i]['account_id']);
						$cam_list->addChild('campaignname',$listed_data[$i]['campaignname']);
						$cam_list->addChild('revenue_type', $listed_data[$i]['revenue_type']);
						$cam_list->addChild('country_value', $listed_data[$i]['country_value']);
						$cam_list->addChild('bidding_value', $listed_data[$i]['bidding_value']);
						$cam_list->addChild('status', $listed_data[$i]['status']);

						}
				print($xml->asXML());
				
			}			
		}
		
	}
	
	function zone_import_download_file()
	{
		
		$data = file_get_contents("./csv/upload/zonelimit_import.csv"); // Read the file's contents			
		$name = 'zonelimit_import.csv'; 
		force_download($name, $data);  
	}
	
	function zone_import_download_file_txt()
	{ 
		$data = file_get_contents("./csv/upload/zonelimit_import.txt"); // Read the file's contents			
		$name = 'zonelimit_import.txt';
		force_download($name, $data);    
	}
	function zone_import_download_file_xml()
	{ 
		$data = file_get_contents("./csv/upload/zonelimit_import.xml"); // Read the file's contents			
		$name = 'zonelimit_import.xml';
		force_download($name, $data);    
	}
	
	function download($zlimit_id=false,$format=false)
	{
		$zlid= rawurldecode($zlimit_id);  
		if($zlid!=false)
		{	
			//$export_list=$this->rest->get('api/v1/campaign/testing',array('campaignid'=>$campaignid,'api_key'=>get_session('api_key')),'php');
			
			$limit_list = 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array("zonelimit_id"=>$zlid,"api_key"=>get_session('api_key')),'json');
			
			$listed_data = json_decode($limit_list, true);		
				
			foreach($listed_data as $cam_id)
			{
			$cam[]=$cam_id['zoneids'];
			}	
			$imp=implode(',',$cam);
			$cmp_s= str_replace(",","_zid_",$imp);
			if($cmp_s)
			{
				$cmp_fn='zid_'.$cmp_s;
			}
			else
			{
				$cmp_fn='zid_'.$imp;
			}			
			if($format=="csv")
			{				
					$filename=$cmp_fn.'.csv';
					header('Content-type: text/csv');
					header('Content-Disposition: attachment; filename='.$filename);

					$csv = "Name,Type,Advertiser,Zone_ids\n";
					
					for($i=0;$i<count($listed_data);$i++){
						
						$csv.= $listed_data[$i]['name'].','.$listed_data[$i]['type'].','.$listed_data[$i]['clientname'].','.str_replace(",","_",$listed_data[$i]['zoneids'])."\n";
					}
					ob_end_clean();
					print_r($csv);  
			}
			else if($format =='txt')
			{
				//$listed_txt = array();
				$delimiter = "\t";
				$filename=$cmp_fn.'.txt';
				header('Content-type: text/tab-separated-values');
				header("Content-Disposition: attachment;filename=".$filename);	
				$listed_txt = "Name,Type,Advertiser,Zone_ids\n";							
				for($i=0;$i<count($listed_data);$i++)
				{
					$listed_txt.= $listed_data[$i]['name'].','.$listed_data[$i]['type'].','.$listed_data[$i]['clientname'].','.str_replace(",","_",$listed_data[$i]['zoneids'])."\n";
				}
				 ob_end_clean();				
				 print_r($listed_txt); 				
			}
			else if($format =='xml')
			{
				$filename=$cmp_fn.'.xml';
				header('Content-Type: text/xml');
				header("Content-Disposition: attachment;filename=".$filename);
				$xml = new SimpleXMLElement('<Admin/>');
				$xml->addAttribute("xmlns", "http://tempuri.org/ds.xsd");
				for($i=0;$i<count($listed_data);$i++)
				{
						$zonelimit_list = $xml->addChild("Zonelimitation");
						$zonelimit_list->addChild('Name',$listed_data[$i]['name']);
						$zonelimit_list->addChild('Type', $listed_data[$i]['type']);
						$zonelimit_list->addChild('Advertiser', $listed_data[$i]['clientname']);
						$zonelimit_list->addChild('Zone_ids', $listed_data[$i]['zoneids']);
						ob_end_clean();					
				}
				print($xml->asXML());
				
			}			
		}
		
	}
	
	function zonebidding_import_download_file()
	{ 		
		$data = file_get_contents("./csv/upload/zonebidding_import.csv"); // Read the file's contents			
		$name = 'zonebidding_import.csv';
		force_download($name, $data);  
	}
	
	function zonebidding_import_download_file_txt()
	{ 
		$data = file_get_contents("./csv/upload/zonebidding_import.txt"); // Read the file's contents			
		$name = 'zonebidding_import.txt';
		force_download($name, $data);    
	}
	function zonebidding_import_download_file_xml()
	{ 
		$data = file_get_contents("./csv/upload/zonebidding_import.xml"); // Read the file's contents			
		$name = 'zonebidding_import.xml';
		force_download($name, $data);      
	}
	function export_zonebidding_download($zone_bid_id=false,$format=false)
	{
									
		$zonebid_id= rawurldecode($zone_bid_id);  
							
		if($zonebid_id!=false)
		{	
			$zonebid_list = 	$this->rest->get('api/v1/countrywise_bidding/fetch_zonebidding_export_data',array("zone_bid_id"=>$zonebid_id,"api_key"=>get_session('api_key')),'json');
			
			$listed_data = json_decode($zonebid_list, true);
			
			if($format=="csv")
			{				
					$filename='zonebidding_list.csv';
					header('Content-type: text/csv');
					header('Content-Disposition: attachment; filename='.$filename);

					$csv = "account_id,campaignid,bidding_type,zone_id,bidrate,status\n";
					
					for($i=0;$i<count($listed_data);$i++){
						
						$csv.= $listed_data[$i]['account_id'].','.$listed_data[$i]['campaignid'].','.$listed_data[$i]['bidding_type'].','.$listed_data[$i]['zoneid'].','.$listed_data[$i]['bidrate'].','.$listed_data[$i]['status']."\n";   
					}
					ob_clean();
					print_r($csv);  
			}
			else if($format =='txt')
			{
				$listed_txt = array ();
				$delimiter = "\t";
				header('Content-type: text/tab-separated-values');
				header("Content-Disposition: attachment;filename=zonebidding_list.txt");	
				
				$txt = "account_id,campaignid,bidding_type,zone_id,bidrate,status\n";
				
											
				for($i=0;$i<count($listed_data);$i++)
				{
					
					$txt.= $listed_data[$i]['account_id'].','. $listed_data[$i]['campaignid'].','.$listed_data[$i]['bidding_type'].','.$listed_data[$i]['zoneid'].','.$listed_data[$i]['bidrate'].','.$listed_data[$i]['status']."\n";
				
				}	
					ob_clean();
					print_r($txt); 		
				
			}
			else if($format =='xml')
			{
				header('Content-Type: text/xml');
				header("Content-Disposition: attachment;filename=zonebidding_list.xml");
				$xml = new SimpleXMLElement('<zonebidding/>');
				$xml->addAttribute("xmlns", "http://tempuri.org/ds.xsd");
				for($i=0;$i<count($listed_data);$i++)
				{
						$cam_list = $xml->addChild("zonebidding");
						$cam_list->addChild('account_id',$listed_data[$i]['account_id']);
						$cam_list->addChild('campaignid',$listed_data[$i]['campaignid']);
						$cam_list->addChild('bidding_type',$listed_data[$i]['bidding_type']);
						$cam_list->addChild('zoneid', $listed_data[$i]['zoneid']);
						$cam_list->addChild('bidrate', $listed_data[$i]['bidrate']);
						$cam_list->addChild('status', $listed_data[$i]['status']);
						}
						ob_clean();
				print($xml->asXML());
				
			}	
		}
		
	}
	
}
