<?php 
class Messages extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		
		$this->load->helper('download');
		
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		//$this->load->model('api_v.1/do_creative','asd');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->message();		
	}
	
	/*
	 * 
	 * name		: Messages
	 * @param   : Null
	 * @return  : List all the messages for admin
	 */	
	 		public function edit_admin_adv_message()
	 {
		$this->session->unset_userdata('admin_edit_adv_notify_mass');
		$this->session->set_userdata('admin_edit_adv_notify_mass', $_POST['url_id']);
		echo json_encode($this->session->userdata('admin_edit_adv_notify_mass'));
	
	 }	
	public function message($acctype=false,$account_id=false)
	{	
		$account_id=$this->session->userdata('admin_edit_adv_notify_mass');
		$data['page_title'] 	= 	"Messages";	
		$data['breadcrumb'] 	= 	'';	
		
		// Write New message
		$data['acctype']		=	($acctype!=false)?$acctype:'';
		$data['account_id']		=	($account_id!=false)?$account_id:'';
		
		$data['users'] 	= 	$this->rest->get('api/v1/message/fetch_user',array('api_key'=>get_session('api_key')),'php');
		// Write New message
		
		$data['inbox'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'inbox','acctype'=>$data['acctype']),'php');
		
		//echo $this->rest->debug();exit;
		$data['sent'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'sent','acctype'=>$data['acctype']),'php');
		$data['trash'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'trash','acctype'=>$data['acctype']),'php');
		
		$data['content'] 		= 	$this->load->view('messages/messages',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: Messages
	 * @param   : Null
	 * @return  : List all the messages for admin
	 */	
	
	public function fetch_message($type=FALSE)
	{	

		$account_id  		=  	$this->rest->get('api/v1/message/fetch_receiever_id',array('api_key'=>get_session('api_key')),'php');
		
		$network_id 	=	$this->rest->get('api/v1/message/fetch_network_id',array('api_key'=>get_session('api_key')),'php');
		
		$message 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>$type),'json');

		#echo $this->rest->debug();exit;

		echo convert_to_datatable_format($message);
	}
	
	/*
	 * 
	 * name		: send_message
	 * @param   : Null
	 * @return  : Send new messages to advertiser/publisher
	 */	
	
	public function send_message($acctype=false,$account_id=false)
	{
		$data['acctype']		=	($acctype!=false)?$acctype:'';
		$data['account_id']		=	($account_id!=false)?$account_id:'';
		
		$data['users'] 	= 	$this->rest->get('api/v1/message/fetch_user',array('api_key'=>get_session('api_key')),'php');
		
		echo $this->load->view('messages/modal_messages/content/send_message',$data);		
	}
	
	/*
	 * 
	 * name		: read_message
	 * @param   : Null
	 * @return  : read messages
	 */	
	
	public function read_message($type=FALSE,$msg_id=FALSE)
	{		
		//$account_id  		=  	$this->rest->get('api/v1/message/fetch_receiever_id',array('api_key'=>get_session('api_key')),'php');
		//$network_id 	=	$this->rest->get('api/v1/message/fetch_network_id',array('api_key'=>get_session('api_key')),'php');
		
		$message 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_id'=>$msg_id,'message_type'=>$type),'php');
		
		$data['read']		=	$message[0];
		
		if($type=='inbox')
		{
			$this->rest->get('api/v1/message/update_message_status',array('api_key'=>get_session('api_key'),'message_id'=>$msg_id),'php');

			echo $this->load->view('messages/modal_messages/content/read_reply_message',$data);		
		}
		else
		{
			echo $this->load->view('messages/modal_messages/content/read_message',$data);		
		}
	}
	
	/*
	 * 
	 * name		: fetch_message_count
	 * @param   : Null
	 * @return  : count messages
	 */	
	
	public function fetch_message_count($type=FALSE)
	{	
		/*$account_id			=	get_session('account_id');
		$network_id			=	get_session('network_account_id');
		$account_type		=	get_session('account_type');*/
		
		$message 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>$type),'php');
		
		if($type=='inbox')
		{
			$inbox_count		=	0;
			if(!empty($message)):
				foreach($message as $msg):
					if($msg['status']==1)
					{
						$inbox_count	+=	1;
					}
				endforeach;
			endif;
			
			echo $inbox_count;
		}
		elseif($type=='sent')
		{	
			echo (!empty($message))?count($message):'0';		
		}
		else
		{
			echo '0';		
		}
	}
	
	/*
	 * 
	 * name		: download_file
	 * @param   : Null
	 * @return  : download image/file
	 */	
	
	public function download_file($file_name=0)
	{	
		$data 	= 	file_get_contents($this->config->item('message_path').'/'.$file_name); // Read the file's contents
		$name 	=	$file_name;
		force_download($name, $data);
	}
	
	/*
	 * 
	 * name		: read
	 * @param   : Null
	 * @return  : read messages
	 */	
	
	public function read($type=FALSE,$msg_id=FALSE)
	{	
		$data['inbox'] 		= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'inbox'),'php');
		$data['sent'] 		= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'sent'),'php');
		$data['trash'] 		= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'trash'),'php');
		
		$message 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>$type,'message_id'=>$msg_id),'php');
		
		$data['read']		=	$message[0];	
		
		$data['type']		=	$type;
		
		$data['msg_id']		=	$msg_id;
		
		if($type=='inbox')
		{
			$this->rest->get('api/v1/message/update_message_status',array('api_key'=>get_session('api_key'),'message_id'=>$msg_id),'php');
		}
		
		$data['users'] 	= 	$this->rest->get('api/v1/message/fetch_user',array('api_key'=>get_session('api_key')),'php');
		
		$data['content'] 		= 	$this->load->view('messages/messages',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
}
