<?php 
class Geo_settings extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->CPM_settings();		
	}
	
	/*
	 * 
	 * name		:CPM_settings
	 * @param   :Null
	 * @return  :List personal_information for Admin
	 * 		
	 */	
	public function CPM_settings()
	{
		$data['page_title'] = "CPM Geo Settings";	
		$data['breadcrumb'] = '';
		
		$data['country_list']		= $this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');	
		$data['content'] = $this->load->view('geo_settings/cpm_setting',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:fetch_geo_list
	 * @param   :Null
	 * @return  :List list of geo settings
	 * 		
	 */
	public function fetch_geo_list() 
	{
		$geo_sett		= $this->rest->get('api/v1/geo_settings/fetch',array('api_key'=>get_session('api_key')),'json');
		#$this->rest->debug();
		echo convert_to_datatable_format($geo_sett);
	}
	
	/*
	 * 
	 * name		: edit_geo
	 * @param   : Null
	 * @return  : List all the Category for admin
	 */	
	 	
	public function edit_geo($geo_id=FALSE)
	{	
		$sett_list					= $this->rest->get('api/v1/geo_settings/geo_data',array('api_key'=>get_session('api_key'),'geo_id'=>$geo_id),'php');
		$data['geo_val']			= $sett_list[0];
		$data['country_list']		= $this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');	
		
		echo $this->load->view('geo_settings/modal_geo/content/edit_geo',$data);
	}
	
}
