<?php 

class Careers extends CI_Controller

{

    function __construct()

	{

		parent::__construct();

		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!

		$this->load->library('rest');

		//$this->load->model('api_v.1/do_creative','asd');

		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));

	}



	function index()

	{

		$this->careers();
		#redirect('admin/managers/users/2');

	}






	
	/*
	 * 
	 * name: careers page
	 * @param : null
	 * @return :list of careers 
	 */	

	public function careers()
	{
		
		$data['page_title'] = "careers";
		$data['breadcrumb'] = '';
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
				//$this->rest->debug();exit;

		$data['content'] = $this->load->view('users/careers_list',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	
	
	
	/*

	 * 

	 * name		: add_careers

	 * @param   : Null

	 * @return  : Fetch modal box for add careers

	 */	

	 	

	public function add_careers()
	{	
		$data['page_title'] = "career";
		
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
		$data['category_list']		= $this->rest->get('api/v1/utilities/fetch_job_category',array('api_key'=>get_session('api_key')),'php');	
		$careers			=	$this->rest->get('api/v1/jobs/fetch_careers',array('api_key'=>get_session('api_key')),'json');

		$data['content'] 	= 	$this->load->view('users/add_careers',$data,TRUE);		
		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);

	}
	/*

	 * 

	 * name		: fetch_careers

	 * @param   : Null

	 * @return  : Fetch modal box for fetch careers

	 */	

	 	
	public function fetch_careers()
	{
			
		$careers			=	$this->rest->get('api/v1/jobs/fetch_careers',array('api_key'=>get_session('api_key')),'json');
			
		//$this->rest->debug();

		echo convert_to_datatable_format($careers);

	}

	 	
	/*

	 * 

	 * name		: edit_careers

	 * @param   : Null

	 * @return  : Fetch modal box for fetch careers

	 */	
	
public function edit_careers($id=FALSE)
	{	
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');	
		$careers_list=$this->rest->get('api/v1/jobs/careers_list',array('api_key'=>get_session('api_key'),'id'=>$id),'php');	
		$data['category_list']		= $this->rest->get('api/v1/utilities/fetch_job_category',array('api_key'=>get_session('api_key')),'php');
		$careers			=	$this->rest->get('api/v1/jobs/fetch_careers',array('api_key'=>get_session('api_key'),'id'=>$id),'php');		
		$data['careers_details']=$careers[0];
			
		$data['content'] 	= 	$this->load->view('users/edit_careers',$data,TRUE);			
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);   
	}	
	

}

